<?php
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Utils;

if (!function_exists('finanzia_widget_cms_theme_process_sticky_register_controls')) {
    add_action('etc_widget_cms_theme_process_sticky_register_controls', 'finanzia_widget_cms_theme_process_sticky_register_controls', 10, 1);
    function finanzia_widget_cms_theme_process_sticky_register_controls($widget)
    {
        // Layout
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'finanzia'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'finanzia' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_theme_process_sticky/layout/1.webp'
                        ],
                        '2' => [
                            'label' => esc_html__( 'Layout 2', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_theme_process_sticky/layout/2.webp'
                        ],
                        '3' => [
                            'label' => esc_html__( 'Layout 3', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_theme_process_sticky/layout/3.webp'
                        ]
                    ]
                ]
            );
        $widget->end_controls_section();
        // Process Section Start
        $widget->start_controls_section(
                'section_process',
                [
                    'label' => esc_html__('Process Content', 'finanzia'),
                    'tab'   => Controls_Manager::TAB_CONTENT
                ]
            );

            $process = new Repeater();
            // Banner
            $process->add_control(
                'banner',
                [
                    'label'   => esc_html__( 'Banner', 'finanzia' ),
                    'type'    => Controls_Manager::MEDIA,
                    'default' => [
                        'url' => Utils::get_placeholder_image_src()
                    ],
                    'label_block'   => false
                ]
            );
            // Icon
            finanzia_elementor_icon_image_settings($process,[
                'group' => false
            ]);
            // Title
            $process->add_control(
                'title',
                [
                    'label'       => esc_html__( 'Title', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'placeholder' => esc_html__( 'Process Title', 'finanzia' ),
                    'default'     => esc_html__( 'Process Title', 'finanzia' ),
                    'label_block' => true,
                ]
            );
            $process->add_control(
                'title2',
                [
                    'label'       => esc_html__( 'Title #2', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'placeholder' => '',
                    'default'     => '',
                    'label_block' => true,
                ]
            );
            // Description
            $process->add_control(
                'desc',
                [
                    'label'       => esc_html__( 'Description', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA
                ]
            );
            // Lists
            $widget->add_control(
                'process_list',
                [
                    'label'   => esc_html__('Process List', 'finanzia'),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $process->get_controls(),
                    'default' => [
                        [
                            'title' => 'Process title #1',
                            'desc' => 'Neque porro quisquam est qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit'
                        ],
                        [
                            'title' => 'Process title #2',
                            'desc' => 'There is no one who loves pain itself, who seeks after it and wants to have it, simply because it is pain'
                        ],
                        [
                            'title' => 'Process title #3',
                            'desc' => 'Cras rutrum varius accumsan. Aenean ut ligula at libero viverra sodales. Vestibulum nec viverra metus'
                        ],
                    ],
                    'title_field' => '{{{ title }}}'
                ]
            );
            // Style
            $widget->add_control(
                'align',
                [
                    'label'        => esc_html__( 'Alignment', 'finanzia' ),
                    'type'         => Controls_Manager::CHOOSE,
                    'options'      => [
                        'start'    => [
                            'title' => esc_html__( 'Left', 'finanzia' ),
                            'icon'  => 'eicon-text-align-left',
                        ],
                        'center'  => [
                            'title' => esc_html__( 'Center', 'finanzia' ),
                            'icon'  => 'eicon-text-align-center',
                        ],
                        'end'   => [
                            'title' => esc_html__( 'Right', 'finanzia' ),
                            'icon'  => 'eicon-text-align-right',
                        ],
                        'justify' => [
                            'title' => esc_html__( 'Justified', 'finanzia' ),
                            'icon' => 'eicon-text-align-justify',
                        ]
                    ]
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'ptitle_color',
                'label'     => esc_html__( 'Title Color', 'finanzia' )
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'ptitle2_color',
                'label'     => esc_html__( 'Title #2 Color', 'finanzia' )
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'pdesc_color',
                'label'     => esc_html__( 'Desc Color', 'finanzia' )
            ]);
        $widget->end_controls_section();
        // Style Settings
        $widget->start_controls_section(
            'style_section',
            [
                'label'     => esc_html__('Offset Settings', 'finanzia'),
                'tab'       => Controls_Manager::TAB_SETTINGS,
                'condition' => [
                    'layout' => ['1']
                ]
            ]
        );
            $widget->add_responsive_control(
                'offset_top',
                [
                    'label'      => esc_html__('Space with Above Section','finanzia'),
                    'type'       => Controls_Manager::SLIDER,
                    'size_units' => [ 'px'],
                    'range'      => [
                        'px' => [
                            'min'  => 0, 
                            'max'  => 300,
                            'step' => 1
                        ]
                    ],
                    'selectors'    => [
                        '{{WRAPPER}}' => 'margin-block-start: calc(calc(100vh - {{SIZE}}{{UNIT}})*-1);',
                    ]
                ]
            );
            $widget->add_responsive_control(
                'offset_bottom',
                [
                    'label'      => esc_html__('Space with Below Section','finanzia'),
                    'type'       => Controls_Manager::SLIDER,
                    'size_units' => [ 'px'],
                    'range'      => [
                        'px' => [
                            'min'  => 0, 
                            'max'  => 300,
                            'step' => 1
                        ]
                    ],
                    'selectors'    => [
                        '{{WRAPPER}}' => 'margin-block-end: calc(calc(100vh - {{SIZE}}{{UNIT}})*-1);',
                    ]
                ]
            );
        $widget->end_controls_section();
    }
}
