<?php
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;

if (!function_exists('finanzia_widget_cms_theme_process_scroll_register_controls')) {
    add_action('etc_widget_cms_theme_process_scroll_register_controls', 'finanzia_widget_cms_theme_process_scroll_register_controls', 10, 1);
    function finanzia_widget_cms_theme_process_scroll_register_controls($widget)
    {
        // Layout
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'finanzia'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'finanzia' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_theme_process_scroll/layout/1.webp'
                        ]
                    ]
                ]
            );
        $widget->end_controls_section();
        // Heading Section Start
        $widget->start_controls_section(
            'section_heading',
            [
                'label' => esc_html__('Heading Content', 'finanzia'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
            $widget->add_control(
                'smallheading_text',
                [
                    'label'       => esc_html__( 'Small Heading', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => '',
                    'placeholder' => esc_html__( 'Enter your text', 'finanzia' ),
                    'label_block' => true
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'smallheading_color',
                'label'     => esc_html__( 'Color', 'finanzia' ),
                'condition' => [
                    'smallheading_text!' => ''
                ]
            ]);
            // Heading
            $widget->add_control(
                'heading_text',
                [
                    'label'       => esc_html__( 'Heading', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'This is the heading',
                    'placeholder' => esc_html__( 'Enter your text', 'finanzia' ),
                    'label_block' => true
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'heading_color',
                'label'    => esc_html__( 'Color', 'finanzia' ),
                'custom'   => false, 
                'condition' => [
                    'heading_text!' => ''
                ]
            ]);
            // Description
            $widget->add_control(
                'desc',
                [
                    'label'       => esc_html__( 'Description', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour', 
                    'placeholder' => esc_html__( 'Enter your text', 'finanzia' ),
                    'rows'        => 10,
                    'show_label'  => true
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'      => 'desc_color',
                'label'     => esc_html__( 'Color', 'finanzia' ),
                'custom'    => false,
                'condition' => [
                    'desc!' => ''
                ]
            ]);
            // Button #1
            finanzia_elementor_link_settings($widget, [
                'name'        => 'link1_',
                'mode'        => 'btn',
                'group'       => false,
                'label'       => esc_html__('Button #1 Settings', 'finanzia'),
                'color_label' => esc_html__('Button', 'finanzia')
            ]);
        $widget->end_controls_section();
        // Process Section Start
        $widget->start_controls_section(
                'section_process',
                [
                    'label' => esc_html__('Process Content', 'finanzia'),
                    'tab'   => Controls_Manager::TAB_CONTENT
                ]
            );
            $process2 = new Repeater();
            // Icon
            finanzia_elementor_icon_image_settings($process2, [
                'group'            => false,
                'img_default_size' => 'custom',
                'skin'             => 'inline'
            ]);
            // Title
            $process2->add_control(
                'title',
                [
                    'label'       => esc_html__( 'Title', 'finanzia' ),
                    'type'        => Controls_Manager::TEXT,
                    'placeholder' => esc_html__( 'Enter your title', 'finanzia' ),
                    'default'     => esc_html__( 'My Skill', 'finanzia' ),
                    'label_block' => true,
                ]
            );
            // Description
            $process2->add_control(
                'desc',
                [
                    'label'       => esc_html__( 'Description', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA
                ]
            );
            // Banner
            $process2->add_control(
                'banner',
                [
                    'label'       => esc_html__('Banner', 'finanzia'),
                    'type'        => Controls_Manager::MEDIA,
                    'description' => esc_html__('Select image.', 'finanzia'),
                    'default' => [
                        'url' => Utils::get_placeholder_image_src()
                    ]
                ]
            );
            $widget->add_control(
                'process_list2',
                [
                    'label'   => esc_html__('Process List', 'finanzia'),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $process2->get_controls(),
                    'default' => [
                        [
                            'title' => 'Acknowledge needs and objectives',
                            'desc'  => 'We prepare for your meeting by identifying key milestones or events that have happened since we last met. Then we review your portfolios to see if they’re well positioned to meet',
                        ],
                        [
                            'title' => 'Provide a comprehensive long term perspective',
                            'desc'  => 'We ascertain our client’s financial outlook to determine whether they should seek investments weighted toward preservation of capital, a balance of income and appreciation, or growth.',
                        ],
                        [
                            'title' => 'Establish confidence and discuss opportunities',
                            'desc'  => 'We will provide unique recommendationa in sensible investment choices that will help our clients meet their long term goals or fund their retirement income needs.',
                        ],
                    ],
                    'title_field' => '{{{ title }}}'
                ]
            );
        $widget->end_controls_section();
    }
}
