<?php
use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!function_exists('finanzia_widget_cms_theme_counter_sticky_register_controls')) {
    add_action('etc_widget_cms_theme_counter_sticky_register_controls', 'finanzia_widget_cms_theme_counter_sticky_register_controls', 10, 1);
    function finanzia_widget_cms_theme_counter_sticky_register_controls($widget)
    {
        // Layout
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'finanzia'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_responsive_control(
                'offset_top',
                [
                    'label'     => esc_html__( 'Stikcy Offset Top', 'finanzia' ),
                    'type'      => Controls_Manager::NUMBER,
                    'default'   => ''
                ]
            );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'finanzia' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_theme_counter_sticky/layout/1.webp'
                        ]
                    ]
                ]
            );
        $widget->end_controls_section();
        // Reapeater Counter
        $widget->start_controls_section(
            'section_counters',
            [
                'label' => esc_html__('Counters Settings', 'finanzia'),
                'tab'   => Controls_Manager::TAB_CONTENT
            ]
        );
            $counters = new Repeater();
                $counters->add_control(
                    'starting_number',
                    [
                        'label'   => esc_html__( 'Starting Number', 'finanzia' ),
                        'type'    => Controls_Manager::NUMBER,
                        'default' => 1,
                    ]
                );
                $counters->add_control(
                    'ending_number',
                    [
                        'label'   => esc_html__( 'Ending Number', 'finanzia' ),
                        'type'    => Controls_Manager::NUMBER,
                        'default' => 100,
                    ]
                );
                $counters->add_control(
                    'prefix',
                    [
                        'label'       => esc_html__( 'Number Prefix', 'finanzia' ),
                        'type'        => Controls_Manager::TEXT,
                        'default'     => '',
                        'placeholder' => '1',
                    ]
                );
                $counters->add_control(
                    'suffix',
                    [
                        'label'       => esc_html__( 'Number Suffix', 'finanzia' ),
                        'type'        => Controls_Manager::TEXT,
                        'default'     => '',
                        'placeholder' => '+',
                    ]
                );
                $counters->add_control(
                    'duration',
                    [
                        'label'   => esc_html__( 'Animation Duration', 'finanzia' ),
                        'type'    => Controls_Manager::NUMBER,
                        'default' => 3000,
                        'min'     => 100,
                        'step'    => 100,
                    ]
                );
                $counters->add_control(
                    'thousand_separator_char',
                    [
                        'label'     => esc_html__( 'Separator', 'finanzia' ),
                        'type'      => Controls_Manager::SELECT,
                        'options'   => [
                            ''  => 'Default',
                            ',' => 'Comma',
                            '.' => 'Dot',
                            ' ' => 'Space',
                        ],
                        'default'   => '',
                    ]
                );
                finanzia_elementor_icon_image_settings($counters, [
                    'group'            => false,
                    'name'             => 'counter_icon',
                    'type'             => 'icon',
                    // icon
                    'icon_default'     => [],
                    //image
                    'img_default_size' => 'custom',
                    'separator'        => 'before'
                ]);
                $counters->add_control(
                    'title',
                    [
                        'label'       => esc_html__( 'Title', 'finanzia' ),
                        'type'        => Controls_Manager::TEXTAREA,
                        'label_block' => true,
                        'default'     => 'Counter',
                        'placeholder' => esc_html__( 'Enter your Title', 'finanzia' ),
                    ]
                );
                $counters->add_control(
                    'description',
                    [
                        'label'       => esc_html__( 'Description', 'finanzia' ),
                        'type'        => Controls_Manager::TEXTAREA,
                        'label_block' => true,
                        'default'     => 'Turpis massa tincidunt dui ut. Sit amet nisl purus in mollis nunc. Id neque aliquam vestibulum morbi blandit cursus risus',
                        'placeholder' => esc_html__( 'Enter your text', 'finanzia' )
                    ]
                );
                // Link #1
                finanzia_elementor_link_settings($counters, [
                    'name'    => 'link1_',
                    'group'   => false,
                    'color'   => false,  
                    'type' => [
                        'cms-service'  => esc_html__('Service', 'finanzia'),
                        'cms-industry' => esc_html__('Industry', 'finanzia')
                    ]
                ]);
            // add counter item
            $widget->add_control(
                'counters',
                [
                    'label'  => esc_html__('Counters List', 'finanzia'),
                    'type'   => Controls_Manager::REPEATER,
                    'fields' => $counters->get_controls(),
                    'default' => [
                        [
                            'starting_number' => '1',
                            'ending_number'   => '300',
                            'prefix'          => '',
                            'suffix'          => 'K',
                            'title'           => 'Counter Title #1',
                        ],
                        [
                            'starting_number' => '1',
                            'ending_number'   => '99',
                            'prefix'          => '',
                            'suffix'          => '%',
                            'title'           => 'Counter Title #2',
                        ]
                    ],
                    'title_field' => '{{{ title }}}'
                ]
            );
        $widget->end_controls_section();
        // Style Section Start
        $widget->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Style Settings', 'finanzia'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );  
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'number_color',
                'label'    => esc_html__( 'Number Color', 'finanzia' )
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'icon_color',
                'label'    => esc_html__( 'Icon Color', 'finanzia' )
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'title_color',
                'label'    => esc_html__( 'Title Color', 'finanzia' )
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'desc_color',
                'label'    => esc_html__( 'Description Color', 'finanzia' )
            ]);
        $widget->end_controls_section();
    }
}
