<?php
use Elementor\Controls_Manager;
use Elementor\Repeater;
if (!function_exists('finanzia_widget_cms_theme_accordion_sticky_register_controls')) {
    add_action('etc_widget_cms_theme_accordion_sticky_register_controls', 'finanzia_widget_cms_theme_accordion_sticky_register_controls', 10, 1);
    function finanzia_widget_cms_theme_accordion_sticky_register_controls($widget)
    {
        // Layout Section Start 
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'finanzia'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'finanzia' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_theme_accordion_sticky/layout/1.webp'
                        ],
                        '2' => [
                            'label' => esc_html__( 'Layout 2', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_theme_accordion_sticky/layout/2.webp'
                        ]
                    ]
                ]
            );
        $widget->end_controls_section();
        $widget->start_controls_section(
            'section_heading',
            [
                'label' => esc_html__('Heading Settings', 'finanzia'),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout' => ['2']
                ]
            ]
        );
            $widget->add_control(
                'smallheading_text',
                [
                    'label'       => esc_html__( 'Small Heading', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => '',
                    'placeholder' => esc_html__( 'Enter your text', 'finanzia' ),
                    'label_block' => true
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'      => 'smallheading_color',
                'label'     => esc_html__( 'Color', 'finanzia' ),
                'condition' => [
                    'smallheading_text!' => ''
                ]
            ]);
            $widget->add_control(
                'heading_text',
                [
                    'label'       => esc_html__( 'Heading', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'This is the heading',
                    'placeholder' => esc_html__( 'Enter your text', 'finanzia' ),
                    'label_block' => true
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'heading_color',
                'label'    => esc_html__( 'Color', 'finanzia' ),
                'condition' => [
                    'heading_text!' => ''
                ]
            ]);
        $widget->end_controls_section();
        // accordion Section Start
        $widget->start_controls_section(
            'section_cms_theme_accordion_sticky',
            [
                'label' => esc_html__('Accordion Settings', 'finanzia'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
            // Layout 1
            $repeater = new Repeater();
            $repeater->add_control(
                'ac_title',
                [
                    'label'       => esc_html__( 'Item Title', 'finanzia' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => 'Title',
                    'placeholder' => esc_html__( 'Enter your title', 'finanzia' ),
                    'label_block' => true,
                ]
            );
            $repeater->add_control(
                'ac_content',
                [
                    'label'       => esc_html__( 'Content Title #1', 'finanzia' ),
                    'type'        => \Elementor\Controls_Manager::TEXTAREA,
                    'default'     => 'Nulla hendrerit elementum leo, eu posuere orci pharetra eu. Nunc orci lorem, eleifend non pretium.',
                    'placeholder' => esc_html__( 'Enter your content', 'finanzia' ),
                    'label_block' => true,
                ]
            );
            $repeater->add_control(
                'ac_content2',
                [
                    'label'       => esc_html__( 'Content Desc #2', 'finanzia' ),
                    'type'        => \Elementor\Controls_Manager::TEXTAREA,
                    'default'     => 'Aenean tincidunt lorem aliquam vestibulum commodo. Morbi quis hendrerit purus. Fusce porttitor varius quam nec',
                    'placeholder' => esc_html__( 'Enter your content', 'finanzia' ),
                    'label_block' => true,
                ]
            );
            finanzia_elementor_colors_opts($repeater,[
                'name'     => 'ac_border_color',
                'label'    => esc_html__( 'Border Color', 'finanzia' )
            ]);
            $widget->add_control(
                'contents',
                [
                    'label' => esc_html__('Accordion Lists', 'finanzia'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $repeater->get_controls(),
                    'default' => [
                        [
                            'ac_title'    => 'Title #1',
                            'ac_content'  => 'Nulla hendrerit elementum leo, eu posuere orci pharetra eu. Nunc orci lorem, eleifend non pretium.',
                            'ac_content2' => 'Aenean tincidunt lorem aliquam vestibulum commodo. Morbi quis hendrerit purus. Fusce porttitor varius quam nec',
                            'ac_border_color' => 'purple'
                        ],
                        [
                            'ac_title'    => 'Title #2',
                            'ac_content'  => 'Nulla hendrerit elementum leo, eu posuere orci pharetra eu. Nunc orci lorem, eleifend non pretium.',
                            'ac_content2' => 'Aenean tincidunt lorem aliquam vestibulum commodo. Morbi quis hendrerit purus. Fusce porttitor varius quam nec',
                            'ac_border_color' => 'green'
                        ],
                        [
                            'ac_title'    => 'Title #3',
                            'ac_content'  => 'Nulla hendrerit elementum leo, eu posuere orci pharetra eu. Nunc orci lorem, eleifend non pretium.',
                            'ac_content2' => 'Aenean tincidunt lorem aliquam vestibulum commodo. Morbi quis hendrerit purus. Fusce porttitor varius quam nec',
                            'ac_border_color' => 'primary-lighten'
                        ]
                    ],
                    'title_field' => '{{{ ac_title }}}',
                    'condition' => [
                        'layout' => ['1']
                    ]
                ]
            );
            // Layout 2
            $repeater2 = new Repeater();
            $repeater2->add_control(
                'ac_title',
                [
                    'label'       => esc_html__( 'Item Title', 'finanzia' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => 'Title',
                    'placeholder' => esc_html__( 'Enter your title', 'finanzia' ),
                    'label_block' => true,
                ]
            );
            finanzia_elementor_icon_image_settings($repeater2, [
                'group'     => false
            ]);
            $repeater2->add_control(
                'ac_content',
                [
                    'label'       => esc_html__( 'Content Title #1', 'finanzia' ),
                    'type'        => \Elementor\Controls_Manager::TEXTAREA,
                    'default'     => 'Nulla hendrerit elementum leo, eu posuere orci pharetra eu. Nunc orci lorem, eleifend non pretium.',
                    'placeholder' => esc_html__( 'Enter your content', 'finanzia' ),
                    'label_block' => true,
                ]
            );
            $repeater2->add_control(
                'ac_content2',
                [
                    'label'       => esc_html__( 'Content Desc #2', 'finanzia' ),
                    'type'        => \Elementor\Controls_Manager::TEXTAREA,
                    'default'     => 'Aenean tincidunt lorem aliquam vestibulum commodo. Morbi quis hendrerit purus. Fusce porttitor varius quam nec',
                    'placeholder' => esc_html__( 'Enter your content', 'finanzia' ),
                    'label_block' => true,
                ]
            );
            $widget->add_control(
                'contents_2',
                [
                    'label'   => esc_html__('Accordion Lists', 'finanzia'),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $repeater2->get_controls(),
                    'default' => [
                        [
                            'ac_title'    => 'Title #1',
                            'ac_content'  => 'Nulla hendrerit elementum leo, eu posuere orci pharetra eu. Nunc orci lorem, eleifend non pretium.',
                            'ac_content2' => 'Aenean tincidunt lorem aliquam vestibulum commodo. Morbi quis hendrerit purus. Fusce porttitor varius quam nec',
                        ],
                        [
                            'ac_title'    => 'Title #2',
                            'ac_content'  => 'Nulla hendrerit elementum leo, eu posuere orci pharetra eu. Nunc orci lorem, eleifend non pretium.',
                            'ac_content2' => 'Aenean tincidunt lorem aliquam vestibulum commodo. Morbi quis hendrerit purus. Fusce porttitor varius quam nec',
                        ],
                        [
                            'ac_title'    => 'Title #3',
                            'ac_content'  => 'Nulla hendrerit elementum leo, eu posuere orci pharetra eu. Nunc orci lorem, eleifend non pretium.',
                            'ac_content2' => 'Aenean tincidunt lorem aliquam vestibulum commodo. Morbi quis hendrerit purus. Fusce porttitor varius quam nec',
                        ]
                    ],
                    'title_field' => '{{{ ac_title }}}',
                    'condition' => [
                        'layout' => ['2']
                    ]
                ]
            );
        $widget->end_controls_section();
    }
}
