<?php
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Repeater;
if (!function_exists('finanzia_widget_cms_slider_register_controls')) {
    add_action('etc_widget_cms_slider_register_controls', 'finanzia_widget_cms_slider_register_controls', 10, 1);
    function finanzia_widget_cms_slider_register_controls($widget)
    {
        // Layout Tab Start
        $widget->start_controls_section('layout_section', [
            'label' => esc_html__('Layout', 'finanzia'),
            'tab' => Controls_Manager::TAB_LAYOUT,
        ]);
            $widget->add_control('header_transparent', [
                'label'              => esc_html__('Header Transparent', 'finanzia'),
                'type'               => Controls_Manager::SWITCHER,
                'default'            => '',
                'prefix_class'       => 'cms-eslider-header-transparent-',
                'description'        => esc_html__('Make arrows alignment middle when have Header Transparent','finanzia'),  
            ]);
            $widget->add_control('layout', [
                'label'   => esc_html__('Templates', 'finanzia'),
                'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                'default' => '1',
                'options' => [
                    '1' => [
                        'label' => esc_html__('Layout 1', 'finanzia'),
                        'image' => get_template_directory_uri().'/elementor/templates/widgets/cms_slider/layout/1.webp',
                    ],
                    '2' => [
                        'label' => esc_html__('Layout 2', 'finanzia'),
                        'image' => get_template_directory_uri().'/elementor/templates/widgets/cms_slider/layout/2.webp',
                    ],
                    '3' => [
                        'label' => esc_html__('Layout 3', 'finanzia'),
                        'image' => get_template_directory_uri().'/elementor/templates/widgets/cms_slider/layout/3.webp',
                    ],
                    '4' => [
                        'label' => esc_html__('Layout 4', 'finanzia'),
                        'image' => get_template_directory_uri().'/elementor/templates/widgets/cms_slider/layout/4.webp',
                    ],
                    '5' => [
                        'label' => esc_html__('Layout 5', 'finanzia'),
                        'image' => get_template_directory_uri().'/elementor/templates/widgets/cms_slider/layout/5.webp',
                    ],
                    '6' => [
                        'label' => esc_html__('Layout 6', 'finanzia'),
                        'image' => get_template_directory_uri().'/elementor/templates/widgets/cms_slider/layout/6.webp',
                    ]
                ]
            ]);
        $widget->end_controls_section();

        // Slider List Section Start
        $widget->start_controls_section('slider_list_section', [
            'label' => esc_html__('Slider List', 'finanzia'),
            'tab' => Controls_Manager::TAB_CONTENT,
        ]);

            $repeater = new Repeater();
            finanzia_elementor_icon_image_settings($repeater, [
                'group'     => false
            ]);
            $repeater->add_control(
                'image',
                [
                    'label'       => esc_html__('Main Image', 'finanzia'),
                    'type'        => Controls_Manager::MEDIA,
                    'label_block' => false,
                    'default'     => [
                        'url' => Utils::get_placeholder_image_src(),
                    ]
                ]
            );
            $repeater->add_control(
                'subtitle',
                [
                    'label'       => esc_html__('Small Title', 'finanzia'),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => esc_html__('This is the subtitle', 'finanzia'),
                    'placeholder' => esc_html__('Enter your subtitle', 'finanzia'),
                    'label_block' => true
                ]
            );
            $repeater->add_control(
                'title',
                [
                    'label'       => esc_html__('Title', 'finanzia'),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => esc_html__('This is the title', 'finanzia'),
                    'placeholder' => esc_html__('Enter your title', 'finanzia'),
                    'label_block' => true,
                ]
            );
            $repeater->add_control(
                'description',
                [
                    'label'       => esc_html__('Description', 'finanzia'),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => esc_html__('This is the description', 'finanzia'),
                    'placeholder' => esc_html__('Enter your description', 'finanzia'),
                    'label_block' => true,
                ]
            );
            $repeater->add_control(
                'button_primary',
                [
                    'label'       => esc_html__('Button Primary', 'finanzia'),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => esc_html__('Button Primary', 'finanzia'),
                    'label_block' => true,
                ]
            );
            $repeater->add_control(
                'button_primary_type',
                [
                    'label'   => esc_html__('Link Type', 'finanzia'),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'custom' => esc_html__('Custom', 'finanzia'),
                        'page'   => esc_html__('Page', 'finanzia'),
                    ],
                    'default' => 'custom',
                    'condition' => [
                        'button_primary!' => ''
                    ]
                ]
            );
            $repeater->add_control(
                'button_primary_page_link',
                [
                    'label'   => esc_html__('Select Page', 'finanzia'),
                    'type'    => Elementor_Theme_Core::POSTS_CONTROL,
                    'post_type' => [
                        'page'
                    ],
                    'multiple'     => false,
                    'return_value' => 'ID',
                    'label_block'  => true,
                    'condition'   => [
                        'button_primary!'     => '',
                        'button_primary_type' => 'page'
                    ]
                ]
            );
            $repeater->add_control(
                'button_primary_link',
                [
                    'label'       => esc_html__( 'Custom Link', 'finanzia' ),
                    'type'        => Controls_Manager::URL,
                    'placeholder' => esc_html__( 'https://your-link.com', 'finanzia' ),
                    'default'     => [
                        'url' => '#',
                    ],
                    'condition' => [
                        'button_primary!'     => '',
                        'button_primary_type' => 'custom'
                    ]
                ]
            );
            // Button Secondary 
            $repeater->add_control(
                'button_secondary',
                [
                    'label'       => esc_html__('Button Secondary', 'finanzia'),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => esc_html__('Button Secondary', 'finanzia'),
                    'label_block' => true,
                ]
            );
            $repeater->add_control(
                'button_secondary_type',
                [
                    'label'   => esc_html__('Link Type', 'finanzia'),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'custom' => esc_html__('Custom', 'finanzia'),
                        'page'   => esc_html__('Page', 'finanzia'),
                    ],
                    'default' => 'custom',
                    'condition' => [
                        'button_secondary!' => ''
                    ]
                ]
            );
            $repeater->add_control(
                'button_secondary_page_link',
                [
                    'label'   => esc_html__('Select Page', 'finanzia'),
                    'type'    => Elementor_Theme_Core::POSTS_CONTROL,
                    'post_type' => [
                        'page'
                    ],
                    'return_value' => 'ID',
                    'multiple'     => false,
                    'label_block'  => true,
                    'condition'   => [
                        'button_secondary!'     => '',
                        'button_secondary_type' => 'page'
                    ]
                ]
            );
            $repeater->add_control(
                'button_secondary_link',
                [
                    'label'       => esc_html__( 'Custom Link', 'finanzia' ),
                    'type'        => Controls_Manager::URL,
                    'placeholder' => esc_html__( 'https://your-link.com', 'finanzia' ),
                    'default'     => [
                        'url' => '#',
                    ],
                    'condition' => [
                        'button_secondary!'     => '',
                        'button_secondary_type' => 'custom'
                    ]
                ]
            );
            // Video Button
            $repeater->add_control(
                'video_link',
                [
                    'label'       => esc_html__( 'Button Video', 'finanzia' ),
                    'description' => esc_html__('Video url from  YouTube/Vimeo/Dailymotion.','finanzia').' EX: https://www.youtube.com/watch?v=iYf3OgEdGmo',
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => '',
                    'dynamic'     => [
                        'active' => true
                    ],
                    'label_block' => true,
                    'frontend_available' => true,
                ]
            );
            $repeater->add_control(
                'video_text',
                [
                    'label'       => '',
                    'description' => esc_html__('Text beside play icon','finanzia'),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'How it works',
                    'condition'   => [
                        'video_link!' => ''
                    ],
                    'label_block' => true
                ]
            );
            // Start List
            $widget->add_control(
                'cms_slides',
                [
                    'label' => esc_html__('Slides', 'finanzia'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $repeater->get_controls(),
                    'default' => [
                        [
                            'image' => [
                                'url' => Utils::get_placeholder_image_src(),
                            ],
                            'title'       => 'This is Slider Title',
                            'subtitle'    => '',
                            'description' => 'This is slider description. Lorem Ipsum is simply dummy text of the printing and typesetting story.',
                        ],
                        [
                            'image' => [
                                'url' => Utils::get_placeholder_image_src(),
                            ],
                            'title'       => 'This is Slider Title',
                            'subtitle'    => '',
                            'description' => 'This is slider description. Lorem Ipsum is simply dummy text of the printing and typesetting story.',
                        ],
                    ],
                    'title_field' => '{{{ title }}}',
                ]
            );
        $widget->end_controls_section();
        // Static Layer
        $widget->start_controls_section(
            'static_layer',
            [
                'label'     => esc_html__('Static Content', 'finanzia'),
                'tab'       => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout' => ['1','2','6']
                ]
            ]
        );
            finanzia_elementor_icon_image_settings($widget, [
                'group'        => false,
                'name'         => 'static_icon', 
                'icon_default' => [
                    'library' => 'svg',
                    'value'   => [
                        'url' => get_template_directory().'/assets/svgs/core/star.svg'
                    ]
                ]
            ]);
            $widget->add_control(
                'static_title',
                [
                    'label'       => esc_html__('Title', 'finanzia'),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'Your Title',
                    'placeholder' => esc_html__('Enter your Title', 'finanzia'),
                    'label_block' => false
                ]
            );
            // Link #1
            finanzia_elementor_link_settings($widget, [
                'name'        => 'link1_',
                'mode'        => '',
                'group'       => false,
                'label'       => esc_html__('Link Settings', 'finanzia'),
                'condition'   => [
                    'layout' => ['2']
                ],
                'separator' => 'after'
            ]);
            finanzia_add_hidden_device_controls($widget, [
                'prefix'    => 'static_'
            ]);
        $widget->end_controls_section();
        // General Style Section Start
        $widget->start_controls_section(
            'general_style_section',
            [
                'label' => esc_html__('General', 'finanzia'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );  
            $widget->add_control('overlay_style', [
                'label'   => esc_html__('Overlay Style', 'finanzia'),
                'type'    => Controls_Manager::SELECT,
                'options' => finanzia_elementor_gradient_opts(),
                'default' => 'dark-above-img2'
            ]);
            $widget->add_responsive_control(
                'content_width',
                [
                    'label' => esc_html__('Content Width', 'finanzia'),
                    'type'  => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%'],
                    'range' => [
                        'px' => [
                            'min'  => 300, 
                            'max'  => 1280,
                            'step' => 5
                        ],
                        '%' => [
                            'min'  => 10, 
                            'max'  => 100,
                            'step' => 1
                        ]
                    ],
                    'selectors'    => [
                        '{{WRAPPER}} .cms-slider--content' => 'max-width: {{SIZE}}{{UNIT}};',
                    ]
                ]
            );
        $widget->end_controls_section();
        // Subtitle Style Section Start
        $widget->start_controls_section(
            'subtitle_style_section',
            [
                'label' => esc_html__('Subtitle', 'finanzia'),
                'tab'   => Controls_Manager::TAB_STYLE

            ]
        );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'subtitle_color',
                'label'     => esc_html__( 'Color', 'finanzia' ),
                'selector' => [
                    '{{WRAPPER}} .cms-slider-subtitle' => 'color: {{VALUE}};',
                ]
            ]);
            $widget->add_control(
                'subtitle_animation',
                [
                    'label'              => esc_html__('Animation', 'finanzia'),
                    'type'               => Controls_Manager::ANIMATION,
                    'default'            => 'fadeInLeft',
                    'frontend_available' => true,
                ]
            );
            $widget->add_control(
                'subtitle_animation_delay',
                [
                    'label'              => esc_html__('Animation Delay', 'finanzia'),
                    'type'               => Controls_Manager::NUMBER,
                    'min'                => 50,
                    'step'               => 50,
                    'default'            => 500,
                    'frontend_available' => true,
                ]
            );
            finanzia_add_hidden_device_controls($widget, ['prefix' => 'subtitle_']);
        $widget->end_controls_section();
        // Title Style Section Start
        $widget->start_controls_section(
            'title_style_section',
            [
                'label' => esc_html__('Title', 'finanzia'),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'title_color',
                'label'     => esc_html__( 'Color', 'finanzia' ),
                'selector' => [
                    '{{WRAPPER}} .cms-slider-title' => 'color: {{VALUE}};',
                ]
            ]);
            $widget->add_control(
                'title_animation',
                [
                    'label'              => esc_html__('Animation', 'finanzia'),
                    'type'               => Controls_Manager::ANIMATION,
                    'default'            => 'fadeInLeft',
                    'frontend_available' => true,
                ]
            );
            $widget->add_control(
                'title_animation_delay',
                [
                    'label'              => esc_html__('Animation Delay', 'finanzia'),
                    'type'               => Controls_Manager::NUMBER,
                    'min'                => 50,
                    'step'               => 50,
                    'default'            => 600,
                    'frontend_available' => true,
                ]
            );
            finanzia_add_hidden_device_controls($widget, ['prefix' => 'title_']);
        $widget->end_controls_section();
        // Description Style Section Start
        $widget->start_controls_section(
            'description_style_section',
            [
                'label' => esc_html__('Description', 'finanzia'),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'desc_color',
                'label'     => esc_html__( 'Color', 'finanzia' ),
                'selector' => [
                    '{{WRAPPER}} .cms-slider-desc' => 'color: {{VALUE}};',
                ]
            ]);
            $widget->add_responsive_control(
                'desc_width',
                [
                    'label' => esc_html__('Width', 'finanzia'),
                    'type'  => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min'  => 300, 
                            'max'  => 1280,
                            'step' => 5
                        ]
                    ],
                    'selectors'    => [
                        '{{WRAPPER}} .cms-slider-desc' => 'max-width: {{SIZE}}{{UNIT}};',
                    ]
                ]
            );
            $widget->add_control(
                'description_animation',
                [
                    'label'              => esc_html__('Animation', 'finanzia'),
                    'type'               => Controls_Manager::ANIMATION,
                    'default'            => 'fadeInLeft',
                    'frontend_available' => true,
                ]
            );

            $widget->add_control(
                'description_animation_delay',
                [
                    'label'              => esc_html__('Animation Delay', 'finanzia'),
                    'type'               => Controls_Manager::NUMBER,
                    'min'                => 50,
                    'step'               => 50,
                    'default'            => 700,
                    'frontend_available' => true,
                ]
            );
            finanzia_add_hidden_device_controls($widget, ['prefix' => 'desc_']);
        $widget->end_controls_section();
        // Button Primary Style Section Start
        $widget->start_controls_section(
            'button_primary_style_section',
            [
                'label' => esc_html__('Button Primary', 'finanzia'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $widget->add_control(
            'button_primary_animation',
            [
                'label'              => esc_html__('Animation', 'finanzia'),
                'type'               => Controls_Manager::ANIMATION,
                'default'            => 'fadeInLeft',
                'frontend_available' => true,
            ]
        );

        $widget->add_control(
            'button_primary_animation_delay',
            [
                'label'              => esc_html__('Animation Delay', 'finanzia'),
                'type'               => Controls_Manager::NUMBER,
                'min'                => 50,
                'step'               => 50,
                'default'            => 800,
                'frontend_available' => true,
            ]
        );
        finanzia_add_hidden_device_controls($widget, ['prefix' => 'btn1_']);
        $widget->end_controls_section();
        // Button Secondary Style Section Start
        $widget->start_controls_section(
            'button_secondary_style_section',
            [
                'label' => esc_html__('Button Secondary', 'finanzia'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $widget->add_control(
            'button_secondary_animation',
            [
                'label'              => esc_html__('Animation', 'finanzia'),
                'type'               => Controls_Manager::ANIMATION,
                'default'            => 'fadeInLeft',
                'frontend_available' => true,
            ]
        );

        $widget->add_control(
            'button_secondary_animation_delay',
            [
                'label'              => esc_html__('Animation Delay', 'finanzia'),
                'type'               => Controls_Manager::NUMBER,
                'min'                => 50,
                'step'               => 50,
                'default'            => 900,
                'frontend_available' => true,
            ]
        );
        finanzia_add_hidden_device_controls($widget, ['prefix' => 'btn2_']);
        $widget->end_controls_section();
        // Button Video Style Section Start
        $widget->start_controls_section(
            'button_video_style_section',
            [
                'label' => esc_html__('Button Video', 'finanzia'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

            $widget->add_control(
                'button_video_animation',
                [
                    'label'              => esc_html__('Animation', 'finanzia'),
                    'type'               => Controls_Manager::ANIMATION,
                    'default'            => 'fadeInLeft',
                    'frontend_available' => true,
                ]
            );

            $widget->add_control(
                'button_video_animation_delay',
                [
                    'label'              => esc_html__('Animation Delay', 'finanzia'),
                    'type'               => Controls_Manager::NUMBER,
                    'min'                => 50,
                    'step'               => 50,
                    'default'            => 1000,
                    'frontend_available' => true,
                ]
            );
            finanzia_add_hidden_device_controls($widget, ['prefix' => 'btn_video_']);
        $widget->end_controls_section();
        
        // Carousel Settings
        $widget->start_controls_section(
            'carousel_section',
            [
                'label'     => esc_html__('Carousel Settings', 'finanzia'),
                'tab'       => Controls_Manager::TAB_SETTINGS,
                'condition' => [
                    'layout!' => ['-list']
                ]
            ]
        );
            $widget->add_responsive_control(
                'slides_height',
                [
                    'label'   => esc_html__( 'Slider Height', 'finanzia' ),
                    'type'    => Controls_Manager::SLIDER,
                    'default' => [
                        'size' => '780',
                        'unit' => 'px' 
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .cms-eslider' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                    'size_units' => [ 'px', 'vh'],
                    'range' => [
                        'px' => [
                            'min' => 100,
                            'max' => 2000,
                        ],
                        'vh' => [
                            'min' => 20,
                            'max' => 100,
                        ],
                    ],
                ]
            );
            $widget->add_control(
                'effect',
                [
                    'label' => esc_html__('Effect', 'finanzia'),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'slide',
                    'options' => [
                        'slide' => esc_html__('Slide', 'finanzia'),
                        'fade' => esc_html__('Fade', 'finanzia'),
                    ],
                    'condition' => [
                        'slides_to_show' => '1',
                    ],
                    'frontend_available' => true,
                ]
            );
            $slides_to_show = range(1, 3);
            $slides_to_show = array_combine($slides_to_show, $slides_to_show);
            $widget->add_responsive_control(
                'slides_to_show',
                [
                    'label'   => esc_html__('Slides to Show', 'finanzia'),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                            '' => esc_html__('Default', 'finanzia'),
                        ] + $slides_to_show,
                    'default'        => '1',
                    'tablet_default' => '1',
                    'mobile_default' => '1',
                    'frontend_available' => true
                ]
            );

            $widget->add_responsive_control(
                'slides_to_scroll',
                [
                    'label' => esc_html__('Slides to Scroll', 'finanzia'),
                    'type' => Controls_Manager::SELECT,
                    'description' => esc_html__('Set how many slides are scrolled per swipe.', 'finanzia'),
                    'options' => [
                            '' => esc_html__('Default', 'finanzia'),
                        ] + $slides_to_show,
                    'condition' => [
                        'slides_to_show!' => '1',
                    ],
                    'frontend_available' => true
                ]
            );

            $widget->add_responsive_control(
                'space_between',
                [
                    'label' => esc_html__('Space Between', 'finanzia'),
                    'type' => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'size' => 30,
                    ],
                    'condition' => [
                        'slides_to_show!' => '1',
                    ],
                    'frontend_available' => true,
                ]
            );
            // Mousewheel
            $widget->add_control(
                'mousewheel',
                [
                    'label'              => esc_html__('Mousewheel Control', 'finanzia'),
                    'type'               => Controls_Manager::SWITCHER,
                    'default'            => 'no',
                    'frontend_available' => true
                ]
            );
            $widget->add_control(
                'mousewheel_releaseOnEdges',
                [
                    'label'              => esc_html__('Mousewheel release On Edges', 'finanzia'),
                    'type'               => Controls_Manager::SWITCHER,
                    'default'            => 'yes',
                    'condition' => [
                        'mousewheel' => 'yes',
                    ],
                    'frontend_available' => true,
                    'description'        => esc_html__('Swiper will release mousewheel event and allow page scrolling when swiper is on edge positions (in the beginning or in the end)', 'finanzia')   
                ]
            );
            $widget->add_control(
                'mousewheel_sensitivity',
                [
                    'label'              => esc_html__('Mousewheel sensitivity', 'finanzia'),
                    'type'               => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min'  => 1, 
                            'max'  => 5,
                            'step' => 1
                        ]
                    ],
                    'default' => [
                        'size' => 1,
                        'unit' => 'px' 
                    ],
                    'size_units' => [ 'px'],
                    'condition' => [
                        'mousewheel' => 'yes',
                    ],
                    'frontend_available' => true,
                    'description'        => esc_html__('Multiplier of mousewheel data, allows to tweak mouse wheel sensitivity', 'finanzia'),
                    'separator'          => 'after'
                ]
            );
            // Arrows
            $widget->add_control(
                'arrows',
                [
                    'label'              => esc_html__('Show Arrows', 'finanzia'),
                    'type'               => Controls_Manager::SWITCHER,
                    'default'            => 'yes',
                    'frontend_available' => true,
                    'separator'          => 'before',
                    'classes'            => 'cms-eseparator'
                ]
            );
            finanzia_add_hidden_device_controls($widget, [
                'prefix'    => 'arrows_',
                'condition' => [
                    'arrows' => 'yes'
                ],
                'separator' => 'before'
            ]);
            // Dots
            $widget->add_control(
                'dots',
                [
                    'label'              => esc_html__('Show Dots', 'finanzia'),
                    'type'               => Controls_Manager::SWITCHER,
                    'default'            => 'yes',
                    'frontend_available' => true,
                    'separator'          => 'before',
                    'classes'            => 'cms-eseparator'
                ]
            );
            finanzia_add_hidden_device_controls($widget, [
                'prefix' => 'dots_',
                'condition' => [
                    'dots' => 'yes'
                ]
            ]);
            $widget->add_control(
                'dots_type',
                [
                    'label'              => esc_html__('Dots Type', 'finanzia'),
                    'type'               => Controls_Manager::SELECT,
                    'options'            => [
                        'progressbar'      => esc_html__('Progressbar','finanzia'),
                        'bullets'          => esc_html__('Dots','finanzia'),
                        'circle'           => esc_html__('Dots Circle','finanzia'),
                        'number'           => esc_html__('Number','finanzia'),
                        'fraction'         => esc_html__('Fraction (Current/Total)','finanzia'),
                        'current-of-total' => esc_html__('Current of Total', 'finanzia'),
                        'custom'           => esc_html__('Custom','finanzia')
                    ],
                    'default'            => 'bullets',
                    'frontend_available' => true,
                    'condition' => [
                        'dots' => 'yes'
                    ]
                ]
            );
            $widget->add_control(
                'lazyload',
                [
                    'label'              => esc_html__('Lazyload', 'finanzia'),
                    'type'               => Controls_Manager::SWITCHER,
                    'frontend_available' => true,
                    'default'            => 'yes',
                    'separator'          => 'before'
                ]
            );
            $widget->add_control(
                'infinite',
                [
                    'label'              => esc_html__('Infinite Loop', 'finanzia'),
                    'type'               => Controls_Manager::SWITCHER,
                    'default'            => 'yes',
                    'frontend_available' => true,
                ]
            );
            $widget->add_control(
                'autoplay',
                [
                    'label' => esc_html__('Autoplay', 'finanzia'),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'frontend_available' => true,
                ]
            );
            $widget->add_control(
                'pause_on_hover',
                [
                    'label' => esc_html__('Pause on Hover', 'finanzia'),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'frontend_available' => true,
                    'condition' => [
                        'autoplay' => 'yes',
                    ],
                ]
            );
            $widget->add_control(
                'pause_on_interaction',
                [
                    'label' => esc_html__('Pause on Interaction', 'finanzia'),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'frontend_available' => true,
                    'condition' => [
                        'autoplay' => 'yes',
                    ],
                ]
            );
            $widget->add_control(
                'autoplay_speed',
                [
                    'label' => esc_html__('Autoplay Speed', 'finanzia'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 5000,
                    'condition' => [
                        'autoplay' => 'yes',
                    ],
                    'frontend_available' => true,
                ]
            );
            $widget->add_control(
                'speed',
                [
                    'label' => esc_html__('Animation Speed', 'finanzia'),
                    'type' => Controls_Manager::NUMBER,
                    'default' => 500,
                    'render_type' => 'none',
                    'frontend_available' => true,
                ]
            );
        $widget->end_controls_section();
    }
}
