<?php
use Elementor\Controls_Manager;
if(!function_exists('finanzia_widget_cms_search_register_controls')){
	add_action('etc_widget_cms_search_register_controls', 'finanzia_widget_cms_search_register_controls', 10, 1);
	function finanzia_widget_cms_search_register_controls($widget){
		// Layout Settings
		$widget->start_controls_section(
			'layout_section',
			[
				'label' => esc_html__('Layout', 'finanzia' ),
                'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
			]
		);

			$widget->add_control(
				'layout',
                [
					'label'   => esc_html__('Templates', 'finanzia' ),
					'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
					'default' => '1',
					'options' => [
                        '1' => [
	                        'label' => esc_html__( 'Layout 1', 'finanzia' ),
	                        'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_search/layout-images/1.jpg'
	                    ]
	                ]
	            ]
			);
		$widget->end_controls_section();
		// Search Settings
		$widget->start_controls_section(
			'search_section',
			[
				'label'    => esc_html__( 'Search Settings', 'finanzia' ),
				'tab'      => \Elementor\Controls_Manager::TAB_CONTENT
			]
		);
			$widget->add_control(
				'field_height',
                [
                	'label'          => esc_html__('Field Height', 'finanzia'),
                    'type'  => \Elementor\Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 40,
                            'max' => 150,
                        ],
                    ],
                    'selectors'      => [
                        '{{WRAPPER}} input[type="search"]' => 'height:{{SIZE}}px !important; line-height:{{SIZE}}px !important;'
                    ]
                ]
			);
			$widget->add_control(
				'placeholder_text',
				[
					'label' => esc_html__( 'Place Holder Text', 'finanzia' ),
					'type'  => \Elementor\Controls_Manager::TEXTAREA
				]
			);
		$widget->end_controls_section();
	}
}
?>