<?php
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Utils;
use Elementor\Repeater;
if (!function_exists('finanzia_widget_cms_process_carousel_register_controls')) {
    add_action('etc_widget_cms_process_carousel_register_controls', 'finanzia_widget_cms_process_carousel_register_controls', 10, 1);
    function finanzia_widget_cms_process_carousel_register_controls($widget)
    {
        // Layout Tab Start
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'finanzia'),
                'tab' => Controls_Manager::TAB_LAYOUT,
            ]
        );
        $widget->add_control(
            'layout',
            [
                'label'   => esc_html__( 'Templates', 'finanzia' ),
                'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                'default' => '1',
                'options' => [
                    '1' => [
                        'label' => esc_html__( 'Layout 1', 'finanzia' ),
                        'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_process_carousel/layout/1.webp'
                    ]
                ]
            ]
        );
        $widget->end_controls_section();
        // List
        $widget->start_controls_section(
            'list_section',
            [
                'label' => esc_html__('Process List', 'finanzia'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
            $process = new Repeater();
            $process->add_control(
                'banner',
                [
                    'label'   => esc_html__('Banner', 'finanzia'),
                    'type'    => Controls_Manager::MEDIA,
                    'default' => [
                        'url' => Utils::get_placeholder_image_src(),
                    ],
                    'label_block' => false
                ]
            );
            $process->add_control(
                'title',
                [
                    'label'   => esc_html__('Title', 'finanzia'),
                    'type'    => Controls_Manager::TEXT,
                    'default' => 'Your Title',
                ]
            );
            $process->add_control(
                'description',
                [
                    'label'   => esc_html__('Description', 'finanzia'),
                    'type'    => Controls_Manager::TEXTAREA,
                    'default' => 'It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.',
                ]
            );
            $widget->add_control(
                'process',
                [
                    'label'   => esc_html__('Process', 'finanzia'),
                    'type'    => \Elementor\Controls_Manager::REPEATER,
                    'fields'  => $process->get_controls(),
                    'default' => [
                        [
                            'banner' => [
                                'url' => Utils::get_placeholder_image_src(),
                            ],
                            'title'        => esc_html__('Title #1', 'finanzia'),
                            'description' => esc_html__('#1 It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.', 'finanzia'),
                        ],
                        [
                            'banner' => [
                                'url' => Utils::get_placeholder_image_src(),
                            ],
                            'title'        => esc_html__('Title #2', 'finanzia'),
                            'description' => esc_html__('#2 It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.', 'finanzia'),
                        ],
                        [
                            'banner' => [
                                'url' => Utils::get_placeholder_image_src(),
                            ],
                            'title'        => esc_html__('Title #3', 'finanzia'),
                            'description' => esc_html__('#3 It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.', 'finanzia'),
                        ]
                    ],
                    'title_field' => '{{{ title }}}',
                    'label_block' => true
                ]
            );
        $widget->end_controls_section();
        // Carousel Settings
        finanzia_elementor_carousel_settings($widget, [
            'slides_to_show'   => 1,
            'slides_to_scroll' => 1 
        ]);
        // Style
        $widget->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Style Settings','finanzia'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'bg_color',
                'label'    => esc_html__( 'Background Color', 'finanzia' )
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'title_color',
                'label'    => esc_html__( 'Title Color', 'finanzia' )
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'desc_color',
                'label'    => esc_html__( 'Description Color', 'finanzia' )
            ]);
            
            // Arrows
            finanzia_elementor_colors_opts($widget,[
                'name'        => 'arrow_color',
                'label'       => esc_html__( 'Arrow Color', 'finanzia' ),
                'description' => esc_html__('Arrows Settings', 'finanzia'),
                'classes'     => 'cms-description-as-label', 
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'        => 'arrow_bg_color',
                'label'       => esc_html__( 'Arrow Background Color', 'finanzia' )
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'        => 'arrow_hover_color',
                'label'       => esc_html__( 'Arrow hover Color', 'finanzia' )
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'        => 'arrow_bg_hover_color',
                'label'       => esc_html__( 'Arrow Background Hover Color', 'finanzia' )
            ]);
        $widget->end_controls_section();
    }
}
