<?php
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;

if (!function_exists('finanzia_widget_cms_process_register_controls')) {
    add_action('etc_widget_cms_process_register_controls', 'finanzia_widget_cms_process_register_controls', 10, 1);
    function finanzia_widget_cms_process_register_controls($widget)
    {
        // Layout
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'finanzia'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'finanzia' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_process/layout/1.webp'
                        ],
                        '2' => [
                            'label' => esc_html__( 'Layout 2', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_process/layout/2.webp'
                        ],
                        '3' => [
                            'label' => esc_html__( 'Layout 3', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_process/layout/3.webp'
                        ],
                        '4' => [
                            'label' => esc_html__( 'Layout 4', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_process/layout/4.webp'
                        ]
                    ]
                ]
            );
        $widget->end_controls_section();
        // Content Tab Start

        // Heading Section Start
        $widget->start_controls_section(
            'section_heading',
            [
                'label' => esc_html__('Heading Content', 'finanzia'),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout' => ['1']
                ]
            ]
        );
            $widget->add_control(
                'smallheading_text',
                [
                    'label'       => esc_html__( 'Small Heading', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => '',
                    'placeholder' => esc_html__( 'Enter your text', 'finanzia' ),
                    'label_block' => true
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'smallheading_color',
                'label'     => esc_html__( 'Color', 'finanzia' ),
                'condition' => [
                    'smallheading_text!' => ''
                ]
            ]);
            // Heading
            $widget->add_control(
                'heading_text',
                [
                    'label'       => esc_html__( 'Heading', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'This is the heading',
                    'placeholder' => esc_html__( 'Enter your text', 'finanzia' ),
                    'label_block' => true
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'heading_color',
                'label'    => esc_html__( 'Color', 'finanzia' ),
                'custom'   => false, 
                'condition' => [
                    'heading_text!' => ''
                ]
            ]);
            // Description
            $widget->add_control(
                'desc',
                [
                    'label'       => esc_html__( 'Description', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour', 
                    'placeholder' => esc_html__( 'Enter your text', 'finanzia' ),
                    'rows'        => 10,
                    'show_label'  => true
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'      => 'desc_color',
                'label'     => esc_html__( 'Color', 'finanzia' ),
                'custom'    => false,
                'condition' => [
                    'desc!' => ''
                ]
            ]);
            // Button #1
            finanzia_elementor_link_settings($widget, [
                'name'        => 'link1_',
                'mode'        => 'btn',
                'group'       => false,
                'label'       => esc_html__('Button #1 Settings', 'finanzia'),
                'color_label' => esc_html__('Button', 'finanzia')
            ]);
        $widget->end_controls_section();
        // Process Section Start
        $widget->start_controls_section(
                'section_process',
                [
                    'label' => esc_html__('Process Content', 'finanzia'),
                    'tab'   => Controls_Manager::TAB_CONTENT
                ]
            );

            $process = new Repeater();
            // Banner
            $process->add_control(
                'banner',
                [
                    'label'   => esc_html__( 'Banner', 'finanzia' ),
                    'type'    => Controls_Manager::MEDIA,
                    'default' => [
                        'url' => Utils::get_placeholder_image_src()
                    ],
                    'label_block'   => false
                ]
            );
            // Icon
            finanzia_elementor_icon_image_settings($process,[
                'group' => false
            ]);
            // Title
            $process->add_control(
                'title',
                [
                    'label'       => esc_html__( 'Title', 'finanzia' ),
                    'type'        => Controls_Manager::TEXT,
                    'placeholder' => esc_html__( 'Process Title', 'finanzia' ),
                    'default'     => esc_html__( 'Process Title', 'finanzia' ),
                    'label_block' => true,
                ]
            );
            // Description
            $process->add_control(
                'desc',
                [
                    'label'       => esc_html__( 'Description', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA
                ]
            );
            // Lists
            $widget->add_control(
                'process_list',
                [
                    'label'   => esc_html__('Process List', 'finanzia'),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $process->get_controls(),
                    'default' => [
                        [
                            'title' => 'Process title #1',
                            'desc' => 'Neque porro quisquam est qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit'
                        ],
                        [
                            'title' => 'Process title #2',
                            'desc' => 'There is no one who loves pain itself, who seeks after it and wants to have it, simply because it is pain'
                        ],
                        [
                            'title' => 'Process title #3',
                            'desc' => 'Cras rutrum varius accumsan. Aenean ut ligula at libero viverra sodales. Vestibulum nec viverra metus'
                        ],
                    ],
                    'title_field' => '{{{ title }}}',
                    'condition' => [
                        'layout' => ['1','2']
                    ]
                ]
            );
            // For layout #3
            $process3 = new Repeater();
            // Banner
            $process3->add_control(
                'banner',
                [
                    'label'   => esc_html__( 'Banner', 'finanzia' ),
                    'type'    => Controls_Manager::MEDIA,
                    'default' => [
                        'url' => Utils::get_placeholder_image_src()
                    ],
                    'label_block'   => false
                ]
            );
            // Title
            $process3->add_control(
                'small_title',
                [
                    'label'       => esc_html__( 'Title', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'placeholder' => esc_html__( 'Your Title', 'finanzia' ),
                    'default'     => esc_html__( 'Your Title', 'finanzia' ),
                    'label_block' => true,
                ]
            );
            $process3->add_control(
                'title',
                [
                    'label'       => esc_html__( 'Content Title', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'placeholder' => esc_html__( 'Process Title', 'finanzia' ),
                    'default'     => esc_html__( 'Process Title', 'finanzia' ),
                    'label_block' => true,
                ]
            );
            // Description
            $process3->add_control(
                'desc',
                [
                    'label'       => esc_html__( 'Description #1', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA
                ]
            );
            $process3->add_control(
                'desc2',
                [
                    'label'       => esc_html__( 'Description #2', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA
                ]
            );
            // Button #1
            finanzia_elementor_link_settings($process3, [
                'name'        => 'link1_',
                'mode'        => 'btn',
                'type'        => [
                    'cms-service' => esc_html__('CMS Service','finanzia')
                ],
                'group'       => false,
                'label'       => esc_html__('Button #1 Settings', 'finanzia'),
                'color_label' => esc_html__('Button', 'finanzia')
            ]);
            $process3->add_control(
                'feature',
                [
                    'label'       => esc_html__( 'Feature', 'finanzia' ),
                    'type'        => Elementor_Theme_Core::REPEATER_CONTROL,
                    'controls'    => array(
                        array(
                            'name'    => 'title',
                            'label'   => esc_html__('Feature Title', 'finanzia' ),
                            'type'    => Controls_Manager::TEXTAREA,
                            'default' => 'Your Title'
                        )
                    ),
                    'label_block' => true,
                    'button_text' => esc_html__('Add Feature', 'finanzia'),
                ]
            );
            $widget->add_control(
                'process_list3',
                [
                    'label'   => esc_html__('Process List', 'finanzia'),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $process3->get_controls(),
                    'default' => [
                        [
                            'small_title' => 'Small Title #1',
                            'title'       => 'Process title #1',
                            'desc'        => 'Neque porro quisquam est qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit'
                        ],
                        [
                            'small_title' => 'Small Title #2',
                            'title'       => 'Process title #2',
                            'desc'        => 'There is no one who loves pain itself, who seeks after it and wants to have it, simply because it is pain'
                        ],
                        [
                            'small_title' => 'Small Title #3',
                            'title'       => 'Process title #3',
                            'desc'        => 'Cras rutrum varius accumsan. Aenean ut ligula at libero viverra sodales. Vestibulum nec viverra metus'
                        ]
                    ],
                    'button_text' => esc_html__('Add Process', 'finanzia'),
                    'title_field' => '{{{ small_title }}}',
                    'condition' => [
                        'layout' => ['3','4']
                    ]
                ]
            );
            // Style
            finanzia_elementor_colors_opts($widget,[
                'name'      => 'bg_color',
                'label'     => esc_html__( 'Background Color', 'finanzia' ),
                'condition' => [
                    'layout' => ['3','4']
                ],
                'separator' => 'before'
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'  => 'small_title_color',
                'label' => esc_html__( 'Small Title Color', 'finanzia' ),
                'condition' => [
                    'layout' => ['3']
                ],
                'separator' => 'before'
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'  => 'small_title_border_color',
                'label' => esc_html__( 'Border Color', 'finanzia' ),
                'condition' => [
                    'layout' => ['3']
                ]
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'  => 'ptitle_color',
                'label' => esc_html__( 'Title Color', 'finanzia' ),
                'separator' => 'before'
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'  => 'pdesc_color',
                'label' => esc_html__( 'Desc Color', 'finanzia' )
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'  => 'pdesc2_color',
                'label' => esc_html__( 'Desc #2 Color', 'finanzia' ),
                'condition' => [
                    'layout' => ['3','4']
                ]
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'  => 'btn_color',
                'label' => esc_html__( 'Button Color', 'finanzia' ),
                'condition' => [
                    'layout' => ['3','4']
                ],
                'separator' => 'before'
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'  => 'btn_text_color',
                'label' => esc_html__( 'Button Text Color', 'finanzia' ),
                'condition' => [
                    'layout' => ['3','4']
                ]
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'  => 'btn_hover_color',
                'label' => esc_html__( 'Button Hover Color', 'finanzia' ),
                'condition' => [
                    'layout' => ['3','4']
                ]
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'  => 'btn_hover_text_color',
                'label' => esc_html__( 'Button Hover Text Color', 'finanzia' ),
                'condition' => [
                    'layout' => ['3','4']
                ]
            ]);
            //
            finanzia_elementor_colors_opts($widget,[
                'name'  => 'feature_color',
                'label' => esc_html__( 'Feature Color', 'finanzia' ),
                'condition' => [
                    'layout' => ['3','4']
                ],
                'separator' => 'before'
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'  => 'feature_border_color',
                'label' => esc_html__( 'Feature Border Color', 'finanzia' ),
                'condition' => [
                    'layout' => ['3','4']
                ]
            ]);
        $widget->end_controls_section();
        // Grid Settings
        finanzia_elementor_grid_columns_settings($widget, []);
    }
}
