<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Repeater;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;

if (!function_exists('finanzia_widget_cms_pricing_register_controls')) {
    add_action('etc_widget_cms_pricing_register_controls', 'finanzia_widget_cms_pricing_register_controls', 10, 1);
    function finanzia_widget_cms_pricing_register_controls($widget)
    {
        // Layout
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'finanzia'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'finanzia' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_pricing/layout/1.webp'
                        ],
                        '2' => [
                            'label' => esc_html__( 'Layout 2', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_pricing/layout/2.webp'
                        ]
                    ]
                ]
            );
        $widget->end_controls_section();
        // Heading Section Start
        $widget->start_controls_section(
            'section_heading',
            [
                'label' => esc_html__('Heading Content', 'finanzia'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
            $widget->add_control(
                'badge_text',
                [
                    'label'       => esc_html__( 'Badge Text', 'finanzia' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => 'BEST VALUE',
                    'label_block' => false,
                    'separator'   => 'after'
                ]
            );
            $widget->add_control(
                'price',
                [
                    'label'       => esc_html__( 'Price', 'finanzia' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => '$150',
                    'label_block' => true,
                    'separator'   => false,
                    'dynamic'     => [
                        'active' => true,
                    ]
                ]
            );
            $widget->add_control(
                'price_pack',
                [
                    'label'       => esc_html__( 'Price Pack', 'finanzia' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => 'Month',
                    'label_block' => false,
                    'separator'   => 'after',
                    'dynamic'     => [
                        'active' => true,
                    ],
                    'condition' => [
                        'price!' => ''
                    ]
                ]
            );
            $widget->add_control(
                'cms_icon',
                [
                    'label'            => esc_html__( 'Icon', 'finanzia' ),
                    'type'             => Controls_Manager::ICONS,
                    'default'          => [],
                    'skin'             => 'inline',
                    'label_block'      => false  
                ]
            );
            $widget->add_control(
                'subheading_text',
                [
                    'label'       => esc_html__( 'Small Heading', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'placeholder' => esc_html__( 'Enter your small title', 'finanzia' ),
                    'label_block' => true,
                    'dynamic' => [
                        'active' => true,
                    ]
                ]
            );
            $widget->add_control(
                'heading_text',
                [
                    'label'       => esc_html__( 'Heading', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => esc_html__( 'Starter Plan', 'finanzia' ),
                    'placeholder' => esc_html__( 'Enter your title', 'finanzia' ),
                    'label_block' => true
                ]
            );
            $widget->add_control(
                'description_text_bold',
                [
                    'label'       => esc_html__( 'Description (Bold)', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'placeholder' => esc_html__( 'Enter your description', 'finanzia' ),
                    'rows'        => 10,
                    'show_label'  => true,
                    'separator' => 'before'
                ]
            );
            $widget->add_control(
                'description_text',
                [
                    'label'       => esc_html__( 'Description', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'Lorem Ipsum has been the industrys standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.',
                    'placeholder' => esc_html__( 'Enter your description', 'finanzia' ),
                    'rows'        => 10,
                    'show_label'  => true,
                    'separator' => 'before'
                ]
            );
        $widget->end_controls_section();
        // Button #1
        finanzia_elementor_link_settings($widget, [
            'name'        => 'link1_',
            'mode'        => 'btn',
            'group'       => true,
            'label'       => esc_html__('Button #1 Settings', 'finanzia'),
            'color_label' => esc_html__('Button', 'finanzia'),
            'text'        => 'Get Started',
            'color'       => false
        ]);
        // Button #2
        finanzia_elementor_link_settings($widget, [
            'name'        => 'link2_',
            'mode'        => 'btn',
            'group'       => true,
            'label'       => esc_html__('Button #2 Settings', 'finanzia'),
            'color_label' => esc_html__('Button', 'finanzia'),
            'color'       => false  
        ]);
        // Features
        $widget->start_controls_section('features_section',[
            'label' => esc_html__('Features Settings', 'finanzia'),
            'tab'   => Controls_Manager::TAB_CONTENT
        ]);
            $repeater = new Repeater();
            $repeater->add_control(
                'icon',
                [
                    'label'       => esc_html__( 'Icon', 'finanzia' ),
                    'default'     => [],
                    'type'        => Controls_Manager::ICONS,
                    'skin'        => 'inline',
                    'label_block' => false,
                ]
            );
            $repeater->add_control(
                'title',
                [
                    'label'       => esc_html__( 'Title', 'finanzia' ),
                    'default'     => esc_html__( 'Title', 'finanzia' ),
                    'type'        => Controls_Manager::TEXT,
                    'label_block' => false,
                ]
            );
            $widget->add_control(
                'cms_feature',
                [
                    'label'   => esc_html__('Features List', 'finanzia'),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $repeater->get_controls(),
                    'default' => [
                        [
                            'icon'  => [],
                            'title' => 'Enterprise Network Video Recorders',
                        ],
                        [
                            'icon'  => [],
                            'title' => 'Intelligent video technology storage',
                        ],
                        [
                            'icon'  => [],
                            'title' => 'Streaming over network or Internet',
                        ]
                    ],
                    'title_field' => '{{{ title }}}',
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'feature_text_color',
                'label'    => esc_html__( 'Text Color', 'finanzia' ),
                'custom'   => false 
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'feature_icon_color',
                'label'    => esc_html__( 'Icon Color', 'finanzia' ),
                'custom'   => false 
            ]);
        $widget->end_controls_section();
    }
}
