<?php
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;

if (!function_exists('finanzia_widget_cms_post_feature_register_controls')) {
    add_action('etc_widget_cms_post_feature_register_controls', 'finanzia_widget_cms_post_feature_register_controls', 10, 1);
    function finanzia_widget_cms_post_feature_register_controls($widget)
    {
        // Layout
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'finanzia'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'finanzia' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_post_feature/layout/1.webp'
                        ],
                        '-2' => [
                            'label' => esc_html__( 'Layout 2', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_post_feature/layout/2.webp'
                        ]
                    ]
                ]
            );
        $widget->end_controls_section();
        // Content
        $widget->start_controls_section(
            'section_content',
            [
                'label' => esc_html__('Content Settings', 'finanzia'),
                'tab'   => Controls_Manager::TAB_CONTENT
            ]
        );
            $widget->add_control(
                'banner',
                [
                    'label'       => esc_html__( 'Replace Feature Image?', 'finanzia' ),
                    'type'        => Controls_Manager::MEDIA,
                    'default'     => [],
                    'label_block' => true
                ]
            );
            $widget->add_control(
                'video_link',
                [
                    'label'              => esc_html__( 'Video', 'finanzia' ),
                    'subtitle'           => esc_html__('Video url from  YouTube/Vimeo/Dailymotion','finanzia'),
                    'type'               => Controls_Manager::TEXTAREA,
                    'default'            => '',
                    'frontend_available' => true,
                    'label_block'        => true,
                    'condition'          => [
                        'layout' => ['1']
                    ]
                ]
            );
        $widget->end_controls_section();
    }
}
