<?php
use Elementor\Controls_Manager;
if (!function_exists('finanzia_widget_cms_navigation_menu_register_controls')) {
    add_action('etc_widget_cms_navigation_menu_register_controls', 'finanzia_widget_cms_navigation_menu_register_controls', 10, 1);
    function finanzia_widget_cms_navigation_menu_register_controls($widget)
    {
        $menus = get_terms( 'nav_menu', array( 'hide_empty' => false ) );
        if ( is_array( $menus ) && ! empty( $menus ) ) {
            foreach ( $menus as $single_menu ) {
                if ( is_object( $single_menu ) && isset( $single_menu->name, $single_menu->term_id ) ) {
                    $custom_menus[ $single_menu->term_id ] = $single_menu->name;
                }
            }
        } else {
            $custom_menus = '';
        }
        // Layout Settings
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__( 'Layout', 'finanzia' ),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'finanzia' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_navigation_menu/layout/1.webp'
                        ],
                        '2' => [
                            'label' => esc_html__( 'Layout 2', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_navigation_menu/layout/2.webp'
                        ],
                        '3' => [
                            'label' => esc_html__( 'Layout 3', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_navigation_menu/layout/3.jpg'
                        ],
                        '4' => [
                            'label' => esc_html__( 'Layout 4', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_navigation_menu/layout/4.webp'
                        ],
                        '5' => [
                            'label' => esc_html__( 'Layout 5', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_navigation_menu/layout/5.webp'
                        ],
                        '-mega' => [
                            'label' => esc_html__( 'Mega Menu', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_navigation_menu/layout/mega.webp'
                        ],
                        '-sidenav' => [
                            'label' => esc_html__( 'Side Navigation', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_navigation_menu/layout/sidenav.webp'
                        ]
                    ]
                ]
            );
        $widget->end_controls_section();

        // Menu Section Start
        $widget->start_controls_section(
            'navigation_menu_section',
            [
                'label' => esc_html__('Navigation Menu', 'finanzia'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $widget->add_control(
            'menu',
            [
                'label'   => esc_html__( 'Select Menu', 'finanzia' ),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'options' => $custom_menus,
            ]
        );
        $widget->add_control(
            'title',
            [
                'label'       => esc_html__('Title', 'finanzia'),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => esc_html__('Enter your title', 'finanzia'),
                'label_block' => true,
                'condition'   => [
                    'layout!' => ['3','4','-sidenav']
                ]
            ]
        );
            $widget->add_control(
                'link_type',
                [
                    'label'   => esc_html__('Title Link Type', 'finanzia'),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'custom' => esc_html__('Custom', 'finanzia'),
                        'page'   => esc_html__('Page', 'finanzia'),
                    ],
                    'default' => 'page',
                    'condition' => [
                        'menu!'  => '',
                        'layout' => ['-mega'],
                        'title!' => ''
                    ]
                ]
            );
            $widget->add_control(
                'page_link',
                [
                    'label'   => esc_html__('Select Page', 'finanzia'),
                    'type'    => Elementor_Theme_Core::POSTS_CONTROL,
                    'post_type' => [
                        'page'
                    ],
                    'return_value' => 'ID',
                    'multiple'  => false,
                    'condition' => [
                        'menu!'  => '',
                        'layout' => ['-mega'],
                        'title!' => '',
                        'link_type' => 'page'
                    ]
                ]
            );
            $widget->add_control(
                'custom_link',
                [
                    'label'       => esc_html__( 'Custom Link', 'finanzia' ),
                    'type'        => Controls_Manager::URL,
                    'placeholder' => esc_html__( 'https://your-link.com', 'finanzia' ),
                    'default'     => [
                        'url' => '#',
                    ],
                    'condition' => [
                        'menu!'  => '',
                        'layout' => ['-mega'],
                        'title!' => '',
                        'link_type' => 'custom'
                    ]
                ]
            );
            finanzia_elementor_responsive_flex_alignment($widget, [
                'condition' => [
                    'menu!' => '',
                ]
            ]);
        $widget->end_controls_section();

        $widget->start_controls_section(
            'section_style_title',
            [
                'label' => esc_html__('Title', 'finanzia'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'menu!'  => '',
                    'layout' => ['1','5','-mega']
                ]
            ]
        );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'title_color',
                'label'     => esc_html__( 'Color', 'finanzia' ),
                'selector' => [
                    '{{WRAPPER}} .cms-title' => 'color: {{VALUE}};',
                ]
            ]);
        $widget->end_controls_section(); // Style Sub Heading Style End
        // Link
        $widget->start_controls_section(
            'section_style_link',
            [
                'label' => esc_html__('Link', 'finanzia'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'menu!'  => '',
                    'layout!' => ['5','-mega']
                ]
            ]
        );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'link_color',
                'label'     => esc_html__( 'Color', 'finanzia' ),
                'selector' => [
                    '{{WRAPPER}} .cms-menu a:not(:hover)' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .cms-menu-horz li:after' => 'background-color: {{VALUE}};',
                ]
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'link_color_hover',
                'label'     => esc_html__( 'Color on Hover & Active', 'finanzia' ),
                'selector' => [
                    '{{WRAPPER}} .cms-menu a:hover, {{WRAPPER}} .cms-menu li.current-menu-item > a' => 'color: {{VALUE}};'
                ]
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'divider_color',
                'label'     => esc_html__( 'Divider Color', 'finanzia' )
            ]);
        $widget->end_controls_section(); // Style Sub Heading Style End
    }
}
