<?php
use Elementor\Controls_Manager;
use Elementor\Repeater;
if (!function_exists('finanzia_widget_cms_google_map_register_controls')) {
    add_action('etc_widget_cms_google_map_register_controls', 'finanzia_widget_cms_google_map_register_controls', 10, 1);
    function finanzia_widget_cms_google_map_register_controls($widget)
    {
        // Layout
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'finanzia'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'finanzia' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_google_map/layout/1.jpg'
                        ],
                        '2' => [
                            'label' => esc_html__( 'Layout 2', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_google_map/layout/2.jpg'
                        ]
                    ]
                ]
            );
        $widget->end_controls_section();
        // Content Tab Start
        $widget->start_controls_section(
            'map_section',
            [
                'label' => esc_html__('Map Settings','finanzia'),
                'tab'   => Controls_Manager::TAB_CONTENT
            ]
        );
            $default_address = esc_html__( 'The Great Kings Building Management 2307 Beverley Road, Brooklyn, NY 145784', 'finanzia' );
            $widget->add_control(
                'map_address',
                [
                    'label'   => esc_html__( 'Address', 'finanzia' ),
                    'type'    => Controls_Manager::TEXTAREA,
                    'dynamic' => [
                        'active' => true
                    ],
                    'placeholder' => $default_address,
                    'default'     => $default_address,
                    'label_block' => true,
                ]
            );
            $widget->add_control(
                'zoom',
                [
                    'label' => esc_html__( 'Zoom', 'finanzia' ),
                    'type' => Controls_Manager::SLIDER,
                    'default' => [
                        'size' => 15,
                    ],
                    'range' => [
                        'px' => [
                            'min' => 1,
                            'max' => 20,
                        ],
                    ],
                    'separator' => 'before',
                ]
            );
            $widget->add_responsive_control(
                'height',
                [
                    'label' => esc_html__( 'Height', 'finanzia' ),
                    'type'  => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 40,
                            'max' => 1440,
                        ]
                    ],
                    'size_units' => [ 'px' ],
                    'selectors' => [
                        '{{WRAPPER}} .cms-egmap' => 'height: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} iframe' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                    'default' => [
                        'size' => 620,
                    ]
                ]
            );
            $widget->add_control(
                'view',
                [
                    'label'   => esc_html__( 'View', 'finanzia' ),
                    'type'    => Controls_Manager::HIDDEN,
                    'default' => 'traditional',
                ]
            );
            
        $widget->end_controls_section();
        // Content
        $widget->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content Settings','finanzia'),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout' => ['2']
                ]
            ]
        );
            $widget->add_control(
                'title',
                [
                    'label'       => esc_html__('Title','finanzia'),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'Global Locations',  
                    'placeholder' => esc_html__('Enter your title', 'finanzia'),
                    'label_block' => false
                ]
            );

            $widget->add_control(
                'active_section',
                [
                    'label'     => esc_html__( 'Active section', 'finanzia' ),
                    'type'      => Controls_Manager::NUMBER,
                    'default'   => '1',
                    'min'       => '0',
                    'max'       => '50',
                    'description' => esc_html__('Locations Settings', 'finanzia'),
                    'classes'     => 'cms-description-as-label'
                ]
            );
            $repeater = new Repeater();
                $repeater->add_control(
                    'ac_title',
                    [
                        'label'       => esc_html__( 'Title', 'finanzia' ),
                        'type'        => Controls_Manager::TEXT,
                        'default'     => 'Title',
                        'placeholder' => esc_html__( 'Enter your title', 'finanzia' ),
                        'label_block' => true,
                    ]
                );
                $repeater->add_control(
                    'ac_content',
                    [
                        'label'       => esc_html__( 'Content', 'finanzia' ),
                        'type'        => \Elementor\Controls_Manager::TEXTAREA,
                        'default'     => 'Item content. Click the edit button to change this text.',
                        'placeholder' => esc_html__( 'Enter your content', 'finanzia' ),
                        'label_block' => true,
                    ]
                );
            $widget->add_control(
                'cms_accordion',
                [
                    'label' => esc_html__('Locations List', 'finanzia'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $repeater->get_controls(),
                    'default' => [
                        [
                            'ac_title'   => 'London Office',
                            'ac_content' => 'Phone: 01061245741
Email: Finanzia@cmsheroes.com
Address: Brooklyn, New York, USA
Hours: Mon-Fri: 8am – 7pm',
                        ],
                        [
                            'ac_title'   => 'Berlin Office',
                            'ac_content' => 'Phone: 01061245741
Email: Finanzia@cmsheroes.com
Address: Berlin Office Address
Hours: Mon-Fri: 8am – 7pm',
                        ],
                        [
                            'ac_title'   => 'Manchester Office',
                            'ac_content' => 'Phone: 01061245741
Email: Finanzia@cmsheroes.com
Address: Manchester Office Address
Hours: Mon-Fri: 8am – 7pm',
                        ]
                    ],
                    'title_field' => '{{{ ac_title }}}',
                ]
            );
        $widget->end_controls_section();
    }
}
