<?php
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Repeater;
//
if (!function_exists('finanzia_widget_cms_fancy_box_register_controls')) {
    add_action('etc_widget_cms_fancy_box_register_controls', 'finanzia_widget_cms_fancy_box_register_controls', 10, 1);
    function finanzia_widget_cms_fancy_box_register_controls($widget)
    {
        // Layout Section Start
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'finanzia'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_responsive_control(
                'text_align',
                [
                    'label'        => esc_html__( 'Text Alignment', 'finanzia' ),
                    'type'         => Controls_Manager::CHOOSE,
                    'options'      => [
                        'start'    => [
                            'title' => esc_html__( 'Left', 'finanzia' ),
                            'icon'  => 'eicon-text-align-left',
                        ],
                        'center'  => [
                            'title' => esc_html__( 'Center', 'finanzia' ),
                            'icon'  => 'eicon-text-align-center',
                        ],
                        'end'   => [
                            'title' => esc_html__( 'Right', 'finanzia' ),
                            'icon'  => 'eicon-text-align-right',
                        ]
                    ]
                ]
            );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__('Templates', 'finanzia'),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__('Layout 1', 'finanzia'),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_fancy_box/layout/1.webp'
                        ],
                        '2' => [
                            'label' => esc_html__('Layout 2', 'finanzia'),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_fancy_box/layout/2.webp'
                        ],
                        '3' => [
                            'label' => esc_html__('Layout 3', 'finanzia'),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_fancy_box/layout/3.webp'
                        ],
                        '4' => [
                            'label' => esc_html__('Layout 4', 'finanzia'),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_fancy_box/layout/4.webp'
                        ],
                        '5' => [
                            'label' => esc_html__('Layout 5', 'finanzia'),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_fancy_box/layout/5.webp'
                        ]
                    ]
                ]
            );
        $widget->end_controls_section();
        // Icon Section Start
        $widget->start_controls_section(
            'fancy_box_section',
            [
                'label' => esc_html__('Fancy Box', 'finanzia'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
            $fancy_box = new Repeater();
                finanzia_elementor_icon_image_settings($fancy_box, [
                    'group'     => false
                ]);
                $fancy_box->add_control(
                    'title',
                    [
                        'label'       => esc_html__('Title', 'finanzia'),
                        'type'        => Controls_Manager::TEXTAREA,
                        'default'     => 'This is the Heading',
                        'placeholder' => esc_html__('Enter your title', 'finanzia'),
                        'label_block' => true
                    ]
                );
                $fancy_box->add_control(
                    'description',
                    [
                        'label'       => esc_html__('Description', 'finanzia'),
                        'type'        => Controls_Manager::TEXTAREA,
                        'default'     => 'This is the Description',
                        'placeholder' => esc_html__('Enter your description', 'finanzia'),
                        'rows'        => 10,
                        'show_label'  => true
                    ]
                );
                finanzia_elementor_link_settings($fancy_box, [
                    'type' => [
                        'cms-service' => esc_html__('Service', 'finanzia')
                    ],
                    'color' => false
                ]);            
            $widget->add_control(
                'fancy_box',
                [
                    'label'       => esc_html__('Fancy Box','finanzia'),
                    'type'        => Controls_Manager::REPEATER,
                    'fields'      => $fancy_box->get_controls(),
                    'title_field' => '{{title}}',
                    'default' => [
                        [
                            'icon_type'     => 'icon',
                            'selected_icon' => [
                                'library' => 'svg',
                                'value'   => [
                                    'url' => get_template_directory().'/assets/svgs/core/star.svg'
                                ] 
                            ],
                            'title' => 'This is Heading'
                        ]
                    ]
                ]
            );
        $widget->end_controls_section();
        // Style Section Start
        $widget->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Style', 'finanzia'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            // Icon
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'icon_color',
                'label'     => esc_html__( 'Icon Color', 'finanzia' ),
                'selector' => [
                    '{{WRAPPER}} .cms-icon' => 'color: {{VALUE}};'
                ]
            ]);
            // Title
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'title_color',
                'label'    => esc_html__( 'Title Color', 'finanzia' ),
                'selector' => [
                    '{{WRAPPER}} .cms-title' => 'color: {{VALUE}};'
                ],
                'separator' => 'before',
            ]);
            // Description
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'description_color',
                'label'    => esc_html__( 'Description Color', 'finanzia' ),
                'selector' => [
                    '{{WRAPPER}} .cms-desc' => 'color: {{VALUE}};'
                ],
                'separator' => 'before',
            ]);
        $widget->end_controls_section();
        // Grid Settings
        finanzia_elementor_grid_columns_settings($widget);
    }
}
