<?php
use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!function_exists('finanzia_widget_cms_download_register_controls')) {
    add_action('etc_widget_cms_download_register_controls', 'finanzia_widget_cms_download_register_controls', 10, 1);
    function finanzia_widget_cms_download_register_controls($widget)
    {
        // Layout
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'finanzia'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'finanzia' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_download/layout/1.webp'
                        ]
                    ]
                ]
            );
        $widget->end_controls_section();
        // Content Tab Start
        // List Section Start
        $widget->start_controls_section(
            'download_section',
            [
                'label' => esc_html__('Download List', 'finanzia'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

            $repeater = new Repeater();
            $repeater->add_control(
                'icon',
                [
                    'label'   => esc_html__('Icon', 'finanzia'),
                    'type'    => Controls_Manager::ICONS,
                    'default' => [
                        'value'   => [
                            'url' => get_template_directory().'/assets/svgs/core/pdf.svg'
                        ],
                        'library' => 'svg'
                    ],
                    'skin'        => 'inline',
                    'label_block' => false
                ]
            );
            $repeater->add_control(
                'name',
                [
                    'label' => esc_html__('Title', 'finanzia'),
                    'type' => Controls_Manager::TEXT
                ]
            );
            $repeater->add_control(
                'link',
                [
                    'label'   => esc_html__( 'File URL', 'finanzia' ),
                    'type'    => Controls_Manager::URL,
                    'default' => [
                        'url' => '#',
                        'is_external' => true,
                        'nofollow'    => true,
                    ],
                    'description' => esc_html__(' Go to Dashboard -> Media -> Add New Media File -> Upload file -> Copy URL', 'finanzia')
                ]
            );
            /*$repeater->add_control(
                'item',
                [
                    'label' => esc_html__('Item', 'finanzia'),
                    'type' => Controls_Manager::MEDIA,
                    'media_types' => ['image', 'video', 'application/pdf', 'application/doc', 'application/docx'],
                    'default' => [
                        'url' => get_template_directory_uri() . '/assets/doc/CMS-Brochure.pdf',
                    ],
                ]
            );*/
            $widget->add_control(
                'title',
                [
                    'label'   => esc_html__('Title', 'finanzia'),
                    'type'    => Controls_Manager::TEXTAREA,
                    'default' => 'Download Brochure'
                ]
            );
            $widget->add_control(
                'download_lists',
                [
                    'label'       => esc_html__('Download Lists', 'finanzia'),
                    'type'        => Controls_Manager::REPEATER,
                    'fields'      => $repeater->get_controls(),
                    'label_block' => true,
                    'default'     => [
                        [
                            'icon' => [
                                'value'   => [
                                    'url' => get_template_directory().'/assets/svgs/core/pdf.svg'
                                ],
                                'library' => 'svg'
                            ],
                            'name' => 'Our Report 2023',
                            'link' => [
                                'url' => '#',
                                'is_external' => true,
                                'nofollow' => true,
                            ],
                        ],
                        [
                            'name' => 'Company Brochure',
                            'link' => [
                                'url' => '#',
                                'is_external' => true,
                                'nofollow' => true,
                            ],
                        ]
                    ],
                    'title_field' => '{{{ name }}}',
                ]
            );
    $widget->end_controls_section();
    }
}
