<?php
use Elementor\Controls_Manager;
use Elementor\Control_Date_Time;
if (!function_exists('finanzia_widget_cms_countdown_register_controls')) {
    add_action('etc_widget_cms_countdown_register_controls', 'finanzia_widget_cms_countdown_register_controls', 10, 1);
    function finanzia_widget_cms_countdown_register_controls($widget)
    {
        // Layout
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'finanzia'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'finanzia' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_countdown/layout/1.jpg'
                        ],
                        '2' => [
                            'label' => esc_html__( 'Layout 2', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_countdown/layout/2.webp'
                        ]
                    ]
                ]
            );
        $widget->end_controls_section();
        // Countdown Section Start
        $widget->start_controls_section(
            'section_countdown',
            [
                'label' => esc_html__('Countdown', 'finanzia'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $widget->add_control(
            'date',
            [
                'label'       => esc_html__( 'Date', 'finanzia' ),
                'type'        => Controls_Manager::DATE_TIME,
                'label_block' => true,
                'description' => esc_html__( 'Set date count down (Date format: yy/mm/dd)', 'finanzia' ),
            ]
        );
        $widget->end_controls_section(); // Countdown Section End
    }
}
