<?php
use Elementor\Controls_Manager;
use Elementor\Base_Data_Control;
if(!function_exists('finanzia_widget_cms_copyright_register_controls')){
	add_action('etc_widget_cms_copyright_register_controls', 'finanzia_widget_cms_copyright_register_controls', 10, 1);
	function finanzia_widget_cms_copyright_register_controls($widget){
		// Layout Settings
		$widget->start_controls_section(
			'layout_section',
			[
				'label' => esc_html__( 'Copyright', 'finanzia' ),
				'tab' => Controls_Manager::TAB_LAYOUT,
			]
		);
			$widget->add_control(
				'layout',
	            [
	            	'label'   => esc_html__( 'Templates', 'finanzia' ),
		            'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
		            'default' => '1',
		            'options' => [
		                '1' => [
		                    'label' => esc_html__( 'Layout 1', 'finanzia' ),
		                    'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_copyright/layout/1.jpg'
		                ]
		            ]
		        ]
			);
		$widget->end_controls_section();
		// Content Settings
		$widget->start_controls_section(
			'setting_section',
            [
            	'label'    => esc_html__('Settings', 'finanzia'),
            	'tab'      => \Elementor\Controls_Manager::TAB_CONTENT
            ]
		);
		$widget->add_control(
			'copyright_text',
			[
				'label'       => esc_html__('Copyright Text', 'finanzia'),
				'type'        => \Elementor\Controls_Manager::WYSIWYG,
				'description' => esc_html__('Use [[year]] variable to insert current year, [[name]] variable to insert site name.', 'finanzia'),
				'label_block' => true,
				'default' 	  => finanzia_default_copyright_text(),
			]
		);
        
		$widget->end_controls_section();
		// Style
        $widget->start_controls_section(
            'section_style_title',
            [
                'label' => esc_html__('Style', 'finanzia'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );
        	$widget->add_responsive_control(
	            'align',
	            [
	                'label'        => esc_html__( 'Alignment', 'finanzia' ),
	                'type'         => Controls_Manager::CHOOSE,
	                'responsive'   => true,
	                'options'      => [
	                    'start'    => [
	                        'title' => esc_html__( 'Left', 'finanzia' ),
	                        'icon'  => 'eicon-text-align-left',
	                    ],
	                    'center'  => [
	                        'title' => esc_html__( 'Center', 'finanzia' ),
	                        'icon'  => 'eicon-text-align-center',
	                    ],
	                    'end'   => [
	                        'title' => esc_html__( 'Right', 'finanzia' ),
	                        'icon'  => 'eicon-text-align-right',
	                    ],
	                    'justify' => [
	                        'title' => esc_html__( 'Justified', 'finanzia' ),
	                        'icon' => 'eicon-text-align-justify',
	                    ]
	                ],
	                'prefix_class' => 'text%s-'
	            ]
	        );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'text_color',
                'label'     => esc_html__( 'Color', 'finanzia' ),
                'selector' => [
                    '{{WRAPPER}} .cms-title' => 'color: {{VALUE}};',
                ]
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'link_color',
                'label'     => esc_html__( 'Link Color', 'finanzia' ),
                'selectors' => [
	                    '{{WRAPPER}} a' => 'color: {{VALUE}};',
	                ],
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'link_color_hover',
                'label'     => esc_html__( 'Link Color Hover', 'finanzia' ),
                'selectors' => [
	                    '{{WRAPPER}} a:hover' => 'color: {{VALUE}};',
	                ],
            ]);
        $widget->end_controls_section();
	}
}
?>