<?php
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;
if (!function_exists('finanzia_widget_cms_contact_form_register_controls')) {
    add_action('etc_widget_cms_contact_form_register_controls', 'finanzia_widget_cms_contact_form_register_controls', 10, 1);
    function finanzia_widget_cms_contact_form_register_controls($widget)
    {
        $cf7 = get_posts('post_type="wpcf7_contact_form"&numberposts=-1');
        $contact_forms = array();
        if ($cf7) {
            foreach ($cf7 as $cform) {
                $form_ID = substr(get_post_meta($cform->ID, '_hash', true), 0, absint(7)); // Get hash form ID
                //
                $contact_forms[$form_ID] = $cform->post_title;
            }
        } else {
            $contact_forms[0] = esc_html__('No contact forms found', 'finanzia');
        }
        // Layout
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'finanzia'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            finanzia_elementor_colors_opts($widget,[
                'name'  => 'bg_color',
                'label' => esc_html__( 'Background Color', 'finanzia' )
            ]);
            $widget->add_control(
                'bg_backdrop',
                [
                    'label' => esc_html__('Background Style', 'finanzia'),
                    'type'  =>  Controls_Manager::SELECT,
                    'options' => [
                        '' => esc_html__('Default','finanzia'),
                        'cms-backdrop-1' => esc_html__('Backdrop #1','finanzia'),
                        'cms-backdrop-2' => esc_html__('Backdrop #2','finanzia'),
                        'cms-backdrop-3' => esc_html__('Backdrop #3','finanzia'),
                        'cms-backdrop-4' => esc_html__('Backdrop #4','finanzia'),
                    ],
                    'default' => ''
                ]
            );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'finanzia' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_contact_form/layout/1.webp'
                        ],
                        '2' => [
                            'label' => esc_html__( 'Layout 2', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_contact_form/layout/2.webp'
                        ],
                        '3' => [
                            'label' => esc_html__( 'Layout 3', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_contact_form/layout/3.webp'
                        ],
                        '4' => [
                            'label' => esc_html__( 'Layout 4', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_contact_form/layout/4.webp'
                        ],
                        '5' => [
                            'label' => esc_html__( 'Layout 5', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_contact_form/layout/5.webp'
                        ],
                        '-popup' => [
                            'label' => esc_html__( 'Popup', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_contact_form/layout/popup.webp'
                        ]
                    ]
                ]
            );
        $widget->end_controls_section();
        // Content Tab Start

        // Source Section Start
        $widget->start_controls_section(
            'source_section',
            [
                'label' => esc_html__('Form Settings', 'finanzia'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
            $widget->add_control(
                'ctf7_popup_title',
                [
                    'label'       => esc_html__('Popup Field Title', 'finanzia'),
                    'type'        => Controls_Manager::TEXTAREA,
                    'label_block' => true,
                    'separator'   => 'before',
                    'condition'   => [
                        'layout' => ['-popup']
                    ]
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'ctf7_popup_title_color',
                'label'     => esc_html__( 'Pupup Title Color', 'finanzia' ),
                'condition' => [
                    'layout' => ['-popup']
                ]
            ]);
            $widget->add_control(
                'popup_cursor_color',
                [
                    'label'     => esc_html__( 'Pupup Cursor Color', 'finanzia' ),
                    'type'        => Controls_Manager::SELECT,
                    'options'   => [
                        ''      => esc_html__('Default', 'finanzia'),
                        '-white' => esc_html__('White', 'finanzia'),
                        '-black' => esc_html__('Black', 'finanzia')
                    ],
                    'condition' => [
                        'layout' => ['-popup']
                    ]
                ]
            );
            $widget->add_control(
                'ctf7_slug',
                [
                    'label'       => esc_html__('Select Form', 'finanzia'),
                    'type'        => Controls_Manager::SELECT,
                    'options'     => $contact_forms,
                    'label_block' => true,
                    'separator'   => 'before'
                ]
            );
            finanzia_elementor_icon_image_settings($widget, [
                'name'         => 'ctf7_title_icon',
                'group'        => false,
                'icon_default' => []
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'icon_color',
                'label'     => esc_html__( 'Icon Color', 'finanzia' ),
                'condition' => [
                    'ctf7_title_icon[value]!' => '',
                    'ctf7_title_icon_type!'   => ''        
                ]
            ]);
            $widget->add_control(
                'ctf7_small_title',
                [
                    'label'       => esc_html__('Form Small Title', 'finanzia'),
                    'type'        => Controls_Manager::TEXTAREA,
                    'label_block' => true
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'      => 'small_title_color',
                'label'     => esc_html__( 'Color', 'finanzia' ),
                'condition' => [
                    'ctf7_small_title!' => ''
                ]
            ]);
            $widget->add_control(
                'ctf7_title',
                [
                    'label'       => esc_html__('Form Title', 'finanzia'),
                    'type'        => Controls_Manager::TEXTAREA,
                    'label_block' => true
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'      => 'title_color',
                'label'     => esc_html__( 'Color', 'finanzia' ),
                'condition' => [
                    'ctf7_title!' => ''
                ]
            ]);
            $widget->add_control(
                'ctf7_description',
                [
                    'label'       => esc_html__('Form Description', 'finanzia'),
                    'type'        => Controls_Manager::TEXTAREA,
                    'label_block' => true
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'      => 'desc_color',
                'label'     => esc_html__( 'Color', 'finanzia' ),
                'condition' => [
                    'ctf7_description!' => ''
                ]
            ]);
            $widget->add_control(
                'ctf7_note',
                [
                    'label'       => esc_html__('Form Note', 'finanzia'),
                    'description' => esc_html__('Add your note after Submit button', 'finanzia'),
                    'type'        => Controls_Manager::TEXTAREA,
                    'label_block' => true
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'      => 'note_color',
                'label'     => esc_html__( 'Color', 'finanzia' ),
                'condition' => [
                    'ctf7_note!' => ''
                ]
            ]); 
        $widget->end_controls_section();
        // Style
        $widget->start_controls_section(
            'section_style',
            [
                'label' => esc_html__('Form Style', 'finanzia'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            finanzia_elementor_colors_opts($widget,[
                'name'  => 'label_color',
                'label' => esc_html__( 'Label Color', 'finanzia' )
            ]);
            $widget->add_control(
                'form_field_height',
                [
                    'label' => esc_html__('Field Height', 'finanzia'),
                    'type'  => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min'  => 40, 
                            'max'  => 100,
                            'step' => 1
                        ]
                    ],
                    'separator' => 'before'
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'  => 'field_color',
                'label' => esc_html__( 'Field Color', 'finanzia' )
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'  => 'placeholder_color',
                'label' => esc_html__( 'Placeholder Color', 'finanzia' )
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'  => 'field_bg_color',
                'label' => esc_html__( 'Field Background Color', 'finanzia' )
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'  => 'field_border_color',
                'label' => esc_html__( 'Field Border Color', 'finanzia' )
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'  => 'field_border_color_hover',
                'label' => esc_html__( 'Field Border Hover Color', 'finanzia' )
            ]);
            $widget->add_control(
                'form_field_radius',
                [
                    'label' => esc_html__('Field Radius', 'finanzia'),
                    'type'  => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min'  => 0, 
                            'max'  => 100,
                            'step' => 1
                        ]
                    ]
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'      => 'field_border_checkbox_color',
                'label'     => esc_html__( 'Checkbox/Radio Border Color', 'finanzia' ),
                'separator' => 'before'
            ]);
            $widget->add_control(
                'field_select_arrow',
                [
                    'label'   => esc_html__( 'Field Select Arrow', 'finanzia' ),
                    'type'    => Controls_Manager::MEDIA,
                    'label_block' => false
                ]
            );
            $widget->add_control(
                'textarea_height',
                [
                    'label' => esc_html__('Textarea Height', 'finanzia'),
                    'type'  => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min'  => 50, 
                            'max'  => 500,
                            'step' => 1
                        ]
                    ]
                ]
            );
            // button
            $widget->add_control(
                'form_btn_height',
                [
                    'label' => esc_html__('Button Height', 'finanzia'),
                    'type'  => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min'  => 40, 
                            'max'  => 100,
                            'step' => 1
                        ]
                    ],
                    'separator' => 'before'
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'  => 'btn_color',
                'label' => esc_html__( 'Button Color', 'finanzia' )
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'  => 'btn_bg_color',
                'label' => esc_html__( 'Button Background Color', 'finanzia' )
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'  => 'btn_hover_color',
                'label' => esc_html__( 'Button Hover Color', 'finanzia' )
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'  => 'btn_bg_hover_color',
                'label' => esc_html__( 'Button Background Hover Color', 'finanzia' )
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'      => 'invalid_color',
                'label'     => esc_html__( 'Invalid Color', 'finanzia' ),
                'separator' => 'before'
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'  => 'invalid_bg',
                'label' => esc_html__( 'Invalid Background Color', 'finanzia' )
            ]);
        $widget->end_controls_section();
    }
}
?>