<?php
use Elementor\Controls_Manager;
if (!function_exists('finanzia_widget_cms_button_register_controls')) {
    add_action('etc_widget_cms_button_register_controls', 'finanzia_widget_cms_button_register_controls', 10, 1);
    function finanzia_widget_cms_button_register_controls($widget)
    {
        // Layout
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'finanzia'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'finanzia' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_button/layout/1.webp'
                        ],
                        '2' => [
                            'label' => esc_html__( 'Layout 2', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_button/layout/2.webp'
                        ],
                        '3' => [
                            'label' => esc_html__( 'Layout 3', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_button/layout/3.webp'
                        ]
                    ]
                ]
            );
        $widget->end_controls_section();
        // Button Settings
        $widget->start_controls_section(
            'button_section',
            [
                'label' => esc_html__('Button Settings', 'finanzia'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );         
            // Button
            finanzia_elementor_link_settings($widget, [
                'mode'        => 'btn',
                'group'       => false,
                'color_label' => esc_html__('Button', 'finanzia'),
                'text'        => 'Click Here',
                'condition'   => [
                    'layout' => ['1','2']
                ]
            ]);
            // Link
            finanzia_elementor_link_settings($widget, [
                'name'        => 'link2_',  
                'mode'        => '',
                'group'       => false,
                'text'        => 'Click Here',
                'condition'   => [
                    'layout' => ['3']
                ]
            ]);
            //
            $widget->add_responsive_control(
                'align',
                [
                    'label'        => esc_html__( 'Alignment', 'finanzia' ),
                    'type'         => Controls_Manager::CHOOSE,
                    'responsive'   => true,
                    'options'      => [
                        'start'    => [
                            'title' => esc_html__( 'Left', 'finanzia' ),
                            'icon'  => 'eicon-text-align-left',
                        ],
                        'center'  => [
                            'title' => esc_html__( 'Center', 'finanzia' ),
                            'icon'  => 'eicon-text-align-center',
                        ],
                        'end'   => [
                            'title' => esc_html__( 'Right', 'finanzia' ),
                            'icon'  => 'eicon-text-align-right',
                        ],
                        'justify' => [
                            'title' => esc_html__( 'Justified', 'finanzia' ),
                            'icon' => 'eicon-text-align-justify',
                        ]
                    ],
                    'prefix_class' => 'text%s-'
                ]
            );
            $widget->add_control(
                'size',
                [
                    'label'        => esc_html__( 'Size', 'finanzia' ),
                    'type'         => Controls_Manager::SELECT,
                    'options'      => [
                        'btn-xs' => esc_html__('Extra Small','finanzia'),
                        'btn-sm' => esc_html__('Small','finanzia'),
                        ''       => esc_html__('Default','finanzia'),
                        'btn-md' => esc_html__('Medium','finanzia'),
                        'btn-lg' => esc_html__('Large','finanzia'),
                        'btn-xl' => esc_html__('Extra Large','finanzia'),

                    ],
                    'condition' => [
                        'layout!' => '3'
                    ]
                ]
            );
            $widget->add_control(
                'btn_icon',
                [
                    'label'       => esc_html__( 'Icon', 'finanzia' ),
                    'type'        => Controls_Manager::ICONS,
                    'skin'        => 'inline',
                    'skin_settings'    => [
                        'inline' => [
                            'icon' => [
                                'url' => get_template_directory().'/assets/svgs/core/long-arrow-right.svg',
                            ]
                        ]
                    ],
                    'default'     => [
                        'value'   => [
                            'url' => get_template_directory().'/assets/svgs/core/long-arrow-right.svg'
                        ],
                        'library' => 'svg'
                    ],
                    'label_block' => false  
                ]
            );
            $widget->add_control(
                'icon_align',
                [
                    'label'     => esc_html__( 'Icon Position', 'finanzia' ),
                    'type'      => Controls_Manager::SELECT,
                    'default'   => '',
                    'options'   => [
                        ''      => esc_html__( 'Default', 'finanzia' ),
                        'first' => esc_html__( 'Before', 'finanzia' ),
                        'last'  => esc_html__( 'After', 'finanzia' ),
                    ],
                    'condition' => [
                        'btn_icon[value]!' => ''
                    ]
                ]
            );
            $widget->add_control(
                'icon_font_size',
                [
                    'label'        => esc_html__( 'Icon Font Size', 'finanzia' ),
                    'type'         => Controls_Manager::SLIDER,
                    'control_type' => 'responsive',
                    'size_units'   => [ 'px' ],
                    'range'        => [
                        'px' => [
                            'min' => 5,
                            'max' => 100,
                        ],
                    ],
                    'selectors'    => [
                        '{{WRAPPER}} .cms-btn-icon' => 'font-size: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .cms-btn-icon svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'btn_icon[value]!' => ''
                    ]
                ]
            );
        $widget->end_controls_section();
    }
}
