<?php
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
if (!function_exists('finanzia_widget_cms_blog_register_controls')) {
    add_action('etc_widget_cms_blog_register_controls', 'finanzia_widget_cms_blog_register_controls', 10, 1);
    function finanzia_widget_cms_blog_register_controls($widget)
    {
        // Layout Settings
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'finanzia' ),
                'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__('Templates', 'finanzia' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_blog/layout/1.webp'
                        ]
                    ]
                ]
            );
        $widget->end_controls_section();
        // Source Section Start
        $post_term_options = etc_get_grid_term_options('post', ['category']);
        $widget->start_controls_section(
            'source_section',
            [
                'label' => esc_html__('Source Settings', 'finanzia'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $widget->add_control(
            'source',
            [
                'label' => esc_html__('Select Categories', 'finanzia'),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $post_term_options,
            ]
        );
        $widget->add_control(
            'orderby',
            [
                'label'   => esc_html__('Order By', 'finanzia'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => [
                    'date'   => esc_html__('Date', 'finanzia'),
                    'ID'     => esc_html__('ID', 'finanzia'),
                    'author' => esc_html__('Author', 'finanzia'),
                    'title'  => esc_html__('Title', 'finanzia'),
                    'rand'   => esc_html__('Random', 'finanzia'),
                ],
            ]
        );
        $widget->add_control(
            'order',
            [
                'label'   => esc_html__('Sort Order', 'finanzia'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'desc',
                'options' => [
                    'desc' => esc_html__('Descending', 'finanzia'),
                    'asc'  => esc_html__('Ascending', 'finanzia'),
                ],
            ]
        );
        $widget->add_control(
            'limit',
            [
                'label'   => esc_html__('Total items', 'finanzia'),
                'type'    => Controls_Manager::NUMBER
            ]
        );
        $widget->end_controls_section();
        // Heading Content
        $widget->start_controls_section(
            'heading_section',
            [
                'label'     => esc_html__('Heading Settings', 'finanzia'),
                'tab'       => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout' => ['1']
                ]
            ]
        );  
            $widget->add_control(
                'heading_text',
                [
                    'label'       => esc_html__( 'Heading', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'This is the heading',
                    'placeholder' => esc_html__( 'Enter your text', 'finanzia' ),
                    'label_block' => true
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'      => 'heading_color',
                'label'     => esc_html__( 'Color', 'finanzia' ),
                'condition' => [
                    'heading_text!' => ''
                ]
            ]);
            // Link
            finanzia_elementor_link_settings($widget, [
                'mode'        => '',
                'group'       => false,
                //'color_label' => esc_html__('Button', 'finanzia'),
                'text'        => ''
            ]);
        $widget->end_controls_section();
    }
}
