<?php
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;
use Elementor\Repeater;

if (!function_exists('finanzia_widget_cms_banner_register_controls')) {
    add_action('etc_widget_cms_banner_register_controls', 'finanzia_widget_cms_banner_register_controls', 10, 1);
    function finanzia_widget_cms_banner_register_controls($widget)
    {
        // Layout
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'finanzia'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'finanzia' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_banner/layout/1.jpg'
                        ],
                        '2' => [
                            'label' => esc_html__( 'Layout 2', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_banner/layout/2.webp'
                        ],
                        '3' => [
                            'label' => esc_html__( 'Layout 3', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_banner/layout/3.webp'
                        ],
                        '-4' => [
                            'label' => esc_html__( 'Layout 4', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_banner/layout/4.webp'
                        ],
                        '-5' => [
                            'label' => esc_html__( 'Layout 5', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_banner/layout/5.webp'
                        ],
                        '-6' => [
                            'label' => esc_html__( 'Layout 6', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_banner/layout/6.webp'
                        ],
                        '-7' => [
                            'label' => esc_html__( 'Layout 7', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_banner/layout/7.webp'
                        ],
                        '-single-industry' => [
                            'label' => esc_html__( 'Layout Single Industry', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_banner/layout/single-industry.webp'
                        ]
                    ]
                ]
            );
        $widget->end_controls_section();
        // Banner
        $widget->start_controls_section(
            'section_single_image',
            [
                'label' => esc_html__('Banner Image', 'finanzia'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
            $widget->add_control(
                'banner',
                [
                    'label'   => esc_html__( 'Banner', 'finanzia' ),
                    'type'    => Controls_Manager::MEDIA,
                    'default' => [
                        'url' => Utils::get_placeholder_image_src()
                    ]
                ]
            );
            $widget->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name'      => 'banner',
                    'label'     => esc_html__('Image Size','finanzia'),
                    'default'   => 'medium',
                    'condition' => [
                        'banner[url]!' => ''
                    ]
                ]
            );
            $widget->add_control(
                'banner_small',
                [
                    'label'   => esc_html__( 'Banner Small', 'finanzia' ),
                    'type'    => Controls_Manager::MEDIA,
                    'default' => [
                        'url' => Utils::get_placeholder_image_src()
                    ],
                    'condition' => [
                        'layout' => '2'
                    ]
                ]
            );
            $widget->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name'      => 'banner_small',
                    'label'     => esc_html__('Image Size','finanzia'),
                    'default'   => 'custom',
                    'condition' => [
                        'layout'             => '2',
                        'banner_small[url]!' => ''
                    ]
                ]
            );
        $widget->end_controls_section();
        finanzia_elementor_animation_settings($widget);
        // Content
        $widget->start_controls_section(
            'section_content',
            [
                'label' => esc_html__('Content Settings', 'finanzia'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
            // Icon
            finanzia_elementor_icon_image_settings($widget, [
                'group'     => false,
                'condition' => [
                    'layout' => []
                ]
            ]);
            // Small Heading
            $widget->add_control(
                'smallheading_text',
                [
                    'label'       => esc_html__( 'Small Heading', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'This is small heading',
                    'placeholder' => esc_html__( 'Enter your text', 'finanzia' ),
                    'label_block' => true,
                    'condition' => [
                        'layout' => ['2']
                    ]
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'smallheading_color',
                'label'     => esc_html__( 'Color', 'finanzia' ),
                'condition' => [
                    'layout'             => ['2'],
                    'smallheading_text!' => ''
                ]
            ]);
            // Heading
            $widget->add_control(
                'heading_text',
                [
                    'label'       => esc_html__( 'Heading', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'This is the heading',
                    'placeholder' => esc_html__( 'Enter your text', 'finanzia' ),
                    'label_block' => true,
                    'condition'   => [
                        'layout' => ['3','7','-single-industry']
                    ]
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'heading_color',
                'label'    => esc_html__( 'Color', 'finanzia' ),
                'condition' => [
                    'layout' => ['3','7','-single-industry'],
                    'heading_text!' => ''
                ]
            ]);
            // Description
            $widget->add_control(
                'description_text',
                [
                    'label'       => esc_html__( 'Description', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour', 
                    'placeholder' => esc_html__( 'Enter your text', 'finanzia' ),
                    'rows'        => 10,
                    'show_label'  => true,
                    'condition' => [
                        'layout' => ['3','-single-industry']
                    ]
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'description_color',
                'label'     => esc_html__( 'Color', 'finanzia' ),
                'condition' => [
                    'layout' => ['3','-single-industry'],
                    'description_text!' => ''
                ]
            ]);
            // Background
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'bg_color',
                'label'     => esc_html__( 'Background Color', 'finanzia' ),
                'condition' => [
                    'layout' => ['']
                ],
                'separator' => 'before'
            ]);
            // Divider
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'divider_color',
                'label'     => esc_html__( 'Divider Color', 'finanzia' ),
                'condition' => [
                    'layout' => []
                ]
            ]);
            // Pointers Settings
            $pointer = new Repeater();
                $pointer->add_control(
                    'banner',
                    [
                        'label'       => esc_html__('Banner', 'finanzia'),
                        'type'        => Controls_Manager::MEDIA,
                        'label_block' => false,
                        'default'     => []
                    ]
                );
                $pointer->add_control(
                    'title',
                    [
                        'label'       => esc_html__('Title', 'finanzia'),
                        'type'        => Controls_Manager::TEXTAREA,
                        'label_block' => true,
                        'default'     => 'Your Title'
                    ]
                );
                $pointer->add_control(
                    'desc',
                    [
                        'label'       => esc_html__('Description', 'finanzia'),
                        'type'        => \Elementor\Controls_Manager::TEXTAREA,
                        'label_block' => true,
                        'default'     => 'Lorem Ipsum is simply dummy text of the printing and typesetting story.'  
                    ]
                );
                finanzia_elementor_link_settings($pointer, [
                    'name'    => 'link1_',
                    'group'   => false,
                    'color'   => false,
                    'type'    => [
                        'cms-service' => esc_html__('Service', 'finanzia'),
                        'cms-industry' => esc_html__('Industry', 'finanzia')
                    ]
                ]);
                $pointer->add_responsive_control(
                    'postion',
                    [
                        'label'              => esc_html__('Item Postion', 'finanzia' ),
                        'type'               => Controls_Manager::DIMENSIONS,
                        'allowed_dimensions' => ['top', 'left'],
                        'size_units'         => [ '%' ],
                        'range' => [
                            '%' => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],
                        'default' => [
                            'unit' => '%',
                            'top'  => '10',
                            'left' => '10'
                        ],
                        'selectors' => [
                            '{{WRAPPER}} {{CURRENT_ITEM}}.cms-pointer-item' => 'top: {{TOP}}{{UNIT}};left: {{LEFT}}{{UNIT}}',
                        ],
                        'separator' => 'before',
                        'classes'   => 'cms-eseparator'
                    ]
                );
            // add Pointers item
            $widget->add_control(
                'active_pointer',
                [
                    'label'     => esc_html__( 'Active Pointer', 'finanzia' ),
                    'type'      => Controls_Manager::NUMBER,
                    'default'   => 1,
                    'separator' => 'after',
                    'condition' => [
                        'layout' => ['5']
                    ]
                ]
            );
            $widget->add_control(
                'cms_pointers',
                [
                    'label'  => esc_html__('Pointers List', 'finanzia'),
                    'type'   => Controls_Manager::REPEATER,
                    'fields' => $pointer->get_controls(),
                    'default' => [
                        [
                            'title'      => 'Your Title Here',
                            'address'    => 'Lorem Ipsum is simply dummy text of the printing and typesetting story.',
                            'link1_text' => 'Explore More',
                            'postion'    => [
                                'unit' => '%',
                                'top'  => '18',
                                'left' => '32'
                            ]
                        ]
                    ],
                    'title_field' => '{{{ title }}}',
                    'label_block' => true,
                    'condition'   => [
                        'layout' => ['5']
                    ]
                ]
            );
        $widget->end_controls_section();
        // Circle Text
        finanzia_elementor_circle_text_settings($widget, [
            'link'      => true,
            'condition' => [
                'layout' => ['4']
            ]
        ]);
        // Style Settings
        $widget->start_controls_section(
            'style_section',
            [
                'label'     => esc_html__('Banner Settings','finanzia'),
                'tab'       => Controls_Manager::TAB_SETTINGS
            ]
        );
            $widget->add_control(
                'as_background',
                [
                    'label'       => esc_html__('As Background', 'finanzia'),
                    'description' => esc_html__('Make your banner show as background', 'finanzia'),
                    'type'        => Controls_Manager::SWITCHER,
                    'return_value'=> 'yes' ,
                    'condition' => [
                        'layout' => ['1']
                    ],
                    'separator' => 'before',
                    'classes'   => 'cms-eseparator'
                ]
            );
            $widget->add_control(
                'bg_pos',
                [
                    'label'       => esc_html__('Background Position', 'finanzia'),
                    'type'        => Controls_Manager::SELECT,
                    'options'     => [
                        ''              => esc_html__('Default', 'finanzia'),
                        'bg-center'     => esc_html__('Center', 'finanzia'),
                        'bg-top-center' => esc_html__('Top Center', 'finanzia')
                    ],
                    'condition' => [
                        'layout'        => ['1'],
                        'as_background' => ['yes']
                    ]
                ]
            );
            $widget->add_control(
                'max_height',
                [
                    'label'        => esc_html__('Max Height', 'finanzia'),
                    'description'  => esc_html__('Add image max-height', 'finanzia'),
                    'type'         => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'condition'    => [
                        'layout' => ['1']
                    ]
                ]
            );
        $widget->end_controls_section();
    }
}
