<?php
use Elementor\Controls_Manager;
use \Elementor\Icons_Manager;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
// Register Elementor Widgets through plugin core
if (!function_exists('finanzia_elementor_register_widgets')) {
    add_filter('etc_register_widgets', 'finanzia_elementor_register_widgets');
    function finanzia_elementor_register_widgets($widgets)
    {
        $widgets = [
            [ // Cms Accordion
                'name'       => 'cms_accordion',
                'title'      => esc_html__('CMS Accordion', 'finanzia'),
                'icon'       => 'eicon-accordion',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [
                    'cms-elementor-custom'
                ],
                'keywords' => [
                    'finanzia', 'cms accordion', 'accordion'
                ]
            ],
            [ // Cms Banner
                'name'       => 'cms_banner',
                'title'      => esc_html__('CMS Banner', 'finanzia'),
                'icon'       => 'eicon-banner',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'finanzia', 'banner', 'image'
                ],
                'scripts'   => [
                    'cms-elementor-custom'
                ]
            ],
            [ // Cms Blog
                'name'       => 'cms_blog',
                'title'      => esc_html__('CMS Blog', 'finanzia'),
                'icon'       => 'eicon-posts-group',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [
                    'cms-elementor-custom'
                ],
                'keywords' => [
                    'finanzia', 'cms blog',' blog', 'post'
                ]
            ],
            [ // Cms Blog Carousel
                'name'       => 'cms_blog_carousel',
                'title'      => esc_html__('CMS Blog Carousel', 'finanzia'),
                'icon'       => 'eicon-posts-carousel',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [
                    'cms-elementor-custom',
                    'cms-post-carousel-widget-js',
                ],
                'styles' => [
                    'swiper'
                ],
                'keywords' => [
                    'finanzia', 'blog', 'post', 'carousel'
                ]
            ],
            [ // Cms Blog Grid
                'name'       => 'cms_blog_grid',
                'title'      => esc_html__('CMS Blog Grid', 'finanzia'),
                'icon'       => 'eicon-posts-grid',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [
                    'cms-elementor-custom'
                ],
                'keywords' => [
                    'finanzia', 'blog', 'post', 'grid'
                ]
            ],
            
            [ // Cms Breadcrumb
                'name'       => 'cms_breadcrumb',
                'title'      => esc_html__('CMS Breadcrumb', 'finanzia'),
                'icon'       => 'eicon-ellipsis-h',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'finanzia', 'breadcrumb'
                ]
            ],
            [ // Cms Button
                'name'       => 'cms_button',
                'title'      => esc_html__('CMS Button', 'finanzia'),
                'icon'       => 'eicon-button',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords' => [
                    'finanzia', 'cms button', 'button'
                ]
            ],
            [ // CMS Chart
                'name'       => 'cms_chart',
                'title'      => esc_html__('CMS Chart', 'finanzia'),
                'icon'       => 'eicon-circle-o',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'finanzia', 'cms chart', 'chart', 'chartjs'
                ],
                'scripts'    => array(
                    'chartjs',
                    'cms-chartjs',
                    'cms-elementor-custom'
                )
            ],
            [ // CMS Chart Line
                'name'       => 'cms_chart_line',
                'title'      => esc_html__('CMS Chart Line', 'finanzia'),
                'icon'       => 'eicon-product-upsell',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'finanzia', 'cms chart', 'chart', 'chartjs'
                ],
                'scripts'    => array(
                    'chartjs',
                    'cms-chartjs',
                    'cms-elementor-custom'
                )
            ],
            [ // Cms Clients Carousel
                'name'       => 'cms_clients',
                'title'      => esc_html__('CMS Clients', 'finanzia'),
                'icon'       => 'eicon-person',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [
                    'cms-elementor-custom',
                    'cms-post-carousel-widget-js',
                ],
                'styles' => [
                    'swiper'
                ],
                'keywords' => [
                    'cms', 'finanzia', 'client', 'clients', 'carousel'
                ]
            ],
            [ // Cms Copyright
                'name'       => 'cms_copyright',
                'title'      => esc_html__('CMS Copyright', 'finanzia'),
                'icon'       => 'eicon-menu-bar',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'finanzia', 'cms copyright', 'copyright'
                ]
            ],
            [ // Cms Countdown
                'name'       => 'cms_countdown',
                'title'      => esc_html__('CMS Countdown', 'finanzia'),
                'icon'       => 'eicon-countdown',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [
                    'cms-elementor-custom'
                ],
                'keywords'   => [
                    'finanzia', 'cms countdown', 'countdown'
                ]
            ],
            [ // Cms Counter
                'name'       => 'cms_counter',
                'title'      => esc_html__('CMS Counter', 'finanzia'),
                'icon'       => 'eicon-counter-circle',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [
                    'jquery-numerator',
                    'cms-elementor-custom',
                    'cms-post-carousel-widget-js'
                ],
                'styles' => [
                    'swiper'
                ],
                'keywords'   => [
                    'finanzia', 'cms counter', 'counter'
                ]
            ],
            [ // Cms Call to Action
                'name'       => 'cms_cta',
                'title'      => esc_html__('CMS Call To Action', 'finanzia'),
                'icon'       => 'eicon-image-rollover',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [
                    'cms-elementor-custom'
                ],
                'keywords'   => [
                    'finanzia', 'cms', 'call action', 'call', 'button'
                ]
            ],
            [ // Cms Download
                'name'       => 'cms_download',
                'title'      => esc_html__('CMS Download', 'finanzia'),
                'icon'       => 'eicon-file-download',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [],
                'styles'     => [],
                'keywords'   => [
                    'finanzia', 'download'
                ]
            ],
            [ // Cms Fancy Box
                'name'       => 'cms_fancy_box',
                'title'      => esc_html__('CMS Fancy Box', 'finanzia'),
                'icon'       => 'eicon-icon-box',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [
                    'cms-elementor-custom',
                    'cms-post-carousel-widget-js'
                ],
                'styles' => [
                    'swiper'
                ],
                'keywords'   => [
                    'finanzia', 'fancy-box', 'fancy', 'box'
                ]
            ],
            [ // CMS Gallery
                'name'       => 'cms_gallery',
                'title'      => esc_html__('CMS Gallery', 'finanzia'),
                'icon'       => 'eicon-gallery-grid',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'finanzia', 'cms gallery', 'gallery', 'image',
                ],
                'scripts' => [
                    'cms-elementor-custom',
                    'cms-galleries'
                ]
            ],
            [ // CMS Google Map
                'name'       => 'cms_google_map',
                'title'      => esc_html__('CMS Google Map', 'finanzia'),
                'icon'       => 'eicon-google-maps',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'finanzia', 'cms map', 'cms', 'map'
                ]
            ],
            [ // Cms Heading
                'name'       => 'cms_heading',
                'title'      => esc_html__('CMS Heading', 'finanzia'),
                'icon'       => 'eicon-heading',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'finanzia', 'heading', 'custom heading'
                ],
                'scripts'    => [
                    'jquery-numerator',
                    'cms-elementor-custom',
                ]
            ],
            [ // Cms Navigation Menu
                'name'       => 'cms_navigation_menu',
                'title'      => esc_html__('CMS Menu', 'finanzia'),
                'icon'       => 'eicon-menu-bar',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'finanzia', 'cms navigation menu', 'menu'
                ]
            ],
            [ // Cms Lists
                'name'       => 'cms_lists',
                'title'      => esc_html__('CMS Lists', 'finanzia'),
                'icon'       => 'eicon-bullet-list',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'finanzia', 'cms lists', 'list'
                ]
            ],
            [ // Cms Page Title
                'name'       => 'cms_page_title',
                'title'      => esc_html__('CMS Page Title', 'finanzia'),
                'icon'       => 'eicon-archive-title',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'finanzia', 'cms page title', 'page title', 'title'
                ]
            ],
            [ // Cms Post Feature
                'name'       => 'cms_post_feature',
                'title'      => esc_html__('CMS Post Feature', 'finanzia'),
                'icon'       => 'eicon-featured-image',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'finanzia', 'cms post feature', 'post title', 'title'
                ]
            ],
            [ // Cms Pricing
                'name'       => 'cms_pricing',
                'title'      => esc_html__('CMS Pricing', 'finanzia'),
                'icon'       => 'eicon-price-table',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [
                    'jquery-numerator',
                    'cms-elementor-custom',
                    'cms-post-carousel-widget-js',
                ],
                'styles' => [
                    'swiper'
                ],
                'keywords' => [
                    'finanzia', 'cms pricing', 'pricing', 'price'
                ]
            ],
            [ // Cms Process
                'name'       => 'cms_process',
                'title'      => esc_html__('CMS Process', 'finanzia'),
                'icon'       => 'eicon-counter',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'finanzia', 'cms process', 'process'
                ],
                'scripts'   => [
                    // 'jquery-numerator',
                    // 'gsap',
                    // 'gsap-split-text',
                    // 'cms-elementor-custom'
                    'etc-scroller',
                    'cms-process-widget-js'
                ]
            ],
            [ // Cms Process Carousel
                'name'       => 'cms_process_carousel',
                'title'      => esc_html__('CMS Process Carousel', 'finanzia'),
                'icon'       => 'eicon-counter',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'finanzia', 'cms process', 'process', 'carousel'
                ],
                'scripts'   => [
                    'cms-post-carousel-widget-js'
                ],
                'styles' => [
                    'swiper'
                ]
            ],
            [ // Cms Process Slider
                'name'       => 'cms_process_slider',
                'title'      => esc_html__('CMS Process Slider', 'finanzia'),
                'icon'       => 'eicon-counter',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'finanzia', 'cms process', 'process', 'slider'
                ],
                'scripts'   => [
                    'etc-scroller',
                    'cms-process-slider-widget-js'
                ]
            ],
            [ // Cms Progress
                'name'       => 'cms_progress',
                'title'      => esc_html__('CMS Progress', 'finanzia'),
                'icon'       => 'eicon-skill-bar',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'finanzia', 'cms Progress', 'Progress'
                ],
                'scripts'   => [
                    'jquery-numerator',
                    'cms-elementor-custom'
                ]
            ],
            [ // CMS Quick Contact
                'name'       => 'cms_quickcontact',
                'title'      => esc_html__('CMS Quick Contact', 'finanzia'),
                'icon'       => 'eicon-mail',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'finanzia', 'cms quick contact', 'quick', 'contact',
                ]
            ],
            [ // CMS Search
                'name'       => 'cms_search',
                'title'      => esc_html__('CMS Search', 'finanzia'),
                'icon'       => 'eicon-site-search',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'finanzia', 'cms search', 'cms', 'search',
                ]
            ],
            [ // Cms Slider
                'name'       => 'cms_slider',
                'title'      => esc_html__('CMS Slider', 'finanzia'),
                'icon'       => 'eicon-slides',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [
                    'cms-elementor-custom',
                    'cms-post-carousel-widget-js'
                ],
                'styles' => [
                    'swiper'
                ],
                'keywords' => [
                    'finanzia', 'cms slider', 'slider'
                ]
            ],
            [ // CMS Socials Icons
                'name'       => 'cms_social_icons',
                'title'      => esc_html__('CMS Socials Icon', 'finanzia'),
                'icon'       => 'eicon-social-icons',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'finanzia', 'cms social', 'icon', 'social icon',
                ]
            ],
            [ // Cms Tabs
                'name'       => 'cms_tabs',
                'title'      => esc_html__('CMS Tabs', 'finanzia'),
                'icon'       => 'eicon-tabs',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [
                    'jquery-numerator',
                    'cms-elementor-custom',
                ],
                'keywords' => [
                    'cms', 'finanzia', 'tab'
                ]
            ],
            [ // Cms Teams (Grid + Carousel)
                'name'       => 'cms_teams',
                'title'      => esc_html__('CMS Teams', 'finanzia'),
                'icon'       => 'eicon-user-circle-o',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [
                    'cms-elementor-custom',
                    'cms-post-carousel-widget-js',
                ],
                'styles' => [
                    'swiper'
                ],
                'keywords' => [
                    'cms', 'finanzia', 'team', 'teams', 'grid', 'carousel'
                ]
            ],
            [ // Cms Testimonial
                'name'       => 'cms_testimonials',
                'title'      => esc_html__('CMS Testimonials', 'finanzia'),
                'icon'       => 'eicon-testimonial',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [
                    'cms-elementor-custom',
                    'cms-post-carousel-widget-js',
                ],
                'styles' => [
                    'swiper'
                ],
                'keywords' => [
                    'cms', 'finanzia', 'testimonial', 'testimonials', 'carousel'
                ]
            ],
            [ // Cms Text Scroll
                'name'       => 'cms_text_scroll',
                'title'      => esc_html__('CMS Text Scroll', 'finanzia'),
                'icon'       => 'eicon-scroll',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [
                    'gsap',
                    'cms-elementor-custom'
                ],
                'keywords'   => [
                    'cms', 'finanzia', 'text scroll', 'scroll'
                ]
            ],
            [ // Cms Video
                'name'       => 'cms_video_player',
                'title'      => esc_html__('CMS Video Player', 'finanzia'),
                'icon'       => 'eicon-play',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'finanzia', 'cms video player', 'video'
                ],
                'scripts'    => [
                    'cms-elementor-custom',
                    'youtube-iframe-api-js',
                    'cms-video-widget-js',
                ]
            ],
            // Theme
            [ // Cms Theme Accordion
                'name'       => 'cms_theme_accordion_sticky',
                'title'      => esc_html__('Finanzia Accordion Sticky', 'finanzia'),
                'icon'       => 'eicon-accordion',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [
                    'etc-scroller',
                    'cms-accordion-sticky-widget-js'
                ],
                'keywords' => [
                    'finanzia', 'cms accordion', 'accordion', 'sticky'
                ]
            ],
            [ // Cms Theme Counter Sticky
                'name'       => 'cms_theme_counter_sticky',
                'title'      => esc_html__('CMS Counter Sticky', 'finanzia'),
                'icon'       => 'eicon-counter-circle',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [
                    'jquery-numerator',
                    'cms-elementor-custom',
                ],
                'keywords'   => [
                    'finanzia', 'theme', 'cms counter sticky', 'counter sticky', 'counter', 'sticky'
                ]
            ],
            [ // Cms Process Sticky
                'name'       => 'cms_theme_process_sticky',
                'title'      => esc_html__('Finanzia Process Sticky', 'finanzia'),
                'icon'       => 'eicon-counter',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'finanzia', 'cms process', 'process'
                ],
                'scripts'   => [
                    'gsap',
                    'gsap-sticky-scroll'
                ]
            ],
            [ // Cms Service Scroll
                'name'       => 'cms_theme_service_scroll',
                'title'      => esc_html__('Finanzia Service Scroll', 'finanzia'),
                'icon'       => 'eicon-counter',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'finanzia', 'cms service', 'scroll'
                ],
                'scripts'   => [
                    'etc-scroller',
                    'cms-service-scroll-widget-js',
                ]
            ],
            [ // Cms Theme Team
                'name'       => 'cms_theme_teams',
                'title'      => esc_html__('Finanzia Team', 'finanzia'),
                'icon'       => 'eicon-user-circle-o',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'finanzia', 'cms team', 'team'
                ],
                'scripts'    => [
                    'cms-hover'
                ]
            ],
            [ // Cms Theme Process Scroll
                'name'       => 'cms_theme_process_scroll',
                'title'      => esc_html__('Finanzia Process Scroll', 'finanzia'),
                'icon'       => 'eicon-counter',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords'   => [
                    'finanzia', 'cms process scroll', 'process', 'scroll'
                ],
                'scripts'    => [
                    'swiper',
                    'cms-theme-process-scroll'
                ]
            ]
        ];
        // Custom Post type
        if(apply_filters('finanzia_enable_career', false)){
            $widgets[] = [ // Cms Career Grid
                'name'       => 'cms_career_grid',
                'title'      => esc_html__('CMS Career Grid', 'finanzia'),
                'icon'       => 'eicon-posts-grid',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [
                ],
                'keywords' => [
                    'finanzia', 'career', 'grid'
                ]
            ];
            $widgets[] = [ // Cms Career Carousel
                'name'       => 'cms_career_carousel',
                'title'      => esc_html__('CMS Career Carousel', 'finanzia'),
                'icon'       => 'eicon-posts-carousel',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [
                    'cms-elementor-custom',
                    'cms-post-carousel-widget-js',
                ],
                'styles' => [
                    'swiper'
                ],
                'keywords' => [
                    'finanzia', 'career', 'carousel'
                ]
            ];
        }
        if(apply_filters('finanzia_enable_case', false)){
            $widgets[] = [ // Cms Case Carousel
                'name'       => 'cms_case_carousel',
                'title'      => esc_html__('CMS Case Carousel', 'finanzia'),
                'icon'       => 'eicon-posts-carousel',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [
                    'cms-elementor-custom',
                    'cms-post-carousel-widget-js',
                ],
                'styles' => [
                    'swiper'
                ],
                'keywords' => [
                    'finanzia', 'case', 'carousel'
                ]
            ];
            $widgets[] = [ // Cms Case Grid
                'name'       => 'cms_case_grid',
                'title'      => esc_html__('CMS Case Grid', 'finanzia'),
                'icon'       => 'eicon-posts-grid',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords' => [
                    'finanzia', 'case', 'grid'
                ],
                'scripts'    => [
                    'cms-hover'
                ]
            ];
        }
        // Custom Post type Service
        if(apply_filters('finanzia_enable_service', false)){
            $widgets[] = [ // Cms Service Carousel
                'name'       => 'cms_service_carousel',
                'title'      => esc_html__('CMS Service Carousel', 'finanzia'),
                'icon'       => 'eicon-posts-carousel',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [
                    'cms-elementor-custom',
                    'cms-post-carousel-widget-js',
                ],
                'styles' => [
                    'swiper'
                ],
                'keywords' => [
                    'finanzia', 'service', 'carousel'
                ]
            ];
            $widgets[] = [ // Cms Service Grid
                'name'       => 'cms_service_grid',
                'title'      => esc_html__('CMS Service Grid', 'finanzia'),
                'icon'       => 'eicon-posts-grid',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords' => [
                    'finanzia', 'service', 'grid'
                ]
            ];
        }
        // Custom Post type Industry
        if(apply_filters('finanzia_enable_industry', false)){
            $widgets[] = [ // Cms Industry Carousel
                'name'       => 'cms_industry_carousel',
                'title'      => esc_html__('CMS Industry Carousel', 'finanzia'),
                'icon'       => 'eicon-posts-carousel',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [
                    'cms-elementor-custom',
                    'cms-post-carousel-widget-js',
                ],
                'styles' => [
                    'swiper'
                ],
                'keywords' => [
                    'finanzia', 'story', 'carousel'
                ]
            ];
            $widgets[] = [ // Cms Industry Grid
                'name'       => 'cms_industry_grid',
                'title'      => esc_html__('CMS Industry Grid', 'finanzia'),
                'icon'       => 'eicon-posts-grid',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'keywords' => [
                    'finanzia', 'story', 'grid'
                ]
            ];
        }
        // Contact Form 7
        if (class_exists('WPCF7')) {
            $widgets[] = [
                'name'       => 'cms_contact_form',
                'title'      => esc_html__('CMS Contact Form 7', 'finanzia'),
                'icon'       => 'eicon-form-horizontal',
                'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
                'scripts'    => [
                    'cms-elementor-custom'
                ],
                'styles'     => [],
                'keywords'   => [
                    'cms', 'finanzia', 'contact-form', 'form', 'contact'
                ]
            ];
        }
        // Newsletter
        if(class_exists('Newsletter')){
            $widgets[] = [
                'name'       => 'cms_newsletter',
                'title'      => esc_html__( 'CMS Newsletter', 'finanzia' ),
                'icon'       => 'eicon-mail',
                'categories' => array( Elementor_Theme_Core::ETC_CATEGORY_NAME ),
                'scripts'    => [
                    'cms-elementor-custom',
                ],
                'keywords'   => [
                    'cms', 'finanzia', 'newsletter'
                ]
            ];
        }
        // Language Swicther
        if(class_exists('TRP_Translate_Press')){
            $widgets[] = [
                'name'       => 'cms_language_switcher',
                'title'      => esc_html__( 'CMS Language Switcher', 'finanzia' ),
                'icon'       => 'eicon-exchange',
                'categories' => array( Elementor_Theme_Core::ETC_CATEGORY_NAME ),
                'scripts'    => [
                    'cms-elementor-custom'
                ],
                'keywords'   => [
                    'cms', 'finanzia', 'language', 'language switcher'
                ]
            ];
        }
        return $widgets;
    }
}
if(!function_exists('finanzia_add_hidden_device_controls')){
    function finanzia_add_hidden_device_controls($widget = [], $args = []) {
        $args = wp_parse_args($args, [
            'prefix'    => 'cms_',
            'condition' => []
        ]);
        // The 'Hide On X' controls are displayed from largest to smallest, while the method returns smallest to largest.
        $active_devices = \Elementor\Plugin::$instance->breakpoints->get_active_devices_list( [ 'reverse' => true ] );
        $active_breakpoints = \Elementor\Plugin::$instance->breakpoints->get_active_breakpoints();

        foreach ( $active_devices as $breakpoint_key ) {
            $label = 'desktop' === $breakpoint_key ? esc_html__( 'Desktop', 'finanzia' ) : $active_breakpoints[ $breakpoint_key ]->get_label();

            $widget->add_control(
                $args['prefix'].'hide_' . $breakpoint_key,
                [
                    /* translators: %s: Device name. */
                    'label'        => sprintf( __( 'Hide On %s', 'finanzia' ), $label ),
                    'type'         => Controls_Manager::SWITCHER,
                    'default'      => '',
                    'label_on'     => esc_html__( 'Hide', 'finanzia' ),
                    'label_off'    => esc_html__( 'Show', 'finanzia' ),
                    'condition'    => $args['condition']
                ]
            );
        }
    }
}
if(!function_exists('finanzia_add_hidden_device_controls_render')){
    function finanzia_add_hidden_device_controls_render($settings = [], $prefix = ''){
        $active_devices     = \Elementor\Plugin::$instance->breakpoints->get_active_devices_list( [ 'reverse' => true ] );
        $active_breakpoints = \Elementor\Plugin::$instance->breakpoints->get_active_breakpoints();
        $hidden             = [];
        foreach ($active_devices as $device) {
            $hidden[] = ($settings[$prefix.'hide_'.$device] === 'yes') ? 'cms-hidden-'.$device : '';
        }
        return implode(' ',array_filter($hidden));
    }
}
// Display Alignment
if(!function_exists('finanzia_elementor_reponsive_flex_alignment')){
    function finanzia_elementor_responsive_flex_alignment($widget = [], $args = []){
        $args = wp_parse_args($args, [
            'name'      => 'align',
            'condition' => [],
            'label'     => esc_html__( 'Alignment', 'finanzia' )
        ]);
        return $widget->add_responsive_control(
            $args['name'],
            [
                'label'        => $args['label'],
                'type'         => Controls_Manager::CHOOSE,
                'options'      => [
                    'start'    => [
                        'title' => esc_html__( 'Left', 'finanzia' ),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'center'  => [
                        'title' => esc_html__( 'Center', 'finanzia' ),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'end'   => [
                        'title' => esc_html__( 'Right', 'finanzia' ),
                        'icon'  => 'eicon-text-align-right',
                    ],
                    'between' => [
                        'title' => esc_html__( 'Between', 'finanzia' ),
                        'icon'  => 'eicon-text-align-justify',
                    ],
                ],
                'condition' => $args['condition']
            ]
        );
    }
}
// Alignment Class
if(!function_exists('finanzia_elementor_get_alignment_class')){
    function finanzia_elementor_get_alignment_class($widget = [], $settings = [], $args = []){
        $args = wp_parse_args($args, [
            'name'         => '',
            'default'      => '',
            'prefix_class' => 'text-',
            'desktop'      => '',
            'widescreen'   => '', 
            'laptop'       => '',
            'tablet_extra' => '',
            'tablet'       => '',
            'mobile_extra' => '',
            'mobile'       => '',
            'smobile'      => '' 
        ]);
        
        $active_devices = \Elementor\Plugin::$instance->breakpoints->get_active_devices_list( [ 'reverse' => true ] );
        $align_class = [];
        if(!empty($settings[$args['name']]) || !empty($args['default'])){
            $align_class[] = $args['prefix_class'].$widget->get_setting($args['name'], $args['default']);
        }
        // Align Class
        foreach ( $active_devices as $key => $breakpoint_key ) {
            $breakpoint_key_class =  str_replace('_','-',$breakpoint_key);

            $setting_breakpoint_key = $widget->get_setting($args['name'].'_' . $breakpoint_key, $args[$breakpoint_key]);

            if($breakpoint_key !== 'desktop' && !empty($setting_breakpoint_key) ){
                //$align_class[] = $args['prefix_class'].$breakpoint_key_class.'-'.$settings[$args['name'].'_' . $breakpoint_key];
                $align_class[] = $args['prefix_class'].$breakpoint_key_class.'-'.$setting_breakpoint_key;
            }
        }
        // remove duplicate value
        $align_class = array_values(array_unique($align_class));
        
        // return
        return finanzia_nice_class($align_class);
    }
}

// Responsive inline CSS 
if(!function_exists('finanzia_elementor_responsive_inline_css')){
    function finanzia_elementor_responsive_inline_css($widget = [], $settings = [], $args = []){
        $args = wp_parse_args($args, [
            'name'         => '',
            'default'      => '',
            'prefix_css' => '--cms-',
            'desktop'      => '',
            'widescreen'   => '', 
            'laptop'       => '',
            'tablet_extra' => '',
            'tablet'       => '',
            'mobile_extra' => '',
            'mobile'       => '',
            'smobile'      => '' 
        ]);
        
        $active_devices = \Elementor\Plugin::$instance->breakpoints->get_active_devices_list( [ 'reverse' => true ] );
        $align_class = [];
        if(!empty($settings[$args['name']]) || !empty($args['default'])){
            $align_class[] = $args['prefix_css'].':'.$widget->get_setting($args['name'], $args['default']).'px';
        }
        // Align Class
        foreach ( $active_devices as $key => $breakpoint_key ) {
            $breakpoint_key_class =  str_replace('_','-',$breakpoint_key);
            $setting_breakpoint_key = $widget->get_setting($args['name'].'_' . $breakpoint_key, $args[$breakpoint_key]);
            if($breakpoint_key !== 'desktop' && !empty($setting_breakpoint_key) ){
                $align_class[] = $args['prefix_css'].'-'.$breakpoint_key_class.':'.$setting_breakpoint_key.'px';
            }
        }
        // remove duplicate value
        $align_class = array_values(array_unique($align_class));
        
        // return
        return implode(';',$align_class);
    }
}

// Grid Columns
if(!function_exists('finanzia_elementor_grid_columns_settings')){
    function finanzia_elementor_grid_columns_settings($widget, $args=[]){
        $args = wp_parse_args($args, [
            'name'      => 'col',
            'label'     => esc_html__('Grid Settings', 'finanzia'),
            'tab'       => Controls_Manager::TAB_SETTINGS,
            'divider'   => false,
            'separator' => 'after',
            'condition' => [],
            'group'     => true,
            'gap'       => false
        ]);
        if($args['group']){
            $widget->start_controls_section(
                $args['name'].'_grid_section',
                [
                    'label'     => $args['label'],
                    'tab'       => $args['tab'],
                    'condition' => $args['condition']
                ]
            );
        }

            $widget->add_responsive_control(
                $args['name'],
                [
                    'label'        => esc_html__('Columns', 'finanzia'),
                    'type'         => Controls_Manager::SELECT,
                    'default'      => '',
                    'default_args' => [
                        'tablet' => '',
                        'mobile' => ''
                    ],
                    'options' => [
                        ''     => esc_html__('Default', 'finanzia'),
                        '1'    => '1',
                        '2'    => '2',
                        '3'    => '3',
                        '4'    => '4',
                        '5'    => '5',
                        '6'    => '6',
                        'auto' => esc_html__('Auto','finanzia'),
                    ],
                    //'separator' => $args['separator']
                ]
            );
            if($args['gap']){
                $widget->add_control(
                    $args['name'].'_gap',
                    [
                        'label'        => esc_html__( 'Gap', 'finanzia' ),
                        'type'         => Controls_Manager::SELECT,
                        'options'      => ['' => esc_html__('Default','finanzia'), 'none'=>0, 10=>10,20=>20,30=>30,40=>40],
                        'default'   => '',
                        'separator' => $args['separator']
                    ]
                );
            }
            if($args['divider']){
                $widget->add_control(
                    $args['name'].'col_separator',
                    [
                        'label'        => esc_html__('Add separator?','finanzia'),
                        'type'         => Controls_Manager::SWITCHER,
                        'return_value' => 'yes'
                    ]
                );
            }
        if($args['group']){
            $widget->end_controls_section();
        }
    }
}
if(!function_exists('finanzia_elementor_get_grid_columns')){
    function finanzia_elementor_get_grid_columns($widget = [], $settings = [], $args = []){
        $args = wp_parse_args($args, [
            'name'         => 'col',
            'prefix_class' => 'flex-col-',
            'default'      => '',
            'widescreen'   => '', 
            'desktop'      => '',
            'laptop'       => '',
            'tablet_extra' => '',
            'tablet'       => '',
            'mobile_extra' => '',
            'mobile'       => '',
            'smobile'      => '1',
            'gap'          => 40,
            'gap_prefix'   => 'gutter-'
        ]); 
        $active_devices = \Elementor\Plugin::$instance->breakpoints->get_active_devices_list( [ 'reverse' => true ] );
        $align_class = [];
        if(!empty($settings[$args['name']]) || !empty($args['default']) ){
            $class = (isset($settings[$args['name']]) && !empty($settings[$args['name']])) ? $settings[$args['name']] : $args['default'];
            $align_class[] = $args['prefix_class'].$class;
        }
        // Align Class
        foreach ( $active_devices as $key => $breakpoint_key ) {
            $breakpoint_key_class =  str_replace('_','-',$breakpoint_key);
            $setting_breakpoint_key = (isset($settings[$args['name'].'_' . $breakpoint_key]) && !empty($settings[$args['name'].'_' . $breakpoint_key])) ? $settings[$args['name'].'_' . $breakpoint_key] : $args[$breakpoint_key];

            if($breakpoint_key !== 'desktop' && !empty($setting_breakpoint_key) ){
                $align_class[] = $args['prefix_class'].$breakpoint_key_class.'-'.$setting_breakpoint_key;
            }
        }
        $align_class[] = 'flex-col-smobile-'.$args['smobile'];
        $align_class[] = $args['gap_prefix'].$widget->get_setting($args['name'].'_gap', $args['gap']);
        // remove duplicate value
        $align_class = array_values(array_unique($align_class));
        
        // return
        return finanzia_nice_class($align_class);
    }
}
// Color
if(!function_exists('finanzia_elementor_colors_opts')){
    function finanzia_elementor_colors_opts($widget=[],$args = []){
        $args = wp_parse_args($args, [
            'name'        => '',
            'selector'    => [],
            'label'       => esc_html__('Color', 'finanzia'),
            'description' => '',
            'classes'     => '',
            'separator'   => '',
            'condition'   => [],
            'conditions'  => [],
            'custom'      => false,
            'label_block' => false
        ]);
        $widget->add_control(
            $args['name'],
            [
                'label'       => $args['label'],
                'type'        => Controls_Manager::SELECT,
                'options'     => finanzia_theme_colors(['custom' => $args['custom']]),
                'default'     => '',
                'separator'   => $args['separator'],
                'condition'   => $args['condition'],
                'conditions'  => $args['conditions'],
                'description' => $args['description'],
                'classes'     => $args['classes'],
                'label_block' => $args['label_block']
            ]
        );
        if($args['custom']){
            $widget->add_control(
                $args['name'].'_custom',
                [
                    'label'     => $args['label'].' '.esc_html__( 'Custom', 'finanzia' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => $args['selector'],
                    'condition' => array_merge(
                        $args['condition'],
                        [
                            $args['name'] => 'custom'
                        ]
                    )
                ]
            );
        }
    }
}
// Carousel Setting
if(!function_exists('finanzia_elementor_carousel_settings')){
    function finanzia_elementor_carousel_settings($widget, $args = []){
        $args = wp_parse_args($args, [
            'label'            => esc_html__('Carousel Settings', 'finanzia'),
            'tab'              => Controls_Manager::TAB_SETTINGS,
            'condition'        => [],
            'hover_icon'       => false,
            'slides_to_show'   => '',
            'slides_to_scroll' => '',
            'show_arrows'      => 'yes',
            'show_dots'        => 'yes',
            'loop'             => 'yes' 
        ]);
        $widget->start_controls_section(
            'carousel_section',
            [
                'label'     => $args['label'],
                'tab'       => $args['tab'],
                'condition' => $args['condition']
            ]
        );
            $widget->add_control(
                'item_shadow',
                [
                    'label'     => esc_html__('Item Shadow?', 'finanzia'),
                    'type'      => Controls_Manager::SELECT,
                    'options'   => [
                        'yes' => esc_html__('Yes', 'finanzia'),
                        'no'   => esc_html__('No', 'finanzia')
                    ],
                    'default' => 'no',
                    'dynamic' => [
                        'active' => true
                    ],
                    'style_transfer' => true,
                    'prefix_class' => 'cms-carousel-item-shadow-',

                ]
            );
            $widget->add_control(
                'content_width',
                [
                    'label'     => esc_html__('Content Width', 'finanzia'),
                    'type'      => Controls_Manager::SELECT,
                    'options'   => [
                        ''             => esc_html__('Default', 'finanzia'),
                        'start'        => esc_html__('Full to Start', 'finanzia'),
                        'end'          => esc_html__('Full to End', 'finanzia'),
                        'start-large'  => esc_html__('Full to Start (Large)', 'finanzia'),
                        'end-large'    => esc_html__('Full to End (Large)', 'finanzia'),
                        'start-mlarge' => esc_html__('Full to Start (Medium Large)', 'finanzia'),
                        'end-mlarge'   => esc_html__('Full to End (Medium Large)', 'finanzia'),
                        'start-xlarge' => esc_html__('Full to Start (Extra Large)', 'finanzia'),
                        'end-xlarge'   => esc_html__('Full to End (Extra Large)', 'finanzia'),
                        'both'         => esc_html__('Full to Both', 'finanzia'),
                        'both-small'   => esc_html__('Full to Both (Small)', 'finanzia'),
                        'both-fit'     => esc_html__('Full to Both (Fit Screen)', 'finanzia')
                    ],
                    'default'      => '', 
                    'prefix_class' => 'cms-swiper-full-',
                    'separator'    => 'after'
                ]
            );
            
            $slides_to_show = range(1, 10);
            $slides_to_show = array_combine($slides_to_show, $slides_to_show);
            $widget->add_responsive_control(
                'slides_to_show',
                [
                    'label'   => esc_html__('Slides to Show', 'finanzia'),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                            '' => esc_html__('Default', 'finanzia'),
                            //'auto' => esc_html__('Auto', 'finanzia'),
                        ] + $slides_to_show,
                    'frontend_available' => true,
                    'default' => $args['slides_to_show']
                ]
            );

            $widget->add_responsive_control(
                'slides_to_scroll',
                [
                    'label'       => esc_html__('Slides to Scroll', 'finanzia'),
                    'type'        => Controls_Manager::SELECT,
                    'description' => esc_html__('Set how many slides are scrolled per swipe.', 'finanzia'),
                    'options'     => [
                            '' => esc_html__('Default', 'finanzia'),
                        ] + $slides_to_show,
                    'condition' => [
                        'slides_to_show!' => ['auto','1'],
                    ],
                    'default'            => $args['slides_to_scroll'],
                    'frontend_available' => true,
                ]
            );
            $widget->add_responsive_control(
                'space_between',
                [
                    'label' => esc_html__('Space Between', 'finanzia'),
                    'type'  => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'max' => 200,
                            'min' => 0.01
                        ],
                    ],
                    'default' => [
                        'size' => 40,
                    ],
                    'condition' => [
                        //'slides_to_show!' => '1',
                    ],
                    'frontend_available' => true,
                ]
            );
            $widget->add_control(
                'effect',
                [
                    'label'   => esc_html__('Effect', 'finanzia'),
                    'type'    => Controls_Manager::SELECT,
                    'default' => 'slide',
                    'options' => [
                        'slide' => esc_html__('Slide', 'finanzia'),
                        'fade'  => esc_html__('Fade', 'finanzia'),
                    ],
                    'condition' => [
                        'slides_to_show' => '1',
                    ],
                    'frontend_available' => true,
                ]
            );
            $widget->add_control(
                'effect_scroll',
                [
                    'label'              => esc_html__('Scroll Effect', 'finanzia'),
                    'description'        => esc_html__('When this option is YES, please change \'Autoplay Speed\' to 0, and \'Animation Speed\' to 9000', 'finanzia'),
                    'content_classes'    => 'elementor-panel-alert elementor-panel-alert-info',
                    'type'               => Controls_Manager::SWITCHER,
                    'frontend_available' => true,
                    'return_value'       => 'scroll',
                    'prefix_class'       => 'cms-swiper-effect-'  
                ]
            );
            $widget->add_control(
                'centeredslide',
                [
                    'label'              => esc_html__('Centered Slide', 'finanzia'),
                    'type'               => Controls_Manager::SWITCHER,
                    'frontend_available' => true,
                ]
            );
            $widget->add_control(
                'lazyload',
                [
                    'label'              => esc_html__('Lazyload', 'finanzia'),
                    'type'               => Controls_Manager::SWITCHER,
                    'default'            => 'yes',
                    'frontend_available' => true,
                ]
            );
            $widget->add_control(
                'infinite',
                [
                    'label'              => esc_html__('Infinite Loop', 'finanzia'),
                    'type'               => Controls_Manager::SWITCHER,
                    'default'            => $args['loop'],
                    'frontend_available' => true,
                ]
            );
            $widget->add_control(
                'autoplay',
                [
                    'label'              => esc_html__('Autoplay', 'finanzia'),
                    'type'               => Controls_Manager::SWITCHER,
                    'default'            => 'yes',
                    'frontend_available' => true,
                ]
            );
            $widget->add_control(
                'autoplay_speed',
                [
                    'label'     => esc_html__('Autoplay Speed', 'finanzia'),
                    'type'      => Controls_Manager::NUMBER,
                    'default'   => 5000,
                    'condition' => [
                        'autoplay' => 'yes',
                    ],
                    'frontend_available' => true,
                ]
            );
            $widget->add_control(
                'pause_on_hover',
                [
                    'label'              => esc_html__('Pause on Hover', 'finanzia'),
                    'type'               => Controls_Manager::SWITCHER,
                    'default'            => 'yes',
                    'frontend_available' => true,
                    'condition'          => [
                        'autoplay' => 'yes',
                    ],
                ]
            );
            $widget->add_control(
                'pause_on_interaction',
                [
                    'label'              => esc_html__('Pause on Interaction', 'finanzia'),
                    'type'               => Controls_Manager::SWITCHER,
                    'default'            => 'yes',
                    'frontend_available' => true,
                    'condition'          => [
                        'autoplay' => 'yes',
                    ],
                ]
            );
            $widget->add_control(
                'speed',
                [
                    'label'              => esc_html__('Animation Speed', 'finanzia'),
                    'type'               => Controls_Manager::NUMBER,
                    'default'            => 500,
                    //'render_type'        => 'none',
                    'frontend_available' => true
                ]
            );
            $widget->add_control(
                'arrows',
                [
                    'label'              => esc_html__('Show Arrows', 'finanzia'),
                    'type'               => Controls_Manager::SWITCHER,
                    'default'            => $args['show_arrows'],
                    'frontend_available' => true,
                    'label_block'        => true
                ]
            );
            finanzia_add_hidden_device_controls($widget, [
                'prefix'    => 'arrows_',
                'condition' => [
                    'arrows' => 'yes'
                ],
                'separator' => 'before'
            ]);
            // Dots
            $widget->add_control(
                'dots',
                [
                    'label'              => esc_html__('Show Dots', 'finanzia'),
                    'type'               => Controls_Manager::SWITCHER,
                    'default'            => $args['show_dots'],
                    'frontend_available' => true,
                    'label_block'        => true
                ]
            );
            finanzia_add_hidden_device_controls($widget, [
                'prefix' => 'dots_',
                'condition' => [
                    'dots' => 'yes'
                ]
            ]);
        $widget->end_controls_section();
    }
}
// Filter Settings
if(!function_exists('finanzia_elementor_filter_settings')){
    function finanzia_elementor_filter_settings($widget = []){
        $widget->add_control(
            'filter',
            [
                'label'   => esc_html__('Enable Filter', 'finanzia'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'true'  => esc_html__('Enable', 'finanzia'),
                    'false' => esc_html__('Disable', 'finanzia'),
                ],
                'default' => 'false',
            ]
        );
        $widget->add_control(
            'filter_default_title',
            [
                'label'     => esc_html__('Filter Default Title', 'finanzia'),
                'type'      => Controls_Manager::TEXT,
                'default'   => esc_html__('All', 'finanzia'),
                'condition' => [
                    'filter' => 'true',
                ],
            ]
        );
        $widget->add_control(
            'filter_alignment',
            [
                'label'   => esc_html__('Filter Alignment', 'finanzia'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'center' => esc_html__('Center', 'finanzia'),
                    'start'  => esc_html__('Start', 'finanzia'),
                    'end'    => esc_html__('End', 'finanzia'),
                ],
                'default'   => 'center',
                'condition' => [
                    'filter' => 'true',
                ],
            ]
        );
        finanzia_elementor_colors_opts($widget, [
            'name'      => 'filter_color',
            'label'     =>  esc_html__('Filter Text Color', 'finanzia'),
            'condition' => [
                'filter' => 'true',
            ],
            'separator' => 'before'
        ]);
        finanzia_elementor_colors_opts($widget, [
            'name'      => 'filter_color_hover',
            'label'     =>  esc_html__('Filter Text Color Hover', 'finanzia'),
            'condition' => [
                'filter' => 'true',
            ]
        ]);
        finanzia_elementor_colors_opts($widget, [
            'name'      => 'filter_bg_color',
            'label'     =>  esc_html__('Filter Background Color', 'finanzia'),
            'condition' => [
                'filter' => 'true',
            ]
        ]);
        finanzia_elementor_colors_opts($widget, [
            'name'      => 'filter_bg_color_hover',
            'label'     =>  esc_html__('Filter Background Color Hover', 'finanzia'),
            'condition' => [
                'filter' => 'true',
            ]
        ]);
        finanzia_elementor_colors_opts($widget, [
            'name'      => 'filter_border_color',
            'label'     =>  esc_html__('Filter Border Color', 'finanzia'),
            'condition' => [
                'filter' => 'true',
            ]
        ]);
        finanzia_elementor_colors_opts($widget, [
            'name'      => 'filter_border_color_hover',
            'label'     =>  esc_html__('Filter Border Color Hover', 'finanzia'),
            'condition' => [
                'filter' => 'true',
            ],
            'separator' => 'after'
        ]);
    }
}
// Filter Render 
if(!function_exists('finanzia_elementor_filter_render')){
    function finanzia_elementor_filter_render($widget = [], $settings = [], $args = []){
        $args = wp_parse_args($args, [
            'categories' => ''
        ]);
        $filter               = $widget->get_setting('filter', 'false');
        $filter_default_title = $widget->get_setting('filter_default_title', 'All');
        $filter_alignment     = $widget->get_setting('filter_alignment', 'center');
        $filter_color         = $widget->get_setting('filter_color', 'accent');
        $filter_color_hover   = $widget->get_setting('filter_color_hover', 'white');
        $filter_bg            = $widget->get_setting('filter_bg_color', 'white');
        $filter_bg_hover      = $widget->get_setting('filter_bg_color_hover', 'accent');
        $filter_border        = $widget->get_setting('filter_border_color', 'white');
        $filter_border_hover  = $widget->get_setting('filter_border_color_hover', 'accent');
        // item attribute
        $widget->add_render_attribute('filter',[
            'class' => [
                'grid-filter-wrap',
                'd-flex justify-content-'.$filter_alignment
            ],
            'style' => '--cms-filter-color:'.$filter_color.';--cms-filter-color-hover:'.$filter_color_hover.';'
        ]);
        $widget->add_render_attribute('filter-item',[
            'class' => [
                'filter-item active',
                'text-'.$filter_color,
                'text-hover-'.$filter_color_hover,
                'text-active-'.$filter_color_hover,
                'bg-'.$filter_bg,
                'bg-hover-'.$filter_bg_hover,
                'bg-active-'.$filter_bg_hover,
                'bdr-1 bdr-'.$filter_border,
                'bdr-hover-'.$filter_border_hover,
                'bdr-active-'.$filter_border_hover,
                'p-tb-5 p-lr-20 cms-radius-20'
            ],
            'data-filter' => '*'
        ]);
        if ($filter == "true"): ?>
        <div <?php etc_print_html($widget->get_render_attribute_string('filter')); ?>>
            <span <?php etc_print_html($widget->get_render_attribute_string('filter-item')); ?>><span class="filter--item" data-hover="<?php echo esc_attr($filter_default_title); ?>"><?php echo esc_html($filter_default_title); ?></span></span>
            <?php foreach ($args['categories'] as $key => $category): 
                $category_arr = explode('|', $category);
                $tax[] = $category_arr[1];
                $term = get_term_by('slug', $category_arr[0], $category_arr[1]);

                $item_key = $widget->get_repeater_setting_key( 'item', 'filter', $key );
                $widget->add_render_attribute( $item_key, [
                    'class' => [
                        'filter-item',
                        'text-'.$filter_color,
                        'text-hover-'.$filter_color_hover,
                        'text-active-'.$filter_color_hover,
                        'bg-'.$filter_bg,
                        'bg-hover-'.$filter_bg_hover,
                        'bg-active-'.$filter_bg_hover,
                        'bdr-1 bdr-'.$filter_border,
                        'bdr-hover-'.$filter_border_hover,
                        'bdr-active-'.$filter_border_hover,
                        'p-tb-5 p-lr-20 cms-radius-20'
                    ],
                    'data-filter' => $category
                ]);
            ?>
                <span <?php etc_print_html($widget->get_render_attribute_string($item_key)); ?>>
                    <span class="filter--item" data-hover="<?php echo esc_attr($term->name); ?>"><?php echo esc_html($term->name); ?></span>
                </span>
            <?php endforeach; ?>
        </div>
    <?php endif;
    }
}
/**
 * Elementor Circle Text Settings
 * 
 * */
function finanzia_elementor_circle_text_settings($widget = [], $args = []){
    $args = wp_parse_args($args, [
        // Group
        'label'     => esc_html__('Circle Text Settings', 'finanzia'),
        'tab'       => Controls_Manager::TAB_CONTENT,
        'condition' => [],
        'group'     => true,
        'skin'      => 'inline',
        //
        'prefix'   => '',
        'name'     => 'circle',
        'type'     => 'icon', 
        // icon
        'icon_label'   => __('Choose Icon','finanzia'),
        'icon_default' => [
            'library' => 'svg',
            'value'   => [
                'url' => get_template_directory().'/assets/svgs/core/star.svg'
            ]  
        ],
        // image
        'img_label'        => __('Choose Image','finanzia'),
        'img_default'      => [],
        'img_size'         => false, 
        'img_default_size' => 'custom',
        // Link
        'link'      => false,
        'link_type' => [],
        //
        'separator' => '',
        'classes'   => ''
    ]);
    if($args['group']){
        $widget->start_controls_section(
            $args['prefix'].'icon_img_section',
            [
                'label'        => $args['label'],
                'tab'          => $args['tab'],
                'condition'    => $args['condition']
            ]
        );
    }
        $widget->add_control(
            $args['prefix'].$args['name'].'_text',
            [
                'label'        => esc_html__('Circle Text', 'finanzia'),
                'type'         => Controls_Manager::TEXTAREA,
                'separator'    => $args['separator'],
                'classes'      => $args['classes'],
                'condition'    => $args['condition'],
                'default'      => 'Your Text Here' 
            ]
        );
        $widget->add_control(
            $args['prefix'].$args['name'].'_type',
            [
                'label'   => esc_html__('Icon Type', 'finanzia'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'icon'  => esc_html__('Icon','finanzia'),
                    'image' => esc_html__('Image','finanzia'),
                    ''      => esc_html__('None','finanzia'),
                ],
                'default'   => $args['type'],
                'condition' => array_merge(
                    $args['condition'],
                    [
                        $args['prefix'].$args['name'].'_text!' => '',
                    ]
                )
            ]
        );
        $widget->add_control(
            $args['prefix'].$args['name'].'_icon',
            [
                'label'       => $args['icon_label'],
                'type'        => Controls_Manager::ICONS,
                'default'     => $args['icon_default'],
                'skin'        => $args['skin'],
                'label_block' => false,
                'condition'   => [
                    $args['prefix'].$args['name'].'_text!' => '',
                    $args['prefix'].$args['name'].'_type' => 'icon'
                ]
            ]
        );
        $widget->add_control(
            $args['prefix'].$args['name'].'_image',
            [
                'label'       => $args['img_label'],
                'type'        => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src()
                ],
                'skin'        => $args['skin'],
                'label_block' => false,
                'condition'    => array_merge(
                    $args['condition'],
                    [
                        $args['prefix'].$args['name'].'_type' => 'image'
                    ]
                )
            ]
        );
        if($args['link']){
            $link_type = array_merge(
                $args['link_type'], 
                [
                    'page'   => esc_html__('Page','finanzia'), 
                    'custom' => esc_html__('Custom','finanzia')
                ]
            );
            $widget->add_control(
                $args['prefix'].$args['name'].'link_type',
                [
                    'label'   => esc_html__('Link Type', 'finanzia'),
                    'type'    => Controls_Manager::SELECT,
                    'options' => $link_type,
                    'default' => 'custom',
                    'condition' => array_merge(
                        $args['condition'],
                        [
                            $args['prefix'].$args['name'].'_text!' => ''
                        ]
                    )
                ]
            );
            unset($link_type['custom']); // remove custom
            foreach ($link_type as $key => $value) {
                $widget->add_control(
                    $args['prefix'].$args['name'].$key,
                    [
                        'label'        => sprintf('%1$s %2$s', esc_html__('Select', 'finanzia'), $value),
                        'type'         => Elementor_Theme_Core::POSTS_CONTROL,
                        'return_value' => 'ID',
                        'multiple'     => false,
                        'post_type'    => [
                            $key
                        ],
                        'condition' => array_merge(
                            $args['condition'],
                            [
                                $args['prefix'].$args['name'].'_text!' => '',
                                $args['prefix'].$args['name'].'link_type' => $key
                            ]
                        ),
                        'label_block' => false
                    ]
                );
            }
            $widget->add_control(
                $args['prefix'].$args['name'].'link_custom',
                [
                    'label'       => esc_html__( 'Custom Link', 'finanzia' ),
                    'type'        => Controls_Manager::URL,
                    'placeholder' => esc_html__( 'https://your-link.com', 'finanzia' ),
                    'default'     => [
                        'url' => '#',
                    ],
                    'condition' => [
                        $args['prefix'].$args['name'].'link_type' => 'custom'
                    ],
                    'label_block' => false
                ]
            );
        }
    if($args['group']){
        $widget->end_controls_section();
    }
}
// Render circle text 
if(!function_exists('finanzia_circle_text')){
    function finanzia_circle_text($widget = [], $settings = [], $args = []){
        $args = wp_parse_args($args, [
            'class'      => '',
            'dimensions' => 120,
            'background' => 'transparent',
            'color'      => 'primary',
            'text'       => '',
            'text_size'  => 20, 
            'echo'       => true,
            'before'     => '',
            'after'      => '',
            // 
            'svg_class'  => 'cms-spin',
            // icon
            'icon'        => true,
            'prefix'      => '',
            'name'        => 'circle',
            'icon_class'  => '',
            'icon_size'   => 20,
            'icon_color'  => 20,
            // link
            'link'         => false,
            'link_class'   => '',
            'link_loop'    => false,
            'link_loop_key' => ''
        ]);

        $text       = !empty($args['text']) ? $args['text'] : $settings[$args['prefix'].$args['name'].'_text'];
        $background = $args['background'];
        $color      = $args['color'];
        $dimensions = $args['dimensions'];

        $classes = ['cms-circle-text circle relative','bg-'.$background, 'text-'.$args['color'], $args['class']];

        // Link
        $link_type = $settings[$args['prefix'].$args['name'].'link_type'];
        $page_ID = $settings[$args['prefix'].$args['name'].$link_type];
        switch($link_type){
            case 'custom':
                $url = $settings[$args['prefix'].$args['name'].'link_custom']['url'];
                break;
            default : 
                $url  = !empty($page_ID) ? get_permalink($page_ID) : '#';
                break;
        }
        $link_loop_key = $widget->get_repeater_setting_key( $args['prefix'].$args['name'].'key', $args['prefix'].$args['name'].'key', $args['prefix'].$args['name'].$args['link_loop_key'] );
        $link_attrs_key = $args['link_loop'] ? $link_loop_key : $args['prefix'].$args['name'].'_attr_key';
        
        $widget->add_render_attribute($link_attrs_key, [
            'class'      => $args['link_class'],
            'href'       => $url,
            'data-title' => $text
        ]);
        ob_start();
    ?>
    <div class="<?php echo finanzia_nice_class($classes); ?>" style="width:<?php echo esc_attr($dimensions);?>px; height: <?php echo esc_attr($dimensions);?>px; font-size:<?php echo esc_attr($args['text_size']);?>px">
        <?php
            // Before 
            printf('%s', $args['before']); 
            // Icon
            if($args['icon']){
                finanzia_elementor_icon_image_render($widget, $settings,[
                    'prefix'      => $args['prefix'],
                    'name'        => $args['name'],
                    'size'        => $args['icon_size'],
                    'color'       => $args['icon_color'],
                    'color_hover' => $args['icon_color'],
                    // icon
                    'icon_tag'    => 'div',
                    'class'       => $args['icon_class'].' absolute center z-top',
                    'attrs'       => []
                ]);
            }
        ?>
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 300 300" xml:space="preserve" class="<?php echo esc_attr($args['svg_class']) ?>">
            <defs>
                <path id="cms-criclePath" d="M 150, 150 m -120, 0 a 120,120 0 0,1 240,0 a 120,120 0 0,1 -240,0"/>
            </defs>
            <circle cx="150" cy="150" r="150" fill="<?php echo esc_attr($background);?>"/>
            <g>
                <use xlink:href="#cms-criclePath" fill="none"/>
                <text>
                    <textPath xlink:href="#cms-criclePath"><?php echo esc_html($text); ?></textPath>
                </text>
            </g>
        </svg>
        <?php
        // After
        printf('%s', $args['after']);
        // Link
        if($args['link']){
        ?>
            <a <?php etc_print_html($widget->get_render_attribute_string($link_attrs_key)); ?>><span class="screen-reader-text"><?php echo esc_html($text); ?></span></a>
        <?php } ?>
    </div>
    <?php
        if($args['echo']){
            echo ob_get_clean();
        } else {
            return ob_get_clean();
        }
    }
}
// Elementor default Icon
if(!function_exists('finanzia_elementor_icon_default')){
    function finanzia_elementor_icon_default($icon = ['value' => '', 'library' => ''], $default = ['value' => '', 'library']){
        if(empty($icon['value'])) $icon = $default;
        return $icon;
    }
}
if(!function_exists('finanzia_elementor_icon_render')){
    function finanzia_elementor_icon_render($icon=[], $default=['value' => '', 'library' => ''], $args=[], $tag = 'span'){
        if(empty($icon['library'])) $icon = $default;
        if(empty($icon['library'])) return;
        $args = wp_parse_args($args, [
            'icon_size'        => '',
            'icon_color'       => '',
            'icon_color_hover' => '',
            'class'            => '',
            'echo'             => true,
            'before'           => '',
            'after'            => '',
            'content'          => '', 
            'style'            => '' 
        ]);
        $args['class'] = is_string($args['class']) ?  explode(' ', $args['class']) : $args['class'];
        $classes = array_unique(array_filter(array_merge([
                'cms-eicon',
                !empty($args['icon_size']) ? 'text-'.$args['icon_size'] : '',
                !empty($args['icon_color']) ? 'text-'.$args['icon_color']: '',
                !empty($args['icon_color_hover']) ? 'text-hover-'.$args['icon_color_hover'] : '',
                'lh-0'
            ],
            $args['class']
        )));
        $attrs = [];
        $attrs['class'] = $classes;
        $args['style'] = (array)$args['style'];
        $args['style'][] = '--svg-size:'.$args['icon_size'].'px';
        $attrs['style'] = implode(';', $args['style']);
        $filesystem = new WP_Filesystem_Direct( true );

        ob_start();
        printf('%s', $args['before']);
        ?>
        <<?php etc_print_html($tag.' '.\Elementor\Utils::render_html_attributes( $attrs ));?> ><?php 
            if(isset($icon['library']) && $icon['library'] === 'svg' && (!isset($icon['value']['id']) || empty($icon['value']['id']) ) && !empty($icon['value']['url'])) {
                include $icon['value']['url'];
            } else {
                Icons_Manager::render_icon( $icon, [], $tag );
            }
            printf('%s', $args['content']);
        ?></<?php etc_print_html($tag) ?>>   
        <?php    
        printf('%s', $args['after']);
        if($args['echo']){
            echo ob_get_clean();
        } else {
            return ob_get_clean();
        }
    }
}
// Icon & Image Settings 
if(!function_exists('finanzia_elementor_icon_image_settings')){
    function finanzia_elementor_icon_image_settings($widget, $args = []){
        $args = wp_parse_args($args, [
            // Group
            'label'     => esc_html__('Icon/Image Settings', 'finanzia'),
            'tab'       => Controls_Manager::TAB_CONTENT,
            'condition' => [],
            'conditions' => [],
            'group'     => true,
            'skin'      => 'inline',
            //
            'prefix'   => '',
            'name'     => 'icon_img',
            'type'     => 'icon', 
            //
            'label_type' => esc_html__('Icon Type', 'finanzia'),
            // icon
            'icon_label'   => __('Choose Icon','finanzia'),
            'icon_default' => [
                'library' => 'svg',
                'value'   => [
                    'url' => get_template_directory().'/assets/svgs/core/star.svg'
                ]  
            ],
            // image
            'img_label'        => __('Choose Image','finanzia'),
            'img_default'      => [],
            'img_size'         => false, 
            'img_default_size' => 'custom',
            //
            'separator' => '',
            'classes'   => ''
        ]);
        if(!empty($args['conditions'])){
            $condition_tag = 'conditions';
            $condition_value = $args['conditions'];
            $condition_relation_icon = array_merge(
                [
                    $args['prefix'].$args['name'].'_type' => 'icon'
                ],
                $args['conditions']
            );
            $condition_relation_img = array_merge(
                [
                    $args['prefix'].$args['name'].'_type' => 'image',
                ],
                $args['conditions']
            );
            $condition_relation_img_size = array_merge(
                [
                    $args['prefix'].$args['name'].'_type'        => 'image',
                    $args['prefix'].$args['name'].'_image[url]!' => '',
                ],
                $args['conditions']
            );
        } else {
            $condition_tag = 'condition';
            $condition_value = $args['condition'];
            $condition_relation_icon = array_merge(
                [
                    $args['prefix'].$args['name'].'_type' => 'icon'
                ],
                $args['condition']
            );
            $condition_relation_img = array_merge(
                [
                    $args['prefix'].$args['name'].'_type' => 'image',
                ],
                $args['condition']
            );
            $condition_relation_img_size = array_merge(
                [
                    $args['prefix'].$args['name'].'_type'        => 'image',
                    $args['prefix'].$args['name'].'_image[url]!' => '',
                ],
                $args['condition']
            );
        }
        if($args['group']){
            $widget->start_controls_section(
                $args['prefix'].'icon_img_section',
                [
                    'label'        => $args['label'],
                    'tab'          => $args['tab'],
                    $condition_tag => $condition_value
                ]
            );
        }
            $widget->add_control(
                $args['prefix'].$args['name'].'_type',
                [
                    'label'   => $args['label_type'],
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'icon'  => esc_html__('Icon','finanzia'),
                        'image' => esc_html__('Image','finanzia'),
                        ''      => esc_html__('None','finanzia'),
                    ],
                    'default' => $args['type'],
                    $condition_tag => $condition_value,
                    'separator'    => $args['separator'],
                    'classes'      => $args['classes']
                ]
            );
            $widget->add_control(
                $args['prefix'].$args['name'].'_icon',
                [
                    'label'     => $args['icon_label'],
                    'type'      => Controls_Manager::ICONS,
                    $condition_tag => $condition_relation_icon,
                    'default'     => $args['icon_default'],
                    'skin'        => $args['skin'],
                    'label_block' => false
                ]
            );
            $widget->add_control(
                $args['prefix'].$args['name'].'_image',
                [
                    'label'       => $args['img_label'],
                    'type'        => Controls_Manager::MEDIA,
                    $condition_tag => $condition_relation_img,
                    'default' => [
                        'url' => Utils::get_placeholder_image_src()
                    ],
                    'skin'        => $args['skin'],
                    'label_block' => false
                ]
            );
        if($args['group']){
            $widget->end_controls_section();
        }
    }
}
// Icon & Image Render
if(!function_exists('finanzia_elementor_icon_image_render')){
    function finanzia_elementor_icon_image_render($widget = [], $settings = [], $args = [], $data = []){
        $args = wp_parse_args($args,[
            'prefix'      => '',
            'name'        => 'icon_img',
            'size'        => 64,
            'color'       => 'accent',
            'color_hover' => 'accent',
            // icon
            'icon_tag'    => 'div',
            // image
            'img_size'   => false,
            // default
            'class'      => '',
            'before'     => '',
            'after'      => '',
            //
            'attrs'      => []
        ]);
        if(!empty($data)){
            $settings = $data;
        }
        $icon_type = $settings[$args['prefix'].$args['name'].'_type'];

        // Render Icon / Image
        switch ($icon_type) {
            case 'image':
                finanzia_elementor_image_render( $settings, [
                    'name'           => $args['prefix'].$args['name'].'_image',
                    'size'           => 'custom',
                    'image_size_key' => '',
                    'custom_size'    => ['width' => $args['size'], 'height' => $args['size']],
                    'img_class'      => finanzia_nice_class($args['class']).' cms-eicon',
                    'before'         => $args['before'],
                    'after'          => $args['after'],
                    'attrs'          => $args['attrs']     
                ]);
                break;
            case 'icon':
                finanzia_elementor_icon_render($settings[$args['prefix'].$args['name'].'_icon'], [], [
                    'aria-hidden'      => 'true', 
                    'class'            => $args['class'], 
                    'icon_size'        => $args['size'], 
                    'icon_color'       => $args['color'], 
                    'icon_color_hover' => $args['color_hover'],
                    'before'           => $args['before'],
                    'after'            => $args['after'],
                    'style'            => $args['attrs']   
                ], $args['icon_tag']);
                break;
        }
    }
}
/**
 * Link Settings
 * 
 * */
function finanzia_elementor_link_settings($widget, $args= []){
    $args = wp_parse_args($args, [
        'name'        => 'link_',
        'type'        => [],
        'mode'        => '', // value: 'text','btn' //get output html as text or button,
        'color'       => true,
        'text'        => '',
        //
        'group'       => false,
        'label'       => esc_html__('Link Settings', 'finanzia'),
        // Color
        'color_label'  => esc_html__('Text', 'finanzia'),
        //
        'tab'         => Controls_Manager::TAB_CONTENT,
        'condition'   => []
    ]);
    $label_classes = $args['group'] ? '' : 'cms-description-as-label';
    $description = $args['group'] ? '' : $args['label'];
    $link_type = array_merge(
        $args['type'], 
        [
            'page'   => esc_html__('Page','finanzia'), 
            'custom' => esc_html__('Custom','finanzia')
        ]
    );
    if($args['group']){
        $widget->start_controls_section(
            $args['name'].'section',
            [
                'label'     => $args['label'],
                'tab'       => $args['tab'],
                'condition' => $args['condition']
            ]
        );
    }
        $widget->add_control(
            $args['name'].'text',
            [
                'label'       => esc_html__('Link Text', 'finanzia'),
                'type'        => Controls_Manager::TEXT,
                'description' => $description,
                'classes'     => $label_classes,
                'condition'   => $args['condition'],
                'default'     => $args['text']
            ]
        );
        $widget->add_control(
            $args['name'].'type',
            [
                'label'   => esc_html__('Link Type', 'finanzia'),
                'type'    => Controls_Manager::SELECT,
                'options' => $link_type,
                'default' => 'custom',
                'condition' =>array_merge(
                    [
                        $args['name'].'text!' => ''
                    ],
                    $args['condition']
                )
            ]
        );
        unset($link_type['custom']); // remove custom
        foreach ($link_type as $key => $value) {
            $widget->add_control(
                $args['name'].$key,
                [
                    'label'        => sprintf('%1$s %2$s', esc_html__('Select', 'finanzia'), $value),
                    'type'         => Elementor_Theme_Core::POSTS_CONTROL,
                    'return_value' => 'ID',
                    'multiple'     => false,
                    'post_type'    => [
                        $key
                    ],
                    'condition'    => array_merge(
                        [
                            $args['name'].'text!' => '',
                            $args['name'].'type' => $key
                        ],
                        $args['condition']
                    ),
                    'label_block' => false
                ]
            );
        }
        $widget->add_control(
            $args['name'].'custom',
            [
                'label'       => esc_html__( 'Custom Link', 'finanzia' ),
                'type'        => Controls_Manager::URL,
                'placeholder' => esc_html__( 'https://your-link.com', 'finanzia' ),
                'default'     => [
                    'url' => '#',
                ],
                'condition' => array_merge(
                    [
                        $args['name'].'text!' => '',
                        $args['name'].'type' => 'custom'
                    ],
                    $args['condition']
                ),
                'label_block' => false
            ]
        );
        if($args['color']) {
            finanzia_elementor_colors_opts($widget,[
                'name'      => $args['name'].'text_color',
                'label'     => esc_html__( 'Text Color', 'finanzia' ),
                'separator' => 'before',
                'classes'   => 'cms-eseparator',
                'condition' => array_merge(
                    [
                        $args['name'].'text!' => '',
                    ],
                    $args['condition']
                )
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'     => $args['name'].'text_color_hover',
                'label'    => esc_html__( 'Text Color Hover', 'finanzia' ),
                'condition' => array_merge(
                    [
                        $args['name'].'text!' => '',
                    ],
                    $args['condition']
                )
            ]);
            if($args['mode'] == 'btn'){
                finanzia_elementor_colors_opts($widget,[
                    'name'     => $args['name'].'btn_color',
                    'label'    => $args['color_label'].' '.esc_html__( 'Color', 'finanzia' ),
                    'condition' => array_merge(
                        [
                            $args['name'].'text!' => '',
                        ],
                        $args['condition']
                    )
                ]);
                finanzia_elementor_colors_opts($widget,[
                    'name'     => $args['name'].'btn_color_hover',
                    'label'    => $args['color_label'].' '.esc_html__( 'Color Hover', 'finanzia' ),
                    'condition' => array_merge(
                        [
                            $args['name'].'text!' => '',
                        ],
                        $args['condition']
                    )
                ]);
            }
        }
    if($args['group']){
        $widget->end_controls_section();
    }
}
// Link Render
function finanzia_elementor_link_render($widget=[], $settings=[], $args = []){
    $args = wp_parse_args($args,[
        'name'             => 'link_',
        'mode'             => '',
        'color'            => true,  
        'btn_prefix'       => 'btn-',
        'btn_hover_prefix' => 'btn-hover-',
        'btn_color'        => 'primary',
        'btn_color_hover'  => 'accent',
        'text_color'       => '',
        'text_color_hover' => '',
        // default
        'class'      => '',
        'before'     => '',
        'after'      => '',
        'echo'       => true,
        'text'       => '',
        'text_icon'  => '',
        'before_text'=> '',
        'after_text' => '',    
        // Loop
        'loop'      => false,
        'loop_key'  => '',
        'attrs'     => []
    ]);
    if(!empty($data)){
        $settings = $data;
    }
    if(empty($settings[$args['name'].'text'])) return;
    $text = !empty($args['text']) ? $args['text'] : $settings[$args['name'].'text'];
    // Get data
    $link_type = $settings[$args['name'].'type'];
    $page_ID = $settings[$args['name'].$link_type];
    switch($link_type){
        case 'custom':
            $url = $settings[$args['name'].'custom']['url'];
            break;
        default : 
            $url  = !empty($page_ID) ? get_permalink($page_ID) : '#';
            break;
    }
    $loop_key = $widget->get_repeater_setting_key( $args['name'].'key', $args['name'].'key', $args['name'].$args['loop_key'] );
    $attrs_key = $args['loop'] ? $loop_key : $args['name'].'_attr_key';
    $attrs = [
        'class' => $args['class'],
        'href'  => $url,
        'title' => $settings[$args['name'].'text']
    ] + (array)$args['attrs'];
    $widget->add_render_attribute($attrs_key, $attrs);
    if($args['color']){
        switch ($args['mode']) {
            case 'btn':
                $args['text_color'] = !empty($args['text_color']) ? $args['text_color'] : 'white';
                $args['text_color_hover'] = !empty($args['text_color_hover']) ? $args['text_color_hover'] : 'white';
                $widget->add_render_attribute($attrs_key, [
                    'class' => [
                        'btn',
                        $args['btn_prefix'].$widget->get_setting($args['name'].'btn_color', $args['btn_color']),
                        'text-'.$widget->get_setting($args['name'].'text_color', $args['text_color']),
                        $args['btn_hover_prefix'].$widget->get_setting($args['name'].'btn_color_hover', $args['btn_color_hover']),
                        'text-hover-'.$widget->get_setting($args['name'].'text_color_hover', $args['text_color_hover'])
                    ]
                ]);
                break;
            
            default:
                $args['text_color'] = !empty($args['text_color']) ? $args['text_color'] : 'primary';
                $args['text_color_hover'] = !empty($args['text_color_hover']) ? $args['text_color_hover'] : 'accent';
                $widget->add_render_attribute($attrs_key, [
                    'class' => [
                        'text-'.$widget->get_setting($args['name'].'text_color', $args['text_color']),
                        'text-hover-'.$widget->get_setting($args['name'].'text_color_hover', $args['text_color_hover'])
                    ]
                ]);
                break;
        }
    }
    // render
    ob_start();
        printf('%s', $args['before']);
    ?>
        <a <?php etc_print_html($widget->get_render_attribute_string($attrs_key)); ?>><?php etc_print_html($args['before_text'].$text.$args['after_text'].$args['text_icon']); ?></a>
    <?php
        printf('%s', $args['after']);
    if($args['echo']){
        echo ob_get_clean();
    } else {
        return ob_get_clean();
    }
}
/**
 * Elementor Taxonomies List
 * */
if(!function_exists('finanzia_elementor_taxonomies_list')){
    function finanzia_elementor_taxonomies_list($args = []){
        $args = wp_parse_args($args, [
            'custom'  => false,
            'default' => true
        ]);
        $_taxonomies = get_taxonomies( array( 'show_tagcloud' => true ), 'object' );
        unset($_taxonomies['elementor_library_category']);
        unset($_taxonomies['wpc_group_badge']);
        unset($_taxonomies['wpc-badge-group']);
        unset($_taxonomies['link_category']);
        $taxonomies = [];
        if(!$args['default']){
            $taxonomies[] = esc_html__('Default','finanzia');
        }
        foreach ( $_taxonomies as $key => $tax ) :
            $taxonomies[$key] = esc_html( $tax->labels->name );
        endforeach;
        if($args['custom']){
            $taxonomies['custom'] = esc_html__('Custom', 'finanzia');
        }
        return $taxonomies;
    }
}
/**
 * 
 * Elemenor Taxonomies List Settings
 * */
if(!function_exists('finanzia_elementor_taxonomies_settings')){
    function finanzia_elementor_taxonomies_settings($widget=[], $args = []){
        $args = wp_parse_args($args, [
            'prefix'    => '',
            'label'     => esc_html__('Taxonomy', 'finanzia'),
            'tab'       => Controls_Manager::TAB_CONTENT,
            'default'   => '',
            'condition' => [],
            'custom'    => false,
            'multiple'  => true
        ]);
        $widget->start_controls_section(
             $args['prefix'].'_taxonomy_section',
            [
                'label'     => $args['label'].' '.esc_html__('Settings','finanzia'),
                'tab'       => $args['tab'],
                'condition' => $args['condition']
            ]
        );
            $widget->add_control(
                $args['prefix'].'_taxonomy',
                [
                    'type'     => Controls_Manager::SELECT,
                    'label'    => $args['label'],
                    'options'  => finanzia_elementor_taxonomies_list(['custom' => $args['custom']]),
                    'default'  => $args['default']
                ]
            );
            finanzia_elementor_term_by_taxonomy_settings($widget, [
                'prefix'    => $args['prefix'],
                'custom'    => $args['custom'],
                'multiple'  => $args['multiple']   
            ]);
            
        $widget->end_controls_section();
    }
}
/**
 * 
 * Elemenor Term list by Taxonomy
 * */
if(!function_exists('finanzia_elementor_term_by_taxonomy_settings')){
    function finanzia_elementor_term_by_taxonomy_settings($widget=[],$args = []){
        $args = wp_parse_args($args, [
            'prefix'           => '',
            'custom_condition' => [],
            'multiple'         => true
        ]);
        $_taxonomies = get_taxonomies( array( 'show_tagcloud' => true ), 'object' );       
        unset($_taxonomies['elementor_library_category']);
        foreach ($_taxonomies as $tax) {
            $widget->add_control(
                $args['prefix'].'term_'.$tax->name,
                [
                    'label'     => sprintf(esc_html__( 'Select Term of %s', 'finanzia' ), $tax->labels->name),
                    'type'      => Controls_Manager::SELECT2,
                    'multiple'  => $args['multiple'],
                    'options'   => finanzia_elementor_term_by_taxonomy($tax->name),
                    'condition' => array_merge(
                        [
                            $args['prefix'].'_taxonomy' => [$tax->name]
                        ],
                        $args['custom_condition']
                    ),
                    'label_block' => true
                ]
            );
        }
    }
}
if(!function_exists('finanzia_elementor_term_by_taxonomy')){
    function finanzia_elementor_term_by_taxonomy($tax = '')
    {
        $term_list = array();
        $terms = get_terms(
            array(
                'taxonomy'   => $tax,
                'hide_empty' => true,
                'orderby'    => 'include'
            )
        );
        foreach ($terms as $term) {
            //$term_list[$term->slug . '|' . $tax] = $term->name;
            $term_list[$term->term_id] = $term->name;
        }
        return $term_list;
    }
}

// Scan files to register controls for each new custom widget
$files = scandir(get_template_directory() . '/elementor/core/widgets');
foreach ($files as $file) {
    $pos = strrpos($file, ".php");
    if ($pos !== false) {
        require_once get_template_directory() . '/elementor/core/widgets/' . $file;
    }
}
/**
 * Ribbon
 * 
 * */
if(!function_exists('finanzia_elementor_ribbon_render')){
    function finanzia_elementor_ribbon_render($args = []){
        $args = wp_parse_args($args, [
            'ribbon'         => 1,
            'class'          => '',
            'before'         => '',
            'after'          => '',
            'content_before' => '',
            'content_after'  => '',
            'content'        => '',
            'color'          => 'primary',
            'color_hover'    => 'accent',
            'size'           => ['width' => '10px', 'height' => '19px'],      
            'echo'           => true
        ]);
        if(empty($args['ribbon'])) return;
        $classes = ['cms-ribbon-'.$args['ribbon'], 'bg-'.$args['color'], 'bg-hover-'.$args['color_hover'], 'd-inline-block', $args['class']];
        $style = 'width:'.$args['size']['width'].';height:'.$args['size']['height'].';';
        ob_start();
            printf('%1$s%2$s%3$s%4$s%5$s%6$s%7$s', $args['before'], '<div class="'.esc_attr(finanzia_nice_class($classes)).'" style="'.esc_attr($style).'">', $args['content_before'], $args['content'], $args['content_after'], '</div>', $args['after']);
        if($args['echo']){
           echo ob_get_clean();
        } else {
            return ob_get_clean();
        }
    }
}