/**
 * Theme JS
 * 
 * */
(function($) {
    "use strict";
    /* ===================
     Page reload 
     ===================== */
    var scroll_top;
    var last_scroll_top = 0;
    var $imgLogo = $('#cms-header .site-logo img');
    var srcLogo = $imgLogo.attr('src'),
        srcLogoMobile = $imgLogo.data('mobile'),
        logo_tablet_mobile_size = 1025;
    var dataSticky = $imgLogo.data('sticky');
    var dataStickyMobile = $imgLogo.data('sticky-mobile');
    var $header = $('#cms-header'),
        $headerSticky = $header.data('sticky'),
        $headerStickyClass = (typeof $headerSticky!='undefined' && typeof $headerSticky['class']!='undefined') ? $headerSticky['class'] : '';

    var header_height = $header.outerHeight(),
        header_main_height = $('.cms-header-main').outerHeight();
    var header_btn1 = $header.find('.h-btn1'),
        header_btn1_classes = header_btn1.data('classes'),
        header_btn2 = $header.find('.h-btn2'),
        header_btn2_classes = header_btn2.data('classes'),
        header_btn_phone = $header.find('.site-header-phone .btn'),
        header_btn_phone_classes = header_btn_phone.data('classes');
    $(window).on('load', function() {
        $(".cms-loader").fadeOut("slow");
        $('.cms-hover-next-prev').on('mouseenter', function(){
            $(this).prev().addClass('prev-item');
            $(this).next().addClass('next-item');
        });
        $('.cms-hover-next-prev').on('mouseleave', function(){
            $(this).prev().removeClass('prev-item');
            $(this).next().removeClass('next-item');
        });
        scroll_top = $(this).scrollTop();
        if (scroll_top > header_height) {
            $header.addClass('header-sticky-hidden');
        }
        if ($(window).outerWidth() < logo_tablet_mobile_size && srcLogoMobile != null) {
            $($imgLogo).attr('src', srcLogoMobile);
        }
        // change class for header button
        if ($header.hasClass('header-transparent')) {
            setTimeout(function() {
                $('body').css('--cms-wrap-header-height', $('.header-transparent').outerHeight() + 'px');
            }, 300);

            if (header_btn1.length > 0) {
                header_btn1.removeClass(header_btn1_classes['default'].replace(/--/gi, ' ')).addClass(header_btn1_classes['transparent'].replace(/--/gi, ' '));
            }
            if (header_btn2.length > 0) {
                header_btn2.removeClass(header_btn2_classes['default'].replace(/--/gi, ' ')).addClass(header_btn2_classes['transparent'].replace(/--/gi, ' '));
            }
            if (header_btn_phone.length > 0) {
                header_btn_phone.removeClass(header_btn_phone_classes['default']).addClass(header_btn_phone_classes['transparent'].replace(/--/gi, ' '));
            }
        } else {
            if (header_btn1.length > 0) {
                header_btn1.removeClass(header_btn1_classes['transparent'].replace(/--/gi, ' ')).addClass(header_btn1_classes['default'].replace(/--/gi, ' '));
            }
            if (header_btn2.length > 0) {
                header_btn2.removeClass(header_btn2_classes['transparent'].replace(/--/gi, ' ')).addClass(header_btn2_classes['default'].replace(/--/gi, ' '));
            }
            if (header_btn_phone.length > 0) {
                header_btn_phone.removeClass(header_btn_phone_classes['transparent'].replace(/--/gi, ' ')).addClass(header_btn_phone_classes['default'].replace(/--/gi, ' '));
            }
        }
        //
        finanzia_dropdown_touched_side();
        //finanzia_header_cart_dropdown();
        // WooCommerce
        finanzia_single_product_gallery_arrows();
    });

    $(window).on('resize', function() {
        $('html').removeClass('cms-modal-opened');
        if ($header.hasClass('header-transparent')) {
            setTimeout(function() {
                $('body').css('--cms-wrap-header-height', $('.header-transparent').outerHeight()+'px');
            }, 0);
        }
        if ($header.hasClass('header-sticky-show')) {
            $header.addClass('header-sticky-hidden').removeClass('header-sticky-show '+$headerStickyClass);
        }

        if ($(window).outerWidth() < logo_tablet_mobile_size && srcLogoMobile != null) {
            $($imgLogo).attr('src', srcLogoMobile);
        } else {
            $($imgLogo).attr('src', srcLogo);
        }
        $('.cms-primary-menu-dropdown .sub-menu').removeClass('submenu-open').attr('style','');
        // Dropdown Mega Menu
        finanzia_dropdown_mega_menu_full_width();
        //finanzia_header_cart_dropdown();
        finanzia_dropdown_touched_side();
        // WooCommerce
        finanzia_single_product_gallery_arrows();
    });

    /* ====================
        Scroll To Top
    ====================== */
    $(window).on('scroll', function() {
        scroll_top = $(this).scrollTop();
        finanzia_header_sticky();
        finanzia_scroll_to_top();
        last_scroll_top = scroll_top;
    });

    function finanzia_scroll_to_top() {
        if (scroll_top > last_scroll_top && scroll_top > header_height + 300) {
            $('.scroll-top').removeClass('to-top-show').addClass('to-top-hidden');
        } else {
            $('.scroll-top').removeClass('to-top-hidden').addClass('to-top-show');
            if (scroll_top < header_height + 300) {
                $('.scroll-top').removeClass('to-top-hidden').removeClass('to-top-show');
            }
        }
    }
    /* ====================
        Header Sticky
    ====================== */
    function finanzia_header_sticky() {
        //if($header.hasClass('sticky-on')){
        if (scroll_top > 2 && scroll_top < header_height && $header.hasClass('transparent-on')) {
            $header.addClass('header-sticky-show '+$headerStickyClass);
            $imgLogo.attr('src', dataSticky);
            if ($(window).outerWidth() < logo_tablet_mobile_size && dataStickyMobile != null) {
                $($imgLogo).attr('src', dataStickyMobile);
            }
            // change class for header button
            if (header_btn1.length > 0) {
                header_btn1.removeClass(header_btn1_classes['transparent']).addClass(header_btn1_classes['default'].replace(/--/gi, ' '));
            }
            if (header_btn2.length > 0) {
                header_btn2.removeClass(header_btn2_classes['transparent']).addClass(header_btn2_classes['default'].replace(/--/gi, ' '));
            }
            if (header_btn_phone.length > 0) {
                header_btn_phone.removeClass(header_btn_phone_classes['transparent']).addClass(header_btn_phone_classes['default'].replace(/--/gi, ' '));
            }
        }

        if (scroll_top > last_scroll_top && scroll_top > header_height) {
            if (!$header.hasClass('header-sticky-hidden')) {
                $header.removeClass('header-sticky-show '+ $headerStickyClass).addClass('header-sticky-hidden');
                $($imgLogo).attr('src', srcLogo);
                if ($(window).outerWidth() < logo_tablet_mobile_size) {
                    $($imgLogo).attr('src', srcLogoMobile);
                }
                // change class for header button
                if (header_btn1.length > 0) {
                    header_btn1.removeClass(header_btn1_classes['default'].replace(/--/gi, ' ')).addClass(header_btn1_classes['transparent'].replace(/--/gi, ' '));
                }
                if (header_btn2.length > 0) {
                    header_btn2.removeClass(header_btn2_classes['default'].replace(/--/gi, ' ')).addClass(header_btn2_classes['transparent'].replace(/--/gi, ' '));
                }
                if (header_btn_phone.length > 0) {
                    header_btn_phone.removeClass(header_btn_phone_classes['default'].replace(/--/gi, ' ')).addClass(header_btn_phone_classes['transparent'].replace(/--/gi, ' '));
                }
            }
            if ($header.hasClass('header-mobile-open')) {
                $imgLogo.attr('src', dataSticky);
                if ($(window).outerWidth() < logo_tablet_mobile_size) {
                    $($imgLogo).attr('src', dataStickyMobile);
                }
            }
        } else {
            if ($header.hasClass('header-sticky-hidden') && $header.hasClass('sticky-on')) {
                $header.removeClass('header-sticky-hidden').addClass('header-sticky-show '+ $headerStickyClass);
                $imgLogo.attr('src', dataSticky);
                if ($(window).outerWidth() < logo_tablet_mobile_size) {
                    $($imgLogo).attr('src', dataStickyMobile);
                }
                if (!$header.hasClass('transparent-on')) {
                    $('#cms-header-wrap').height(header_height);
                }
                // change class for header button
                if (header_btn1.length > 0) {
                    header_btn1.removeClass(header_btn1_classes['transparent'].replace(/--/gi, ' ')).addClass(header_btn1_classes['default'].replace(/--/gi, ' '));
                }
                if (header_btn2.length > 0) {
                    header_btn2.removeClass(header_btn2_classes['transparent'].replace(/--/gi, ' ')).addClass(header_btn2_classes['default'].replace(/--/gi, ' '));
                }

                if (header_btn_phone.length > 0) {
                    header_btn_phone.removeClass(header_btn_phone_classes['transparent'].replace(/--/gi, ' ')).addClass(header_btn_phone_classes['default'].replace(/--/gi, ' '));
                }
            }
            if (scroll_top < header_height) {
                $header.removeClass('header-sticky-hidden').removeClass('header-sticky-show '+ $headerStickyClass);
                if (!$header.hasClass('transparent-on')) {
                    $('#cms-header-wrap').height('auto');
                }

                // change class for header button
                if (header_btn1.length > 0) {
                    header_btn1.removeClass(header_btn1_classes['default'].replace(/--/gi, ' ')).addClass(header_btn1_classes['transparent'].replace(/--/gi, ' '));
                }
                if (header_btn2.length > 0) {
                    header_btn2.removeClass(header_btn2_classes['default'].replace(/--/gi, ' ')).addClass(header_btn2_classes['transparent'].replace(/--/gi, ' '));
                }
                if (header_btn_phone.length > 0 && $header.hasClass('transparent-on')) {
                    header_btn_phone.removeClass(header_btn_phone_classes['default'].replace(/--/gi, ' ')).addClass(header_btn_phone_classes['transparent'].replace(/--/gi, ' '));
                }

                $imgLogo.attr('src', srcLogo);
                if ($(window).outerWidth() < logo_tablet_mobile_size) {
                    $($imgLogo).attr('src', srcLogoMobile);
                }
                if ($header.hasClass('transparent-on') && $header.hasClass('header-mobile-open')) {
                    $($imgLogo).attr('src', dataSticky);
                } else {
                    $($imgLogo).attr('src', srcLogo);
                }
                if ($(window).outerWidth() < logo_tablet_mobile_size) {
                    if ($header.hasClass('transparent-on') && $header.hasClass('header-mobile-open')) {
                        $($imgLogo).attr('src', dataStickyMobile);
                    } else {
                        $($imgLogo).attr('src', srcLogoMobile);
                    }
                }
            }
            if ($header.hasClass('header-mobile-open')) {
                $header.removeClass('header-sticky-hidden').addClass('header-sticky-show '+$headerStickyClass);
            }
        }
        //} 
    }

    $(document).ready(function() {
        setTimeout(function() {
            if($('body').hasClass('has-header-top')){
                $('body').css('--cms-header-top-height', $('#cms-header-top').outerHeight() + 'px');
            }
        }, 300);
        /* =================
         Menu Dropdown
         =================== */
        var $menu = $('.site-navigation-dropdown');
        $menu.find('.cms-primary-menu-dropdown li').each(function() {
            var $submenu = $(this).find('>.sub-menu');
            if ($submenu.length == 1) {
                $(this).on( 'mouseenter' , function() {
                    if ($submenu.offset().left + $submenu.width() > $(window).width()) {
                        $submenu.addClass('back');
                    } else if ($submenu.offset().left < 0) {
                        $submenu.addClass('back');
                    }
                }).on( 'mouseleave' , function() {
                    $submenu.removeClass('back');
                });
            }
        });

        $('.sub-menu .current-menu-item').parents('.menu-item-has-children').addClass('current-menu-ancestor');
        $('.mega-auto-width').parents('.megamenu').addClass('remove-pos');
        // add current ancestor for mega parent 
        $('.cms-emenu-6 > .cms-title').each(function(){
           var mega_url  = $(this).attr("href"); 
           var mega_root = window.location.href;
            if(mega_url == mega_root){
                $('.cms-emenu-6 > .cms-title').addClass('current');
                $('.cms-emenu-6 > .cms-title').parents('.menu-item-has-children').addClass('current-menu-ancestor');
            }
        });
        /* =================
         Menu Mobile
         =================== */
        $("#main-menu-mobile").on('click touch', function(e) {
            e.preventDefault();
            if($('html').hasClass('cms-modal-opened')){
                $('html').removeClass('cms-modal-opened');
            } else {
                $('html').addClass('cms-modal-opened');
            }
            $('#cms-header').toggleClass('header-mobile-open');
            $(this).find('.open-menu').toggleClass('opened');
            $('.site-navigation').toggleClass('navigation-open');
            if (scroll_top < header_height) {
                $header.removeClass('header-sticky-hidden').removeClass('header-sticky-show '+$headerStickyClass);
            }
            if (scroll_top < header_height) {
                if ($header.hasClass('transparent-on') && $header.hasClass('header-mobile-open')) {
                    //$($imgLogo).attr('src', dataSticky);
                } else {
                    //$($imgLogo).attr('src', srcLogo);
                }
            }
            if ($(window).outerWidth() < logo_tablet_mobile_size) {
                if (scroll_top < header_height) {
                    if ($header.hasClass('transparent-on') && $header.hasClass('header-mobile-open')) {
                        $($imgLogo).attr('src', dataStickyMobile);
                    } else {
                        $($imgLogo).attr('src', srcLogoMobile);
                    }
                }
            }
        });
        $("#main-menu-mobile-close").on('click touch', function() {
            $('html').removeClass('cms-modal-opened');
            $('#cms-header').removeClass('header-mobile-open');
            $('.site-navigation').removeClass('navigation-open');
            $('.open-menu').removeClass('opened');
        });
        /* Mobile Sub Menu */
        $('.main-menu-toggle').on('click touch', function(e) {
            e.preventDefault();
            $(this).toggleClass('open');
            $(this).parents('.menu-item').toggleClass('current-menu-item');
            $(this).parents('.menu-item').find('> .sub-menu').toggleClass('submenu-open');
            $(this).parent('.cms-menu-link').next('.sub-menu').slideToggle();
        });
        /**
         * Header Left
         * */
        $("#cms-header-left-show-menu").on('click touch', function(e) {
            e.preventDefault();
            $(this).toggleClass('open');
            //$('.site-navigation').toggleClass('header-left-open');
            //$(this).find('.open-menu').toggleClass('opened');
            $('.site-navigation').toggleClass('open');
        });
        // HTML Checkbox
        $('.cms-checkbox').on('click', function(){
            $(this).toggleClass('checked')
        });
        $('[checked=checked]').parent().toggleClass("checked");
        $('input[type=checkbox]').on('change', function () {
          $(this).parent().toggleClass("checked");
        });
        $('input[type=radio]').on('change', function () {
          $(this).parents('.wpcf7-radio').find('label').removeClass("checked");
          $(this).parent().toggleClass("checked");
        });
        
        // Modal
        finanzia_modal();
        // Dropdown Mega Menu
        finanzia_dropdown_mega_menu_full_width();
        // Dropdown touched side
        finanzia_dropdown_touched_side();
        // Footer
        finanzia_footer();
        // Lazy load
        finanzia_lazy_images();
        // Woo
        finanzia_quantity_plus_minus_action();
        finanzia_header_cart_dropdown();
        finanzia_single_product_gallery_arrows();
        finanzia_single_product_star_rating();
        //finanzia_woo_checkout_place_order_button();
        finanzia_woocs_menu_change_currency();

        // WPCF7
        finanzia_wpcf7();
        // Select 2 
        finanzia_select2();
    });
    // Ajax Complete
    $(document).ajaxComplete(function(event, xhr, settings){
        "use strict";
        // Modal
        //finanzia_modal();
        // WPCF7
        finanzia_wpcf7();
        // WooCommerce
        //finanzia_woo_checkout_place_order_button();
        finanzia_single_product_gallery_arrows();
        // Select 2 
        finanzia_select2();
    });
    /**
     * Modal
     * 
     * */
    function finanzia_modal(){
        "use strict";
        $('.cms-modal').each(function() {
            var modal_move = $(this).data('modal-move'),
                modal_open = $(this).data('modal'),
                modal_mode = $(this).data('modal-mode'),
                modal_slide = $(this).data('modal-slide'),
                modal_class = $(this).data('modal-class'),
                modal_width = $(this).data('modal-width'),
                modal_space = $(this).data('modal-space'),
                modal_space_top = parseInt($(modal_open).find('.cms-modal-content').css('padding-top')),
                modal_space_bot = parseInt($(modal_open).find('.cms-modal-content').css('padding-bottom')),
                modal_hidden = $(this).data('modal-hidden'),
                modal_placeholder = $(this).data('modal-placeholder'),
                close_text = $(this).data('close-text');

            $(modal_open).addClass('cms-modal-' + modal_mode);
            $(modal_open).addClass('cms-modal-' + modal_mode + '-' + modal_slide);
            $(modal_open).addClass(modal_class);
            $(modal_open).css('--cms-modal-width', modal_width);
            $(modal_open).css('--cms-modal-content-space', modal_space);
            $(modal_open).css('--cms-modal-mousewheel-space', modal_space_top + modal_space_bot+'px');
            if (typeof modal_placeholder != 'undefined') {
                $(modal_open).find('.search-popup .cms-search-popup-input').attr('placeholder', modal_placeholder);
            }
            if (typeof close_text != 'undefined' && typeof close_text != '') {
                $(modal_open).find('.cms-close').prepend( close_text);
            }
            if (typeof modal_hidden != 'undefined') {
                $(modal_open).find('.cms-close').attr('data-modal-hidden', modal_hidden);
            }
            // bring all modal to footer
            if(typeof modal_move != 'undefined'){
                var modal_html = $(modal_move).html();
                $(modal_move).remove();
                $('body').append(modal_html);
            }
        });
        $('.cms-modal').on('click', function(e) {
            e.preventDefault();
            var modal_open = $(this).data('modal'),
                focus = $(this).data('focus'),
                modal_slide = $(this).data('modal-slide'),
                overlay_class = $(this).data('overlay-class'),
                modal_space_top = parseInt($(modal_open).find('.cms-modal-content').css('padding-top')),
                modal_space_bot = parseInt($(modal_open).find('.cms-modal-content').css('padding-bottom')),
                modal_hidden = $(this).data('modal-hidden');
            $(this).toggleClass('open');
            $(modal_open).toggleClass('open');
            $(modal_open).css('--cms-modal-mousewheel-space', modal_space_top + modal_space_bot +'px');
            if (typeof focus != 'undefined') {
                setTimeout(function() {
                    $(focus).focus();
                }, 300);
            }
            //
            $('html').toggleClass('cms-modal-opened');
            $('body').find('.cms-modal-overlay').addClass(overlay_class);
            $('body').find('.cms-modal-overlay').toggleClass('open');
            $('body').find('.cms-modal-overlay').attr('data-modal-hidden', modal_hidden);
            $(modal_hidden).css({ 'opacity': '0', 'visibility': 'hidden' });
        });
        $('.cms-close').on('click', function(e) {
            e.preventDefault();
            var modal_hidden = $(this).data('modal-hidden');
            $('html').removeClass('cms-modal-opened');
            $(this).parents('.cms-modal-html').removeClass('open');
            $(this).parents('body').find('.cms-modal.open').removeClass('open');
            $(this).parents('body').find('.cms-modal-overlay.open').removeClass('open');
            // get back
            $(modal_hidden).css({ 'opacity': '', 'visibility': '' });
        });
        $('.cms-modal-overlay').on('click', function(e) {
            e.preventDefault();
            var modal_hidden = $(this).data('modal-hidden');
            $(this).removeClass('open');
            $('html').removeClass('cms-modal-opened');
            $(this).parent().find('.cms-modal.open').removeClass('open');
            $(this).parent().find('.cms-modal-html.open').removeClass('open');
            // get back
            $(modal_hidden).css({ 'opacity': '', 'visibility': '' });
        });
    }
    /**
     * Dropdown Mega Menu
     * Full Width
    **/
    function finanzia_dropdown_mega_menu_full_width(){
        'use strict';
        var parentPos     = $('.cms-primary-menu'),
            window_width = $(window).width();
        parentPos.find('.megamenu').each(function () {
            var megamenu      = $(this).find('> .cms-megamenu-full');
            if(megamenu.length == 1 && $(this).offset().left != 'undefined'){
                var megamenuPos    = $(this).offset().left;
                if(window_width > 1279){
                    if(finanzia_is_rtl()){
                        megamenu.css({'right': megamenuPos, 'left':'auto'});
                    } else {
                        megamenu.css({'left':megamenuPos*-1, 'right':'auto'});
                    }
                } else {
                    megamenu.css({'left':'', 'right':''});
                }
            }
            // Mega menu container
            var megamenu_container      = $(this).find('> .cms-megamenu-container');
            if(megamenu_container.length == 1 && $(this).offset().left != 'undefined'){
                var megamenu_container_w = megamenu_container.outerWidth(),
                    menuoffset    = megamenu_container.offset().left,
                    megamenuPos = (menuoffset + megamenu_container_w - window_width)/-1;
                  
                if ( (menuoffset + megamenu_container_w) > window_width) {
                    if(finanzia_is_rtl()){
                        megamenu_container.css({'right': megamenuPos, 'left':'auto'});
                    } else {
                        megamenu_container.css({'left':megamenuPos, 'right':'auto'});
                    }
                } else {
                    megamenu_container.css({'left':'', 'right':''});
                }
            }
        });
    }
    /**
     * Dropdown Touched Side
     * */
    function finanzia_dropdown_touched_side(){
        setTimeout(function() {
            $('.cms-touchedside').each(function(){
                var content = $(this).find('>.cms--touchedside'),
                    content_w = content.outerWidth(),
                    window_width = $(window).width(),
                    offsetLeft = $(this).offset().left,
                    offsetRight = window_width - offsetLeft - $(this).outerWidth(),
                    dropdown_offset = $(this).data('dropdown-offset');
                    if(typeof dropdown_offset == 'undefined'){
                        dropdown_offset = 0;
                    }
                    //
                    content.removeClass('back');
                    $(this).attr('data-offset', offsetLeft);
                    $(this).attr('data-w',content_w);
                    $(this).attr('data-ww',window_width);
                if(content.length == 1){
                    if(finanzia_is_rtl()){
                        if(offsetRight + content_w > window_width){
                            var position = offsetRight + content_w - window_width;
                            //content.css({'left':'auto', 'right': position*-1});
                            content.css({'left':'0', 'right': 'auto', 'margin-inline-end' : dropdown_offset});
                            content.addClass('back');
                        } else {
                            content.css({'left':'auto', 'right':'0', 'margin-inline-start': dropdown_offset});
                            content.removeClass('back');
                        }
                    } else {
                        if(offsetLeft + content_w > window_width){
                            var position = offsetLeft + content_w - window_width;
                            //content.css({'left': position*-1, 'right':'auto'});
                            content.css({'left': 'auto', 'right':'0', 'margin-inline-end' : dropdown_offset });
                            content.addClass('back');
                        } else {
                            content.css({'left': '0', 'right':'auto', 'margin-inline-start': dropdown_offset});
                            content.removeClass('back');
                        }
                    }
                }
            });
        }, 1000);
    }
    /**
     * Footer
     * */
    function finanzia_footer(){
        'use strict';
        var body_footer_fixed = $('.cms-footer-fixed'),
            footer_fixed = $('.cms-footer--fixed'),
            footer_fixed_h = footer_fixed.outerHeight();
            body_footer_fixed.css({'padding-bottom':footer_fixed_h});
    }
    /*
     * Lazy Images
     */
    function finanzia_lazy_images() {
        'use strict';
        setTimeout(function() {
            $('.cms-lazy').each(function() {
                $(this).removeClass('lazy-loading').addClass('cms-lazy-loaded');
            });
        }, 100);
    }
    /**
     * Check right to left
    */
    function finanzia_is_rtl(){
        "use strict"; 
        var rtl = $('html[dir="rtl"]'),
            is_rtl = rtl.length ? true : false;
        return is_rtl;
    }
    /**
     * Header WooCommerce Cart Dropdown
     * */
    function finanzia_header_cart_dropdown(){
        "use strict";
        $('.site-header-cart').each(function(){
            var header_cart = $(this),
                header_cart_h = header_cart.outerHeight(),
                header_cart_content = header_cart.find('.cms-header-cart-dropdown'),
                header_cart_content_pos = ((header_main_height - header_cart_h)/2 + header_cart_h);
            if(header_cart_content.length == 1){
                header_cart_content.css('top', header_cart_content_pos);
                $(window).on( 'scroll', function() {
                    header_cart_content.removeClass('open');
                });
                header_cart.on('click touch', function() {
                    //$(this).toggleClass('active');
                    //header_cart_content.toggleClass('open');
                });
                header_cart.on('click touch', function(e){
                    //e.preventDefault();
                    //$(this).parents('body').find('.cms-header-cart-dropdown').removeClass('open');
                    $(this).toggleClass('open');
                    header_cart_content.toggleClass("open");
                });
                $('body').on('click touch', function(){
                    //header_cart.removeClass('open');
                    //header_cart_content.removeClass('open');
                });
            }
        });
    }
    /**
     * WooCommerce 
     * Select 2 form product order form
     * */
    function finanzia_select2(){
        'use strict';
        if (typeof jQuery.fn.select2 != 'undefined') {
            $('.woocommerce-ordering select').select2({
                theme : 'cms-dropdown',
                minimumResultsForSearch : -1
            });
        } else {
            $('.woocommerce-ordering select').addClass('no-select2');
        }
    }
    /*
     * WooCommerce Quantity action
     */
    function finanzia_quantity_plus_minus_action() {
        "use strict";
        $(document).on('click', '.quantity .cms-qty-act', function() {
            var $this = $(this),
                spinner = $this.parents('.quantity'),
                input = spinner.find('input.qty'),
                step = input.attr('step'),
                min = input.attr('min'),
                max = input.attr('max'),
                value = parseInt(input.val());
            if (!value) value = 0;
            if (!step) step = 1;
            step = parseInt(step);
            if (!min) min = 0;
            var type = $this.hasClass('cms-qty-up') ? 'up' : 'down';
            switch (type) {
                case 'up':
                    if (!(max && value >= max))
                        input.val(value + step).change();
                    break;
                case 'down':
                    if (value > min)
                        input.val(value - step).change();
                    break;
            }
            if (max && (parseInt(input.val()) > max))
                input.val(max).change();
            if (parseInt(input.val()) < min)
                input.val(min).change();
        });
    }
    /**
     * WooCommerce Product Gallery
     * Flex direction Nav position
     * 
     * */
    function finanzia_single_product_gallery_arrows(){
        'use strict';
        // fix arrow position
        if(typeof $.flexslider != 'undefined'){
            setTimeout(function() {
                $('.woocommerce-product-gallery').each(function (){
                var flex_viewport = $(this).find('.flex-viewport'),
                flex_viewport_h = flex_viewport.outerHeight(),
                arrow_pos = (flex_viewport_h/2),
                arrow = $(this).find('.flex-direction-nav li');
                arrow.css('top', arrow_pos);
            }), 1000});
        }
    }
    /**
     * WooCommerce
     * Single Product Review
     * 
     * */
    function finanzia_single_product_star_rating(){
        // Star ratings for comments
        $('body').on( 'init', '#rating', function() {
            setTimeout(function() {
                $( '#rating' ).parent().find('.stars').html(
                    //'<p class="stars svgs">\
                        '<span class="stars-inner">\
                            <a class="star-1" href="#"><svg viewBox="0 0 14 14" xmlns="http://www.w3.org/2000/svg"><path d="M10.8809 13.3471L7 10.9186L3.11913 13.3471C2.97814 13.4364 2.79628 13.4296 2.66052 13.3311C2.52514 13.2329 2.46304 13.0623 2.50389 12.9001L3.61418 8.45845L0.146667 5.51851C0.0184791 5.41115 -0.0315874 5.23651 0.0200924 5.07751C0.0717721 4.91809 0.215163 4.80634 0.381796 4.79472L4.90757 4.47868L6.61948 0.232518C6.74527 -0.0775059 7.25473 -0.0775059 7.38052 0.232518L9.09243 4.47868L13.6182 4.79472C13.7848 4.80634 13.9282 4.91809 13.9799 5.07751C14.0316 5.23651 13.9815 5.41115 13.8533 5.51851L10.3858 8.45851L11.4961 12.9001C11.5369 13.0624 11.4749 13.233 11.3395 13.3311C11.2009 13.4318 11.0196 13.434 10.8809 13.3471Z"/></svg><span class="screen-reader-text">1</span></a>\
                            <a class="star-2" href="#"><svg viewBox="0 0 14 14" xmlns="http://www.w3.org/2000/svg"><path d="M10.8809 13.3471L7 10.9186L3.11913 13.3471C2.97814 13.4364 2.79628 13.4296 2.66052 13.3311C2.52514 13.2329 2.46304 13.0623 2.50389 12.9001L3.61418 8.45845L0.146667 5.51851C0.0184791 5.41115 -0.0315874 5.23651 0.0200924 5.07751C0.0717721 4.91809 0.215163 4.80634 0.381796 4.79472L4.90757 4.47868L6.61948 0.232518C6.74527 -0.0775059 7.25473 -0.0775059 7.38052 0.232518L9.09243 4.47868L13.6182 4.79472C13.7848 4.80634 13.9282 4.91809 13.9799 5.07751C14.0316 5.23651 13.9815 5.41115 13.8533 5.51851L10.3858 8.45851L11.4961 12.9001C11.5369 13.0624 11.4749 13.233 11.3395 13.3311C11.2009 13.4318 11.0196 13.434 10.8809 13.3471Z"/></svg><span class="screen-reader-text">2</span></a>\
                            <a class="star-3" href="#"><svg viewBox="0 0 14 14" xmlns="http://www.w3.org/2000/svg"><path d="M10.8809 13.3471L7 10.9186L3.11913 13.3471C2.97814 13.4364 2.79628 13.4296 2.66052 13.3311C2.52514 13.2329 2.46304 13.0623 2.50389 12.9001L3.61418 8.45845L0.146667 5.51851C0.0184791 5.41115 -0.0315874 5.23651 0.0200924 5.07751C0.0717721 4.91809 0.215163 4.80634 0.381796 4.79472L4.90757 4.47868L6.61948 0.232518C6.74527 -0.0775059 7.25473 -0.0775059 7.38052 0.232518L9.09243 4.47868L13.6182 4.79472C13.7848 4.80634 13.9282 4.91809 13.9799 5.07751C14.0316 5.23651 13.9815 5.41115 13.8533 5.51851L10.3858 8.45851L11.4961 12.9001C11.5369 13.0624 11.4749 13.233 11.3395 13.3311C11.2009 13.4318 11.0196 13.434 10.8809 13.3471Z"/></svg><span class="screen-reader-text">3</span></a>\
                            <a class="star-4" href="#"><svg viewBox="0 0 14 14" xmlns="http://www.w3.org/2000/svg"><path d="M10.8809 13.3471L7 10.9186L3.11913 13.3471C2.97814 13.4364 2.79628 13.4296 2.66052 13.3311C2.52514 13.2329 2.46304 13.0623 2.50389 12.9001L3.61418 8.45845L0.146667 5.51851C0.0184791 5.41115 -0.0315874 5.23651 0.0200924 5.07751C0.0717721 4.91809 0.215163 4.80634 0.381796 4.79472L4.90757 4.47868L6.61948 0.232518C6.74527 -0.0775059 7.25473 -0.0775059 7.38052 0.232518L9.09243 4.47868L13.6182 4.79472C13.7848 4.80634 13.9282 4.91809 13.9799 5.07751C14.0316 5.23651 13.9815 5.41115 13.8533 5.51851L10.3858 8.45851L11.4961 12.9001C11.5369 13.0624 11.4749 13.233 11.3395 13.3311C11.2009 13.4318 11.0196 13.434 10.8809 13.3471Z"/></svg><span class="screen-reader-text">4</span></a>\
                            <a class="star-5" href="#"><svg viewBox="0 0 14 14" xmlns="http://www.w3.org/2000/svg"><path d="M10.8809 13.3471L7 10.9186L3.11913 13.3471C2.97814 13.4364 2.79628 13.4296 2.66052 13.3311C2.52514 13.2329 2.46304 13.0623 2.50389 12.9001L3.61418 8.45845L0.146667 5.51851C0.0184791 5.41115 -0.0315874 5.23651 0.0200924 5.07751C0.0717721 4.91809 0.215163 4.80634 0.381796 4.79472L4.90757 4.47868L6.61948 0.232518C6.74527 -0.0775059 7.25473 -0.0775059 7.38052 0.232518L9.09243 4.47868L13.6182 4.79472C13.7848 4.80634 13.9282 4.91809 13.9799 5.07751C14.0316 5.23651 13.9815 5.41115 13.8533 5.51851L10.3858 8.45851L11.4961 12.9001C11.5369 13.0624 11.4749 13.233 11.3395 13.3311C11.2009 13.4318 11.0196 13.434 10.8809 13.3471Z"/></svg><span class="screen-reader-text">5</span></a>\
                        </span>'
                    //</p>'
                ), 1000 
            });
        })
    }
    /**
     * WooCommerce
     * Place Order Button
     * Wrap text by Span
     * */
    function finanzia_woo_checkout_place_order_button(){
        'use strict';
        setTimeout(function() {
            $('#place_order').wrapInner('<span class="cms-place-order"></span>');
        }, 1000);
    }
    /**
     * WooCommerce Currency Switcher
     * 
     * Add currency to menu
     * **/
    function finanzia_woocs_menu_change_currency(){
        'use strict';
         $('.cms-woocs').on('click' , function (e) {
            e.preventDefault();
            var currency = $(this).data('currency');
            window.location.href = location.protocol + '//' + location.host + location.pathname + '?currency=' + currency;
         });
    }
    // Contact form 7
    function finanzia_wpcf7(){
        'use strict';
        // add radio class active for default item
        $('.wpcf7-radio').each(function(){
            $('input[checked="checked"]').parents('.wpcf7-list-item').addClass('active');
        });
        // add radio class active on click
        $('.wpcf7-radio .wpcf7-list-item').on('click', function(){
            $(this).parent().find('.wpcf7-list-item').removeClass('active');
            $(this).toggleClass('active');
        });
        // add checkbox class active
        $('.wpcf7-checkbox .wpcf7-list-item').on('click', function(){
            $(this).toggleClass('active');
        });
        // date time
        $('.wpcf7-form-control-wrap.cms-date-time').on('click', function() {
            $(this).addClass('active');
        });
    }
})(jQuery);

// Animate on Scroll
(function( $ ) {
    "use strict";
    window.finanzia_requestAnimFrame = function() {
        return (
            window.requestAnimationFrame       ||
            window.webkitRequestAnimationFrame ||
            window.mozRequestAnimationFrame    ||
            window.oRequestAnimationFrame      ||
            window.msRequestAnimationFrame     ||
            function( callback ) {
                window.setTimeout( callback, 1000 / 60 );
            }
        );
    }();
    window.finanzia_floating_image_loop = function() {
        var win_w = window.innerWidth;
        var win_h = window.innerHeight;
        $( '.cms_floating_image_image' ).each(function() {
            //var elem = $(this).find('.cms_floating_image_image');
            var bounds = this.getBoundingClientRect();
            if ( bounds.top < win_h && bounds.bottom > 0 ) {
                var speed = $(this).attr( 'data-speed' ) / 10;
                //var speed = elem.attr( 'data-speed' ) / 10;
                var ypos = ( bounds.top - win_h/5 ) * speed;
               // elem.css( 'transform', 'translateY(' + ypos + 'px)' );
                $(this).css( 'transform', 'translateY(' + ypos + 'px)' );
            }

        });
        window.finanzia_floating_image_lock = false;
    }
    
    window.finanzia_floating_image_lock = false;
    
    $( window ).on( 'scroll', function() {
        if ( ! window.finanzia_floating_image_lock ) {
            window.finanzia_floating_image_lock = true;
            finanzia_requestAnimFrame( finanzia_floating_image_loop );
        }
    });
    
    finanzia_requestAnimFrame( finanzia_floating_image_loop );

    $( window ).on( "load", function() {  
        finanzia_requestAnimFrame( finanzia_floating_image_loop );
    });
})( jQuery );
/**
 * WPC Smart Wishlist
 * update wishlist count on header 
*/
jQuery( document ).on( 'woosw_change_count', function( event, count ) {
    jQuery('.wishlist-count').html(count);
    jQuery('.wishlist-icon').attr('data-count',count);
} );
/**
 * WPC Smart Wishlist
 * update custom icon
*/
jQuery('.cms-woosw-btn').not('.woosw-added').on('click touch', function(e){
    // change text
    jQuery(this).attr('data-hint',cms_woosw_vars.button_text_adding);
    jQuery(this).attr('arial-label',cms_woosw_vars.button_text_adding);
    // change icon
    jQuery(this).find('.cms-woosw-btn-icon').append(cms_woosw_vars.icon_loadding);
    jQuery(this).find('.cms-woosw-btn-icon').addClass('cms-loading');
});
jQuery( document ).on( 'woosw_add', function( event, id ) {
    // change text
    jQuery(this).attr('data-hint',cms_woosw_vars.button_text_added);
    jQuery(this).attr('arial-label',cms_woosw_vars.button_text_added);
    // change icon
    if(jQuery('.woosw-btn-'+id).hasClass('woosw-added')){
        jQuery('.woosw-btn-'+id).find('.cms-woosw-btn-icon').html(cms_woosw_vars.icon_added).removeClass('cms-loading');
    }
} );
jQuery( document ).on( 'woosw_remove', function( event, product_id ) {
    // change text
    jQuery('.woosw-btn-'+product_id).attr('data-hint',woosw_vars.button_text);
    jQuery('.woosw-btn-'+product_id).attr('arial-label',woosw_vars.button_text);
    // change icon
    if(jQuery('.woosw-btn-'+product_id).not('.woosw-added')){
        jQuery('.woosw-btn-'+product_id).find('.cms-woosw-btn-icon').html(cms_woosw_vars.icon_normal).removeClass('cms-loading');
    }
});
jQuery( document ).on( 'woosw_empty', function( event, id ) {
    // change text
    jQuery('.woosw-btn').attr('data-hint',woosw_vars.button_text);
    jQuery('.woosw-btn').attr('arial-label',woosw_vars.button_text);
    // change icon
    jQuery('.woosw-btn').find('.cms-woosw-btn-icon').html(cms_woosw_vars.icon_normal).removeClass('cms-loading');
});

/**
 * WPC Smart Compare
 * update compare count on header 
*/
jQuery( document ).on( 'woosc_change_count', function( event, count ) {
    jQuery('.compare-count').html(count);
    jQuery('.compare-icon').attr('data-count',count);
} );

/**
 * Popup Newsletter
 * 
 * */
(function ( $ ) {
    'use strict';
    window.Core                = {};
    Core.body         = $( 'body' );
    Core.html         = $( 'html' );
    Core.windowWidth  = $( window ).width();
    Core.windowHeight = $( window ).height();
    Core.scroll       = 0;
    $( window ).on(
        'load',
        function () {
            SubscribeModal.init();
        }
    );

    var SubscribeModal = {
        init: function () {
            this.holder = $( '#cms-subscribe-popup' );

            if ( this.holder.length ) {
                var $preventHolder = this.holder.find( '.cms-sp-prevent-inner' ),
                    $modalClose    = $( '.cms-sp-close' ),
                    disabledPopup  = 'no';

                if ( $preventHolder.length ) {
                    var isLocalStorage = this.holder.hasClass( 'cms-sp-prevent-cookies' ),
                        $preventInput  = $preventHolder.find( '.cms-sp-prevent-input' );

                    if ( isLocalStorage ) {
                        disabledPopup = localStorage.getItem( 'disabledPopup' );
                        sessionStorage.removeItem( 'disabledPopup' );
                    } else {
                        disabledPopup = sessionStorage.getItem( 'disabledPopup' );
                        localStorage.removeItem( 'disabledPopup' );
                    }

                    $preventHolder.children().on(
                        'click',
                        function ( e ) {
                            $preventInput.val(this.checked);

                            if ( $preventInput.attr('value') === 'true' ) {
                                if ( isLocalStorage ) {
                                    localStorage.setItem( 'disabledPopup', 'yes' );
                                } else {
                                    sessionStorage.setItem( 'disabledPopup', 'yes' );
                                }
                            } else {
                                if ( isLocalStorage ) {
                                    localStorage.setItem( 'disabledPopup', 'no' );
                                } else {
                                    sessionStorage.setItem( 'disabledPopup', 'no' );
                                }
                            }
                        }
                    );
                }

                if ( disabledPopup !== 'yes' ) {
                    if ( Core.body.hasClass( 'cms-sp-opened' ) ) {
                        SubscribeModal.handleClassAndScroll( 'remove' );
                    } else {
                        SubscribeModal.handleClassAndScroll( 'add' );
                    }

                    $modalClose.on(
                        'click',
                        function ( e ) {
                            e.preventDefault();

                            SubscribeModal.handleClassAndScroll( 'remove' );
                        }
                    );

                    // Close on escape
                    $( document ).keyup(
                        function ( e ) {
                            if ( e.keyCode === 27 ) { // KeyCode for ESC button is 27
                                SubscribeModal.handleClassAndScroll( 'remove' );
                            }
                        }
                    );
                }
            }
        },

        handleClassAndScroll: function ( option ) {
            if ( option === 'remove' ) {
                Core.body.removeClass( 'cms-sp-opened' );
            }

            if ( option === 'add' ) {
                Core.body.addClass( 'cms-sp-opened' );
            }
        },
    };

})( jQuery );
/**
 * Finanzia 
 * Mouse Cursor
 * 
 * **/
(function($) {
    'use strict';
    // This case is important when theme is not active
    if (typeof FinanziaCore !== 'object') {
        window.FinanziaCore = {};
    }
    window.FinanziaCore = {};
    FinanziaCore.body = $('body');
    FinanziaCore.html = $('html');
    FinanziaCore.windowWidth = $(window).width();
    FinanziaCore.windowHeight = $(window).height();
    FinanziaCore.scroll = 0;

    $(document).ready(function() {
        CMSThemeCursor().init();
    });

    function CMSThemeCursor() {
        var cursorEnabled = FinanziaCore.body.hasClass('cms-theme-cursor'),
            cursor = $('#cms-theme-cursor');
        // Move
        var moveCursor = function() {
            var transformCursor = function(x, y) {
                cursor.css({
                    'transform': 'translate3d(' + x + 'px, ' + y + 'px, 0)'
                });
            };
            var handleMove = function(e) {
                var x = e.clientX - cursor.width() / 2,
                    y = e.clientY - cursor.height() / 2;
                requestAnimationFrame(function() {
                    transformCursor(x, y);
                });
            };
            $(window).on('mousemove', handleMove);
        };
        // Hover
        var hoverClass = function() {
            $('.button').disabled = false;
            var items = 'a, button';
            var addCSSClass = function() {
                !cursor.hasClass('cms-hovering') && cursor.addClass('cms-hovering');
            };
            var removeCSSClass = function() {
                cursor.hasClass('cms-hovering') && cursor.removeClass('cms-hovering');
            };
            $(document).on('mouseenter', items, addCSSClass);
            $(document).on('mouseleave', items, removeCSSClass);
        };
        // Show Cursor
        var showCursor = function() {
            !cursor.hasClass('cms-visible') && cursor.addClass('cms-visible');
        }
        // Hide Cursor
        var hideCursor = function() {
            cursor.hasClass('cms-visible') && cursor.removeClass('cms-visible cms-hovering');
        };
        // Override Cursor
        var overrideCursor = function() {
            cursor.toggleClass('cms-override');
        };
        // Control Items
        var controlItems = function() {
            var items = $('.cms-hover-move');
            items.length &&
                items.each(function() {
                    var item = $(this),
                        inner = item.children(),
                        coeff = item.parent().data('move') == 'strict' ? 0.6 : 1,
                        limit = 9 * coeff;
                    var cX, cY, w, h, x, y, inRange; //position variables
                    var updatePosition = function() {
                        cX = cursor.offset().left;
                        cY = cursor.offset().top;
                        w = item.width();
                        h = item.height();
                        x = item.offset().left + w / 2;
                        y = item.offset().top + h / 2;
                        inRange = Math.abs(x - cX) < w * coeff && Math.abs(y - cY) < h * coeff;
                    };
                    var coords = function() {
                        return {
                            x: Math.abs(cX - x) < limit ? cX - x : limit * (cX - x) / Math.abs(cX - x),
                            y: Math.abs(cY - y) < limit ? cY - y : limit * (cY - y) / Math.abs(cY - y)
                        }
                    };
                    var moveItem = function() {
                        inner.addClass('cms-moving');
                        var deltaX = 0,
                            deltaY = 0,
                            dX = coords().x,
                            dY = coords().y;
                        var transformItem = function() {
                            deltaX += (coords().x - dX) / 5;
                            deltaY += (coords().y - dY) / 5;
                            deltaX.toFixed(2) !== dX.toFixed(2) &&
                                inner.css({
                                    'transform': 'translate3d(' + deltaX + 'px, ' + deltaY + 'px, 0)',
                                    'transition': '1s cubic-bezier(.2,.84,.5,1)'
                                });
                            dX = deltaX;
                            dY = deltaY;
                            requestAnimationFrame(function() {
                                inRange && transformItem();
                            });
                        };
                        transformItem();
                    };
                    var resetItem = function() {
                        inner
                            .removeClass('cms-moving')
                            .css({
                                'transition': 'transform 1.6s',
                                'transform': 'translate3d(0px, 0px, 0px)'
                            })
                            .one(FinanziaCore.CMSTransitionEnd, function() {
                                inner.removeClass('cms-controlled');
                                inner.css({
                                    'transition': 'none'
                                });
                            });
                    };
                    var setState = function() {
                        updatePosition();

                        if (inRange) {
                            !inner.hasClass('cms-moving') && moveItem(); //start move
                        } else {
                            inner.hasClass('cms-moving') && resetItem();
                        }
                        requestAnimationFrame(setState);
                    };
                    requestAnimationFrame(setState);
                });
        };

        var changeCursor = function() {
            var instances = [{
                        type: 'light',
                        triggers: '.cms-cursor-light'
                    },
                    {
                        type: 'dark',
                        triggers: '.cms-cursor-dark'
                    },
                    {
                        type: 'preloader',
                        triggers: '.cms-page-spinner'
                    },
                    {
                        type: 'drag',
                        triggers: '.cms-cursor-drag'
                    },
                    {
                        type: 'image',
                        cursor: '',
                        triggers: '.cms-cursor-img'
                    },
                ],
                triggers = '',
                hides = '.cms-portfolio-info-float .cms-pli-link, .cms-pls-item-inner, .fluidvids, iframe',
                overrides = '.cms-portfolio-list.cms-item-layout--info-on-hover-boxed .cms-e';

            var setCursor = function(type) {
                cursor.addClass('cms-' + type);
            };

            var resetCursor = function() {
                instances.forEach(function(instance) {
                    cursor.removeClass('cms-' + instance.type);
                });
            };

            instances.forEach(function(instance, i) {
                triggers += instance.triggers;
                if (i + 1 < instances.length) triggers += ', ';

                $(document).on('mouseenter', instance.triggers, function() {
                    setCursor(instance.type);
                });
            });

            $(document).on('mouseleave', triggers, resetCursor);
            $(document).on('mouseenter mouseleave', overrides, function() {
                overrideCursor();
            });
            $(document).on('mousemove', hides, function() {
                hideCursor();
            });
            $(document).on('mouseleave', hides, function() {
                showCursor();
            });
            $(document).on('mouseleave', hideCursor);
            $(document).on('mouseenter', showCursor);
        };

        var isIE = function() {

            var ua = window.navigator.userAgent;
            var msie = ua.indexOf("MSIE ");
            var isIE = false;

            if (msie > 0 || !!navigator.userAgent.match(/Trident.*rv\:11\./)) // If Internet Explorer
            {
                isIE = true;

                if (cursorEnabled) {
                    FinanziaCore.body.removeClass('cms-theme-cursor');
                }
            } else // If another browser
            {
                isIE = false;
            }

            return isIE;
        };

        var init = function() {
            $(document).one('mousemove', function() {
                showCursor();
            });
            moveCursor();
            hoverClass();
            controlItems();
            changeCursor();
        };

        return {
            init: function() {
                !Modernizr.touch && cursorEnabled && !isIE() && init();
            }
        }
    }
})(jQuery);