<?php
/**
 * Add child styles.
 */
function finanzia_child_enqueue_styles()
{
  wp_enqueue_style('finanzia-child', get_stylesheet_directory_uri() . '/assets/css/child-theme.css', array('finanzia'));
}
add_action('wp_enqueue_scripts', 'finanzia_child_enqueue_styles', 10 , 99999);
/**
  * Set up Trevox Child Theme's textdomain.
  *
  * Declare textdomain for this child theme.
  * Translations can be added to the /languages/ directory.
  */
add_action( 'after_setup_theme', 'finanzia_child_theme_setup' );
function finanzia_child_theme_setup() {
    load_child_theme_textdomain( 'finanzia-child', get_stylesheet_directory() . '/languages' );
}
/**
 * CMS Portal
 * child theme active
 *
*/
add_action('after_switch_theme', 'finanzia_child_redirect_to_welcome_page');
function finanzia_child_redirect_to_welcome_page()
{
    if (is_child_theme()) {
        $parent_theme = wp_get_theme()->parent();
        if (class_exists('CMS_PORTAL')) {
            wp_safe_redirect(admin_url("themes.php?page={$parent_theme->get('TextDomain')}"));
        } else {
            wp_safe_redirect(admin_url("themes.php?page={$parent_theme->get('TextDomain')}-welcome"));
        }
    }
}