<?php
// remove lazy load 
add_filter( 'wp_lazy_loading_enabled', '__return_false' );
// Remove Emoji
remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
remove_action( 'wp_print_styles', 'print_emoji_styles' );

// User Custom Fields
/**
 * User custom fields.
 */
if(!function_exists('tco_user_fields')){
    add_action( 'show_user_profile', 'tco_user_fields' );
    add_action( 'edit_user_profile', 'tco_user_fields' );
    function tco_user_fields($user){

        $user_facebook = get_user_meta($user->ID, 'user_facebook', true);
        $user_twitter = get_user_meta($user->ID, 'user_twitter', true);
        $user_linkedin = get_user_meta($user->ID, 'user_linkedin', true);
        $user_skype = get_user_meta($user->ID, 'user_skype', true);
        $user_google = get_user_meta($user->ID, 'user_google', true);
        $user_youtube = get_user_meta($user->ID, 'user_youtube', true);
        $user_vimeo = get_user_meta($user->ID, 'user_vimeo', true);
        $user_tumblr = get_user_meta($user->ID, 'user_tumblr', true);
        $user_rss = get_user_meta($user->ID, 'user_rss', true);
        $user_pinterest = get_user_meta($user->ID, 'user_pinterest', true);
        $user_instagram = get_user_meta($user->ID, 'user_instagram', true);
        $user_yelp = get_user_meta($user->ID, 'user_yelp', true);
        $user_tiktok = get_user_meta($user->ID, 'user_tiktok', true);

        ?>
        <h3><?php esc_html_e('Social', 'medsky'); ?></h3>
        <table class="form-table">
            <tr>
                <th><label for="user_facebook"><?php esc_html_e('Facebook', 'medsky'); ?></label></th>
                <td>
                    <input id="user_facebook" name="user_facebook" type="text" value="<?php echo esc_attr(isset($user_facebook) ? $user_facebook : ''); ?>" />
                </td>
            </tr>
            <tr>
                <th><label for="user_twitter"><?php esc_html_e('Twitter', 'medsky'); ?></label></th>
                <td>
                    <input id="user_twitter" name="user_twitter" type="text" value="<?php echo esc_attr(isset($user_twitter) ? $user_twitter : ''); ?>" />
                </td>
            </tr>
            <tr>
                <th><label for="user_linkedin"><?php esc_html_e('Linkedin', 'medsky'); ?></label></th>
                <td>
                    <input id="user_linkedin" name="user_linkedin" type="text" value="<?php echo esc_attr(isset($user_linkedin) ? $user_linkedin : ''); ?>" />
                </td>
            </tr>
            <tr>
                <th><label for="user_pinterest"><?php esc_html_e('Pinterest', 'medsky'); ?></label></th>
                <td>
                    <input id="user_pinterest" name="user_pinterest" type="text" value="<?php echo esc_attr(isset($user_pinterest) ? $user_pinterest : ''); ?>" />
                </td>
            </tr>
            <tr>
                <th><label for="user_instagram"><?php esc_html_e('Instagram', 'medsky'); ?></label></th>
                <td>
                    <input id="user_instagram" name="user_instagram" type="text" value="<?php echo esc_attr(isset($user_instagram) ? $user_instagram : ''); ?>" />
                </td>
            </tr>
            <tr>
                <th><label for="user_tiktok"><?php esc_html_e('Tiktok', 'medsky'); ?></label></th>
                <td>
                    <input id="user_tiktok" name="user_tiktok" type="text" value="<?php echo esc_attr(isset($user_tiktok) ? $user_tiktok : ''); ?>" />
                </td>
            </tr>
            <tr>
                <th><label for="user_skype"><?php esc_html_e('Skype', 'medsky'); ?></label></th>
                <td>
                    <input id="user_skype" name="user_skype" type="text" value="<?php echo esc_attr(isset($user_skype) ? $user_skype : ''); ?>" />
                </td>
            </tr>
            <tr>
                <th><label for="user_google"><?php esc_html_e('Google', 'medsky'); ?></label></th>
                <td>
                    <input id="user_google" name="user_google" type="text" value="<?php echo esc_attr(isset($user_google) ? $user_google : ''); ?>" />
                </td>
            </tr>
            <tr>
                <th><label for="user_youtube"><?php esc_html_e('Youtube', 'medsky'); ?></label></th>
                <td>
                    <input id="user_youtube" name="user_youtube" type="text" value="<?php echo esc_attr(isset($user_youtube) ? $user_youtube : ''); ?>" />
                </td>
            </tr>
            <tr>
                <th><label for="user_vimeo"><?php esc_html_e('Vimeo', 'medsky'); ?></label></th>
                <td>
                    <input id="user_vimeo" name="user_vimeo" type="text" value="<?php echo esc_attr(isset($user_vimeo) ? $user_vimeo : ''); ?>" />
                </td>
            </tr>
            <tr>
                <th><label for="user_tumblr"><?php esc_html_e('Tumblr', 'medsky'); ?></label></th>
                <td>
                    <input id="user_tumblr" name="user_tumblr" type="text" value="<?php echo esc_attr(isset($user_tumblr) ? $user_tumblr : ''); ?>" />
                </td>
            </tr>
            <tr>
                <th><label for="user_rss"><?php esc_html_e('Rss', 'medsky'); ?></label></th>
                <td>
                    <input id="user_rss" name="user_rss" type="text" value="<?php echo esc_attr(isset($user_rss) ? $user_rss : ''); ?>" />
                </td>
            </tr>
            <tr>
                <th><label for="user_yelp"><?php esc_html_e('Yelp', 'medsky'); ?></label></th>
                <td>
                    <input id="user_yelp" name="user_yelp" type="text" value="<?php echo esc_attr(isset($user_yelp) ? $user_yelp : ''); ?>" />
                </td>
            </tr>
        </table>
        <?php
    }
}
/**
 * Save user custom fields.
 */
if(!function_exists('tco_save_user_custom_fields')){
    add_action( 'personal_options_update', 'tco_save_user_custom_fields' );
    add_action( 'edit_user_profile_update', 'tco_save_user_custom_fields' );
    function tco_save_user_custom_fields( $user_id )
    {
        if ( !current_user_can( 'edit_user', $user_id ) )
            return false;

        if(isset($_POST['user_facebook']))
            update_user_meta( $user_id, 'user_facebook', $_POST['user_facebook'] );
        if(isset($_POST['user_twitter']))
            update_user_meta( $user_id, 'user_twitter', $_POST['user_twitter'] );
        if(isset($_POST['user_linkedin']))
            update_user_meta( $user_id, 'user_linkedin', $_POST['user_linkedin'] );
        if(isset($_POST['user_skype']))
            update_user_meta( $user_id, 'user_skype', $_POST['user_skype'] );
        if(isset($_POST['user_google']))
            update_user_meta( $user_id, 'user_google', $_POST['user_google'] );
        if(isset($_POST['user_youtube']))
            update_user_meta( $user_id, 'user_youtube', $_POST['user_youtube'] );
        if(isset($_POST['user_vimeo']))
            update_user_meta( $user_id, 'user_vimeo', $_POST['user_vimeo'] );
        if(isset($_POST['user_tumblr']))
            update_user_meta( $user_id, 'user_tumblr', $_POST['user_tumblr'] );
        if(isset($_POST['user_rss']))
            update_user_meta( $user_id, 'user_rss', $_POST['user_rss'] );
        if(isset($_POST['user_pinterest']))
            update_user_meta( $user_id, 'user_pinterest', $_POST['user_pinterest'] );
        if(isset($_POST['user_instagram']))
            update_user_meta( $user_id, 'user_instagram', $_POST['user_instagram'] );
        if(isset($_POST['user_yelp']))
            update_user_meta( $user_id, 'user_yelp', $_POST['user_yelp'] );
        if(isset($_POST['user_tiktok']))
            update_user_meta( $user_id, 'user_tiktok', $_POST['user_tiktok'] );
    }
}