<?php
add_filter('tco_theme_options_args', 'tco_theme_options_args_sample', 9);
function tco_theme_options_args_sample()
{
    $args = [
        'general' => [
            'title' => esc_html__('General', TCO_TEXT_DOMAIN),
            'fields' => [
                'favicon' => [
                    'type' => Theme_Core_Options::MEDIA_FIELD,
                    'title' => esc_html__('Favicon', TCO_TEXT_DOMAIN),
                ],
                'show_page_loading' => [
                    'type' => Theme_Core_Options::SWITCH_FIELD,
                    'title' => esc_html__('Enable Page Loading', TCO_TEXT_DOMAIN),
                    'subtitle' => esc_html__('Enable page loading effect when you load site.', TCO_TEXT_DOMAIN),
                ],
                'dev_mode' => [
                    'type' => Theme_Core_Options::SWITCH_FIELD,
                    'title' => esc_html__('Dev Mode (not recommended)', TCO_TEXT_DOMAIN),
                    'description' => esc_html__('no minimize , generate css over time...', TCO_TEXT_DOMAIN),
                ],
            ],
        ],
        'header' => [
            'title' => esc_html__('Header', TCO_TEXT_DOMAIN),
            'sections' => [
                'general' => [
                    'title' => esc_html__('General', TCO_TEXT_DOMAIN),
                    'fields' => [
                        'header_layout' => [
                            'type' => Theme_Core_Options::IMAGE_SELECT_FIELD,
                            'title' => esc_html__('Layout', TCO_TEXT_DOMAIN),
                            'subtitle' => esc_html__('Select a layout for header.', TCO_TEXT_DOMAIN),
                            'options' => [
                                '1' => TCO_URL . 'assets/images/header-layout/h1.jpg',
                                '2' => TCO_URL . 'assets/images/header-layout/h2.jpg',
                                '3' => TCO_URL . 'assets/images/header-layout/h3.jpg',
                            ],
                            'default' => '1',
                        ],
                        'sticky_on' => [
                            'type' => Theme_Core_Options::SWITCH_FIELD,
                            'title' => esc_html__('Sticky Header', TCO_TEXT_DOMAIN),
                            'subtitle' => esc_html__('Header will be sticked when applicable.', TCO_TEXT_DOMAIN),
                        ],
                        'cart_icon' => [
                            'type' => Theme_Core_Options::SWITCH_FIELD,
                            'title' => esc_html__('Cart Icon', TCO_TEXT_DOMAIN),
                        ],
                        'search_icon' => [
                            'type' => Theme_Core_Options::SWITCH_FIELD,
                            'title' => esc_html__('Cart Icon', TCO_TEXT_DOMAIN),
                        ],
                    ],
                ],
                'top-bar' => [
                    'title' => esc_html__('Top Bar', TCO_TEXT_DOMAIN),
                    'fields' => [
                        'phone_label' => [
                            'type' => Theme_Core_Options::TEXT_FIELD,
                            'title' => esc_html__('Phone Label', TCO_TEXT_DOMAIN),
                        ],
                        'phone_number' => [
                            'type' => Theme_Core_Options::TEXT_FIELD,
                            'title' => esc_html__('Phone Number', TCO_TEXT_DOMAIN),
                        ],
                        'phone_link' => [
                            'type' => Theme_Core_Options::TEXT_FIELD,
                            'title' => esc_html__('Phone Link', TCO_TEXT_DOMAIN),
                        ],
                        'email_label' => [
                            'type' => Theme_Core_Options::TEXT_FIELD,
                            'title' => esc_html__('Email Label', TCO_TEXT_DOMAIN),
                        ],
                        'email_address' => [
                            'type' => Theme_Core_Options::TEXT_FIELD,
                            'title' => esc_html__('Email Address', TCO_TEXT_DOMAIN),
                        ],
                        'time_label' => [
                            'type' => Theme_Core_Options::TEXT_FIELD,
                            'title' => esc_html__('Time Label', TCO_TEXT_DOMAIN),
                        ],
                        'time' => [
                            'type' => Theme_Core_Options::TEXT_FIELD,
                            'title' => esc_html__('Time Label', TCO_TEXT_DOMAIN),
                        ],
                        'h_social_facebook_url' => [
                            'type' => Theme_Core_Options::TEXT_FIELD,
                            'title' => esc_html__('Facebook URL', TCO_TEXT_DOMAIN),
                        ],
                        'h_social_twitter_url' => [
                            'type' => Theme_Core_Options::TEXT_FIELD,
                            'title' => esc_html__('Twitter URL', TCO_TEXT_DOMAIN),
                        ],
                        'h_social_linkedin_url' => [
                            'type' => Theme_Core_Options::TEXT_FIELD,
                            'title' => esc_html__('Linkedin URL', TCO_TEXT_DOMAIN),
                        ],
                        'h_social_instagram_url' => [
                            'type' => Theme_Core_Options::TEXT_FIELD,
                            'title' => esc_html__('Instagram URL', TCO_TEXT_DOMAIN),
                        ],
                        'h_social_google_url' => [
                            'type' => Theme_Core_Options::TEXT_FIELD,
                            'title' => esc_html__('Google URL', TCO_TEXT_DOMAIN),
                        ],
                        'h_social_skype_url' => [
                            'type' => Theme_Core_Options::TEXT_FIELD,
                            'title' => esc_html__('Skype URL', TCO_TEXT_DOMAIN),
                        ],
                        'h_social_pinterest_url' => [
                            'type' => Theme_Core_Options::TEXT_FIELD,
                            'title' => esc_html__('Pinterest URL', TCO_TEXT_DOMAIN),
                        ],
                        'h_social_vimeo_url' => [
                            'type' => Theme_Core_Options::TEXT_FIELD,
                            'title' => esc_html__('Vimeo URL', TCO_TEXT_DOMAIN),
                        ],
                        'h_social_youtube_url' => [
                            'type' => Theme_Core_Options::TEXT_FIELD,
                            'title' => esc_html__('Youtube URL', TCO_TEXT_DOMAIN),
                        ],
                        'h_social_yelp_url' => [
                            'type' => Theme_Core_Options::TEXT_FIELD,
                            'title' => esc_html__('Yelp URL', TCO_TEXT_DOMAIN),
                        ],
                        'h_social_tumblr_url' => [
                            'type' => Theme_Core_Options::TEXT_FIELD,
                            'title' => esc_html__('Tumblr URL', TCO_TEXT_DOMAIN),
                        ],
                        'h_social_tripadvisor_url' => [
                            'type' => Theme_Core_Options::TEXT_FIELD,
                            'title' => esc_html__('Tripadvisor URL', TCO_TEXT_DOMAIN),
                        ],
                    ],
                ],
                'logo' => [
                    'title' => esc_html__('Logo', TCO_TEXT_DOMAIN),
                    'fields' => [
                        'logo_light' => [
                            'type' => Theme_Core_Options::MEDIA_FIELD,
                            'title' => esc_html__('Logo Light', TCO_TEXT_DOMAIN),
                            'default' => [
                                'url' => TCO_URL . '/assets/images/logo-light.png'
                            ]
                        ],
                        'logo' => [
                            'type' => Theme_Core_Options::MEDIA_FIELD,
                            'title' => esc_html__('Logo Dark', TCO_TEXT_DOMAIN),
                            'default' => [
                                'url' => TCO_URL . '/assets/images/logo-dark.png'
                            ]
                        ],
                        'logo_mobile' => [
                            'type' => Theme_Core_Options::MEDIA_FIELD,
                            'title' => esc_html__('Logo Tablet & Mobile', TCO_TEXT_DOMAIN),
                            'default' => [
                                'url' => TCO_URL . '/assets/images/logo-dark.png'
                            ]
                        ],
                        'logo_maxh' => [
                            'type' => 'dimensions',
                            'title' => esc_html__('Logo Max height', TCO_TEXT_DOMAIN),
                            'subtitle' => esc_html__('Enter number.', TCO_TEXT_DOMAIN),
                            'width' => false,
                        ],
                        'logo_maxh_sm' => [
                            'type' => 'dimensions',
                            'title' => esc_html__('Logo Max height Tablet & Mobile', TCO_TEXT_DOMAIN),
                            'subtitle' => esc_html__('Enter number.', TCO_TEXT_DOMAIN),
                            'width' => false,
                        ],
                    ],
                ],
                'navigation' => [
                    'title' => esc_html__('Navigation', TCO_TEXT_DOMAIN),
                    'fields' => [
                        'font_menu' => [
                            'type' => Theme_Core_Options::TYPOGRAPHY_FIELD,
                            'title' => esc_html__('Custom Google Font', TCO_TEXT_DOMAIN),
                            'output' => [
                                '.primary-menu > li > a, body .primary-menu .sub-menu li a'
                            ],
                        ],
                        'menu_font_size' => [
                            'type' => Theme_Core_Options::TEXT_FIELD,
                            'title' => esc_html__('Font Size', TCO_TEXT_DOMAIN),
                        ],
                        'menu_text_transform' => [
                            'type' => Theme_Core_Options::SELECT_FIELD,
                            'title' => esc_html__('Text Transform', TCO_TEXT_DOMAIN),
                            'options' => [
                                '' => esc_html__('Default', TCO_TEXT_DOMAIN),
                                'uppercase' => esc_html__('Uppercase', TCO_TEXT_DOMAIN),
                                'capitalize' => esc_html__('Capitalize', TCO_TEXT_DOMAIN),
                                'lowercase' => esc_html__('Lowercase', TCO_TEXT_DOMAIN),
                                'initial' => esc_html__('Initial', TCO_TEXT_DOMAIN),
                                'inherit' => esc_html__('Inherit', TCO_TEXT_DOMAIN),
                                'none' => esc_html__('None', TCO_TEXT_DOMAIN),
                            ],
                        ],
                        'main_menu' => [
                            'type' => Theme_Core_Options::HEADING_FIELD,
                            'title' => esc_html__('Main Menu', TCO_TEXT_DOMAIN),
                        ],
                        'main_menu_color' => [
                            'type' => Theme_Core_Options::LINK_COLOR_FIELD,
                            'title' => esc_html__('Color', TCO_TEXT_DOMAIN),
                        ],
                        'sticky_menu' => [
                            'type' => Theme_Core_Options::HEADING_FIELD,
                            'title' => esc_html__('Sticky Menu', TCO_TEXT_DOMAIN),
                        ],
                        'sticky_menu_color' => [
                            'type' => Theme_Core_Options::LINK_COLOR_FIELD,
                            'title' => esc_html__('Color', TCO_TEXT_DOMAIN),
                        ],
                        'button_navigation' => [
                            'type' => Theme_Core_Options::HEADING_FIELD,
                            'title' => esc_html__('Button Navigation', TCO_TEXT_DOMAIN),
                        ],
                        'h_btn_on' => [
                            'type' => Theme_Core_Options::BUTTON_SET_FIELD,
                            'title' => esc_html__('Show/Hide Button', TCO_TEXT_DOMAIN),
                            'options' => [
                                'show' => esc_html__('Show', TCO_TEXT_DOMAIN),
                                'hide' => esc_html__('Hide', TCO_TEXT_DOMAIN),
                            ],
                            'default' => 'hide',
                        ],
                        'h_btn_text' => [
                            'type' => Theme_Core_Options::TEXT_FIELD,
                            'title' => esc_html__('Button Text', TCO_TEXT_DOMAIN),
                            'required' => [
                                'h_btn_on',
                                '=',
                                'show'
                            ],
                        ],
                        'h_btn_link_type' => [
                            'type' => Theme_Core_Options::BUTTON_SET_FIELD,
                            'title' => esc_html__('Button Link Type', TCO_TEXT_DOMAIN),
                            'options' => [
                                'page' => esc_html__('Page', TCO_TEXT_DOMAIN),
                                'custom' => esc_html__('Custom', TCO_TEXT_DOMAIN),
                            ],
                            'default' => 'page',
                            'required' => [
                                'h_btn_on',
                                '=',
                                'show'
                            ],
                        ],
                        'h_btn_link' => [
                            'type' => Theme_Core_Options::SELECT_FIELD,
                            'title' => esc_html__('Page Link', TCO_TEXT_DOMAIN),
                            'args' => [
                                'post_type' => 'page',
                                'posts_per_page' => -1,
                                'orderby' => 'title',
                                'order' => 'ASC',
                            ],
                            'select2' => true,
                            'required' => [
                                'h_btn_link_type',
                                '=',
                                'page'
                            ],
                        ],
                        'h_btn_link_custom' => [
                            'type' => Theme_Core_Options::TEXT_FIELD,
                            'title' => esc_html__('Custom Link', TCO_TEXT_DOMAIN),
                            'required' => [
                                'h_btn_link_type',
                                '=',
                                'custom'
                            ],
                        ],
                        'h_btn_target' => [
                            'type' => Theme_Core_Options::BUTTON_SET_FIELD,
                            'title' => esc_html__('Button Target', TCO_TEXT_DOMAIN),
                            'options' => [
                                '_self' => esc_html__('Self', TCO_TEXT_DOMAIN),
                                '_blank' => esc_html__('Blank', TCO_TEXT_DOMAIN),
                            ],
                            'default' => '_self',
                            'required' => [
                                'h_btn_on',
                                '=',
                                'show'
                            ],
                        ],
                    ],
                ],
            ]
        ],
        'page-title' => [
            'title' => esc_html__('Page Tile', TCO_TEXT_DOMAIN),
            'fields' => [
                'pagetitle' => [
                    'type' => Theme_Core_Options::BUTTON_SET_FIELD,
                    'title' => esc_html__('Page Title', TCO_TEXT_DOMAIN),
                    'options' => [
                        'show' => esc_html__('Show', TCO_TEXT_DOMAIN),
                        'hide' => esc_html__('Hide', TCO_TEXT_DOMAIN),
                    ],
                    'default' => 'show',
                ],
                'page_title_img' => [
                    'type' => Theme_Core_Options::MEDIA_FIELD,
                    'title' => esc_html__('Page Title Image', TCO_TEXT_DOMAIN),
                    'required' => [
                        'pagetitle',
                        '=',
                        'show'
                    ],
                ],
                'breadcrumb' => [
                    'type' => Theme_Core_Options::BUTTON_SET_FIELD,
                    'title' => esc_html__('Breadcrumbs', TCO_TEXT_DOMAIN),
                    'options' => [
                        'show' => esc_html__('Show', TCO_TEXT_DOMAIN),
                        'hide' => esc_html__('Hide', TCO_TEXT_DOMAIN),
                    ],
                    'default' => 'show',
                    'required' => [
                        'pagetitle',
                        '=',
                        'show'
                    ],
                ],
            ],
        ],
        'content' => [
            'title' => esc_html__('Content', TCO_TEXT_DOMAIN),
            'sections' => [
                'general' => [
                    'title' => esc_html__('General', TCO_TEXT_DOMAIN),
                    'fields' => [
                        'content_bg_color' => [
                            'type' => Theme_Core_Options::COLOR_FIELD,
                            'title' => esc_html__('Background Color', TCO_TEXT_DOMAIN),
                            'subtitle' => esc_html__('Content background color.', TCO_TEXT_DOMAIN),
                            'output' => [
                                'background-color' => 'body'
                            ],
                        ],
                        'content_padding' => [
                            'type' => 'spacing',
                            'title' => esc_html__('Sticky Header', TCO_TEXT_DOMAIN),
                            'description' => esc_html__('Default: Top - 90px, Bottom - 90px', TCO_TEXT_DOMAIN),
                            'right' => false,
                            'left' => false,
                            'mode' => 'padding',
                            'output' => [
                                '#content'
                            ],
                        ],
                        'search_field_placeholder' => [
                            'type' => Theme_Core_Options::TEXT_FIELD,
                            'title' => esc_html__('Search Form - Text Placeholder', TCO_TEXT_DOMAIN),
                            'description' => esc_html__('Default: Search Keywords...', TCO_TEXT_DOMAIN),
                        ],
                    ],
                ],
                'archive' => [
                    'title' => esc_html__('Archive', TCO_TEXT_DOMAIN),
                    'fields' => [
                        'archive_sidebar_pos' => [
                            'type' => Theme_Core_Options::BUTTON_SET_FIELD,
                            'title' => esc_html__('Sidebar Position', TCO_TEXT_DOMAIN),
                            'subtitle' => esc_html__('Select a sidebar position for blog home, archive, search...', TCO_TEXT_DOMAIN),
                            'options' => [
                                'left' => esc_html__('Left', TCO_TEXT_DOMAIN),
                                'right' => esc_html__('Right', TCO_TEXT_DOMAIN),
                                'none' => esc_html__('Disabled', TCO_TEXT_DOMAIN)
                            ],
                            'default' => 'right'
                        ],
                        'archive_author_on' => [
                            'type' => Theme_Core_Options::SWITCH_FIELD,
                            'title' => esc_html__('Author', TCO_TEXT_DOMAIN),
                            'subtitle' => esc_html__('Show author name on each post.', TCO_TEXT_DOMAIN),
                            'default' => 1,
                        ],
                        'archive_date_on' => [
                            'type' => Theme_Core_Options::SWITCH_FIELD,
                            'title' => esc_html__('Date', TCO_TEXT_DOMAIN),
                            'subtitle' => esc_html__('Show date posted on each post.', TCO_TEXT_DOMAIN),
                            'default' => 1,
                        ],
                        'archive_categories_on' => [
                            'type' => Theme_Core_Options::SWITCH_FIELD,
                            'title' => esc_html__('Categories', TCO_TEXT_DOMAIN),
                            'subtitle' => esc_html__('Show category names on each post.', TCO_TEXT_DOMAIN),
                            'default' => 1,
                        ],
                        'archive_comments_on' => [
                            'type' => Theme_Core_Options::SWITCH_FIELD,
                            'title' => esc_html__('Comments', TCO_TEXT_DOMAIN),
                            'subtitle' => esc_html__('Show comments count on each post.', TCO_TEXT_DOMAIN),
                            'default' => 1,
                        ],
                    ],
                ],
                'single-post' => [
                    'title' => esc_html__('Single Post', TCO_TEXT_DOMAIN),
                    'fields' => [
                        'post_header_layout' => [
                            'type' => Theme_Core_Options::IMAGE_SELECT_FIELD,
                            'title' => esc_html__('Header Layout', TCO_TEXT_DOMAIN),
                            'subtitle' => esc_html__('Select a layout for header.', TCO_TEXT_DOMAIN),
                            'options' => [
                                'df' => TCO_URL . 'assets/images/header-layout/h-default.jpg',
                                '2' => TCO_URL . 'assets/images/header-layout/h2.jpg',
                                '3' => TCO_URL . 'assets/images/header-layout/h3.jpg',
                            ],
                            'default' => 2
                        ],
                        'post_sidebar_pos' => [
                            'type' => Theme_Core_Options::BUTTON_SET_FIELD,
                            'title' => esc_html__('Sidebar Position', TCO_TEXT_DOMAIN),
                            'subtitle' => esc_html__('Select a sidebar position', TCO_TEXT_DOMAIN),
                            'options' => [
                                'left' => esc_html__('Left', TCO_TEXT_DOMAIN),
                                'right' => esc_html__('Right', TCO_TEXT_DOMAIN),
                                'none' => esc_html__('Disabled', TCO_TEXT_DOMAIN)
                            ],
                            'default' => 'right'
                        ],
                        'post_author_on' => [
                            'type' => Theme_Core_Options::SWITCH_FIELD,
                            'title' => esc_html__('Author', TCO_TEXT_DOMAIN),
                            'subtitle' => esc_html__('Show author name on single post.', TCO_TEXT_DOMAIN),
                            'default' => 1,
                        ],
                        'post_author_info_on' => [
                            'type' => Theme_Core_Options::SWITCH_FIELD,
                            'title' => esc_html__('Author Info', TCO_TEXT_DOMAIN),
                            'subtitle' => esc_html__('Show author info on single post.', TCO_TEXT_DOMAIN),
                        ],
                        'post_date_on' => [
                            'type' => Theme_Core_Options::SWITCH_FIELD,
                            'title' => esc_html__('Date', TCO_TEXT_DOMAIN),
                            'subtitle' => esc_html__('Show date on single post.', TCO_TEXT_DOMAIN),
                            'default' => 1,
                        ],
                        'post_categories_on' => [
                            'type' => Theme_Core_Options::SWITCH_FIELD,
                            'title' => esc_html__('Categories', TCO_TEXT_DOMAIN),
                            'subtitle' => esc_html__('Show category names on single post.', TCO_TEXT_DOMAIN),
                            'default' => 1,
                        ],
                        'post_tags_on' => [
                            'type' => Theme_Core_Options::SWITCH_FIELD,
                            'title' => esc_html__('Tags', TCO_TEXT_DOMAIN),
                            'subtitle' => esc_html__('Show tag names on single post.', TCO_TEXT_DOMAIN),
                            'default' => 1,
                        ],
                        'post_comments_on' => [
                            'type' => Theme_Core_Options::SWITCH_FIELD,
                            'title' => esc_html__('Comments', TCO_TEXT_DOMAIN),
                            'subtitle' => esc_html__('Show comments count on single post.', TCO_TEXT_DOMAIN),
                            'default' => 1,
                        ],
                        'post_social_share_on' => [
                            'type' => Theme_Core_Options::SWITCH_FIELD,
                            'title' => esc_html__('Social Share', TCO_TEXT_DOMAIN),
                            'subtitle' => esc_html__('Show social share on single post.', TCO_TEXT_DOMAIN),
                            'default' => 1,
                        ],
                        'post_navigation_on' => [
                            'type' => Theme_Core_Options::SWITCH_FIELD,
                            'title' => esc_html__('Navigation', TCO_TEXT_DOMAIN),
                            'subtitle' => esc_html__('Show navigation on single post.', TCO_TEXT_DOMAIN),
                            'default' => 1,
                        ],
                        'post_comments_form_on' => [
                            'type' => Theme_Core_Options::SWITCH_FIELD,
                            'title' => esc_html__('Comments Form', TCO_TEXT_DOMAIN),
                            'subtitle' => esc_html__('Show comments form on single post.', TCO_TEXT_DOMAIN),
                            'default' => 1,
                        ],
                        'post_feature_image_on' => [
                            'type' => Theme_Core_Options::SWITCH_FIELD,
                            'title' => esc_html__('Feature Image', TCO_TEXT_DOMAIN),
                            'subtitle' => esc_html__('Show feature image on single post.', TCO_TEXT_DOMAIN),
                            'default' => 1,
                        ],
                    ],
                ],
                'single-case' => [
                    'title' => esc_html__('Single Case', TCO_TEXT_DOMAIN),
                    'fields' => [
                        'case_social_share' => [
                            'type' => Theme_Core_Options::SWITCH_FIELD,
                            'title' => esc_html__('Social Share', TCO_TEXT_DOMAIN),
                        ],
                        'case_social_navigation' => [
                            'type' => Theme_Core_Options::SWITCH_FIELD,
                            'title' => esc_html__('Navigation', TCO_TEXT_DOMAIN),
                        ],
                        'case_social_tag' => [
                            'type' => Theme_Core_Options::SWITCH_FIELD,
                            'title' => esc_html__('Tags', TCO_TEXT_DOMAIN),
                        ],
                        'portfolio_slug' => [
                            'type' => Theme_Core_Options::TEXT_FIELD,
                            'title' => esc_html__('Case Study Slug', TCO_TEXT_DOMAIN),
                            'description' => esc_html__('Default: case-study', TCO_TEXT_DOMAIN),
                        ],
                        'portfolio_name' => [
                            'type' => Theme_Core_Options::TEXT_FIELD,
                            'title' => esc_html__('Case Study Name', TCO_TEXT_DOMAIN),
                            'description' => esc_html__('Default: Portfolio', TCO_TEXT_DOMAIN),
                        ],
                    ],
                ],
            ]
        ],
        'shop' => [
            'title' => esc_html__('Shop', TCO_TEXT_DOMAIN),
            'fields' => [
                'sidebar_shop' => [
                    'type' => Theme_Core_Options::BUTTON_SET_FIELD,
                    'title' => esc_html__('Sidebar Position', TCO_TEXT_DOMAIN),
                    'subtitle' => esc_html__('Select a sidebar position for archive shop.', TCO_TEXT_DOMAIN),
                    'options' => [
                        'left' => esc_html__('Left', TCO_TEXT_DOMAIN),
                        'right' => esc_html__('Right', TCO_TEXT_DOMAIN),
                        'none' => esc_html__('Disabled', TCO_TEXT_DOMAIN)
                    ],
                    'default' => 'right'
                ],
                'product_per_page' => [
                    'type' => Theme_Core_Options::SLIDER_FIELD,
                    'title' => esc_html__('Products displayed per page', TCO_TEXT_DOMAIN),
                    'subtitle' => esc_html__('Number product to show', TCO_TEXT_DOMAIN),
                    'default' => 8,
                    'min' => 4,
                    'step' => 1,
                    'max' => 50,
                ],
                'shop_page_title_img' => [
                    'type' => Theme_Core_Options::MEDIA_FIELD,
                    'title' => esc_html__('Page Title Image', TCO_TEXT_DOMAIN),
                    'required' => [
                        'pagetitle',
                        '=',
                        'show',
                    ],
                ],
            ],
        ],
        'footer' => [
            'title' => esc_html__('Footer', TCO_TEXT_DOMAIN),
            'fields' => [
                'footer_layout_custom' => [
                    'type' => Theme_Core_Options::SELECT_FIELD,
                    'title' => esc_html__('Layout', TCO_TEXT_DOMAIN),
                    'desc' => sprintf(esc_html__('To use this Option please %sClick Here%s to add your custom footer layout first.', TCO_TEXT_DOMAIN), '<a href="' . esc_url(admin_url('edit.php?post_type=footer')) . '">', '</a>'),
                    'args' => [
                        'post_type' => 'footer',
                        'posts_per_page' => -1,
                        'orderby' => 'title',
                        'order' => 'ASC',
                    ],
                    'default' => '',
                ],
                'back_totop_on' => [
                    'type' => Theme_Core_Options::SWITCH_FIELD,
                    'title' => esc_html__('Back to Top Button', TCO_TEXT_DOMAIN),
                    'subtitle' => esc_html__('Show back to top button when scrolled down.', TCO_TEXT_DOMAIN),
                    'default' => 1,
                ],
            ],
        ],
        'colors' => [
            'title' => esc_html__('Colors', TCO_TEXT_DOMAIN),
            'fields' => [
                'primary_color' => [
                    'type' => Theme_Core_Options::COLOR_FIELD,
                    'title' => esc_html__('Primary Color', TCO_TEXT_DOMAIN),
                    'default' => '#00c881',
                ],
                'secondary_color' => [
                    'type' => Theme_Core_Options::COLOR_FIELD,
                    'title' => esc_html__('Secondary Color', TCO_TEXT_DOMAIN),
                    'default' => '#222222',
                ],
                'link_color' => [
                    'type' => Theme_Core_Options::LINK_COLOR_FIELD,
                    'title' => esc_html__('Link Color', TCO_TEXT_DOMAIN),
                    'default' => [
                        'regular' => '#00c881',
                        'hover' => '#0f885d',
                        'active' => '#0f885d'
                    ],
                ],
            ],
        ],
        'typography' => [
            'title' => esc_html__('Typography', TCO_TEXT_DOMAIN),
            'sections' => [
                'general' => [
                    'title' => esc_html__('General', TCO_TEXT_DOMAIN),
                    'fields' => [
                        'body_default_font' => [
                            'type' => Theme_Core_Options::SELECT_FIELD,
                            'title' => esc_html__('Body Default Font', TCO_TEXT_DOMAIN),
                            'options' => [
                                'Poppins' => esc_html__('Default', 'mori'),
                                'Google-Font' => esc_html__('Google Font', 'mori'),
                            ],
                            'default' => 'Poppins',
                        ],
                        'font_main' => [
                            'type' => Theme_Core_Options::TYPOGRAPHY_FIELD,
                            'title' => esc_html__('Body Google Font', TCO_TEXT_DOMAIN),
                            'subtitle' => esc_html__('This will be the default font of your website.', TCO_TEXT_DOMAIN),
                            'output' => [
                                'body'
                            ],
                            'required' => [
                                'body_default_font',
                                '=',
                                'Google-Font',
                            ],
                        ],
                        'heading_default_font' => [
                            'type' => Theme_Core_Options::SELECT_FIELD,
                            'title' => esc_html__('Heading Default Font', TCO_TEXT_DOMAIN),
                            'options' => [
                                'Work-Sans' => esc_html__('Default', 'mori'),
                                'Google-Font' => esc_html__('Google Font', 'mori'),
                            ],
                            'default' => 'Work-Sans',
                        ],
                        'font_h1' => [
                            'type' => Theme_Core_Options::TYPOGRAPHY_FIELD,
                            'title' => esc_html__('H1', TCO_TEXT_DOMAIN),
                            'subtitle' => esc_html__('This will be the default font for all H1 tags of your website.', TCO_TEXT_DOMAIN),
                            'output' => [
                                'h1',
                                '.h1',
                                '.text-heading'
                            ],
                            'required' => [
                                'heading_default_font',
                                '=',
                                'Google-Font',
                            ],
                        ],
                        'font_h2' => [
                            'type' => Theme_Core_Options::TYPOGRAPHY_FIELD,
                            'title' => esc_html__('H2', TCO_TEXT_DOMAIN),
                            'subtitle' => esc_html__('This will be the default font for all H2 tags of your website.', TCO_TEXT_DOMAIN),
                            'output' => [
                                'h2',
                                '.h2',
                            ],
                            'required' => [
                                'heading_default_font',
                                '=',
                                'Google-Font',
                            ],
                        ],
                        'font_h3' => [
                            'type' => Theme_Core_Options::TYPOGRAPHY_FIELD,
                            'title' => esc_html__('H3', TCO_TEXT_DOMAIN),
                            'subtitle' => esc_html__('This will be the default font for all H3 tags of your website.', TCO_TEXT_DOMAIN),
                            'output' => [
                                'h3',
                                '.h3',
                            ],
                            'required' => [
                                'heading_default_font',
                                '=',
                                'Google-Font',
                            ],
                        ],
                        'font_h4' => [
                            'type' => Theme_Core_Options::TYPOGRAPHY_FIELD,
                            'title' => esc_html__('H4', TCO_TEXT_DOMAIN),
                            'subtitle' => esc_html__('This will be the default font for all H4 tags of your website.', TCO_TEXT_DOMAIN),
                            'output' => [
                                'h4',
                                '.h4',
                            ],
                            'required' => [
                                'heading_default_font',
                                '=',
                                'Google-Font',
                            ],
                        ],
                        'font_h5' => [
                            'type' => Theme_Core_Options::TYPOGRAPHY_FIELD,
                            'title' => esc_html__('H5', TCO_TEXT_DOMAIN),
                            'subtitle' => esc_html__('This will be the default font for all H5 tags of your website.', TCO_TEXT_DOMAIN),
                            'output' => [
                                'h5',
                                '.h5',
                            ],
                            'required' => [
                                'heading_default_font',
                                '=',
                                'Google-Font',
                            ],
                        ],
                        'font_h6' => [
                            'type' => Theme_Core_Options::TYPOGRAPHY_FIELD,
                            'title' => esc_html__('H6', TCO_TEXT_DOMAIN),
                            'subtitle' => esc_html__('This will be the default font for all H6 tags of your website.', TCO_TEXT_DOMAIN),
                            'output' => [
                                'h6',
                                '.h6',
                            ],
                            'required' => [
                                'heading_default_font',
                                '=',
                                'Google-Font',
                            ],
                        ],
                    ],
                ],
            ],
        ],
        'google-maps' => [
            'title' => esc_html__('Google Maps', TCO_TEXT_DOMAIN),
            'fields' => [
                'gm_api_key' => [
                    'type' => Theme_Core_Options::TEXT_FIELD,
                    'title' => esc_html__('API Key', TCO_TEXT_DOMAIN),
                    'description' => esc_html__('Register a Google Maps Api key then put it in here.', TCO_TEXT_DOMAIN),
                    'default' => 'AIzaSyC08_qdlXXCWiFNVj02d-L2BDK5qr6ZnfM',
                ]
            ],
        ],
        '404-page' => [
            'title' => esc_html__('404 Page', TCO_TEXT_DOMAIN),
            'fields' => [
                'title_404_page' => [
                    'type' => Theme_Core_Options::TEXTAREA_FIELD,
                    'title' => esc_html__('Title', TCO_TEXT_DOMAIN),
                ],
                'content_404_page' => [
                    'type' => Theme_Core_Options::TEXTAREA_FIELD,
                    'title' => esc_html__('Content', TCO_TEXT_DOMAIN),
                ],
                'btn_text_404_page' => [
                    'type' => Theme_Core_Options::TEXT_FIELD,
                    'title' => esc_html__('Button Text', TCO_TEXT_DOMAIN),
                    'description' => esc_html__('Default: Take me go back home', TCO_TEXT_DOMAIN),
                ],
            ],
        ],
        'custom-code' => [
            'title' => esc_html__('Custom Code', TCO_TEXT_DOMAIN),
            'fields' => [
                'site_header_code' => [
                    'type' => Theme_Core_Options::TEXTAREA_FIELD,
                    'title' => esc_html__('Header Custom Codes', TCO_TEXT_DOMAIN),
                    'subtitle' => esc_html__('It will insert the code to wp_head hook.', TCO_TEXT_DOMAIN),
                ],
                'site_footer_code' => [
                    'type' => Theme_Core_Options::TEXTAREA_FIELD,
                    'title' => esc_html__('Footer Custom Codes', TCO_TEXT_DOMAIN),
                    'subtitle' => esc_html__('It will insert the code to wp_footer hook.', TCO_TEXT_DOMAIN),
                ],
            ],
        ],
        'custom-css' => [
            'title' => esc_html__('Custom CSS', TCO_TEXT_DOMAIN),
            'fields' => [
                'site_css' => [
                    'type' => Theme_Core_Options::CODE_EDITOR_FIELD,
                    'title' => esc_html__('CSS Code', TCO_TEXT_DOMAIN),
                    'subtitle' => esc_html__('Advanced CSS Options. You can paste your custom CSS Code here.', TCO_TEXT_DOMAIN),
                    'mode' => 'css',
                ],
            ],
        ],
    ];

    return $args;
}

?>