<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

/**
 *
 */
class TCOUserOptions
{
    function __construct()
    {
        $this->init();
    }

    function init()
    {
        $user_options_args = apply_filters("tco_user_options_args", []);
        update_option("tco_user_options_args", $user_options_args);
        if(is_array($user_options_args) && count($user_options_args) > 0){
            add_action('show_user_profile', [$this, 'user_custom_fields']);
            add_action('edit_user_profile', [$this, 'user_custom_fields']);
        }
    }

    public function user_custom_fields($user)
    {
        tco_get_template_file_e('user_custom_fields.php', ['user' => $user]);
    }

    function get_user_options_args()
    {
        $user_options_args = get_option("tco_user_options_args", []);

        return $user_options_args;
    }

    function get_user_options($user_id = 0)
    {
        $user = get_user_by('ID', $user_id);
        $user_options = [];
        if ($user) {
            $user_options = get_usermeta($user->ID, "tco_user_options");
        }
        return $user_options;
    }

    function set_user_options($user_options, $user_id = 0)
    {
        $user = get_user_by('ID', $user_id);
        if ($user && $user->ID) {
            update_user_meta($user->ID, "tco_user_options", $user_options);
            foreach ($user_options as $key => $data) {
                update_user_meta($user->ID, $key, $data);
            }
        }
    }
}