<?php

if (!defined('ABSPATH')) {
    die();
}

if (!class_exists('TCOAjaxHandle')) {
    class TCOAjaxHandle
    {
        public function __construct()
        {
            add_action('wp_ajax_get_theme_options_args', array($this, 'get_theme_options_args'));
            add_action('wp_ajax_get_theme_options', array($this, 'get_theme_options'));
            add_action('wp_ajax_save_theme_options', array($this, 'save_theme_options'));

            add_action('wp_ajax_get_page_options_args', array($this, 'get_page_options_args'));
            add_action('wp_ajax_get_page_options', array($this, 'get_page_options'));
            add_action('wp_ajax_save_page_options', array($this, 'save_page_options'));

            add_action('wp_ajax_get_posts', array($this, 'get_posts'));

            add_action('wp_ajax_get_tax_options_args', array($this, 'get_tax_options_args'));
            add_action('wp_ajax_get_tax_options', array($this, 'get_tax_options'));

            add_action('wp_ajax_get_user_options_args', array($this, 'get_user_options_args'));
            add_action('wp_ajax_get_user_options', array($this, 'get_user_options'));
            add_action('wp_ajax_save_user_options', array($this, 'save_user_options'));

            add_action('wp_ajax_get_woocommerce_attribute_options_args', array($this, 'get_woocommerce_attribute_options_args'));
            add_action('wp_ajax_get_woocommerce_attribute_options', array($this, 'get_woocommerce_attribute_options'));
            add_action('wp_ajax_save_woocommerce_attribute_options', array($this, 'save_woocommerce_attribute_options'));
        }

        function send_response($data = [], $message = 'Successfully!', $success = true)
        {
            wp_send_json(
                array(
                    'success' => $success,
                    'message' => $message,
                    'data' => $data
                )
            );
            die;
        }

        function get_theme_options_args()
        {
            global $theme_core_options;

            if (!$theme_core_options instanceof Theme_Core_Options) {
                $this->send_response([], esc_html__('Error!', TCO_TEXT_DOMAIN), false);
            }

            $options_args = $theme_core_options->theme_options->get_theme_options_args();

            $this->send_response($options_args, esc_html__('Get Theme Options Args Successfully!', TCO_TEXT_DOMAIN));
        }

        function get_theme_options()
        {
            global $theme_core_options;

            $theme_options = $theme_core_options->theme_options->get_theme_options();

            $this->send_response($theme_options, esc_html__('Get Theme Options Successfully!', TCO_TEXT_DOMAIN));
        }

        function save_theme_options()
        {
            global $theme_core_options;

            unset($_POST['action']);
            $theme_core_options->theme_options->set_theme_options($_POST);

            $this->send_response($_POST, esc_html__('Save Theme Options Successfully!', TCO_TEXT_DOMAIN));
        }

        function get_page_options_args()
        {
            global $theme_core_options;

            if (!$theme_core_options instanceof Theme_Core_Options) {
                $this->send_response([], esc_html__('Error!', TCO_TEXT_DOMAIN), false);
            }

            $post_id = 0;
            if (isset($_POST['post_id']) && !empty($_POST['post_id'])) {
                $post_id = $_POST['post_id'];
            }

            $options_args = $theme_core_options->page_options->get_page_options_args($post_id);

            $this->send_response($options_args, esc_html__('Get Page Options Args Successfully!', TCO_TEXT_DOMAIN));
        }

        function get_page_options()
        {
            global $theme_core_options;

            if (!$theme_core_options instanceof Theme_Core_Options) {
                $this->send_response([], esc_html__('Error!', TCO_TEXT_DOMAIN), false);
            }

            $post_id = 0;
            if (isset($_POST['post_id']) && !empty($_POST['post_id'])) {
                $post_id = $_POST['post_id'];
            }

            $options = $theme_core_options->page_options->get_page_options($post_id);

            $this->send_response($options, esc_html__('Get Page Options Successfully!', TCO_TEXT_DOMAIN));
        }

        function save_page_options()
        {
            global $theme_core_options;

            if (!$theme_core_options instanceof Theme_Core_Options) {
                $this->send_response([], esc_html__('Error!', TCO_TEXT_DOMAIN), false);
            }

            $post_id = 0;
            if (isset($_POST['post_id']) && !empty($_POST['post_id'])) {
                $post_id = $_POST['post_id'];
            }

            unset($_POST['action']);
            unset($_POST['post_id']);
            $theme_core_options->page_options->set_page_options($_POST, $post_id);

            $this->send_response($_POST, esc_html__('Save Page Options Successfully!', TCO_TEXT_DOMAIN));
        }

        function get_posts()
        {
            $post_type = 'post';
            $posts_per_page = '6';
            $order = 'DESC';
            $orderby = 'date';

            if (isset($_POST['post_type']) && !empty($_POST['post_type'])) {
                $post_type = $_POST['post_type'];
            }

            if (isset($_POST['posts_per_page']) && !empty($_POST['posts_per_page'])) {
                $posts_per_page = $_POST['posts_per_page'];
            }

            if (isset($_POST['order']) && !empty($_POST['order'])) {
                $order = $_POST['order'];
            }

            if (isset($_POST['orderby']) && !empty($_POST['orderby'])) {
                $orderby = $_POST['orderby'];
            }

            $posts = get_posts([
                'post_type' => $post_type,
                'posts_per_page' => $posts_per_page,
                'order' => $order,
                'orderby' => $orderby,
            ]);

            $this->send_response($posts, esc_html__('Get Posts Successfully!', TCO_TEXT_DOMAIN));
        }

        function get_tax_options_args()
        {
            global $theme_core_options;

            if (!$theme_core_options instanceof Theme_Core_Options) {
                $this->send_response([], esc_html__('Error!', TCO_TEXT_DOMAIN), false);
            }

            $taxonomy = get_taxonomy($_POST['tax_name']);
            if (!$taxonomy) {
                $this->send_response([], esc_html__('Taxonomy is not found!', TCO_TEXT_DOMAIN), false);
            }

            $options_args = $theme_core_options->tax_options->get_tax_options_args($taxonomy->name);

            $this->send_response($options_args, esc_html__('Get Tax Options Args Successfully!', TCO_TEXT_DOMAIN));
        }

        function get_tax_options()
        {
            global $theme_core_options;

            if (!$theme_core_options instanceof Theme_Core_Options) {
                $this->send_response([], esc_html__('Error!', TCO_TEXT_DOMAIN), false);
            }

            $taxonomy = get_taxonomy($_POST['tax_name']);
            if (!$taxonomy) {
                $this->send_response([], esc_html__('Taxonomy is not found!', TCO_TEXT_DOMAIN), false);
            }

            $term_id = 0;
            if (isset($_POST['term_id']) && !empty($_POST['term_id'])) {
                $term_id = $_POST['term_id'];
            }

            $options = $theme_core_options->tax_options->get_tax_options($term_id, $taxonomy->name);

            $this->send_response($options, esc_html__('Get Tax Options Successfully!', TCO_TEXT_DOMAIN));
        }

        function get_user_options_args()
        {
            global $theme_core_options;

            if (!$theme_core_options instanceof Theme_Core_Options) {
                $this->send_response([], esc_html__('Error!', TCO_TEXT_DOMAIN), false);
            }

            $options_args = $theme_core_options->user_options->get_user_options_args();

            $this->send_response($options_args, esc_html__('Get User Options Args Successfully!', TCO_TEXT_DOMAIN));
        }

        function get_user_options()
        {
            global $theme_core_options;

            if (!$theme_core_options instanceof Theme_Core_Options) {
                $this->send_response([], esc_html__('Error!', TCO_TEXT_DOMAIN), false);
            }

            $user_id = 0;
            if (isset($_POST['user_id']) && !empty($_POST['user_id'])) {
                $user_id = $_POST['user_id'];
            }

            $options = $theme_core_options->user_options->get_user_options($user_id);

            $this->send_response($options, esc_html__('Get User Options Successfully!', TCO_TEXT_DOMAIN));
        }

        function save_user_options()
        {
            global $theme_core_options;

            if (!$theme_core_options instanceof Theme_Core_Options) {
                $this->send_response([], esc_html__('Error!', TCO_TEXT_DOMAIN), false);
            }

            $user_id = 0;
            if (isset($_POST['user_id']) && !empty($_POST['user_id'])) {
                $user_id = $_POST['user_id'];
            }

            unset($_POST['action']);
            unset($_POST['user_id']);
            $theme_core_options->user_options->set_user_options($_POST, $user_id);

            $this->send_response($_POST, esc_html__('Save User Options Successfully!', TCO_TEXT_DOMAIN));
        }

        function get_woocommerce_attribute_options_args()
        {
            global $theme_core_options;

            if (!$theme_core_options instanceof Theme_Core_Options) {
                $this->send_response([], esc_html__('Error!', TCO_TEXT_DOMAIN), false);
            }

            $options_args = $theme_core_options->woocommerce_attribute_options->get_options_args();

            $this->send_response($options_args, esc_html__('Get Woocommerce Attribute Options Args Successfully!', TCO_TEXT_DOMAIN));
        }

        function get_woocommerce_attribute_options()
        {
            global $theme_core_options;

            if (!$theme_core_options instanceof Theme_Core_Options) {
                $this->send_response([], esc_html__('Error!', TCO_TEXT_DOMAIN), false);
            }

            $woocommerce_attribute_id = 0;
            if (isset($_POST['woocommerce_attribute_id']) && !empty($_POST['woocommerce_attribute_id'])) {
                $woocommerce_attribute_id = intval($_POST['woocommerce_attribute_id']);
            }

            $options = $theme_core_options->woocommerce_attribute_options->get_options($woocommerce_attribute_id);

            $this->send_response($options, esc_html__('Get Woocommerce Attribute Options Successfully!', TCO_TEXT_DOMAIN));
        }

        function save_woocommerce_attribute_options()
        {
            global $theme_core_options;

            if (!$theme_core_options instanceof Theme_Core_Options) {
                $this->send_response([], esc_html__('Error!', TCO_TEXT_DOMAIN), false);
            }

            $woocommerce_attribute_id = 0;
            if (isset($_POST['woocommerce_attribute_id']) && !empty($_POST['woocommerce_attribute_id'])) {
                $woocommerce_attribute_id = intval($_POST['woocommerce_attribute_id']);
            }

            unset($_POST['action']);
            unset($_POST['woocommerce_attribute_id']);
            $theme_core_options->woocommerce_attribute_options->set_user_options($_POST, $woocommerce_attribute_id);

            $this->send_response($_POST, esc_html__('Save Woocommerce Attribute Options Successfully!', TCO_TEXT_DOMAIN));
        }
    }
}