var TCOTemplate = function (config) {
    this.init(config);
};

TCOTemplate.prototype = {
    templates: {},
    ready: true,

    init: function (config) {
        if(!tcoHelper.isEmpty(config)){
            $.extend(this, config);
        }
    },

    addTemplate: function (key, template) {
        this.templates[key] = template;
    },

    updateTemplate: function (key, template) {
        this.templates[key] = template;
    },

    deleteTemplate: function (key) {
        let _templates = {};
        $.each(this.templates, function (_key, template) {
            if(key !== _key){
                _templates[_key] = template;
            }
        });
        this.templates = _templates;

        return this.templates;
    },

    getTemplate: function (key) {
        return this.templates[key];
    }
};

var tcoTemplates = new TCOTemplate();

(function ($) {
    $(document).ready(function () {
        var templateEls = $('template');
        if(templateEls.length > 0){
            let length = templateEls.length;
            tcoTemplates.ready = false;
            $.each(templateEls, function (index, templateEl) {
                let key = $(templateEl).data('id');
                let src = $(templateEl).data('src');
                $.get(src, function (data) {

                }).done(function(data) {
                    tcoTemplates.addTemplate(key, data);
                }).fail(function() {

                }).always(function() {
                    length--;
                });
            });
            tcoHelper.waitFor(function () {
                return length === 0;
            }, function () {
                tcoTemplates.ready = true;
            }, 'Load Templates!');
        }
    });
}(jQuery));