( function ($) {
	"use strict";

	var TCO_TABS = 'TCOTabs';

	function TCOTabs(config, element) {
	    let $element = $(element);
        $element.css('position', 'relative');

	    $element.data(TCO_TABS, this);

	    this.element = $element;

	    this.init(config);
	    this.render();
	}

	TCOTabs.prototype = {
		config: {
			// id
			tabListId: 'tablist-' + tcoHelper.getTimestamp(),
			tabsId: 'tabs-' + tcoHelper.getTimestamp(),
			tabsLinkId: 'tabs-link-' + tcoHelper.getTimestamp(),
            tabsContentWrapperId: 'tabs-content-wrapper-' + tcoHelper.getTimestamp(),
			tabsContentId: 'tabs-content-' + tcoHelper.getTimestamp(),
			tabLinkPreId: 'tab-link-' + tcoHelper.getTimestamp() + '-',
			tabLinkAnchorPreId: 'tab-link-anchor-' + tcoHelper.getTimestamp() + '-',
			tabContentPreId: 'tab-content-' + tcoHelper.getTimestamp() + '-',

			tabsArgs: {},
		},

		tabs: {},

	    init: function (config) {
	        $.extend(this.config, config);

	        this.formatTabs();
	    },

	    render: function () {
	    	let _this = this;
            let tablistTmpl = tcoTemplates.getTemplate('tablist');
            let tablistHtml = _.template(tablistTmpl)({
                config: _this.config
            });
            tablistHtml = $(tablistHtml);
            let tabsLinkEl = tablistHtml.find('#' + _this.config.tabsLinkId);
            let tabsContentEl = tablistHtml.find('#' + _this.config.tabsContentId);
            tabsLinkEl.html('');
            tabsContentEl.html('');

            tcoHelper.waitFor(function () {
            	return !tcoHelper.isEmpty(_this.tabs);
            }, function () {
            	$.each(_this.tabs, function (tabKey, tabArgs) {
	            	tabsLinkEl.append(tabArgs.tabLinkEl);
	            	tabsContentEl.append(tabArgs.tabContentEl);
	            });
            }, 'Wait for format tabsArgs!', 300);
            
            _this.element.html(tablistHtml);
            
            return tablistHtml;
	    },

	    formatTabs: function () {
	    	let _this = this;
	    	let tabLinkTmpl = tcoTemplates.getTemplate('tab-link');
	    	let tabContentTmpl = tcoTemplates.getTemplate('tab-content');
            
            let count = 0;
	    	$.each(_this.config.tabsArgs, function (tabKey, tabArgs) {
	    		count++;

	    		// Tab Config
	    		tabArgs.tabKey = tabKey;
	    		tabArgs.active = count === 1;
	    		let tabConfig = {
	    			active: count === 1,
	    			tabKey: tabKey,
	    			tabArgs: tabArgs,
	    			tabLinkPreId: _this.config.tabLinkPreId,
	    			tabLinkAnchorPreId: _this.config.tabLinkAnchorPreId,
	    			tabContentPreId: _this.config.tabContentPreId,
	    		};

	    		// Tab Link
	    		let tabLinkHtml = _.template(tabLinkTmpl)({
	                config: tabConfig
	            });
	            tabLinkHtml = $(tabLinkHtml);

	            // Tab Content
	            let tabContentHtml = _.template(tabContentTmpl)({
	                config: tabConfig
	            });
	            tabContentHtml = $(tabContentHtml);
	            // Build tabContentHtml
	            if(!tcoHelper.isEmpty(tabArgs.sections)){
	            	tabContentHtml.tcoAccordion({
                        accordionsArgs: tabArgs.sections
                    });
	            }
	            else if(!tcoHelper.isEmpty(tabArgs.fields)){
                    tabContentHtml.tcoForm({
                        fieldsArgs: tabArgs.fields
                    });
                }

	            // Events
	            tabLinkHtml.on('click', function (e) {
	            	e.preventDefault();

	            	let activeTab = _this.getActiveTab();
	            	let tab = _this.getTab(tabKey);

	            	activeTab.active = false;
	            	_this.updateTab(activeTab.tabKey, activeTab);
	            	activeTab.tabLinkEl.removeClass('active');
	            	activeTab.tabContentEl.removeClass('active');
	            	tab.active = true;
	            	_this.updateTab(tabKey, tab);
	            	tabLinkHtml.addClass('active');
	            	tabContentHtml.addClass('active');
	            });

	            tabArgs.tabLinkEl = tabLinkHtml;
	            tabArgs.tabContentEl = tabContentHtml;
	            _this.addTab(tabKey, tabArgs);
	    	});
	    },

	    addTab: function (tabKey, tabArgs) {
            this.tabs[tabKey] = tabArgs;
        },

        updateTab: function (tabKey, tabArgs) {
            this.tabs[tabKey] = tabArgs;
        },

        getTab: function (tabKey) {
            return this.tabs[tabKey];
        },

        getActiveTab: function () {
        	let _this = this;
        	let activeTab = {};
        	$.each(_this.tabs, function (tabKey, tabArgs) {
        		if(tabArgs.active === true){
        			activeTab = tabArgs;
        		}
        	});

        	return activeTab;
        },

        setTabsContentHeader: function (el) {
			this.element.find('.cms-tabs-content-header').html(el);
        },

        setTabsContentFooter: function (el) {
            this.element.find('.cms-tabs-content-footer').html(el);
        },

        setTabsHeader: function (el) {
            this.element.find('.cms-tabs-header').html(el);
        }
	};

	$.fn.tcoTabs = function (config) {
	    let result = this;

	    this.each(function () {
	        let $element = $(this),
	            instance = $element.data(TCO_TABS);

	        if (instance) {
	            instance.init(config);
	            instance.render();

	            result = instance;
	        } else {
	            result = new TCOTabs(config, $element);
	        }
	    });

	    return result;
	};
}(jQuery) );