$ = $ || jQuery;

var TCOHelper = function (config) {

};

TCOHelper.prototype = {

    openLoader: function () {
        let loaderTmpl = tcoTemplates.getTemplate('loader');
        if($('.loader').length === 0){
            $('body').prepend(loaderTmpl);
        }
    },

    closeLoader: function () {
        $('.loader').remove();
    },

    waitFor: function (condition, callback, message, time) {
        let _this = this;
        if (_this.isEmpty(message)) {
            message = 'Timeout';
        }
        var cond = condition();
        if (cond) {
            callback();
        } else {
            setTimeout(function () {
                console.log(message);
                _this.waitFor(condition, callback, message, time);
            }, time);
        }
    },

    arrayInsertAt: function (array, index, ...elements) {
        array.splice(index, 0, ...elements);
    },

    getRandomInt: function (min, max) {
        min = Math.ceil(min);
        max = Math.floor(max);
        return Math.floor(Math.random() * (max - min + 1)) + min;
    },

    getTimestamp: function () {
        return new Date().getTime();
    },

    isEmpty: function (val) {
        return typeof val === "undefined" || val === "" || val === null || (typeof val === "object" && $.isEmptyObject(val)) || ($.isArray(val) && val.lenght === 0);
    },

    checkVisible: function (elm, type) {
        type = type || "visible";
        let vpH = $(window).height(), // Viewport Height
            st = $(window).scrollTop(), // Scroll Top
            y = $(elm).offset().top,
            elementHeight = $(elm).height();

        if (type === "visible") return ((y < (vpH + st)) && (y > (st - elementHeight)));
        if (type === "above") return ((y < (vpH + st)));
    },

    indexArray: function (unindexedArray) {
        var indexedArray = {};

        $.map(unindexedArray, function(n, i){
            indexedArray[n['name']] = n['value'];
        });

        return indexedArray;
    }
};

var tcoHelper = new TCOHelper();