(function($) {
    "use strict";

    $(document).ready(function() {
        var woocommerce_attribute_id = $('[name="tco_woocommerce_attribute_id"]').val();
        var woocommerceAttributeOptionsArgs = null;
        var woocommerceAttributeOptions = null;

        $.ajax({
            url: theme_core_options_configs.ajax_url,
            type: 'POST',
            beforeSend: function() {

            },
            data: {
                action: 'get_woocommerce_attribute_options_args',
            }
        }).done(function(res) {
            if (res.success) {
                woocommerceAttributeOptionsArgs = res.data;
            } else {
                console.log(res.message);
            }
        }).fail(function(res) {
            console.log(res);
        }).always(function() {

        });

        $.ajax({
            url: theme_core_options_configs.ajax_url,
            type: 'POST',
            beforeSend: function() {

            },
            data: {
                action: 'get_woocommerce_attribute_options',
                woocommerce_attribute_id: woocommerce_attribute_id,
            }
        }).done(function(res) {
            if (res.success) {
                woocommerceAttributeOptions = res.data;
            } else {
                console.log(res.message);
            }
        }).fail(function(res) {
            console.log(res);
        }).always(function() {

        });

        tcoHelper.waitFor(function() {
            return woocommerceAttributeOptionsArgs != null && woocommerceAttributeOptions != null && tcoTemplates.ready;
        }, function() {

            if (!tcoHelper.isEmpty(woocommerceAttributeOptionsArgs)) {
                // Set Theme Options to Window Object
                $.each(woocommerceAttributeOptions, function(optId, optVal) {
                    window[optId] = optVal;
                });

                let woocommerceAttributeOptionsTabs = $('#woocommerce-attribute-options').tcoTabs({
                    tabsArgs: woocommerceAttributeOptionsArgs
                });
                let woocommerceAttributeOptionsActionsTmpl = tcoTemplates.getTemplate('theme-options-actions');
                let woocommerceAttributeOptionsActionsHtml = _.template(woocommerceAttributeOptionsActionsTmpl)({});
                woocommerceAttributeOptionsActionsHtml = $(woocommerceAttributeOptionsActionsHtml);
                let woocommerceAttributeOptionsInfoTmpl = tcoTemplates.getTemplate('theme-options-info');
                let woocommerceAttributeOptionsInfoHtml = _.template(woocommerceAttributeOptionsInfoTmpl)({});
                woocommerceAttributeOptionsInfoHtml = $(woocommerceAttributeOptionsInfoHtml);
                // woocommerceAttributeOptionsTabs.setTabsContentHeader(woocommerceAttributeOptionsActionsHtml.clone());
                // woocommerceAttributeOptionsTabs.setTabsContentFooter(woocommerceAttributeOptionsActionsHtml.clone());
                // woocommerceAttributeOptionsTabs.setTabsHeader(woocommerceAttributeOptionsInfoHtml);

                let maxHeight = 0;
                $.each(woocommerceAttributeOptionsTabs.element.find('.cms-tab-content'), function (index, item) {
                    if ($(item).outerHeight() > maxHeight) {
                        maxHeight = $(item).outerHeight();
                    }
                });
                woocommerceAttributeOptionsTabs.element.find('.cms-tabs-content').css('min-height', maxHeight + 'px');

                // Event
                let saveBtn = woocommerceAttributeOptionsTabs.element.find('.btn-save-options');
                let resetSectionBtn = woocommerceAttributeOptionsTabs.element.find('.btn-reset-section');
                let resetBtn = woocommerceAttributeOptionsTabs.element.find('.btn-reset');
                let loaderTmpl = tcoTemplates.getTemplate('loader-2');

                saveBtn.on('click', function(e) {
                    e.preventDefault();

                    if (!confirm("Are you sure you want to save the changes?")) {
                        return false;
                    }

                    let data = woocommerceAttributeOptionsTabs.element.find(':input').serializeArray();
                    let formData = new FormData();
                    $.each(data, function(index, item) {
                        formData.append(item['name'], item['value']);
                    });
                    formData.append('action', 'save_woocommerce_attribute_options');
                    formData.append('woocommerce_attribute_id', woocommerce_attribute_id);
                    $.ajax({
                        url: theme_core_options_configs.ajax_url,
                        type: "POST",
                        beforeSend: function() {
                            if ($('.loader-2').length === 0) {
                                woocommerceAttributeOptionsTabs.element.prepend(loaderTmpl);
                            }
                        },
                        data: formData,
                        contentType: false,
                        processData: false,
                    }).done(function(res) {
                        if (res.success) {

                        }
                    }).fail(function(res) {

                    }).always(function() {
                        $('.loader-2').remove();
                    });
                });
                resetSectionBtn.on('click', function (e) {
                    e.preventDefault();

                    if (!confirm("Are you sure you want to reset data of this section?")) {
                        return false;
                    }

                    let activeTab = woocommerceAttributeOptionsTabs.getActiveTab();
                    if (!tcoHelper.isEmpty(activeTab)) {
                        if (!tcoHelper.isEmpty(activeTab.sections)) {
                            $.each(activeTab.sections, function (sectionId, sectionArgs) {
                                if (!tcoHelper.isEmpty(sectionArgs.fields)) {
                                    $.each(sectionArgs.fields, function (fieldId, fieldArgs) {
                                        delete fieldArgs['value'];
                                        window[fieldId] = fieldArgs['default'];
                                    });
                                }
                            });
                            activeTab.tabContentEl.tcoAccordion({
                                accordionsArgs: activeTab.sections
                            });
                        }
                        else if (!tcoHelper.isEmpty(activeTab.fields)) {
                            $.each(activeTab.fields, function (fieldId, fieldArgs) {
                                delete fieldArgs['value'];
                                window[fieldId] = fieldArgs['default'];
                            });
                            console.log(activeTab.fields);
                            activeTab.tabContentEl.tcoForm({
                                fieldsArgs: activeTab.fields
                            });
                        }
                    }
                });
                resetBtn.on('click', function (e) {
                    e.preventDefault();

                    if (!confirm("Are you sure you want to reset data of all sections?")) {
                        return false;
                    }

                    let tabs = woocommerceAttributeOptionsTabs.tabs;
                    if (!tcoHelper.isEmpty(tabs)) {
                        $.each(tabs, function (tabId, tabArgs) {
                            if (!tcoHelper.isEmpty(tabArgs)) {
                                if (!tcoHelper.isEmpty(tabArgs.sections)) {
                                    $.each(tabArgs.sections, function (sectionId, sectionArgs) {
                                        if (!tcoHelper.isEmpty(sectionArgs.fields)) {
                                            $.each(sectionArgs.fields, function (fieldId, fieldArgs) {
                                                delete fieldArgs['value'];
                                                window[fieldId] = fieldArgs['default'];
                                            });
                                        }
                                    });
                                    tabArgs.tabContentEl.tcoAccordion({
                                        accordionsArgs: tabArgs.sections
                                    });
                                }
                                else if (!tcoHelper.isEmpty(tabArgs.fields)) {
                                    $.each(tabArgs.fields, function (fieldId, fieldArgs) {
                                        delete fieldArgs['value'];
                                        window[fieldId] = fieldArgs['default'];
                                    });
                                    console.log(tabArgs.fields);
                                    tabArgs.tabContentEl.tcoForm({
                                        fieldsArgs: tabArgs.fields
                                    });
                                }
                            }
                        });
                    }
                });
            }
        }, 'Wait for get Woocommerce Attribute Options Args!');
    });
}(jQuery));