(function($) {
    "use strict";

    $(document).ready(function() {
        var user_id = $('[name="user_id"]').val();
        var userOptionsArgs = null;
        var userOptions = null;

        $.ajax({
            url: theme_core_options_configs.ajax_url,
            type: 'POST',
            beforeSend: function() {

            },
            data: {
                action: 'get_user_options_args',
            }
        }).done(function(res) {
            if (res.success) {
                userOptionsArgs = res.data;
            } else {
                console.log(res.message);
            }
        }).fail(function(res) {
            console.log(res);
        }).always(function() {

        });

        $.ajax({
            url: theme_core_options_configs.ajax_url,
            type: 'POST',
            beforeSend: function() {

            },
            data: {
                action: 'get_user_options',
                user_id: user_id,
            }
        }).done(function(res) {
            if (res.success) {
                userOptions = res.data;
            } else {
                console.log(res.message);
            }
        }).fail(function(res) {
            console.log(res);
        }).always(function() {

        });

        tcoHelper.waitFor(function() {
            return userOptionsArgs != null && userOptions != null && tcoTemplates.ready;
        }, function() {

            if (!tcoHelper.isEmpty(userOptionsArgs)) {
                // Set Theme Options to Window Object
                $.each(userOptions, function(optId, optVal) {
                    window[optId] = optVal;
                });

                let userOptionsTabs = $('#user-options').tcoTabs({
                    tabsArgs: userOptionsArgs
                });
                let userOptionsActionsTmpl = tcoTemplates.getTemplate('theme-options-actions');
                let userOptionsActionsHtml = _.template(userOptionsActionsTmpl)({});
                userOptionsActionsHtml = $(userOptionsActionsHtml);
                let userOptionsInfoTmpl = tcoTemplates.getTemplate('theme-options-info');
                let userOptionsInfoHtml = _.template(userOptionsInfoTmpl)({});
                userOptionsInfoHtml = $(userOptionsInfoHtml);
                userOptionsTabs.setTabsContentHeader(userOptionsActionsHtml.clone());
                userOptionsTabs.setTabsContentFooter(userOptionsActionsHtml.clone());
                userOptionsTabs.setTabsHeader(userOptionsInfoHtml);

                let maxHeight = 0;
                $.each(userOptionsTabs.element.find('.cms-tab-content'), function (index, item) {
                    if ($(item).outerHeight() > maxHeight) {
                        maxHeight = $(item).outerHeight();
                    }
                });
                userOptionsTabs.element.find('.cms-tabs-content').css('min-height', maxHeight + 'px');

                // Event
                let saveBtn = userOptionsTabs.element.find('.btn-save-options');
                let resetSectionBtn = userOptionsTabs.element.find('.btn-reset-section');
                let resetBtn = userOptionsTabs.element.find('.btn-reset');
                let loaderTmpl = tcoTemplates.getTemplate('loader-2');

                saveBtn.on('click', function(e) {
                    e.preventDefault();

                    if (!confirm("Are you sure you want to save the changes?")) {
                        return false;
                    }

                    let data = userOptionsTabs.element.find(':input').serializeArray();
                    let formData = new FormData();
                    $.each(data, function(index, item) {
                        formData.append(item['name'], item['value']);
                    });
                    formData.append('action', 'save_user_options');
                    formData.append('user_id', user_id);
                    $.ajax({
                        url: theme_core_options_configs.ajax_url,
                        type: "POST",
                        beforeSend: function() {
                            if ($('.loader-2').length === 0) {
                                userOptionsTabs.element.prepend(loaderTmpl);
                            }
                        },
                        data: formData,
                        contentType: false,
                        processData: false,
                    }).done(function(res) {
                        if (res.success) {

                        }
                    }).fail(function(res) {

                    }).always(function() {
                        $('.loader-2').remove();
                    });
                });
                resetSectionBtn.on('click', function (e) {
                    e.preventDefault();

                    if (!confirm("Are you sure you want to reset data of this section?")) {
                        return false;
                    }

                    let activeTab = userOptionsTabs.getActiveTab();
                    if (!tcoHelper.isEmpty(activeTab)) {
                        if (!tcoHelper.isEmpty(activeTab.sections)) {
                            $.each(activeTab.sections, function (sectionId, sectionArgs) {
                                if (!tcoHelper.isEmpty(sectionArgs.fields)) {
                                    $.each(sectionArgs.fields, function (fieldId, fieldArgs) {
                                        delete fieldArgs['value'];
                                        window[fieldId] = fieldArgs['default'];
                                    });
                                }
                            });
                            activeTab.tabContentEl.tcoAccordion({
                                accordionsArgs: activeTab.sections
                            });
                        }
                        else if (!tcoHelper.isEmpty(activeTab.fields)) {
                            $.each(activeTab.fields, function (fieldId, fieldArgs) {
                                delete fieldArgs['value'];
                                window[fieldId] = fieldArgs['default'];
                            });
                            console.log(activeTab.fields);
                            activeTab.tabContentEl.tcoForm({
                                fieldsArgs: activeTab.fields
                            });
                        }
                    }
                });
                resetBtn.on('click', function (e) {
                    e.preventDefault();

                    if (!confirm("Are you sure you want to reset data of all sections?")) {
                        return false;
                    }

                    let tabs = userOptionsTabs.tabs;
                    if (!tcoHelper.isEmpty(tabs)) {
                        $.each(tabs, function (tabId, tabArgs) {
                            if (!tcoHelper.isEmpty(tabArgs)) {
                                if (!tcoHelper.isEmpty(tabArgs.sections)) {
                                    $.each(tabArgs.sections, function (sectionId, sectionArgs) {
                                        if (!tcoHelper.isEmpty(sectionArgs.fields)) {
                                            $.each(sectionArgs.fields, function (fieldId, fieldArgs) {
                                                delete fieldArgs['value'];
                                                window[fieldId] = fieldArgs['default'];
                                            });
                                        }
                                    });
                                    tabArgs.tabContentEl.tcoAccordion({
                                        accordionsArgs: tabArgs.sections
                                    });
                                }
                                else if (!tcoHelper.isEmpty(tabArgs.fields)) {
                                    $.each(tabArgs.fields, function (fieldId, fieldArgs) {
                                        delete fieldArgs['value'];
                                        window[fieldId] = fieldArgs['default'];
                                    });
                                    console.log(tabArgs.fields);
                                    tabArgs.tabContentEl.tcoForm({
                                        fieldsArgs: tabArgs.fields
                                    });
                                }
                            }
                        });
                    }
                });
            }
        }, 'Wait for get User Options Args!');
    });
}(jQuery));