(function ($) {
    "use strict";

    $(document).ready(function () {
        var themeOptionsArgs = null;
        var themeOptions = null;

        $.ajax({
            url: theme_core_options_configs.ajax_url,
            type: 'POST',
            beforeSend: function () {

            },
            data: {
                action: 'get_theme_options_args',
            }
        }).done(function (res) {
            if (res.success) {
                themeOptionsArgs = res.data;
            }
            else {
                console.log(res.message);
            }
        }).fail(function (res) {
            console.log(res);
        }).always(function () {

        });

        $.ajax({
            url: theme_core_options_configs.ajax_url,
            type: 'POST',
            beforeSend: function () {

            },
            data: {
                action: 'get_theme_options',
            }
        }).done(function (res) {
            if (res.success) {
                themeOptions = res.data;
            }
            else {
                console.log(res.message);
            }
        }).fail(function (res) {
            console.log(res);
        }).always(function () {

        });

        tcoHelper.waitFor(function () {
            return themeOptionsArgs != null && themeOptions != null && tcoTemplates.ready;
        }, function () {
            // Set Theme Options to Window Object
            $.each(themeOptions, function (optId, optVal) {
                try {
                    window[optId] = optVal;
                }
                catch {

                }
            });

            let themeOptionsTabs = $('#theme-options').tcoTabs({
                tabsArgs: themeOptionsArgs
            });
            let themeOptionsActionsTmpl = tcoTemplates.getTemplate('theme-options-actions');
            let themeOptionsActionsHtml = _.template(themeOptionsActionsTmpl)({});
            themeOptionsActionsHtml = $(themeOptionsActionsHtml);
            let themeOptionsInfoTmpl = tcoTemplates.getTemplate('theme-options-info');
            let themeOptionsInfoHtml = _.template(themeOptionsInfoTmpl)({});
            themeOptionsInfoHtml = $(themeOptionsInfoHtml);
            themeOptionsTabs.setTabsContentHeader(themeOptionsActionsHtml.clone());
            themeOptionsTabs.setTabsContentFooter(themeOptionsActionsHtml.clone());
            themeOptionsTabs.setTabsHeader(themeOptionsInfoHtml);

            let maxHeight = 0;
            $.each(themeOptionsTabs.element.find('.cms-tab-content'), function (index, item) {
                if ($(item).outerHeight() > maxHeight) {
                    maxHeight = $(item).outerHeight();
                }
            });
            themeOptionsTabs.element.find('.cms-tabs-content').css('min-height', maxHeight + 'px');

            // Event
            let saveBtn = themeOptionsTabs.element.find('.btn-save-options');
            let resetSectionBtn = themeOptionsTabs.element.find('.btn-reset-section');
            let resetBtn = themeOptionsTabs.element.find('.btn-reset');
            let loaderTmpl = tcoTemplates.getTemplate('loader-2');

            saveBtn.on('click', function (e) {
                e.preventDefault();

                if (!confirm("Are you sure you want to save the changes?")) {
                    return false;
                }

                let data = themeOptionsTabs.element.find(':input').serializeArray();
                let formData = new FormData();
                $.each(data, function (index, item) {
                    formData.append(item['name'], item['value']);
                });
                formData.append('action', 'save_theme_options');
                $.ajax({
                    url: theme_core_options_configs.ajax_url,
                    type: "POST",
                    beforeSend: function () {
                        if ($('.loader-2').length === 0) {
                            themeOptionsTabs.element.prepend(loaderTmpl);
                        }
                    },
                    data: formData,
                    contentType: false,
                    processData: false,
                }).done(function (res) {
                    if (res.success) {

                    }
                }).fail(function (res) {

                }).always(function () {
                    $('.loader-2').remove();
                });
            });
            resetSectionBtn.on('click', function (e) {
                e.preventDefault();

                if (!confirm("Are you sure you want to reset data of this section?")) {
                    return false;
                }

                let activeTab = themeOptionsTabs.getActiveTab();
                if (!tcoHelper.isEmpty(activeTab)) {
                    if (!tcoHelper.isEmpty(activeTab.sections)) {
                        $.each(activeTab.sections, function (sectionId, sectionArgs) {
                            if (!tcoHelper.isEmpty(sectionArgs.fields)) {
                                $.each(sectionArgs.fields, function (fieldId, fieldArgs) {
                                    delete fieldArgs['value'];
                                    window[fieldId] = fieldArgs['default'];
                                });
                            }
                        });
                        activeTab.tabContentEl.tcoAccordion({
                            accordionsArgs: activeTab.sections
                        });
                    }
                    else if (!tcoHelper.isEmpty(activeTab.fields)) {
                        $.each(activeTab.fields, function (fieldId, fieldArgs) {
                            delete fieldArgs['value'];
                            window[fieldId] = fieldArgs['default'];
                        });
                        console.log(activeTab.fields);
                        activeTab.tabContentEl.tcoForm({
                            fieldsArgs: activeTab.fields
                        });
                    }

                    let data = themeOptionsTabs.element.find(':input').serializeArray();
                    let formData = new FormData();
                    $.each(data, function (index, item) {
                        formData.append(item['name'], item['value']);
                    });
                    formData.append('action', 'save_theme_options');
                    $.ajax({
                        url: theme_core_options_configs.ajax_url,
                        type: "POST",
                        beforeSend: function () {
                            if ($('.loader-2').length === 0) {
                                themeOptionsTabs.element.prepend(loaderTmpl);
                            }
                        },
                        data: formData,
                        contentType: false,
                        processData: false,
                    }).done(function (res) {
                        if (res.success) {

                        }
                    }).fail(function (res) {

                    }).always(function () {
                        $('.loader-2').remove();
                    });
                }
            });
            resetBtn.on('click', function (e) {
                e.preventDefault();

                if (!confirm("Are you sure you want to reset data of all sections?")) {
                    return false;
                }

                let tabs = themeOptionsTabs.tabs;
                if (!tcoHelper.isEmpty(tabs)) {
                    $.each(tabs, function (tabId, tabArgs) {
                        if (!tcoHelper.isEmpty(tabArgs)) {
                            if (!tcoHelper.isEmpty(tabArgs.sections)) {
                                $.each(tabArgs.sections, function (sectionId, sectionArgs) {
                                    if (!tcoHelper.isEmpty(sectionArgs.fields)) {
                                        $.each(sectionArgs.fields, function (fieldId, fieldArgs) {
                                            delete fieldArgs['value'];
                                            window[fieldId] = fieldArgs['default'];
                                        });
                                    }
                                });
                                tabArgs.tabContentEl.tcoAccordion({
                                    accordionsArgs: tabArgs.sections
                                });
                            }
                            else if (!tcoHelper.isEmpty(tabArgs.fields)) {
                                $.each(tabArgs.fields, function (fieldId, fieldArgs) {
                                    delete fieldArgs['value'];
                                    window[fieldId] = fieldArgs['default'];
                                });
                                console.log(tabArgs.fields);
                                tabArgs.tabContentEl.tcoForm({
                                    fieldsArgs: tabArgs.fields
                                });
                            }
                        }
                    });

                    let data = themeOptionsTabs.element.find(':input').serializeArray();
                    let formData = new FormData();
                    $.each(data, function (index, item) {
                        formData.append(item['name'], item['value']);
                    });
                    formData.append('action', 'save_theme_options');
                    $.ajax({
                        url: theme_core_options_configs.ajax_url,
                        type: "POST",
                        beforeSend: function () {
                            if ($('.loader-2').length === 0) {
                                themeOptionsTabs.element.prepend(loaderTmpl);
                            }
                        },
                        data: formData,
                        contentType: false,
                        processData: false,
                    }).done(function (res) {
                        if (res.success) {

                        }
                    }).fail(function (res) {

                    }).always(function () {
                        $('.loader-2').remove();
                    });
                }
            });
        }, 'Wait for get Theme Options Args!');
    });
}(jQuery));