(function($) {
    "use strict";

    $(document).ready(function() {
        var postId = $('#post_ID').val();
        var pageOptionsArgs = null;
        var pageOptions = null;

        $.ajax({
            url: theme_core_options_configs.ajax_url,
            type: 'POST',
            beforeSend: function() {

            },
            data: {
                action: 'get_page_options_args',
                post_id: postId
            }
        }).done(function(res) {
            if (res.success) {
                pageOptionsArgs = res.data;
            } else {
                
            }
        }).fail(function(res) {
            
        }).always(function() {

        });

        $.ajax({
            url: theme_core_options_configs.ajax_url,
            type: 'POST',
            beforeSend: function() {

            },
            data: {
                action: 'get_page_options',
                post_id: postId
            }
        }).done(function(res) {
            if (res.success) {
                pageOptions = res.data;
            } else {
                
            }
        }).fail(function(res) {
            
        }).always(function() {

        });

        tcoHelper.waitFor(function() {
            return pageOptionsArgs != null && pageOptions != null && tcoTemplates.ready;
        }, function() {

            if (!tcoHelper.isEmpty(pageOptionsArgs)) {
                // Set Theme Options to Window Object
                $.each(pageOptions, function(optId, optVal) {
                    try {
                        window[optId] = optVal;
                    } catch {

                    }
                });

                let fieldsList = {};
                $.each(pageOptionsArgs, function(tabId, tabArgs) {
                    if (!tcoHelper.isEmpty(tabArgs)) {
                        if (!tcoHelper.isEmpty(tabArgs.sections)) {
                            $.each(tabArgs.sections, function(sectionId, sectionArgs) {
                                if (!tcoHelper.isEmpty(sectionArgs.fields)) {
                                    $.each(sectionArgs.fields, function(fieldId, fieldArgs) {
                                        fieldsList[fieldId] = '';
                                    });
                                }
                            });
                        } else if (!tcoHelper.isEmpty(tabArgs.fields)) {
                            $.each(tabArgs.fields, function(fieldId, fieldArgs) {
                                fieldsList[fieldId] = '';
                            });
                        }
                    }
                });

                let pageOptionsTabs = $('#page-options').tcoTabs({
                    tabsArgs: pageOptionsArgs
                });
                let pageOptionsActionsTmpl = tcoTemplates.getTemplate('theme-options-actions');
                let pageOptionsActionsHtml = _.template(pageOptionsActionsTmpl)({});
                pageOptionsActionsHtml = $(pageOptionsActionsHtml);
                let pageOptionsInfoTmpl = tcoTemplates.getTemplate('theme-options-info');
                let pageOptionsInfoHtml = _.template(pageOptionsInfoTmpl)({});
                pageOptionsInfoHtml = $(pageOptionsInfoHtml);
                pageOptionsTabs.setTabsContentHeader(pageOptionsActionsHtml.clone());
                pageOptionsTabs.setTabsContentFooter(pageOptionsActionsHtml.clone());
                pageOptionsTabs.setTabsHeader(pageOptionsInfoHtml);

                let maxHeight = 0;
                $.each(pageOptionsTabs.element.find('.cms-tab-content'), function(index, item) {
                    if ($(item).outerHeight() > maxHeight) {
                        maxHeight = $(item).outerHeight();
                    }
                });
                pageOptionsTabs.element.find('.cms-tabs-content').css('min-height', maxHeight + 'px');

                // Event
                let saveBtn = pageOptionsTabs.element.find('.btn-save-options');
                let resetSectionBtn = pageOptionsTabs.element.find('.btn-reset-section');
                let resetBtn = pageOptionsTabs.element.find('.btn-reset');
                let loaderTmpl = tcoTemplates.getTemplate('loader-2');

                saveBtn.on('click', function(e) {
                    e.preventDefault();

                    if (!confirm("Are you sure you want to save the changes?")) {
                        return false;
                    }

                    let data = pageOptionsTabs.element.find(':input').serializeArray();
                    let formData = new FormData();
                    $.each(data, function(index, item) {
                        fieldsList[item['name']] = item['value'];
                    });
                    $.each(fieldsList, function(fieldIndex, fieldValue) {
                        formData.append(fieldIndex, fieldValue);
                    });
                    formData.append('action', 'save_page_options');
                    formData.append('post_id', postId);
                    $.ajax({
                        url: theme_core_options_configs.ajax_url,
                        type: "POST",
                        beforeSend: function() {
                            if ($('.loader-2').length === 0) {
                                pageOptionsTabs.element.prepend(loaderTmpl);
                            }
                        },
                        data: formData,
                        contentType: false,
                        processData: false,
                    }).done(function(res) {
                        if (res.success) {

                        }
                    }).fail(function(res) {

                    }).always(function() {
                        $('.loader-2').remove();
                    });
                });
                resetSectionBtn.on('click', function(e) {
                    e.preventDefault();

                    if (!confirm("Are you sure you want to reset data of this section?")) {
                        return false;
                    }

                    let activeTab = pageOptionsTabs.getActiveTab();
                    if (!tcoHelper.isEmpty(activeTab)) {
                        if (!tcoHelper.isEmpty(activeTab.sections)) {
                            $.each(activeTab.sections, function(sectionId, sectionArgs) {
                                if (!tcoHelper.isEmpty(sectionArgs.fields)) {
                                    $.each(sectionArgs.fields, function(fieldId, fieldArgs) {
                                        delete fieldArgs['value'];
                                        window[fieldId] = fieldArgs['default'];
                                    });
                                }
                            });
                            activeTab.tabContentEl.tcoAccordion({
                                accordionsArgs: activeTab.sections
                            });
                        } else if (!tcoHelper.isEmpty(activeTab.fields)) {
                            $.each(activeTab.fields, function(fieldId, fieldArgs) {
                                delete fieldArgs['value'];
                                window[fieldId] = fieldArgs['default'];
                            });
                            activeTab.tabContentEl.tcoForm({
                                fieldsArgs: activeTab.fields
                            });
                        }

                        let data = pageOptionsTabs.element.find(':input').serializeArray();
                        let formData = new FormData();
                        $.each(data, function(index, item) {
                            formData.append(item['name'], item['value']);
                        });
                        formData.append('action', 'save_page_options');
                        formData.append('post_id', postId);
                        $.ajax({
                            url: theme_core_options_configs.ajax_url,
                            type: "POST",
                            beforeSend: function() {
                                if ($('.loader-2').length === 0) {
                                    pageOptionsTabs.element.prepend(loaderTmpl);
                                }
                            },
                            data: formData,
                            contentType: false,
                            processData: false,
                        }).done(function(res) {
                            if (res.success) {

                            }
                        }).fail(function(res) {

                        }).always(function() {
                            $('.loader-2').remove();
                        });
                    }
                });
                resetBtn.on('click', function(e) {
                    e.preventDefault();

                    if (!confirm("Are you sure you want to reset data of all sections?")) {
                        return false;
                    }

                    let tabs = pageOptionsTabs.tabs;
                    if (!tcoHelper.isEmpty(tabs)) {
                        $.each(tabs, function(tabId, tabArgs) {
                            if (!tcoHelper.isEmpty(tabArgs)) {
                                if (!tcoHelper.isEmpty(tabArgs.sections)) {
                                    $.each(tabArgs.sections, function(sectionId, sectionArgs) {
                                        if (!tcoHelper.isEmpty(sectionArgs.fields)) {
                                            $.each(sectionArgs.fields, function(fieldId, fieldArgs) {
                                                delete fieldArgs['value'];
                                                window[fieldId] = fieldArgs['default'];
                                            });
                                        }
                                    });
                                    tabArgs.tabContentEl.tcoAccordion({
                                        accordionsArgs: tabArgs.sections
                                    });
                                } else if (!tcoHelper.isEmpty(tabArgs.fields)) {
                                    $.each(tabArgs.fields, function(fieldId, fieldArgs) {
                                        delete fieldArgs['value'];
                                        window[fieldId] = fieldArgs['default'];
                                    });
                                    tabArgs.tabContentEl.tcoForm({
                                        fieldsArgs: tabArgs.fields
                                    });
                                }
                            }
                        });

                        let data = pageOptionsTabs.element.find(':input').serializeArray();
                        let formData = new FormData();
                        $.each(data, function(index, item) {
                            formData.append(item['name'], item['value']);
                        });
                        formData.append('action', 'save_page_options');
                        formData.append('post_id', postId);
                        $.ajax({
                            url: theme_core_options_configs.ajax_url,
                            type: "POST",
                            beforeSend: function() {
                                if ($('.loader-2').length === 0) {
                                    pageOptionsTabs.element.prepend(loaderTmpl);
                                }
                            },
                            data: formData,
                            contentType: false,
                            processData: false,
                        }).done(function(res) {
                            if (res.success) {

                            }
                        }).fail(function(res) {

                        }).always(function() {
                            $('.loader-2').remove();
                        });
                    }
                });
            }
        }, 'Wait for get Page Options Args!');
    });
}(jQuery));