( function ($) {
	"use strict";

	var TCO_ACCORDION = 'TCOAccordion';

	function TCOAccordion(config, element) {
	    let $element = $(element);

	    $element.data(TCO_ACCORDION, this);

	    this.element = $element;

	    this.init(config);
	    this.render();
	}

	TCOAccordion.prototype = {
		// id
		accordionHeaderPreId: 'accordion-link-' + tcoHelper.getTimestamp() + '-',
		accordionContentPreId: 'accordion-content-' + tcoHelper.getTimestamp() + '-',

		accordionsArgs: {},

		accordions: {},

	    init: function (config) {
	        $.extend(this, config);

	        this.formatAccordion();
	    },

	    render: function () {
	    	let _this = this;
            let accordionContainerTmpl = tcoTemplates.getTemplate('accordion-container');
            let accordionContainerHtml = _.template(accordionContainerTmpl)({
                config: _this
            });
            accordionContainerHtml = $(accordionContainerHtml);

            tcoHelper.waitFor(function () {
            	return !tcoHelper.isEmpty(_this.accordions);
            }, function () {
            	$.each(_this.accordions, function (accordionKey, accordionArgs) {
	            	accordionContainerHtml.append(accordionArgs.accordionItemEl);
	            });
            }, 'Wait for format accordionsArgs!', 300);
            
            _this.element.html(accordionContainerHtml);
            
            return accordionContainerHtml;
	    },

	    formatAccordion: function () {
	    	let _this = this;
	    	let accordionItemTmpl = tcoTemplates.getTemplate('accordion-item');
	    	_this.accordions = {};
            
            let count = 0;
	    	$.each(_this.accordionsArgs, function (accordionKey, accordionArgs) {
	    		count++;

	    		// Accordion Config
	    		accordionArgs.accordionKey = accordionKey;
	    		accordionArgs.active = count === 1;
	    		let accordionConfig = {
	    			active: count === 1,
	    			accordionKey: accordionKey,
	    			accordionArgs: accordionArgs,
	    			accordionHeaderPreId: _this.accordionHeaderPreId,
	    			accordionContentPreId: _this.accordionContentPreId,
	    		};

	    		// Accordion Link
	    		let accordionItemHtml = _.template(accordionItemTmpl)({
	                config: accordionConfig
	            });
	            accordionItemHtml = $(accordionItemHtml);

	            let accordionHeader = accordionItemHtml.find('#' + _this.accordionHeaderPreId + accordionKey);
	            let accordionContent = accordionItemHtml.find('#' + _this.accordionContentPreId + accordionKey);

	            // Build accordionContentHtml
	            if(!tcoHelper.isEmpty(accordionArgs.fields)){
                    accordionContent.tcoForm({
                        fieldsArgs: accordionArgs.fields
                    });
                }

	            // Events
	            accordionHeader.on('click', function (e) {
	            	e.preventDefault();

	            	let activeAccordion = _this.getActiveAccordion();
	            	let accordion = _this.getAccordion(accordionKey);

	            	activeAccordion.active = false;
	            	_this.updateAccordion(activeAccordion.accordionKey, activeAccordion);
	            	activeAccordion.accordionItemEl.find('#' + _this.accordionHeaderPreId + activeAccordion.accordionKey).removeClass('active');
	            	activeAccordion.accordionItemEl.find('#' + _this.accordionContentPreId + activeAccordion.accordionKey).removeClass('active');
	            	
	            	accordion.active = true;
	            	_this.updateAccordion(accordionKey, accordion);
	            	accordion.accordionItemEl.find('#' + _this.accordionHeaderPreId + accordion.accordionKey).addClass('active');
	            	accordion.accordionItemEl.find('#' + _this.accordionContentPreId + accordion.accordionKey).addClass('active');
	            });

	            accordionArgs.accordionItemEl = accordionItemHtml;
	            _this.addAccordion(accordionKey, accordionArgs);
	    	});
	    },

	    addAccordion: function (accordionKey, accordionArgs) {
            this.accordions[accordionKey] = accordionArgs;
        },

        updateAccordion: function (accordionKey, accordionArgs) {
            this.accordions[accordionKey] = accordionArgs;
        },

        getAccordion: function (accordionKey) {
            return this.accordions[accordionKey];
        },

        getActiveAccordion: function () {
        	let _this = this;
        	let activeAccordion = {};
        	$.each(_this.accordions, function (accordionKey, accordionArgs) {
        		if(accordionArgs.active === true){
        			activeAccordion = accordionArgs;
        		}
        	});

        	return activeAccordion;
        },
	};

	$.fn.tcoAccordion = function (config) {
	    let result = this;

	    this.each(function () {
	        let $element = $(this),
	            instance = $element.data(TCO_ACCORDION);

	        if (instance) {
	            instance.init(config);
	            instance.render();

	            result = instance;
	        } else {
	            result = new TCOAccordion(config, $element);
	        }
	    });

	    return result;
	};
}(jQuery) );