# Theme Core Options
A easily to use options framework for wordpress

## How to Use

### Hooks

1. tco_page_parent

* Order where the menu appears in the admin area.

<p>
    <img src="/assets/images/readme/page-parent-1.png" alt="Page Parent" style="max-width:100%;">
    <img src="/assets/images/readme/page-parent-2.png" alt="Page Parent" style="max-width:100%;">
</p>

```sh
add_filter('tco_page_parent', '{$prefix}_tco_parent_page');
function {$prefix}_tco_parent_page(){
    $theme = wp_get_theme();
    return $theme->get('TextDomain');
}
```

2. tco_theme_logo

<p>
  <img src="/assets/images/readme/theme-logo-1.png" alt="Theme Logo" style="max-width:100%;">
      <img src="/assets/images/readme/theme-logo-2.png" alt="Theme Logo" style="max-width:100%;">
</p>

```sh
add_filter('tco_theme_logo', '{$prefix}_tco_theme_logo');
function {$prefix}_tco_theme_logo(){
    return get_theme_file_uri( '{$logo_path}' );
}
```

3. tco_theme_options_name

* Set name of theme options will be stored in database (<strong><i>options</i></strong> table).
* Should use {$prefix}_get_opt_name() function.

```sh
add_filter('tco_theme_options_name', '{$prefix}_tco_theme_options_name');
function {$prefix}_tco_theme_options_name(){
    $opt_name = '{$enter_the_name_you_want_or_use_function_get_opt_name_like_old_them_framework}';
    return $opt_name;
}
```

4. tco_theme_options_args / tco_{$post_type}_page_options_args

```sh
add_filter('tco_theme_options_args', '{$prefix}_theme_options_args');
function {$prefix}_theme_options_args(){
    $args = {inc/helpers/theme-options-sample.php} // Please check this file to know how to make args for theme options
    return $args;
}
```

```sh
add_filter('tco_{$post_type}_page_options_args', '{$prefix}_{$post_type}_page_options_args');
function {$prefix}_{$post_type}_page_options_args(){
    $args = {inc/helpers/page-options-sample.php} // Please check this file to know how to make args for page options
    return $args;
}
```

5. enable_theme_options_args_sample / enable_page_options_args_sample

* Preview how to options work.

```sh
add_filter('enable_theme_options_args_sample', '{$prefix}_enable_theme_options_args_sample');
function {$prefix}_enable_theme_options_args_sample(){
    return true;
}
```

```sh
add_filter('enable_page_options_args_sample', '{$prefix}_enable_page_options_args_sample');
function {$prefix}_enable_page_options_args_sample(){
    return true;
}
```

### Get Options

1. Theme Options

* Add below function to template-functions.php

```sh
function {$prefix}_get_opt( $opt_id, $default = false ) {
    $opt_name = {$prefix}_get_opt_name();

    $options = get_option($opt_name, []);

    if (empty($options) || !isset($options[$opt_id]) || empty($options[$opt_id])) {
        return $default;
    }

    if (is_array($options[$opt_id]) && is_array($default)) {
        foreach ($options[$opt_id] as $key => $value) {
            if (isset($default[$key]) && empty($value)) {
                $options[$opt_id][$key] = $default[$key];
            }
        }
    }

    return $options[$opt_id];
}
```

2. Page Options

* Add below function to template-functions.php

```sh
function {$prefix}_get_page_opt( $opt_id, $default = false ) {
	$id = get_the_ID();
	if ( ! is_archive() && is_home() ) {
		if ( ! is_front_page() ) {
			$page_for_posts = get_option( 'page_for_posts' );
			$id             = $page_for_posts;
		}
	}

	// Get page option for Shop Page
    if(class_exists('WooCommerce') && is_shop()){
        $id = get_option( 'woocommerce_shop_page_id' );
    }

	return $options = ! empty($id) ? get_post_meta( intval( $id ), $opt_id, true ) : $default;
}
```