<?php

use Elementor\Icons_Manager;

/**
 * Elementor cms icon picker control.
 *
 * @since 1.0.0
 */
class Elementor_Theme_Core_Posts_Control extends \Elementor\Base_Data_Control
{
    public function __construct()
    {
        parent::__construct();

        add_action('wp_ajax_etc_posts_control_get_posts', [$this, 'get_posts']);
        add_action('wp_ajax_nopriv_etc_posts_control_get_posts', [$this, 'get_posts']);
    }

    /**
     * Get emoji one area control type.
     *
     * Retrieve the control type, in this case `cms_icons`.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Control type.
     */
    public function get_type()
    {
        return Elementor_Theme_Core::POSTS_CONTROL;
    }

    /**
     * Enqueue emoji one area control scripts and styles.
     *
     * Used to register and enqueue custom scripts and styles used by the emoji one
     * area control.
     *
     * @since 1.0.0
     * @access public
     */
    public function enqueue()
    {
        wp_enqueue_style('select2');
        wp_enqueue_script('select2');
        wp_enqueue_script('cms-posts-control', ETC_URL . 'assets/js/etc-posts-control.js', ['jquery'], '1.0.0');
        wp_localize_script('cms-posts-control', 'cms_posts_control_config', [
            'ajax_url' => admin_url('admin-ajax.php')
        ]);
    }

    /**
     * Get emoji one area control default settings.
     *
     * Retrieve the default settings of the emoji one area control. Used to return
     * the default settings while initializing the emoji one area control.
     *
     * @since 1.0.0
     * @access protected
     *
     * @return array Control default settings.
     */
    protected function get_default_settings()
    {
        return [
            'label_block' => true,
            'return_value' => 'slug',
        ];
    }

    /**
     * Render emoji one area control output in the editor.
     *
     * Used to generate the control HTML in the editor using Underscore JS
     * template. The variables for the class are available using `data` JS
     * object.
     *
     * @since 1.0.0
     * @access public
     */
    public function content_template()
    {
        $control_uid = $this->get_control_uid();
        $post_types = get_post_types([
            'public' => true
        ], 'object');

?>
        <div class="elementor-control-field">
            <# if ( data.label ) { #>
                <label for="<?php echo esc_attr($control_uid); ?>" class="elementor-control-title">{{{ data.label }}}</label>
                <# } #>
                    <div class="elementor-control-input-wrapper">
                        <?php
                            // echo '<pre>';
                            // var_dump($post_types);
                            // echo '</pre>';
                        ?>
                        <!-- <select name="" id="<?php // echo $control_uid; ?>-post-type" class="select2 elementor-control-tag-area" data-placeholder="<?php // echo esc_attr__('Select Post Type', ETC_TEXT_DOMAIN); ?>">
                            <option value="any"><?php // echo esc_html__('All', ETC_TEXT_DOMAIN); ?></option>
                            <?php
                                // foreach ($post_types as $post_type) {
                                    ?>
                                    <option value="<?php // echo esc_attr($post_type->label); ?>"><?php // echo esc_html($post_type->name); ?></option>
                                    <?php
                                // }
                            ?>
                            
                        </select> -->
                        <select name="" id="<?php echo $control_uid; ?>" class="select2 tooltip-target elementor-control-tag-area" data-tooltip="{{ data.title }}" data-setting="{{ data.name }}" data-placeholder="<# if(!_.isEmpty(data.placeholder)) { print(data.placeholder); } else { print('Select Option'); } #>" <# if(data.multiple==true) { print('multiple'); } #>>
                        </select>
                    </div>
        </div>
        <# if ( data.description ) { #>
            <div class="elementor-control-field-description">{{{ data.description }}}</div>
            <# } #>
        <?php
    }
}
