<?php

if (!defined('ABSPATH')) {
    die();
}
if (!class_exists('CMS_Ajax_Handle')) {
    class CMS_Ajax_Handle
    {
        public function __construct()
        {
            add_action('wp_ajax_cms_auto_generate', array($this, 'cms_auto_generate'));

            add_action('wp_ajax_etc_posts_control_get_posts', [$this, 'get_posts']);
            add_action('wp_ajax_nopriv_etc_posts_control_get_posts', [$this, 'get_posts']);
            add_action('wp_ajax_etc_get_posts_by_slugs', [$this, 'get_posts_by_slugs']);
            add_action('wp_ajax_nopriv_etc_get_posts_by_slugs', [$this, 'get_posts_by_slugs']);
            add_action('wp_ajax_etc_get_posts_by_ids', [$this, 'get_posts_by_ids']);
            add_action('wp_ajax_nopriv_etc_get_posts_by_ids', [$this, 'get_posts_by_ids']);
        }

        function cms_auto_generate()
        {
            try {
                $result = [
                    'stt' => true,
                    'msg' => __('Generate Successfully!', ETC_TEXT_DOMAIN),
                    'data' => strtoupper(substr(md5(uniqid(mt_rand(), true) . ':' . microtime(true)), 5, 11)),
                ];
                wp_send_json($result);
            } catch (Exception $e) {
                $result = [
                    'stt' => false,
                    'msg' => $e->getMessage(),
                    'data' => '',
                ];
                wp_send_json($result);
            }
            die();
        }

        public function get_posts()
        {
            $result = [];
            $post_type = isset($_POST['post_type']) ? $_POST['post_type'] : [ 'post' ];
            if(!is_array($post_type)){
                $post_type = [ $post_type ];
            }

            $limit = 10;
            $page = 1;
            if (isset($_POST['page'])) {
                $page = intval($_POST['page']);
                $page = $page > 0 ? $page : 1;
            }
            $orderby = 'date';
            $order = 'DESC';
            $query_params = [
                'post_type' => $post_type,
                'posts_per_page' => $limit,
                'orderby' => $orderby,
                'order' => $order,
                'paged' => $page,
                'search_columns' => [
                    'post_title'
                ],
            ];

            if (isset($_POST['s'])) {
                $query_params['s'] = $_POST['s'];
            }

            $query = new \WP_Query($query_params);
            $posts = [];

            foreach ($query->posts as $post) {
                $posts[] = [
                    'id' => $post->ID,
                    'post_name' => $post->post_name,
                    'post_title' => $post->post_title,
                ];
            }

            $paginated = !$query->get('no_found_rows');

            $result = [
                'data' => [
                    'posts' => $posts,
                    'total'        => $paginated ? (int) $query->found_posts : count($query->posts),
                    'total_pages'  => $paginated ? (int) $query->max_num_pages : 1,
                    'per_page'     => (int) $query->get('posts_per_page'),
                    'current_page' => $paginated ? (int) max(1, $query->get('paged', 1)) : 1,
                ],
                'message' => esc_html__('Successfully', ETC_TEXT_DOMAIN),
                'success' => true,
            ];

            wp_send_json($result);
            die();
        }

        public function get_posts_by_slugs(){
            if(!isset($_POST['post_name'])){
                wp_send_json([
                    'success' => false,
                    'message' => __('Fail!', ETC_TEXT_DOMAIN),
                    'data' => [],
                ]);
                die(); 
            }

            $post_type = isset($_POST['post_type']) && !empty($_POST['post_type']) ? $_POST['post_type'] : [ 'post' ];
            if(!is_array($post_type)){
                $post_type = [ $post_type ];
            }

            $post_name = isset($_POST['post_name']) ? $_POST['post_name'] : [];
            if(!is_array($post_name)){
                $post_name = [ $post_name ];
            }

            $orderby = 'date';
            $order = 'DESC';
            $query_params = [
                'post_type' => $post_type,
                'posts_per_page' => -1,
                'orderby' => $orderby,
                'order' => $order,
                'post_name__in' => $post_name,
            ];

            $query = new \WP_Query($query_params);
            $posts = [];

            foreach ($query->posts as $post) {
                $posts[] = [
                    'id' => $post->ID,
                    'post_name' => $post->post_name,
                    'post_title' => $post->post_title,
                ];
            }

            $result = [
                'success' => true,
                'message' => __('Successfully!', ETC_TEXT_DOMAIN),
                'data' => $posts,
            ];

            wp_send_json($result);
            die();
        }

        public function get_posts_by_ids(){
            if(!isset($_POST['post_id'])){
                wp_send_json([
                    'success' => false,
                    'message' => __('Fail!', ETC_TEXT_DOMAIN),
                    'data' => [],
                ]);
                die(); 
            }

            $post_type = isset($_POST['post_type']) && !empty($_POST['post_type']) ? $_POST['post_type'] : [ 'post' ];
            if(!is_array($post_type)){
                $post_type = [ $post_type ];
            }

            $post_id = isset($_POST['post_id']) ? $_POST['post_id'] : [];
            if(!is_array($post_id)){
                $post_id = etc_sanitize_query_var($post_id);
                $test = $post_id;
                $post_id = [ $post_id ];
            }

            $orderby = 'date';
            $order = 'DESC';
            $query_params = [
                'post_type' => $post_type,
                'posts_per_page' => -1,
                'orderby' => $orderby,
                'order' => $order,
                'post__in' => $post_id,
            ];

            $query = new \WP_Query($query_params);
            $posts = [];

            foreach ($query->posts as $post) {
                $posts[] = [
                    'id' => $post->ID,
                    'post_name' => $post->post_name,
                    'post_title' => $post->post_title,
                ];
            }

            $result = [
                'success' => true,
                'message' => __('Successfully!', ETC_TEXT_DOMAIN),
                'data' => $posts,
                'post_id' => $post_id,
                'test' => $test,
            ];

            wp_send_json($result);
            die();
        }
    }
    new CMS_Ajax_Handle();
}
