/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-11-28 07:04:37 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint unsigned NOT NULL DEFAULT '10',
  `args` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint unsigned NOT NULL DEFAULT '0',
  `attempts` int NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=151 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=1949 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=416 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `package` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_events` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_newsletter` (
  `id` int NOT NULL AUTO_INCREMENT,
  `email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `name` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `token` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `language` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `status` varchar(1) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'S',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated` int NOT NULL DEFAULT '0',
  `last_activity` int NOT NULL DEFAULT '0',
  `surname` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `sex` char(1) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'n',
  `feed_time` bigint NOT NULL DEFAULT '0',
  `feed` tinyint NOT NULL DEFAULT '0',
  `referrer` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `ip` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `wp_user_id` int NOT NULL DEFAULT '0',
  `source` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `http_referer` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `geo` tinyint NOT NULL DEFAULT '0',
  `country` varchar(4) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `region` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `city` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `bounce_type` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `bounce_time` int NOT NULL DEFAULT '0',
  `unsub_email_id` int NOT NULL DEFAULT '0',
  `unsub_time` int NOT NULL DEFAULT '0',
  `list_1` tinyint NOT NULL DEFAULT '0',
  `list_2` tinyint NOT NULL DEFAULT '0',
  `list_3` tinyint NOT NULL DEFAULT '0',
  `list_4` tinyint NOT NULL DEFAULT '0',
  `list_5` tinyint NOT NULL DEFAULT '0',
  `list_6` tinyint NOT NULL DEFAULT '0',
  `list_7` tinyint NOT NULL DEFAULT '0',
  `list_8` tinyint NOT NULL DEFAULT '0',
  `list_9` tinyint NOT NULL DEFAULT '0',
  `list_10` tinyint NOT NULL DEFAULT '0',
  `list_11` tinyint NOT NULL DEFAULT '0',
  `list_12` tinyint NOT NULL DEFAULT '0',
  `list_13` tinyint NOT NULL DEFAULT '0',
  `list_14` tinyint NOT NULL DEFAULT '0',
  `list_15` tinyint NOT NULL DEFAULT '0',
  `list_16` tinyint NOT NULL DEFAULT '0',
  `list_17` tinyint NOT NULL DEFAULT '0',
  `list_18` tinyint NOT NULL DEFAULT '0',
  `list_19` tinyint NOT NULL DEFAULT '0',
  `list_20` tinyint NOT NULL DEFAULT '0',
  `list_21` tinyint NOT NULL DEFAULT '0',
  `list_22` tinyint NOT NULL DEFAULT '0',
  `list_23` tinyint NOT NULL DEFAULT '0',
  `list_24` tinyint NOT NULL DEFAULT '0',
  `list_25` tinyint NOT NULL DEFAULT '0',
  `list_26` tinyint NOT NULL DEFAULT '0',
  `list_27` tinyint NOT NULL DEFAULT '0',
  `list_28` tinyint NOT NULL DEFAULT '0',
  `list_29` tinyint NOT NULL DEFAULT '0',
  `list_30` tinyint NOT NULL DEFAULT '0',
  `list_31` tinyint NOT NULL DEFAULT '0',
  `list_32` tinyint NOT NULL DEFAULT '0',
  `list_33` tinyint NOT NULL DEFAULT '0',
  `list_34` tinyint NOT NULL DEFAULT '0',
  `list_35` tinyint NOT NULL DEFAULT '0',
  `list_36` tinyint NOT NULL DEFAULT '0',
  `list_37` tinyint NOT NULL DEFAULT '0',
  `list_38` tinyint NOT NULL DEFAULT '0',
  `list_39` tinyint NOT NULL DEFAULT '0',
  `list_40` tinyint NOT NULL DEFAULT '0',
  `profile_1` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_2` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_3` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_4` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_5` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_6` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_7` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_8` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_9` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_10` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_11` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_12` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_13` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_14` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_15` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_16` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_17` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_18` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_19` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `profile_20` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `test` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `wp_user_id` (`wp_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_newsletter_emails` (
  `id` int NOT NULL AUTO_INCREMENT,
  `language` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `subject` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `message` longtext COLLATE utf8mb4_unicode_520_ci,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` enum('new','sending','sent','paused','error') COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'new',
  `total` int NOT NULL DEFAULT '0',
  `last_id` int NOT NULL DEFAULT '0',
  `sent` int NOT NULL DEFAULT '0',
  `track` int NOT NULL DEFAULT '1',
  `list` int NOT NULL DEFAULT '0',
  `type` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `query` longtext COLLATE utf8mb4_unicode_520_ci,
  `editor` tinyint NOT NULL DEFAULT '0',
  `sex` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `theme` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `message_text` longtext COLLATE utf8mb4_unicode_520_ci,
  `preferences` longtext COLLATE utf8mb4_unicode_520_ci,
  `send_on` int NOT NULL DEFAULT '0',
  `token` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `options` longtext COLLATE utf8mb4_unicode_520_ci,
  `private` tinyint(1) NOT NULL DEFAULT '0',
  `click_count` int unsigned NOT NULL DEFAULT '0',
  `version` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `open_count` int unsigned NOT NULL DEFAULT '0',
  `unsub_count` int unsigned NOT NULL DEFAULT '0',
  `error_count` int unsigned NOT NULL DEFAULT '0',
  `stats_time` int unsigned NOT NULL DEFAULT '0',
  `updated` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_newsletter_logs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `status` int NOT NULL DEFAULT '0',
  `source` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `data` longtext COLLATE utf8mb4_unicode_520_ci,
  `created` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_newsletter_sent` (
  `email_id` int unsigned NOT NULL DEFAULT '0',
  `user_id` int unsigned NOT NULL DEFAULT '0',
  `status` tinyint unsigned NOT NULL DEFAULT '0',
  `open` tinyint unsigned NOT NULL DEFAULT '0',
  `time` int unsigned NOT NULL DEFAULT '0',
  `error` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `ip` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`email_id`,`user_id`),
  KEY `user_id` (`user_id`),
  KEY `email_id` (`email_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_newsletter_stats` (
  `id` int NOT NULL AUTO_INCREMENT,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_id` int NOT NULL DEFAULT '0',
  `email_id` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '0',
  `ip` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `email_id` (`email_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_newsletter_user_logs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL DEFAULT '0',
  `ip` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `source` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `data` longtext COLLATE utf8mb4_unicode_520_ci,
  `created` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_newsletter_user_meta` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL DEFAULT '0',
  `meta_key` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=8818 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=8308 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=1288 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=68 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=68 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=63 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_note_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `query` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `actioned_text` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonce_action` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `nonce_name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=12183 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_notes` (
  `note_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `locale` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `title` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content_data` longtext COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT '0',
  `layout` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `image` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  `icon` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_category_lookup` (
  `category_tree_id` bigint unsigned NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_customer_lookup` (
  `customer_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `first_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `postcode` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `city` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `state` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_addresses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `address_type` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `first_name` text COLLATE utf8mb4_unicode_520_ci,
  `last_name` text COLLATE utf8mb4_unicode_520_ci,
  `company` text COLLATE utf8mb4_unicode_520_ci,
  `address_1` text COLLATE utf8mb4_unicode_520_ci,
  `address_2` text COLLATE utf8mb4_unicode_520_ci,
  `city` text COLLATE utf8mb4_unicode_520_ci,
  `state` text COLLATE utf8mb4_unicode_520_ci,
  `postcode` text COLLATE utf8mb4_unicode_520_ci,
  `country` text COLLATE utf8mb4_unicode_520_ci,
  `email` varchar(320) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `phone` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_coupon_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `coupon_id` bigint NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_operational_data` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned DEFAULT NULL,
  `created_via` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `woocommerce_version` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_product_lookup` (
  `order_item_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `variation_id` bigint unsigned NOT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT '0',
  `product_gross_revenue` double NOT NULL DEFAULT '0',
  `coupon_amount` double NOT NULL DEFAULT '0',
  `tax_amount` double NOT NULL DEFAULT '0',
  `shipping_amount` double NOT NULL DEFAULT '0',
  `shipping_tax_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_stats` (
  `order_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int NOT NULL DEFAULT '0',
  `total_sales` double NOT NULL DEFAULT '0',
  `tax_total` double NOT NULL DEFAULT '0',
  `shipping_total` double NOT NULL DEFAULT '0',
  `net_total` double NOT NULL DEFAULT '0',
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `customer_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_tax_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT '0',
  `order_tax` double NOT NULL DEFAULT '0',
  `total_tax` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders` (
  `id` bigint unsigned NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `currency` varchar(10) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `billing_email` varchar(320) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint unsigned DEFAULT NULL,
  `payment_method` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `payment_method_title` text COLLATE utf8mb4_unicode_520_ci,
  `transaction_id` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `ip_address` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_520_ci,
  `customer_note` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned DEFAULT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_attributes_lookup` (
  `product_id` bigint NOT NULL,
  `product_or_parent_id` bigint NOT NULL,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `term_id` bigint NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_download_directories` (
  `url_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint NOT NULL,
  `sku` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `global_unique_id` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `virtual` tinyint(1) DEFAULT '0',
  `downloadable` tinyint(1) DEFAULT '0',
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT '0',
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'instock',
  `rating_count` bigint DEFAULT '0',
  `average_rating` decimal(3,2) DEFAULT '0.00',
  `total_sales` bigint DEFAULT '0',
  `tax_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'taxable',
  `tax_class` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_rate_limits` (
  `rate_limit_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `rate_limit_expiry` bigint unsigned NOT NULL,
  `rate_limit_remaining` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_reserved_stock` (
  `order_id` bigint NOT NULL,
  `product_id` bigint NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT '0',
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `delivery_url` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `secret` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `topic` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint NOT NULL,
  `failure_count` smallint NOT NULL DEFAULT '0',
  `pending_delivery` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `description` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `permissions` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_key` char(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_secret` char(43) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonces` longtext COLLATE utf8mb4_unicode_520_ci,
  `truncated_key` char(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_label` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `attribute_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_orderby` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_public` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL DEFAULT '0',
  `order_key` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_email` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `context` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `order_item_type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `order_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_expiry` bigint unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint unsigned NOT NULL,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `zone_id` (`zone_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint unsigned NOT NULL,
  `instance_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `method_order` bigint unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `zone_order` bigint unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint unsigned NOT NULL,
  `tax_rate_compound` int NOT NULL DEFAULT '0',
  `tax_rate_shipping` int NOT NULL DEFAULT '1',
  `tax_rate_order` bigint unsigned NOT NULL,
  `tax_rate_class` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("124", "woocommerce_cleanup_draft_orders", "complete", "2025-10-29 05:34:06", "2025-10-29 05:34:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761716046;s:18:\"\0*\0first_timestamp\";i:1749183317;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761716046;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-29 05:42:40", "2025-10-29 05:42:40", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("125", "woocommerce_cleanup_draft_orders", "complete", "2025-10-30 05:42:40", "2025-10-30 05:42:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761802960;s:18:\"\0*\0first_timestamp\";i:1749183317;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761802960;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-30 08:54:47", "2025-10-30 08:54:47", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("126", "woocommerce_cleanup_draft_orders", "complete", "2025-10-31 08:54:47", "2025-10-31 08:54:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761900887;s:18:\"\0*\0first_timestamp\";i:1749183317;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761900887;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-31 15:29:54", "2025-10-31 15:29:54", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("127", "woocommerce_cleanup_draft_orders", "complete", "2025-11-01 15:29:54", "2025-11-01 15:29:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762010994;s:18:\"\0*\0first_timestamp\";i:1749183317;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762010994;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-01 16:04:09", "2025-11-01 16:04:09", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("128", "woocommerce_cleanup_draft_orders", "complete", "2025-11-02 16:04:09", "2025-11-02 16:04:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762099449;s:18:\"\0*\0first_timestamp\";i:1749183317;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762099449;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-03 05:41:25", "2025-11-03 05:41:25", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("129", "woocommerce_cleanup_draft_orders", "complete", "2025-11-04 05:41:25", "2025-11-04 05:41:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762234885;s:18:\"\0*\0first_timestamp\";i:1749183317;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762234885;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-04 05:41:42", "2025-11-04 05:41:42", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("130", "woocommerce_cleanup_draft_orders", "complete", "2025-11-05 05:41:42", "2025-11-05 05:41:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762321302;s:18:\"\0*\0first_timestamp\";i:1749183317;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762321302;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-05 07:12:36", "2025-11-05 07:12:36", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("131", "woocommerce_cleanup_draft_orders", "complete", "2025-11-06 07:12:36", "2025-11-06 07:12:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762413156;s:18:\"\0*\0first_timestamp\";i:1749183317;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762413156;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-06 13:44:13", "2025-11-06 13:44:13", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("132", "woocommerce_cleanup_draft_orders", "complete", "2025-11-07 13:44:13", "2025-11-07 13:44:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762523053;s:18:\"\0*\0first_timestamp\";i:1749183317;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762523053;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-07 18:00:53", "2025-11-07 18:00:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("133", "woocommerce_cleanup_draft_orders", "complete", "2025-11-08 18:00:53", "2025-11-08 18:00:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762624853;s:18:\"\0*\0first_timestamp\";i:1749183317;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762624853;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-08 23:02:17", "2025-11-08 23:02:17", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("134", "woocommerce_cleanup_draft_orders", "complete", "2025-11-09 23:02:17", "2025-11-09 23:02:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762729337;s:18:\"\0*\0first_timestamp\";i:1749183317;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762729337;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-10 05:28:15", "2025-11-10 05:28:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("135", "woocommerce_cleanup_draft_orders", "complete", "2025-11-11 05:28:15", "2025-11-11 05:28:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762838895;s:18:\"\0*\0first_timestamp\";i:1749183317;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762838895;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-11 05:34:23", "2025-11-11 05:34:23", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("136", "woocommerce_cleanup_draft_orders", "complete", "2025-11-12 05:34:23", "2025-11-12 05:34:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1762925663;s:18:\"\0*\0first_timestamp\";i:1749183317;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1762925663;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-12 05:35:11", "2025-11-12 05:35:11", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("137", "woocommerce_cleanup_draft_orders", "complete", "2025-11-13 05:35:11", "2025-11-13 05:35:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763012111;s:18:\"\0*\0first_timestamp\";i:1749183317;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763012111;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-13 05:37:27", "2025-11-13 05:37:27", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("138", "woocommerce_cleanup_draft_orders", "complete", "2025-11-14 05:37:27", "2025-11-14 05:37:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763098647;s:18:\"\0*\0first_timestamp\";i:1749183317;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763098647;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-14 08:40:36", "2025-11-14 08:40:36", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("139", "woocommerce_cleanup_draft_orders", "complete", "2025-11-15 08:40:36", "2025-11-15 08:40:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763196036;s:18:\"\0*\0first_timestamp\";i:1749183317;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763196036;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-15 16:39:31", "2025-11-15 16:39:31", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("140", "woocommerce_cleanup_draft_orders", "complete", "2025-11-16 16:39:31", "2025-11-16 16:39:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763311171;s:18:\"\0*\0first_timestamp\";i:1749183317;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763311171;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-16 18:22:58", "2025-11-16 18:22:58", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("141", "woocommerce_cleanup_draft_orders", "complete", "2025-11-17 18:22:58", "2025-11-17 18:22:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763403778;s:18:\"\0*\0first_timestamp\";i:1749183317;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763403778;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-18 10:38:54", "2025-11-18 10:38:54", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("142", "woocommerce_cleanup_draft_orders", "complete", "2025-11-19 10:38:54", "2025-11-19 10:38:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763548734;s:18:\"\0*\0first_timestamp\";i:1749183317;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763548734;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-20 05:26:50", "2025-11-20 05:26:50", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("143", "woocommerce_cleanup_draft_orders", "complete", "2025-11-21 05:26:50", "2025-11-21 05:26:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763702810;s:18:\"\0*\0first_timestamp\";i:1749183317;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763702810;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-21 05:28:29", "2025-11-21 05:28:29", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("144", "woocommerce_cleanup_draft_orders", "complete", "2025-11-22 05:28:29", "2025-11-22 05:28:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763789309;s:18:\"\0*\0first_timestamp\";i:1749183317;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763789309;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-22 05:29:29", "2025-11-22 05:29:29", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("145", "woocommerce_cleanup_draft_orders", "complete", "2025-11-23 05:29:29", "2025-11-23 05:29:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763875769;s:18:\"\0*\0first_timestamp\";i:1749183317;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763875769;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-23 05:30:18", "2025-11-23 05:30:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("146", "woocommerce_cleanup_draft_orders", "complete", "2025-11-24 05:30:18", "2025-11-24 05:30:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763962218;s:18:\"\0*\0first_timestamp\";i:1749183317;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763962218;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-24 05:32:10", "2025-11-24 05:32:10", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("147", "woocommerce_cleanup_draft_orders", "complete", "2025-11-25 05:32:10", "2025-11-25 05:32:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764048730;s:18:\"\0*\0first_timestamp\";i:1749183317;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764048730;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-25 05:35:39", "2025-11-25 05:35:39", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("148", "woocommerce_cleanup_draft_orders", "complete", "2025-11-26 05:35:39", "2025-11-26 05:35:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764135339;s:18:\"\0*\0first_timestamp\";i:1749183317;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764135339;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-26 11:10:56", "2025-11-26 11:10:56", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("149", "woocommerce_cleanup_draft_orders", "complete", "2025-11-27 11:10:56", "2025-11-27 11:10:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764241856;s:18:\"\0*\0first_timestamp\";i:1749183317;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764241856;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-11-28 05:27:21", "2025-11-28 05:27:21", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("150", "woocommerce_cleanup_draft_orders", "pending", "2025-11-29 05:27:21", "2025-11-29 05:27:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764394041;s:18:\"\0*\0first_timestamp\";i:1749183317;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764394041;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "wc_delete_related_product_transients_group");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("337", "124", "action created", "2025-10-28 05:34:06", "2025-10-28 05:34:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("338", "124", "action started via WP Cron", "2025-10-29 05:42:39", "2025-10-29 05:42:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("339", "124", "action complete via WP Cron", "2025-10-29 05:42:40", "2025-10-29 05:42:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("340", "125", "action created", "2025-10-29 05:42:40", "2025-10-29 05:42:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("341", "125", "action started via WP Cron", "2025-10-30 08:54:47", "2025-10-30 08:54:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("342", "125", "action complete via WP Cron", "2025-10-30 08:54:47", "2025-10-30 08:54:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("343", "126", "action created", "2025-10-30 08:54:47", "2025-10-30 08:54:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("344", "126", "action started via WP Cron", "2025-10-31 15:29:54", "2025-10-31 15:29:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("345", "126", "action complete via WP Cron", "2025-10-31 15:29:54", "2025-10-31 15:29:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("346", "127", "action created", "2025-10-31 15:29:54", "2025-10-31 15:29:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("347", "127", "action started via WP Cron", "2025-11-01 16:04:09", "2025-11-01 16:04:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("348", "127", "action complete via WP Cron", "2025-11-01 16:04:09", "2025-11-01 16:04:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("349", "128", "action created", "2025-11-01 16:04:09", "2025-11-01 16:04:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("350", "128", "action started via WP Cron", "2025-11-03 05:41:25", "2025-11-03 05:41:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("351", "128", "action complete via WP Cron", "2025-11-03 05:41:25", "2025-11-03 05:41:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("352", "129", "action created", "2025-11-03 05:41:25", "2025-11-03 05:41:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("353", "129", "action started via WP Cron", "2025-11-04 05:41:42", "2025-11-04 05:41:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("354", "129", "action complete via WP Cron", "2025-11-04 05:41:42", "2025-11-04 05:41:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("355", "130", "action created", "2025-11-04 05:41:42", "2025-11-04 05:41:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("356", "130", "action started via WP Cron", "2025-11-05 07:12:36", "2025-11-05 07:12:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("357", "130", "action complete via WP Cron", "2025-11-05 07:12:36", "2025-11-05 07:12:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("358", "131", "action created", "2025-11-05 07:12:36", "2025-11-05 07:12:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("359", "131", "action started via WP Cron", "2025-11-06 13:44:13", "2025-11-06 13:44:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("360", "131", "action complete via WP Cron", "2025-11-06 13:44:13", "2025-11-06 13:44:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("361", "132", "action created", "2025-11-06 13:44:13", "2025-11-06 13:44:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("362", "132", "action started via WP Cron", "2025-11-07 18:00:53", "2025-11-07 18:00:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("363", "132", "action complete via WP Cron", "2025-11-07 18:00:53", "2025-11-07 18:00:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("364", "133", "action created", "2025-11-07 18:00:53", "2025-11-07 18:00:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("365", "133", "action started via WP Cron", "2025-11-08 23:02:17", "2025-11-08 23:02:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("366", "133", "action complete via WP Cron", "2025-11-08 23:02:17", "2025-11-08 23:02:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("367", "134", "action created", "2025-11-08 23:02:17", "2025-11-08 23:02:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("368", "134", "action started via WP Cron", "2025-11-10 05:28:15", "2025-11-10 05:28:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("369", "134", "action complete via WP Cron", "2025-11-10 05:28:15", "2025-11-10 05:28:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("370", "135", "action created", "2025-11-10 05:28:15", "2025-11-10 05:28:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("371", "135", "action started via WP Cron", "2025-11-11 05:34:23", "2025-11-11 05:34:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("372", "135", "action complete via WP Cron", "2025-11-11 05:34:23", "2025-11-11 05:34:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("373", "136", "action created", "2025-11-11 05:34:23", "2025-11-11 05:34:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("374", "136", "action started via WP Cron", "2025-11-12 05:35:11", "2025-11-12 05:35:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("375", "136", "action complete via WP Cron", "2025-11-12 05:35:11", "2025-11-12 05:35:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("376", "137", "action created", "2025-11-12 05:35:11", "2025-11-12 05:35:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("377", "137", "action started via WP Cron", "2025-11-13 05:37:27", "2025-11-13 05:37:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("378", "137", "action complete via WP Cron", "2025-11-13 05:37:27", "2025-11-13 05:37:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("379", "138", "action created", "2025-11-13 05:37:27", "2025-11-13 05:37:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("380", "138", "action started via WP Cron", "2025-11-14 08:40:36", "2025-11-14 08:40:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("381", "138", "action complete via WP Cron", "2025-11-14 08:40:36", "2025-11-14 08:40:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("382", "139", "action created", "2025-11-14 08:40:36", "2025-11-14 08:40:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("383", "139", "action started via WP Cron", "2025-11-15 16:39:31", "2025-11-15 16:39:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("384", "139", "action complete via WP Cron", "2025-11-15 16:39:31", "2025-11-15 16:39:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("385", "140", "action created", "2025-11-15 16:39:31", "2025-11-15 16:39:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("386", "140", "action started via WP Cron", "2025-11-16 18:22:58", "2025-11-16 18:22:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("387", "140", "action complete via WP Cron", "2025-11-16 18:22:58", "2025-11-16 18:22:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("388", "141", "action created", "2025-11-16 18:22:58", "2025-11-16 18:22:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("389", "141", "action started via WP Cron", "2025-11-18 10:38:54", "2025-11-18 10:38:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("390", "141", "action complete via WP Cron", "2025-11-18 10:38:54", "2025-11-18 10:38:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("391", "142", "action created", "2025-11-18 10:38:54", "2025-11-18 10:38:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("392", "142", "action started via WP Cron", "2025-11-20 05:26:50", "2025-11-20 05:26:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("393", "142", "action complete via WP Cron", "2025-11-20 05:26:50", "2025-11-20 05:26:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("394", "143", "action created", "2025-11-20 05:26:50", "2025-11-20 05:26:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("395", "143", "action started via WP Cron", "2025-11-21 05:28:28", "2025-11-21 05:28:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("396", "143", "action complete via WP Cron", "2025-11-21 05:28:29", "2025-11-21 05:28:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("397", "144", "action created", "2025-11-21 05:28:29", "2025-11-21 05:28:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("398", "144", "action started via WP Cron", "2025-11-22 05:29:29", "2025-11-22 05:29:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("399", "144", "action complete via WP Cron", "2025-11-22 05:29:29", "2025-11-22 05:29:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("400", "145", "action created", "2025-11-22 05:29:29", "2025-11-22 05:29:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("401", "145", "action started via WP Cron", "2025-11-23 05:30:18", "2025-11-23 05:30:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("402", "145", "action complete via WP Cron", "2025-11-23 05:30:18", "2025-11-23 05:30:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("403", "146", "action created", "2025-11-23 05:30:18", "2025-11-23 05:30:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("404", "146", "action started via WP Cron", "2025-11-24 05:32:10", "2025-11-24 05:32:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("405", "146", "action complete via WP Cron", "2025-11-24 05:32:10", "2025-11-24 05:32:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("406", "147", "action created", "2025-11-24 05:32:10", "2025-11-24 05:32:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("407", "147", "action started via WP Cron", "2025-11-25 05:35:39", "2025-11-25 05:35:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("408", "147", "action complete via WP Cron", "2025-11-25 05:35:39", "2025-11-25 05:35:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("409", "148", "action created", "2025-11-25 05:35:39", "2025-11-25 05:35:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("410", "148", "action started via WP Cron", "2025-11-26 11:10:56", "2025-11-26 11:10:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("411", "148", "action complete via WP Cron", "2025-11-26 11:10:56", "2025-11-26 11:10:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("412", "149", "action created", "2025-11-26 11:10:56", "2025-11-26 11:10:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("413", "149", "action started via WP Cron", "2025-11-28 05:27:21", "2025-11-28 05:27:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("414", "149", "action complete via WP Cron", "2025-11-28 05:27:21", "2025-11-28 05:27:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("415", "150", "action created", "2025-11-28 05:27:21", "2025-11-28 05:27:21");

/* INSERT TABLE DATA: wp_commentmeta */
INSERT INTO `wp_commentmeta` VALUES("1", "2", "rating", "");
INSERT INTO `wp_commentmeta` VALUES("2", "2", "address", "");
INSERT INTO `wp_commentmeta` VALUES("3", "3", "rating", "");
INSERT INTO `wp_commentmeta` VALUES("4", "3", "address", "");
INSERT INTO `wp_commentmeta` VALUES("5", "4", "rating", "");
INSERT INTO `wp_commentmeta` VALUES("6", "4", "address", "");
INSERT INTO `wp_commentmeta` VALUES("7", "5", "rating", "5");
INSERT INTO `wp_commentmeta` VALUES("8", "5", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("9", "5", "rating", "5");
INSERT INTO `wp_commentmeta` VALUES("10", "5", "address", "");
INSERT INTO `wp_commentmeta` VALUES("11", "6", "rating", "5");
INSERT INTO `wp_commentmeta` VALUES("12", "6", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("13", "6", "rating", "5");
INSERT INTO `wp_commentmeta` VALUES("14", "6", "address", "");
INSERT INTO `wp_commentmeta` VALUES("15", "7", "rating", "5");
INSERT INTO `wp_commentmeta` VALUES("16", "7", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("17", "7", "rating", "5");
INSERT INTO `wp_commentmeta` VALUES("18", "7", "address", "");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("1", "1", "A WordPress Commenter", "wapuu@wordpress.example", "https://wordpress.org/", "", "2025-06-06 04:06:45", "2025-06-06 04:06:45", "Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://gravatar.com/\">Gravatar</a>.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("2", "69", "Michael Brian", "finanzia@cmssuperheroes.com", "https://demo.cmssuperheroes.com/themeforest/finanzia", "::1", "2024-10-30 08:18:42", "2024-10-30 08:18:42", "The example about the mattress sizing page you mentioned in the last WBF can be a perfect example of new keywords and content, and broadening the funnel as well. I can only imagine the sale numbers if that was the site of a mattress selling company.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("3", "69", "Mike Dooley", "MikeDooley@mail.com", "http://MikeDooley.com", "::1", "2024-10-30 08:19:25", "2024-10-30 08:19:25", "Sizing page you mentioned in the last WBF can be a perfect example of new keywords and content, and broadening the funnel as well. I can only imagine the sale numbers if that was the site of a mattress selling company.", "0", "1", "", "comment", "2", "0");
INSERT INTO `wp_comments` VALUES("4", "69", "Maria Andaloro", "MariaAndaloro@mail.com", "http://MariaAndaloro.com", "::1", "2024-10-30 08:20:05", "2024-10-30 08:20:05", "The example about the mattress sizing page you mentioned in the last WBF can be a perfect example of new keywords and content, and broadening the funnel as well. I can only imagine the sale numbers if that was the site of a mattress selling company.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("5", "587", "Michael Brian", "MichaelBrian@mail.com", "", "::1", "2024-12-05 15:00:42", "2024-12-05 15:00:42", "The example about the mattress sizing page you mentioned in the last WBF can be a perfect example of new keywords and content, and broadening the funnel as well. I can only imagine the sale numbers if that was the site of a mattress selling company.", "0", "1", "", "review", "0", "0");
INSERT INTO `wp_comments` VALUES("6", "587", "Mike Dooley", "MikeDooley@mail.com", "", "::1", "2024-12-05 15:01:32", "2024-12-05 15:01:32", "Sizing page you mentioned in the last WBF can be a perfect example of new keywords and content, and broadening the funnel as well. I can only imagine the sale numbers if that was the site of a mattress selling company.", "0", "1", "", "review", "0", "0");
INSERT INTO `wp_comments` VALUES("7", "587", "Michael Brian", "finanzia@cmssuperheroes.com", "https://demo.cmssuperheroes.com/themeforest/finanzia", "::1", "2024-12-10 03:48:58", "2024-12-10 03:48:58", "The example about the mattress sizing page you mentioned in the last WBF can be a perfect example of new keywords and content, and broadening the funnel as well. I can only imagine the sale numbers if that was the site of a mattress selling company.", "0", "1", "", "review", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "20251128_atlascapitalsolutionspteltd", "2d7cc4ec8e3b45013642_20251128070425", "21", "2025-11-28 07:04:37", "MainAdmin", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-11-28 07:04:25\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:6:\"8.0.36\";s:10:\"VersionPHP\";s:6:\"8.2.29\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:36:\"20251128_atlascapitalsolutionspteltd\";s:4:\"Hash\";s:35:\"2d7cc4ec8e3b45013642_20251128070425\";s:8:\"NameHash\";s:72:\"20251128_atlascapitalsolutionspteltd_2d7cc4ec8e3b45013642_20251128070425\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:82:\"20251128_atlascapitalsolutionspteltd_2d7cc4ec8e3b45013642_20251128070425_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.0\";s:6:\"WPUser\";s:9:\"MainAdmin\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:84:\"20251128_atlascapitalsolutionspteltd_2d7cc4ec8e3b45013642_20251128070425_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:40:\"/home3/tessaccount/public_html/atlascapt\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2506;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:16536;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-11-28 07:04:25\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:6:\"8.0.36\";s:10:\"VersionPHP\";s:6:\"8.2.29\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:36:\"20251128_atlascapitalsolutionspteltd\";s:4:\"Hash\";s:35:\"2d7cc4ec8e3b45013642_20251128070425\";s:8:\"NameHash\";s:72:\"20251128_atlascapitalsolutionspteltd_2d7cc4ec8e3b45013642_20251128070425\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:90:\"20251128_atlascapitalsolutionspteltd_2d7cc4ec8e3b45013642_20251128070425_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:54:\"/home3/tessaccount/public_html/atlascapt/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:85:\"20251128_atlascapitalsolutionspteltd_2d7cc4ec8e3b45013642_20251128070425_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:158:\"/home3/tessaccount/public_html/atlascapt/wp-content/backups-dup-lite/tmp/20251128_atlascapitalsolutionspteltd_2d7cc4ec8e3b45013642_20251128070425_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:49:\"/home3/tessaccount/public_html/atlascapt/wp-admin\";i:1;s:52:\"/home3/tessaccount/public_html/atlascapt/wp-includes\";i:2;s:61:\"/home3/tessaccount/public_html/atlascapt/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:40:\"/home3/tessaccount/public_html/atlascapt\";i:1;s:40:\"/home3/tessaccount/public_html/atlascapt\";i:2;s:51:\"/home3/tessaccount/public_html/atlascapt/wp-content\";i:3;s:59:\"/home3/tessaccount/public_html/atlascapt/wp-content/uploads\";i:4;s:59:\"/home3/tessaccount/public_html/atlascapt/wp-content/plugins\";i:5;s:62:\"/home3/tessaccount/public_html/atlascapt/wp-content/mu-plugins\";i:6;s:58:\"/home3/tessaccount/public_html/atlascapt/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:72:\"/home3/tessaccount/public_html/atlascapt/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "cron", "a:32:{i:1764313481;a:2:{s:10:\"newsletter\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"newsletter\";s:4:\"args\";a:0:{}s:8:\"interval\";i:300;}}s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1764313639;a:1:{s:29:\"rsssl_every_five_minutes_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:18:\"rsssl_five_minutes\";s:4:\"args\";a:0:{}s:8:\"interval\";i:300;}}}i:1764313658;a:1:{s:28:\"rsssl_every_three_hours_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:23:\"rsssl_every_three_hours\";s:4:\"args\";a:0:{}s:8:\"interval\";i:10800;}}}i:1764314110;a:2:{s:24:\"woocommerce_cleanup_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"woocommerce_cleanup_rate_limits\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764314114;a:2:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1764314121;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1764315281;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1764316881;a:1:{s:32:\"woocommerce_cancel_unpaid_orders\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1764324910;a:1:{s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1764346014;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1764346514;a:1:{s:45:\"woocommerce_marketplace_cron_fetch_promotions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1764351404;a:1:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1764353204;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1764374400;a:1:{s:27:\"woocommerce_scheduled_sales\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764389205;a:2:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764389214;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764389217;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764389258;a:1:{s:20:\"rsssl_every_day_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"rsssl_daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764389638;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764389710;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764389714;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764389720;a:2:{s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:33:\"woocommerce_cleanup_personal_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764396853;a:1:{s:17:\"newsletter_update\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764480464;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1764597600;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1764734858;a:1:{s:22:\"rsssl_every_month_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:13:\"rsssl_monthly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:2592000;}}}i:1764735370;a:1:{s:25:\"woocommerce_geoip_updater\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"fifteendays\";s:4:\"args\";a:0:{}s:8:\"interval\";i:1296000;}}}i:1764895559;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1764907647;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1764907658;a:1:{s:21:\"rsssl_every_week_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:12:\"rsssl_weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1764911653;a:1:{s:16:\"newsletter_clean\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wp_options` VALUES("2", "siteurl", "https://atlascapt.warelytest.com", "on");
INSERT INTO `wp_options` VALUES("3", "home", "https://atlascapt.warelytest.com", "on");
INSERT INTO `wp_options` VALUES("4", "blogname", "Atlas Capital Solutions Pte. Ltd.", "on");
INSERT INTO `wp_options` VALUES("5", "blogdescription", "", "on");
INSERT INTO `wp_options` VALUES("6", "users_can_register", "0", "on");
INSERT INTO `wp_options` VALUES("7", "admin_email", "selvam@warelycorp.com", "on");
INSERT INTO `wp_options` VALUES("8", "start_of_week", "1", "on");
INSERT INTO `wp_options` VALUES("9", "use_balanceTags", "0", "on");
INSERT INTO `wp_options` VALUES("10", "use_smilies", "1", "on");
INSERT INTO `wp_options` VALUES("11", "require_name_email", "1", "on");
INSERT INTO `wp_options` VALUES("12", "comments_notify", "1", "on");
INSERT INTO `wp_options` VALUES("13", "posts_per_rss", "10", "on");
INSERT INTO `wp_options` VALUES("14", "rss_use_excerpt", "0", "on");
INSERT INTO `wp_options` VALUES("15", "mailserver_url", "mail.example.com", "on");
INSERT INTO `wp_options` VALUES("16", "mailserver_login", "login@example.com", "on");
INSERT INTO `wp_options` VALUES("17", "mailserver_pass", "", "on");
INSERT INTO `wp_options` VALUES("18", "mailserver_port", "110", "on");
INSERT INTO `wp_options` VALUES("19", "default_category", "1", "on");
INSERT INTO `wp_options` VALUES("20", "default_comment_status", "open", "on");
INSERT INTO `wp_options` VALUES("21", "default_ping_status", "open", "on");
INSERT INTO `wp_options` VALUES("22", "default_pingback_flag", "1", "on");
INSERT INTO `wp_options` VALUES("23", "posts_per_page", "10", "on");
INSERT INTO `wp_options` VALUES("24", "date_format", "F j, Y", "on");
INSERT INTO `wp_options` VALUES("25", "time_format", "g:i a", "on");
INSERT INTO `wp_options` VALUES("26", "links_updated_date_format", "F j, Y g:i a", "on");
INSERT INTO `wp_options` VALUES("27", "comment_moderation", "0", "on");
INSERT INTO `wp_options` VALUES("28", "moderation_notify", "1", "on");
INSERT INTO `wp_options` VALUES("29", "permalink_structure", "/%postname%/", "on");
INSERT INTO `wp_options` VALUES("30", "rewrite_rules", "a:511:{s:10:\"service/?$\";s:31:\"index.php?post_type=cms-service\";s:40:\"service/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?post_type=cms-service&feed=$matches[1]\";s:35:\"service/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?post_type=cms-service&feed=$matches[1]\";s:27:\"service/page/([0-9]{1,})/?$\";s:49:\"index.php?post_type=cms-service&paged=$matches[1]\";s:8:\"story/?$\";s:32:\"index.php?post_type=cms-industry\";s:38:\"story/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?post_type=cms-industry&feed=$matches[1]\";s:33:\"story/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?post_type=cms-industry&feed=$matches[1]\";s:25:\"story/page/([0-9]{1,})/?$\";s:50:\"index.php?post_type=cms-industry&paged=$matches[1]\";s:8:\"cases/?$\";s:28:\"index.php?post_type=cms-case\";s:38:\"cases/feed/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?post_type=cms-case&feed=$matches[1]\";s:33:\"cases/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?post_type=cms-case&feed=$matches[1]\";s:25:\"cases/page/([0-9]{1,})/?$\";s:46:\"index.php?post_type=cms-case&paged=$matches[1]\";s:9:\"career/?$\";s:30:\"index.php?post_type=cms-career\";s:39:\"career/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?post_type=cms-career&feed=$matches[1]\";s:34:\"career/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?post_type=cms-career&feed=$matches[1]\";s:26:\"career/page/([0-9]{1,})/?$\";s:48:\"index.php?post_type=cms-career&paged=$matches[1]\";s:14:\"cms-sidenav/?$\";s:31:\"index.php?post_type=cms-sidenav\";s:44:\"cms-sidenav/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?post_type=cms-sidenav&feed=$matches[1]\";s:39:\"cms-sidenav/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?post_type=cms-sidenav&feed=$matches[1]\";s:31:\"cms-sidenav/page/([0-9]{1,})/?$\";s:49:\"index.php?post_type=cms-sidenav&paged=$matches[1]\";s:17:\"cms-header-top/?$\";s:34:\"index.php?post_type=cms-header-top\";s:47:\"cms-header-top/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?post_type=cms-header-top&feed=$matches[1]\";s:42:\"cms-header-top/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?post_type=cms-header-top&feed=$matches[1]\";s:34:\"cms-header-top/page/([0-9]{1,})/?$\";s:52:\"index.php?post_type=cms-header-top&paged=$matches[1]\";s:13:\"cms-footer/?$\";s:30:\"index.php?post_type=cms-footer\";s:43:\"cms-footer/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?post_type=cms-footer&feed=$matches[1]\";s:38:\"cms-footer/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?post_type=cms-footer&feed=$matches[1]\";s:30:\"cms-footer/page/([0-9]{1,})/?$\";s:48:\"index.php?post_type=cms-footer&paged=$matches[1]\";s:12:\"cms-popup/?$\";s:29:\"index.php?post_type=cms-popup\";s:42:\"cms-popup/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=cms-popup&feed=$matches[1]\";s:37:\"cms-popup/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=cms-popup&feed=$matches[1]\";s:29:\"cms-popup/page/([0-9]{1,})/?$\";s:47:\"index.php?post_type=cms-popup&paged=$matches[1]\";s:16:\"cms-mega-menu/?$\";s:33:\"index.php?post_type=cms-mega-menu\";s:46:\"cms-mega-menu/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_type=cms-mega-menu&feed=$matches[1]\";s:41:\"cms-mega-menu/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_type=cms-mega-menu&feed=$matches[1]\";s:33:\"cms-mega-menu/page/([0-9]{1,})/?$\";s:51:\"index.php?post_type=cms-mega-menu&paged=$matches[1]\";s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:21:\"^wc/file/transient/?$\";s:33:\"index.php?wc-transient-file-name=\";s:24:\"^wc/file/transient/(.+)$\";s:44:\"index.php?wc-transient-file-name=$matches[1]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:7:\"shop/?$\";s:27:\"index.php?post_type=product\";s:37:\"shop/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:32:\"shop/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:24:\"shop/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:43:\"category/(.+?)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?category_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:40:\"tag/([^/]+)/wc/file/transient(/(.*))?/?$\";s:55:\"index.php?tag=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:35:\"service/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"service/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"service/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"service/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"service/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"service/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"service/([^/]+)/embed/?$\";s:44:\"index.php?cms-service=$matches[1]&embed=true\";s:28:\"service/([^/]+)/trackback/?$\";s:38:\"index.php?cms-service=$matches[1]&tb=1\";s:48:\"service/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?cms-service=$matches[1]&feed=$matches[2]\";s:43:\"service/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?cms-service=$matches[1]&feed=$matches[2]\";s:36:\"service/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?cms-service=$matches[1]&paged=$matches[2]\";s:43:\"service/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?cms-service=$matches[1]&cpage=$matches[2]\";s:44:\"service/([^/]+)/wc/file/transient(/(.*))?/?$\";s:63:\"index.php?cms-service=$matches[1]&wc/file/transient=$matches[3]\";s:33:\"service/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?cms-service=$matches[1]&wc-api=$matches[3]\";s:50:\"service/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:61:\"service/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"service/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"service/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:32:\"service/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?cms-service=$matches[1]&page=$matches[2]\";s:24:\"service/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"service/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"service/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"service/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"service/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"service/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"story/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"story/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"story/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"story/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"story/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"story/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"story/([^/]+)/embed/?$\";s:45:\"index.php?cms-industry=$matches[1]&embed=true\";s:26:\"story/([^/]+)/trackback/?$\";s:39:\"index.php?cms-industry=$matches[1]&tb=1\";s:46:\"story/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?cms-industry=$matches[1]&feed=$matches[2]\";s:41:\"story/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?cms-industry=$matches[1]&feed=$matches[2]\";s:34:\"story/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?cms-industry=$matches[1]&paged=$matches[2]\";s:41:\"story/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?cms-industry=$matches[1]&cpage=$matches[2]\";s:42:\"story/([^/]+)/wc/file/transient(/(.*))?/?$\";s:64:\"index.php?cms-industry=$matches[1]&wc/file/transient=$matches[3]\";s:31:\"story/([^/]+)/wc-api(/(.*))?/?$\";s:53:\"index.php?cms-industry=$matches[1]&wc-api=$matches[3]\";s:48:\"story/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:59:\"story/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:37:\"story/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:48:\"story/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:30:\"story/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?cms-industry=$matches[1]&page=$matches[2]\";s:22:\"story/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:32:\"story/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:52:\"story/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"story/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"story/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:28:\"story/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"cases/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"cases/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"cases/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"cases/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"cases/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"cases/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"cases/([^/]+)/embed/?$\";s:41:\"index.php?cms-case=$matches[1]&embed=true\";s:26:\"cases/([^/]+)/trackback/?$\";s:35:\"index.php?cms-case=$matches[1]&tb=1\";s:46:\"cases/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?cms-case=$matches[1]&feed=$matches[2]\";s:41:\"cases/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?cms-case=$matches[1]&feed=$matches[2]\";s:34:\"cases/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?cms-case=$matches[1]&paged=$matches[2]\";s:41:\"cases/([^/]+)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?cms-case=$matches[1]&cpage=$matches[2]\";s:42:\"cases/([^/]+)/wc/file/transient(/(.*))?/?$\";s:60:\"index.php?cms-case=$matches[1]&wc/file/transient=$matches[3]\";s:31:\"cases/([^/]+)/wc-api(/(.*))?/?$\";s:49:\"index.php?cms-case=$matches[1]&wc-api=$matches[3]\";s:48:\"cases/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:59:\"cases/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:37:\"cases/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:48:\"cases/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:30:\"cases/([^/]+)(?:/([0-9]+))?/?$\";s:47:\"index.php?cms-case=$matches[1]&page=$matches[2]\";s:22:\"cases/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:32:\"cases/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:52:\"cases/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"cases/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"cases/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:28:\"cases/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"career/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"career/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"career/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"career/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"career/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"career/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:23:\"career/([^/]+)/embed/?$\";s:43:\"index.php?cms-career=$matches[1]&embed=true\";s:27:\"career/([^/]+)/trackback/?$\";s:37:\"index.php?cms-career=$matches[1]&tb=1\";s:47:\"career/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?cms-career=$matches[1]&feed=$matches[2]\";s:42:\"career/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?cms-career=$matches[1]&feed=$matches[2]\";s:35:\"career/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?cms-career=$matches[1]&paged=$matches[2]\";s:42:\"career/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?cms-career=$matches[1]&cpage=$matches[2]\";s:43:\"career/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?cms-career=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"career/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?cms-career=$matches[1]&wc-api=$matches[3]\";s:49:\"career/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:60:\"career/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:38:\"career/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:49:\"career/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:31:\"career/([^/]+)(?:/([0-9]+))?/?$\";s:49:\"index.php?cms-career=$matches[1]&page=$matches[2]\";s:23:\"career/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:33:\"career/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:53:\"career/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"career/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"career/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:29:\"career/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:39:\"cms-sidenav/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"cms-sidenav/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"cms-sidenav/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"cms-sidenav/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"cms-sidenav/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"cms-sidenav/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"cms-sidenav/([^/]+)/embed/?$\";s:44:\"index.php?cms-sidenav=$matches[1]&embed=true\";s:32:\"cms-sidenav/([^/]+)/trackback/?$\";s:38:\"index.php?cms-sidenav=$matches[1]&tb=1\";s:52:\"cms-sidenav/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?cms-sidenav=$matches[1]&feed=$matches[2]\";s:47:\"cms-sidenav/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?cms-sidenav=$matches[1]&feed=$matches[2]\";s:40:\"cms-sidenav/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?cms-sidenav=$matches[1]&paged=$matches[2]\";s:47:\"cms-sidenav/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?cms-sidenav=$matches[1]&cpage=$matches[2]\";s:48:\"cms-sidenav/([^/]+)/wc/file/transient(/(.*))?/?$\";s:63:\"index.php?cms-sidenav=$matches[1]&wc/file/transient=$matches[3]\";s:37:\"cms-sidenav/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?cms-sidenav=$matches[1]&wc-api=$matches[3]\";s:54:\"cms-sidenav/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:65:\"cms-sidenav/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:43:\"cms-sidenav/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:54:\"cms-sidenav/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:36:\"cms-sidenav/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?cms-sidenav=$matches[1]&page=$matches[2]\";s:28:\"cms-sidenav/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"cms-sidenav/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"cms-sidenav/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"cms-sidenav/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"cms-sidenav/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"cms-sidenav/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:42:\"cms-header-top/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"cms-header-top/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"cms-header-top/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"cms-header-top/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"cms-header-top/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"cms-header-top/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"cms-header-top/([^/]+)/embed/?$\";s:47:\"index.php?cms-header-top=$matches[1]&embed=true\";s:35:\"cms-header-top/([^/]+)/trackback/?$\";s:41:\"index.php?cms-header-top=$matches[1]&tb=1\";s:55:\"cms-header-top/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?cms-header-top=$matches[1]&feed=$matches[2]\";s:50:\"cms-header-top/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?cms-header-top=$matches[1]&feed=$matches[2]\";s:43:\"cms-header-top/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?cms-header-top=$matches[1]&paged=$matches[2]\";s:50:\"cms-header-top/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?cms-header-top=$matches[1]&cpage=$matches[2]\";s:51:\"cms-header-top/([^/]+)/wc/file/transient(/(.*))?/?$\";s:66:\"index.php?cms-header-top=$matches[1]&wc/file/transient=$matches[3]\";s:40:\"cms-header-top/([^/]+)/wc-api(/(.*))?/?$\";s:55:\"index.php?cms-header-top=$matches[1]&wc-api=$matches[3]\";s:57:\"cms-header-top/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:68:\"cms-header-top/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:46:\"cms-header-top/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:57:\"cms-header-top/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:39:\"cms-header-top/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?cms-header-top=$matches[1]&page=$matches[2]\";s:31:\"cms-header-top/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"cms-header-top/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"cms-header-top/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"cms-header-top/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"cms-header-top/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"cms-header-top/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:38:\"cms-footer/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"cms-footer/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"cms-footer/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"cms-footer/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"cms-footer/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"cms-footer/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"cms-footer/([^/]+)/embed/?$\";s:43:\"index.php?cms-footer=$matches[1]&embed=true\";s:31:\"cms-footer/([^/]+)/trackback/?$\";s:37:\"index.php?cms-footer=$matches[1]&tb=1\";s:51:\"cms-footer/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?cms-footer=$matches[1]&feed=$matches[2]\";s:46:\"cms-footer/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?cms-footer=$matches[1]&feed=$matches[2]\";s:39:\"cms-footer/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?cms-footer=$matches[1]&paged=$matches[2]\";s:46:\"cms-footer/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?cms-footer=$matches[1]&cpage=$matches[2]\";s:47:\"cms-footer/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?cms-footer=$matches[1]&wc/file/transient=$matches[3]\";s:36:\"cms-footer/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?cms-footer=$matches[1]&wc-api=$matches[3]\";s:53:\"cms-footer/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:64:\"cms-footer/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:42:\"cms-footer/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:53:\"cms-footer/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:35:\"cms-footer/([^/]+)(?:/([0-9]+))?/?$\";s:49:\"index.php?cms-footer=$matches[1]&page=$matches[2]\";s:27:\"cms-footer/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"cms-footer/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"cms-footer/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"cms-footer/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"cms-footer/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"cms-footer/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:37:\"cms-popup/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"cms-popup/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"cms-popup/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"cms-popup/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"cms-popup/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"cms-popup/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"cms-popup/([^/]+)/embed/?$\";s:42:\"index.php?cms-popup=$matches[1]&embed=true\";s:30:\"cms-popup/([^/]+)/trackback/?$\";s:36:\"index.php?cms-popup=$matches[1]&tb=1\";s:50:\"cms-popup/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?cms-popup=$matches[1]&feed=$matches[2]\";s:45:\"cms-popup/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?cms-popup=$matches[1]&feed=$matches[2]\";s:38:\"cms-popup/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?cms-popup=$matches[1]&paged=$matches[2]\";s:45:\"cms-popup/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?cms-popup=$matches[1]&cpage=$matches[2]\";s:46:\"cms-popup/([^/]+)/wc/file/transient(/(.*))?/?$\";s:61:\"index.php?cms-popup=$matches[1]&wc/file/transient=$matches[3]\";s:35:\"cms-popup/([^/]+)/wc-api(/(.*))?/?$\";s:50:\"index.php?cms-popup=$matches[1]&wc-api=$matches[3]\";s:52:\"cms-popup/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:63:\"cms-popup/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:41:\"cms-popup/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:52:\"cms-popup/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:34:\"cms-popup/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?cms-popup=$matches[1]&page=$matches[2]\";s:26:\"cms-popup/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"cms-popup/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"cms-popup/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"cms-popup/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"cms-popup/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"cms-popup/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:57:\"service-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?service-category=$matches[1]&feed=$matches[2]\";s:52:\"service-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?service-category=$matches[1]&feed=$matches[2]\";s:33:\"service-category/([^/]+)/embed/?$\";s:49:\"index.php?service-category=$matches[1]&embed=true\";s:45:\"service-category/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?service-category=$matches[1]&paged=$matches[2]\";s:27:\"service-category/([^/]+)/?$\";s:38:\"index.php?service-category=$matches[1]\";s:52:\"service-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?service-tag=$matches[1]&feed=$matches[2]\";s:47:\"service-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?service-tag=$matches[1]&feed=$matches[2]\";s:28:\"service-tag/([^/]+)/embed/?$\";s:44:\"index.php?service-tag=$matches[1]&embed=true\";s:40:\"service-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?service-tag=$matches[1]&paged=$matches[2]\";s:22:\"service-tag/([^/]+)/?$\";s:33:\"index.php?service-tag=$matches[1]\";s:58:\"industry-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?industry-category=$matches[1]&feed=$matches[2]\";s:53:\"industry-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?industry-category=$matches[1]&feed=$matches[2]\";s:34:\"industry-category/([^/]+)/embed/?$\";s:50:\"index.php?industry-category=$matches[1]&embed=true\";s:46:\"industry-category/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?industry-category=$matches[1]&paged=$matches[2]\";s:28:\"industry-category/([^/]+)/?$\";s:39:\"index.php?industry-category=$matches[1]\";s:53:\"industry-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?industry-tag=$matches[1]&feed=$matches[2]\";s:48:\"industry-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?industry-tag=$matches[1]&feed=$matches[2]\";s:29:\"industry-tag/([^/]+)/embed/?$\";s:45:\"index.php?industry-tag=$matches[1]&embed=true\";s:41:\"industry-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?industry-tag=$matches[1]&paged=$matches[2]\";s:23:\"industry-tag/([^/]+)/?$\";s:34:\"index.php?industry-tag=$matches[1]\";s:54:\"case-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?case-category=$matches[1]&feed=$matches[2]\";s:49:\"case-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?case-category=$matches[1]&feed=$matches[2]\";s:30:\"case-category/([^/]+)/embed/?$\";s:46:\"index.php?case-category=$matches[1]&embed=true\";s:42:\"case-category/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?case-category=$matches[1]&paged=$matches[2]\";s:24:\"case-category/([^/]+)/?$\";s:35:\"index.php?case-category=$matches[1]\";s:49:\"case-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?case-tag=$matches[1]&feed=$matches[2]\";s:44:\"case-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?case-tag=$matches[1]&feed=$matches[2]\";s:25:\"case-tag/([^/]+)/embed/?$\";s:41:\"index.php?case-tag=$matches[1]&embed=true\";s:37:\"case-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?case-tag=$matches[1]&paged=$matches[2]\";s:19:\"case-tag/([^/]+)/?$\";s:30:\"index.php?case-tag=$matches[1]\";s:56:\"career-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?career-category=$matches[1]&feed=$matches[2]\";s:51:\"career-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?career-category=$matches[1]&feed=$matches[2]\";s:32:\"career-category/([^/]+)/embed/?$\";s:48:\"index.php?career-category=$matches[1]&embed=true\";s:44:\"career-category/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?career-category=$matches[1]&paged=$matches[2]\";s:26:\"career-category/([^/]+)/?$\";s:37:\"index.php?career-category=$matches[1]\";s:51:\"career-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?career-tag=$matches[1]&feed=$matches[2]\";s:46:\"career-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?career-tag=$matches[1]&feed=$matches[2]\";s:27:\"career-tag/([^/]+)/embed/?$\";s:43:\"index.php?career-tag=$matches[1]&embed=true\";s:39:\"career-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?career-tag=$matches[1]&paged=$matches[2]\";s:21:\"career-tag/([^/]+)/?$\";s:32:\"index.php?career-tag=$matches[1]\";s:41:\"cms-mega-menu/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"cms-mega-menu/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"cms-mega-menu/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"cms-mega-menu/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"cms-mega-menu/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:47:\"cms-mega-menu/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:30:\"cms-mega-menu/([^/]+)/embed/?$\";s:46:\"index.php?cms-mega-menu=$matches[1]&embed=true\";s:34:\"cms-mega-menu/([^/]+)/trackback/?$\";s:40:\"index.php?cms-mega-menu=$matches[1]&tb=1\";s:54:\"cms-mega-menu/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?cms-mega-menu=$matches[1]&feed=$matches[2]\";s:49:\"cms-mega-menu/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?cms-mega-menu=$matches[1]&feed=$matches[2]\";s:42:\"cms-mega-menu/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?cms-mega-menu=$matches[1]&paged=$matches[2]\";s:49:\"cms-mega-menu/([^/]+)/comment-page-([0-9]{1,})/?$\";s:53:\"index.php?cms-mega-menu=$matches[1]&cpage=$matches[2]\";s:50:\"cms-mega-menu/([^/]+)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?cms-mega-menu=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"cms-mega-menu/([^/]+)/wc-api(/(.*))?/?$\";s:54:\"index.php?cms-mega-menu=$matches[1]&wc-api=$matches[3]\";s:56:\"cms-mega-menu/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:67:\"cms-mega-menu/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:45:\"cms-mega-menu/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:56:\"cms-mega-menu/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:38:\"cms-mega-menu/([^/]+)(?:/([0-9]+))?/?$\";s:52:\"index.php?cms-mega-menu=$matches[1]&page=$matches[2]\";s:30:\"cms-mega-menu/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:40:\"cms-mega-menu/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:60:\"cms-mega-menu/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"cms-mega-menu/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"cms-mega-menu/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:36:\"cms-mega-menu/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:46:\"e-floating-buttons/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:56:\"e-floating-buttons/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:76:\"e-floating-buttons/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:52:\"e-floating-buttons/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"e-floating-buttons/([^/]+)/embed/?$\";s:51:\"index.php?e-floating-buttons=$matches[1]&embed=true\";s:39:\"e-floating-buttons/([^/]+)/trackback/?$\";s:45:\"index.php?e-floating-buttons=$matches[1]&tb=1\";s:47:\"e-floating-buttons/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&paged=$matches[2]\";s:54:\"e-floating-buttons/([^/]+)/comment-page-([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&cpage=$matches[2]\";s:55:\"e-floating-buttons/([^/]+)/wc/file/transient(/(.*))?/?$\";s:70:\"index.php?e-floating-buttons=$matches[1]&wc/file/transient=$matches[3]\";s:44:\"e-floating-buttons/([^/]+)/wc-api(/(.*))?/?$\";s:59:\"index.php?e-floating-buttons=$matches[1]&wc-api=$matches[3]\";s:61:\"e-floating-buttons/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:72:\"e-floating-buttons/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:50:\"e-floating-buttons/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:61:\"e-floating-buttons/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:43:\"e-floating-buttons/([^/]+)(?:/([0-9]+))?/?$\";s:57:\"index.php?e-floating-buttons=$matches[1]&page=$matches[2]\";s:35:\"e-floating-buttons/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"e-floating-buttons/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"e-floating-buttons/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"e-floating-buttons/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"brand/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:39:\"brand/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:20:\"brand/(.+?)/embed/?$\";s:46:\"index.php?product_brand=$matches[1]&embed=true\";s:32:\"brand/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?product_brand=$matches[1]&paged=$matches[2]\";s:14:\"brand/(.+?)/?$\";s:35:\"index.php?product_brand=$matches[1]\";s:55:\"product-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:50:\"product-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:31:\"product-category/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:43:\"product-category/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:25:\"product-category/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:52:\"product-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:47:\"product-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:28:\"product-tag/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:40:\"product-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:22:\"product-tag/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:35:\"product/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"product/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"product/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"product/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"product/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:28:\"product/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:48:\"product/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:43:\"product/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:36:\"product/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:43:\"product/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:44:\"product/([^/]+)/wc/file/transient(/(.*))?/?$\";s:59:\"index.php?product=$matches[1]&wc/file/transient=$matches[3]\";s:33:\"product/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:61:\"product/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"product/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:32:\"product/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:24:\"product/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"product/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"product/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"product/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:24:\"index.php??sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=73&cpage=$matches[1]\";s:28:\"wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:37:\"comments/wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:40:\"search/(.+)/wc/file/transient(/(.*))?/?$\";s:53:\"index.php?s=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:43:\"author/([^/]+)/wc/file/transient(/(.*))?/?$\";s:63:\"index.php?author_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:93:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc/file/transient=$matches[5]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:52:\"([0-9]{4})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:77:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc/file/transient=$matches[4]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:39:\"([0-9]{4})/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?year=$matches[1]&wc/file/transient=$matches[3]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:36:\"(.?.+?)/wc/file/transient(/(.*))?/?$\";s:60:\"index.php?pagename=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:42:\".?.+?/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\".?.+?/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:36:\"([^/]+)/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?name=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"([^/]+)/wc-api(/(.*))?/?$\";s:45:\"index.php?name=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\"[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\"[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "on");
INSERT INTO `wp_options` VALUES("31", "hack_file", "0", "on");
INSERT INTO `wp_options` VALUES("32", "blog_charset", "UTF-8", "on");
INSERT INTO `wp_options` VALUES("33", "moderation_keys", "", "off");
INSERT INTO `wp_options` VALUES("34", "active_plugins", "a:13:{i:0;s:25:\"cms-portal/cms-portal.php\";i:1;s:36:\"contact-form-7/wp-contact-form-7.php\";i:2;s:39:\"disable-gutenberg/disable-gutenberg.php\";i:3;s:32:\"duplicate-page/duplicatepage.php\";i:4;s:25:\"duplicator/duplicator.php\";i:5;s:45:\"elementor-theme-core/elementor-theme-core.php\";i:6;s:23:\"elementor/elementor.php\";i:7;s:21:\"newsletter/plugin.php\";i:8;s:35:\"one-user-avatar/one-user-avatar.php\";i:9;s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";i:10;s:39:\"swa-import-export/swa-import-export.php\";i:11;s:41:\"theme-core-options/theme-core-options.php\";i:12;s:27:\"woocommerce/woocommerce.php\";}", "on");
INSERT INTO `wp_options` VALUES("35", "category_base", "", "on");
INSERT INTO `wp_options` VALUES("36", "ping_sites", "https://rpc.pingomatic.com/", "on");
INSERT INTO `wp_options` VALUES("37", "comment_max_links", "2", "on");
INSERT INTO `wp_options` VALUES("38", "gmt_offset", "0", "on");
INSERT INTO `wp_options` VALUES("39", "default_email_category", "1", "on");
INSERT INTO `wp_options` VALUES("40", "recently_edited", "", "off");
INSERT INTO `wp_options` VALUES("41", "template", "finanzia", "on");
INSERT INTO `wp_options` VALUES("42", "stylesheet", "finanzia-child", "on");
INSERT INTO `wp_options` VALUES("43", "comment_registration", "0", "on");
INSERT INTO `wp_options` VALUES("44", "html_type", "text/html", "on");
INSERT INTO `wp_options` VALUES("45", "use_trackback", "0", "on");
INSERT INTO `wp_options` VALUES("46", "default_role", "subscriber", "on");
INSERT INTO `wp_options` VALUES("47", "db_version", "60421", "on");
INSERT INTO `wp_options` VALUES("48", "uploads_use_yearmonth_folders", "1", "on");
INSERT INTO `wp_options` VALUES("49", "upload_path", "", "on");
INSERT INTO `wp_options` VALUES("50", "blog_public", "1", "on");
INSERT INTO `wp_options` VALUES("51", "default_link_category", "2", "on");
INSERT INTO `wp_options` VALUES("52", "show_on_front", "page", "on");
INSERT INTO `wp_options` VALUES("53", "tag_base", "", "on");
INSERT INTO `wp_options` VALUES("54", "show_avatars", "1", "on");
INSERT INTO `wp_options` VALUES("55", "avatar_rating", "G", "on");
INSERT INTO `wp_options` VALUES("56", "upload_url_path", "", "on");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_w", "150", "on");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_h", "150", "on");
INSERT INTO `wp_options` VALUES("59", "thumbnail_crop", "1", "on");
INSERT INTO `wp_options` VALUES("60", "medium_size_w", "768", "on");
INSERT INTO `wp_options` VALUES("61", "medium_size_h", "768", "on");
INSERT INTO `wp_options` VALUES("62", "avatar_default", "mystery", "on");
INSERT INTO `wp_options` VALUES("63", "large_size_w", "840", "on");
INSERT INTO `wp_options` VALUES("64", "large_size_h", "560", "on");
INSERT INTO `wp_options` VALUES("65", "image_default_link_type", "none", "on");
INSERT INTO `wp_options` VALUES("66", "image_default_size", "", "on");
INSERT INTO `wp_options` VALUES("67", "image_default_align", "", "on");
INSERT INTO `wp_options` VALUES("68", "close_comments_for_old_posts", "0", "on");
INSERT INTO `wp_options` VALUES("69", "close_comments_days_old", "14", "on");
INSERT INTO `wp_options` VALUES("70", "thread_comments", "1", "on");
INSERT INTO `wp_options` VALUES("71", "thread_comments_depth", "5", "on");
INSERT INTO `wp_options` VALUES("72", "page_comments", "0", "on");
INSERT INTO `wp_options` VALUES("73", "comments_per_page", "50", "on");
INSERT INTO `wp_options` VALUES("74", "default_comments_page", "newest", "on");
INSERT INTO `wp_options` VALUES("75", "comment_order", "asc", "on");
INSERT INTO `wp_options` VALUES("76", "sticky_posts", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("77", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("78", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("79", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("80", "uninstall_plugins", "a:1:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}}", "off");
INSERT INTO `wp_options` VALUES("81", "timezone_string", "", "on");
INSERT INTO `wp_options` VALUES("82", "page_for_posts", "102", "on");
INSERT INTO `wp_options` VALUES("83", "page_on_front", "73", "on");
INSERT INTO `wp_options` VALUES("84", "default_post_format", "0", "on");
INSERT INTO `wp_options` VALUES("85", "link_manager_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("86", "finished_splitting_shared_terms", "1", "on");
INSERT INTO `wp_options` VALUES("87", "site_icon", "693", "on");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_w", "768", "on");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_h", "0", "on");
INSERT INTO `wp_options` VALUES("90", "wp_page_for_privacy_policy", "3", "on");
INSERT INTO `wp_options` VALUES("91", "show_comments_cookies_opt_in", "1", "on");
INSERT INTO `wp_options` VALUES("92", "admin_email_lifespan", "1764734804", "on");
INSERT INTO `wp_options` VALUES("93", "disallowed_keys", "", "off");
INSERT INTO `wp_options` VALUES("94", "comment_previously_approved", "1", "on");
INSERT INTO `wp_options` VALUES("95", "auto_plugin_theme_update_emails", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_dev", "enabled", "on");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_minor", "enabled", "on");
INSERT INTO `wp_options` VALUES("98", "auto_update_core_major", "enabled", "on");
INSERT INTO `wp_options` VALUES("99", "wp_force_deactivated_plugins", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("100", "wp_attachment_pages_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("101", "initial_db_version", "58975", "on");
INSERT INTO `wp_options` VALUES("102", "wp_user_roles", "a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:115:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:15:\"manage_security\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:92:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}}", "on");
INSERT INTO `wp_options` VALUES("103", "fresh_site", "0", "off");
INSERT INTO `wp_options` VALUES("104", "user_count", "1", "off");
INSERT INTO `wp_options` VALUES("105", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("106", "sidebars_widgets", "a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:13:\"array_version\";i:3;s:12:\"sidebar-post\";a:4:{i:0;s:12:\"cms_search-1\";i:1;s:18:\"cms_recent_posts-1\";i:2;s:10:\"cms_menu-1\";i:3;s:11:\"tag_cloud-1\";}s:15:\"sidebar-product\";a:5:{i:0;s:10:\"cms_menu-2\";i:1;s:28:\"woocommerce_product_search-1\";i:2;s:22:\"woocommerce_products-1\";i:3;s:26:\"woocommerce_price_filter-1\";i:4;s:31:\"woocommerce_product_tag_cloud-1\";}}", "auto");
INSERT INTO `wp_options` VALUES("107", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("108", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("109", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("110", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("111", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("112", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("113", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("114", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("115", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("116", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("117", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("118", "widget_tag_cloud", "a:2:{i:1;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"taxonomy\";s:8:\"post_tag\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("119", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("120", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("121", "_transient_wp_core_block_css_files", "a:2:{s:7:\"version\";s:5:\"6.8.1\";s:5:\"files\";a:536:{i:0;s:23:\"archives/editor-rtl.css\";i:1;s:27:\"archives/editor-rtl.min.css\";i:2;s:19:\"archives/editor.css\";i:3;s:23:\"archives/editor.min.css\";i:4;s:22:\"archives/style-rtl.css\";i:5;s:26:\"archives/style-rtl.min.css\";i:6;s:18:\"archives/style.css\";i:7;s:22:\"archives/style.min.css\";i:8;s:20:\"audio/editor-rtl.css\";i:9;s:24:\"audio/editor-rtl.min.css\";i:10;s:16:\"audio/editor.css\";i:11;s:20:\"audio/editor.min.css\";i:12;s:19:\"audio/style-rtl.css\";i:13;s:23:\"audio/style-rtl.min.css\";i:14;s:15:\"audio/style.css\";i:15;s:19:\"audio/style.min.css\";i:16;s:19:\"audio/theme-rtl.css\";i:17;s:23:\"audio/theme-rtl.min.css\";i:18;s:15:\"audio/theme.css\";i:19;s:19:\"audio/theme.min.css\";i:20;s:21:\"avatar/editor-rtl.css\";i:21;s:25:\"avatar/editor-rtl.min.css\";i:22;s:17:\"avatar/editor.css\";i:23;s:21:\"avatar/editor.min.css\";i:24;s:20:\"avatar/style-rtl.css\";i:25;s:24:\"avatar/style-rtl.min.css\";i:26;s:16:\"avatar/style.css\";i:27;s:20:\"avatar/style.min.css\";i:28;s:21:\"button/editor-rtl.css\";i:29;s:25:\"button/editor-rtl.min.css\";i:30;s:17:\"button/editor.css\";i:31;s:21:\"button/editor.min.css\";i:32;s:20:\"button/style-rtl.css\";i:33;s:24:\"button/style-rtl.min.css\";i:34;s:16:\"button/style.css\";i:35;s:20:\"button/style.min.css\";i:36;s:22:\"buttons/editor-rtl.css\";i:37;s:26:\"buttons/editor-rtl.min.css\";i:38;s:18:\"buttons/editor.css\";i:39;s:22:\"buttons/editor.min.css\";i:40;s:21:\"buttons/style-rtl.css\";i:41;s:25:\"buttons/style-rtl.min.css\";i:42;s:17:\"buttons/style.css\";i:43;s:21:\"buttons/style.min.css\";i:44;s:22:\"calendar/style-rtl.css\";i:45;s:26:\"calendar/style-rtl.min.css\";i:46;s:18:\"calendar/style.css\";i:47;s:22:\"calendar/style.min.css\";i:48;s:25:\"categories/editor-rtl.css\";i:49;s:29:\"categories/editor-rtl.min.css\";i:50;s:21:\"categories/editor.css\";i:51;s:25:\"categories/editor.min.css\";i:52;s:24:\"categories/style-rtl.css\";i:53;s:28:\"categories/style-rtl.min.css\";i:54;s:20:\"categories/style.css\";i:55;s:24:\"categories/style.min.css\";i:56;s:19:\"code/editor-rtl.css\";i:57;s:23:\"code/editor-rtl.min.css\";i:58;s:15:\"code/editor.css\";i:59;s:19:\"code/editor.min.css\";i:60;s:18:\"code/style-rtl.css\";i:61;s:22:\"code/style-rtl.min.css\";i:62;s:14:\"code/style.css\";i:63;s:18:\"code/style.min.css\";i:64;s:18:\"code/theme-rtl.css\";i:65;s:22:\"code/theme-rtl.min.css\";i:66;s:14:\"code/theme.css\";i:67;s:18:\"code/theme.min.css\";i:68;s:22:\"columns/editor-rtl.css\";i:69;s:26:\"columns/editor-rtl.min.css\";i:70;s:18:\"columns/editor.css\";i:71;s:22:\"columns/editor.min.css\";i:72;s:21:\"columns/style-rtl.css\";i:73;s:25:\"columns/style-rtl.min.css\";i:74;s:17:\"columns/style.css\";i:75;s:21:\"columns/style.min.css\";i:76;s:33:\"comment-author-name/style-rtl.css\";i:77;s:37:\"comment-author-name/style-rtl.min.css\";i:78;s:29:\"comment-author-name/style.css\";i:79;s:33:\"comment-author-name/style.min.css\";i:80;s:29:\"comment-content/style-rtl.css\";i:81;s:33:\"comment-content/style-rtl.min.css\";i:82;s:25:\"comment-content/style.css\";i:83;s:29:\"comment-content/style.min.css\";i:84;s:26:\"comment-date/style-rtl.css\";i:85;s:30:\"comment-date/style-rtl.min.css\";i:86;s:22:\"comment-date/style.css\";i:87;s:26:\"comment-date/style.min.css\";i:88;s:31:\"comment-edit-link/style-rtl.css\";i:89;s:35:\"comment-edit-link/style-rtl.min.css\";i:90;s:27:\"comment-edit-link/style.css\";i:91;s:31:\"comment-edit-link/style.min.css\";i:92;s:32:\"comment-reply-link/style-rtl.css\";i:93;s:36:\"comment-reply-link/style-rtl.min.css\";i:94;s:28:\"comment-reply-link/style.css\";i:95;s:32:\"comment-reply-link/style.min.css\";i:96;s:30:\"comment-template/style-rtl.css\";i:97;s:34:\"comment-template/style-rtl.min.css\";i:98;s:26:\"comment-template/style.css\";i:99;s:30:\"comment-template/style.min.css\";i:100;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:101;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:102;s:38:\"comments-pagination-numbers/editor.css\";i:103;s:42:\"comments-pagination-numbers/editor.min.css\";i:104;s:34:\"comments-pagination/editor-rtl.css\";i:105;s:38:\"comments-pagination/editor-rtl.min.css\";i:106;s:30:\"comments-pagination/editor.css\";i:107;s:34:\"comments-pagination/editor.min.css\";i:108;s:33:\"comments-pagination/style-rtl.css\";i:109;s:37:\"comments-pagination/style-rtl.min.css\";i:110;s:29:\"comments-pagination/style.css\";i:111;s:33:\"comments-pagination/style.min.css\";i:112;s:29:\"comments-title/editor-rtl.css\";i:113;s:33:\"comments-title/editor-rtl.min.css\";i:114;s:25:\"comments-title/editor.css\";i:115;s:29:\"comments-title/editor.min.css\";i:116;s:23:\"comments/editor-rtl.css\";i:117;s:27:\"comments/editor-rtl.min.css\";i:118;s:19:\"comments/editor.css\";i:119;s:23:\"comments/editor.min.css\";i:120;s:22:\"comments/style-rtl.css\";i:121;s:26:\"comments/style-rtl.min.css\";i:122;s:18:\"comments/style.css\";i:123;s:22:\"comments/style.min.css\";i:124;s:20:\"cover/editor-rtl.css\";i:125;s:24:\"cover/editor-rtl.min.css\";i:126;s:16:\"cover/editor.css\";i:127;s:20:\"cover/editor.min.css\";i:128;s:19:\"cover/style-rtl.css\";i:129;s:23:\"cover/style-rtl.min.css\";i:130;s:15:\"cover/style.css\";i:131;s:19:\"cover/style.min.css\";i:132;s:22:\"details/editor-rtl.css\";i:133;s:26:\"details/editor-rtl.min.css\";i:134;s:18:\"details/editor.css\";i:135;s:22:\"details/editor.min.css\";i:136;s:21:\"details/style-rtl.css\";i:137;s:25:\"details/style-rtl.min.css\";i:138;s:17:\"details/style.css\";i:139;s:21:\"details/style.min.css\";i:140;s:20:\"embed/editor-rtl.css\";i:141;s:24:\"embed/editor-rtl.min.css\";i:142;s:16:\"embed/editor.css\";i:143;s:20:\"embed/editor.min.css\";i:144;s:19:\"embed/style-rtl.css\";i:145;s:23:\"embed/style-rtl.min.css\";i:146;s:15:\"embed/style.css\";i:147;s:19:\"embed/style.min.css\";i:148;s:19:\"embed/theme-rtl.css\";i:149;s:23:\"embed/theme-rtl.min.css\";i:150;s:15:\"embed/theme.css\";i:151;s:19:\"embed/theme.min.css\";i:152;s:19:\"file/editor-rtl.css\";i:153;s:23:\"file/editor-rtl.min.css\";i:154;s:15:\"file/editor.css\";i:155;s:19:\"file/editor.min.css\";i:156;s:18:\"file/style-rtl.css\";i:157;s:22:\"file/style-rtl.min.css\";i:158;s:14:\"file/style.css\";i:159;s:18:\"file/style.min.css\";i:160;s:23:\"footnotes/style-rtl.css\";i:161;s:27:\"footnotes/style-rtl.min.css\";i:162;s:19:\"footnotes/style.css\";i:163;s:23:\"footnotes/style.min.css\";i:164;s:23:\"freeform/editor-rtl.css\";i:165;s:27:\"freeform/editor-rtl.min.css\";i:166;s:19:\"freeform/editor.css\";i:167;s:23:\"freeform/editor.min.css\";i:168;s:22:\"gallery/editor-rtl.css\";i:169;s:26:\"gallery/editor-rtl.min.css\";i:170;s:18:\"gallery/editor.css\";i:171;s:22:\"gallery/editor.min.css\";i:172;s:21:\"gallery/style-rtl.css\";i:173;s:25:\"gallery/style-rtl.min.css\";i:174;s:17:\"gallery/style.css\";i:175;s:21:\"gallery/style.min.css\";i:176;s:21:\"gallery/theme-rtl.css\";i:177;s:25:\"gallery/theme-rtl.min.css\";i:178;s:17:\"gallery/theme.css\";i:179;s:21:\"gallery/theme.min.css\";i:180;s:20:\"group/editor-rtl.css\";i:181;s:24:\"group/editor-rtl.min.css\";i:182;s:16:\"group/editor.css\";i:183;s:20:\"group/editor.min.css\";i:184;s:19:\"group/style-rtl.css\";i:185;s:23:\"group/style-rtl.min.css\";i:186;s:15:\"group/style.css\";i:187;s:19:\"group/style.min.css\";i:188;s:19:\"group/theme-rtl.css\";i:189;s:23:\"group/theme-rtl.min.css\";i:190;s:15:\"group/theme.css\";i:191;s:19:\"group/theme.min.css\";i:192;s:21:\"heading/style-rtl.css\";i:193;s:25:\"heading/style-rtl.min.css\";i:194;s:17:\"heading/style.css\";i:195;s:21:\"heading/style.min.css\";i:196;s:19:\"html/editor-rtl.css\";i:197;s:23:\"html/editor-rtl.min.css\";i:198;s:15:\"html/editor.css\";i:199;s:19:\"html/editor.min.css\";i:200;s:20:\"image/editor-rtl.css\";i:201;s:24:\"image/editor-rtl.min.css\";i:202;s:16:\"image/editor.css\";i:203;s:20:\"image/editor.min.css\";i:204;s:19:\"image/style-rtl.css\";i:205;s:23:\"image/style-rtl.min.css\";i:206;s:15:\"image/style.css\";i:207;s:19:\"image/style.min.css\";i:208;s:19:\"image/theme-rtl.css\";i:209;s:23:\"image/theme-rtl.min.css\";i:210;s:15:\"image/theme.css\";i:211;s:19:\"image/theme.min.css\";i:212;s:29:\"latest-comments/style-rtl.css\";i:213;s:33:\"latest-comments/style-rtl.min.css\";i:214;s:25:\"latest-comments/style.css\";i:215;s:29:\"latest-comments/style.min.css\";i:216;s:27:\"latest-posts/editor-rtl.css\";i:217;s:31:\"latest-posts/editor-rtl.min.css\";i:218;s:23:\"latest-posts/editor.css\";i:219;s:27:\"latest-posts/editor.min.css\";i:220;s:26:\"latest-posts/style-rtl.css\";i:221;s:30:\"latest-posts/style-rtl.min.css\";i:222;s:22:\"latest-posts/style.css\";i:223;s:26:\"latest-posts/style.min.css\";i:224;s:18:\"list/style-rtl.css\";i:225;s:22:\"list/style-rtl.min.css\";i:226;s:14:\"list/style.css\";i:227;s:18:\"list/style.min.css\";i:228;s:22:\"loginout/style-rtl.css\";i:229;s:26:\"loginout/style-rtl.min.css\";i:230;s:18:\"loginout/style.css\";i:231;s:22:\"loginout/style.min.css\";i:232;s:25:\"media-text/editor-rtl.css\";i:233;s:29:\"media-text/editor-rtl.min.css\";i:234;s:21:\"media-text/editor.css\";i:235;s:25:\"media-text/editor.min.css\";i:236;s:24:\"media-text/style-rtl.css\";i:237;s:28:\"media-text/style-rtl.min.css\";i:238;s:20:\"media-text/style.css\";i:239;s:24:\"media-text/style.min.css\";i:240;s:19:\"more/editor-rtl.css\";i:241;s:23:\"more/editor-rtl.min.css\";i:242;s:15:\"more/editor.css\";i:243;s:19:\"more/editor.min.css\";i:244;s:30:\"navigation-link/editor-rtl.css\";i:245;s:34:\"navigation-link/editor-rtl.min.css\";i:246;s:26:\"navigation-link/editor.css\";i:247;s:30:\"navigation-link/editor.min.css\";i:248;s:29:\"navigation-link/style-rtl.css\";i:249;s:33:\"navigation-link/style-rtl.min.css\";i:250;s:25:\"navigation-link/style.css\";i:251;s:29:\"navigation-link/style.min.css\";i:252;s:33:\"navigation-submenu/editor-rtl.css\";i:253;s:37:\"navigation-submenu/editor-rtl.min.css\";i:254;s:29:\"navigation-submenu/editor.css\";i:255;s:33:\"navigation-submenu/editor.min.css\";i:256;s:25:\"navigation/editor-rtl.css\";i:257;s:29:\"navigation/editor-rtl.min.css\";i:258;s:21:\"navigation/editor.css\";i:259;s:25:\"navigation/editor.min.css\";i:260;s:24:\"navigation/style-rtl.css\";i:261;s:28:\"navigation/style-rtl.min.css\";i:262;s:20:\"navigation/style.css\";i:263;s:24:\"navigation/style.min.css\";i:264;s:23:\"nextpage/editor-rtl.css\";i:265;s:27:\"nextpage/editor-rtl.min.css\";i:266;s:19:\"nextpage/editor.css\";i:267;s:23:\"nextpage/editor.min.css\";i:268;s:24:\"page-list/editor-rtl.css\";i:269;s:28:\"page-list/editor-rtl.min.css\";i:270;s:20:\"page-list/editor.css\";i:271;s:24:\"page-list/editor.min.css\";i:272;s:23:\"page-list/style-rtl.css\";i:273;s:27:\"page-list/style-rtl.min.css\";i:274;s:19:\"page-list/style.css\";i:275;s:23:\"page-list/style.min.css\";i:276;s:24:\"paragraph/editor-rtl.css\";i:277;s:28:\"paragraph/editor-rtl.min.css\";i:278;s:20:\"paragraph/editor.css\";i:279;s:24:\"paragraph/editor.min.css\";i:280;s:23:\"paragraph/style-rtl.css\";i:281;s:27:\"paragraph/style-rtl.min.css\";i:282;s:19:\"paragraph/style.css\";i:283;s:23:\"paragraph/style.min.css\";i:284;s:35:\"post-author-biography/style-rtl.css\";i:285;s:39:\"post-author-biography/style-rtl.min.css\";i:286;s:31:\"post-author-biography/style.css\";i:287;s:35:\"post-author-biography/style.min.css\";i:288;s:30:\"post-author-name/style-rtl.css\";i:289;s:34:\"post-author-name/style-rtl.min.css\";i:290;s:26:\"post-author-name/style.css\";i:291;s:30:\"post-author-name/style.min.css\";i:292;s:26:\"post-author/editor-rtl.css\";i:293;s:30:\"post-author/editor-rtl.min.css\";i:294;s:22:\"post-author/editor.css\";i:295;s:26:\"post-author/editor.min.css\";i:296;s:25:\"post-author/style-rtl.css\";i:297;s:29:\"post-author/style-rtl.min.css\";i:298;s:21:\"post-author/style.css\";i:299;s:25:\"post-author/style.min.css\";i:300;s:33:\"post-comments-form/editor-rtl.css\";i:301;s:37:\"post-comments-form/editor-rtl.min.css\";i:302;s:29:\"post-comments-form/editor.css\";i:303;s:33:\"post-comments-form/editor.min.css\";i:304;s:32:\"post-comments-form/style-rtl.css\";i:305;s:36:\"post-comments-form/style-rtl.min.css\";i:306;s:28:\"post-comments-form/style.css\";i:307;s:32:\"post-comments-form/style.min.css\";i:308;s:26:\"post-content/style-rtl.css\";i:309;s:30:\"post-content/style-rtl.min.css\";i:310;s:22:\"post-content/style.css\";i:311;s:26:\"post-content/style.min.css\";i:312;s:23:\"post-date/style-rtl.css\";i:313;s:27:\"post-date/style-rtl.min.css\";i:314;s:19:\"post-date/style.css\";i:315;s:23:\"post-date/style.min.css\";i:316;s:27:\"post-excerpt/editor-rtl.css\";i:317;s:31:\"post-excerpt/editor-rtl.min.css\";i:318;s:23:\"post-excerpt/editor.css\";i:319;s:27:\"post-excerpt/editor.min.css\";i:320;s:26:\"post-excerpt/style-rtl.css\";i:321;s:30:\"post-excerpt/style-rtl.min.css\";i:322;s:22:\"post-excerpt/style.css\";i:323;s:26:\"post-excerpt/style.min.css\";i:324;s:34:\"post-featured-image/editor-rtl.css\";i:325;s:38:\"post-featured-image/editor-rtl.min.css\";i:326;s:30:\"post-featured-image/editor.css\";i:327;s:34:\"post-featured-image/editor.min.css\";i:328;s:33:\"post-featured-image/style-rtl.css\";i:329;s:37:\"post-featured-image/style-rtl.min.css\";i:330;s:29:\"post-featured-image/style.css\";i:331;s:33:\"post-featured-image/style.min.css\";i:332;s:34:\"post-navigation-link/style-rtl.css\";i:333;s:38:\"post-navigation-link/style-rtl.min.css\";i:334;s:30:\"post-navigation-link/style.css\";i:335;s:34:\"post-navigation-link/style.min.css\";i:336;s:27:\"post-template/style-rtl.css\";i:337;s:31:\"post-template/style-rtl.min.css\";i:338;s:23:\"post-template/style.css\";i:339;s:27:\"post-template/style.min.css\";i:340;s:24:\"post-terms/style-rtl.css\";i:341;s:28:\"post-terms/style-rtl.min.css\";i:342;s:20:\"post-terms/style.css\";i:343;s:24:\"post-terms/style.min.css\";i:344;s:24:\"post-title/style-rtl.css\";i:345;s:28:\"post-title/style-rtl.min.css\";i:346;s:20:\"post-title/style.css\";i:347;s:24:\"post-title/style.min.css\";i:348;s:26:\"preformatted/style-rtl.css\";i:349;s:30:\"preformatted/style-rtl.min.css\";i:350;s:22:\"preformatted/style.css\";i:351;s:26:\"preformatted/style.min.css\";i:352;s:24:\"pullquote/editor-rtl.css\";i:353;s:28:\"pullquote/editor-rtl.min.css\";i:354;s:20:\"pullquote/editor.css\";i:355;s:24:\"pullquote/editor.min.css\";i:356;s:23:\"pullquote/style-rtl.css\";i:357;s:27:\"pullquote/style-rtl.min.css\";i:358;s:19:\"pullquote/style.css\";i:359;s:23:\"pullquote/style.min.css\";i:360;s:23:\"pullquote/theme-rtl.css\";i:361;s:27:\"pullquote/theme-rtl.min.css\";i:362;s:19:\"pullquote/theme.css\";i:363;s:23:\"pullquote/theme.min.css\";i:364;s:39:\"query-pagination-numbers/editor-rtl.css\";i:365;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:366;s:35:\"query-pagination-numbers/editor.css\";i:367;s:39:\"query-pagination-numbers/editor.min.css\";i:368;s:31:\"query-pagination/editor-rtl.css\";i:369;s:35:\"query-pagination/editor-rtl.min.css\";i:370;s:27:\"query-pagination/editor.css\";i:371;s:31:\"query-pagination/editor.min.css\";i:372;s:30:\"query-pagination/style-rtl.css\";i:373;s:34:\"query-pagination/style-rtl.min.css\";i:374;s:26:\"query-pagination/style.css\";i:375;s:30:\"query-pagination/style.min.css\";i:376;s:25:\"query-title/style-rtl.css\";i:377;s:29:\"query-title/style-rtl.min.css\";i:378;s:21:\"query-title/style.css\";i:379;s:25:\"query-title/style.min.css\";i:380;s:25:\"query-total/style-rtl.css\";i:381;s:29:\"query-total/style-rtl.min.css\";i:382;s:21:\"query-total/style.css\";i:383;s:25:\"query-total/style.min.css\";i:384;s:20:\"query/editor-rtl.css\";i:385;s:24:\"query/editor-rtl.min.css\";i:386;s:16:\"query/editor.css\";i:387;s:20:\"query/editor.min.css\";i:388;s:19:\"quote/style-rtl.css\";i:389;s:23:\"quote/style-rtl.min.css\";i:390;s:15:\"quote/style.css\";i:391;s:19:\"quote/style.min.css\";i:392;s:19:\"quote/theme-rtl.css\";i:393;s:23:\"quote/theme-rtl.min.css\";i:394;s:15:\"quote/theme.css\";i:395;s:19:\"quote/theme.min.css\";i:396;s:23:\"read-more/style-rtl.css\";i:397;s:27:\"read-more/style-rtl.min.css\";i:398;s:19:\"read-more/style.css\";i:399;s:23:\"read-more/style.min.css\";i:400;s:18:\"rss/editor-rtl.css\";i:401;s:22:\"rss/editor-rtl.min.css\";i:402;s:14:\"rss/editor.css\";i:403;s:18:\"rss/editor.min.css\";i:404;s:17:\"rss/style-rtl.css\";i:405;s:21:\"rss/style-rtl.min.css\";i:406;s:13:\"rss/style.css\";i:407;s:17:\"rss/style.min.css\";i:408;s:21:\"search/editor-rtl.css\";i:409;s:25:\"search/editor-rtl.min.css\";i:410;s:17:\"search/editor.css\";i:411;s:21:\"search/editor.min.css\";i:412;s:20:\"search/style-rtl.css\";i:413;s:24:\"search/style-rtl.min.css\";i:414;s:16:\"search/style.css\";i:415;s:20:\"search/style.min.css\";i:416;s:20:\"search/theme-rtl.css\";i:417;s:24:\"search/theme-rtl.min.css\";i:418;s:16:\"search/theme.css\";i:419;s:20:\"search/theme.min.css\";i:420;s:24:\"separator/editor-rtl.css\";i:421;s:28:\"separator/editor-rtl.min.css\";i:422;s:20:\"separator/editor.css\";i:423;s:24:\"separator/editor.min.css\";i:424;s:23:\"separator/style-rtl.css\";i:425;s:27:\"separator/style-rtl.min.css\";i:426;s:19:\"separator/style.css\";i:427;s:23:\"separator/style.min.css\";i:428;s:23:\"separator/theme-rtl.css\";i:429;s:27:\"separator/theme-rtl.min.css\";i:430;s:19:\"separator/theme.css\";i:431;s:23:\"separator/theme.min.css\";i:432;s:24:\"shortcode/editor-rtl.css\";i:433;s:28:\"shortcode/editor-rtl.min.css\";i:434;s:20:\"shortcode/editor.css\";i:435;s:24:\"shortcode/editor.min.css\";i:436;s:24:\"site-logo/editor-rtl.css\";i:437;s:28:\"site-logo/editor-rtl.min.css\";i:438;s:20:\"site-logo/editor.css\";i:439;s:24:\"site-logo/editor.min.css\";i:440;s:23:\"site-logo/style-rtl.css\";i:441;s:27:\"site-logo/style-rtl.min.css\";i:442;s:19:\"site-logo/style.css\";i:443;s:23:\"site-logo/style.min.css\";i:444;s:27:\"site-tagline/editor-rtl.css\";i:445;s:31:\"site-tagline/editor-rtl.min.css\";i:446;s:23:\"site-tagline/editor.css\";i:447;s:27:\"site-tagline/editor.min.css\";i:448;s:26:\"site-tagline/style-rtl.css\";i:449;s:30:\"site-tagline/style-rtl.min.css\";i:450;s:22:\"site-tagline/style.css\";i:451;s:26:\"site-tagline/style.min.css\";i:452;s:25:\"site-title/editor-rtl.css\";i:453;s:29:\"site-title/editor-rtl.min.css\";i:454;s:21:\"site-title/editor.css\";i:455;s:25:\"site-title/editor.min.css\";i:456;s:24:\"site-title/style-rtl.css\";i:457;s:28:\"site-title/style-rtl.min.css\";i:458;s:20:\"site-title/style.css\";i:459;s:24:\"site-title/style.min.css\";i:460;s:26:\"social-link/editor-rtl.css\";i:461;s:30:\"social-link/editor-rtl.min.css\";i:462;s:22:\"social-link/editor.css\";i:463;s:26:\"social-link/editor.min.css\";i:464;s:27:\"social-links/editor-rtl.css\";i:465;s:31:\"social-links/editor-rtl.min.css\";i:466;s:23:\"social-links/editor.css\";i:467;s:27:\"social-links/editor.min.css\";i:468;s:26:\"social-links/style-rtl.css\";i:469;s:30:\"social-links/style-rtl.min.css\";i:470;s:22:\"social-links/style.css\";i:471;s:26:\"social-links/style.min.css\";i:472;s:21:\"spacer/editor-rtl.css\";i:473;s:25:\"spacer/editor-rtl.min.css\";i:474;s:17:\"spacer/editor.css\";i:475;s:21:\"spacer/editor.min.css\";i:476;s:20:\"spacer/style-rtl.css\";i:477;s:24:\"spacer/style-rtl.min.css\";i:478;s:16:\"spacer/style.css\";i:479;s:20:\"spacer/style.min.css\";i:480;s:20:\"table/editor-rtl.css\";i:481;s:24:\"table/editor-rtl.min.css\";i:482;s:16:\"table/editor.css\";i:483;s:20:\"table/editor.min.css\";i:484;s:19:\"table/style-rtl.css\";i:485;s:23:\"table/style-rtl.min.css\";i:486;s:15:\"table/style.css\";i:487;s:19:\"table/style.min.css\";i:488;s:19:\"table/theme-rtl.css\";i:489;s:23:\"table/theme-rtl.min.css\";i:490;s:15:\"table/theme.css\";i:491;s:19:\"table/theme.min.css\";i:492;s:24:\"tag-cloud/editor-rtl.css\";i:493;s:28:\"tag-cloud/editor-rtl.min.css\";i:494;s:20:\"tag-cloud/editor.css\";i:495;s:24:\"tag-cloud/editor.min.css\";i:496;s:23:\"tag-cloud/style-rtl.css\";i:497;s:27:\"tag-cloud/style-rtl.min.css\";i:498;s:19:\"tag-cloud/style.css\";i:499;s:23:\"tag-cloud/style.min.css\";i:500;s:28:\"template-part/editor-rtl.css\";i:501;s:32:\"template-part/editor-rtl.min.css\";i:502;s:24:\"template-part/editor.css\";i:503;s:28:\"template-part/editor.min.css\";i:504;s:27:\"template-part/theme-rtl.css\";i:505;s:31:\"template-part/theme-rtl.min.css\";i:506;s:23:\"template-part/theme.css\";i:507;s:27:\"template-part/theme.min.css\";i:508;s:30:\"term-description/style-rtl.css\";i:509;s:34:\"term-description/style-rtl.min.css\";i:510;s:26:\"term-description/style.css\";i:511;s:30:\"term-description/style.min.css\";i:512;s:27:\"text-columns/editor-rtl.css\";i:513;s:31:\"text-columns/editor-rtl.min.css\";i:514;s:23:\"text-columns/editor.css\";i:515;s:27:\"text-columns/editor.min.css\";i:516;s:26:\"text-columns/style-rtl.css\";i:517;s:30:\"text-columns/style-rtl.min.css\";i:518;s:22:\"text-columns/style.css\";i:519;s:26:\"text-columns/style.min.css\";i:520;s:19:\"verse/style-rtl.css\";i:521;s:23:\"verse/style-rtl.min.css\";i:522;s:15:\"verse/style.css\";i:523;s:19:\"verse/style.min.css\";i:524;s:20:\"video/editor-rtl.css\";i:525;s:24:\"video/editor-rtl.min.css\";i:526;s:16:\"video/editor.css\";i:527;s:20:\"video/editor.min.css\";i:528;s:19:\"video/style-rtl.css\";i:529;s:23:\"video/style-rtl.min.css\";i:530;s:15:\"video/style.css\";i:531;s:19:\"video/style.min.css\";i:532;s:19:\"video/theme-rtl.css\";i:533;s:23:\"video/theme-rtl.min.css\";i:534;s:15:\"video/theme.css\";i:535;s:19:\"video/theme.min.css\";}}", "on");
INSERT INTO `wp_options` VALUES("125", "theme_mods_twentytwentyfive", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1749182932;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "off");
INSERT INTO `wp_options` VALUES("126", "_transient_wp_styles_for_blocks", "a:2:{s:4:\"hash\";s:32:\"8c7d46a72d7d4591fc1dd9485bedb304\";s:6:\"blocks\";a:5:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:120:\":where(.wp-block-post-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-post-template.is-layout-grid){gap: 1.25em;}\";s:12:\"core/columns\";s:102:\":where(.wp-block-columns.is-layout-flex){gap: 2em;}:where(.wp-block-columns.is-layout-grid){gap: 2em;}\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";}}", "on");
INSERT INTO `wp_options` VALUES("127", "recovery_keys", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("148", "_site_transient_wp_plugin_dependencies_plugin_data", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("149", "recently_activated", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("162", "rsssl_show_onboarding", "1", "off");
INSERT INTO `wp_options` VALUES("165", "rsssl_encryption_keys_set", "1", "off");
INSERT INTO `wp_options` VALUES("168", "rsssl_options", "a:37:{s:12:\"site_has_ssl\";s:1:\"1\";s:8:\"redirect\";s:11:\"wp_redirect\";s:19:\"mixed_content_fixer\";i:1;s:11:\"ssl_enabled\";s:1:\"1\";s:27:\"notifications_email_address\";s:21:\"selvam@warelycorp.com\";s:24:\"send_notifications_email\";i:1;s:24:\"enabled_captcha_provider\";s:4:\"none\";s:25:\"password_change_frequency\";s:2:\"12\";s:23:\"login_cookie_expiration\";s:2:\"48\";s:22:\"404_blocking_threshold\";s:3:\"lax\";s:29:\"404_blocking_lockout_duration\";s:0:\"\";s:27:\"disable_anyone_can_register\";i:1;s:20:\"disable_file_editing\";i:1;s:28:\"block_code_execution_uploads\";i:1;s:22:\"hide_wordpress_version\";i:1;s:22:\"disable_login_feedback\";i:1;s:16:\"disable_indexing\";i:1;s:24:\"disable_user_enumeration\";i:1;s:27:\"disable_x_powered_by_header\";i:1;s:22:\"block_display_is_login\";i:1;s:27:\"limit_login_attempts_amount\";s:1:\"5\";s:29:\"limit_login_attempts_duration\";s:2:\"15\";s:40:\"limit_login_attempts_locked_out_duration\";s:2:\"30\";s:16:\"x_xss_protection\";s:4:\"zero\";s:15:\"x_frame_options\";s:0:\"\";s:15:\"referrer_policy\";s:31:\"strict-origin-when-cross-origin\";s:12:\"hsts_max_age\";s:8:\"63072000\";s:26:\"cross_origin_opener_policy\";s:8:\"disabled\";s:28:\"cross_origin_resource_policy\";s:8:\"disabled\";s:28:\"cross_origin_embedder_policy\";s:8:\"disabled\";s:19:\"csp_frame_ancestors\";s:4:\"self\";s:24:\"login_protection_enabled\";i:1;s:19:\"two_fa_grace_period\";s:2:\"10\";s:28:\"enable_vulnerability_scanner\";i:1;s:36:\"vulnerability_notification_dashboard\";s:1:\"l\";s:35:\"vulnerability_notification_sitewide\";s:1:\"h\";s:19:\"review_notice_shown\";s:1:\"1\";}", "auto");
INSERT INTO `wp_options` VALUES("173", "rsssl_current_version", "9.3.5", "off");
INSERT INTO `wp_options` VALUES("186", "rsssl_6_notice_dismissed", "1", "off");
INSERT INTO `wp_options` VALUES("191", "rsssl_last_tested_http_method", "19", "off");
INSERT INTO `wp_options` VALUES("192", "rsssl_http_methods_allowed", "a:2:{s:11:\"not-allowed\";a:0:{}s:7:\"allowed\";a:18:{i:0;s:3:\"GET\";i:1;s:4:\"POST\";i:2;s:3:\"PUT\";i:3;s:6:\"DELETE\";i:4;s:4:\"HEAD\";i:5;s:7:\"OPTIONS\";i:6;s:7:\"CONNECT\";i:7;s:5:\"TRACE\";i:8;s:5:\"TRACK\";i:9;s:5:\"PATCH\";i:10;s:4:\"COPY\";i:11;s:4:\"LINK\";i:12;s:6:\"UNLINK\";i:13;s:5:\"PURGE\";i:14;s:4:\"LOCK\";i:15;s:6:\"UNLOCK\";i:16;s:8:\"PROPFIND\";i:17;s:4:\"VIEW\";}}", "off");
INSERT INTO `wp_options` VALUES("199", "finished_updating_comment_type", "1", "auto");
INSERT INTO `wp_options` VALUES("205", "rsssl_activation_timestamp", "1749182908", "off");
INSERT INTO `wp_options` VALUES("212", "rsssl_email_verification_status", "started", "off");
INSERT INTO `wp_options` VALUES("217", "rsssl_wp_version_token", "4917192188", "auto");
INSERT INTO `wp_options` VALUES("220", "rsssl_folder_name", "really-simple-ssl/14086ad280176be05f65b9170cc85c72", "auto");
INSERT INTO `wp_options` VALUES("221", "rsssl_onboarding_dismissed", "1", "off");
INSERT INTO `wp_options` VALUES("225", "current_theme", "Finanzia Child", "auto");
INSERT INTO `wp_options` VALUES("226", "theme_mods_twentytwentyfour", "a:5:{i:0;b:0;s:19:\"wp_classic_sidebars\";a:0:{}s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1749183009;s:4:\"data\";a:1:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}}}}", "off");
INSERT INTO `wp_options` VALUES("227", "theme_switched", "", "auto");
INSERT INTO `wp_options` VALUES("230", "rsssl_l_notification_dismissed_for", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("231", "rsssl_m_notification_dismissed_for", "a:2:{i:0;s:36:\"552cd3e5-96ca-4a76-b22e-7eb65c0d783d\";i:1;s:36:\"d3411927-e153-48b1-a5ca-549c26d1db82\";}", "off");
INSERT INTO `wp_options` VALUES("232", "rsssl_h_notification_dismissed_for", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("233", "rsssl_c_notification_dismissed_for", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("239", "theme_mods_finanzia", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1749183088;s:4:\"data\";a:1:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}}}}", "off");
INSERT INTO `wp_options` VALUES("242", "large_crop", "1", "auto");
INSERT INTO `wp_options` VALUES("243", "medium_large_crop", "1", "auto");
INSERT INTO `wp_options` VALUES("244", "medium_crop", "1", "auto");
INSERT INTO `wp_options` VALUES("245", "elementor_cpt_support", "a:37:{i:0;b:0;i:1;s:4:\"post\";i:2;s:4:\"page\";i:3;s:10:\"cms-footer\";i:4;s:14:\"cms-header-top\";i:5;s:13:\"cms-mega-menu\";i:6;s:9:\"portfolio\";i:7;s:10:\"cms-career\";i:8;s:8:\"cms-case\";i:9;s:12:\"cms-industry\";i:10;s:11:\"cms-service\";i:11;s:11:\"cms-sidenav\";i:12;s:9:\"cms-popup\";i:13;s:4:\"post\";i:14;s:4:\"page\";i:15;s:10:\"cms-footer\";i:16;s:14:\"cms-header-top\";i:17;s:13:\"cms-mega-menu\";i:18;s:9:\"portfolio\";i:19;s:10:\"cms-career\";i:20;s:8:\"cms-case\";i:21;s:12:\"cms-industry\";i:22;s:11:\"cms-service\";i:23;s:11:\"cms-sidenav\";i:24;s:9:\"cms-popup\";i:25;s:4:\"post\";i:26;s:4:\"page\";i:27;s:10:\"cms-footer\";i:28;s:14:\"cms-header-top\";i:29;s:13:\"cms-mega-menu\";i:30;s:9:\"portfolio\";i:31;s:10:\"cms-career\";i:32;s:8:\"cms-case\";i:33;s:12:\"cms-industry\";i:34;s:11:\"cms-service\";i:35;s:11:\"cms-sidenav\";i:36;s:9:\"cms-popup\";}", "auto");
INSERT INTO `wp_options` VALUES("250", "cpt_oauth", "a:4:{s:9:\"user_data\";a:1:{s:12:\"display_name\";s:6:\"Selvam\";}s:12:\"access_token\";s:64:\"eef6f2e269f2242241087093079a92bffea1ec12a51470fab68a90efb3168240\";s:10:\"expires_in\";i:25920000;s:13:\"refresh_token\";s:64:\"b01c6dab31ac3dc72141c033d563c9735a498cd42c4f0e2e302c3633fbd6f38d\";}", "auto");
INSERT INTO `wp_options` VALUES("262", "theme_mods_finanzia-child", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:65;}s:18:\"custom_css_post_id\";i:710;s:11:\"custom_logo\";i:691;}", "on");
INSERT INTO `wp_options` VALUES("271", "tco_theme_options_args", "a:11:{s:7:\"general\";a:2:{s:5:\"title\";s:7:\"General\";s:8:\"sections\";a:3:{s:6:\"colors\";a:2:{s:5:\"title\";s:6:\"Colors\";s:6:\"fields\";a:6:{s:12:\"accent_color\";a:3:{s:4:\"type\";s:9:\"color-set\";s:5:\"title\";s:12:\"Accent Color\";s:7:\"options\";a:2:{s:7:\"regular\";s:54:\"Regular <div class=\"label-desc\">Default: #223140</div>\";s:6:\"darken\";s:53:\"Darken <div class=\"label-desc\">Default: #051423</div>\";}}s:13:\"primary_color\";a:3:{s:4:\"type\";s:9:\"color-set\";s:5:\"title\";s:13:\"Primary Color\";s:7:\"options\";a:2:{s:7:\"regular\";s:54:\"Regular <div class=\"label-desc\">Default: #091019</div>\";s:7:\"lighten\";s:54:\"Lighten <div class=\"label-desc\">Default: #B1B9C1</div>\";}}s:13:\"heading_color\";a:3:{s:4:\"type\";s:9:\"color-set\";s:5:\"title\";s:13:\"Heading Color\";s:7:\"options\";a:1:{s:7:\"regular\";s:54:\"Regular <div class=\"label-desc\">Default: #091019</div>\";}}s:10:\"body_color\";a:3:{s:4:\"type\";s:9:\"color-set\";s:5:\"title\";s:10:\"Body Color\";s:7:\"options\";a:1:{s:7:\"regular\";s:17:\"Default (#42484E)\";}}s:10:\"link_color\";a:2:{s:4:\"type\";s:10:\"link-color\";s:5:\"title\";s:10:\"Link Color\";}s:12:\"custom_color\";a:3:{s:4:\"type\";s:9:\"color-set\";s:5:\"title\";s:12:\"Custom Color\";s:7:\"options\";a:9:{s:5:\"green\";s:52:\"Green <div class=\"label-desc\">Default: #6E997F</div>\";s:11:\"light-green\";s:58:\"Light-green <div class=\"label-desc\">Default: #89B49B</div>\";s:6:\"purple\";s:53:\"Purple <div class=\"label-desc\">Default: #717CA3</div>\";s:11:\"light-purle\";s:58:\"Light-purle <div class=\"label-desc\">Default: #8A93B1</div>\";s:4:\"grey\";s:51:\"Grey <div class=\"label-desc\">Default: #EEF1F3</div>\";s:7:\"stroke1\";s:54:\"Stroke1 <div class=\"label-desc\">Default: #223140</div>\";s:7:\"divider\";s:54:\"Divider <div class=\"label-desc\">Default: #E4E9F1</div>\";s:12:\"divider-dark\";s:59:\"Divider-dark <div class=\"label-desc\">Default: #2C3F51</div>\";s:11:\"stroke-dark\";s:58:\"Stroke-dark <div class=\"label-desc\">Default: #A7ADB3</div>\";}}}}s:5:\"typos\";a:2:{s:5:\"title\";s:11:\"Typographys\";s:6:\"fields\";a:4:{s:9:\"body_font\";a:4:{s:4:\"type\";s:6:\"select\";s:5:\"title\";s:9:\"Body Font\";s:7:\"options\";a:2:{s:7:\"default\";s:7:\"Default\";s:6:\"custom\";s:6:\"Custom\";}s:7:\"default\";s:7:\"default\";}s:14:\"body_font_typo\";a:11:{s:4:\"type\";s:10:\"typography\";s:5:\"title\";s:16:\"Body Custom Font\";s:8:\"subtitle\";s:46:\"This will be the default font of your website.\";s:8:\"required\";a:3:{i:0;s:9:\"body_font\";i:1;s:1:\"=\";i:2;s:6:\"custom\";}s:11:\"font_backup\";b:0;s:12:\"font_subsets\";b:0;s:10:\"font_style\";b:1;s:11:\"line_height\";b:0;s:9:\"font_size\";b:0;s:5:\"color\";b:0;s:6:\"output\";a:1:{i:0;s:11:\".dummy-body\";}}s:12:\"heading_font\";a:4:{s:4:\"type\";s:6:\"select\";s:5:\"title\";s:20:\"Heading Default Font\";s:7:\"options\";a:2:{s:7:\"default\";s:7:\"Default\";s:6:\"custom\";s:6:\"Custom\";}s:7:\"default\";s:7:\"default\";}s:17:\"heading_font_typo\";a:11:{s:4:\"type\";s:10:\"typography\";s:5:\"title\";s:7:\"Heading\";s:8:\"subtitle\";s:67:\"This will be the default font for all Heading tags of your website.\";s:6:\"output\";a:1:{i:0;s:14:\".dummy-heading\";}s:8:\"required\";a:3:{i:0;s:12:\"heading_font\";i:1;s:1:\"=\";i:2;s:6:\"custom\";}s:11:\"font_backup\";b:0;s:12:\"font_subsets\";b:0;s:10:\"font_style\";b:1;s:11:\"line_height\";b:0;s:9:\"font_size\";b:0;s:5:\"color\";b:0;}}}s:5:\"tools\";a:2:{s:5:\"title\";s:5:\"Tools\";s:6:\"fields\";a:3:{s:17:\"show_page_loading\";a:3:{s:4:\"type\";s:6:\"switch\";s:5:\"title\";s:19:\"Enable Page Loading\";s:8:\"subtitle\";s:46:\"Enable page loading effect when you load site.\";}s:13:\"back_totop_on\";a:4:{s:4:\"type\";s:6:\"switch\";s:5:\"title\";s:18:\"Back to Top Button\";s:8:\"subtitle\";s:43:\"Show back to top button when scrolled down.\";s:7:\"default\";i:1;}s:8:\"dev_mode\";a:3:{s:4:\"type\";s:6:\"switch\";s:5:\"title\";s:26:\"Dev Mode (not recommended)\";s:11:\"description\";s:39:\"no minimize , generate css over time...\";}}}}}s:10:\"header_top\";a:2:{s:5:\"title\";s:10:\"Header Top\";s:6:\"fields\";a:1:{s:17:\"header_top_layout\";a:8:{s:4:\"type\";s:12:\"image-select\";s:5:\"title\";s:6:\"Layout\";s:8:\"subtitle\";s:42:\"Select a layout for upper header top area.\";s:11:\"description\";s:154:\"<a href=\"https://atlascapt.warelytest.com/wp-admin/edit.php?post_type=cms-header-top\" target=\"_blank\">Click Here</a> to add your custom header top layout.\";s:11:\"placeholder\";s:7:\"Default\";s:7:\"options\";a:3:{s:4:\"none\";s:94:\"https://atlascapt.warelytest.com/wp-content/themes/finanzia/assets/images/default-opt/none.jpg\";i:463;s:78:\"https://atlascapt.warelytest.com/wp-content/uploads/Header-top-consulting.webp\";i:206;s:75:\"https://atlascapt.warelytest.com/wp-content/uploads/Header-top-default.webp\";}s:7:\"default\";s:1:\"1\";s:8:\"required\";a:3:{i:0;s:17:\"header_top_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}}}s:6:\"header\";a:2:{s:5:\"title\";s:6:\"Header\";s:8:\"sections\";a:4:{s:7:\"general\";a:2:{s:5:\"title\";s:7:\"General\";s:6:\"fields\";a:11:{s:13:\"header_layout\";a:6:{s:4:\"type\";s:12:\"image-select\";s:5:\"title\";s:6:\"Layout\";s:8:\"subtitle\";s:27:\"Select a layout for header.\";s:7:\"options\";a:5:{i:1;s:94:\"https://atlascapt.warelytest.com/wp-content/themes/finanzia/assets/images/header-layout/h1.jpg\";i:2;s:94:\"https://atlascapt.warelytest.com/wp-content/themes/finanzia/assets/images/header-layout/h2.jpg\";i:3;s:94:\"https://atlascapt.warelytest.com/wp-content/themes/finanzia/assets/images/header-layout/h3.jpg\";i:4;s:94:\"https://atlascapt.warelytest.com/wp-content/themes/finanzia/assets/images/header-layout/h4.jpg\";s:4:\"left\";s:98:\"https://atlascapt.warelytest.com/wp-content/themes/finanzia/assets/images/header-layout/h-left.jpg\";}s:7:\"default\";s:1:\"1\";s:8:\"required\";s:0:\"\";}s:11:\"header_menu\";a:4:{s:4:\"type\";s:6:\"select\";s:5:\"title\";s:15:\"Main Navigation\";s:7:\"options\";a:10:{s:2:\"_1\";s:7:\"Default\";s:7:\"primary\";s:21:\"Finanzia Primary Menu\";i:59;s:15:\"Blog Categories\";i:60;s:14:\"Footer - About\";i:61;s:19:\"Footer - Industries\";i:62;s:17:\"Footer - Services\";i:63;s:11:\"Footer Menu\";i:64;s:28:\"Header Top - Home Consulting\";i:65;s:9:\"Main Menu\";i:66;s:15:\"Shop Categories\";}s:7:\"default\";s:7:\"primary\";}s:15:\"main_menu_color\";a:2:{s:4:\"type\";s:10:\"link-color\";s:5:\"title\";s:10:\"Menu Color\";}s:13:\"header_height\";a:4:{s:4:\"type\";s:10:\"dimensions\";s:5:\"title\";s:21:\"Header Width / Height\";s:8:\"subtitle\";s:34:\"Set width / height for your Header\";s:5:\"width\";b:0;}s:5:\"extra\";a:2:{s:4:\"type\";s:7:\"heading\";s:5:\"title\";s:14:\"Extra Settings\";}s:12:\"header_width\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:20:\"Header Content Width\";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:5:{s:9:\"container\";s:9:\"Container\";s:14:\"container-wide\";s:14:\"Container Wide\";s:15:\"container-fluid\";s:15:\"Container Fluid\";s:16:\"container-fluid2\";s:28:\"Container Fluid - Full Right\";s:15:\"container--full\";s:14:\"Container Full\";}s:7:\"default\";s:15:\"container-fluid\";s:8:\"required\";s:0:\"\";}s:13:\"header_sticky\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:13:\"Header Sticky\";s:8:\"subtitle\";s:39:\"Header will be sticked when applicable.\";s:7:\"options\";a:2:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";}s:7:\"default\";s:3:\"off\";s:8:\"required\";s:0:\"\";}s:18:\"header_sticky_mode\";a:7:{s:5:\"title\";s:18:\"Header Sticky Mode\";s:8:\"subtitle\";s:17:\"Header will when:\";s:11:\"description\";s:0:\"\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:2:{s:7:\"srollup\";s:9:\"Scroll UP\";s:6:\"always\";s:6:\"Always\";}s:7:\"default\";s:7:\"srollup\";s:8:\"required\";a:3:{i:0;s:13:\"header_sticky\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:12:\"header_boxed\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:12:\"Header Boxed\";s:8:\"subtitle\";s:17:\"Make header boxed\";s:7:\"options\";a:2:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";}s:7:\"default\";s:3:\"off\";s:8:\"required\";s:0:\"\";}s:13:\"header_shadow\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:13:\"Header Shadow\";s:8:\"subtitle\";s:30:\"Add shadow at bottom of header\";s:7:\"options\";a:2:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";}s:7:\"default\";s:2:\"on\";s:8:\"required\";s:0:\"\";}s:14:\"header_divider\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:7:\"Divider\";s:8:\"subtitle\";s:31:\"Add divider at bottom of header\";s:7:\"options\";a:2:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";}s:7:\"default\";s:3:\"off\";s:8:\"required\";s:0:\"\";}}}s:4:\"logo\";a:2:{s:5:\"title\";s:4:\"Logo\";s:6:\"fields\";a:4:{s:4:\"logo\";a:2:{s:4:\"type\";s:5:\"media\";s:5:\"title\";s:4:\"Logo\";}s:9:\"logo_maxh\";a:3:{s:4:\"type\";s:10:\"dimensions\";s:5:\"title\";s:15:\"Logo Dimensions\";s:8:\"subtitle\";s:13:\"Enter number.\";}s:11:\"logo_mobile\";a:2:{s:4:\"type\";s:5:\"media\";s:5:\"title\";s:24:\"Logo Tablet &amp; Mobile\";}s:12:\"logo_maxh_sm\";a:3:{s:4:\"type\";s:10:\"dimensions\";s:5:\"title\";s:35:\"Logo Tablet &amp; Mobile Dimensions\";s:8:\"subtitle\";s:13:\"Enter number.\";}}}s:12:\"header_ontop\";a:2:{s:5:\"title\";s:18:\"Header Transparent\";s:6:\"fields\";a:4:{s:18:\"header_transparent\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:18:\"Header Transparent\";s:8:\"subtitle\";s:39:\"Header transparent use with background.\";s:7:\"options\";a:2:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";}s:7:\"default\";s:3:\"off\";s:8:\"required\";s:0:\"\";}s:10:\"logo_light\";a:2:{s:4:\"type\";s:5:\"media\";s:5:\"title\";s:4:\"Logo\";}s:17:\"logo_light_mobile\";a:2:{s:4:\"type\";s:5:\"media\";s:5:\"title\";s:24:\"Logo Tablet &amp; Mobile\";}s:22:\"transparent_menu_color\";a:2:{s:4:\"type\";s:10:\"link-color\";s:5:\"title\";s:10:\"Menu Color\";}}}s:10:\"attributes\";a:2:{s:5:\"title\";s:10:\"Attributes\";s:6:\"fields\";a:31:{s:11:\"search_icon\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:11:\"Search Icon\";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:2:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";}s:7:\"default\";s:3:\"off\";s:8:\"required\";s:0:\"\";}s:17:\"search_on_content\";a:6:{s:4:\"type\";s:6:\"select\";s:5:\"title\";s:17:\"Search Content As\";s:7:\"options\";a:2:{s:2:\"_1\";s:7:\"Default\";s:6:\"custom\";s:6:\"Custom\";}s:7:\"default\";s:2:\"_1\";s:11:\"description\";s:147:\"<a href=\"https://atlascapt.warelytest.com/wp-admin/edit.php?post_type=cms-popup#add_new\" target=\"_blank\">Click Here</a> to add your custom content.\";s:8:\"required\";a:3:{i:0;s:11:\"search_icon\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:25:\"search_on_content_content\";a:6:{s:4:\"type\";s:6:\"select\";s:5:\"title\";s:28:\"Choose custom search content\";s:11:\"description\";s:28:\"Choose custom search content\";s:7:\"options\";a:1:{s:2:\"_1\";s:15:\"Select Template\";}s:7:\"default\";s:2:\"_1\";s:8:\"required\";a:3:{i:0;s:17:\"search_on_content\";i:1;s:1:\"=\";i:2;s:6:\"custom\";}}s:9:\"cart_icon\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:9:\"Cart Icon\";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:2:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";}s:7:\"default\";s:3:\"off\";s:8:\"required\";s:0:\"\";}s:10:\"show_phone\";a:2:{s:4:\"type\";s:7:\"heading\";s:5:\"title\";s:6:\"Phone \";}s:10:\"h_phone_on\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:16:\"Show/Hide Phone \";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:2:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";}s:7:\"default\";s:3:\"off\";s:8:\"required\";s:0:\"\";}s:12:\"h_phone_text\";a:3:{s:4:\"type\";s:4:\"text\";s:5:\"title\";s:10:\"Phone Text\";s:11:\"placeholder\";s:16:\"Need assistance?\";}s:14:\"h_phone_number\";a:3:{s:4:\"type\";s:4:\"text\";s:5:\"title\";s:12:\"Phone Number\";s:11:\"placeholder\";s:13:\"+2 0106124541\";}s:9:\"show_mail\";a:2:{s:4:\"type\";s:7:\"heading\";s:5:\"title\";s:5:\"Mail \";}s:9:\"h_mail_on\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:15:\"Show/Hide Mail \";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:2:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";}s:7:\"default\";s:3:\"off\";s:8:\"required\";s:0:\"\";}s:11:\"h_mail_text\";a:4:{s:4:\"type\";s:4:\"text\";s:5:\"title\";s:10:\"Your Email\";s:11:\"placeholder\";s:22:\"Finanzia@cmsheroes.com\";s:8:\"required\";a:3:{i:0;s:9:\"h_mail_on\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:13:\"h_btn_heading\";a:2:{s:4:\"type\";s:7:\"heading\";s:5:\"title\";s:15:\"Button Settings\";}s:8:\"h_btn_on\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:16:\"Show/Hide Button\";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:2:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";}s:7:\"default\";s:3:\"off\";s:8:\"required\";s:0:\"\";}s:10:\"h_btn_text\";a:3:{s:4:\"type\";s:4:\"text\";s:5:\"title\";s:11:\"Button Text\";s:8:\"required\";a:3:{i:0;s:8:\"h_btn_on\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:15:\"h_btn_link_type\";a:5:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:16:\"Button Link Type\";s:7:\"options\";a:2:{s:4:\"page\";s:4:\"Page\";s:6:\"custom\";s:6:\"Custom\";}s:7:\"default\";s:4:\"page\";s:8:\"required\";a:3:{i:0;s:8:\"h_btn_on\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:10:\"h_btn_link\";a:5:{s:4:\"type\";s:6:\"select\";s:5:\"title\";s:9:\"Page Link\";s:4:\"args\";a:4:{s:9:\"post_type\";s:4:\"page\";s:14:\"posts_per_page\";i:-1;s:7:\"orderby\";s:5:\"title\";s:5:\"order\";s:3:\"ASC\";}s:7:\"select2\";b:1;s:8:\"required\";a:3:{i:0;s:15:\"h_btn_link_type\";i:1;s:1:\"=\";i:2;s:4:\"page\";}}s:17:\"h_btn_link_custom\";a:3:{s:4:\"type\";s:4:\"text\";s:5:\"title\";s:11:\"Custom Link\";s:8:\"required\";a:3:{i:0;s:15:\"h_btn_link_type\";i:1;s:1:\"=\";i:2;s:6:\"custom\";}}s:12:\"h_btn_target\";a:5:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:13:\"Button Target\";s:7:\"options\";a:2:{s:5:\"_self\";s:4:\"Self\";s:6:\"_blank\";s:5:\"Blank\";}s:7:\"default\";s:5:\"_self\";s:8:\"required\";a:3:{i:0;s:8:\"h_btn_on\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:14:\"h_btn2_heading\";a:2:{s:4:\"type\";s:7:\"heading\";s:5:\"title\";s:18:\"Button Settings #2\";}s:9:\"h_btn2_on\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:16:\"Show/Hide Button\";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:2:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";}s:7:\"default\";s:3:\"off\";s:8:\"required\";s:0:\"\";}s:11:\"h_btn2_text\";a:3:{s:4:\"type\";s:4:\"text\";s:5:\"title\";s:11:\"Button Text\";s:8:\"required\";a:3:{i:0;s:9:\"h_btn2_on\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:16:\"h_btn2_link_type\";a:5:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:16:\"Button Link Type\";s:7:\"options\";a:2:{s:4:\"page\";s:4:\"Page\";s:6:\"custom\";s:6:\"Custom\";}s:7:\"default\";s:4:\"page\";s:8:\"required\";a:3:{i:0;s:9:\"h_btn2_on\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:11:\"h_btn2_link\";a:5:{s:4:\"type\";s:6:\"select\";s:5:\"title\";s:9:\"Page Link\";s:4:\"args\";a:4:{s:9:\"post_type\";s:4:\"page\";s:14:\"posts_per_page\";i:-1;s:7:\"orderby\";s:5:\"title\";s:5:\"order\";s:3:\"ASC\";}s:7:\"select2\";b:1;s:8:\"required\";a:3:{i:0;s:16:\"h_btn2_link_type\";i:1;s:1:\"=\";i:2;s:4:\"page\";}}s:18:\"h_btn2_link_custom\";a:3:{s:4:\"type\";s:4:\"text\";s:5:\"title\";s:11:\"Custom Link\";s:8:\"required\";a:3:{i:0;s:16:\"h_btn2_link_type\";i:1;s:1:\"=\";i:2;s:6:\"custom\";}}s:13:\"h_btn2_target\";a:5:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:13:\"Button Target\";s:7:\"options\";a:2:{s:5:\"_self\";s:4:\"Self\";s:6:\"_blank\";s:5:\"Blank\";}s:7:\"default\";s:5:\"_self\";s:8:\"required\";a:3:{i:0;s:9:\"h_btn2_on\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:25:\"hide_sidebar_icon_heading\";a:3:{s:4:\"type\";s:7:\"heading\";s:5:\"title\";s:23:\"Hidden Sidebar Settings\";s:8:\"required\";a:0:{}}s:17:\"hide_sidebar_icon\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:14:\"Hidden Sidebar\";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:2:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";}s:7:\"default\";s:3:\"off\";s:8:\"required\";a:0:{}}s:21:\"header_sidenav_layout\";a:8:{s:4:\"type\";s:12:\"image-select\";s:5:\"title\";s:21:\"Hidden Sidebar Layout\";s:8:\"subtitle\";s:40:\"Select a layout for upper side nav area.\";s:11:\"description\";s:149:\"<a href=\"https://atlascapt.warelytest.com/wp-admin/edit.php?post_type=cms-sidenav\" target=\"_blank\">Click Here</a> to add your custom side nav layout.\";s:11:\"placeholder\";s:7:\"Default\";s:7:\"options\";a:1:{i:332;b:0;}s:7:\"default\";s:0:\"\";s:8:\"required\";a:3:{i:0;s:17:\"hide_sidebar_icon\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:21:\"header_social_heading\";a:3:{s:4:\"type\";s:7:\"heading\";s:5:\"title\";s:14:\"Header Socials\";s:8:\"required\";a:0:{}}s:18:\"show_header_social\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:16:\"Show/Hide Social\";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:2:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";}s:7:\"default\";s:3:\"off\";s:8:\"required\";a:0:{}}s:14:\"header_socials\";a:6:{s:4:\"type\";s:8:\"repeater\";s:5:\"title\";s:15:\"Add your Social\";s:6:\"fields\";a:3:{s:4:\"icon\";a:3:{s:4:\"type\";s:5:\"media\";s:5:\"title\";s:4:\"Icon\";s:7:\"default\";s:0:\"\";}s:3:\"url\";a:2:{s:4:\"type\";s:4:\"text\";s:5:\"title\";s:10:\"Social URL\";}s:4:\"text\";a:2:{s:4:\"type\";s:4:\"text\";s:5:\"title\";s:11:\"Social Text\";}}s:11:\"title_field\";s:3:\"url\";s:5:\"class\";s:6:\"123xxx\";s:7:\"classes\";s:10:\"456qwweqwe\";}}}}}s:10:\"page-title\";a:2:{s:5:\"title\";s:9:\"Page Tile\";s:6:\"fields\";a:7:{s:9:\"pagetitle\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:10:\"Page Title\";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:2:{s:2:\"on\";s:4:\"Show\";s:3:\"off\";s:4:\"Hide\";}s:7:\"default\";s:2:\"on\";s:8:\"required\";a:3:{i:0;s:13:\"custom_ptitle\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:10:\"show_title\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:5:\"Title\";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:2:{s:2:\"on\";s:4:\"Show\";s:3:\"off\";s:4:\"Hide\";}s:7:\"default\";s:2:\"on\";s:8:\"required\";a:3:{i:0;s:9:\"pagetitle\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:15:\"show_breadcrumb\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:11:\"Breadcrumbs\";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:2:{s:2:\"on\";s:4:\"Show\";s:3:\"off\";s:4:\"Hide\";}s:7:\"default\";s:2:\"on\";s:8:\"required\";a:3:{i:0;s:9:\"pagetitle\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:12:\"ptitle_align\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:17:\"Content Alignment\";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:3:{s:5:\"start\";s:5:\"Start\";s:6:\"center\";s:6:\"Center\";s:3:\"end\";s:3:\"End\";}s:7:\"default\";s:0:\"\";s:8:\"required\";a:3:{i:0;s:9:\"pagetitle\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:14:\"ptitle_heading\";a:3:{s:4:\"type\";s:7:\"heading\";s:5:\"title\";s:19:\"Background Settings\";s:8:\"required\";a:3:{i:0;s:9:\"pagetitle\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:13:\"page_title_bg\";a:8:{s:4:\"type\";s:10:\"background\";s:5:\"title\";s:10:\"Background\";s:8:\"subtitle\";s:33:\"Choose Background color and image\";s:8:\"required\";a:3:{i:0;s:9:\"pagetitle\";i:1;s:1:\"=\";i:2;s:2:\"on\";}s:17:\"background-repeat\";b:0;s:15:\"background-size\";b:0;s:19:\"background-position\";b:0;s:21:\"background-attachment\";b:0;}s:18:\"page_title_overlay\";a:3:{s:4:\"type\";s:10:\"rgba-color\";s:5:\"title\";s:24:\"Overlay Background Color\";s:8:\"required\";a:3:{i:0;s:9:\"pagetitle\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}}}s:7:\"content\";a:2:{s:5:\"title\";s:7:\"Content\";s:8:\"sections\";a:3:{s:7:\"general\";a:2:{s:5:\"title\";s:7:\"General\";s:6:\"fields\";a:2:{s:13:\"content_width\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:13:\"Content Width\";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:5:{s:9:\"container\";s:9:\"Container\";s:14:\"container-wide\";s:14:\"Container Wide\";s:15:\"container-fluid\";s:15:\"Container Fluid\";s:16:\"container-fluid2\";s:28:\"Container Fluid - Full Right\";s:15:\"container--full\";s:14:\"Container Full\";}s:7:\"default\";s:9:\"container\";s:8:\"required\";s:0:\"\";}s:24:\"search_field_placeholder\";a:3:{s:4:\"type\";s:4:\"text\";s:5:\"title\";s:30:\"Search Form - Text Placeholder\";s:11:\"description\";s:27:\"Default: Search Keywords...\";}}}s:7:\"archive\";a:2:{s:5:\"title\";s:7:\"Archive\";s:6:\"fields\";a:4:{s:17:\"archive_author_on\";a:4:{s:4:\"type\";s:6:\"switch\";s:5:\"title\";s:6:\"Author\";s:8:\"subtitle\";s:30:\"Show author name on each post.\";s:7:\"default\";i:1;}s:15:\"archive_date_on\";a:4:{s:4:\"type\";s:6:\"switch\";s:5:\"title\";s:4:\"Date\";s:8:\"subtitle\";s:30:\"Show date posted on each post.\";s:7:\"default\";i:1;}s:21:\"archive_categories_on\";a:4:{s:4:\"type\";s:6:\"switch\";s:5:\"title\";s:10:\"Categories\";s:8:\"subtitle\";s:33:\"Show category names on each post.\";s:7:\"default\";i:1;}s:19:\"archive_comments_on\";a:4:{s:4:\"type\";s:6:\"switch\";s:5:\"title\";s:8:\"Comments\";s:8:\"subtitle\";s:33:\"Show comments count on each post.\";s:7:\"default\";i:1;}}}s:11:\"single-post\";a:2:{s:5:\"title\";s:11:\"Single Post\";s:6:\"fields\";a:9:{s:14:\"post_author_on\";a:4:{s:4:\"type\";s:6:\"switch\";s:5:\"title\";s:6:\"Author\";s:8:\"subtitle\";s:32:\"Show author name on single post.\";s:7:\"default\";i:1;}s:19:\"post_author_info_on\";a:3:{s:4:\"type\";s:6:\"switch\";s:5:\"title\";s:11:\"Author Info\";s:8:\"subtitle\";s:32:\"Show author info on single post.\";}s:12:\"post_date_on\";a:4:{s:4:\"type\";s:6:\"switch\";s:5:\"title\";s:4:\"Date\";s:8:\"subtitle\";s:25:\"Show date on single post.\";s:7:\"default\";i:1;}s:18:\"post_categories_on\";a:4:{s:4:\"type\";s:6:\"switch\";s:5:\"title\";s:10:\"Categories\";s:8:\"subtitle\";s:35:\"Show category names on single post.\";s:7:\"default\";i:1;}s:12:\"post_tags_on\";a:4:{s:4:\"type\";s:6:\"switch\";s:5:\"title\";s:4:\"Tags\";s:8:\"subtitle\";s:30:\"Show tag names on single post.\";s:7:\"default\";i:1;}s:16:\"post_comments_on\";a:4:{s:4:\"type\";s:6:\"switch\";s:5:\"title\";s:8:\"Comments\";s:8:\"subtitle\";s:35:\"Show comments count on single post.\";s:7:\"default\";i:1;}s:20:\"post_social_share_on\";a:3:{s:4:\"type\";s:6:\"switch\";s:5:\"title\";s:12:\"Social Share\";s:8:\"subtitle\";s:33:\"Show social share on single post.\";}s:18:\"post_navigation_on\";a:4:{s:4:\"type\";s:6:\"switch\";s:5:\"title\";s:10:\"Navigation\";s:8:\"subtitle\";s:31:\"Show navigation on single post.\";s:7:\"default\";i:1;}s:21:\"post_comments_form_on\";a:4:{s:4:\"type\";s:6:\"switch\";s:5:\"title\";s:13:\"Comments Form\";s:8:\"subtitle\";s:34:\"Show comments form on single post.\";s:7:\"default\";i:1;}}}}}s:7:\"sidebar\";a:2:{s:5:\"title\";s:7:\"Sidebar\";s:8:\"sections\";a:1:{s:7:\"general\";a:2:{s:5:\"title\";s:7:\"General\";s:6:\"fields\";a:2:{s:10:\"sidebar_on\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:12:\"Show Sidebar\";s:8:\"subtitle\";s:51:\"Show/Hide sidebar on single post &amp; archive page\";s:7:\"options\";a:2:{s:2:\"on\";s:4:\"Show\";s:3:\"off\";s:4:\"Hide\";}s:7:\"default\";s:3:\"off\";s:8:\"required\";s:0:\"\";}s:11:\"sidebar_pos\";a:5:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:16:\"Sidebar Position\";s:7:\"options\";a:2:{s:11:\"order-first\";s:4:\"Left\";s:10:\"order-last\";s:5:\"Right\";}s:7:\"default\";s:10:\"order-last\";s:8:\"required\";a:3:{i:0;s:10:\"sidebar_on\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}}}}}s:6:\"footer\";a:2:{s:5:\"title\";s:6:\"Footer\";s:6:\"fields\";a:3:{s:16:\"footer_copyright\";a:6:{s:4:\"type\";s:8:\"textarea\";s:5:\"title\";s:18:\"Copyright Settings\";s:8:\"subtitle\";s:23:\"Add your copyright text\";s:11:\"description\";s:50:\"Use [[copy]] for &copy;, [[year]] for current year\";s:11:\"placeholder\";s:70:\"&copy; 2024 Finanzia, All Rights Reserved. With Love by CMSSuperHeroes\";s:8:\"required\";a:6:{i:0;s:13:\"footer_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";i:3;s:13:\"footer_layout\";i:4;s:1:\"=\";i:5;i:1;}}s:13:\"footer_layout\";a:8:{s:4:\"type\";s:12:\"image-select\";s:5:\"title\";s:6:\"Layout\";s:8:\"subtitle\";s:38:\"Select a layout for upper footer area.\";s:11:\"description\";s:146:\"<a href=\"https://atlascapt.warelytest.com/wp-admin/edit.php?post_type=cms-footer\" target=\"_blank\">Click Here</a> to add your custom footer layout.\";s:11:\"placeholder\";s:7:\"Default\";s:7:\"options\";a:2:{i:1;s:100:\"https://atlascapt.warelytest.com/wp-content/themes/finanzia/assets/images/footer-layout/default.webp\";i:169;s:65:\"https://atlascapt.warelytest.com/wp-content/uploads/footer-1.webp\";}s:7:\"default\";s:1:\"1\";s:8:\"required\";a:3:{i:0;s:13:\"footer_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:12:\"footer_fixed\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:12:\"Footer Fixed\";s:8:\"subtitle\";s:28:\"Make footer fixed at bottom?\";s:7:\"options\";a:2:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";}s:7:\"default\";s:3:\"off\";s:8:\"required\";a:3:{i:0;s:13:\"footer_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}}}s:8:\"404-page\";a:2:{s:5:\"title\";s:8:\"404 Page\";s:6:\"fields\";a:3:{s:14:\"title_404_page\";a:2:{s:4:\"type\";s:8:\"textarea\";s:5:\"title\";s:5:\"Title\";}s:16:\"content_404_page\";a:2:{s:4:\"type\";s:8:\"textarea\";s:5:\"title\";s:7:\"Content\";}s:17:\"btn_text_404_page\";a:3:{s:4:\"type\";s:4:\"text\";s:5:\"title\";s:11:\"Button Text\";s:11:\"description\";s:29:\"Default: Take me go back home\";}}}s:4:\"shop\";a:2:{s:5:\"title\";s:4:\"Shop\";s:8:\"sections\";a:1:{s:6:\"single\";a:2:{s:5:\"title\";s:15:\"Single Products\";s:6:\"fields\";a:5:{s:26:\"product_layout_and_content\";a:3:{s:4:\"type\";s:7:\"heading\";s:5:\"title\";s:20:\"Layout &amp; Content\";s:8:\"required\";s:0:\"\";}s:21:\"product_single_layout\";a:7:{s:5:\"title\";s:6:\"Layout\";s:8:\"subtitle\";s:32:\"Choose layout for single product\";s:11:\"description\";s:0:\"\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:1:{s:14:\"single-product\";s:19:\"WooCommerce Default\";}s:7:\"default\";s:14:\"single-product\";s:8:\"required\";s:0:\"\";}s:15:\"product_gallery\";a:7:{s:5:\"title\";s:14:\"Gallery Layout\";s:8:\"subtitle\";s:40:\"Choose layout for single product Gallery\";s:11:\"description\";s:0:\"\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:1:{s:6:\"slider\";s:6:\"Slider\";}s:7:\"default\";s:6:\"slider\";s:8:\"required\";s:0:\"\";}s:19:\"product_gallery_nav\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:18:\"Gallery Navigation\";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:2:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";}s:7:\"default\";s:2:\"on\";s:8:\"required\";a:3:{i:0;s:15:\"product_gallery\";i:1;s:1:\"=\";i:2;a:1:{i:0;s:6:\"slider\";}}}s:13:\"product_share\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:5:\"Share\";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:2:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";}s:7:\"default\";s:3:\"off\";s:8:\"required\";s:0:\"\";}}}}}s:5:\"popup\";a:2:{s:5:\"title\";s:6:\"Pop Up\";s:6:\"fields\";a:5:{s:12:\"popup_layout\";a:8:{s:4:\"type\";s:12:\"image-select\";s:5:\"title\";s:6:\"Layout\";s:8:\"subtitle\";s:38:\"Select a layout for upper Pop-Up area.\";s:11:\"description\";s:144:\"<a href=\"https://atlascapt.warelytest.com/wp-admin/edit.php?post_type=cms-popup\" target=\"_blank\">Click Here</a> to add your custom popup layout.\";s:11:\"placeholder\";s:7:\"Default\";s:7:\"options\";a:1:{s:4:\"none\";s:94:\"https://atlascapt.warelytest.com/wp-content/themes/finanzia/assets/images/default-opt/none.jpg\";}s:7:\"default\";s:1:\"1\";s:8:\"required\";a:3:{i:0;s:12:\"popup_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:10:\"hide_popup\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:22:\"Show Hide popup option\";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:2:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";}s:7:\"default\";s:3:\"off\";s:8:\"required\";a:3:{i:0;s:12:\"popup_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:13:\"popup_animate\";a:7:{s:5:\"title\";s:15:\"Animation Style\";s:8:\"subtitle\";s:0:\"\";s:11:\"description\";s:0:\"\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:3:{s:12:\"cms-fadeInUp\";s:10:\"Fade In Up\";s:14:\"cms-fadeInLeft\";s:12:\"Fade In Left\";s:15:\"cms-fadeInRight\";s:13:\"Fade In Right\";}s:7:\"default\";s:12:\"cms-fadeInUp\";s:8:\"required\";a:3:{i:0;s:12:\"popup_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:14:\"popup_position\";a:7:{s:5:\"title\";s:8:\"Position\";s:8:\"subtitle\";s:0:\"\";s:11:\"description\";s:0:\"\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:7:{s:17:\"align-items-start\";s:11:\"Top - Start\";s:37:\"align-items-start justify-content-end\";s:9:\"Top - End\";s:18:\"align-items-center\";s:14:\"Center - Start\";s:41:\"align-items-center justify-content-center\";s:15:\"Center - Center\";s:38:\"align-items-center justify-content-end\";s:12:\"Center - End\";s:15:\"align-items-end\";s:14:\"Bottom - Start\";s:35:\"align-items-end justify-content-end\";s:12:\"Bottom - End\";}s:7:\"default\";s:15:\"align-items-end\";s:8:\"required\";a:3:{i:0;s:12:\"popup_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:11:\"popup_max_w\";a:5:{s:4:\"type\";s:10:\"dimensions\";s:5:\"title\";s:11:\"Popup Width\";s:8:\"subtitle\";s:13:\"Enter number.\";s:6:\"height\";b:0;s:8:\"required\";a:3:{i:0;s:12:\"popup_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}}}s:3:\"api\";a:2:{s:5:\"title\";s:3:\"Api\";s:6:\"fields\";a:1:{s:10:\"gm_api_key\";a:5:{s:4:\"type\";s:4:\"text\";s:5:\"title\";s:19:\"Google Maps API Key\";s:8:\"subtitle\";s:51:\"Register a Google Maps Api key then put it in here.\";s:11:\"description\";s:39:\"AIzaSyC08_qdlXXCWiFNVj02d-L2BDK5qr6ZnfM\";s:7:\"default\";s:0:\"\";}}}}", "auto");
INSERT INTO `wp_options` VALUES("272", "tco_post_page_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("273", "tco_page_page_options_args", "a:7:{s:7:\"general\";a:2:{s:5:\"title\";s:7:\"General\";s:8:\"sections\";a:3:{s:6:\"colors\";a:2:{s:5:\"title\";s:6:\"Colors\";s:6:\"fields\";a:7:{s:12:\"color_custom\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:12:\"Custom Color\";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:2:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";}s:7:\"default\";s:3:\"off\";s:8:\"required\";s:0:\"\";}s:12:\"accent_color\";a:4:{s:4:\"type\";s:9:\"color-set\";s:5:\"title\";s:12:\"Accent Color\";s:7:\"options\";a:2:{s:7:\"regular\";s:54:\"Regular <div class=\"label-desc\">Default: #223140</div>\";s:6:\"darken\";s:53:\"Darken <div class=\"label-desc\">Default: #051423</div>\";}s:8:\"required\";a:3:{i:0;s:12:\"color_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:13:\"primary_color\";a:4:{s:4:\"type\";s:9:\"color-set\";s:5:\"title\";s:13:\"Primary Color\";s:7:\"options\";a:2:{s:7:\"regular\";s:54:\"Regular <div class=\"label-desc\">Default: #091019</div>\";s:7:\"lighten\";s:54:\"Lighten <div class=\"label-desc\">Default: #B1B9C1</div>\";}s:8:\"required\";a:3:{i:0;s:12:\"color_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:13:\"heading_color\";a:4:{s:4:\"type\";s:9:\"color-set\";s:5:\"title\";s:13:\"Heading Color\";s:7:\"options\";a:1:{s:7:\"regular\";s:54:\"Regular <div class=\"label-desc\">Default: #091019</div>\";}s:8:\"required\";a:3:{i:0;s:12:\"color_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:10:\"body_color\";a:4:{s:4:\"type\";s:9:\"color-set\";s:5:\"title\";s:10:\"Body Color\";s:7:\"options\";a:1:{s:7:\"regular\";s:17:\"Default (#42484E)\";}s:8:\"required\";a:3:{i:0;s:12:\"color_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:10:\"link_color\";a:3:{s:4:\"type\";s:10:\"link-color\";s:5:\"title\";s:10:\"Link Color\";s:8:\"required\";a:3:{i:0;s:12:\"color_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:12:\"custom_color\";a:4:{s:4:\"type\";s:9:\"color-set\";s:5:\"title\";s:12:\"Custom Color\";s:7:\"options\";a:9:{s:5:\"green\";s:52:\"Green <div class=\"label-desc\">Default: #6E997F</div>\";s:11:\"light-green\";s:58:\"Light-green <div class=\"label-desc\">Default: #89B49B</div>\";s:6:\"purple\";s:53:\"Purple <div class=\"label-desc\">Default: #717CA3</div>\";s:11:\"light-purle\";s:58:\"Light-purle <div class=\"label-desc\">Default: #8A93B1</div>\";s:4:\"grey\";s:51:\"Grey <div class=\"label-desc\">Default: #EEF1F3</div>\";s:7:\"stroke1\";s:54:\"Stroke1 <div class=\"label-desc\">Default: #223140</div>\";s:7:\"divider\";s:54:\"Divider <div class=\"label-desc\">Default: #E4E9F1</div>\";s:12:\"divider-dark\";s:59:\"Divider-dark <div class=\"label-desc\">Default: #2C3F51</div>\";s:11:\"stroke-dark\";s:58:\"Stroke-dark <div class=\"label-desc\">Default: #A7ADB3</div>\";}s:8:\"required\";a:3:{i:0;s:12:\"color_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}}}s:5:\"typos\";a:2:{s:5:\"title\";s:11:\"Typographys\";s:6:\"fields\";a:4:{s:9:\"body_font\";a:4:{s:4:\"type\";s:6:\"select\";s:5:\"title\";s:9:\"Body Font\";s:7:\"options\";a:2:{s:7:\"default\";s:7:\"Default\";s:6:\"custom\";s:6:\"Custom\";}s:7:\"default\";s:7:\"default\";}s:14:\"body_font_typo\";a:11:{s:4:\"type\";s:10:\"typography\";s:5:\"title\";s:16:\"Body Custom Font\";s:8:\"subtitle\";s:46:\"This will be the default font of your website.\";s:8:\"required\";a:3:{i:0;s:9:\"body_font\";i:1;s:1:\"=\";i:2;s:6:\"custom\";}s:11:\"font_backup\";b:0;s:12:\"font_subsets\";b:0;s:10:\"font_style\";b:1;s:11:\"line_height\";b:0;s:9:\"font_size\";b:0;s:5:\"color\";b:0;s:6:\"output\";a:1:{i:0;s:11:\".dummy-body\";}}s:12:\"heading_font\";a:4:{s:4:\"type\";s:6:\"select\";s:5:\"title\";s:20:\"Heading Default Font\";s:7:\"options\";a:2:{s:7:\"default\";s:7:\"Default\";s:6:\"custom\";s:6:\"Custom\";}s:7:\"default\";s:7:\"default\";}s:17:\"heading_font_typo\";a:11:{s:4:\"type\";s:10:\"typography\";s:5:\"title\";s:7:\"Heading\";s:8:\"subtitle\";s:67:\"This will be the default font for all Heading tags of your website.\";s:6:\"output\";a:1:{i:0;s:14:\".dummy-heading\";}s:8:\"required\";a:3:{i:0;s:12:\"heading_font\";i:1;s:1:\"=\";i:2;s:6:\"custom\";}s:11:\"font_backup\";b:0;s:12:\"font_subsets\";b:0;s:10:\"font_style\";b:1;s:11:\"line_height\";b:0;s:9:\"font_size\";b:0;s:5:\"color\";b:0;}}}s:8:\"advanced\";a:2:{s:5:\"title\";s:8:\"Advanced\";s:6:\"fields\";a:1:{s:14:\"body_top_space\";a:2:{s:4:\"type\";s:6:\"slider\";s:5:\"title\";s:14:\"Body Top Space\";}}}}}s:10:\"header-top\";a:2:{s:5:\"title\";s:10:\"Header Top\";s:6:\"fields\";a:2:{s:17:\"header_top_custom\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:17:\"Custom Header Top\";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:2:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";}s:7:\"default\";s:3:\"off\";s:8:\"required\";s:0:\"\";}s:17:\"header_top_layout\";a:8:{s:4:\"type\";s:12:\"image-select\";s:5:\"title\";s:6:\"Layout\";s:8:\"subtitle\";s:42:\"Select a layout for upper header top area.\";s:11:\"description\";s:154:\"<a href=\"https://atlascapt.warelytest.com/wp-admin/edit.php?post_type=cms-header-top\" target=\"_blank\">Click Here</a> to add your custom header top layout.\";s:11:\"placeholder\";s:7:\"Default\";s:7:\"options\";a:4:{i:-1;s:97:\"https://atlascapt.warelytest.com/wp-content/themes/finanzia/assets/images/default-opt/default.jpg\";s:4:\"none\";s:94:\"https://atlascapt.warelytest.com/wp-content/themes/finanzia/assets/images/default-opt/none.jpg\";i:463;s:78:\"https://atlascapt.warelytest.com/wp-content/uploads/Header-top-consulting.webp\";i:206;s:75:\"https://atlascapt.warelytest.com/wp-content/uploads/Header-top-default.webp\";}s:7:\"default\";s:2:\"-1\";s:8:\"required\";a:3:{i:0;s:17:\"header_top_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}}}s:6:\"header\";a:2:{s:5:\"title\";s:6:\"Header\";s:6:\"fields\";a:32:{s:13:\"header_custom\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:13:\"Custom Header\";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:2:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";}s:7:\"default\";s:3:\"off\";s:8:\"required\";s:0:\"\";}s:13:\"header_layout\";a:6:{s:4:\"type\";s:12:\"image-select\";s:5:\"title\";s:6:\"Layout\";s:8:\"subtitle\";s:27:\"Select a layout for header.\";s:7:\"options\";a:7:{i:-1;s:101:\"https://atlascapt.warelytest.com/wp-content/themes/finanzia/assets/images/header-layout/h-default.jpg\";s:4:\"none\";s:94:\"https://atlascapt.warelytest.com/wp-content/themes/finanzia/assets/images/header-layout/h0.jpg\";i:1;s:94:\"https://atlascapt.warelytest.com/wp-content/themes/finanzia/assets/images/header-layout/h1.jpg\";i:2;s:94:\"https://atlascapt.warelytest.com/wp-content/themes/finanzia/assets/images/header-layout/h2.jpg\";i:3;s:94:\"https://atlascapt.warelytest.com/wp-content/themes/finanzia/assets/images/header-layout/h3.jpg\";i:4;s:94:\"https://atlascapt.warelytest.com/wp-content/themes/finanzia/assets/images/header-layout/h4.jpg\";s:4:\"left\";s:98:\"https://atlascapt.warelytest.com/wp-content/themes/finanzia/assets/images/header-layout/h-left.jpg\";}s:7:\"default\";s:2:\"-1\";s:8:\"required\";a:3:{i:0;s:13:\"header_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:11:\"header_menu\";a:5:{s:4:\"type\";s:6:\"select\";s:5:\"title\";s:15:\"Main Navigation\";s:7:\"options\";a:10:{s:2:\"_1\";s:7:\"Default\";s:7:\"primary\";s:21:\"Finanzia Primary Menu\";i:59;s:15:\"Blog Categories\";i:60;s:14:\"Footer - About\";i:61;s:19:\"Footer - Industries\";i:62;s:17:\"Footer - Services\";i:63;s:11:\"Footer Menu\";i:64;s:28:\"Header Top - Home Consulting\";i:65;s:9:\"Main Menu\";i:66;s:15:\"Shop Categories\";}s:7:\"default\";s:2:\"_1\";s:8:\"required\";a:3:{i:0;s:13:\"header_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:15:\"main_menu_color\";a:3:{s:4:\"type\";s:10:\"link-color\";s:5:\"title\";s:10:\"Menu Color\";s:8:\"required\";a:3:{i:0;s:13:\"header_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:13:\"header_height\";a:5:{s:4:\"type\";s:10:\"dimensions\";s:5:\"title\";s:21:\"Header Width / Height\";s:8:\"subtitle\";s:34:\"Set width / height for your Header\";s:5:\"width\";b:0;s:8:\"required\";a:3:{i:0;s:13:\"header_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:5:\"extra\";a:3:{s:4:\"type\";s:7:\"heading\";s:5:\"title\";s:14:\"Extra Settings\";s:8:\"required\";a:3:{i:0;s:13:\"header_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:12:\"header_width\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:20:\"Header Content Width\";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:6:{s:9:\"container\";s:9:\"Container\";s:14:\"container-wide\";s:14:\"Container Wide\";s:15:\"container-fluid\";s:15:\"Container Fluid\";s:16:\"container-fluid2\";s:28:\"Container Fluid - Full Right\";s:15:\"container--full\";s:14:\"Container Full\";i:-1;s:7:\"Default\";}s:7:\"default\";s:2:\"-1\";s:8:\"required\";a:3:{i:0;s:13:\"header_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:13:\"header_sticky\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:13:\"Header Sticky\";s:8:\"subtitle\";s:39:\"Header will be sticked when applicable.\";s:7:\"options\";a:3:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";i:-1;s:7:\"Default\";}s:7:\"default\";s:2:\"-1\";s:8:\"required\";a:3:{i:0;s:13:\"header_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:18:\"header_sticky_mode\";a:7:{s:5:\"title\";s:18:\"Header Sticky Mode\";s:8:\"subtitle\";s:17:\"Header will when:\";s:11:\"description\";s:0:\"\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:3:{i:0;s:13:\"Theme Default\";s:7:\"srollup\";s:9:\"Scroll UP\";s:6:\"always\";s:6:\"Always\";}s:7:\"default\";s:1:\"0\";s:8:\"required\";a:3:{i:0;s:13:\"header_sticky\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:18:\"header_transparent\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:18:\"Header Transparent\";s:8:\"subtitle\";s:39:\"Header transparent use with background.\";s:7:\"options\";a:3:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";i:-1;s:7:\"Default\";}s:7:\"default\";s:2:\"-1\";s:8:\"required\";a:3:{i:0;s:13:\"header_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:22:\"transparent_menu_color\";a:4:{s:4:\"type\";s:10:\"link-color\";s:5:\"title\";s:10:\"Menu Color\";s:8:\"subtitle\";s:29:\"Header Transparent Menu Color\";s:8:\"required\";a:3:{i:0;s:18:\"header_transparent\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:12:\"header_boxed\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:12:\"Header Boxed\";s:8:\"subtitle\";s:17:\"Make header boxed\";s:7:\"options\";a:3:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";i:-1;s:7:\"Default\";}s:7:\"default\";s:2:\"-1\";s:8:\"required\";a:3:{i:0;s:13:\"header_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:13:\"header_shadow\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:13:\"Header Shadow\";s:8:\"subtitle\";s:30:\"Add shadow at bottom of header\";s:7:\"options\";a:3:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";i:-1;s:7:\"Default\";}s:7:\"default\";s:2:\"-1\";s:8:\"required\";a:3:{i:0;s:13:\"header_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:14:\"header_divider\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:7:\"Divider\";s:8:\"subtitle\";s:31:\"Add divider at bottom of header\";s:7:\"options\";a:3:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";i:-1;s:7:\"Default\";}s:7:\"default\";s:2:\"-1\";s:8:\"required\";a:3:{i:0;s:13:\"header_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:11:\"custom_logo\";a:3:{s:4:\"type\";s:7:\"heading\";s:5:\"title\";s:13:\"Logo Settings\";s:8:\"required\";a:3:{i:0;s:13:\"header_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:4:\"logo\";a:3:{s:4:\"type\";s:5:\"media\";s:5:\"title\";s:4:\"Logo\";s:8:\"required\";a:3:{i:0;s:13:\"header_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:9:\"logo_maxh\";a:4:{s:4:\"type\";s:10:\"dimensions\";s:5:\"title\";s:15:\"Logo Dimensions\";s:8:\"subtitle\";s:13:\"Enter number.\";s:8:\"required\";a:3:{i:0;s:13:\"header_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:11:\"logo_mobile\";a:3:{s:4:\"type\";s:5:\"media\";s:5:\"title\";s:24:\"Logo Tablet &amp; Mobile\";s:8:\"required\";a:3:{i:0;s:13:\"header_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:12:\"logo_maxh_sm\";a:4:{s:4:\"type\";s:10:\"dimensions\";s:5:\"title\";s:35:\"Logo Tablet &amp; Mobile Dimensions\";s:8:\"subtitle\";s:13:\"Enter number.\";s:8:\"required\";a:3:{i:0;s:13:\"header_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:10:\"logo_light\";a:3:{s:4:\"type\";s:5:\"media\";s:5:\"title\";s:25:\"Logo - Header Transparent\";s:8:\"required\";a:3:{i:0;s:13:\"header_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:17:\"logo_light_mobile\";a:3:{s:4:\"type\";s:5:\"media\";s:5:\"title\";s:45:\"Logo Tablet &amp; Mobile - Header Transparent\";s:8:\"required\";a:3:{i:0;s:13:\"header_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:16:\"custom_attribute\";a:3:{s:4:\"type\";s:7:\"heading\";s:5:\"title\";s:19:\"Attributes Settings\";s:8:\"required\";a:3:{i:0;s:13:\"header_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:11:\"search_icon\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:11:\"Search Icon\";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:3:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";i:-1;s:7:\"Default\";}s:7:\"default\";s:2:\"-1\";s:8:\"required\";a:3:{i:0;s:13:\"header_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:9:\"cart_icon\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:9:\"Cart Icon\";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:3:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";i:-1;s:7:\"Default\";}s:7:\"default\";s:2:\"-1\";s:8:\"required\";a:3:{i:0;s:13:\"header_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:9:\"h_mail_on\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:15:\"Show/Hide Email\";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:3:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";i:-1;s:7:\"Default\";}s:7:\"default\";s:2:\"-1\";s:8:\"required\";a:3:{i:0;s:13:\"header_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:10:\"h_phone_on\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:15:\"Show/Hide Phone\";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:3:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";i:-1;s:7:\"Default\";}s:7:\"default\";s:2:\"-1\";s:8:\"required\";a:3:{i:0;s:13:\"header_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:8:\"h_btn_on\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:16:\"Show/Hide Button\";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:3:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";i:-1;s:7:\"Default\";}s:7:\"default\";s:2:\"-1\";s:8:\"required\";a:3:{i:0;s:13:\"header_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:9:\"h_btn2_on\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:19:\"Show/Hide Button #2\";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:3:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";i:-1;s:7:\"Default\";}s:7:\"default\";s:2:\"-1\";s:8:\"required\";a:3:{i:0;s:13:\"header_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:18:\"show_header_social\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:16:\"Show/Hide Social\";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:3:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";i:-1;s:7:\"Default\";}s:7:\"default\";s:2:\"-1\";s:8:\"required\";a:3:{i:0;s:13:\"header_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:25:\"hide_sidebar_icon_heading\";a:3:{s:4:\"type\";s:7:\"heading\";s:5:\"title\";s:23:\"Hidden Sidebar Settings\";s:8:\"required\";a:3:{i:0;s:13:\"header_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:17:\"hide_sidebar_icon\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:14:\"Hidden Sidebar\";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:3:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";i:-1;s:7:\"Default\";}s:7:\"default\";s:2:\"-1\";s:8:\"required\";a:3:{i:0;s:13:\"header_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:21:\"header_sidenav_layout\";a:8:{s:4:\"type\";s:12:\"image-select\";s:5:\"title\";s:21:\"Hidden Sidebar Layout\";s:8:\"subtitle\";s:40:\"Select a layout for upper side nav area.\";s:11:\"description\";s:149:\"<a href=\"https://atlascapt.warelytest.com/wp-admin/edit.php?post_type=cms-sidenav\" target=\"_blank\">Click Here</a> to add your custom side nav layout.\";s:11:\"placeholder\";s:7:\"Default\";s:7:\"options\";a:3:{i:-1;s:97:\"https://atlascapt.warelytest.com/wp-content/themes/finanzia/assets/images/default-opt/default.jpg\";s:4:\"none\";s:94:\"https://atlascapt.warelytest.com/wp-content/themes/finanzia/assets/images/default-opt/none.jpg\";i:332;b:0;}s:7:\"default\";s:0:\"\";s:8:\"required\";a:3:{i:0;s:17:\"hide_sidebar_icon\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}}}s:10:\"page-title\";a:2:{s:5:\"title\";s:9:\"Page Tile\";s:6:\"fields\";a:8:{s:13:\"custom_ptitle\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:17:\"Custom Page Title\";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:2:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";}s:7:\"default\";s:3:\"off\";s:8:\"required\";s:0:\"\";}s:9:\"pagetitle\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:10:\"Page Title\";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:3:{s:2:\"on\";s:4:\"Show\";s:3:\"off\";s:4:\"Hide\";i:-1;s:7:\"Default\";}s:7:\"default\";s:2:\"-1\";s:8:\"required\";a:3:{i:0;s:13:\"custom_ptitle\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:10:\"show_title\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:5:\"Title\";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:3:{s:2:\"on\";s:4:\"Show\";s:3:\"off\";s:4:\"Hide\";i:-1;s:7:\"Default\";}s:7:\"default\";s:2:\"-1\";s:8:\"required\";a:3:{i:0;s:9:\"pagetitle\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:15:\"show_breadcrumb\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:11:\"Breadcrumbs\";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:3:{s:2:\"on\";s:4:\"Show\";s:3:\"off\";s:4:\"Hide\";i:-1;s:7:\"Default\";}s:7:\"default\";s:2:\"-1\";s:8:\"required\";a:3:{i:0;s:9:\"pagetitle\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:12:\"ptitle_align\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:17:\"Content Alignment\";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:3:{s:5:\"start\";s:5:\"Start\";s:6:\"center\";s:6:\"Center\";s:3:\"end\";s:3:\"End\";}s:7:\"default\";s:0:\"\";s:8:\"required\";a:3:{i:0;s:9:\"pagetitle\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:14:\"ptitle_heading\";a:3:{s:4:\"type\";s:7:\"heading\";s:5:\"title\";s:19:\"Background Settings\";s:8:\"required\";a:3:{i:0;s:9:\"pagetitle\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:13:\"page_title_bg\";a:8:{s:4:\"type\";s:10:\"background\";s:5:\"title\";s:10:\"Background\";s:8:\"subtitle\";s:33:\"Choose Background color and image\";s:8:\"required\";a:3:{i:0;s:9:\"pagetitle\";i:1;s:1:\"=\";i:2;s:2:\"on\";}s:17:\"background-repeat\";b:0;s:15:\"background-size\";b:0;s:19:\"background-position\";b:0;s:21:\"background-attachment\";b:0;}s:18:\"page_title_overlay\";a:3:{s:4:\"type\";s:10:\"rgba-color\";s:5:\"title\";s:24:\"Overlay Background Color\";s:8:\"required\";a:3:{i:0;s:9:\"pagetitle\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}}}s:7:\"content\";a:2:{s:5:\"title\";s:7:\"Content\";s:6:\"fields\";a:1:{s:13:\"content_width\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:13:\"Content Width\";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:6:{s:9:\"container\";s:9:\"Container\";s:14:\"container-wide\";s:14:\"Container Wide\";s:15:\"container-fluid\";s:15:\"Container Fluid\";s:16:\"container-fluid2\";s:28:\"Container Fluid - Full Right\";s:15:\"container--full\";s:14:\"Container Full\";i:-1;s:7:\"Default\";}s:7:\"default\";s:2:\"-1\";s:8:\"required\";s:0:\"\";}}}s:6:\"footer\";a:2:{s:5:\"title\";s:6:\"Footer\";s:6:\"fields\";a:4:{s:13:\"footer_custom\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:13:\"Custom Footer\";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:2:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";}s:7:\"default\";s:3:\"off\";s:8:\"required\";s:0:\"\";}s:16:\"footer_copyright\";a:6:{s:4:\"type\";s:8:\"textarea\";s:5:\"title\";s:18:\"Copyright Settings\";s:8:\"subtitle\";s:23:\"Add your copyright text\";s:11:\"description\";s:50:\"Use [[copy]] for &copy;, [[year]] for current year\";s:11:\"placeholder\";s:70:\"&copy; 2024 Finanzia, All Rights Reserved. With Love by CMSSuperHeroes\";s:8:\"required\";a:6:{i:0;s:13:\"footer_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";i:3;s:13:\"footer_layout\";i:4;s:1:\"=\";i:5;i:1;}}s:13:\"footer_layout\";a:8:{s:4:\"type\";s:12:\"image-select\";s:5:\"title\";s:6:\"Layout\";s:8:\"subtitle\";s:38:\"Select a layout for upper footer area.\";s:11:\"description\";s:146:\"<a href=\"https://atlascapt.warelytest.com/wp-admin/edit.php?post_type=cms-footer\" target=\"_blank\">Click Here</a> to add your custom footer layout.\";s:11:\"placeholder\";s:7:\"Default\";s:7:\"options\";a:4:{i:-1;s:97:\"https://atlascapt.warelytest.com/wp-content/themes/finanzia/assets/images/default-opt/default.jpg\";s:4:\"none\";s:94:\"https://atlascapt.warelytest.com/wp-content/themes/finanzia/assets/images/default-opt/none.jpg\";i:1;s:100:\"https://atlascapt.warelytest.com/wp-content/themes/finanzia/assets/images/footer-layout/default.webp\";i:169;s:65:\"https://atlascapt.warelytest.com/wp-content/uploads/footer-1.webp\";}s:7:\"default\";s:2:\"-1\";s:8:\"required\";a:3:{i:0;s:13:\"footer_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:12:\"footer_fixed\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:12:\"Footer Fixed\";s:8:\"subtitle\";s:28:\"Make footer fixed at bottom?\";s:7:\"options\";a:3:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";i:-1;s:7:\"Default\";}s:7:\"default\";s:2:\"-1\";s:8:\"required\";a:3:{i:0;s:13:\"footer_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}}}s:5:\"popup\";a:2:{s:5:\"title\";s:6:\"Pop Up\";s:6:\"fields\";a:6:{s:12:\"popup_custom\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:13:\"Custom Pop Up\";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:2:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";}s:7:\"default\";s:3:\"off\";s:8:\"required\";s:0:\"\";}s:12:\"popup_layout\";a:8:{s:4:\"type\";s:12:\"image-select\";s:5:\"title\";s:6:\"Layout\";s:8:\"subtitle\";s:38:\"Select a layout for upper Pop-Up area.\";s:11:\"description\";s:144:\"<a href=\"https://atlascapt.warelytest.com/wp-admin/edit.php?post_type=cms-popup\" target=\"_blank\">Click Here</a> to add your custom popup layout.\";s:11:\"placeholder\";s:7:\"Default\";s:7:\"options\";a:2:{i:-1;s:97:\"https://atlascapt.warelytest.com/wp-content/themes/finanzia/assets/images/default-opt/default.jpg\";s:4:\"none\";s:94:\"https://atlascapt.warelytest.com/wp-content/themes/finanzia/assets/images/default-opt/none.jpg\";}s:7:\"default\";s:2:\"-1\";s:8:\"required\";a:3:{i:0;s:12:\"popup_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:10:\"hide_popup\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:22:\"Show Hide popup option\";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:2:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";}s:7:\"default\";s:3:\"off\";s:8:\"required\";a:3:{i:0;s:12:\"popup_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:13:\"popup_animate\";a:7:{s:5:\"title\";s:15:\"Animation Style\";s:8:\"subtitle\";s:0:\"\";s:11:\"description\";s:0:\"\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:4:{i:0;s:13:\"Theme Default\";s:12:\"cms-fadeInUp\";s:10:\"Fade In Up\";s:14:\"cms-fadeInLeft\";s:12:\"Fade In Left\";s:15:\"cms-fadeInRight\";s:13:\"Fade In Right\";}s:7:\"default\";s:1:\"0\";s:8:\"required\";a:3:{i:0;s:12:\"popup_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:14:\"popup_position\";a:7:{s:5:\"title\";s:8:\"Position\";s:8:\"subtitle\";s:0:\"\";s:11:\"description\";s:0:\"\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:8:{i:0;s:13:\"Theme Default\";s:17:\"align-items-start\";s:11:\"Top - Start\";s:37:\"align-items-start justify-content-end\";s:9:\"Top - End\";s:18:\"align-items-center\";s:14:\"Center - Start\";s:41:\"align-items-center justify-content-center\";s:15:\"Center - Center\";s:38:\"align-items-center justify-content-end\";s:12:\"Center - End\";s:15:\"align-items-end\";s:14:\"Bottom - Start\";s:35:\"align-items-end justify-content-end\";s:12:\"Bottom - End\";}s:7:\"default\";s:1:\"0\";s:8:\"required\";a:3:{i:0;s:12:\"popup_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:11:\"popup_max_w\";a:5:{s:4:\"type\";s:10:\"dimensions\";s:5:\"title\";s:11:\"Popup Width\";s:8:\"subtitle\";s:13:\"Enter number.\";s:6:\"height\";b:0;s:8:\"required\";a:3:{i:0;s:12:\"popup_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}}}}", "auto");
INSERT INTO `wp_options` VALUES("274", "tco_attachment_page_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("275", "tco_revision_page_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("276", "tco_nav_menu_item_page_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("277", "tco_custom_css_page_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("278", "tco_customize_changeset_page_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("279", "tco_oembed_cache_page_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("280", "tco_user_request_page_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("281", "tco_wp_block_page_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("282", "tco_wp_template_page_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("283", "tco_wp_template_part_page_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("284", "tco_wp_global_styles_page_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("285", "tco_wp_navigation_page_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("286", "tco_wp_font_family_page_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("287", "tco_wp_font_face_page_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("288", "tco_cms-service_page_options_args", "a:2:{s:7:\"general\";a:2:{s:5:\"title\";s:7:\"General\";s:8:\"sections\";a:2:{s:5:\"icons\";a:2:{s:5:\"title\";s:4:\"Icon\";s:6:\"fields\";a:1:{s:4:\"icon\";a:3:{s:4:\"type\";s:5:\"media\";s:5:\"title\";s:11:\"Choose Icon\";s:7:\"default\";s:0:\"\";}}}s:8:\"features\";a:2:{s:5:\"title\";s:8:\"Features\";s:6:\"fields\";a:1:{s:8:\"features\";a:4:{s:4:\"type\";s:8:\"repeater\";s:5:\"title\";s:16:\"Add your feature\";s:6:\"fields\";a:1:{s:4:\"text\";a:2:{s:4:\"type\";s:4:\"text\";s:5:\"title\";s:12:\"Your feature\";}}s:11:\"title_field\";s:4:\"text\";}}}}}s:6:\"header\";a:2:{s:5:\"title\";s:6:\"Header\";s:6:\"fields\";a:2:{s:13:\"header_custom\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:13:\"Custom Header\";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:2:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";}s:7:\"default\";s:3:\"off\";s:8:\"required\";s:0:\"\";}s:18:\"header_transparent\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:18:\"Header Transparent\";s:8:\"subtitle\";s:39:\"Header transparent use with background.\";s:7:\"options\";a:3:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";i:-1;s:7:\"Default\";}s:7:\"default\";s:2:\"-1\";s:8:\"required\";a:3:{i:0;s:13:\"header_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}}}}", "auto");
INSERT INTO `wp_options` VALUES("289", "tco_cms-industry_page_options_args", "a:2:{s:7:\"general\";a:2:{s:5:\"title\";s:7:\"General\";s:8:\"sections\";a:1:{s:5:\"icons\";a:2:{s:5:\"title\";s:13:\"Industry Info\";s:6:\"fields\";a:1:{s:4:\"icon\";a:3:{s:4:\"type\";s:5:\"media\";s:5:\"title\";s:11:\"Choose Icon\";s:7:\"default\";s:0:\"\";}}}}}s:6:\"header\";a:2:{s:5:\"title\";s:6:\"Header\";s:6:\"fields\";a:2:{s:13:\"header_custom\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:13:\"Custom Header\";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:2:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";}s:7:\"default\";s:3:\"off\";s:8:\"required\";s:0:\"\";}s:18:\"header_transparent\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:18:\"Header Transparent\";s:8:\"subtitle\";s:39:\"Header transparent use with background.\";s:7:\"options\";a:3:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";i:-1;s:7:\"Default\";}s:7:\"default\";s:2:\"-1\";s:8:\"required\";a:3:{i:0;s:13:\"header_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}}}}", "auto");
INSERT INTO `wp_options` VALUES("290", "tco_cms-case_page_options_args", "a:2:{s:7:\"general\";a:2:{s:5:\"title\";s:7:\"General\";s:8:\"sections\";a:1:{s:5:\"icons\";a:2:{s:5:\"title\";s:4:\"Icon\";s:6:\"fields\";a:1:{s:4:\"icon\";a:3:{s:4:\"type\";s:5:\"media\";s:5:\"title\";s:11:\"Choose Icon\";s:7:\"default\";s:0:\"\";}}}}}s:6:\"header\";a:2:{s:5:\"title\";s:6:\"Header\";s:6:\"fields\";a:2:{s:13:\"header_custom\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:13:\"Custom Header\";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:2:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";}s:7:\"default\";s:3:\"off\";s:8:\"required\";s:0:\"\";}s:18:\"header_transparent\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:18:\"Header Transparent\";s:8:\"subtitle\";s:39:\"Header transparent use with background.\";s:7:\"options\";a:3:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";i:-1;s:7:\"Default\";}s:7:\"default\";s:2:\"-1\";s:8:\"required\";a:3:{i:0;s:13:\"header_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}}}}", "auto");
INSERT INTO `wp_options` VALUES("291", "tco_cms-career_page_options_args", "a:2:{s:7:\"general\";a:2:{s:5:\"title\";s:7:\"General\";s:8:\"sections\";a:1:{s:7:\"general\";a:2:{s:5:\"title\";s:7:\"General\";s:6:\"fields\";a:3:{s:8:\"job_type\";a:2:{s:4:\"type\";s:4:\"text\";s:5:\"title\";s:8:\"Job Type\";}s:11:\"job_address\";a:2:{s:4:\"type\";s:4:\"text\";s:5:\"title\";s:11:\"Job Address\";}s:10:\"job_salary\";a:2:{s:4:\"type\";s:4:\"text\";s:5:\"title\";s:10:\"Job Salary\";}}}}}s:6:\"header\";a:2:{s:5:\"title\";s:6:\"Header\";s:6:\"fields\";a:2:{s:13:\"header_custom\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:13:\"Custom Header\";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:2:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";}s:7:\"default\";s:3:\"off\";s:8:\"required\";s:0:\"\";}s:18:\"header_transparent\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:18:\"Header Transparent\";s:8:\"subtitle\";s:39:\"Header transparent use with background.\";s:7:\"options\";a:3:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";i:-1;s:7:\"Default\";}s:7:\"default\";s:2:\"-1\";s:8:\"required\";a:3:{i:0;s:13:\"header_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}}}}", "auto");
INSERT INTO `wp_options` VALUES("292", "tco_cms-sidenav_page_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("293", "tco_cms-header-top_page_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("294", "tco_cms-footer_page_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("295", "tco_cms-popup_page_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("296", "tco_cms-mega-menu_page_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("297", "tco_category_tax_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("298", "tco_post_tag_tax_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("299", "tco_wp_template_part_area_tax_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("300", "tco_wp_pattern_category_tax_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("301", "tco_service-category_tax_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("302", "tco_service-tag_tax_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("303", "tco_industry-category_tax_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("304", "tco_industry-tag_tax_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("305", "tco_case-category_tax_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("306", "tco_case-tag_tax_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("307", "tco_career-category_tax_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("308", "tco_career-tag_tax_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("309", "tco_user_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("310", "tco_woocommerce_attribute_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("312", "elementor_active_kit", "685", "auto");
INSERT INTO `wp_options` VALUES("313", "elementor_font_display", "swap", "auto");
INSERT INTO `wp_options` VALUES("316", "elementor_landing_pages_activation", "0", "auto");
INSERT INTO `wp_options` VALUES("317", "elementor_version", "3.29.2", "auto");
INSERT INTO `wp_options` VALUES("318", "elementor_install_history", "a:1:{s:6:\"3.29.2\";i:1749183242;}", "auto");
INSERT INTO `wp_options` VALUES("319", "elementor_events_db_version", "1.0.0", "off");
INSERT INTO `wp_options` VALUES("320", "widget_cms_search", "a:2:{i:1;a:2:{s:5:\"title\";s:0:\"\";s:11:\"placeholder\";s:9:\"Search...\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("321", "widget_cms_recent_posts", "a:2:{i:1;a:5:{s:5:\"title\";s:12:\"Recent Posts\";s:6:\"number\";i:3;s:9:\"post_type\";s:4:\"post\";s:7:\"post_in\";s:6:\"recent\";s:6:\"layout\";s:1:\"1\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("322", "widget_cms_menu", "a:3:{i:1;a:4:{s:5:\"title\";s:10:\"Categories\";s:6:\"layout\";i:1;s:8:\"nav_menu\";i:31;s:5:\"count\";i:3;}i:2;a:3:{s:5:\"title\";s:10:\"Categories\";s:6:\"layout\";i:2;s:8:\"nav_menu\";i:66;}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("323", "widget_cms_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("324", "widget_cms_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("325", "widget_cms_follow_us", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("326", "tco_elementor_library_page_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("327", "tco_elementor_library_type_tax_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("328", "tco_elementor_library_category_tax_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("330", "elementor_checklist", "{\"last_opened_timestamp\":null,\"first_closed_checklist_in_editor\":true,\"is_popup_minimized\":false,\"steps\":{\"add_logo\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"set_fonts_and_colors\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"create_pages\":{\"is_marked_completed\":false,\"is_immutable_completed\":true},\"setup_header\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"assign_homepage\":{\"is_marked_completed\":false,\"is_immutable_completed\":false}},\"should_open_in_editor\":true}", "auto");
INSERT INTO `wp_options` VALUES("331", "tco_e-floating-buttons_page_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("333", "newsletter_logger_secret", "955caa59", "auto");
INSERT INTO `wp_options` VALUES("334", "newsletter_install_time", "1749183251", "off");
INSERT INTO `wp_options` VALUES("336", "newsletter_backup_0.0.0", "a:3:{s:23:\"newsletter_install_time\";i:1749183251;s:24:\"newsletter_logger_secret\";s:8:\"955caa59\";s:23:\"newsletter_show_welcome\";s:1:\"1\";}", "off");
INSERT INTO `wp_options` VALUES("337", "newsletter_statistics", "a:1:{s:3:\"key\";s:32:\"24946a12d8df322b4f7e46ccc5b0a600\";}", "off");
INSERT INTO `wp_options` VALUES("338", "newsletter_version", "8.8.7", "auto");
INSERT INTO `wp_options` VALUES("339", "widget_newsletterwidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("340", "widget_newsletterwidgetminimal", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("342", "newsletter_addons_updated", "1764134847", "off");
INSERT INTO `wp_options` VALUES("343", "newsletter_addons", "a:58:{i:0;O:8:\"stdClass\":13:{s:2:\"id\";s:3:\"123\";s:8:\"category\";s:12:\"subscription\";s:7:\"version\";s:5:\"1.0.5\";s:5:\"title\";s:23:\"MemberPress Integration\";s:11:\"description\";s:35:\"Integration with MemberPress plugin\";s:4:\"slug\";s:22:\"newsletter-memberpress\";s:4:\"type\";s:12:\"integration \";s:3:\"url\";s:43:\"https://www.thenewsletterplugin.com/premium\";s:5:\"image\";s:78:\"https://www.thenewsletterplugin.com/wp-content/uploads/2025/05/memberpress.png\";s:4:\"free\";b:0;s:12:\"downloadable\";b:0;s:12:\"download_url\";s:85:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=123\";s:7:\"wp_slug\";s:38:\"newsletter-memberpress/memberpress.php\";}i:1;O:8:\"stdClass\":13:{s:2:\"id\";s:2:\"73\";s:8:\"category\";s:12:\"subscription\";s:7:\"version\";s:5:\"1.4.6\";s:5:\"title\";s:20:\"WP Users Integration\";s:11:\"description\";s:118:\"Connects the WordPress user registration with Newsletter subscription. Optionally imports all WP users as subscribers.\";s:4:\"slug\";s:18:\"newsletter-wpusers\";s:4:\"type\";s:11:\"integration\";s:3:\"url\";s:93:\"https://www.thenewsletterplugin.com/documentation/addons/extended-features/wpusers-extension/\";s:5:\"image\";s:82:\"https://www.thenewsletterplugin.com/wp-content/uploads/2023/03/wpusers-32x32-1.png\";s:4:\"free\";b:1;s:12:\"downloadable\";b:1;s:12:\"download_url\";s:84:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=73\";s:7:\"wp_slug\";s:30:\"newsletter-wpusers/wpusers.php\";}i:2;O:8:\"stdClass\":13:{s:2:\"id\";s:2:\"87\";s:8:\"category\";s:6:\"legacy\";s:7:\"version\";s:5:\"1.0.5\";s:5:\"title\";s:32:\"Speed and Delivery Hours Control\";s:11:\"description\";s:117:\"Configure a different delivery speed for each newsletter and the delivery hours window. Only for regular newsletters.\";s:4:\"slug\";s:23:\"newsletter-speedcontrol\";s:4:\"type\";s:6:\"legacy\";s:3:\"url\";s:43:\"https://www.thenewsletterplugin.com/account\";s:5:\"image\";s:79:\"https://www.thenewsletterplugin.com/wp-content/uploads/2018/12/speedcontrol.png\";s:4:\"free\";b:1;s:12:\"downloadable\";b:1;s:12:\"download_url\";s:84:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=87\";s:7:\"wp_slug\";s:40:\"newsletter-speedcontrol/speedcontrol.php\";}i:3;O:8:\"stdClass\":13:{s:2:\"id\";s:3:\"108\";s:8:\"category\";s:12:\"subscription\";s:7:\"version\";s:5:\"1.2.0\";s:5:\"title\";s:16:\"Forminator Addon\";s:11:\"description\";s:41:\"Collect subscribers using Formnator forms\";s:4:\"slug\";s:21:\"newsletter-forminator\";s:4:\"type\";s:11:\"integration\";s:3:\"url\";s:43:\"https://www.thenewsletterplugin.com/premium\";s:5:\"image\";s:85:\"https://www.thenewsletterplugin.com/wp-content/uploads/2023/10/forminator-32x32-1.png\";s:4:\"free\";b:0;s:12:\"downloadable\";b:0;s:12:\"download_url\";s:85:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=108\";s:7:\"wp_slug\";s:36:\"newsletter-forminator/forminator.php\";}i:4;O:8:\"stdClass\":13:{s:2:\"id\";s:3:\"110\";s:8:\"category\";s:12:\"subscription\";s:7:\"version\";s:5:\"1.1.3\";s:5:\"title\";s:25:\"Paid Membership Pro Addon\";s:11:\"description\";s:58:\"Collect subscribers and connect lists to membership levels\";s:4:\"slug\";s:16:\"newsletter-pmpro\";s:4:\"type\";s:11:\"integration\";s:3:\"url\";s:43:\"https://www.thenewsletterplugin.com/premium\";s:5:\"image\";s:72:\"https://www.thenewsletterplugin.com/wp-content/uploads/2023/11/pmpro.png\";s:4:\"free\";b:0;s:12:\"downloadable\";b:0;s:12:\"download_url\";s:85:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=110\";s:7:\"wp_slug\";s:26:\"newsletter-pmpro/pmpro.php\";}i:5;O:8:\"stdClass\":13:{s:2:\"id\";s:3:\"111\";s:8:\"category\";s:12:\"subscription\";s:7:\"version\";s:5:\"1.2.3\";s:5:\"title\";s:27:\"Ultimate Member Integration\";s:11:\"description\";s:87:\"Create subscriber on registration and manage the in/out from lists based on user roles.\";s:4:\"slug\";s:25:\"newsletter-ultimatemember\";s:4:\"type\";s:11:\"integration\";s:3:\"url\";s:43:\"https://www.thenewsletterplugin.com/premium\";s:5:\"image\";s:81:\"https://www.thenewsletterplugin.com/wp-content/uploads/2023/11/ultimatemember.png\";s:4:\"free\";b:0;s:12:\"downloadable\";b:0;s:12:\"download_url\";s:85:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=111\";s:7:\"wp_slug\";s:44:\"newsletter-ultimatemember/ultimatemember.php\";}i:6;O:8:\"stdClass\":13:{s:2:\"id\";s:3:\"112\";s:8:\"category\";s:8:\"delivery\";s:7:\"version\";s:5:\"1.1.8\";s:5:\"title\";s:7:\"SMTP2Go\";s:11:\"description\";s:73:\"Send emails and automatically process bounces and complaints with SMTP2Go\";s:4:\"slug\";s:18:\"newsletter-smtp2go\";s:4:\"type\";s:9:\"delivery \";s:3:\"url\";s:43:\"https://www.thenewsletterplugin.com/account\";s:5:\"image\";s:85:\"https://cdn.thenewsletterplugin.com/extensions/design-32px-outline_newsletter-dev.png\";s:4:\"free\";b:1;s:12:\"downloadable\";b:1;s:12:\"download_url\";s:85:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=112\";s:7:\"wp_slug\";s:30:\"newsletter-smtp2go/smtp2go.php\";}i:7;O:8:\"stdClass\":13:{s:2:\"id\";s:3:\"113\";s:8:\"category\";s:12:\"subscription\";s:7:\"version\";s:5:\"1.0.9\";s:5:\"title\";s:23:\"WP User Pro Integration\";s:11:\"description\";s:31:\"Connect subscribers to WP users\";s:4:\"slug\";s:21:\"newsletter-wpuserspro\";s:4:\"type\";s:11:\"integration\";s:3:\"url\";s:43:\"https://www.thenewsletterplugin.com/wpusers\";s:5:\"image\";s:82:\"https://www.thenewsletterplugin.com/wp-content/uploads/2023/03/wpusers-32x32-1.png\";s:4:\"free\";b:0;s:12:\"downloadable\";b:0;s:12:\"download_url\";s:85:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=113\";s:7:\"wp_slug\";s:36:\"newsletter-wpuserspro/wpuserspro.php\";}i:8;O:8:\"stdClass\":13:{s:2:\"id\";s:2:\"61\";s:8:\"category\";s:12:\"subscription\";s:7:\"version\";s:5:\"4.4.9\";s:5:\"title\";s:22:\"Contact Form 7 Connect\";s:11:\"description\";s:52:\"Collect subscribers with your Contact Form 7 plugin.\";s:4:\"slug\";s:14:\"newsletter-cf7\";s:4:\"type\";s:11:\"integration\";s:3:\"url\";s:95:\"https://www.thenewsletterplugin.com/documentation/addons/integrations/contact-form-7-extension/\";s:5:\"image\";s:86:\"https://www.thenewsletterplugin.com/wp-content/uploads/2023/10/contact-form-7-icon.png\";s:4:\"free\";b:0;s:12:\"downloadable\";b:0;s:12:\"download_url\";s:84:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=61\";s:7:\"wp_slug\";s:22:\"newsletter-cf7/cf7.php\";}i:9;O:8:\"stdClass\":13:{s:2:\"id\";s:3:\"101\";s:8:\"category\";s:12:\"subscription\";s:7:\"version\";s:5:\"1.2.2\";s:5:\"title\";s:21:\"Gravity Forms Connect\";s:11:\"description\";s:51:\"Collect subscribers with your Gravity Forms plugin.\";s:4:\"slug\";s:23:\"newsletter-gravityforms\";s:4:\"type\";s:11:\"integration\";s:3:\"url\";s:93:\"https://www.thenewsletterplugin.com/documentation/addons/integrations/gravityforms-extension/\";s:5:\"image\";s:79:\"https://www.thenewsletterplugin.com/wp-content/uploads/2021/04/gravityforms.png\";s:4:\"free\";b:0;s:12:\"downloadable\";b:0;s:12:\"download_url\";s:85:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=101\";s:7:\"wp_slug\";s:40:\"newsletter-gravityforms/gravityforms.php\";}i:10;O:8:\"stdClass\":13:{s:2:\"id\";s:2:\"83\";s:8:\"category\";s:12:\"subscription\";s:7:\"version\";s:5:\"1.2.8\";s:5:\"title\";s:19:\"Ninja Forms Connect\";s:11:\"description\";s:85:\"Integrate Ninja Forms with Newsletter collecting subscription from your contact form.\";s:4:\"slug\";s:21:\"newsletter-ninjaforms\";s:4:\"type\";s:11:\"integration\";s:3:\"url\";s:91:\"https://www.thenewsletterplugin.com/documentation/addons/integrations/ninjaforms-extension/\";s:5:\"image\";s:77:\"https://www.thenewsletterplugin.com/wp-content/uploads/2021/08/ninjaforms.png\";s:4:\"free\";b:0;s:12:\"downloadable\";b:0;s:12:\"download_url\";s:84:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=83\";s:7:\"wp_slug\";s:36:\"newsletter-ninjaforms/ninjaforms.php\";}i:11;O:8:\"stdClass\":13:{s:2:\"id\";s:2:\"84\";s:8:\"category\";s:12:\"subscription\";s:7:\"version\";s:5:\"1.4.0\";s:5:\"title\";s:16:\"WP Forms Connect\";s:11:\"description\";s:46:\"Collect subscribers with your WP Forms plugin.\";s:4:\"slug\";s:18:\"newsletter-wpforms\";s:4:\"type\";s:11:\"integration\";s:3:\"url\";s:88:\"https://www.thenewsletterplugin.com/documentation/addons/integrations/wpforms-extension/\";s:5:\"image\";s:74:\"https://www.thenewsletterplugin.com/wp-content/uploads/2021/08/wpforms.png\";s:4:\"free\";b:0;s:12:\"downloadable\";b:0;s:12:\"download_url\";s:84:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=84\";s:7:\"wp_slug\";s:30:\"newsletter-wpforms/wpforms.php\";}i:12;O:8:\"stdClass\":13:{s:2:\"id\";s:2:\"99\";s:8:\"category\";s:12:\"subscription\";s:7:\"version\";s:5:\"1.1.9\";s:5:\"title\";s:21:\"Elementor Forms Addon\";s:11:\"description\";s:99:\"Integrates Elementor forms with Newsletter to collect subscription by forms created with Elementor.\";s:4:\"slug\";s:20:\"newsletter-elementor\";s:4:\"type\";s:11:\"integration\";s:3:\"url\";s:90:\"https://www.thenewsletterplugin.com/documentation/addons/integrations/elementor-extension/\";s:5:\"image\";s:76:\"https://www.thenewsletterplugin.com/wp-content/uploads/2021/04/elementor.png\";s:4:\"free\";b:0;s:12:\"downloadable\";b:0;s:12:\"download_url\";s:84:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=99\";s:7:\"wp_slug\";s:34:\"newsletter-elementor/elementor.php\";}i:13;O:8:\"stdClass\":13:{s:2:\"id\";s:3:\"109\";s:8:\"category\";s:11:\"newsletters\";s:7:\"version\";s:5:\"1.0.9\";s:5:\"title\";s:20:\"AI Assistant (alpha)\";s:11:\"description\";s:52:\"Get help with email subjects by AI Assistant (alpha=\";s:4:\"slug\";s:13:\"newsletter-ai\";s:4:\"type\";s:9:\"extension\";s:3:\"url\";s:43:\"https://www.thenewsletterplugin.com/account\";s:5:\"image\";s:80:\"https://www.thenewsletterplugin.com/wp-content/uploads/2023/11/newsletter-ai.png\";s:4:\"free\";b:1;s:12:\"downloadable\";b:1;s:12:\"download_url\";s:85:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=109\";s:7:\"wp_slug\";s:20:\"newsletter-ai/ai.php\";}i:14;O:8:\"stdClass\":13:{s:2:\"id\";s:2:\"60\";s:8:\"category\";s:8:\"delivery\";s:7:\"version\";s:5:\"1.6.1\";s:5:\"title\";s:10:\"Amazon SES\";s:11:\"description\";s:94:\"Send emails and automatically process bounces and complaints with Amazon Simple Email Service.\";s:4:\"slug\";s:17:\"newsletter-amazon\";s:4:\"type\";s:8:\"delivery\";s:3:\"url\";s:94:\"https://www.thenewsletterplugin.com/documentation/addons/delivery-addons/amazon-ses-extension/\";s:5:\"image\";s:85:\"https://cdn.thenewsletterplugin.com/extensions/design-32px-outline_newsletter-dev.png\";s:4:\"free\";b:0;s:12:\"downloadable\";b:0;s:12:\"download_url\";s:84:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=60\";s:7:\"wp_slug\";s:28:\"newsletter-amazon/amazon.php\";}i:15;O:8:\"stdClass\":13:{s:2:\"id\";s:3:\"107\";s:8:\"category\";s:12:\"subscription\";s:7:\"version\";s:5:\"1.1.7\";s:5:\"title\";s:24:\"Formidable Forms Connect\";s:11:\"description\";s:42:\"Collect subscribers using Formidable Forms\";s:4:\"slug\";s:21:\"newsletter-formidable\";s:4:\"type\";s:11:\"integration\";s:3:\"url\";s:43:\"https://www.thenewsletterplugin.com/premium\";s:5:\"image\";s:82:\"https://www.thenewsletterplugin.com/wp-content/uploads/2023/10/formidable-logo.png\";s:4:\"free\";b:0;s:12:\"downloadable\";b:0;s:12:\"download_url\";s:85:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=107\";s:7:\"wp_slug\";s:36:\"newsletter-formidable/formidable.php\";}i:16;O:8:\"stdClass\":13:{s:2:\"id\";s:3:\"104\";s:8:\"category\";s:12:\"subscription\";s:7:\"version\";s:5:\"1.1.3\";s:5:\"title\";s:13:\"Form Designer\";s:11:\"description\";s:38:\"Visual designer for subscription forms\";s:4:\"slug\";s:16:\"newsletter-forms\";s:4:\"type\";s:9:\"extension\";s:3:\"url\";s:43:\"https://www.thenewsletterplugin.com/account\";s:5:\"image\";s:91:\"https://www.thenewsletterplugin.com/wp-content/uploads/2023/02/forms-addon-icon-32x32-1.png\";s:4:\"free\";b:1;s:12:\"downloadable\";b:1;s:12:\"download_url\";s:85:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=104\";s:7:\"wp_slug\";s:26:\"newsletter-forms/forms.php\";}i:17;O:8:\"stdClass\":13:{s:2:\"id\";s:3:\"116\";s:8:\"category\";s:8:\"delivery\";s:7:\"version\";s:5:\"1.1.0\";s:5:\"title\";s:20:\"PostMark Integration\";s:11:\"description\";s:52:\"Send newsletters using the PostMark delivery service\";s:4:\"slug\";s:19:\"newsletter-postmark\";s:4:\"type\";s:8:\"delivery\";s:3:\"url\";s:43:\"https://www.thenewsletterplugin.com/premium\";s:5:\"image\";s:83:\"https://www.thenewsletterplugin.com/wp-content/uploads/2024/09/postmark-32x32-1.png\";s:4:\"free\";b:0;s:12:\"downloadable\";b:0;s:12:\"download_url\";s:85:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=116\";s:7:\"wp_slug\";s:32:\"newsletter-postmark/postmark.php\";}i:18;O:8:\"stdClass\":13:{s:2:\"id\";s:3:\"125\";s:8:\"category\";s:11:\"newsletters\";s:7:\"version\";s:5:\"1.0.3\";s:5:\"title\";s:16:\"WP Event Manager\";s:11:\"description\";s:44:\"Integration with the WP Event Manager plugin\";s:4:\"slug\";s:25:\"newsletter-wpeventmanager\";s:4:\"type\";s:11:\"integration\";s:3:\"url\";s:43:\"https://www.thenewsletterplugin.com/premium\";s:5:\"image\";s:89:\"https://www.thenewsletterplugin.com/wp-content/uploads/2025/09/wpeventmanager-32x32-1.png\";s:4:\"free\";b:0;s:12:\"downloadable\";b:0;s:12:\"download_url\";s:85:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=125\";s:7:\"wp_slug\";s:44:\"newsletter-wpeventmanager/wpeventmanager.php\";}i:19;O:8:\"stdClass\":13:{s:2:\"id\";s:2:\"65\";s:8:\"category\";s:8:\"delivery\";s:7:\"version\";s:5:\"4.3.3\";s:5:\"title\";s:7:\"Mailgun\";s:11:\"description\";s:59:\"Send emails and automatically process bounces with Mailgun.\";s:4:\"slug\";s:18:\"newsletter-mailgun\";s:4:\"type\";s:8:\"delivery\";s:3:\"url\";s:91:\"https://www.thenewsletterplugin.com/documentation/addons/delivery-addons/mailgun-extension/\";s:5:\"image\";s:85:\"https://cdn.thenewsletterplugin.com/extensions/design-32px-outline_newsletter-dev.png\";s:4:\"free\";b:0;s:12:\"downloadable\";b:0;s:12:\"download_url\";s:84:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=65\";s:7:\"wp_slug\";s:30:\"newsletter-mailgun/mailgun.php\";}i:20;O:8:\"stdClass\":13:{s:2:\"id\";s:2:\"48\";s:8:\"category\";s:8:\"delivery\";s:7:\"version\";s:5:\"4.5.1\";s:5:\"title\";s:8:\"SendGrid\";s:11:\"description\";s:60:\"Send emails and automatically process bounces with SendGrid.\";s:4:\"slug\";s:19:\"newsletter-sendgrid\";s:4:\"type\";s:8:\"delivery\";s:3:\"url\";s:92:\"https://www.thenewsletterplugin.com/documentation/addons/delivery-addons/sendgrid-extension/\";s:5:\"image\";s:85:\"https://cdn.thenewsletterplugin.com/extensions/design-32px-outline_newsletter-dev.png\";s:4:\"free\";b:0;s:12:\"downloadable\";b:0;s:12:\"download_url\";s:84:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=48\";s:7:\"wp_slug\";s:32:\"newsletter-sendgrid/sendgrid.php\";}i:21;O:8:\"stdClass\":13:{s:2:\"id\";s:2:\"52\";s:8:\"category\";s:8:\"delivery\";s:7:\"version\";s:5:\"4.2.6\";s:5:\"title\";s:7:\"Mailjet\";s:11:\"description\";s:59:\"Send emails and automatically process bounces with Mailjet.\";s:4:\"slug\";s:18:\"newsletter-mailjet\";s:4:\"type\";s:8:\"delivery\";s:3:\"url\";s:91:\"https://www.thenewsletterplugin.com/documentation/addons/delivery-addons/mailjet-extension/\";s:5:\"image\";s:85:\"https://cdn.thenewsletterplugin.com/extensions/design-32px-outline_newsletter-dev.png\";s:4:\"free\";b:0;s:12:\"downloadable\";b:0;s:12:\"download_url\";s:84:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=52\";s:7:\"wp_slug\";s:30:\"newsletter-mailjet/mailjet.php\";}i:22;O:8:\"stdClass\":13:{s:2:\"id\";s:3:\"105\";s:8:\"category\";s:12:\"subscription\";s:7:\"version\";s:5:\"1.1.8\";s:5:\"title\";s:20:\"Fluent Forms Connect\";s:11:\"description\";s:50:\"Collect subscribers with your Fluent Forms plugin.\";s:4:\"slug\";s:22:\"newsletter-fluentforms\";s:4:\"type\";s:11:\"integration\";s:3:\"url\";s:43:\"https://www.thenewsletterplugin.com/premium\";s:5:\"image\";s:86:\"https://www.thenewsletterplugin.com/wp-content/uploads/2023/03/fluentforms-32x32-1.png\";s:4:\"free\";b:0;s:12:\"downloadable\";b:0;s:12:\"download_url\";s:85:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=105\";s:7:\"wp_slug\";s:38:\"newsletter-fluentforms/fluentforms.php\";}i:23;O:8:\"stdClass\":13:{s:2:\"id\";s:2:\"66\";s:8:\"category\";s:8:\"delivery\";s:7:\"version\";s:5:\"1.2.8\";s:5:\"title\";s:12:\"ElasticEmail\";s:11:\"description\";s:64:\"Send emails and automatically process bounces with ElasticEmail.\";s:4:\"slug\";s:23:\"newsletter-elasticemail\";s:4:\"type\";s:8:\"delivery\";s:3:\"url\";s:96:\"https://www.thenewsletterplugin.com/documentation/addons/delivery-addons/elasticemail-extension/\";s:5:\"image\";s:85:\"https://cdn.thenewsletterplugin.com/extensions/design-32px-outline_newsletter-dev.png\";s:4:\"free\";b:0;s:12:\"downloadable\";b:0;s:12:\"download_url\";s:84:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=66\";s:7:\"wp_slug\";s:40:\"newsletter-elasticemail/elasticemail.php\";}i:24;O:8:\"stdClass\":13:{s:2:\"id\";s:2:\"69\";s:8:\"category\";s:8:\"delivery\";s:7:\"version\";s:5:\"1.2.8\";s:5:\"title\";s:9:\"SparkPost\";s:11:\"description\";s:61:\"Send emails and automatically process bounces with SparkPost.\";s:4:\"slug\";s:20:\"newsletter-sparkpost\";s:4:\"type\";s:8:\"delivery\";s:3:\"url\";s:93:\"https://www.thenewsletterplugin.com/documentation/addons/delivery-addons/sparkpost-extension/\";s:5:\"image\";s:85:\"https://cdn.thenewsletterplugin.com/extensions/design-32px-outline_newsletter-dev.png\";s:4:\"free\";b:0;s:12:\"downloadable\";b:0;s:12:\"download_url\";s:84:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=69\";s:7:\"wp_slug\";s:34:\"newsletter-sparkpost/sparkpost.php\";}i:25;O:8:\"stdClass\":13:{s:2:\"id\";s:2:\"72\";s:8:\"category\";s:10:\"automation\";s:7:\"version\";s:5:\"1.6.3\";s:5:\"title\";s:13:\"Autoresponder\";s:11:\"description\";s:94:\"Create unlimited email series to follow-up your subscribers. Lessons, up-sells, conversations.\";s:4:\"slug\";s:24:\"newsletter-autoresponder\";s:4:\"type\";s:9:\"extension\";s:3:\"url\";s:49:\"https://www.thenewsletterplugin.com/autoresponder\";s:5:\"image\";s:79:\"https://cdn.thenewsletterplugin.com/extensions/emoticons-32px-outline_robot.png\";s:4:\"free\";b:0;s:12:\"downloadable\";b:0;s:12:\"download_url\";s:84:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=72\";s:7:\"wp_slug\";s:42:\"newsletter-autoresponder/autoresponder.php\";}i:26;O:8:\"stdClass\":13:{s:2:\"id\";s:3:\"124\";s:8:\"category\";s:8:\"delivery\";s:7:\"version\";s:5:\"1.0.7\";s:5:\"title\";s:20:\"SMTP.com Integration\";s:11:\"description\";s:46:\"Integration with the delivery service SMTP.com\";s:4:\"slug\";s:18:\"newsletter-smtpcom\";s:4:\"type\";s:8:\"delivery\";s:3:\"url\";s:91:\"https://www.thenewsletterplugin.com/documentation/addons/delivery-addons/smtpcom-extension/\";s:5:\"image\";s:76:\"https://www.thenewsletterplugin.com/wp-content/uploads/2025/05/smtpcom-1.png\";s:4:\"free\";b:1;s:12:\"downloadable\";b:1;s:12:\"download_url\";s:85:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=124\";s:7:\"wp_slug\";s:30:\"newsletter-smtpcom/smtpcom.php\";}i:27;O:8:\"stdClass\":13:{s:2:\"id\";s:3:\"122\";s:8:\"category\";s:8:\"delivery\";s:7:\"version\";s:5:\"1.0.5\";s:5:\"title\";s:21:\"SendPulse Integration\";s:11:\"description\";s:36:\"Integrates Newsletter with SendPulse\";s:4:\"slug\";s:20:\"newsletter-sendpulse\";s:4:\"type\";s:9:\"delivery \";s:3:\"url\";s:83:\"https://www.thenewsletterplugin.com/documentation/addons/delivery-addons/sendpulse/\";s:5:\"image\";s:84:\"https://www.thenewsletterplugin.com/wp-content/uploads/2025/03/sendpulse-32x32-1.png\";s:4:\"free\";b:1;s:12:\"downloadable\";b:1;s:12:\"download_url\";s:85:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=122\";s:7:\"wp_slug\";s:34:\"newsletter-sendpulse/sendpulse.php\";}i:28;O:8:\"stdClass\":13:{s:2:\"id\";s:2:\"50\";s:8:\"category\";s:10:\"statistics\";s:7:\"version\";s:5:\"4.7.0\";s:5:\"title\";s:23:\"Reports and Retargeting\";s:11:\"description\";s:104:\"Detailed statistics of your campaign (opens, clicks, URLs) and retargeting based on subscriber behavior.\";s:4:\"slug\";s:18:\"newsletter-reports\";s:4:\"type\";s:9:\"extension\";s:3:\"url\";s:43:\"https://www.thenewsletterplugin.com/reports\";s:5:\"image\";s:85:\"https://cdn.thenewsletterplugin.com/extensions/business-32px-outline_chart-bar-33.png\";s:4:\"free\";b:0;s:12:\"downloadable\";b:0;s:12:\"download_url\";s:84:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=50\";s:7:\"wp_slug\";s:30:\"newsletter-reports/reports.php\";}i:29;O:8:\"stdClass\":13:{s:2:\"id\";s:2:\"62\";s:8:\"category\";s:10:\"automation\";s:7:\"version\";s:5:\"4.8.6\";s:5:\"title\";s:9:\"Automated\";s:11:\"description\";s:98:\"Automatically creates periodic newsletters with your blog content (posts, products, events, CPTs).\";s:4:\"slug\";s:20:\"newsletter-automated\";s:4:\"type\";s:9:\"extension\";s:3:\"url\";s:45:\"https://www.thenewsletterplugin.com/automated\";s:5:\"image\";s:79:\"https://www.thenewsletterplugin.com/wp-content/uploads/2021/03/automated-32.png\";s:4:\"free\";b:0;s:12:\"downloadable\";b:0;s:12:\"download_url\";s:84:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=62\";s:7:\"wp_slug\";s:34:\"newsletter-automated/automated.php\";}i:30;O:8:\"stdClass\":13:{s:2:\"id\";s:2:\"63\";s:8:\"category\";s:25:\"newsletters, subscription\";s:7:\"version\";s:5:\"2.0.0\";s:5:\"title\";s:11:\"WooCommerce\";s:11:\"description\";s:113:\"Subscribe on checkout, subscribers import, segmentation by cart products, and newsletter composer products block.\";s:4:\"slug\";s:22:\"newsletter-woocommerce\";s:4:\"type\";s:11:\"integration\";s:3:\"url\";s:47:\"https://www.thenewsletterplugin.com/woocommerce\";s:5:\"image\";s:93:\"https://www.thenewsletterplugin.com/wp-content/uploads/2018/03/woocommerce-extension-icon.png\";s:4:\"free\";b:0;s:12:\"downloadable\";b:0;s:12:\"download_url\";s:84:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=63\";s:7:\"wp_slug\";s:38:\"newsletter-woocommerce/woocommerce.php\";}i:31;O:8:\"stdClass\":13:{s:2:\"id\";s:2:\"90\";s:8:\"category\";s:8:\"delivery\";s:7:\"version\";s:5:\"1.3.0\";s:5:\"title\";s:27:\"Brevo (formerly Sendinblue)\";s:11:\"description\";s:94:\"Send emails and automatically process bounces and complaints with Brevo (formerly Sendinblue).\";s:4:\"slug\";s:21:\"newsletter-sendinblue\";s:4:\"type\";s:8:\"delivery\";s:3:\"url\";s:94:\"https://www.thenewsletterplugin.com/documentation/addons/delivery-addons/sendinblue-extension/\";s:5:\"image\";s:85:\"https://cdn.thenewsletterplugin.com/extensions/design-32px-outline_newsletter-dev.png\";s:4:\"free\";b:1;s:12:\"downloadable\";b:1;s:12:\"download_url\";s:84:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=90\";s:7:\"wp_slug\";s:36:\"newsletter-sendinblue/sendinblue.php\";}i:32;O:8:\"stdClass\":13:{s:2:\"id\";s:2:\"74\";s:8:\"category\";s:11:\"newsletters\";s:7:\"version\";s:5:\"1.6.3\";s:5:\"title\";s:24:\"Extended Composer Blocks\";s:11:\"description\";s:76:\"Adds new blocks to the newsletter composer: list, video, gallery, full post.\";s:4:\"slug\";s:17:\"newsletter-blocks\";s:4:\"type\";s:9:\"extension\";s:3:\"url\";s:44:\"https://www.thenewsletterplugin.com/composer\";s:5:\"image\";s:91:\"https://www.thenewsletterplugin.com/wp-content/uploads/2017/04/ui-32px-outline-3_widget.png\";s:4:\"free\";b:0;s:12:\"downloadable\";b:0;s:12:\"download_url\";s:84:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=74\";s:7:\"wp_slug\";s:28:\"newsletter-blocks/blocks.php\";}i:33;O:8:\"stdClass\":13:{s:2:\"id\";s:2:\"75\";s:8:\"category\";s:10:\"statistics\";s:7:\"version\";s:5:\"1.3.3\";s:5:\"title\";s:11:\"Geolocation\";s:11:\"description\";s:74:\"Geolocate the subscribers and target them by geolocation in your campaign.\";s:4:\"slug\";s:14:\"newsletter-geo\";s:4:\"type\";s:9:\"extension\";s:3:\"url\";s:97:\"https://www.thenewsletterplugin.com/documentation/addons/extended-features/geolocation-extension/\";s:5:\"image\";s:85:\"https://www.thenewsletterplugin.com/wp-content/uploads/2018/03/geo-extension-icon.png\";s:4:\"free\";b:0;s:12:\"downloadable\";b:0;s:12:\"download_url\";s:84:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=75\";s:7:\"wp_slug\";s:22:\"newsletter-geo/geo.php\";}i:34;O:8:\"stdClass\":13:{s:2:\"id\";s:2:\"77\";s:8:\"category\";s:5:\"tools\";s:7:\"version\";s:5:\"2.5.1\";s:5:\"title\";s:14:\"Newsletter API\";s:11:\"description\";s:64:\"Access programmatically to The Newsletter Plugin via REST calls.\";s:4:\"slug\";s:14:\"newsletter-api\";s:4:\"type\";s:9:\"extension\";s:3:\"url\";s:78:\"https://www.thenewsletterplugin.com/documentation/developers/newsletter-api-2/\";s:5:\"image\";s:86:\"https://www.thenewsletterplugin.com/wp-content/uploads/2017/10/bold-direction@2x-1.png\";s:4:\"free\";b:1;s:12:\"downloadable\";b:1;s:12:\"download_url\";s:84:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=77\";s:7:\"wp_slug\";s:22:\"newsletter-api/api.php\";}i:35;O:8:\"stdClass\":13:{s:2:\"id\";s:2:\"85\";s:8:\"category\";s:0:\"\";s:7:\"version\";s:5:\"1.3.9\";s:5:\"title\";s:14:\"Addons Manager\";s:11:\"description\";s:0:\"\";s:4:\"slug\";s:21:\"newsletter-extensions\";s:4:\"type\";s:7:\"manager\";s:3:\"url\";s:43:\"https://www.thenewsletterplugin.com/account\";s:5:\"image\";s:0:\"\";s:4:\"free\";b:1;s:12:\"downloadable\";b:1;s:12:\"download_url\";s:84:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=85\";s:7:\"wp_slug\";s:36:\"newsletter-extensions/extensions.php\";}i:36;O:8:\"stdClass\":13:{s:2:\"id\";s:2:\"68\";s:8:\"category\";s:10:\"statistics\";s:7:\"version\";s:5:\"1.3.1\";s:5:\"title\";s:16:\"Google Analytics\";s:11:\"description\";s:65:\"Automatically add Google Analytics UTM campaign tracking to links\";s:4:\"slug\";s:20:\"newsletter-analytics\";s:4:\"type\";s:9:\"extension\";s:3:\"url\";s:52:\"https://www.thenewsletterplugin.com/google-analytics\";s:5:\"image\";s:76:\"https://www.thenewsletterplugin.com/wp-content/uploads/2021/08/analytics.png\";s:4:\"free\";b:0;s:12:\"downloadable\";b:0;s:12:\"download_url\";s:84:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=68\";s:7:\"wp_slug\";s:34:\"newsletter-analytics/analytics.php\";}i:37;O:8:\"stdClass\":13:{s:2:\"id\";s:3:\"100\";s:8:\"category\";s:25:\"subscription, newsletters\";s:7:\"version\";s:5:\"1.1.0\";s:5:\"title\";s:22:\"Easy Digital Downloads\";s:11:\"description\";s:61:\"Subscribe on checkout and newsletter composer products block.\";s:4:\"slug\";s:14:\"newsletter-edd\";s:4:\"type\";s:11:\"integration\";s:3:\"url\";s:84:\"https://www.thenewsletterplugin.com/documentation/addons/integrations/edd-extension/\";s:5:\"image\";s:70:\"https://www.thenewsletterplugin.com/wp-content/uploads/2021/08/edd.png\";s:4:\"free\";b:0;s:12:\"downloadable\";b:0;s:12:\"download_url\";s:85:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=100\";s:7:\"wp_slug\";s:22:\"newsletter-edd/edd.php\";}i:38;O:8:\"stdClass\":13:{s:2:\"id\";s:2:\"88\";s:8:\"category\";s:11:\"newsletters\";s:7:\"version\";s:5:\"1.5.4\";s:5:\"title\";s:30:\"The Events Calendar (by Tribe)\";s:11:\"description\";s:85:\"Adds a composer block that extracts the events managed by The Events Calendar plugin.\";s:4:\"slug\";s:22:\"newsletter-tribeevents\";s:4:\"type\";s:11:\"integration\";s:3:\"url\";s:92:\"https://www.thenewsletterplugin.com/documentation/addons/integrations/tribeevents-extension/\";s:5:\"image\";s:92:\"https://www.thenewsletterplugin.com/wp-content/uploads/2019/02/tribe-event-calendar-icon.png\";s:4:\"free\";b:0;s:12:\"downloadable\";b:0;s:12:\"download_url\";s:84:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=88\";s:7:\"wp_slug\";s:38:\"newsletter-tribeevents/tribeevents.php\";}i:39;O:8:\"stdClass\":13:{s:2:\"id\";s:3:\"115\";s:8:\"category\";s:11:\"newsletters\";s:7:\"version\";s:5:\"1.1.0\";s:5:\"title\";s:22:\"EventPrime Integration\";s:11:\"description\";s:55:\"Adds a block to insert into newsletters from EventPrime\";s:4:\"slug\";s:21:\"newsletter-eventprime\";s:4:\"type\";s:11:\"integration\";s:3:\"url\";s:43:\"https://www.thenewsletterplugin.com/account\";s:5:\"image\";s:77:\"https://www.thenewsletterplugin.com/wp-content/uploads/2024/09/eventprime.png\";s:4:\"free\";b:1;s:12:\"downloadable\";b:1;s:12:\"download_url\";s:85:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=115\";s:7:\"wp_slug\";s:36:\"newsletter-eventprime/eventprime.php\";}i:40;O:8:\"stdClass\":13:{s:2:\"id\";s:2:\"55\";s:8:\"category\";s:6:\"legacy\";s:7:\"version\";s:5:\"4.1.2\";s:5:\"title\";s:8:\"Facebook\";s:11:\"description\";s:62:\"One click subscription and confirmation with Facebook Connect.\";s:4:\"slug\";s:19:\"newsletter-facebook\";s:4:\"type\";s:11:\"integration\";s:3:\"url\";s:89:\"https://www.thenewsletterplugin.com/documentation/addons/integrations/facebook-extension/\";s:5:\"image\";s:75:\"https://www.thenewsletterplugin.com/wp-content/uploads/2021/08/facebook.png\";s:4:\"free\";b:0;s:12:\"downloadable\";b:0;s:12:\"download_url\";s:84:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=55\";s:7:\"wp_slug\";s:32:\"newsletter-facebook/facebook.php\";}i:41;O:8:\"stdClass\":13:{s:2:\"id\";s:2:\"79\";s:8:\"category\";s:11:\"newsletters\";s:7:\"version\";s:5:\"1.5.0\";s:5:\"title\";s:14:\"Events Manager\";s:11:\"description\";s:84:\"Adds a composer block that extracts the events managed by the Events Manager plugin.\";s:4:\"slug\";s:17:\"newsletter-events\";s:4:\"type\";s:11:\"integration\";s:3:\"url\";s:87:\"https://www.thenewsletterplugin.com/documentation/addons/integrations/events-extension/\";s:5:\"image\";s:86:\"https://www.thenewsletterplugin.com/wp-content/uploads/2019/02/events-manager-icon.png\";s:4:\"free\";b:0;s:12:\"downloadable\";b:0;s:12:\"download_url\";s:84:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=79\";s:7:\"wp_slug\";s:28:\"newsletter-events/events.php\";}i:42;O:8:\"stdClass\":13:{s:2:\"id\";s:2:\"82\";s:8:\"category\";s:5:\"tools\";s:7:\"version\";s:5:\"1.0.3\";s:5:\"title\";s:21:\"Translatepress Bridge\";s:11:\"description\";s:78:\"Enables few multilanguage Newsletter features for who is using Translatepress.\";s:4:\"slug\";s:25:\"newsletter-translatepress\";s:4:\"type\";s:11:\"integration\";s:3:\"url\";s:95:\"https://www.thenewsletterplugin.com/documentation/addons/integrations/translatepress-extension/\";s:5:\"image\";s:81:\"https://www.thenewsletterplugin.com/wp-content/uploads/2018/09/translatepress.png\";s:4:\"free\";b:1;s:12:\"downloadable\";b:1;s:12:\"download_url\";s:84:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=82\";s:7:\"wp_slug\";s:44:\"newsletter-translatepress/translatepress.php\";}i:43;O:8:\"stdClass\":13:{s:2:\"id\";s:2:\"95\";s:8:\"category\";s:8:\"delivery\";s:7:\"version\";s:5:\"1.1.8\";s:5:\"title\";s:10:\"Mailersend\";s:11:\"description\";s:77:\"Send emails and automatically process bounces and complaints with MailerSend.\";s:4:\"slug\";s:21:\"newsletter-mailersend\";s:4:\"type\";s:8:\"delivery\";s:3:\"url\";s:43:\"https://www.thenewsletterplugin.com/account\";s:5:\"image\";s:77:\"https://www.thenewsletterplugin.com/wp-content/uploads/2025/06/mailersend.png\";s:4:\"free\";b:1;s:12:\"downloadable\";b:1;s:12:\"download_url\";s:84:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=95\";s:7:\"wp_slug\";s:36:\"newsletter-mailersend/mailersend.php\";}i:44;O:8:\"stdClass\":13:{s:2:\"id\";s:2:\"86\";s:8:\"category\";s:5:\"tools\";s:7:\"version\";s:5:\"1.6.0\";s:5:\"title\";s:17:\"Import and Export\";s:11:\"description\";s:82:\"An advanced import system with extended profile fields and mapping (beta version).\";s:4:\"slug\";s:17:\"newsletter-import\";s:4:\"type\";s:9:\"extension\";s:3:\"url\";s:91:\"https://www.thenewsletterplugin.com/documentation/addons/extended-features/advanced-import/\";s:5:\"image\";s:65:\"https://cdn.thenewsletterplugin.com/extensions/file-upload-88.png\";s:4:\"free\";b:1;s:12:\"downloadable\";b:1;s:12:\"download_url\";s:84:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=86\";s:7:\"wp_slug\";s:28:\"newsletter-import/import.php\";}i:45;O:8:\"stdClass\":13:{s:2:\"id\";s:2:\"97\";s:8:\"category\";s:5:\"tools\";s:7:\"version\";s:5:\"1.1.1\";s:5:\"title\";s:8:\"Webhooks\";s:11:\"description\";s:85:\"Adds webhooks to trigger external services upon subscription and cancellation events.\";s:4:\"slug\";s:19:\"newsletter-webhooks\";s:4:\"type\";s:9:\"extension\";s:3:\"url\";s:81:\"https://www.thenewsletterplugin.com/documentation/developers/newsletter-webhooks/\";s:5:\"image\";s:86:\"https://www.thenewsletterplugin.com/wp-content/uploads/2017/10/bold-direction@2x-1.png\";s:4:\"free\";b:0;s:12:\"downloadable\";b:0;s:12:\"download_url\";s:84:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=97\";s:7:\"wp_slug\";s:32:\"newsletter-webhooks/webhooks.php\";}i:46;O:8:\"stdClass\":13:{s:2:\"id\";s:2:\"67\";s:8:\"category\";s:12:\"subscription\";s:7:\"version\";s:5:\"1.6.2\";s:5:\"title\";s:5:\"Leads\";s:11:\"description\";s:106:\"Add a popup or a fixed subscription bar to your website and offer your visitors a simple way to subscribe.\";s:4:\"slug\";s:16:\"newsletter-leads\";s:4:\"type\";s:9:\"extension\";s:3:\"url\";s:41:\"https://www.thenewsletterplugin.com/leads\";s:5:\"image\";s:75:\"https://cdn.thenewsletterplugin.com/extensions/ui-32px-outline-3_widget.png\";s:4:\"free\";b:0;s:12:\"downloadable\";b:0;s:12:\"download_url\";s:84:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=67\";s:7:\"wp_slug\";s:26:\"newsletter-leads/leads.php\";}i:47;O:8:\"stdClass\":13:{s:2:\"id\";s:2:\"58\";s:8:\"category\";s:5:\"tools\";s:7:\"version\";s:5:\"4.1.8\";s:5:\"title\";s:14:\"Public Archive\";s:11:\"description\";s:65:\"Generates a public archive of the sent newsletters for your blog.\";s:4:\"slug\";s:18:\"newsletter-archive\";s:4:\"type\";s:9:\"extension\";s:3:\"url\";s:93:\"https://www.thenewsletterplugin.com/documentation/addons/extended-features/archive-extension/\";s:5:\"image\";s:88:\"https://cdn.thenewsletterplugin.com/extensions/files-32px-outline_archive-3d-content.png\";s:4:\"free\";b:1;s:12:\"downloadable\";b:1;s:12:\"download_url\";s:84:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=58\";s:7:\"wp_slug\";s:30:\"newsletter-archive/archive.php\";}i:48;O:8:\"stdClass\":13:{s:2:\"id\";s:2:\"70\";s:8:\"category\";s:12:\"subscription\";s:7:\"version\";s:5:\"1.2.0\";s:5:\"title\";s:20:\"Subscribe on Comment\";s:11:\"description\";s:55:\"Adds the subscription option to your blog comment form.\";s:4:\"slug\";s:19:\"newsletter-comments\";s:4:\"type\";s:11:\"integration\";s:3:\"url\";s:94:\"https://www.thenewsletterplugin.com/documentation/addons/extended-features/comments-extension/\";s:5:\"image\";s:87:\"https://www.thenewsletterplugin.com/wp-content/uploads/2017/02/comment-notification.png\";s:4:\"free\";b:0;s:12:\"downloadable\";b:0;s:12:\"download_url\";s:84:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=70\";s:7:\"wp_slug\";s:32:\"newsletter-comments/comments.php\";}i:49;O:8:\"stdClass\":13:{s:2:\"id\";s:2:\"71\";s:8:\"category\";s:12:\"subscription\";s:7:\"version\";s:5:\"1.2.1\";s:5:\"title\";s:14:\"Locked Content\";s:11:\"description\";s:72:\"Hide premium content in your posts and offer a subscription to see them.\";s:4:\"slug\";s:15:\"newsletter-lock\";s:4:\"type\";s:9:\"extension\";s:3:\"url\";s:100:\"https://www.thenewsletterplugin.com/documentation/addons/extended-features/locked-content-extension/\";s:5:\"image\";s:94:\"https://www.thenewsletterplugin.com/wp-content/uploads/2017/04/ui-32px-outline-1_lock-open.png\";s:4:\"free\";b:1;s:12:\"downloadable\";b:1;s:12:\"download_url\";s:84:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=71\";s:7:\"wp_slug\";s:24:\"newsletter-lock/lock.php\";}i:50;O:8:\"stdClass\":13:{s:2:\"id\";s:2:\"54\";s:8:\"category\";s:3:\"eol\";s:7:\"version\";s:5:\"4.1.3\";s:5:\"title\";s:8:\"Followup\";s:11:\"description\";s:67:\"Automated email series sent upon subscription at defined intervals.\";s:4:\"slug\";s:19:\"newsletter-followup\";s:4:\"type\";s:3:\"eol\";s:3:\"url\";s:71:\"https://www.thenewsletterplugin.com/plugins/newsletter/follow-up-module\";s:5:\"image\";s:83:\"https://cdn.thenewsletterplugin.com/extensions/ui-32px-outline-2_time-countdown.png\";s:4:\"free\";b:0;s:12:\"downloadable\";b:0;s:12:\"download_url\";s:84:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=54\";s:7:\"wp_slug\";s:32:\"newsletter-followup/followup.php\";}i:51;O:8:\"stdClass\":13:{s:2:\"id\";s:2:\"53\";s:8:\"category\";s:3:\"eol\";s:7:\"version\";s:5:\"2.2.0\";s:5:\"title\";s:5:\"Popup\";s:11:\"description\";s:60:\"Configurable popup system to increase the subscription rate.\";s:4:\"slug\";s:16:\"newsletter-popup\";s:4:\"type\";s:3:\"eol\";s:3:\"url\";s:67:\"https://www.thenewsletterplugin.com/plugins/newsletter/popup-module\";s:5:\"image\";s:75:\"https://cdn.thenewsletterplugin.com/extensions/ui-32px-outline-3_widget.png\";s:4:\"free\";b:0;s:12:\"downloadable\";b:0;s:12:\"download_url\";s:84:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=53\";s:7:\"wp_slug\";s:26:\"newsletter-popup/popup.php\";}i:52;O:8:\"stdClass\":13:{s:2:\"id\";s:2:\"51\";s:8:\"category\";s:3:\"eol\";s:7:\"version\";s:5:\"4.1.3\";s:5:\"title\";s:12:\"Feed by Mail\";s:11:\"description\";s:71:\"Automatically creates and sends newsletters with the latest blog posts.\";s:4:\"slug\";s:15:\"newsletter-feed\";s:4:\"type\";s:3:\"eol\";s:3:\"url\";s:58:\"https://www.thenewsletterplugin.com/feed-by-mail-extension\";s:5:\"image\";s:77:\"https://cdn.thenewsletterplugin.com/extensions/ui-32px-outline-3_playlist.png\";s:4:\"free\";b:0;s:12:\"downloadable\";b:0;s:12:\"download_url\";s:84:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=51\";s:7:\"wp_slug\";s:24:\"newsletter-feed/feed.php\";}i:53;O:8:\"stdClass\":13:{s:2:\"id\";s:2:\"49\";s:8:\"category\";s:3:\"eol\";s:7:\"version\";s:5:\"4.0.0\";s:5:\"title\";s:8:\"Mandrill\";s:11:\"description\";s:61:\"Integrates the Mandrill delivery system and bounce detection.\";s:4:\"slug\";s:19:\"newsletter-mandrill\";s:4:\"type\";s:3:\"eol\";s:3:\"url\";s:69:\"http://www.thenewsletterplugin.com/plugins/newsletter/mandrill-module\";s:5:\"image\";s:85:\"https://cdn.thenewsletterplugin.com/extensions/design-32px-outline_newsletter-dev.png\";s:4:\"free\";b:0;s:12:\"downloadable\";b:0;s:12:\"download_url\";s:84:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=49\";s:7:\"wp_slug\";s:32:\"newsletter-mandrill/mandrill.php\";}i:54;O:8:\"stdClass\":13:{s:2:\"id\";s:2:\"93\";s:8:\"category\";s:8:\"delivery\";s:7:\"version\";s:5:\"1.2.3\";s:5:\"title\";s:13:\"External SMTP\";s:11:\"description\";s:32:\"Send emails with a generic SMTP.\";s:4:\"slug\";s:15:\"newsletter-smtp\";s:4:\"type\";s:8:\"delivery\";s:3:\"url\";s:88:\"https://www.thenewsletterplugin.com/documentation/addons/delivery-addons/smtp-extension/\";s:5:\"image\";s:85:\"https://cdn.thenewsletterplugin.com/extensions/design-32px-outline_newsletter-dev.png\";s:4:\"free\";b:1;s:12:\"downloadable\";b:1;s:12:\"download_url\";s:84:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=93\";s:7:\"wp_slug\";s:24:\"newsletter-smtp/smtp.php\";}i:55;O:8:\"stdClass\":13:{s:2:\"id\";s:2:\"96\";s:8:\"category\";s:8:\"delivery\";s:7:\"version\";s:5:\"1.0.6\";s:5:\"title\";s:25:\"Office 365 Header Removal\";s:11:\"description\";s:168:\"This addon removes hidden headers from outgoing email to avoid Office365 SMTP block (or attempt to...). Install ONLY if you\'re using Office365 SMTP with an SMTP plugin!\";s:4:\"slug\";s:20:\"newsletter-office365\";s:4:\"type\";s:8:\"delivery\";s:3:\"url\";s:43:\"https://www.thenewsletterplugin.com/account\";s:5:\"image\";s:85:\"https://cdn.thenewsletterplugin.com/extensions/design-32px-outline_newsletter-dev.png\";s:4:\"free\";b:1;s:12:\"downloadable\";b:1;s:12:\"download_url\";s:84:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=96\";s:7:\"wp_slug\";s:34:\"newsletter-office365/office365.php\";}i:56;O:8:\"stdClass\":13:{s:2:\"id\";s:2:\"76\";s:8:\"category\";s:5:\"tools\";s:7:\"version\";s:5:\"1.3.5\";s:5:\"title\";s:17:\"Bounce Management\";s:11:\"description\";s:56:\"Bounce management (only if do not use a delivery addon).\";s:4:\"slug\";s:17:\"newsletter-bounce\";s:4:\"type\";s:9:\"extension\";s:3:\"url\";s:92:\"https://www.thenewsletterplugin.com/documentation/addons/extended-features/bounce-extension/\";s:5:\"image\";s:98:\"https://www.thenewsletterplugin.com/wp-content/uploads/2017/10/ic_settings_backup_restore_32px.png\";s:4:\"free\";b:0;s:12:\"downloadable\";b:0;s:12:\"download_url\";s:84:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=76\";s:7:\"wp_slug\";s:28:\"newsletter-bounce/bounce.php\";}i:57;O:8:\"stdClass\":13:{s:2:\"id\";s:2:\"91\";s:8:\"category\";s:11:\"newsletters\";s:7:\"version\";s:5:\"1.0.3\";s:5:\"title\";s:9:\"Instasend\";s:11:\"description\";s:63:\"Quickly create a newsletter from a post (free for limited time)\";s:4:\"slug\";s:20:\"newsletter-instasend\";s:4:\"type\";s:9:\"extension\";s:3:\"url\";s:85:\"https://www.thenewsletterplugin.com/documentation/addons/extended-features/instasend/\";s:5:\"image\";s:79:\"https://www.thenewsletterplugin.com/wp-content/uploads/2020/05/instasend-32.png\";s:4:\"free\";b:1;s:12:\"downloadable\";b:1;s:12:\"download_url\";s:84:\"http://www.thenewsletterplugin.com/wp-content/plugins/file-commerce-pro/get.php?f=91\";s:7:\"wp_slug\";s:34:\"newsletter-instasend/instasend.php\";}}", "off");
INSERT INTO `wp_options` VALUES("345", "wpcf7", "a:2:{s:7:\"version\";s:5:\"6.0.6\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1749183271;s:7:\"version\";s:5:\"6.0.6\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}", "auto");
INSERT INTO `wp_options` VALUES("346", "tco_wpcf7_contact_form_page_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("348", "avatar_default_wp_user_avatar", "", "auto");
INSERT INTO `wp_options` VALUES("349", "wp_user_avatar_allow_upload", "0", "auto");
INSERT INTO `wp_options` VALUES("350", "wp_user_avatar_disable_um_avatars", "0", "auto");
INSERT INTO `wp_options` VALUES("351", "wp_user_avatar_force_file_uploader", "0", "auto");
INSERT INTO `wp_options` VALUES("352", "wp_user_avatar_disable_gravatar", "0", "auto");
INSERT INTO `wp_options` VALUES("353", "wp_user_avatar_edit_avatar", "1", "auto");
INSERT INTO `wp_options` VALUES("354", "wp_user_avatar_resize_crop", "0", "auto");
INSERT INTO `wp_options` VALUES("355", "wp_user_avatar_resize_h", "96", "auto");
INSERT INTO `wp_options` VALUES("356", "wp_user_avatar_resize_upload", "0", "auto");
INSERT INTO `wp_options` VALUES("357", "wp_user_avatar_resize_w", "96", "auto");
INSERT INTO `wp_options` VALUES("358", "wp_user_avatar_tinymce", "1", "auto");
INSERT INTO `wp_options` VALUES("359", "wp_user_avatar_upload_size_limit", "0", "auto");
INSERT INTO `wp_options` VALUES("360", "widget_wp_user_avatar_profile", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("362", "wp_user_avatar_default_avatar_updated", "1", "auto");
INSERT INTO `wp_options` VALUES("363", "wp_user_avatar_users_updated", "1", "auto");
INSERT INTO `wp_options` VALUES("364", "wp_user_avatar_media_updated", "1", "auto");
INSERT INTO `wp_options` VALUES("365", "newsletter_diagnostic_cron_calls", "a:100:{i:0;i:1763703352;i:1;i:1763789367;i:2;i:1763789389;i:3;i:1763789825;i:4;i:1763829000;i:5;i:1763829250;i:6;i:1763842245;i:7;i:1763853905;i:8;i:1763858870;i:9;i:1763862603;i:10;i:1763863702;i:11;i:1763864150;i:12;i:1763864244;i:13;i:1763864570;i:14;i:1763864822;i:15;i:1763864875;i:16;i:1763865109;i:17;i:1763865453;i:18;i:1763865775;i:19;i:1763865851;i:20;i:1763865952;i:21;i:1763866008;i:22;i:1763866247;i:23;i:1763866470;i:24;i:1763866524;i:25;i:1763866671;i:26;i:1763867250;i:27;i:1763867312;i:28;i:1763867346;i:29;i:1763867568;i:30;i:1763867692;i:31;i:1763867723;i:32;i:1763867953;i:33;i:1763868126;i:34;i:1763868376;i:35;i:1763868591;i:36;i:1763868666;i:37;i:1763868724;i:38;i:1763868783;i:39;i:1763868928;i:40;i:1763868982;i:41;i:1763869025;i:42;i:1763869111;i:43;i:1763869162;i:44;i:1763869518;i:45;i:1763869575;i:46;i:1763869757;i:47;i:1763869907;i:48;i:1763869940;i:49;i:1763869982;i:50;i:1763870450;i:51;i:1763870535;i:52;i:1763870723;i:53;i:1763870933;i:54;i:1763870981;i:55;i:1763871060;i:56;i:1763871145;i:57;i:1763871255;i:58;i:1763872204;i:59;i:1763872417;i:60;i:1763872523;i:61;i:1763872897;i:62;i:1763873013;i:63;i:1763873055;i:64;i:1763873294;i:65;i:1763873536;i:66;i:1763873710;i:67;i:1763873786;i:68;i:1763874189;i:69;i:1763874270;i:70;i:1763874430;i:71;i:1763874539;i:72;i:1763874829;i:73;i:1763874896;i:74;i:1763875115;i:75;i:1763875817;i:76;i:1763875841;i:77;i:1763876282;i:78;i:1763962328;i:79;i:1763962341;i:80;i:1763962806;i:81;i:1764048455;i:82;i:1764048462;i:83;i:1764048938;i:84;i:1764134845;i:85;i:1764134861;i:86;i:1764135279;i:87;i:1764155455;i:88;i:1764155609;i:89;i:1764221195;i:90;i:1764221202;i:91;i:1764221630;i:92;i:1764225189;i:93;i:1764307639;i:94;i:1764307646;i:95;i:1764308105;i:96;i:1764313280;i:97;i:1764313302;i:98;i:1764313362;i:99;i:1764313422;}", "off");
INSERT INTO `wp_options` VALUES("366", "newsletter_lock_engine", "0", "yes");
INSERT INTO `wp_options` VALUES("368", "action_scheduler_hybrid_store_demarkation", "11", "auto");
INSERT INTO `wp_options` VALUES("369", "schema-ActionScheduler_StoreSchema", "7.0.1749183307", "auto");
INSERT INTO `wp_options` VALUES("370", "schema-ActionScheduler_LoggerSchema", "3.0.1749183307", "auto");
INSERT INTO `wp_options` VALUES("373", "woocommerce_newly_installed", "no", "auto");
INSERT INTO `wp_options` VALUES("374", "woocommerce_schema_version", "920", "auto");
INSERT INTO `wp_options` VALUES("375", "woocommerce_store_address", "", "on");
INSERT INTO `wp_options` VALUES("376", "woocommerce_store_address_2", "", "on");
INSERT INTO `wp_options` VALUES("377", "woocommerce_store_city", "", "on");
INSERT INTO `wp_options` VALUES("378", "woocommerce_default_country", "SG", "on");
INSERT INTO `wp_options` VALUES("379", "woocommerce_store_postcode", "", "on");
INSERT INTO `wp_options` VALUES("380", "woocommerce_allowed_countries", "all", "on");
INSERT INTO `wp_options` VALUES("381", "woocommerce_all_except_countries", "", "on");
INSERT INTO `wp_options` VALUES("382", "woocommerce_specific_allowed_countries", "", "on");
INSERT INTO `wp_options` VALUES("383", "woocommerce_ship_to_countries", "", "on");
INSERT INTO `wp_options` VALUES("384", "woocommerce_specific_ship_to_countries", "", "on");
INSERT INTO `wp_options` VALUES("385", "woocommerce_default_customer_address", "base", "on");
INSERT INTO `wp_options` VALUES("386", "woocommerce_calc_taxes", "no", "on");
INSERT INTO `wp_options` VALUES("387", "woocommerce_enable_coupons", "yes", "on");
INSERT INTO `wp_options` VALUES("388", "woocommerce_calc_discounts_sequentially", "no", "off");
INSERT INTO `wp_options` VALUES("389", "woocommerce_currency", "SGD", "on");
INSERT INTO `wp_options` VALUES("390", "woocommerce_currency_pos", "left", "on");
INSERT INTO `wp_options` VALUES("391", "woocommerce_price_thousand_sep", ",", "on");
INSERT INTO `wp_options` VALUES("392", "woocommerce_price_decimal_sep", ".", "on");
INSERT INTO `wp_options` VALUES("393", "woocommerce_price_num_decimals", "2", "on");
INSERT INTO `wp_options` VALUES("394", "woocommerce_shop_page_id", "103", "on");
INSERT INTO `wp_options` VALUES("395", "woocommerce_cart_redirect_after_add", "no", "on");
INSERT INTO `wp_options` VALUES("396", "woocommerce_enable_ajax_add_to_cart", "yes", "on");
INSERT INTO `wp_options` VALUES("397", "woocommerce_placeholder_image", "11", "on");
INSERT INTO `wp_options` VALUES("398", "woocommerce_weight_unit", "kg", "on");
INSERT INTO `wp_options` VALUES("399", "woocommerce_dimension_unit", "cm", "on");
INSERT INTO `wp_options` VALUES("400", "woocommerce_enable_reviews", "yes", "on");
INSERT INTO `wp_options` VALUES("401", "woocommerce_review_rating_verification_label", "yes", "off");
INSERT INTO `wp_options` VALUES("402", "woocommerce_review_rating_verification_required", "no", "off");
INSERT INTO `wp_options` VALUES("403", "woocommerce_enable_review_rating", "yes", "on");
INSERT INTO `wp_options` VALUES("404", "woocommerce_review_rating_required", "yes", "off");
INSERT INTO `wp_options` VALUES("405", "woocommerce_manage_stock", "yes", "on");
INSERT INTO `wp_options` VALUES("406", "woocommerce_hold_stock_minutes", "60", "off");
INSERT INTO `wp_options` VALUES("407", "woocommerce_notify_low_stock", "yes", "off");
INSERT INTO `wp_options` VALUES("408", "woocommerce_notify_no_stock", "yes", "off");
INSERT INTO `wp_options` VALUES("409", "woocommerce_stock_email_recipient", "selvam@warelycorp.com", "off");
INSERT INTO `wp_options` VALUES("410", "woocommerce_notify_low_stock_amount", "2", "off");
INSERT INTO `wp_options` VALUES("411", "woocommerce_notify_no_stock_amount", "0", "on");
INSERT INTO `wp_options` VALUES("412", "woocommerce_hide_out_of_stock_items", "no", "on");
INSERT INTO `wp_options` VALUES("413", "woocommerce_stock_format", "", "on");
INSERT INTO `wp_options` VALUES("414", "woocommerce_file_download_method", "force", "off");
INSERT INTO `wp_options` VALUES("415", "woocommerce_downloads_redirect_fallback_allowed", "no", "off");
INSERT INTO `wp_options` VALUES("416", "woocommerce_downloads_require_login", "no", "off");
INSERT INTO `wp_options` VALUES("417", "woocommerce_downloads_grant_access_after_payment", "yes", "off");
INSERT INTO `wp_options` VALUES("418", "woocommerce_downloads_deliver_inline", "", "off");
INSERT INTO `wp_options` VALUES("419", "woocommerce_downloads_add_hash_to_filename", "yes", "on");
INSERT INTO `wp_options` VALUES("420", "woocommerce_downloads_count_partial", "yes", "on");
INSERT INTO `wp_options` VALUES("422", "woocommerce_attribute_lookup_direct_updates", "no", "on");
INSERT INTO `wp_options` VALUES("423", "woocommerce_attribute_lookup_optimized_updates", "no", "on");
INSERT INTO `wp_options` VALUES("424", "woocommerce_product_match_featured_image_by_sku", "no", "on");
INSERT INTO `wp_options` VALUES("425", "woocommerce_prices_include_tax", "no", "on");
INSERT INTO `wp_options` VALUES("426", "woocommerce_tax_based_on", "shipping", "on");
INSERT INTO `wp_options` VALUES("427", "woocommerce_shipping_tax_class", "inherit", "on");
INSERT INTO `wp_options` VALUES("428", "woocommerce_tax_round_at_subtotal", "no", "on");
INSERT INTO `wp_options` VALUES("429", "woocommerce_tax_classes", "", "on");
INSERT INTO `wp_options` VALUES("430", "woocommerce_tax_display_shop", "excl", "on");
INSERT INTO `wp_options` VALUES("431", "woocommerce_tax_display_cart", "excl", "on");
INSERT INTO `wp_options` VALUES("432", "woocommerce_price_display_suffix", "", "on");
INSERT INTO `wp_options` VALUES("433", "woocommerce_tax_total_display", "itemized", "off");
INSERT INTO `wp_options` VALUES("434", "woocommerce_enable_shipping_calc", "yes", "off");
INSERT INTO `wp_options` VALUES("435", "woocommerce_shipping_cost_requires_address", "no", "on");
INSERT INTO `wp_options` VALUES("436", "woocommerce_ship_to_destination", "billing", "off");
INSERT INTO `wp_options` VALUES("437", "woocommerce_shipping_debug_mode", "no", "on");
INSERT INTO `wp_options` VALUES("438", "woocommerce_enable_guest_checkout", "yes", "off");
INSERT INTO `wp_options` VALUES("439", "woocommerce_enable_checkout_login_reminder", "no", "off");
INSERT INTO `wp_options` VALUES("440", "woocommerce_enable_signup_and_login_from_checkout", "no", "off");
INSERT INTO `wp_options` VALUES("441", "woocommerce_enable_myaccount_registration", "no", "off");
INSERT INTO `wp_options` VALUES("442", "woocommerce_registration_generate_password", "yes", "off");
INSERT INTO `wp_options` VALUES("443", "woocommerce_registration_generate_username", "yes", "off");
INSERT INTO `wp_options` VALUES("444", "woocommerce_erasure_request_removes_order_data", "no", "off");
INSERT INTO `wp_options` VALUES("445", "woocommerce_erasure_request_removes_download_data", "no", "off");
INSERT INTO `wp_options` VALUES("446", "woocommerce_allow_bulk_remove_personal_data", "no", "off");
INSERT INTO `wp_options` VALUES("447", "woocommerce_registration_privacy_policy_text", "Your personal data will be used to support your experience throughout this website, to manage access to your account, and for other purposes described in our [privacy_policy].", "on");
INSERT INTO `wp_options` VALUES("448", "woocommerce_checkout_privacy_policy_text", "Your personal data will be used to process your order, support your experience throughout this website, and for other purposes described in our [privacy_policy].", "on");
INSERT INTO `wp_options` VALUES("449", "woocommerce_delete_inactive_accounts", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "off");
INSERT INTO `wp_options` VALUES("450", "woocommerce_trash_pending_orders", "", "off");
INSERT INTO `wp_options` VALUES("451", "woocommerce_trash_failed_orders", "", "off");
INSERT INTO `wp_options` VALUES("452", "woocommerce_trash_cancelled_orders", "", "off");
INSERT INTO `wp_options` VALUES("453", "woocommerce_anonymize_refunded_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "off");
INSERT INTO `wp_options` VALUES("454", "woocommerce_anonymize_completed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "off");
INSERT INTO `wp_options` VALUES("455", "woocommerce_email_from_name", "atlascapt", "off");
INSERT INTO `wp_options` VALUES("456", "woocommerce_email_from_address", "selvam@warelycorp.com", "off");
INSERT INTO `wp_options` VALUES("457", "woocommerce_email_header_image", "", "off");
INSERT INTO `wp_options` VALUES("458", "woocommerce_email_base_color", "#32373c", "off");
INSERT INTO `wp_options` VALUES("459", "woocommerce_email_background_color", "#ffffff", "off");
INSERT INTO `wp_options` VALUES("460", "woocommerce_email_body_background_color", "#ffffff", "off");
INSERT INTO `wp_options` VALUES("461", "woocommerce_email_text_color", "#1e1e1e", "off");
INSERT INTO `wp_options` VALUES("462", "woocommerce_email_footer_text", "{site_title} &mdash; Built with {WooCommerce}", "off");
INSERT INTO `wp_options` VALUES("463", "woocommerce_email_footer_text_color", "#787c82", "off");
INSERT INTO `wp_options` VALUES("464", "woocommerce_email_auto_sync_with_theme", "yes", "off");
INSERT INTO `wp_options` VALUES("465", "woocommerce_merchant_email_notifications", "no", "off");
INSERT INTO `wp_options` VALUES("466", "woocommerce_cart_page_id", "104", "off");
INSERT INTO `wp_options` VALUES("467", "woocommerce_checkout_page_id", "105", "off");
INSERT INTO `wp_options` VALUES("468", "woocommerce_myaccount_page_id", "106", "off");
INSERT INTO `wp_options` VALUES("469", "woocommerce_terms_page_id", "", "off");
INSERT INTO `wp_options` VALUES("470", "woocommerce_checkout_pay_endpoint", "order-pay", "on");
INSERT INTO `wp_options` VALUES("471", "woocommerce_checkout_order_received_endpoint", "order-received", "on");
INSERT INTO `wp_options` VALUES("472", "woocommerce_myaccount_add_payment_method_endpoint", "add-payment-method", "on");
INSERT INTO `wp_options` VALUES("473", "woocommerce_myaccount_delete_payment_method_endpoint", "delete-payment-method", "on");
INSERT INTO `wp_options` VALUES("474", "woocommerce_myaccount_set_default_payment_method_endpoint", "set-default-payment-method", "on");
INSERT INTO `wp_options` VALUES("475", "woocommerce_myaccount_orders_endpoint", "orders", "on");
INSERT INTO `wp_options` VALUES("476", "woocommerce_myaccount_view_order_endpoint", "view-order", "on");
INSERT INTO `wp_options` VALUES("477", "woocommerce_myaccount_downloads_endpoint", "downloads", "on");
INSERT INTO `wp_options` VALUES("478", "woocommerce_myaccount_edit_account_endpoint", "edit-account", "on");
INSERT INTO `wp_options` VALUES("479", "woocommerce_myaccount_edit_address_endpoint", "edit-address", "on");
INSERT INTO `wp_options` VALUES("480", "woocommerce_myaccount_payment_methods_endpoint", "payment-methods", "on");
INSERT INTO `wp_options` VALUES("481", "woocommerce_myaccount_lost_password_endpoint", "lost-password", "on");
INSERT INTO `wp_options` VALUES("482", "woocommerce_logout_endpoint", "customer-logout", "on");
INSERT INTO `wp_options` VALUES("483", "woocommerce_api_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("484", "woocommerce_allow_tracking", "yes", "on");
INSERT INTO `wp_options` VALUES("485", "woocommerce_show_marketplace_suggestions", "yes", "off");
INSERT INTO `wp_options` VALUES("486", "woocommerce_custom_orders_table_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("487", "woocommerce_analytics_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("488", "woocommerce_feature_rate_limit_checkout_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("489", "woocommerce_feature_order_attribution_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("490", "woocommerce_feature_site_visibility_badge_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("491", "woocommerce_feature_remote_logging_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("492", "woocommerce_feature_email_improvements_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("493", "woocommerce_email_improvements_disabled_count", "1", "auto");
INSERT INTO `wp_options` VALUES("494", "woocommerce_email_improvements_first_disabled_at", "2025-06-06 04:15:09", "auto");
INSERT INTO `wp_options` VALUES("495", "woocommerce_email_improvements_last_disabled_at", "2025-06-06 04:15:09", "auto");
INSERT INTO `wp_options` VALUES("496", "woocommerce_feature_reactify-classic-payments-settings_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("497", "woocommerce_feature_product_block_editor_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("498", "woocommerce_hpos_fts_index_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("499", "woocommerce_feature_cost_of_goods_sold_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("500", "woocommerce_single_image_width", "600", "on");
INSERT INTO `wp_options` VALUES("501", "woocommerce_thumbnail_image_width", "300", "on");
INSERT INTO `wp_options` VALUES("502", "woocommerce_checkout_highlight_required_fields", "yes", "on");
INSERT INTO `wp_options` VALUES("503", "woocommerce_demo_store", "no", "off");
INSERT INTO `wp_options` VALUES("504", "wc_downloads_approved_directories_mode", "enabled", "auto");
INSERT INTO `wp_options` VALUES("505", "woocommerce_permalinks", "a:5:{s:12:\"product_base\";s:7:\"product\";s:13:\"category_base\";s:16:\"product-category\";s:8:\"tag_base\";s:11:\"product-tag\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}", "auto");
INSERT INTO `wp_options` VALUES("506", "current_theme_supports_woocommerce", "yes", "auto");
INSERT INTO `wp_options` VALUES("507", "woocommerce_queue_flush_rewrite_rules", "no", "auto");
INSERT INTO `wp_options` VALUES("508", "_transient_wc_attribute_taxonomies", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("510", "default_product_cat", "15", "auto");
INSERT INTO `wp_options` VALUES("512", "woocommerce_refund_returns_page_id", "16", "auto");
INSERT INTO `wp_options` VALUES("515", "woocommerce_paypal_settings", "a:23:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:6:\"PayPal\";s:11:\"description\";s:85:\"Pay via PayPal; you can pay with your credit card if you don\'t have a PayPal account.\";s:5:\"email\";s:21:\"selvam@warelycorp.com\";s:8:\"advanced\";s:0:\"\";s:8:\"testmode\";s:2:\"no\";s:5:\"debug\";s:2:\"no\";s:16:\"ipn_notification\";s:3:\"yes\";s:14:\"receiver_email\";s:21:\"selvam@warelycorp.com\";s:14:\"identity_token\";s:0:\"\";s:14:\"invoice_prefix\";s:3:\"WC-\";s:13:\"send_shipping\";s:3:\"yes\";s:16:\"address_override\";s:2:\"no\";s:13:\"paymentaction\";s:4:\"sale\";s:9:\"image_url\";s:0:\"\";s:11:\"api_details\";s:0:\"\";s:12:\"api_username\";s:0:\"\";s:12:\"api_password\";s:0:\"\";s:13:\"api_signature\";s:0:\"\";s:20:\"sandbox_api_username\";s:0:\"\";s:20:\"sandbox_api_password\";s:0:\"\";s:21:\"sandbox_api_signature\";s:0:\"\";s:12:\"_should_load\";s:2:\"no\";}", "on");
INSERT INTO `wp_options` VALUES("516", "woocommerce_version", "9.8.5", "auto");
INSERT INTO `wp_options` VALUES("517", "woocommerce_db_version", "9.8.5", "auto");
INSERT INTO `wp_options` VALUES("518", "woocommerce_store_id", "e14162b2-e519-4d6a-b9ad-df4af19754c1", "auto");
INSERT INTO `wp_options` VALUES("519", "woocommerce_admin_install_timestamp", "1749183310", "auto");
INSERT INTO `wp_options` VALUES("520", "woocommerce_inbox_variant_assignment", "8", "auto");
INSERT INTO `wp_options` VALUES("521", "woocommerce_remote_variant_assignment", "35", "auto");
INSERT INTO `wp_options` VALUES("522", "woocommerce_attribute_lookup_enabled", "no", "auto");
INSERT INTO `wp_options` VALUES("524", "rsssl_404_cache", "a:24:{s:11:\"3.1.130.203\";a:2:{i:11;i:1761013774;i:12;i:1761013775;}s:13:\"164.92.112.64\";a:1:{i:1;i:1749606405;}s:13:\"137.184.47.68\";a:1:{i:0;i:1749659600;}s:12:\"106.51.149.1\";a:1:{i:30;i:1750318157;}s:12:\"167.99.89.11\";a:1:{i:0;i:1750851628;}s:14:\"216.81.248.170\";a:1:{i:0;i:1752198390;}s:13:\"34.142.150.70\";a:1:{i:0;i:1754595900;}s:14:\"35.185.191.154\";a:1:{i:0;i:1754631762;}s:14:\"106.51.151.226\";a:1:{i:12;i:1755156379;}s:13:\"23.162.200.48\";a:1:{i:0;i:1755252371;}s:14:\"34.143.157.214\";a:1:{i:0;i:1755926645;}s:13:\"52.231.100.68\";a:6:{i:111;i:1757496483;i:112;i:1757496484;i:113;i:1757496485;i:114;i:1757496485;i:115;i:1757496486;i:116;i:1757496487;}s:14:\"34.124.207.167\";a:1:{i:0;i:1757585628;}s:14:\"34.143.253.145\";a:1:{i:0;i:1759809930;}s:13:\"45.148.10.245\";a:5:{i:0;i:1759884098;i:1;i:1759884099;i:2;i:1759884100;i:3;i:1759884101;i:4;i:1759884102;}s:12:\"20.168.78.46\";a:4:{i:30;i:1760327598;i:31;i:1760327599;i:32;i:1760327600;i:33;i:1760327602;}s:14:\"20.242.108.110\";a:5:{i:128;i:1760465371;i:129;i:1760465372;i:130;i:1760465373;i:131;i:1760465374;i:132;i:1760465375;}s:12:\"51.75.133.70\";a:1:{i:0;i:1760541992;}s:14:\"205.210.31.199\";a:1:{i:0;i:1760852834;}s:13:\"42.104.142.79\";a:2:{i:59;i:1760894552;i:60;i:1760894553;}s:14:\"42.104.141.220\";a:2:{i:25;i:1761017607;i:26;i:1761017607;}s:11:\"34.1.28.215\";a:2:{i:0;i:1761125389;i:1;i:1761125390;}s:11:\"34.1.29.232\";a:2:{i:0;i:1761130324;i:1;i:1761130326;}s:12:\"165.154.5.93\";a:10:{i:11;i:1761151760;i:12;i:1761151760;i:13;i:1761151761;i:14;i:1761151761;i:15;i:1761151761;i:16;i:1761151761;i:17;i:1761151762;i:18;i:1761151762;i:19;i:1761151763;i:20;i:1761151763;}}", "off");
INSERT INTO `wp_options` VALUES("528", "_transient_jetpack_autoloader_plugin_paths", "a:1:{i:0;s:29:\"{{WP_PLUGIN_DIR}}/woocommerce\";}", "on");
INSERT INTO `wp_options` VALUES("529", "action_scheduler_lock_async-request-runner", "69294972c66948.45537755|1764313518", "no");
INSERT INTO `wp_options` VALUES("530", "woocommerce_admin_notices", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("531", "wc_blocks_version", "11.8.0-dev", "auto");
INSERT INTO `wp_options` VALUES("532", "woocommerce_maxmind_geolocation_settings", "a:1:{s:15:\"database_prefix\";s:32:\"MRC3erK7MO3m9oZkk5G3HTlJGVps27kf\";}", "on");
INSERT INTO `wp_options` VALUES("533", "_transient_woocommerce_webhook_ids_status_active", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("534", "widget_woocommerce_widget_cart", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("535", "widget_woocommerce_layered_nav_filters", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("536", "widget_woocommerce_layered_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("537", "widget_woocommerce_price_filter", "a:2:{i:1;a:1:{s:5:\"title\";s:15:\"Filter By Price\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("538", "widget_woocommerce_product_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("539", "widget_woocommerce_product_search", "a:2:{i:1;a:1:{s:5:\"title\";s:6:\"Search\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("540", "widget_woocommerce_product_tag_cloud", "a:2:{i:1;a:1:{s:5:\"title\";s:4:\"Tags\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("541", "widget_woocommerce_products", "a:2:{i:1;a:7:{s:5:\"title\";s:15:\"Latest products\";s:6:\"number\";i:3;s:4:\"show\";s:0:\"\";s:7:\"orderby\";s:4:\"date\";s:5:\"order\";s:4:\"desc\";s:9:\"hide_free\";i:0;s:11:\"show_hidden\";i:0;}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("542", "widget_woocommerce_recently_viewed_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("543", "widget_woocommerce_top_rated_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("544", "widget_woocommerce_recent_reviews", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("545", "widget_woocommerce_rating_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("546", "widget_wc_brands_brand_description", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("547", "widget_woocommerce_brand_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("548", "widget_wc_brands_brand_thumbnails", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("549", "tco_scheduled-action_page_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("550", "tco_product_page_options_args", "a:1:{s:7:\"general\";a:2:{s:5:\"title\";s:7:\"General\";s:8:\"sections\";a:1:{s:6:\"single\";a:2:{s:5:\"title\";s:15:\"Single Products\";s:6:\"fields\";a:6:{s:14:\"product_custom\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:14:\"Custom Product\";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:2:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";}s:7:\"default\";s:3:\"off\";s:8:\"required\";s:0:\"\";}s:26:\"product_layout_and_content\";a:3:{s:4:\"type\";s:7:\"heading\";s:5:\"title\";s:20:\"Layout &amp; Content\";s:8:\"required\";a:3:{i:0;s:14:\"product_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:21:\"product_single_layout\";a:7:{s:5:\"title\";s:6:\"Layout\";s:8:\"subtitle\";s:32:\"Choose layout for single product\";s:11:\"description\";s:0:\"\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:2:{i:0;s:13:\"Theme Default\";s:14:\"single-product\";s:19:\"WooCommerce Default\";}s:7:\"default\";s:1:\"0\";s:8:\"required\";a:3:{i:0;s:14:\"product_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:15:\"product_gallery\";a:7:{s:5:\"title\";s:14:\"Gallery Layout\";s:8:\"subtitle\";s:40:\"Choose layout for single product Gallery\";s:11:\"description\";s:0:\"\";s:4:\"type\";s:6:\"select\";s:7:\"options\";a:2:{i:0;s:13:\"Theme Default\";s:6:\"slider\";s:6:\"Slider\";}s:7:\"default\";s:1:\"0\";s:8:\"required\";a:3:{i:0;s:14:\"product_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}s:19:\"product_gallery_nav\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:18:\"Gallery Navigation\";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:3:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";i:-1;s:7:\"Default\";}s:7:\"default\";s:2:\"-1\";s:8:\"required\";a:3:{i:0;s:15:\"product_gallery\";i:1;s:1:\"=\";i:2;a:1:{i:0;s:6:\"slider\";}}}s:13:\"product_share\";a:6:{s:4:\"type\";s:10:\"button-set\";s:5:\"title\";s:5:\"Share\";s:8:\"subtitle\";s:0:\"\";s:7:\"options\";a:3:{s:2:\"on\";s:2:\"On\";s:3:\"off\";s:3:\"Off\";i:-1;s:7:\"Default\";}s:7:\"default\";s:2:\"-1\";s:8:\"required\";a:3:{i:0;s:14:\"product_custom\";i:1;s:1:\"=\";i:2;s:2:\"on\";}}}}}}}", "auto");
INSERT INTO `wp_options` VALUES("551", "tco_product_variation_page_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("552", "tco_shop_order_page_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("553", "tco_shop_order_refund_page_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("554", "tco_shop_coupon_page_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("555", "tco_shop_order_placehold_page_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("556", "tco_action-group_tax_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("557", "tco_product_brand_tax_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("558", "tco_product_type_tax_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("559", "tco_product_visibility_tax_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("560", "tco_product_cat_tax_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("561", "tco_product_tag_tax_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("562", "tco_product_shipping_class_tax_options_args", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("571", "woocommerce_admin_pes_incentive_woopayments_store_had_woopayments", "no", "auto");
INSERT INTO `wp_options` VALUES("574", "woocommerce_gateway_order", "a:6:{s:19:\"_wc_pes_woopayments\";i:0;s:25:\"_wc_pes_paypal_full_stack\";i:1;s:33:\"_wc_offline_payment_methods_group\";i:2;s:4:\"bacs\";i:3;s:6:\"cheque\";i:4;s:3:\"cod\";i:5;}", "auto");
INSERT INTO `wp_options` VALUES("578", "jetpack_options", "a:1:{s:14:\"last_heartbeat\";i:1764307643;}", "auto");
INSERT INTO `wp_options` VALUES("583", "woocommerce_custom_orders_table_created", "yes", "auto");
INSERT INTO `wp_options` VALUES("584", "woocommerce_coming_soon", "no", "auto");
INSERT INTO `wp_options` VALUES("585", "woocommerce_store_pages_only", "no", "auto");
INSERT INTO `wp_options` VALUES("586", "woocommerce_email_improvements_default_enabled", "yes", "auto");
INSERT INTO `wp_options` VALUES("587", "woocommerce_email_improvements_first_enabled_at", "2025-06-06 04:15:16", "auto");
INSERT INTO `wp_options` VALUES("588", "woocommerce_email_improvements_last_enabled_at", "2025-06-06 04:15:16", "auto");
INSERT INTO `wp_options` VALUES("589", "woocommerce_email_improvements_enabled_count", "1", "auto");
INSERT INTO `wp_options` VALUES("590", "woocommerce_initial_installed_version", "9.8.5", "off");
INSERT INTO `wp_options` VALUES("594", "wc_blocks_db_schema_version", "260", "auto");
INSERT INTO `wp_options` VALUES("595", "wc_remote_inbox_notifications_stored_state", "O:8:\"stdClass\":2:{s:22:\"there_were_no_products\";b:1;s:22:\"there_are_now_products\";b:0;}", "off");
INSERT INTO `wp_options` VALUES("600", "_elementor_installed_time", "1749183317", "auto");
INSERT INTO `wp_options` VALUES("601", "elementor_connect_site_key", "ace91bb39a2b5fd67f32c7f433c189a8", "auto");
INSERT INTO `wp_options` VALUES("602", "elementor_remote_info_library", "a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:9:\"templates\";a:4:{i:0;a:20:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:20472;s:5:\"title\";s:10:\"test ido f\";s:9:\"thumbnail\";s:153:\"https://library.stg.elementor.red/wp-content/uploads/2025/01/png-clipart-logo-harry-potter-literary-series-lord-voldemort-film-harry-potter-thumbnail.png\";s:12:\"tmpl_created\";i:1751356263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.stg.elementor.red/blocks/test-ido-f/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:1;a:20:{s:4:\"tmpl\";i:1227;s:2:\"id\";i:19968;s:5:\"title\";s:12:\"Zeyad Test 1\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_2.jpg\";s:12:\"tmpl_created\";i:1670765723;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.stg.elementor.red/blocks/zeyad-test-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:2;a:20:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:19494;s:5:\"title\";s:5:\"test2\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_4.jpg\";s:12:\"tmpl_created\";i:1672308146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.stg.elementor.red/blocks/test2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:3;a:20:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:9631;s:5:\"title\";s:38:\"Slide-in | Sale | Register | Subscribe\";s:9:\"thumbnail\";s:87:\"https://library.stg.elementor.red/wp-content/uploads/2019/01/Slide-in_Sale_small_01.png\";s:12:\"tmpl_created\";i:1660034300;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.stg.elementor.red/popups/slide-in-sale-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:142;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}}}", "off");
INSERT INTO `wp_options` VALUES("603", "elementor_remote_info_feed_data", "a:3:{i:0;a:5:{s:5:\"title\";s:76:\"Introducing Elementor 3.32: Transitions, Transform, Size Variables, and More\";s:7:\"excerpt\";s:250:\"Elementor 3.32 is here, accelerating Editor V4 Alpha with transform controls and layered transitions, system-wide Size Variables and streamlined class management. This release empowers you to build more consistent, dynamic, and professional websites.\";s:7:\"created\";i:1759243152;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:138:\"https://elementor.com/blog/elementor-332-v4-transform-transitions/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:1;a:5:{s:5:\"title\";s:70:\"Introducing Elementor 3.31: New Editor V4 Variables, Filters, and More\";s:7:\"excerpt\";s:294:\"Elementor 3.31 is here, pushing Editor V4 forward with powerful design system enhancements and modern visual styling tools. From Variables and Filters to smarter editing workflows and semantic markup, this version makes it easier than ever to design beautiful, performant, and accessible sites.\";s:7:\"created\";i:1755094220;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:140:\"https://elementor.com/blog/elementor-331-v4-alpha-variables-filters/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:2;a:5:{s:5:\"title\";s:67:\"What Is an MCP? The AI Breakthrough Web Creators Shouldn’t Ignore\";s:7:\"excerpt\";s:143:\"Discover how Model Context Protocol (MCP) is shaping AI-tool interaction and redefining how pro web creators build, manage, and scale websites.\";s:7:\"created\";i:1754310811;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:130:\"https://elementor.com/blog/mcp-explained-for-web-creators/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}}", "off");
INSERT INTO `wp_options` VALUES("608", "woocommerce_checkout_phone_field", "optional", "auto");
INSERT INTO `wp_options` VALUES("609", "woocommerce_checkout_company_field", "hidden", "auto");
INSERT INTO `wp_options` VALUES("610", "woocommerce_checkout_address_2_field", "optional", "auto");
INSERT INTO `wp_options` VALUES("611", "_transient_woocommerce_reports-transient-version", "1749183319", "on");
INSERT INTO `wp_options` VALUES("623", "woocommerce_allow_tracking_first_optin", "1749183326", "auto");
INSERT INTO `wp_options` VALUES("624", "woocommerce_onboarding_profile_progress", "a:1:{s:29:\"core_profiler_completed_steps\";a:2:{s:12:\"intro-opt-in\";a:1:{s:12:\"completed_at\";s:20:\"2025-06-06T04:15:26Z\";}s:17:\"skip-guided-setup\";a:1:{s:12:\"completed_at\";s:20:\"2025-06-06T04:15:34Z\";}}}", "auto");
INSERT INTO `wp_options` VALUES("625", "woocommerce_allow_tracking_last_modified", "1749183326", "auto");
INSERT INTO `wp_options` VALUES("628", "wc_has_tracked_default_theme", "1", "auto");
INSERT INTO `wp_options` VALUES("630", "woocommerce_onboarding_profile", "a:1:{s:7:\"skipped\";b:1;}", "auto");
INSERT INTO `wp_options` VALUES("631", "woocommerce_private_link", "no", "auto");
INSERT INTO `wp_options` VALUES("632", "woocommerce_share_key", "C3SdilU53HL5VpgDamb6I5bSqV8NwYio", "auto");
INSERT INTO `wp_options` VALUES("636", "_transient_woocommerce_shipping_task_zone_count_transient", "0", "on");
INSERT INTO `wp_options` VALUES("647", "_transient_ptk_patterns", "a:99:{i:0;a:18:{s:2:\"ID\";i:450;s:7:\"site_id\";i:231214916;s:5:\"title\";s:47:\"Intro: Heading with image and two columns above\";s:4:\"name\";s:51:\"intro-heading-with-image-and-two-columns-above-copy\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:4005:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"align\":\"wide\",\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group alignwide\"><!-- wp:columns {\"verticalAlignment\":\"top\",\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide are-vertically-aligned-top\"><!-- wp:column {\"verticalAlignment\":\"top\",\"width\":\"\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"left\",\"contentSize\":\"480px\"}} -->\n<div class=\"wp-block-column is-vertically-aligned-top\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Stay dry in style</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"top\",\"width\":\"40%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-top\" style=\"flex-basis:40%\"><!-- wp:paragraph -->\n<p>Designed for both fashion and function, our rain jackets offers sleek styles and waterproof protection to keep you dry in any downpour.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Discover collection</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:image {\"id\":75,\"aspectRatio\":\"16/9\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/06/man-person-winter-photography-statue-coat.png\" alt=\"\" class=\"wp-image-75\" style=\"aspect-ratio:16/9;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_intro\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_intro\";s:5:\"title\";s:22:\"_dotcom_imported_intro\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:105:\"https://wooblockpatterns.wpcomstaging.com/2024/07/10/intro-heading-with-image-and-two-columns-above-copy/\";s:13:\"modified_date\";s:19:\"2025-05-06 14:29:32\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:1;a:18:{s:2:\"ID\";i:448;s:7:\"site_id\";i:231214916;s:5:\"title\";s:40:\"Intro: Two column with content and image\";s:4:\"name\";s:39:\"intro-two-column-with-content-and-image\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3489:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\"},\"align\":\"full\",\"className\":\"alignfull\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|40\"}}}} -->\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center\"><!-- wp:column {\"verticalAlignment\":\"center\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:heading {\"fontSize\":\"xx-large\"} -->\n<h2 class=\"wp-block-heading has-xx-large-font-size\">Sounds like<br>no other</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Experience your music like never before with our latest generation of hi-fidelity headphones.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Shop now</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:image {\"id\":79,\"aspectRatio\":\"3/4\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/06/man-person-music-black-and-white-white-photography.jpg\" alt=\"\" class=\"wp-image-79\" style=\"aspect-ratio:3/4;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_intro\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_intro\";s:5:\"title\";s:22:\"_dotcom_imported_intro\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:93:\"https://wooblockpatterns.wpcomstaging.com/2024/07/10/intro-two-column-with-content-and-image/\";s:13:\"modified_date\";s:19:\"2024-07-18 12:14:17\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:2;a:18:{s:2:\"ID\";i:410;s:7:\"site_id\";i:231214916;s:5:\"title\";s:28:\"Review: Centered testimonial\";s:4:\"name\";s:27:\"review-centered-testimonial\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:4632:\"<!-- wp:group {\"metadata\":{\"name\":\"Review\",\"categories\":[\"featured\",\"reviews\"],\"patternName\":\"review-centered-testimonial\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"0\",\"left\":\"var:preset|spacing|40\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"20%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:20%\"></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"textAlign\":\"center\",\"align\":\"wide\",\"fontSize\":\"large\"} -->\n<h2 class=\"wp-block-heading alignwide has-text-align-center has-large-font-size\">What people are saying</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">\"I recently attended a pottery workshop at this shop, and it was such a wonderful experience. The instructor was patient and encouraging, and I had a blast getting creative with clay.”</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group\"><!-- wp:image {\"id\":107,\"width\":\"64px\",\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"100px\"}}} -->\n<figure class=\"wp-block-image size-full is-resized has-custom-border\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/06/portrait.png\" alt=\"\" class=\"wp-image-107\" style=\"border-radius:100px;aspect-ratio:1;object-fit:cover;width:64px\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"8px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-text-align-center has-medium-font-size\">Liz S.</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"fontSize\":\"small\"} -->\n<p class=\"has-text-align-center has-small-font-size\">Painter</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"20%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:20%\"></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:24:\"_dotcom_imported_reviews\";a:3:{s:4:\"slug\";s:24:\"_dotcom_imported_reviews\";s:5:\"title\";s:24:\"_dotcom_imported_reviews\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:81:\"https://wooblockpatterns.wpcomstaging.com/2024/07/04/review-centered-testimonial/\";s:13:\"modified_date\";s:19:\"2024-07-04 12:03:45\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:3;a:18:{s:2:\"ID\";i:404;s:7:\"site_id\";i:231214916;s:5:\"title\";s:37:\"Review: A quote with scattered images\";s:4:\"name\";s:36:\"review-a-quote-with-scattered-images\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:4579:\"<!-- wp:group {\"metadata\":{\"categories\":[\"reviews\"],\"patternName\":\"review-a-quote-with-scattered-images\",\"name\":\"Review: A quote with scattered images\"},\"style\":{\"spacing\":{\"padding\":{\"right\":\"var:preset|spacing|30\",\"left\":\"var:preset|spacing|30\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group\" style=\"padding-right:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)\"><!-- wp:spacer {\"height\":\"var:preset|spacing|40\"} -->\n<div style=\"height:var(--wp--preset--spacing--40)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:image {\"id\":405,\"width\":\"200px\",\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"align\":\"left\",\"style\":{\"border\":{\"width\":\"0px\",\"style\":\"none\"}},\"className\":\"is-style-default\"} -->\n<figure class=\"wp-block-image alignleft size-full is-resized has-custom-border is-style-default\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/07/table-food-dessert-cake-circle-painting-23295-pxhere-2.png\" alt=\"\" class=\"wp-image-405\" style=\"border-style:none;border-width:0px;aspect-ratio:1;object-fit:cover;width:200px\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":408,\"width\":\"95px\",\"height\":\"auto\",\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"align\":\"right\",\"style\":{\"border\":{\"width\":\"0px\",\"style\":\"none\"}},\"className\":\"is-style-default\"} -->\n<figure class=\"wp-block-image alignright size-full is-resized has-custom-border is-style-default\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/07/formation-cave-food-autumn-darkness-still-life-790116-pxhere-2.png\" alt=\"\" class=\"wp-image-408\" style=\"border-style:none;border-width:0px;aspect-ratio:1;object-fit:cover;width:95px;height:auto\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"},\"blockGap\":\"var:preset|spacing|20\",\"padding\":{\"right\":\"var:preset|spacing|20\",\"left\":\"var:preset|spacing|20\",\"top\":\"var:preset|spacing|60\",\"bottom\":\"var:preset|spacing|60\"}},\"dimensions\":{\"minHeight\":\"\"}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group\" style=\"margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--60);padding-right:var(--wp--preset--spacing--20);padding-bottom:var(--wp--preset--spacing--60);padding-left:var(--wp--preset--spacing--20)\"><!-- wp:spacer {\"height\":\"40px\"} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:image {\"id\":107,\"width\":\"62px\",\"height\":\"62px\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"align\":\"center\",\"className\":\"is-style-rounded\"} -->\n<figure class=\"wp-block-image aligncenter size-full is-resized is-style-rounded\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/06/portrait.png\" alt=\"\" class=\"wp-image-107\" style=\"object-fit:cover;width:62px;height:62px\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\"} -->\n<h2 class=\"wp-block-heading has-text-align-center\">\"The only limit is the extent of your imagination.\"</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">Jayla H.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:image {\"id\":406,\"width\":\"200px\",\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"align\":\"right\",\"style\":{\"border\":{\"width\":\"0px\",\"style\":\"none\"}},\"className\":\"is-style-default\"} -->\n<figure class=\"wp-block-image alignright size-full is-resized has-custom-border is-style-default\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/07/plant-fruit-dish-meal-food-cooking-88153-pxhere-2.png\" alt=\"\" class=\"wp-image-406\" style=\"border-style:none;border-width:0px;aspect-ratio:1;object-fit:cover;width:200px\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":407,\"width\":\"112px\",\"height\":\"auto\",\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"align\":\"left\",\"style\":{\"border\":{\"width\":\"0px\",\"style\":\"none\"}},\"className\":\"is-style-default\"} -->\n<figure class=\"wp-block-image alignleft size-full is-resized has-custom-border is-style-default\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/07/tree-nature-branch-plant-fruit-flower-104610-pxhere.png\" alt=\"\" class=\"wp-image-407\" style=\"border-style:none;border-width:0px;aspect-ratio:1;object-fit:cover;width:112px;height:auto\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|40\"} -->\n<div style=\"height:var(--wp--preset--spacing--40)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:24:\"_dotcom_imported_reviews\";a:3:{s:4:\"slug\";s:24:\"_dotcom_imported_reviews\";s:5:\"title\";s:24:\"_dotcom_imported_reviews\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:90:\"https://wooblockpatterns.wpcomstaging.com/2024/07/04/review-a-quote-with-scattered-images/\";s:13:\"modified_date\";s:19:\"2024-07-04 12:00:48\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:4;a:18:{s:2:\"ID\";i:401;s:7:\"site_id\";i:231214916;s:5:\"title\";s:35:\"Review: Two column centered reviews\";s:4:\"name\";s:2:\"ff\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:7029:\"<!-- wp:group {\"metadata\":{\"name\":\"Reviews\",\"categories\":[\"featured\",\"reviews\"],\"patternName\":\"review-two-column-centered-reviews\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\",\"wideSize\":\"900px\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"align\":\"wide\"} -->\n<h2 class=\"wp-block-heading alignwide has-text-align-center\">Reviews</h2>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|10\",\"bottom\":\"var:preset|spacing|10\",\"left\":\"var:preset|spacing|10\",\"right\":\"var:preset|spacing|10\"}}}} -->\n<div class=\"wp-block-column\" style=\"padding-top:var(--wp--preset--spacing--10);padding-right:var(--wp--preset--spacing--10);padding-bottom:var(--wp--preset--spacing--10);padding-left:var(--wp--preset--spacing--10)\"><!-- wp:group {\"layout\":{\"type\":\"constrained\",\"contentSize\":\"380px\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"12px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"center\",\"orientation\":\"vertical\"}} -->\n<div class=\"wp-block-group\"><!-- wp:image {\"id\":107,\"width\":\"48px\",\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"100px\"}}} -->\n<figure class=\"wp-block-image size-full is-resized has-custom-border\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/06/portrait.png\" alt=\"\" class=\"wp-image-107\" style=\"border-radius:100px;aspect-ratio:1;object-fit:cover;width:48px\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"6px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"style\":{\"typography\":{\"lineHeight\":\"1\"}},\"className\":\"is-testimonial-name\",\"fontSize\":\"small\"} -->\n<h3 class=\"wp-block-heading has-text-align-center is-testimonial-name has-small-font-size\" style=\"line-height:1\">Jayla H.</h3>\n<!-- /wp:heading --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"0\"} -->\n<div style=\"height:0\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"className\":\"is-testimonial-review\"} -->\n<p class=\"has-text-align-center is-testimonial-review\">\"I\'ve been a loyal customer for years, and for good reason. The customer service is top-notch, and the products are always reliable.\"</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|10\",\"bottom\":\"var:preset|spacing|10\",\"left\":\"var:preset|spacing|10\",\"right\":\"var:preset|spacing|10\"}}}} -->\n<div class=\"wp-block-column\" style=\"padding-top:var(--wp--preset--spacing--10);padding-right:var(--wp--preset--spacing--10);padding-bottom:var(--wp--preset--spacing--10);padding-left:var(--wp--preset--spacing--10)\"><!-- wp:group {\"layout\":{\"type\":\"constrained\",\"contentSize\":\"380px\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"12px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"center\",\"orientation\":\"vertical\"}} -->\n<div class=\"wp-block-group\"><!-- wp:image {\"id\":325,\"width\":\"48px\",\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"100px\"}}} -->\n<figure class=\"wp-block-image size-full is-resized has-custom-border\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/07/cf19a5d21c3eeb7afa7c346b32af3ece-1.jpeg\" alt=\"\" class=\"wp-image-325\" style=\"border-radius:100px;aspect-ratio:1;object-fit:cover;width:48px\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"6px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":4,\"style\":{\"typography\":{\"lineHeight\":\"1\"}},\"className\":\"is-testimonial-name\",\"fontSize\":\"small\"} -->\n<h4 class=\"wp-block-heading has-text-align-center is-testimonial-name has-small-font-size\" style=\"line-height:1\">Scott F.</h4>\n<!-- /wp:heading --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"0\"} -->\n<div style=\"height:0\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"className\":\"is-testimonial-review\"} -->\n<p class=\"has-text-align-center is-testimonial-review\">“I recently purchased a smart TV, and I couldn\'t be happier with my purchase. The staff was friendly and helpful, answering all of my questions.\"</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:24:\"_dotcom_imported_reviews\";a:3:{s:4:\"slug\";s:24:\"_dotcom_imported_reviews\";s:5:\"title\";s:24:\"_dotcom_imported_reviews\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:56:\"https://wooblockpatterns.wpcomstaging.com/2024/07/04/ff/\";s:13:\"modified_date\";s:19:\"2024-07-04 12:00:56\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:5;a:18:{s:2:\"ID\";i:397;s:7:\"site_id\";i:231214916;s:5:\"title\";s:26:\"Three column pricing table\";s:4:\"name\";s:28:\"three-column-pricing-table-2\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:15916:\"<!-- wp:group {\"metadata\":{\"name\":\"Pricing table\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"alignfull\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"textAlign\":\"center\"} -->\n<h2 class=\"wp-block-heading has-text-align-center\">Elevate your learning</h2>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|30\",\"width\":\"0px\"} -->\n<div style=\"height:var(--wp--preset--spacing--30);width:0px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"metadata\":{\"name\":\"Tiers\"},\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"metadata\":{\"name\":\"Tier Item\"},\"style\":{\"spacing\":{\"padding\":{\"right\":\"var:preset|spacing|40\",\"left\":\"var:preset|spacing|40\",\"top\":\"var:preset|spacing|30\",\"bottom\":\"var:preset|spacing|50\"},\"blockGap\":\"var:preset|spacing|40\"},\"border\":{\"width\":\"1px\"}},\"borderColor\":\"primary\",\"backgroundColor\":\"base-2\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-column has-border-color has-primary-border-color has-base-2-background-color has-background\" style=\"border-width:1px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--40)\"><!-- wp:paragraph {\"fontSize\":\"small\"} -->\n<p class=\"has-small-font-size\">Free</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"className\":\"is-style-default\"} -->\n<h2 class=\"wp-block-heading is-style-default\">$0</h2>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"justifyContent\":\"stretch\"}} -->\n<div class=\"wp-block-group\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast-2\"}}}},\"textColor\":\"contrast-2\"} -->\n<p class=\"has-text-align-left has-contrast-2-color has-text-color has-link-color\"><strong>✦</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast\"}}},\"layout\":{\"selfStretch\":\"fit\",\"flexSize\":null}},\"textColor\":\"contrast\"} -->\n<p class=\"has-text-align-left has-contrast-color has-text-color has-link-color\">Video lectures</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast-2\"}}}},\"textColor\":\"contrast-2\"} -->\n<p class=\"has-text-align-left has-contrast-2-color has-text-color has-link-color\"><strong>✦</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast\"}}},\"layout\":{\"selfStretch\":\"fit\",\"flexSize\":null}},\"textColor\":\"contrast\"} -->\n<p class=\"has-text-align-left has-contrast-color has-text-color has-link-color\">Interactive quizzes</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast-2\"}}}},\"textColor\":\"contrast-2\"} -->\n<p class=\"has-text-align-left has-contrast-2-color has-text-color has-link-color\"><strong>✦</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast\"}}},\"layout\":{\"selfStretch\":\"fit\",\"flexSize\":null}},\"textColor\":\"contrast\"} -->\n<p class=\"has-text-align-left has-contrast-color has-text-color has-link-color\">Downloadable resources</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast-2\"}}}},\"textColor\":\"contrast-2\"} -->\n<p class=\"has-text-align-left has-contrast-2-color has-text-color has-link-color\"><strong>✦</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast\"}}},\"layout\":{\"selfStretch\":\"fit\",\"flexSize\":null}},\"textColor\":\"contrast\"} -->\n<p class=\"has-text-align-left has-contrast-color has-text-color has-link-color\">Certificates of completion</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"16px\"} -->\n<div style=\"height:16px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"width\":100,\"className\":\"is-style-outline\"} --><div class=\"wp-block-button has-custom-width wp-block-button__width-100 is-style-outline\"><a class=\"wp-block-button__link wp-element-button\">Subscribe</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"metadata\":{\"name\":\"Tier Item (highlighted)\"},\"style\":{\"spacing\":{\"padding\":{\"right\":\"var:preset|spacing|40\",\"left\":\"var:preset|spacing|40\",\"top\":\"var:preset|spacing|30\",\"bottom\":\"var:preset|spacing|30\"},\"blockGap\":\"var:preset|spacing|40\"},\"border\":{\"width\":\"2px\"}},\"borderColor\":\"primary\",\"backgroundColor\":\"base-2\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-column has-border-color has-primary-border-color has-base-2-background-color has-background\" style=\"border-width:2px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--40)\"><!-- wp:paragraph {\"fontSize\":\"small\"} -->\n<p class=\"has-small-font-size\">Basic</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"className\":\"is-style-default\"} -->\n<h2 class=\"wp-block-heading is-style-default\">$39</h2>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"justifyContent\":\"stretch\"}} -->\n<div class=\"wp-block-group\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast-2\"}}}},\"textColor\":\"contrast-2\"} -->\n<p class=\"has-text-align-left has-contrast-2-color has-text-color has-link-color\"><strong>✦</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast\"}}},\"layout\":{\"selfStretch\":\"fit\",\"flexSize\":null}},\"textColor\":\"contrast\"} -->\n<p class=\"has-text-align-left has-contrast-color has-text-color has-link-color\">Everything included in Free</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast-2\"}}}},\"textColor\":\"contrast-2\"} -->\n<p class=\"has-text-align-left has-contrast-2-color has-text-color has-link-color\"><strong>✦</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast\"}}},\"layout\":{\"selfStretch\":\"fit\",\"flexSize\":null}},\"textColor\":\"contrast\"} -->\n<p class=\"has-text-align-left has-contrast-color has-text-color has-link-color\">Personalized feedback</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast-2\"}}}},\"textColor\":\"contrast-2\"} -->\n<p class=\"has-text-align-left has-contrast-2-color has-text-color has-link-color\"><strong>✦</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast\"}}},\"layout\":{\"selfStretch\":\"fit\",\"flexSize\":null}},\"textColor\":\"contrast\"} -->\n<p class=\"has-text-align-left has-contrast-color has-text-color has-link-color\">Live Q&amp;A sessions</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast-2\"}}}},\"textColor\":\"contrast-2\"} -->\n<p class=\"has-text-align-left has-contrast-2-color has-text-color has-link-color\"><strong>✦</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast\"}}},\"layout\":{\"selfStretch\":\"fit\",\"flexSize\":null}},\"textColor\":\"contrast\"} -->\n<p class=\"has-text-align-left has-contrast-color has-text-color has-link-color\">Community forums</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"16px\"} -->\n<div style=\"height:16px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"width\":100,\"className\":\"is-style-fill\"} --><div class=\"wp-block-button has-custom-width wp-block-button__width-100 is-style-fill\"><a class=\"wp-block-button__link wp-element-button\">Subscribe</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"metadata\":{\"name\":\"Tier Item\"},\"style\":{\"spacing\":{\"padding\":{\"right\":\"var:preset|spacing|40\",\"left\":\"var:preset|spacing|40\",\"top\":\"var:preset|spacing|30\",\"bottom\":\"var:preset|spacing|50\"},\"blockGap\":\"var:preset|spacing|40\"},\"border\":{\"width\":\"1px\"}},\"borderColor\":\"primary\",\"backgroundColor\":\"base-2\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-column has-border-color has-primary-border-color has-base-2-background-color has-background\" style=\"border-width:1px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--40)\"><!-- wp:paragraph {\"fontSize\":\"small\"} -->\n<p class=\"has-small-font-size\">Premium</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading {\"className\":\"is-style-default\"} -->\n<h2 class=\"wp-block-heading is-style-default\">$99</h2>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"justifyContent\":\"stretch\"}} -->\n<div class=\"wp-block-group\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast-2\"}}}},\"textColor\":\"contrast-2\"} -->\n<p class=\"has-text-align-left has-contrast-2-color has-text-color has-link-color\"><strong>✦</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast\"}}},\"layout\":{\"selfStretch\":\"fit\",\"flexSize\":null}},\"textColor\":\"contrast\"} -->\n<p class=\"has-text-align-left has-contrast-color has-text-color has-link-color\"><s><span></span></s>Everything included in Basic</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast-2\"}}}},\"textColor\":\"contrast-2\"} -->\n<p class=\"has-text-align-left has-contrast-2-color has-text-color has-link-color\"><strong>✦</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast\"}}},\"layout\":{\"selfStretch\":\"fit\",\"flexSize\":null}},\"textColor\":\"contrast\"} -->\n<p class=\"has-text-align-left has-contrast-color has-text-color has-link-color\">Premium support</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast-2\"}}}},\"textColor\":\"contrast-2\"} -->\n<p class=\"has-text-align-left has-contrast-2-color has-text-color has-link-color\"><strong>✦</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast\"}}},\"layout\":{\"selfStretch\":\"fit\",\"flexSize\":null}},\"textColor\":\"contrast\"} -->\n<p class=\"has-text-align-left has-contrast-color has-text-color has-link-color\">Coaching sessions</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast-2\"}}}},\"textColor\":\"contrast-2\"} -->\n<p class=\"has-text-align-left has-contrast-2-color has-text-color has-link-color\"><strong>✦</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast\"}}},\"layout\":{\"selfStretch\":\"fit\",\"flexSize\":null}},\"textColor\":\"contrast\"} -->\n<p class=\"has-text-align-left has-contrast-color has-text-color has-link-color\">Priority access to new content</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"16px\"} -->\n<div style=\"height:16px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"width\":100,\"className\":\"is-style-outline\"} --><div class=\"wp-block-button has-custom-width wp-block-button__width-100 is-style-outline\"><a class=\"wp-block-button__link wp-element-button\">Subscribe</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:25:\"_dotcom_imported_services\";a:3:{s:4:\"slug\";s:25:\"_dotcom_imported_services\";s:5:\"title\";s:25:\"_dotcom_imported_services\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:82:\"https://wooblockpatterns.wpcomstaging.com/2024/07/02/three-column-pricing-table-2/\";s:13:\"modified_date\";s:19:\"2024-07-05 10:59:28\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:6;a:18:{s:2:\"ID\";i:395;s:7:\"site_id\";i:231214916;s:5:\"title\";s:30:\"Two column boxed pricing table\";s:4:\"name\";s:30:\"two-column-boxed-pricing-table\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:7641:\"<!-- wp:group {\"metadata\":{\"name\":\"Pricing Table\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"alignfull\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"textColor\":\"ast-global-color-2\",\"className\":\"is-pricing-title\"} -->\n<h2 class=\"wp-block-heading has-text-align-center is-pricing-title has-ast-global-color-2-color has-text-color\">Pricing</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"className\":\"is-pricing-description\"} -->\n<p class=\"has-text-align-center is-pricing-description\">Whether you\'re a self-paced learner looking for flexibility or someone who thrives with additional support and guidance, we have a plan for you.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|20\"} -->\n<div style=\"height:var(--wp--preset--spacing--20)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"align\":\"wide\",\"layout\":{\"type\":\"constrained\",\"contentSize\":\"800px\"}} -->\n<div class=\"wp-block-group alignwide\"><!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|30\",\"left\":\"var:preset|spacing|30\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"style\":{\"color\":{\"background\":\"#00000012\"},\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|30\",\"bottom\":\"var:preset|spacing|30\",\"left\":\"var:preset|spacing|30\",\"right\":\"var:preset|spacing|30\"}}}} -->\n<div class=\"wp-block-column has-background\" style=\"background-color:#00000012;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0\"}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"className\":\"is-pricing-tier-name\",\"fontSize\":\"large\"} -->\n<h3 class=\"wp-block-heading is-pricing-tier-name has-large-font-size\">Free</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"className\":\"is-pricing-tier-price\",\"fontSize\":\"small\"} -->\n<p class=\"is-pricing-tier-price has-small-font-size\">$0.00/month</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"width\":100,\"className\":\"is-style-fill\"} --><div class=\"wp-block-button has-custom-width wp-block-button__width-100 is-style-fill\"><a class=\"wp-block-button__link wp-element-button\">Get Started</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"4px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"className\":\"is-pricing-tier-service-checked\"} -->\n<p class=\"is-pricing-tier-service-checked\"><strong>✓</strong> Video lectures</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"className\":\"is-pricing-tier-service-checked\"} -->\n<p class=\"is-pricing-tier-service-checked\"><strong>✓</strong> Interactive quizzes</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"className\":\"is-pricing-tier-service-checked\"} -->\n<p class=\"is-pricing-tier-service-checked\"><strong>✓</strong> Downloadable resources</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"className\":\"is-pricing-tier-service-checked\"} -->\n<p class=\"is-pricing-tier-service-checked\"><strong>✓</strong> Downloadable resources</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"style\":{\"color\":{\"background\":\"#00000012\"},\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|30\",\"bottom\":\"var:preset|spacing|30\",\"left\":\"var:preset|spacing|30\",\"right\":\"var:preset|spacing|30\"}}}} -->\n<div class=\"wp-block-column has-background\" style=\"background-color:#00000012;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)\"><!-- wp:group {\"metadata\":{\"name\":\"Pricing Title\"},\"style\":{\"spacing\":{\"blockGap\":\"0\"}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"className\":\"is-pricing-tier-name\",\"fontSize\":\"large\"} -->\n<h3 class=\"wp-block-heading is-pricing-tier-name has-large-font-size\">Basic</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"className\":\"is-pricing-tier-price\",\"fontSize\":\"small\"} -->\n<p class=\"is-pricing-tier-price has-small-font-size\">$69.00</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"width\":100,\"className\":\"is-style-fill\"} --><div class=\"wp-block-button has-custom-width wp-block-button__width-100 is-style-fill\"><a class=\"wp-block-button__link wp-element-button\">Get Started</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"4px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"className\":\"is-pricing-tier-service-checked\"} -->\n<p class=\"is-pricing-tier-service-checked\"><strong>✓</strong> Everything included in Free</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"className\":\"is-pricing-tier-service-checked\"} -->\n<p class=\"is-pricing-tier-service-checked\"><strong>✓</strong> Personalized feedback</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"className\":\"is-pricing-tier-service-checked\"} -->\n<p class=\"is-pricing-tier-service-checked\"><strong>✓</strong> Live Q&amp;A sessions</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"className\":\"is-pricing-tier-service-checked\"} -->\n<p class=\"is-pricing-tier-service-checked\"><strong>✓</strong> Online community forums</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:25:\"_dotcom_imported_services\";a:3:{s:4:\"slug\";s:25:\"_dotcom_imported_services\";s:5:\"title\";s:25:\"_dotcom_imported_services\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:84:\"https://wooblockpatterns.wpcomstaging.com/2024/07/02/two-column-boxed-pricing-table/\";s:13:\"modified_date\";s:19:\"2024-07-02 11:49:48\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:7;a:18:{s:2:\"ID\";i:392;s:7:\"site_id\";i:231214916;s:5:\"title\";s:24:\"Two column pricing table\";s:4:\"name\";s:24:\"two-column-pricing-table\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:7002:\"<!-- wp:group {\"metadata\":{\"name\":\"Pricing\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"alignfull\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\",\"contentSize\":\"960px\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"align\":\"wide\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignwide\"><!-- wp:heading {\"textAlign\":\"center\",\"align\":\"wide\",\"className\":\"is-pricing-title\"} -->\n<h2 class=\"wp-block-heading alignwide has-text-align-center is-pricing-title\">Pricing</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|40\",\"left\":\"0\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|10\",\"bottom\":\"var:preset|spacing|10\",\"left\":\"var:preset|spacing|10\",\"right\":\"var:preset|spacing|10\"}}}} -->\n<div class=\"wp-block-column\" style=\"padding-top:var(--wp--preset--spacing--10);padding-right:var(--wp--preset--spacing--10);padding-bottom:var(--wp--preset--spacing--10);padding-left:var(--wp--preset--spacing--10)\"><!-- wp:group {\"layout\":{\"type\":\"constrained\",\"contentSize\":\"380px\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"className\":\"is-pricing-tier-name\",\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-text-align-center is-pricing-tier-name has-medium-font-size\">Basic</h3>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|20\"} -->\n<div style=\"height:var(--wp--preset--spacing--20)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":4,\"className\":\"is-pricing-tier-price\",\"fontSize\":\"xx-large\"} -->\n<h4 class=\"wp-block-heading has-text-align-center is-pricing-tier-price has-xx-large-font-size\">$99</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"className\":\"is-pricing-tier-service\"} -->\n<p class=\"has-text-align-center is-pricing-tier-service\">It offers comprehensive access to all course materials, including video lectures, interactive quizzes, and downloadable resources.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"width\":50} --><div class=\"wp-block-button has-custom-width wp-block-button__width-50\"><a class=\"wp-block-button__link wp-element-button\">Get Started</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|20\"} -->\n<div style=\"height:var(--wp--preset--spacing--20)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|10\",\"bottom\":\"var:preset|spacing|10\",\"left\":\"var:preset|spacing|10\",\"right\":\"var:preset|spacing|10\"}}}} -->\n<div class=\"wp-block-column\" style=\"padding-top:var(--wp--preset--spacing--10);padding-right:var(--wp--preset--spacing--10);padding-bottom:var(--wp--preset--spacing--10);padding-left:var(--wp--preset--spacing--10)\"><!-- wp:group {\"layout\":{\"type\":\"constrained\",\"contentSize\":\"380px\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"className\":\"is-pricing-tier-name\",\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-text-align-center is-pricing-tier-name has-medium-font-size\">Premium</h3>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|20\"} -->\n<div style=\"height:var(--wp--preset--spacing--20)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":4,\"className\":\"is-pricing-tier-price\",\"fontSize\":\"xx-large\"} -->\n<h4 class=\"wp-block-heading has-text-align-center is-pricing-tier-price has-xx-large-font-size\">$199</h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"className\":\"is-pricing-tier-service\"} -->\n<p class=\"has-text-align-center is-pricing-tier-service\">Everything in the Basic plan plus exclusive perks and additional support. Enjoy live Q&amp;A, coaching sessions, and priority access to new content.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"width\":50} --><div class=\"wp-block-button has-custom-width wp-block-button__width-50\"><a class=\"wp-block-button__link wp-element-button\">Get Started</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:spacer {\"height\":\"0px\"} -->\n<div style=\"height:0px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:25:\"_dotcom_imported_services\";a:3:{s:4:\"slug\";s:25:\"_dotcom_imported_services\";s:5:\"title\";s:25:\"_dotcom_imported_services\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:78:\"https://wooblockpatterns.wpcomstaging.com/2024/07/02/two-column-pricing-table/\";s:13:\"modified_date\";s:19:\"2024-07-02 11:48:37\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:8;a:18:{s:2:\"ID\";i:384;s:7:\"site_id\";i:231214916;s:5:\"title\";s:28:\"Two column service offerings\";s:4:\"name\";s:28:\"two-column-service-offerings\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:4331:\"<!-- wp:group {\"metadata\":{\"name\":\"Services\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"alignfull\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|60\",\"left\":\"var:preset|spacing|30\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"4px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"fontSize\":\"large\"} -->\n<h3 class=\"wp-block-heading has-text-align-center has-large-font-size\">Basic</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">$99/month</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"8px\"} -->\n<div style=\"height:8px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:image {\"id\":250,\"aspectRatio\":\"4/3\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"color\":[]}} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/07/0ad9cb5f991125c89fc952521795a1e6-1.jpeg\" alt=\"\" class=\"wp-image-250\" style=\"aspect-ratio:4/3;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"4px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"textAlign\":\"center\",\"level\":3,\"fontSize\":\"large\"} -->\n<h3 class=\"wp-block-heading has-text-align-center has-large-font-size\">Premium</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">$199/month</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"8px\"} -->\n<div style=\"height:8px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:image {\"id\":237,\"aspectRatio\":\"4/3\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"color\":[]}} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/06/8d8416beec2ca80653d3b811bf6b1f77.jpeg\" alt=\"\" class=\"wp-image-237\" style=\"aspect-ratio:4/3;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:25:\"_dotcom_imported_services\";a:3:{s:4:\"slug\";s:25:\"_dotcom_imported_services\";s:5:\"title\";s:25:\"_dotcom_imported_services\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:82:\"https://wooblockpatterns.wpcomstaging.com/2024/07/02/two-column-service-offerings/\";s:13:\"modified_date\";s:19:\"2024-07-02 11:21:24\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:9;a:18:{s:2:\"ID\";i:382;s:7:\"site_id\";i:231214916;s:5:\"title\";s:43:\"Three columns of headings, images and links\";s:4:\"name\";s:42:\"three-columns-of-headings-images-and-links\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:5801:\"<!-- wp:group {\"metadata\":{\"name\":\"Services\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|40\",\"left\":\"var:preset|spacing|30\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Furniture customization</h3>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"4px\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group\" style=\"padding-bottom:4px\"><!-- wp:image {\"id\":63,\"aspectRatio\":\"3/2\",\"scale\":\"cover\",\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/06/table-wood-house-chair-floor-window-1-1024x683.jpg\" alt=\"\" class=\"wp-image-63\" style=\"aspect-ratio:3/2;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>Create bespoke pieces that perfectly fit your space and style with our customization services. From fabric selection to dimensions, we\'ll bring your vision to life.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"#\">Get started</a></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Interior design</h3>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"4px\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group\" style=\"padding-bottom:4px\"><!-- wp:image {\"id\":304,\"aspectRatio\":\"3/2\",\"scale\":\"cover\",\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/07/54f708281f82831c082a1cf9d7b7faa9-1-683x1024.jpeg\" alt=\"\" class=\"wp-image-304\" style=\"aspect-ratio:3/2;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>Our expert designers will work with you to transform your space into a stylish and functional haven that reflects your personal taste and lifestyle.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"#\">Get started</a></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Delivery and assembly</h3>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"bottom\":\"4px\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group\" style=\"padding-bottom:4px\"><!-- wp:image {\"id\":354,\"aspectRatio\":\"3/2\",\"scale\":\"cover\",\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/07/ade23ce2024ccbbb42f7f7d6dfe5f2e0-1-684x1024.jpeg\" alt=\"\" class=\"wp-image-354\" style=\"aspect-ratio:3/2;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>Enjoy hassle-free shopping with our delivery and assembly services. Let our team handle the heavy lifting and installation, so you can relax in your newly furnished home.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"#\">Get started</a></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:25:\"_dotcom_imported_services\";a:3:{s:4:\"slug\";s:25:\"_dotcom_imported_services\";s:5:\"title\";s:25:\"_dotcom_imported_services\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:96:\"https://wooblockpatterns.wpcomstaging.com/2024/07/02/three-columns-of-headings-images-and-links/\";s:13:\"modified_date\";s:19:\"2024-07-04 13:40:28\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:10;a:18:{s:2:\"ID\";i:380;s:7:\"site_id\";i:231214916;s:5:\"title\";s:21:\"Grid of text features\";s:4:\"name\";s:21:\"grid-of-text-features\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:5163:\"<!-- wp:group {\"metadata\":{\"name\":\"Services\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"alignfull\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|40\",\"left\":\"var:preset|spacing|40\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"className\":\"is-service-name\",\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading is-service-name has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Personal styling</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"className\":\"is-service-description\"} -->\n<p class=\"is-service-description\">Work one-on-one with our expert stylists to curate outfits that align with your unique taste, body type, and lifestyle.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"className\":\"is-service-name\",\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading is-service-name has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Alterations and tailoring</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"className\":\"is-service-description\"} -->\n<p class=\"is-service-description\">Ensure the perfect fit. From hemming to resizing, our skilled tailors will tailor your garments<br>to perfection.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|20\"} -->\n<div style=\"height:var(--wp--preset--spacing--20)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|40\",\"left\":\"var:preset|spacing|40\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"className\":\"is-service-name\",\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading is-service-name has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Wardrobe refresh</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"className\":\"is-service-description\"} -->\n<p class=\"is-service-description\">Revamp your wardrobe. Our stylists will help you declutter, organize, and update your closet with fresh new pieces.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"className\":\"is-service-name\",\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading is-service-name has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Virtual Shopping</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"className\":\"is-service-description\"} -->\n<p class=\"is-service-description\">Can\'t make it to our store? Our virtual shopping assistance service allows you to shop from the comfort of your home.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:25:\"_dotcom_imported_services\";a:3:{s:4:\"slug\";s:25:\"_dotcom_imported_services\";s:5:\"title\";s:25:\"_dotcom_imported_services\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:75:\"https://wooblockpatterns.wpcomstaging.com/2024/07/02/grid-of-text-features/\";s:13:\"modified_date\";s:19:\"2024-07-04 13:41:09\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:11;a:18:{s:2:\"ID\";i:378;s:7:\"site_id\";i:231214916;s:5:\"title\";s:28:\"Headings left, content right\";s:4:\"name\";s:27:\"headings-left-content-right\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:6543:\"<!-- wp:group {\"metadata\":{\"name\":\"Services\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"alignfull\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"metadata\":{\"name\":\"Content\"},\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|40\"}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignwide\"><!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"40%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:40%\"><!-- wp:heading {\"fontSize\":\"large\"} -->\n<h2 class=\"wp-block-heading has-large-font-size\">Installation</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p>Enjoy peace of mind with our professional installation and setup services. From home theater systems to smart home devices, we\'ll ensure everything is installed and configured correctly for optimal performance.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"#\">Discover more</a></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:separator {\"align\":\"wide\",\"style\":{\"color\":{\"background\":\"#4747471a\"}},\"className\":\"is-style-wide\"} -->\n<hr class=\"wp-block-separator alignwide has-text-color has-alpha-channel-opacity has-background is-style-wide\" style=\"background-color:#4747471a;color:#4747471a\"/>\n<!-- /wp:separator -->\n\n<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"40%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:40%\"><!-- wp:heading {\"fontSize\":\"large\"} -->\n<h2 class=\"wp-block-heading has-large-font-size\">Maintenance</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p>Extend the lifespan of your electronics with our repair and maintenance services. Our skilled technicians will diagnose and fix any issues to keep your devices running smoothly.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"#\">Discover more</a></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:separator {\"align\":\"wide\",\"style\":{\"color\":{\"background\":\"#4747471a\"}},\"className\":\"is-style-wide\"} -->\n<hr class=\"wp-block-separator alignwide has-text-color has-alpha-channel-opacity has-background is-style-wide\" style=\"background-color:#4747471a;color:#4747471a\"/>\n<!-- /wp:separator -->\n\n<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"40%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:40%\"><!-- wp:heading {\"fontSize\":\"large\"} -->\n<h2 class=\"wp-block-heading has-large-font-size\">Trade-in</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p>Upgrade to the latest technology while being environmentally conscious with our trade-in and recycling programs. Trade in your old devices for credit towards new purchases or recycle them responsibly with us.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"#\">Discover more</a></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:separator {\"align\":\"wide\",\"style\":{\"color\":{\"background\":\"#4747471a\"}},\"className\":\"is-style-wide\"} -->\n<hr class=\"wp-block-separator alignwide has-text-color has-alpha-channel-opacity has-background is-style-wide\" style=\"background-color:#4747471a;color:#4747471a\"/>\n<!-- /wp:separator -->\n\n<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"40%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:40%\"><!-- wp:heading {\"fontSize\":\"large\"} -->\n<h2 class=\"wp-block-heading has-large-font-size\">Support</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p>Get the most out of your electronics with our tech support and training services. Our experts will help troubleshoot any issues and provide guidance on using your devices effectively.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p><a href=\"#\">Discover more</a></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:separator {\"align\":\"wide\",\"style\":{\"color\":{\"background\":\"#4747471a\"}},\"className\":\"is-style-wide\"} -->\n<hr class=\"wp-block-separator alignwide has-text-color has-alpha-channel-opacity has-background is-style-wide\" style=\"background-color:#4747471a;color:#4747471a\"/>\n<!-- /wp:separator --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:25:\"_dotcom_imported_services\";a:3:{s:4:\"slug\";s:25:\"_dotcom_imported_services\";s:5:\"title\";s:25:\"_dotcom_imported_services\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:81:\"https://wooblockpatterns.wpcomstaging.com/2024/07/02/headings-left-content-right/\";s:13:\"modified_date\";s:19:\"2024-07-02 11:17:53\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:12;a:18:{s:2:\"ID\";i:376;s:7:\"site_id\";i:231214916;s:5:\"title\";s:30:\"Heading with six text sections\";s:4:\"name\";s:30:\"heading-with-six-text-sections\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:6956:\"<!-- wp:group {\"metadata\":{\"name\":\"Services\"},\"align\":\"full\",\"className\":\"alignfull\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"style\":{\"layout\":{\"selfStretch\":\"fixed\",\"flexSize\":\"100%\"}},\"fontSize\":\"large\"} -->\n<h2 class=\"wp-block-heading has-large-font-size\">Our services</h2>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|10\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}}} -->\n<div style=\"margin-top:0;margin-bottom:0;height:var(--wp--preset--spacing--10)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"style\":{\"spacing\":{\"blockGap\":\"0\"}}} -->\n<div class=\"wp-block-column\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Furniture customization</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Create bespoke pieces that perfectly fit your space and style with our customization services. We\'ll bring your vision to life.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"56px\"} -->\n<div style=\"height:56px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Home staging</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Planning to sell your home? Our home staging service will help maximize its appeal to potential buyers, showcasing its full potential.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"56px\"} -->\n<div style=\"height:56px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Interior design consultation</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Our expert designers will work with you to transform your space into a stylish and functional haven that reflects your personal taste and lifestyle.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"style\":{\"spacing\":{\"blockGap\":\"0\"}}} -->\n<div class=\"wp-block-column\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Furniture restoration</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Restore the beauty of your beloved furniture pieces. From refinishing to repairs, we\'ll breathe new life into your cherished items.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"56px\"} -->\n<div style=\"height:56px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Delivery and assembly</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Enjoy hassle-free shopping with our delivery and assembly services. Let our team handle the heavy lifting and installation, so you can relax.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"56px\"} -->\n<div style=\"height:56px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Virtual design consultation</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Can\'t make it to our showroom? No problem! Our virtual design consultation service allows you to get expert advice from the comfort of your home.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:25:\"_dotcom_imported_services\";a:3:{s:4:\"slug\";s:25:\"_dotcom_imported_services\";s:5:\"title\";s:25:\"_dotcom_imported_services\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:84:\"https://wooblockpatterns.wpcomstaging.com/2024/07/02/heading-with-six-text-sections/\";s:13:\"modified_date\";s:19:\"2024-07-24 14:34:50\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:13;a:18:{s:2:\"ID\";i:371;s:7:\"site_id\";i:231214916;s:5:\"title\";s:32:\"Three column boxed pricing table\";s:4:\"name\";s:26:\"three-column-pricing-table\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:9435:\"<!-- wp:group {\"metadata\":{\"name\":\"Pricing Table\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"alignfull\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"textAlign\":\"center\",\"className\":\"is-pricing-title\"} -->\n<h2 class=\"wp-block-heading has-text-align-center is-pricing-title\">Pricing</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|30\"} -->\n<div style=\"height:var(--wp--preset--spacing--30)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|30\",\"left\":\"var:preset|spacing|30\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"style\":{\"color\":{\"background\":\"#00000012\"},\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|30\",\"bottom\":\"var:preset|spacing|30\",\"left\":\"var:preset|spacing|30\",\"right\":\"var:preset|spacing|30\"}}}} -->\n<div class=\"wp-block-column has-background\" style=\"background-color:#00000012;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0\"}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"className\":\"is-pricing-tier-name\",\"fontSize\":\"large\"} -->\n<h3 class=\"wp-block-heading is-pricing-tier-name has-large-font-size\">Free</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"className\":\"is-pricing-tier-price\",\"fontSize\":\"small\"} -->\n<p class=\"is-pricing-tier-price has-small-font-size\">$0.00/month</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"width\":100,\"className\":\"is-style-outline\"} --><div class=\"wp-block-button has-custom-width wp-block-button__width-100 is-style-outline\"><a class=\"wp-block-button__link wp-element-button\">Get Started</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"4px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"className\":\"is-pricing-tier-service-checked\"} -->\n<p class=\"is-pricing-tier-service-checked\"><strong>✓</strong> Video lectures</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"className\":\"is-pricing-tier-service-checked\"} -->\n<p class=\"is-pricing-tier-service-checked\"><strong>✓</strong> Interactive quizzes</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"className\":\"is-pricing-tier-service-checked\"} -->\n<p class=\"is-pricing-tier-service-checked\"><strong>✓</strong> Downloadable resources</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"className\":\"is-pricing-tier-service-checked\"} -->\n<p class=\"is-pricing-tier-service-checked\"><strong>✓</strong> Certificate of completion</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"style\":{\"color\":{\"background\":\"#00000012\"},\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|30\",\"bottom\":\"var:preset|spacing|30\",\"left\":\"var:preset|spacing|30\",\"right\":\"var:preset|spacing|30\"}}}} -->\n<div class=\"wp-block-column has-background\" style=\"background-color:#00000012;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)\"><!-- wp:group {\"metadata\":{\"name\":\"Pricing Title\"},\"style\":{\"spacing\":{\"blockGap\":\"0\"}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"className\":\"is-pricing-tier-name\",\"fontSize\":\"large\"} -->\n<h3 class=\"wp-block-heading is-pricing-tier-name has-large-font-size\">Basic</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"className\":\"is-pricing-tier-price\",\"fontSize\":\"small\"} -->\n<p class=\"is-pricing-tier-price has-small-font-size\">$39.00/month</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"width\":100,\"className\":\"is-style-fill\"} --><div class=\"wp-block-button has-custom-width wp-block-button__width-100 is-style-fill\"><a class=\"wp-block-button__link wp-element-button\">Get Started</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"4px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"className\":\"is-pricing-tier-service-checked\"} -->\n<p class=\"is-pricing-tier-service-checked\"><strong>✓</strong> Everything included in Free</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"className\":\"is-pricing-tier-service-checked\"} -->\n<p class=\"is-pricing-tier-service-checked\"><strong>✓</strong> Personalized feedback</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"className\":\"is-pricing-tier-service-checked\"} -->\n<p class=\"is-pricing-tier-service-checked\"><strong>✓</strong> Live Q&amp;A sessions</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"className\":\"is-pricing-tier-service-checked\"} -->\n<p class=\"is-pricing-tier-service-checked\"><strong>✓</strong> Online community forums</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"style\":{\"color\":{\"background\":\"#00000012\"},\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|30\",\"bottom\":\"var:preset|spacing|30\",\"left\":\"var:preset|spacing|30\",\"right\":\"var:preset|spacing|30\"}}}} -->\n<div class=\"wp-block-column has-background\" style=\"background-color:#00000012;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0\"}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"className\":\"is-pricing-tier-name\",\"fontSize\":\"large\"} -->\n<h3 class=\"wp-block-heading is-pricing-tier-name has-large-font-size\">Premium</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"className\":\"is-pricing-tier-price\",\"fontSize\":\"small\"} -->\n<p class=\"is-pricing-tier-price has-small-font-size\">$99.00/month</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"width\":100,\"className\":\"is-style-outline\"} --><div class=\"wp-block-button has-custom-width wp-block-button__width-100 is-style-outline\"><a class=\"wp-block-button__link wp-element-button\">Get Started</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"4px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"className\":\"is-pricing-tier-service-checked\"} -->\n<p class=\"is-pricing-tier-service-checked\"><strong>✓</strong> Everything included in Basic</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"className\":\"is-pricing-tier-service-checked\"} -->\n<p class=\"is-pricing-tier-service-checked\"><strong>✓</strong> Premium support</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"className\":\"is-pricing-tier-service-checked\"} -->\n<p class=\"is-pricing-tier-service-checked\"><strong>✓</strong> Coaching sessions</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"className\":\"is-pricing-tier-service-checked\"} -->\n<p class=\"is-pricing-tier-service-checked\"><strong>✓</strong> Priority access to new content</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:25:\"_dotcom_imported_services\";a:3:{s:4:\"slug\";s:25:\"_dotcom_imported_services\";s:5:\"title\";s:25:\"_dotcom_imported_services\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:80:\"https://wooblockpatterns.wpcomstaging.com/2024/07/02/three-column-pricing-table/\";s:13:\"modified_date\";s:19:\"2024-07-02 11:47:39\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:14;a:18:{s:2:\"ID\";i:359;s:7:\"site_id\";i:231214916;s:5:\"title\";s:23:\"Two columns with images\";s:4:\"name\";s:23:\"two-columns-with-images\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:5251:\"<!-- wp:group {\"metadata\":{\"name\":\"Services\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"alignfull\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|60\",\"left\":\"var:preset|spacing|30\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":368,\"aspectRatio\":\"4/3\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"color\":[]}} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/07/56b4ef6554bcb138de65c66f1ec092b9-2.jpeg\" alt=\"\" class=\"wp-image-368\" style=\"aspect-ratio:4/3;object-fit:cover\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:spacer {\"height\":\"4px\"} -->\n<div style=\"height:4px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3} -->\n<h3 class=\"wp-block-heading\">Trade-in and recycling</h3>\n<!-- /wp:heading --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>Upgrade to the latest technology while being environmentally conscious with our trade-in and recycling programs. Trade in your old devices for credit towards new purchases or recycle them responsibly.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":\"8px\"} -->\n<div style=\"height:8px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:buttons {\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}}} -->\n<div class=\"wp-block-buttons\" style=\"margin-top:0;margin-bottom:0\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Get Started</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":222,\"aspectRatio\":\"4/3\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"color\":[]}} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/06/772d1d20f57861f0aa71dccda165b03e.jpeg\" alt=\"\" class=\"wp-image-222\" style=\"aspect-ratio:4/3;object-fit:cover\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:spacer {\"height\":\"4px\"} -->\n<div style=\"height:4px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3} -->\n<h3 class=\"wp-block-heading\">Extended warranty</h3>\n<!-- /wp:heading --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>Protect your investment with our extended warranty and protection plans. Get peace of mind knowing your electronics are covered against unexpected damage and defects.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":\"8px\"} -->\n<div style=\"height:8px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:buttons {\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}}} -->\n<div class=\"wp-block-buttons\" style=\"margin-top:0;margin-bottom:0\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Get Started</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:25:\"_dotcom_imported_services\";a:3:{s:4:\"slug\";s:25:\"_dotcom_imported_services\";s:5:\"title\";s:25:\"_dotcom_imported_services\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:77:\"https://wooblockpatterns.wpcomstaging.com/2024/07/02/two-columns-with-images/\";s:13:\"modified_date\";s:19:\"2024-07-04 13:21:17\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:15;a:18:{s:2:\"ID\";i:357;s:7:\"site_id\";i:231214916;s:5:\"title\";s:31:\"Heading with four text sections\";s:4:\"name\";s:31:\"heading-with-four-text-sections\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:5530:\"<!-- wp:group {\"metadata\":{\"name\":\"Services\"},\"align\":\"full\",\"className\":\"alignfull\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|30\",\"left\":\"var:preset|spacing|30\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"style\":{\"layout\":{\"selfStretch\":\"fixed\",\"flexSize\":\"100%\"}},\"fontSize\":\"large\"} -->\n<h2 class=\"wp-block-heading has-large-font-size\">Services</h2>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|10\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}}} -->\n<div style=\"margin-top:0;margin-bottom:0;height:var(--wp--preset--spacing--10)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"style\":{\"spacing\":{\"blockGap\":\"0\"}}} -->\n<div class=\"wp-block-column\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Personal styling</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Work one-on-one with our expert stylists to curate outfits that align with your unique taste, body type, and lifestyle.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"56px\"} -->\n<div style=\"height:56px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Wardrobe refresh</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Revamp your wardrobe. Our stylists will help you declutter, organize, and update your closet with fresh new pieces.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"style\":{\"spacing\":{\"blockGap\":\"0\"}}} -->\n<div class=\"wp-block-column\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Alterations and tailoring</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Ensure the perfect fit. From hemming to resizing, our skilled tailors will tailor your garments to perfection.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"56px\"} -->\n<div style=\"height:56px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Virtual Shopping</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Can\'t make it to our store? Our virtual shopping assistance service allows you to shop from the comfort of your home.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:25:\"_dotcom_imported_services\";a:3:{s:4:\"slug\";s:25:\"_dotcom_imported_services\";s:5:\"title\";s:25:\"_dotcom_imported_services\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:85:\"https://wooblockpatterns.wpcomstaging.com/2024/07/02/heading-with-four-text-sections/\";s:13:\"modified_date\";s:19:\"2024-07-24 14:35:12\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:16;a:18:{s:2:\"ID\";i:348;s:7:\"site_id\";i:231214916;s:5:\"title\";s:34:\"Personal bio with a contact button\";s:4:\"name\";s:34:\"personal-bio-with-a-contact-button\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3746:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"alignfull\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:image {\"id\":107,\"width\":\"175px\",\"height\":\"auto\",\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"align\":\"center\",\"style\":{\"border\":{\"radius\":\"100em\"}}} -->\n<figure class=\"wp-block-image aligncenter size-full is-resized has-custom-border\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/06/portrait.png\" alt=\"\" class=\"wp-image-107\" style=\"border-radius:100em;aspect-ratio:1;object-fit:cover;width:175px;height:auto\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:spacer {\"height\":\"8px\"} -->\n<div style=\"height:8px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"align\":\"wide\",\"layout\":{\"type\":\"constrained\",\"wideSize\":\"460px\"}} -->\n<div class=\"wp-block-group alignwide\"><!-- wp:heading {\"textAlign\":\"center\",\"textColor\":\"ast-global-color-2\"} -->\n<h2 class=\"wp-block-heading has-text-align-center has-ast-global-color-2-color has-text-color\">Marianne R.</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">“My journey into fashion began with a passion for sustainability and a love for artisanal crafts. Since childhood, I’ve been captivated by the intricate handiwork of global artisans and the stories behind their creations.” </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\",\"orientation\":\"horizontal\",\"flexWrap\":\"wrap\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">About me</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:88:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/personal-bio-with-a-contact-button/\";s:13:\"modified_date\";s:19:\"2024-07-01 18:33:10\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:17;a:18:{s:2:\"ID\";i:345;s:7:\"site_id\";i:231214916;s:5:\"title\";s:66:\"Circular avatar on left header on right with sub-header and button\";s:4:\"name\";s:66:\"circular-avatar-on-left-header-on-right-with-sub-header-and-button\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3620:\"<!-- wp:group {\"metadata\":{\"name\":\"About\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|50\"}}}} -->\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center\"><!-- wp:column {\"verticalAlignment\":\"center\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:image {\"id\":346,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"100em\"}}} -->\n<figure class=\"wp-block-image size-full has-custom-border\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/07/8d605dc291be9f49e7e9afe9b8d0f5c7-1.png\" alt=\"\" class=\"wp-image-346\" style=\"border-radius:100em;aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:heading {\"align\":\"wide\"} -->\n<h2 class=\"wp-block-heading alignwide\">Sustainable fashion</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>We believe that fashion should be as kind to the planet as it is to your wardrobe. With a commitment to sustainability and environmental responsibility, we curate a collection of chic and eco-friendly clothing.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Get in touch</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:120:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/circular-avatar-on-left-header-on-right-with-sub-header-and-button/\";s:13:\"modified_date\";s:19:\"2024-07-04 14:53:07\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:18;a:18:{s:2:\"ID\";i:343;s:7:\"site_id\";i:231214916;s:5:\"title\";s:57:\"Circular image on right with large border header on right\";s:4:\"name\";s:57:\"circular-image-on-right-with-large-border-header-on-right\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3565:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|50\"}}}} -->\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center\"><!-- wp:column {\"verticalAlignment\":\"center\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:heading {\"fontSize\":\"small\"} -->\n<h2 class=\"wp-block-heading has-small-font-size\">About us</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading {\"align\":\"wide\"} -->\n<h2 class=\"wp-block-heading alignwide\">Sustainable fashion</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>We believe that fashion should be as kind to the planet as it is to your wardrobe. With a commitment to sustainability and environmental responsibility, we curate a collection of chic and eco-friendly clothing.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:image {\"id\":262,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"radius\":\"100em\",\"width\":\"0px\",\"style\":\"none\"}}} -->\n<figure class=\"wp-block-image size-full has-custom-border\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/07/96bbcf9839d875a42e9aaaada8132a33.jpeg\" alt=\"\" class=\"wp-image-262\" style=\"border-style:none;border-width:0px;border-radius:100em;aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:111:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/circular-image-on-right-with-large-border-header-on-right/\";s:13:\"modified_date\";s:19:\"2024-07-04 14:46:29\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:19;a:18:{s:2:\"ID\";i:341;s:7:\"site_id\";i:231214916;s:5:\"title\";s:33:\"Header with a paragraph and stats\";s:4:\"name\";s:33:\"header-with-a-paragraph-and-stats\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:4298:\"<!-- wp:group {\"metadata\":{\"name\":\"Numbers\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"textAlign\":\"left\",\"align\":\"wide\",\"fontSize\":\"xx-large\"} -->\n<h2 class=\"wp-block-heading alignwide has-text-align-left has-xx-large-font-size\">Create anything</h2>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"right\":\"0\",\"left\":\"0\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignwide\" style=\"padding-right:0;padding-left:0\"><!-- wp:spacer {\"height\":\"4px\"} -->\n<div style=\"height:4px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"75%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:75%\"><!-- wp:paragraph {\"fontSize\":\"medium\"} -->\n<p class=\"has-medium-font-size\">Welcome to a world of limitless possibilities, where the journey is as exhilarating as the destination, and where every moment is an opportunity to make your mark on the canvas of existence.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|30\"} -->\n<div style=\"height:var(--wp--preset--spacing--30)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3,\"fontSize\":\"x-large\"} -->\n<h3 class=\"wp-block-heading has-x-large-font-size\">14M</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Satisfied clients</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3,\"fontSize\":\"x-large\"} -->\n<h3 class=\"wp-block-heading has-x-large-font-size\">Eco</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>We are thinking about the planet</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3,\"fontSize\":\"x-large\"} -->\n<h3 class=\"wp-block-heading has-x-large-font-size\">120</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Options</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:87:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/header-with-a-paragraph-and-stats/\";s:13:\"modified_date\";s:19:\"2024-07-04 14:49:56\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:20;a:18:{s:2:\"ID\";i:338;s:7:\"site_id\";i:231214916;s:5:\"title\";s:12:\"Team members\";s:4:\"name\";s:12:\"team-members\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:11352:\"<!-- wp:group {\"metadata\":{\"name\":\"Team\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"textAlign\":\"center\"} -->\n<h2 class=\"wp-block-heading has-text-align-center\">Our Team</h2>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"metadata\":{\"name\":\"Team members\"},\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|50\",\"left\":\"var:preset|spacing|30\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":336,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"color\":[]}} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/07/fab46ce87d847342cbe7410cdaa90732.jpeg\" alt=\"\" class=\"wp-image-336\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:spacer {\"height\":\"4px\"} -->\n<div style=\"height:4px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"9px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Emily Hayes</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Interior designer</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>Emily brings over a decade of experience in interior design, specializing in creating unique and personalized spaces that reflect each client\'s personality and lifestyle.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":335,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"color\":[]}} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/07/f53d7341f90e86c42ed293bb386b5db4.jpeg\" alt=\"\" class=\"wp-image-335\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:spacer {\"height\":\"4px\"} -->\n<div style=\"height:4px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"9px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Mark Johnson</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Furniture designer</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>With a keen eye for detail and craftsmanship, Mark designs furniture pieces that blend style with functionality, ensuring every piece enhances the beauty of any space.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":331,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"color\":[]}} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/07/885b26a44a4ca21844c169eca79dcf8c.jpeg\" alt=\"\" class=\"wp-image-331\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:spacer {\"height\":\"4px\"} -->\n<div style=\"height:4px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"9px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Alex Parker</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Customer support specialist</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>Alex is committed to ensuring our customers have a seamless experience, providing attentive support and assistance with any inquiries or concerns they may have.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"metadata\":{\"name\":\"Team members\"},\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|50\",\"left\":\"var:preset|spacing|30\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":330,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"color\":[]}} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/07/44df767ec48f3788eb836df942c12ca5.jpeg\" alt=\"\" class=\"wp-image-330\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:spacer {\"height\":\"4px\"} -->\n<div style=\"height:4px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"9px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">David Carter</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Project manager</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>David oversees every project with precision and efficiency, ensuring that timelines are met and that every detail is executed flawlessly from concept to completion.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":332,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"color\":[]}} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/07/b804be09af895837548af933fdea519f.jpeg\" alt=\"\" class=\"wp-image-332\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:spacer {\"height\":\"4px\"} -->\n<div style=\"height:4px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"9px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Sophia Lee</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Sales manager</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>Sophia is dedicated to providing exceptional service to our customers, offering guidance to help them find the perfect furniture and décor pieces for their homes.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":339,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"color\":[]}} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/07/05414bb38f179cc7c6969cbaf1b152e1-1.jpeg\" alt=\"\" class=\"wp-image-339\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:spacer {\"height\":\"4px\"} -->\n<div style=\"height:4px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"9px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Emma Reynolds</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Marketing coordinator</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>Emma\'s creative flair and passion for design shine through in her work, as she curates captivating content and engaging campaigns to showcase our products and services.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:66:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/team-members/\";s:13:\"modified_date\";s:19:\"2024-07-04 14:42:27\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:21;a:18:{s:2:\"ID\";i:334;s:7:\"site_id\";i:231214916;s:5:\"title\";s:8:\"Our team\";s:4:\"name\";s:8:\"our-team\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:10105:\"<!-- wp:group {\"metadata\":{\"name\":\"Team\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"40%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:40%\"><!-- wp:heading {\"textAlign\":\"left\"} -->\n<h2 class=\"wp-block-heading has-text-align-left\">Our Team</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"30%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:30%\"><!-- wp:image {\"id\":336,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"color\":[]}} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/07/fab46ce87d847342cbe7410cdaa90732.jpeg\" alt=\"\" class=\"wp-image-336\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:spacer {\"height\":\"4px\"} -->\n<div style=\"height:4px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"9px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Emily Hayes</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Interior designer</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>Emily brings over a decade of experience in interior design, specializing in creating unique and personalized spaces that reflect each client\'s personality and lifestyle. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:social-links {\"iconColor\":\"theme-4\",\"iconColorValue\":\"#242b2d\",\"size\":\"has-small-icon-size\",\"className\":\"is-style-logos-only\"} -->\n<ul class=\"wp-block-social-links has-small-icon-size has-icon-color is-style-logos-only\"><!-- wp:social-link {\"url\":\"#\",\"service\":\"facebook\"} /-->\n\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"x\"} /-->\n\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"linkedin\"} /--></ul>\n<!-- /wp:social-links --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"30%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:30%\"><!-- wp:image {\"id\":335,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"color\":[]}} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/07/f53d7341f90e86c42ed293bb386b5db4.jpeg\" alt=\"\" class=\"wp-image-335\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:spacer {\"height\":\"4px\"} -->\n<div style=\"height:4px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"9px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Mark Johnson</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Furniture designer</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>With a keen eye for detail and craftsmanship, Mark designs furniture pieces that blend style with functionality, ensuring every piece enhances the beauty of any space.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:social-links {\"iconColor\":\"theme-4\",\"iconColorValue\":\"#242b2d\",\"size\":\"has-small-icon-size\",\"className\":\"is-style-logos-only\"} -->\n<ul class=\"wp-block-social-links has-small-icon-size has-icon-color is-style-logos-only\"><!-- wp:social-link {\"url\":\"#\",\"service\":\"facebook\"} /-->\n\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"x\"} /-->\n\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"linkedin\"} /--></ul>\n<!-- /wp:social-links --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"40%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:40%\"></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"30%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:30%\"><!-- wp:image {\"id\":331,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"color\":[]}} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/07/885b26a44a4ca21844c169eca79dcf8c.jpeg\" alt=\"\" class=\"wp-image-331\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:spacer {\"height\":\"4px\"} -->\n<div style=\"height:4px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"9px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Alex Parker</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Customer support specialist</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>Alex is committed to ensuring our customers have a seamless experience, providing attentive support and assistance with any inquiries or concerns they may have.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:social-links {\"iconColor\":\"theme-4\",\"iconColorValue\":\"#242b2d\",\"size\":\"has-small-icon-size\",\"className\":\"is-style-logos-only\"} -->\n<ul class=\"wp-block-social-links has-small-icon-size has-icon-color is-style-logos-only\"><!-- wp:social-link {\"url\":\"#\",\"service\":\"facebook\"} /-->\n\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"x\"} /-->\n\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"linkedin\"} /--></ul>\n<!-- /wp:social-links --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"30%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:30%\"><!-- wp:image {\"id\":332,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"color\":[]}} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/07/b804be09af895837548af933fdea519f.jpeg\" alt=\"\" class=\"wp-image-332\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:spacer {\"height\":\"4px\"} -->\n<div style=\"height:4px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"9px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Sophia Lee</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Sales manager</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p>Sophia is dedicated to providing exceptional service to our customers, offering guidance to help them find the perfect furniture and décor pieces for their homes.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:social-links {\"iconColor\":\"theme-4\",\"iconColorValue\":\"#242b2d\",\"size\":\"has-small-icon-size\",\"className\":\"is-style-logos-only\"} -->\n<ul class=\"wp-block-social-links has-small-icon-size has-icon-color is-style-logos-only\"><!-- wp:social-link {\"url\":\"#\",\"service\":\"facebook\"} /-->\n\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"x\"} /-->\n\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"linkedin\"} /--></ul>\n<!-- /wp:social-links --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:62:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/our-team/\";s:13:\"modified_date\";s:19:\"2024-07-04 14:43:04\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:22;a:18:{s:2:\"ID\";i:329;s:7:\"site_id\";i:231214916;s:5:\"title\";s:4:\"Team\";s:4:\"name\";s:4:\"team\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:4779:\"<!-- wp:group {\"metadata\":{\"name\":\"Team\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|20\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"50%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:heading {\"textAlign\":\"left\"} -->\n<h2 class=\"wp-block-heading has-text-align-left\">Meet the passionate team behind our brand</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"30%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:30%\"><!-- wp:image {\"id\":332,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"color\":[]},\"className\":\"is-style-default\"} -->\n<figure class=\"wp-block-image size-full is-style-default\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/07/b804be09af895837548af933fdea519f.jpeg\" alt=\"\" class=\"wp-image-332\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"30%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:30%\"><!-- wp:image {\"id\":331,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"color\":[]}} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/07/885b26a44a4ca21844c169eca79dcf8c.jpeg\" alt=\"\" class=\"wp-image-331\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|20\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"50%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"30%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:30%\"><!-- wp:image {\"id\":330,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"color\":[]}} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/07/44df767ec48f3788eb836df942c12ca5.jpeg\" alt=\"\" class=\"wp-image-330\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"30%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:30%\"><!-- wp:image {\"id\":325,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"color\":[]}} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/07/cf19a5d21c3eeb7afa7c346b32af3ece-1.jpeg\" alt=\"\" class=\"wp-image-325\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:58:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/team/\";s:13:\"modified_date\";s:19:\"2024-07-01 16:45:42\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:23;a:18:{s:2:\"ID\";i:327;s:7:\"site_id\";i:231214916;s:5:\"title\";s:5:\"About\";s:4:\"name\";s:5:\"about\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:6587:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|50\"}}}} -->\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"40%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:40%\"><!-- wp:image {\"id\":462,\"aspectRatio\":\"3/4\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/07/girls-in-the-hills-3.jpg\" alt=\"\" class=\"wp-image-462\" style=\"aspect-ratio:3/4;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"80%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:80%\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Embrace<br>sustainable fashion</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>We believe that fashion should be as kind to the planet as it is to your wardrobe. With a commitment to sustainability and environmental responsibility, we curate a collection of chic and eco-friendly clothing.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"stretch\"} -->\n<div class=\"wp-block-column is-vertically-aligned-stretch\"></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"24px\"} -->\n<div style=\"height:24px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"isStackedOnMobile\":false,\"fontSize\":\"medium\"} -->\n<div class=\"wp-block-columns is-not-stacked-on-mobile has-medium-font-size\"><!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"bottom\":\"0\",\"left\":\"var:preset|spacing|20\",\"right\":\"var:preset|spacing|20\"},\"blockGap\":\"4px\"},\"border\":{\"left\":{\"color\":\"#1e1e1e40\",\"width\":\"1px\"},\"top\":[],\"right\":[],\"bottom\":[]}}} -->\n<div class=\"wp-block-column\" style=\"border-left-color:#1e1e1e40;border-left-width:1px;padding-top:0;padding-right:var(--wp--preset--spacing--20);padding-bottom:0;padding-left:var(--wp--preset--spacing--20)\"><!-- wp:heading {\"level\":3} -->\n<h3 class=\"wp-block-heading\">100%</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Eco-friendly packaging</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"bottom\":\"0\",\"left\":\"var:preset|spacing|20\",\"right\":\"var:preset|spacing|20\"},\"blockGap\":\"4px\"},\"border\":{\"left\":{\"color\":\"#1e1e1e40\",\"width\":\"1px\"},\"top\":[],\"right\":[],\"bottom\":[]}}} -->\n<div class=\"wp-block-column\" style=\"border-left-color:#1e1e1e40;border-left-width:1px;padding-top:0;padding-right:var(--wp--preset--spacing--20);padding-bottom:0;padding-left:var(--wp--preset--spacing--20)\"><!-- wp:heading {\"level\":3} -->\n<h3 class=\"wp-block-heading\">75%</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Recycled materials</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"8px\"} -->\n<div style=\"height:8px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"isStackedOnMobile\":false,\"fontSize\":\"medium\"} -->\n<div class=\"wp-block-columns is-not-stacked-on-mobile has-medium-font-size\"><!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"bottom\":\"0\",\"left\":\"var:preset|spacing|20\",\"right\":\"var:preset|spacing|20\"},\"blockGap\":\"4px\"},\"border\":{\"left\":{\"color\":\"#1e1e1e40\",\"width\":\"1px\"},\"top\":[],\"right\":[],\"bottom\":[]}}} -->\n<div class=\"wp-block-column\" style=\"border-left-color:#1e1e1e40;border-left-width:1px;padding-top:0;padding-right:var(--wp--preset--spacing--20);padding-bottom:0;padding-left:var(--wp--preset--spacing--20)\"><!-- wp:heading {\"level\":3} -->\n<h3 class=\"wp-block-heading\">80%</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Less water usage</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"bottom\":\"0\",\"left\":\"var:preset|spacing|20\",\"right\":\"var:preset|spacing|20\"},\"blockGap\":\"4px\"},\"border\":{\"left\":{\"color\":\"#1e1e1e40\",\"width\":\"1px\"},\"top\":[],\"right\":[],\"bottom\":[]}}} -->\n<div class=\"wp-block-column\" style=\"border-left-color:#1e1e1e40;border-left-width:1px;padding-top:0;padding-right:var(--wp--preset--spacing--20);padding-bottom:0;padding-left:var(--wp--preset--spacing--20)\"><!-- wp:heading {\"level\":3} -->\n<h3 class=\"wp-block-heading\">100%</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Organic cotton</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"9px\"} -->\n<div style=\"height:9px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:59:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/about/\";s:13:\"modified_date\";s:19:\"2024-07-18 12:31:42\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:24;a:18:{s:2:\"ID\";i:322;s:7:\"site_id\";i:231214916;s:5:\"title\";s:29:\"About with heading and images\";s:4:\"name\";s:29:\"about-with-heading-and-images\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:4808:\"<!-- wp:group {\"metadata\":{\"name\":\"About\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"align\":\"wide\"} -->\n<h2 class=\"wp-block-heading alignwide\">Chic and eco-friendly fashion, thoughtfully crafted with organic fabrics and recycled materials.</h2>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|30\"} -->\n<div style=\"height:var(--wp--preset--spacing--30)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|20\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"space-between\",\"verticalAlignment\":\"top\"}} -->\n<div class=\"wp-block-group alignwide\"><!-- wp:image {\"id\":323,\"aspectRatio\":\"3/4\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/07/f3b0161d47e4ada886ef5f69d0637ddd.jpeg\" alt=\"\" class=\"wp-image-323\" style=\"aspect-ratio:3/4;object-fit:cover\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"justifyContent\":\"stretch\"}} -->\n<div class=\"wp-block-group\"><!-- wp:spacer {\"height\":\"0px\",\"style\":{\"layout\":{\"flexSize\":\"5vw\",\"selfStretch\":\"fixed\"}}} -->\n<div style=\"height:0px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:image {\"id\":75,\"aspectRatio\":\"3/4\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/06/man-person-winter-photography-statue-coat.png\" alt=\"\" class=\"wp-image-75\" style=\"aspect-ratio:3/4;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:group -->\n\n<!-- wp:image {\"id\":325,\"aspectRatio\":\"3/4\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/07/cf19a5d21c3eeb7afa7c346b32af3ece-1.jpeg\" alt=\"\" class=\"wp-image-325\" style=\"aspect-ratio:3/4;object-fit:cover\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"justifyContent\":\"stretch\"}} -->\n<div class=\"wp-block-group\"><!-- wp:spacer {\"height\":\"0px\",\"style\":{\"layout\":{\"flexSize\":\"5vw\",\"selfStretch\":\"fixed\"}}} -->\n<div style=\"height:0px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:image {\"id\":324,\"aspectRatio\":\"3/4\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/07/f554dfb297c4824916eb82ee70a3d942.jpeg\" alt=\"\" class=\"wp-image-324\" style=\"aspect-ratio:3/4;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:83:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/about-with-heading-and-images/\";s:13:\"modified_date\";s:19:\"2024-07-01 16:38:19\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:25;a:18:{s:2:\"ID\";i:319;s:7:\"site_id\";i:231214916;s:5:\"title\";s:22:\"List with descriptions\";s:4:\"name\";s:4:\"data\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:10266:\"<!-- wp:group {\"metadata\":{\"name\":\"Data list\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"metadata\":{\"name\":\"Data entry\"},\"align\":\"wide\",\"style\":{\"border\":{\"top\":{\"color\":\"var:preset|color|theme-4\",\"width\":\"1px\"},\"right\":[],\"bottom\":[],\"left\":[]},\"spacing\":{\"padding\":{\"right\":\"0\",\"left\":\"0\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignwide\" style=\"border-top-color:var(--wp--preset--color--theme-4);border-top-width:1px;padding-right:0;padding-left:0\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|30\"}}}} -->\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center\"><!-- wp:column {\"verticalAlignment\":\"center\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:heading {\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|theme-4\"}}}},\"textColor\":\"theme-4\"} -->\n<h2 class=\"wp-block-heading has-theme-4-color has-text-color has-link-color\">18 years</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"40%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:40%\"><!-- wp:paragraph {\"align\":\"left\"} -->\n<p class=\"has-text-align-left\">We have been in the market for 18 years and proved our customers our experience matters.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"metadata\":{\"name\":\"Data entry\"},\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|20\",\"left\":\"var:preset|spacing|20\"}},\"border\":{\"top\":{\"width\":\"1px\"}}}} -->\n<div class=\"wp-block-group alignwide\" style=\"border-top-width:1px\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center\"><!-- wp:column {\"verticalAlignment\":\"center\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:heading {\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|theme-4\"}}}},\"textColor\":\"theme-4\"} -->\n<h2 class=\"wp-block-heading has-theme-4-color has-text-color has-link-color\">54 countries</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"40%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:40%\"><!-- wp:paragraph {\"align\":\"left\"} -->\n<p class=\"has-text-align-left\">We are worldwide with market participation in more than 54 countries in 5 continents.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"metadata\":{\"name\":\"Data entry\"},\"align\":\"wide\",\"style\":{\"border\":{\"top\":{\"width\":\"1px\"}},\"spacing\":{\"padding\":{\"right\":\"0\",\"left\":\"0\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignwide\" style=\"border-top-width:1px;padding-right:0;padding-left:0\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|30\"}}}} -->\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center\"><!-- wp:column {\"verticalAlignment\":\"center\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:heading {\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|theme-4\"}}}},\"textColor\":\"theme-4\"} -->\n<h2 class=\"wp-block-heading has-theme-4-color has-text-color has-link-color\">98K users</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"40%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:40%\"><!-- wp:paragraph {\"align\":\"left\"} -->\n<p class=\"has-text-align-left\">We have almost 100k active users with a high level of engagement and adoption.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"metadata\":{\"name\":\"Data entry\"},\"align\":\"wide\",\"style\":{\"border\":{\"top\":{\"width\":\"1px\"}}}} -->\n<div class=\"wp-block-group alignwide\" style=\"border-top-width:1px\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center\"><!-- wp:column {\"verticalAlignment\":\"center\",\"style\":{\"color\":[],\"border\":{\"radius\":\"0px\"}}} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"border-radius:0px\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"verticalAlignment\":\"top\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|theme-4\"}}}},\"textColor\":\"theme-4\"} -->\n<h2 class=\"wp-block-heading has-theme-4-color has-text-color has-link-color\">$12M revenue</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"40%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:40%\"><!-- wp:paragraph {\"align\":\"left\"} -->\n<p class=\"has-text-align-left\">We closed 2023 over $12M dollars in revenue which position us as leader in our industry</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:58:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/data/\";s:13:\"modified_date\";s:19:\"2024-07-04 14:33:26\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:26;a:18:{s:2:\"ID\";i:317;s:7:\"site_id\";i:231214916;s:5:\"title\";s:28:\"Tall content with image left\";s:4:\"name\";s:28:\"tall-content-with-image-left\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:4051:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|40\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":273,\"aspectRatio\":\"3/4\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/07/44024b9b9c88dd50f5cf11f5c31311c5-1.jpeg\" alt=\"\" class=\"wp-image-273\" style=\"aspect-ratio:3/4;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"right\":\"0\"},\"blockGap\":\"var:preset|spacing|30\"},\"dimensions\":{\"minHeight\":\"100%\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"verticalAlignment\":\"space-between\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"min-height:100%;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><!-- wp:group {\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"fontSize\":\"x-large\"} -->\n<h2 class=\"wp-block-heading has-x-large-font-size\">Committed to a greener lifestyle</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"layout\":{\"type\":\"constrained\",\"contentSize\":\"400px\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph -->\n<p>Our passion is crafting mindful moments with locally sourced, organic, and sustainable products. We\'re more than a store; we\'re your path to a community-driven, eco-friendly lifestyle that embraces premium quality.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Meet us</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:82:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/tall-content-with-image-left/\";s:13:\"modified_date\";s:19:\"2024-07-04 14:06:24\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:27;a:18:{s:2:\"ID\";i:315;s:7:\"site_id\";i:231214916;s:5:\"title\";s:24:\"Two column text sections\";s:4:\"name\";s:24:\"two-column-text-sections\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3953:\"<!-- wp:group {\"metadata\":{\"name\":\"About\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|50\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"className\":\"is-service-name\",\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading is-service-name has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Commitment to sustainability</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"className\":\"is-service-description\"} -->\n<p class=\"is-service-description\">Ethical sourcing is at the forefront of everything we do. We\'re proud to champion sustainable fashion by prioritizing the use of organic and recycled materials in our clothing and accessories. By supporting fair trade initiatives and maintaining transparent supply chains, we ensure that every piece upholds our commitment to ethical practices.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"className\":\"is-service-name\",\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading is-service-name has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Quality and Craftsmanship</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"className\":\"is-service-description\"} -->\n<p class=\"is-service-description\">We are dedicated to crafting timeless pieces that stand the test of time. Each garment and accessory in our collection is a testament to our unwavering commitment to quality and craftsmanship. We take pride in using only the finest materials and employing meticulous attention to detail in every step of the creation process.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:78:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/two-column-text-sections/\";s:13:\"modified_date\";s:19:\"2024-07-04 14:16:22\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:28;a:18:{s:2:\"ID\";i:313;s:7:\"site_id\";i:231214916;s:5:\"title\";s:36:\"Content with grid of images on right\";s:4:\"name\";s:36:\"content-with-grid-of-images-on-right\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:5365:\"<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|40\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"25%\",\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-column\" style=\"flex-basis:25%\"><!-- wp:spacer {\"height\":\"var:preset|spacing|10\"} -->\n<div style=\"height:var(--wp--preset--spacing--10)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"fontSize\":\"large\"} -->\n<h2 class=\"wp-block-heading has-large-font-size\">Crafting beauty</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>We are dedicated to the art of craftsmanship, where each vase is meticulously crafted to perfection. Our passion for detail and commitment to quality shines through in every piece, resulting in vases that are not just functional, but true works of art.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">More about us</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"16px\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"style\":{\"spacing\":{\"blockGap\":\"18px\"}}} -->\n<div class=\"wp-block-column\"><!-- wp:image {\"lightbox\":{\"enabled\":true},\"id\":266,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"large\",\"linkDestination\":\"none\",\"className\":\"is-style-default\"} -->\n<figure class=\"wp-block-image size-large is-style-default\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/07/a0c4b80dc701de6a1143de003da3ef95-1-768x1024.jpeg\" alt=\"\" class=\"wp-image-266\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"lightbox\":{\"enabled\":true},\"id\":88,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"is-style-default\"} -->\n<figure class=\"wp-block-image size-full is-style-default\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/06/white-vase-decoration-pattern-ceramic-lamp.jpg\" alt=\"\" class=\"wp-image-88\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"style\":{\"spacing\":{\"blockGap\":\"18px\"}}} -->\n<div class=\"wp-block-column\"><!-- wp:image {\"lightbox\":{\"enabled\":true},\"id\":62,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"is-style-default\"} -->\n<figure class=\"wp-block-image size-full is-style-default\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/06/plant-white-leaf-flower-vase-green.jpg\" alt=\"\" class=\"wp-image-62\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"lightbox\":{\"enabled\":true},\"id\":69,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"is-style-default\"} -->\n<figure class=\"wp-block-image size-full is-style-default\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/06/tree-branch-plant-wood-leaf-flower.jpg\" alt=\"\" class=\"wp-image-69\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:90:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/content-with-grid-of-images-on-right/\";s:13:\"modified_date\";s:19:\"2024-07-18 12:15:00\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:29;a:18:{s:2:\"ID\";i:311;s:7:\"site_id\";i:231214916;s:5:\"title\";s:26:\"Pull left, fullwidth image\";s:4:\"name\";s:25:\"pull-left-fullwidth-image\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3473:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"40%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:40%\"><!-- wp:paragraph -->\n<p>We believe that your home should be a reflection of your unique style and personality. Our curated collection of home essentials and decor pieces is designed to help you create a space that feels truly like you. From cozy furnishings to stylish accents, we offer everything you need to turn your house into a home.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"60%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:60%\"></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:image {\"id\":63,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"align\":\"full\"} -->\n<figure class=\"wp-block-image alignfull size-full\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/06/table-wood-house-chair-floor-window-1.jpg\" alt=\"\" class=\"wp-image-63\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:79:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/pull-left-fullwidth-image/\";s:13:\"modified_date\";s:19:\"2024-07-01 16:24:14\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:30;a:18:{s:2:\"ID\";i:309;s:7:\"site_id\";i:231214916;s:5:\"title\";s:21:\"Right-aligned content\";s:4:\"name\";s:21:\"right-aligned-content\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3470:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"40%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:40%\"></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"\"} -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p>We are dedicated to crafting timeless pieces that stand the test of time. Each garment and accessory in our collection is a testament to our unwavering commitment to quality and craftsmanship. We take pride in using only the finest materials and employing meticulous attention to detail in every step of the creation process. From the stitching to the finishing touches, our products are thoughtfully designed to exude durability, longevity, and timeless elegance. When you shop with us, you can trust that you\'re investing in items that are not only stylish but also built to last, ensuring years of enjoyment and wear. We believe in fashion that not only looks good but also does good for the planet and its people. That\'s why we\'re dedicated to reducing the environmental and social impact of the clothing and accessories industry. When you shop with us, you can feel confident knowing that your purchase supports a more sustainable and ethical approach to fashion, making a positive difference in the world.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:75:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/right-aligned-content/\";s:13:\"modified_date\";s:19:\"2024-07-01 16:23:24\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:31;a:18:{s:2:\"ID\";i:306;s:7:\"site_id\";i:231214916;s:5:\"title\";s:35:\"Large heading with content on right\";s:4:\"name\";s:39:\"large-heading-with-content-on-the-right\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3440:\"<!-- wp:group {\"metadata\":{\"name\":\"About\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"verticalAlignment\":\"top\",\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide are-vertically-aligned-top\"><!-- wp:column {\"verticalAlignment\":\"top\",\"width\":\"50%\",\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-column is-vertically-aligned-top\" style=\"flex-basis:50%\"><!-- wp:heading {\"fontSize\":\"xx-large\"} -->\n<h2 class=\"wp-block-heading has-xx-large-font-size\">Create anything</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"top\",\"width\":\"50%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-top\" style=\"flex-basis:50%\"><!-- wp:paragraph -->\n<p>Welcome to a world of limitless possibilities, where the journey is as exhilarating as the destination, and where every moment is an opportunity to make your mark on the canvas of existence. The only limit is the extent of your imagination.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Get Started</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|10\"} -->\n<div style=\"height:var(--wp--preset--spacing--10)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:93:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/large-heading-with-content-on-the-right/\";s:13:\"modified_date\";s:19:\"2024-07-01 16:22:38\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:32;a:18:{s:2:\"ID\";i:303;s:7:\"site_id\";i:231214916;s:5:\"title\";s:29:\"Tall content with image right\";s:4:\"name\";s:29:\"tall-content-with-image-right\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3981:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"right\":\"0\"},\"blockGap\":\"var:preset|spacing|30\"},\"dimensions\":{\"minHeight\":\"100%\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"verticalAlignment\":\"space-between\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"min-height:100%;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><!-- wp:heading {\"fontSize\":\"x-large\"} -->\n<h2 class=\"wp-block-heading has-x-large-font-size\">Discover a world of possibilities</h2>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"layout\":{\"type\":\"constrained\",\"contentSize\":\"400px\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph -->\n<p>We believe that your home should be a reflection of your unique style and personality. Our curated collection of home essentials and decor pieces is designed to help you create a space that feels truly like you. From cozy furnishings to stylish accents, we offer everything you need to turn your house into a home.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Meet us</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":304,\"aspectRatio\":\"3/4\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/07/54f708281f82831c082a1cf9d7b7faa9-1.jpeg\" alt=\"\" class=\"wp-image-304\" style=\"aspect-ratio:3/4;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:83:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/tall-content-with-image-right/\";s:13:\"modified_date\";s:19:\"2024-07-01 15:58:41\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:33;a:18:{s:2:\"ID\";i:301;s:7:\"site_id\";i:231214916;s:5:\"title\";s:24:\"Spread right, heavy text\";s:4:\"name\";s:23:\"spread-right-heavy-text\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3950:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|40\"}}}} -->\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"40%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:40%\"><!-- wp:image {\"id\":69,\"aspectRatio\":\"2/3\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/06/tree-branch-plant-wood-leaf-flower.jpg\" alt=\"\" class=\"wp-image-69\" style=\"aspect-ratio:2/3;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"50%\",\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:50%\"><!-- wp:paragraph {\"fontSize\":\"small\"} -->\n<p class=\"has-small-font-size\">About us</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Step into a world of botanical beauty</h2>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph -->\n<p>With a passion for all things leafy, we offer a diverse collection of plants, from lush foliage to exotic blooms, to bring the beauty of nature into your home. Whether you\'re a seasoned plant parent or just beginning your green journey, our friendly team is here to help you find the perfect plant companion.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">More about us</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:77:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/spread-right-heavy-text/\";s:13:\"modified_date\";s:19:\"2024-07-18 12:07:51\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:34;a:18:{s:2:\"ID\";i:299;s:7:\"site_id\";i:231214916;s:5:\"title\";s:28:\"Heading with button and text\";s:4:\"name\";s:28:\"heading-with-button-and-text\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3802:\"<!-- wp:group {\"metadata\":{\"name\":\"About\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center\"><!-- wp:column {\"width\":\"50%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:heading {\"textAlign\":\"left\",\"fontSize\":\"x-large\"} -->\n<h2 class=\"wp-block-heading has-text-align-left has-x-large-font-size\">Discover a world of possibilities</h2>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":\"8px\"} -->\n<div style=\"height:8px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"left\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Get Started</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"50%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:paragraph {\"style\":{\"layout\":{\"selfStretch\":\"fixed\",\"flexSize\":\"70%\"}}} -->\n<p>We believe that your home should be a reflection of your unique style and personality. Our curated collection of home essentials and decor pieces is designed to help you create a space that feels truly like you.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"layout\":{\"selfStretch\":\"fixed\",\"flexSize\":\"70%\"}}} -->\n<p>Our expert designers will work closely with you to bring your vision to life. From furniture selection to color schemes, we\'ll provide professional advice and guidance every step of the way to help you achieve the perfect balance of comfort, functionality, and aesthetic appeal.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:82:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/heading-with-button-and-text/\";s:13:\"modified_date\";s:19:\"2024-07-01 15:56:19\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:35;a:18:{s:2:\"ID\";i:297;s:7:\"site_id\";i:231214916;s:5:\"title\";s:20:\"Left-aligned content\";s:4:\"name\";s:22:\"left-aligned-content-2\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:2881:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"var:preset|spacing|20\"} -->\n<div style=\"height:var(--wp--preset--spacing--20)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|40\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"\"} -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p>As we navigate the intricate tapestry of existence, we are constantly presented with choices, each a potential pathway to something extraordinary. This is a world where creativity knows no bounds, where the curious mind finds solace, and where the fearless heart discovers uncharted territories. It is a place where the pursuit of knowledge, the embrace of change, and the willingness to take risks are not mere options but essential ingredients for a life well-lived.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Welcome to a world of limitless possibilities, where the journey is as exhilarating as the destination, and where every moment is an opportunity to make your mark on the canvas of existence. The only limit is the extent of your imagination.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"40%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:40%\"></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|20\"} -->\n<div style=\"height:var(--wp--preset--spacing--20)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:76:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/left-aligned-content-2/\";s:13:\"modified_date\";s:19:\"2024-07-01 15:54:34\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:36;a:18:{s:2:\"ID\";i:294;s:7:\"site_id\";i:231214916;s:5:\"title\";s:35:\"Fullwidth image, content pull right\";s:4:\"name\";s:34:\"fullwidth-image-content-pull-right\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3046:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:image {\"id\":295,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"align\":\"full\"} -->\n<figure class=\"wp-block-image alignfull size-full\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/07/90731e071ce29177b55e394f139c6400.jpeg\" alt=\"\" class=\"wp-image-295\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|10\"} -->\n<div style=\"height:var(--wp--preset--spacing--10)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"right\":\"var:preset|spacing|40\",\"left\":\"var:preset|spacing|40\",\"top\":\"var:preset|spacing|10\",\"bottom\":\"var:preset|spacing|10\"}}}} -->\n<div class=\"wp-block-columns alignwide\" style=\"padding-top:var(--wp--preset--spacing--10);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--10);padding-left:var(--wp--preset--spacing--40)\"><!-- wp:column {\"width\":\"60%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:60%\"></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"40%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:40%\"><!-- wp:paragraph -->\n<p>Welcome to your premier destination for premium headphones and audio accessories. Dive into our curated collection, where cutting-edge technology meets sleek design to deliver an unparalleled listening experience. From wireless wonders to noise-canceling marvels, we have the perfect pair to suit every lifestyle and preference.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|10\"} -->\n<div style=\"height:var(--wp--preset--spacing--10)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:88:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/fullwidth-image-content-pull-right/\";s:13:\"modified_date\";s:19:\"2024-07-01 15:53:49\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:37;a:18:{s:2:\"ID\";i:291;s:7:\"site_id\";i:231214916;s:5:\"title\";s:25:\"Content left, image right\";s:4:\"name\";s:24:\"content-left-image-right\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3389:\"<!-- wp:group {\"metadata\":{\"name\":\"About\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"var:preset|spacing|20\"} -->\n<div style=\"height:var(--wp--preset--spacing--20)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|40\"}}}} -->\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"50%\",\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:50%\"><!-- wp:heading {\"level\":4,\"fontSize\":\"small\"} -->\n<h4 class=\"wp-block-heading has-small-font-size\">About us</h4>\n<!-- /wp:heading -->\n\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Elevate your space</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>We specialize in curating exquisite home decor pieces that add an element of elegance to every space. With a keen eye for detail and a commitment to quality, we strive to bring sophistication and charm into your home.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">More about us</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"40%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:40%\"><!-- wp:image {\"id\":292,\"width\":\"521px\",\"height\":\"auto\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full is-resized\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/07/b7754a09d649f4fe4ae390a60df7b556.jpeg\" alt=\"\" class=\"wp-image-292\" style=\"object-fit:cover;width:521px;height:auto\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|20\"} -->\n<div style=\"height:var(--wp--preset--spacing--20)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:78:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/content-left-image-right/\";s:13:\"modified_date\";s:19:\"2024-07-18 12:15:40\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:38;a:18:{s:2:\"ID\";i:289;s:7:\"site_id\";i:231214916;s:5:\"title\";s:27:\"Centered heading and button\";s:4:\"name\";s:27:\"centered-heading-and-button\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:2670:\"<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"fontSize\":\"x-large\"} -->\n<h2 class=\"wp-block-heading has-text-align-center has-x-large-font-size\">Discover a world of possibilities</h2>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":\"8px\"} -->\n<div style=\"height:8px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Get Started</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:81:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/centered-heading-and-button/\";s:13:\"modified_date\";s:19:\"2024-07-01 15:49:09\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:39;a:18:{s:2:\"ID\";i:287;s:7:\"site_id\";i:231214916;s:5:\"title\";s:42:\"Heading with content and large image below\";s:4:\"name\";s:42:\"heading-with-content-and-large-image-below\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:4054:\"<!-- wp:group {\"metadata\":{\"name\":\"About\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|60\"}}}} -->\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center\"><!-- wp:column {\"width\":\"50%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:heading {\"textAlign\":\"left\",\"fontSize\":\"x-large\"} -->\n<h2 class=\"wp-block-heading has-text-align-left has-x-large-font-size\">Embrace<br>sustainable fashion</h2>\n<!-- /wp:heading -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"left\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Discover more</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"50%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:paragraph {\"style\":{\"layout\":{\"selfStretch\":\"fixed\",\"flexSize\":\"70%\"}}} -->\n<p>We believe that fashion should be as kind to the planet as it is to your wardrobe. With a commitment to sustainability and environmental responsibility, we curate a collection of chic and eco-friendly clothing.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"layout\":{\"selfStretch\":\"fixed\",\"flexSize\":\"70%\"}}} -->\n<p>From organic fabrics to recycled materials, every piece in our collection is thoughtfully crafted with the planet in mind.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|30\"} -->\n<div style=\"height:var(--wp--preset--spacing--30)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:image {\"id\":75,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"align\":\"wide\"} -->\n<figure class=\"wp-block-image alignwide size-full\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/06/man-person-winter-photography-statue-coat.png\" alt=\"\" class=\"wp-image-75\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:96:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/heading-with-content-and-large-image-below/\";s:13:\"modified_date\";s:19:\"2024-07-01 15:48:30\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:40;a:18:{s:2:\"ID\";i:284;s:7:\"site_id\";i:231214916;s:5:\"title\";s:30:\"Heading with two media columns\";s:4:\"name\";s:30:\"heading-with-two-media-columns\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:4356:\"<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|30\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"10px\"}}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\" style=\"margin-bottom:10px\"><!-- wp:image {\"id\":285,\"aspectRatio\":\"4/3\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"color\":[]}} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/07/e7e21c3e64f977311b55a59d66aec660.jpeg\" alt=\"\" class=\"wp-image-285\" style=\"aspect-ratio:4/3;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading {\"level\":3,\"fontSize\":\"large\"} -->\n<h3 class=\"wp-block-heading has-large-font-size\">Commitment to sustainability</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>At the heart of our mission is a commitment to sustainability. We prioritize environmentally friendly practices by sourcing locally grown produce, minimizing packaging waste, and championing sustainable farming methods.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:group {\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"10px\"}}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group\" style=\"margin-bottom:10px\"><!-- wp:image {\"id\":273,\"aspectRatio\":\"4/3\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"color\":[]}} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/07/44024b9b9c88dd50f5cf11f5c31311c5-1.jpeg\" alt=\"\" class=\"wp-image-273\" style=\"aspect-ratio:4/3;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:group -->\n\n<!-- wp:heading {\"level\":3,\"fontSize\":\"large\"} -->\n<h3 class=\"wp-block-heading has-large-font-size\">Quality and freshness</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Every step of our process, from meticulous ingredient selection to adhering to stringent standards, reflects our dedication to quality. From the initial harvest to the finished product, we uphold uncompromising standards of freshness and flavor.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:84:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/heading-with-two-media-columns/\";s:13:\"modified_date\";s:19:\"2024-07-01 15:47:28\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:41;a:18:{s:2:\"ID\";i:282;s:7:\"site_id\";i:231214916;s:5:\"title\";s:27:\"Three columns with features\";s:4:\"name\";s:27:\"three-columns-with-features\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:4409:\"<!-- wp:group {\"metadata\":{\"name\":\"About\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|50\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"className\":\"is-service-name\",\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading is-service-name has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Commitment to sustainability</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"className\":\"is-service-description\"} -->\n<p class=\"is-service-description\">At the heart of our mission is a commitment to sustainability. We prioritize environmentally friendly practices by sourcing locally grown produce, minimizing packaging waste, and championing sustainable farming methods.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"className\":\"is-service-name\",\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading is-service-name has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Quality and freshness</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"className\":\"is-service-description\"} -->\n<p class=\"is-service-description\">At our core, we\'re dedicated to delivering excellence. We take great care in selecting only the finest organic fruits and vegetables, adhering to stringent standards to guarantee optimal freshness and flavor.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"className\":\"is-service-name\",\"fontSize\":\"medium\"} -->\n<h3 class=\"wp-block-heading is-service-name has-medium-font-size\" style=\"font-style:normal;font-weight:700\">Community engagement</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"className\":\"is-service-description\"} -->\n<p class=\"is-service-description\">From fostering partnerships with local farmers to active participation in community events, we\'re deeply committed to supporting initiatives focused on food security, nutrition, and overall well-being.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:81:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/three-columns-with-features/\";s:13:\"modified_date\";s:19:\"2024-07-04 14:17:24\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:42;a:18:{s:2:\"ID\";i:279;s:7:\"site_id\";i:231214916;s:5:\"title\";s:36:\"Four image grid, content on the left\";s:4:\"name\";s:35:\"four-image-grid-content-on-the-left\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:5194:\"<!-- wp:group {\"metadata\":{\"name\":\"About\"},\"align\":\"full\",\"className\":\"alignfull\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|40\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"8px\",\"left\":\"8px\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"style\":{\"spacing\":{\"blockGap\":\"8px\"}}} -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":266,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"is-style-default\"} -->\n<figure class=\"wp-block-image size-full is-style-default\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/07/a0c4b80dc701de6a1143de003da3ef95-1.jpeg\" alt=\"\" class=\"wp-image-266\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":88,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"is-style-default\"} -->\n<figure class=\"wp-block-image size-full is-style-default\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/06/white-vase-decoration-pattern-ceramic-lamp.jpg\" alt=\"\" class=\"wp-image-88\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"style\":{\"spacing\":{\"blockGap\":\"8px\"}}} -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":62,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"is-style-default\"} -->\n<figure class=\"wp-block-image size-full is-style-default\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/06/plant-white-leaf-flower-vase-green.jpg\" alt=\"\" class=\"wp-image-62\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":69,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"className\":\"is-style-default\"} -->\n<figure class=\"wp-block-image size-full is-style-default\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/06/tree-branch-plant-wood-leaf-flower.jpg\" alt=\"\" class=\"wp-image-69\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"40%\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"left\",\"contentSize\":\"400px\"}} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:40%\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Crafting beauty</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>We are dedicated to the art of craftsmanship, where each vase is meticulously crafted to perfection. Our passion for detail and commitment to quality shines through in every piece, resulting in vases that are not just functional, but true works of art.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">More about us</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:89:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/four-image-grid-content-on-the-left/\";s:13:\"modified_date\";s:19:\"2024-07-18 12:07:14\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:43;a:18:{s:2:\"ID\";i:277;s:7:\"site_id\";i:231214916;s:5:\"title\";s:30:\"Heading left and content right\";s:4:\"name\";s:30:\"heading-left-and-content-right\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3526:\"<!-- wp:group {\"metadata\":{\"name\":\"About\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"alignfull\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"45%\",\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|20\"}}} -->\n<div class=\"wp-block-column\" style=\"flex-basis:45%\"><!-- wp:heading {\"fontSize\":\"small\"} -->\n<h2 class=\"wp-block-heading has-small-font-size\">Create anything</h2>\n<!-- /wp:heading -->\n\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Discover a world of possibilities</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"55%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:55%\"><!-- wp:spacer {\"height\":\"var:preset|spacing|20\"} -->\n<div style=\"height:var(--wp--preset--spacing--20)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:paragraph -->\n<p>We believe that your home should be a reflection of your unique style and personality. Our curated collection of home essentials and decor pieces is designed to help you create a space that feels truly like you.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Our expert designers will work closely with you to bring your vision to life. From furniture selection to color schemes, we\'ll provide professional advice and guidance every step of the way to help you achieve the perfect balance of comfort, functionality, and aesthetic appeal.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:84:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/heading-left-and-content-right/\";s:13:\"modified_date\";s:19:\"2024-07-01 15:41:54\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:44;a:18:{s:2:\"ID\";i:275;s:7:\"site_id\";i:231214916;s:5:\"title\";s:29:\"Content left with image right\";s:4:\"name\";s:29:\"content-left-with-image-right\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3420:\"<!-- wp:group {\"metadata\":{\"name\":\"About\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"alignfull\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"verticalAlignment\":\"center\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Where cycling dreams take flight</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Founded by avid cyclists with a passion for pedal-powered adventures, we\'re dedicated to providing top-quality bikes, accessories, and expert advice to riders of all levels.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Discover more</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"bottom\"} -->\n<div class=\"wp-block-column is-vertically-aligned-bottom\"><!-- wp:image {\"lightbox\":{\"enabled\":false},\"id\":70,\"aspectRatio\":\"1\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/06/road-sport-vintage-wheel-retro-old.jpg\" alt=\"\" class=\"wp-image-70\" style=\"aspect-ratio:1;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_about\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_about\";s:5:\"title\";s:22:\"_dotcom_imported_about\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:83:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/content-left-with-image-right/\";s:13:\"modified_date\";s:19:\"2024-07-01 15:40:59\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:45;a:18:{s:2:\"ID\";i:269;s:7:\"site_id\";i:231214916;s:5:\"title\";s:40:\"Heading with image and two columns below\";s:4:\"name\";s:40:\"heading-with-image-and-two-columns-below\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:4851:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"alignfull\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"align\":\"wide\",\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group alignwide\"><!-- wp:columns {\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}}} -->\n<div class=\"wp-block-columns\" style=\"margin-top:0;margin-bottom:0\"><!-- wp:column {\"width\":\"45%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:45%\"><!-- wp:heading {\"align\":\"wide\"} -->\n<h2 class=\"wp-block-heading alignwide\">Create anything</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"60%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:60%\"></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:image {\"id\":270,\"aspectRatio\":\"16/9\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/07/bc60cf21a37262b760535f0448a60acf-1.jpeg\" alt=\"\" class=\"wp-image-270\" style=\"aspect-ratio:16/9;object-fit:cover\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|20\"} -->\n<div style=\"height:var(--wp--preset--spacing--20)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"verticalAlignment\":\"top\",\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide are-vertically-aligned-top\"><!-- wp:column {\"verticalAlignment\":\"top\",\"width\":\"\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"left\",\"contentSize\":\"420px\"}} -->\n<div class=\"wp-block-column is-vertically-aligned-top\"><!-- wp:heading {\"level\":3} -->\n<h3 class=\"wp-block-heading\">Unleash your creativity at our pottery workshop</h3>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"top\",\"width\":\"40%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-top\" style=\"flex-basis:40%\"><!-- wp:paragraph -->\n<p>Join us for an immersive pottery workshop where you can explore the art of shaping clay. Learn techniques from experienced artisans, unleash your creativity, and create your own unique pieces to take home. Perfect for all skill levels!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Book now</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_intro\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_intro\";s:5:\"title\";s:22:\"_dotcom_imported_intro\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:94:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/heading-with-image-and-two-columns-below/\";s:13:\"modified_date\";s:19:\"2024-07-01 15:35:10\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:46;a:18:{s:2:\"ID\";i:264;s:7:\"site_id\";i:231214916;s:5:\"title\";s:31:\"Heading with three images below\";s:4:\"name\";s:31:\"heading-with-three-images-below\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:4705:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|30\",\"left\":\"var:preset|spacing|60\"}}}} -->\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"66.66%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:66.66%\"><!-- wp:heading {\"align\":\"wide\"} -->\n<h2 class=\"wp-block-heading alignwide\">Beyond function: vases as works of art</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:33.33%\"><!-- wp:paragraph {\"align\":\"left\",\"style\":{\"layout\":{\"selfStretch\":\"fixed\",\"flexSize\":\"70%\"}}} -->\n<p class=\"has-text-align-left\">We are dedicated to the art of craftsmanship, where each vase is meticulously crafted to perfection. Our passion for detail and commitment to quality shines through in every piece, resulting in vases that are not just functional, but true works of art.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|20\"} -->\n<div style=\"height:var(--wp--preset--spacing--20)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|30\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"verticalAlignment\":\"top\"}} -->\n<div class=\"wp-block-group alignwide\"><!-- wp:image {\"id\":266,\"aspectRatio\":\"2/3\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/07/a0c4b80dc701de6a1143de003da3ef95-1.jpeg\" alt=\"\" class=\"wp-image-266\" style=\"aspect-ratio:2/3;object-fit:cover\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":62,\"aspectRatio\":\"2/3\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/06/plant-white-leaf-flower-vase-green.jpg\" alt=\"\" class=\"wp-image-62\" style=\"aspect-ratio:2/3;object-fit:cover\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":69,\"aspectRatio\":\"2/3\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/06/tree-branch-plant-wood-leaf-flower.jpg\" alt=\"\" class=\"wp-image-69\" style=\"aspect-ratio:2/3;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_intro\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_intro\";s:5:\"title\";s:22:\"_dotcom_imported_intro\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:85:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/heading-with-three-images-below/\";s:13:\"modified_date\";s:19:\"2024-07-01 15:26:33\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:47;a:18:{s:2:\"ID\";i:261;s:7:\"site_id\";i:231214916;s:5:\"title\";s:52:\"Full-width cover with heading, paragraph, and button\";s:4:\"name\";s:50:\"full-width-cover-with-heading-paragraph-and-button\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:4040:\"<!-- wp:cover {\"url\":\"https://s0.wp.com/i/woo-block-patterns/2024/07/96bbcf9839d875a42e9aaaada8132a33.jpeg\",\"id\":262,\"dimRatio\":50,\"overlayColor\":\"theme-5\",\"isUserOverlayColor\":true,\"minHeight\":558,\"minHeightUnit\":\"px\",\"style\":{\"spacing\":{\"padding\":{\"right\":\"var:preset|spacing|40\",\"left\":\"var:preset|spacing|40\",\"top\":\"var:preset|spacing|50\",\"bottom\":\"var:preset|spacing|40\"}}},\"className\":\"alignfull\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-cover alignfull\" style=\"padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40);min-height:558px\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-theme-5-background-color has-background-dim\"></span><img class=\"wp-block-cover__image-background wp-image-262\" alt=\"\" src=\"https://s0.wp.com/i/woo-block-patterns/2024/07/96bbcf9839d875a42e9aaaada8132a33.jpeg\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:group {\"metadata\":{\"name\":\"Content\"},\"align\":\"wide\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"},\"padding\":{\"top\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"right\":\"0\"}}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group alignwide\" style=\"margin-top:0;margin-bottom:0;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"stretch\",\"width\":\"66.67%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-stretch\" style=\"flex-basis:66.67%\"><!-- wp:heading {\"textAlign\":\"center\",\"align\":\"wide\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"right\":\"0\"}},\"layout\":{\"selfStretch\":\"fit\",\"flexSize\":null}},\"className\":\"text-balance\",\"fontSize\":\"xx-large\"} -->\n<h2 class=\"wp-block-heading alignwide has-text-align-center text-balance has-xx-large-font-size\" style=\"margin-top:0;margin-right:0;margin-bottom:0;margin-left:0\">Find your shade</h2>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":\"300px\"} -->\n<div style=\"height:300px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">Explore our exclusive collection of sunglasses, crafted to elevate your look and safeguard your eyes. Find your perfect pair and see the world through a new lens.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"justifyContent\":\"left\",\"orientation\":\"horizontal\"},\"style\":{\"layout\":{\"selfStretch\":\"fit\",\"flexSize\":null}}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"theme-1\",\"textColor\":\"theme-5\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|theme-5\"}}}}} --><div class=\"wp-block-button\"><a class=\"wp-block-button__link has-theme-5-color has-theme-1-background-color has-text-color has-background has-link-color wp-element-button\">Shop now</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:columns {\"verticalAlignment\":\"bottom\"} -->\n<div class=\"wp-block-columns are-vertically-aligned-bottom\"><!-- wp:column {\"verticalAlignment\":\"bottom\"} -->\n<div class=\"wp-block-column is-vertically-aligned-bottom\"></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"bottom\"} -->\n<div class=\"wp-block-column is-vertically-aligned-bottom\"></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"bottom\"} -->\n<div class=\"wp-block-column is-vertically-aligned-bottom\"></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:group --></div></div>\n<!-- /wp:cover -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_intro\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_intro\";s:5:\"title\";s:22:\"_dotcom_imported_intro\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:104:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/full-width-cover-with-heading-paragraph-and-button/\";s:13:\"modified_date\";s:19:\"2024-07-01 15:23:05\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:48;a:18:{s:2:\"ID\";i:259;s:7:\"site_id\";i:231214916;s:5:\"title\";s:30:\"Left-aligned header and button\";s:4:\"name\";s:30:\"left-aligned-header-and-button\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:2621:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"align\":\"wide\",\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group alignwide\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Welcome to a world of limitless possibilities, where the journey is as exhilarating as the destination.</h2>\n<!-- /wp:heading -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Learn More</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_intro\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_intro\";s:5:\"title\";s:22:\"_dotcom_imported_intro\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:84:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/left-aligned-header-and-button/\";s:13:\"modified_date\";s:19:\"2024-07-01 15:20:39\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:49;a:18:{s:2:\"ID\";i:254;s:7:\"site_id\";i:231214916;s:5:\"title\";s:20:\"Left-aligned content\";s:4:\"name\";s:20:\"left-aligned-content\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3792:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\"},\"align\":\"full\",\"className\":\"alignfull\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"verticalAlignment\":\"center\",\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|30\"}}} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:heading {\"textAlign\":\"left\",\"fontSize\":\"xx-large\"} -->\n<h2 class=\"wp-block-heading has-text-align-left has-xx-large-font-size\">A world of possibilities</h2>\n<!-- /wp:heading -->\n\n<!-- wp:columns {\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"0\",\"left\":\"0\"}}}} -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"80%\",\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|30\"}}} -->\n<div class=\"wp-block-column\" style=\"flex-basis:80%\"><!-- wp:paragraph {\"align\":\"left\",\"style\":{\"layout\":{\"selfStretch\":\"fixed\",\"flexSize\":\"70%\"}}} -->\n<p class=\"has-text-align-left\">Welcome to a world of limitless possibilities, where the journey is as exhilarating as the destination, and where every moment is an opportunity to make your mark on the canvas of existence.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"left\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Get Started</a></div><!-- /wp:button -->\n\n<!-- wp:button {\"className\":\"is-style-outline\"} --><div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link wp-element-button\">Learn more</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_intro\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_intro\";s:5:\"title\";s:22:\"_dotcom_imported_intro\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:74:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/left-aligned-content/\";s:13:\"modified_date\";s:19:\"2024-07-23 14:32:19\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:50;a:18:{s:2:\"ID\";i:252;s:7:\"site_id\";i:231214916;s:5:\"title\";s:32:\"Pull right with wide image below\";s:4:\"name\";s:32:\"pull-right-with-wide-image-below\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3885:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"alignfull\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"50%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:heading {\"fontSize\":\"x-large\"} -->\n<h2 class=\"wp-block-heading has-x-large-font-size\">Ride into adventure</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Zoom through the streets on this premium 3-speed bike. Manufactured and assembled in Germany in the 80s.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Shop now</a></div><!-- /wp:button -->\n\n<!-- wp:button {\"className\":\"is-style-outline\"} --><div class=\"wp-block-button is-style-outline\"><a class=\"wp-block-button__link wp-element-button\">Discover collection</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"30%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:30%\"></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:image {\"id\":70,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"align\":\"wide\",\"className\":\"is-style-default\"} -->\n<figure class=\"wp-block-image alignwide size-full is-style-default\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/06/road-sport-vintage-wheel-retro-old.jpg\" alt=\"\" class=\"wp-image-70\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_intro\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_intro\";s:5:\"title\";s:22:\"_dotcom_imported_intro\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:86:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/pull-right-with-wide-image-below/\";s:13:\"modified_date\";s:19:\"2024-07-01 15:17:04\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:51;a:18:{s:2:\"ID\";i:249;s:7:\"site_id\";i:231214916;s:5:\"title\";s:39:\"Fullwidth image with content and button\";s:4:\"name\";s:39:\"fullwidth-image-with-content-and-button\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3735:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\",\"categories\":[\"intro\"],\"patternName\":\"a8c/intro-fullwidth-image-with-content-and-button-2\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"alignfull\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:0;padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:cover {\"url\":\"https://s1.wp.com/i/woo-block-patterns/2024/07/0ad9cb5f991125c89fc952521795a1e6-1.jpeg\",\"id\":250,\"dimRatio\":0,\"customOverlayColor\":\"#FFF\",\"isUserOverlayColor\":true,\"minHeight\":550,\"minHeightUnit\":\"px\",\"isDark\":false,\"align\":\"full\"} -->\n<div class=\"wp-block-cover alignfull is-light\" style=\"min-height:550px\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-0 has-background-dim\" style=\"background-color:#FFF\"></span><img class=\"wp-block-cover__image-background wp-image-250\" alt=\"\" src=\"https://s1.wp.com/i/woo-block-patterns/2024/07/0ad9cb5f991125c89fc952521795a1e6-1.jpeg\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:spacer -->\n<div style=\"height:100px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"align\":\"wide\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignwide\"><!-- wp:heading {\"textAlign\":\"center\",\"textColor\":\"ast-global-color-2\"} -->\n<h2 class=\"wp-block-heading has-text-align-center has-ast-global-color-2-color has-text-color\">Vintage vinyl treasures</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">Step back in time and groove to the melodies of vinyl records. Dive into our eclectic collection, where each record spins tales of nostalgia and magic.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\",\"orientation\":\"horizontal\",\"flexWrap\":\"wrap\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Shop vinyl records</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_intro\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_intro\";s:5:\"title\";s:22:\"_dotcom_imported_intro\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:93:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/fullwidth-image-with-content-and-button/\";s:13:\"modified_date\";s:19:\"2024-07-01 15:15:23\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:52;a:18:{s:2:\"ID\";i:247;s:7:\"site_id\";i:231214916;s:5:\"title\";s:26:\"Large left-aligned heading\";s:4:\"name\";s:26:\"large-left-aligned-heading\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:2447:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\",\"categories\":[\"intro\"],\"patternName\":\"a8c/intro-left-aligned-header-and-button\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"align\":\"wide\",\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group alignwide\"><!-- wp:heading -->\n<h2 class=\"wp-block-heading\">A world filled with boundless opportunities and endless potential</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_intro\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_intro\";s:5:\"title\";s:22:\"_dotcom_imported_intro\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:80:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/large-left-aligned-heading/\";s:13:\"modified_date\";s:19:\"2024-07-01 15:11:33\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:53;a:18:{s:2:\"ID\";i:244;s:7:\"site_id\";i:231214916;s:5:\"title\";s:37:\"Centered heading with two column text\";s:4:\"name\";s:37:\"centered-heading-with-two-column-text\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:4449:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\",\"categories\":[\"intro\"],\"patternName\":\"a8c/centered-heading-with-two-column-text\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"alignfull\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"15%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:15%\"></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"70%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:70%\"><!-- wp:heading {\"textAlign\":\"center\",\"fontSize\":\"xx-large\"} -->\n<h2 class=\"wp-block-heading has-text-align-center has-xx-large-font-size\">Welcome home</h2>\n<!-- /wp:heading -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"textAlign\":\"center\"} --><div class=\"wp-block-button\"><a class=\"wp-block-button__link has-text-align-center wp-element-button\">Get Started</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"15%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:15%\"></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p>We believe that your home should be a reflection of your unique style and personality. Our curated collection of home essentials and decor pieces is designed to help you create a space that feels truly like you. From cozy furnishings to stylish accents, we offer everything you need to turn your house into a home.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:paragraph -->\n<p>Our expert designers will work closely with you to bring your vision to life. From furniture selection to color schemes, we\'ll provide professional advice and guidance every step of the way to help you achieve the perfect balance of comfort, functionality, and aesthetic appeal.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_intro\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_intro\";s:5:\"title\";s:22:\"_dotcom_imported_intro\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:91:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/centered-heading-with-two-column-text/\";s:13:\"modified_date\";s:19:\"2024-07-01 15:08:38\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:54;a:18:{s:2:\"ID\";i:243;s:7:\"site_id\";i:231214916;s:5:\"title\";s:33:\"Two column with image and content\";s:4:\"name\";s:35:\"two-column-with-image-and-content-2\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3498:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"alignfull\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"verticalAlignment\":\"center\",\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|40\"}}}} -->\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center\"><!-- wp:column {\"verticalAlignment\":\"center\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:image {\"id\":69,\"aspectRatio\":\"3/4\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/06/tree-branch-plant-wood-leaf-flower.jpg\" alt=\"\" class=\"wp-image-69\" style=\"aspect-ratio:3/4;object-fit:cover\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:heading {\"fontSize\":\"xx-large\"} -->\n<h2 class=\"wp-block-heading has-xx-large-font-size\">Elevate your greenery</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Spruce up your plants with our delightful ceramic pots, lovingly crafted to bring joy to your indoor and outdoor spaces.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Shop now</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_intro\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_intro\";s:5:\"title\";s:22:\"_dotcom_imported_intro\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:89:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/two-column-with-image-and-content-2/\";s:13:\"modified_date\";s:19:\"2024-07-04 14:02:00\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:55;a:18:{s:2:\"ID\";i:242;s:7:\"site_id\";i:231214916;s:5:\"title\";s:16:\"Centered content\";s:4:\"name\";s:18:\"centered-content-2\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3583:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"alignfull\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"20%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:20%\"></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"60%\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-column\" style=\"flex-basis:60%\"><!-- wp:heading {\"textAlign\":\"center\",\"fontSize\":\"xx-large\"} -->\n<h2 class=\"wp-block-heading has-text-align-center has-xx-large-font-size\">Ride into adventure</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"layout\":{\"selfStretch\":\"fixed\",\"flexSize\":\"70%\"}}} -->\n<p class=\"has-text-align-center\">Welcome to your ultimate destination for high-quality bikes that fuel your passion for adventure. Whether you\'re a casual rider, a mountain biking enthusiast, or a road cycling pro, our diverse range of bikes promises to elevate your riding experience. Each bike is crafted with precision, combining cutting-edge technology and superior craftsmanship.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Explore our collection</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"20%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:20%\"></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_intro\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_intro\";s:5:\"title\";s:22:\"_dotcom_imported_intro\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:72:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/centered-content-2/\";s:13:\"modified_date\";s:19:\"2024-07-01 15:06:53\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:56;a:18:{s:2:\"ID\";i:241;s:7:\"site_id\";i:231214916;s:5:\"title\";s:39:\"Content with button and fullwidth image\";s:4:\"name\";s:41:\"content-with-button-and-fullwidth-image-3\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3540:\"<!-- wp:group {\"metadata\":{\"name\":\"Intro\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"0\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"alignfull\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:0;padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"align\":\"wide\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignwide\"><!-- wp:heading {\"textAlign\":\"center\",\"textColor\":\"ast-global-color-2\"} -->\n<h2 class=\"wp-block-heading has-text-align-center has-ast-global-color-2-color has-text-color\">Sit back and relax</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">With a wide range of designer chairs to elevate your living space.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\",\"orientation\":\"horizontal\",\"flexWrap\":\"wrap\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Shop now</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:cover {\"url\":\"https://s1.wp.com/i/woo-block-patterns/2024/06/fa0e410e907dc5ba65806d0a9e45c89c.jpeg\",\"id\":231,\"dimRatio\":0,\"customOverlayColor\":\"#FFF\",\"isUserOverlayColor\":true,\"minHeight\":550,\"minHeightUnit\":\"px\",\"isDark\":false,\"align\":\"full\"} -->\n<div class=\"wp-block-cover alignfull is-light\" style=\"min-height:550px\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-0 has-background-dim\" style=\"background-color:#FFF\"></span><img class=\"wp-block-cover__image-background wp-image-231\" alt=\"\" src=\"https://s1.wp.com/i/woo-block-patterns/2024/06/fa0e410e907dc5ba65806d0a9e45c89c.jpeg\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:spacer -->\n<div style=\"height:100px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div></div>\n<!-- /wp:cover --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_intro\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_intro\";s:5:\"title\";s:22:\"_dotcom_imported_intro\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:95:\"https://wooblockpatterns.wpcomstaging.com/2024/07/01/content-with-button-and-fullwidth-image-3/\";s:13:\"modified_date\";s:19:\"2024-07-05 09:58:45\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:57;a:18:{s:2:\"ID\";i:239;s:7:\"site_id\";i:231214916;s:5:\"title\";s:41:\"Left-aligned content overlaid on an image\";s:4:\"name\";s:43:\"left-aligned-content-overlaid-on-an-image-2\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3486:\"<!-- wp:cover {\"url\":\"https://s1.wp.com/i/woo-block-patterns/2024/06/man-person-music-black-and-white-white-photography.jpg\",\"id\":79,\"dimRatio\":30,\"customOverlayColor\":\"#010101\",\"isUserOverlayColor\":true,\"focalPoint\":{\"x\":0.45,\"y\":0.19},\"contentPosition\":\"bottom left\",\"style\":{\"spacing\":{\"padding\":{\"right\":\"var:preset|spacing|40\",\"left\":\"var:preset|spacing|40\",\"top\":\"var:preset|spacing|40\",\"bottom\":\"var:preset|spacing|40\"}}},\"className\":\"alignfull\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-cover has-custom-content-position is-position-bottom-left alignfull\" style=\"padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40)\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-30 has-background-dim\" style=\"background-color:#010101\"></span><img class=\"wp-block-cover__image-background wp-image-79\" alt=\"\" src=\"https://s1.wp.com/i/woo-block-patterns/2024/06/man-person-music-black-and-white-white-photography.jpg\" style=\"object-position:45% 19%\" data-object-fit=\"cover\" data-object-position=\"45% 19%\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:group {\"metadata\":{\"name\":\"Content\"},\"align\":\"wide\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"},\"padding\":{\"top\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"right\":\"0\"}}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group alignwide\" style=\"margin-top:0;margin-bottom:0;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><!-- wp:spacer {\"height\":\"var:preset|spacing|80\"} -->\n<div style=\"height:var(--wp--preset--spacing--80)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"var:preset|spacing|20\"}},\"layout\":{\"type\":\"constrained\",\"contentSize\":\"700px\",\"wideSize\":\"960px\",\"justifyContent\":\"left\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"textAlign\":\"left\",\"align\":\"wide\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"right\":\"0\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"#fefefe\"}}},\"color\":{\"text\":\"#fefefe\"}},\"className\":\"text-balance\",\"fontSize\":\"xx-large\"} -->\n<h2 class=\"wp-block-heading alignwide has-text-align-left text-balance has-text-color has-link-color has-xx-large-font-size\" style=\"color:#fefefe;margin-top:0;margin-right:0;margin-bottom:0;margin-left:0\">Sounds like no other</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"left\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"#fefefe\"}}},\"color\":{\"text\":\"#fefefe\"},\"spacing\":{\"margin\":{\"bottom\":\"var:preset|spacing|30\"}}}} -->\n<p class=\"has-text-align-left has-text-color has-link-color\" style=\"color:#fefefe;margin-bottom:var(--wp--preset--spacing--30)\">Experience your music like never before with our latest generation of hi-fidelity headphones.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"align\":\"wide\",\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"justifyContent\":\"left\"}} -->\n<div class=\"wp-block-buttons alignwide\"><!-- wp:button {\"backgroundColor\":\"theme-1\",\"textColor\":\"theme-5\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|theme-5\"}}}}} --><div class=\"wp-block-button\"><a class=\"wp-block-button__link has-theme-5-color has-theme-1-background-color has-text-color has-background has-link-color wp-element-button\">Shop now</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group --></div></div>\n<!-- /wp:cover -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_intro\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_intro\";s:5:\"title\";s:22:\"_dotcom_imported_intro\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:97:\"https://wooblockpatterns.wpcomstaging.com/2024/06/28/left-aligned-content-overlaid-on-an-image-2/\";s:13:\"modified_date\";s:19:\"2024-07-05 10:42:03\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:58;a:18:{s:2:\"ID\";i:235;s:7:\"site_id\";i:231214916;s:5:\"title\";s:43:\"Center-aligned content overlaid on an image\";s:4:\"name\";s:44:\"fullwidth-image-with-call-to-action-overlaid\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3467:\"<!-- wp:cover {\"url\":\"https://s0.wp.com/i/woo-block-patterns/2024/06/8d8416beec2ca80653d3b811bf6b1f77.jpeg\",\"id\":237,\"dimRatio\":20,\"customOverlayColor\":\"#010101\",\"isUserOverlayColor\":true,\"style\":{\"spacing\":{\"padding\":{\"right\":\"var:preset|spacing|40\",\"left\":\"var:preset|spacing|40\",\"top\":\"var:preset|spacing|40\",\"bottom\":\"var:preset|spacing|40\"}},\"color\":{\"text\":\"#ffffff\"},\"elements\":{\"link\":{\"color\":{\"text\":\"#ffffff\"}}}},\"className\":\"alignfull\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-cover alignfull has-text-color has-link-color\" style=\"color:#ffffff;padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40)\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-20 has-background-dim\" style=\"background-color:#010101\"></span><img class=\"wp-block-cover__image-background wp-image-237\" alt=\"\" src=\"https://s0.wp.com/i/woo-block-patterns/2024/06/8d8416beec2ca80653d3b811bf6b1f77.jpeg\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:group {\"metadata\":{\"name\":\"Content\"},\"align\":\"wide\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\"},\"padding\":{\"top\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"right\":\"0\"}}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group alignwide\" style=\"margin-top:0;margin-bottom:0;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><!-- wp:spacer {\"height\":\"var:preset|spacing|70\"} -->\n<div style=\"height:var(--wp--preset--spacing--70)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"layout\":{\"type\":\"constrained\",\"contentSize\":\"\",\"wideSize\":\"580px\"}} -->\n<div class=\"wp-block-group\"><!-- wp:heading {\"textAlign\":\"center\",\"align\":\"wide\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"right\":\"0\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"#fefefe\"}}},\"color\":{\"text\":\"#fefefe\"}},\"className\":\"text-balance\",\"fontSize\":\"xx-large\"} -->\n<h2 class=\"wp-block-heading alignwide has-text-align-center text-balance has-text-color has-link-color has-xx-large-font-size\" style=\"color:#fefefe;margin-top:0;margin-right:0;margin-bottom:0;margin-left:0\">Find your groove</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"#fefefe\"}}},\"color\":{\"text\":\"#fefefe\"}}} -->\n<p class=\"has-text-align-center has-text-color has-link-color\" style=\"color:#fefefe\">Embark on a musical adventure, where every chord is a step towards harmony. Discover guitars of all shapes, sizes, and melodies.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"justifyContent\":\"center\"},\"style\":{\"layout\":{\"selfStretch\":\"fit\",\"flexSize\":null}}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"theme-1\",\"textColor\":\"theme-5\",\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|theme-5\"}}}}} --><div class=\"wp-block-button\"><a class=\"wp-block-button__link has-theme-5-color has-theme-1-background-color has-text-color has-background has-link-color wp-element-button\">Discover collection</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|70\"} -->\n<div style=\"height:var(--wp--preset--spacing--70)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group --></div></div>\n<!-- /wp:cover -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_intro\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_intro\";s:5:\"title\";s:22:\"_dotcom_imported_intro\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:98:\"https://wooblockpatterns.wpcomstaging.com/2024/06/28/fullwidth-image-with-call-to-action-overlaid/\";s:13:\"modified_date\";s:19:\"2024-07-05 09:24:31\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:59;a:18:{s:2:\"ID\";i:224;s:7:\"site_id\";i:231214916;s:5:\"title\";s:39:\"Fullwidth content with background image\";s:4:\"name\";s:39:\"fullwidth-content-with-background-image\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:2606:\"<!-- wp:cover {\"url\":\"https://s0.wp.com/i/woo-block-patterns/2024/06/772d1d20f57861f0aa71dccda165b03e.jpeg\",\"id\":222,\"dimRatio\":0,\"overlayColor\":\"theme-5\",\"isUserOverlayColor\":true,\"minHeightUnit\":\"vh\",\"isDark\":false,\"metadata\":{\"name\":\"Intro\"},\"align\":\"full\",\"className\":\"alignfull\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|20\",\"bottom\":\"var:preset|spacing|20\",\"left\":\"var:preset|spacing|40\",\"right\":\"var:preset|spacing|40\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-cover alignfull is-light\" style=\"margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--20);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--20);padding-left:var(--wp--preset--spacing--40)\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-theme-5-background-color has-background-dim-0 has-background-dim\"></span><img class=\"wp-block-cover__image-background wp-image-222\" alt=\"\" src=\"https://s0.wp.com/i/woo-block-patterns/2024/06/772d1d20f57861f0aa71dccda165b03e.jpeg\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:spacer {\"height\":\"var:preset|spacing|50\"} -->\n<div style=\"height:var(--wp--preset--spacing--50)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"metadata\":{\"name\":\"Content\"},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"align\":\"center\",\"fontSize\":\"xx-large\"} -->\n<p class=\"has-text-align-center has-xx-large-font-size\">Craft your Story</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">Welcome to the place where the journey of a thousand stories begins. Embrace the transformative power of writing, and let your voice echo through the pages of time. Join us, and turn your imagination into reality.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|10\",\"style\":{\"layout\":[]}} -->\n<div style=\"height:var(--wp--preset--spacing--10)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\">Discover more</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"var:preset|spacing|50\"} -->\n<div style=\"height:var(--wp--preset--spacing--50)\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div></div>\n<!-- /wp:cover -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:22:\"_dotcom_imported_intro\";a:3:{s:4:\"slug\";s:22:\"_dotcom_imported_intro\";s:5:\"title\";s:22:\"_dotcom_imported_intro\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:93:\"https://wooblockpatterns.wpcomstaging.com/2024/06/28/fullwidth-content-with-background-image/\";s:13:\"modified_date\";s:19:\"2024-07-24 11:18:13\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:60;a:18:{s:2:\"ID\";i:208;s:7:\"site_id\";i:231214916;s:5:\"title\";s:32:\"Small Discount Banner with Image\";s:4:\"name\";s:32:\"small-discount-banner-with-image\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:2269:\"<!-- wp:columns {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/small-discount-banner-with-image\",\"name\":\"Small Discount Banner with Image\"},\"style\":{\"color\":{\"background\":\"#fcf8e1\"},\"spacing\":{\"padding\":{\"top\":\"20px\",\"right\":\"20px\",\"bottom\":\"20px\",\"left\":\"20px\"}}}} -->\n<div class=\"wp-block-columns has-background\" style=\"background-color:#fcf8e1;padding-top:20px;padding-right:20px;padding-bottom:20px;padding-left:20px\"><!-- wp:column {\"width\":\"45%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:45%\"><!-- wp:group {\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\"},\"padding\":{\"left\":\"25px\",\"top\":\"25px\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group\" style=\"margin-top:0;padding-top:25px;padding-left:25px\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"300\",\"lineHeight\":\"1\",\"fontSize\":\"30px\"}}} -->\n<p style=\"font-size:30px;font-style:normal;font-weight:300;line-height:1\"><em>Chairs</em></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"300\",\"lineHeight\":\"0\",\"fontSize\":\"30px\"},\"color\":{\"text\":\"#74227b\"},\"elements\":{\"link\":{\"color\":{\"text\":\"#74227b\"}}}}} -->\n<p class=\"has-text-color has-link-color\" style=\"color:#74227b;font-size:30px;font-style:normal;font-weight:300;line-height:0\"><em>from</em></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#74227b\"},\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"900\",\"fontSize\":\"52px\",\"lineHeight\":\"1.2\"},\"elements\":{\"link\":{\"color\":{\"text\":\"#74227b\"}}}}} -->\n<p class=\"has-text-color has-link-color\" style=\"color:#74227b;font-size:52px;font-style:normal;font-weight:900;line-height:1.2\"><a href=\"https://wooblockpatterns.wpcomstaging.com/shop/\">$149</a></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":117,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"align\":\"center\"} -->\n<figure class=\"wp-block-image aligncenter size-full\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/06/table-floor-interior-atmosphere-living-room-furniture-square-lg.png\" alt=\"\" class=\"wp-image-117\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:86:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/small-discount-banner-with-image/\";s:13:\"modified_date\";s:19:\"2024-11-06 17:35:31\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:61;a:18:{s:2:\"ID\";i:206;s:7:\"site_id\";i:231214916;s:5:\"title\";s:13:\"Shop by Price\";s:4:\"name\";s:13:\"shop-by-price\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:11069:\"<!-- wp:columns {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/shop-by-price\",\"name\":\"Shop by Price\"},\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"25%\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"},\"blockGap\":\"10px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-column\" style=\"padding-top:0;padding-right:0;padding-bottom:0;padding-left:0;flex-basis:25%\"><!-- wp:cover {\"customOverlayColor\":\"#e09300\",\"isUserOverlayColor\":true,\"minHeight\":130,\"minHeightUnit\":\"px\",\"contentPosition\":\"top left\",\"isDark\":false,\"style\":{\"spacing\":{\"blockGap\":\"0em\",\"padding\":{\"top\":\"0.8em\"}}},\"className\":\"is-light has-background-color has-text-color\"} -->\n<div class=\"wp-block-cover is-light has-custom-content-position is-position-top-left has-background-color has-text-color\" style=\"padding-top:0.8em;min-height:130px\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-100 has-background-dim\" style=\"background-color:#e09300\"></span><div class=\"wp-block-cover__inner-container\"><!-- wp:paragraph {\"align\":\"left\",\"placeholder\":\"Write title…\",\"style\":{\"typography\":{\"fontSize\":\"0.7em\",\"lineHeight\":\"1\"},\"spacing\":{\"margin\":{\"top\":\"0px\",\"bottom\":\"5px\"}},\"color\":{\"text\":\"#ffffff\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|base\"}}}}} -->\n<p class=\"has-text-align-left has-text-color has-link-color\" style=\"color:#ffffff;margin-top:0px;margin-bottom:5px;font-size:0.7em;line-height:1\"><a style=\"text-decoration:none\" href=\"/shop/?rating_filter=5\">Highest</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"0.7em\",\"lineHeight\":\"1\"},\"spacing\":{\"margin\":{\"top\":\"0px\",\"bottom\":\"5px\"}},\"color\":{\"text\":\"#ffffff\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|base\"}}}},\"fontSize\":\"large\"} -->\n<p class=\"has-text-color has-link-color has-large-font-size\" style=\"color:#ffffff;margin-top:0px;margin-bottom:5px;font-size:0.7em;line-height:1\"><strong><a style=\"text-decoration:none\" href=\"/shop/?rating_filter=5\">rated</a></strong></p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\",\"verticalAlignment\":\"center\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"textColor\":\"contrast\",\"style\":{\"border\":{\"width\":\"0px\",\"style\":\"none\"},\"spacing\":{\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"is-style-outline\",\"fontSize\":\"small\"} --><div class=\"wp-block-button has-custom-font-size is-style-outline has-small-font-size\"><a class=\"wp-block-button__link has-contrast-color has-text-color wp-element-button\" href=\"/shop/?rating_filter=5\" style=\"border-style:none;border-width:0px;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><strong>Outdoor Furniture &amp; Accessories</strong></a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"25%\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"},\"blockGap\":\"10px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-column\" style=\"padding-top:0;padding-right:0;padding-bottom:0;padding-left:0;flex-basis:25%\"><!-- wp:cover {\"customOverlayColor\":\"#6f64f1\",\"isUserOverlayColor\":true,\"minHeight\":130,\"minHeightUnit\":\"px\",\"contentPosition\":\"top left\",\"style\":{\"spacing\":{\"blockGap\":\"0.8em\",\"padding\":{\"top\":\"0.8em\"}}},\"className\":\"has-background-color has-text-color\"} -->\n<div class=\"wp-block-cover has-custom-content-position is-position-top-left has-background-color has-text-color\" style=\"padding-top:0.8em;min-height:130px\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-100 has-background-dim\" style=\"background-color:#6f64f1\"></span><div class=\"wp-block-cover__inner-container\"><!-- wp:paragraph {\"align\":\"left\",\"placeholder\":\"Write title…\",\"style\":{\"typography\":{\"fontSize\":\"0.7em\",\"lineHeight\":\"1\"},\"spacing\":{\"margin\":{\"top\":\"0px\",\"bottom\":\"5px\"}},\"color\":{\"text\":\"#ffffff\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|base\"}}}}} -->\n<p class=\"has-text-align-left has-text-color has-link-color\" style=\"color:#ffffff;margin-top:0px;margin-bottom:5px;font-size:0.7em;line-height:1\"><a style=\"text-decoration:none\" href=\"/shop/?max_price=15\">Under</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"0.7em\",\"lineHeight\":\"1\"},\"spacing\":{\"margin\":{\"top\":\"0px\",\"bottom\":\"5px\"}},\"color\":{\"text\":\"#ffffff\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|base\"}}}},\"fontSize\":\"large\"} -->\n<p class=\"has-text-color has-link-color has-large-font-size\" style=\"color:#ffffff;margin-top:0px;margin-bottom:5px;font-size:0.7em;line-height:1\"><strong><a style=\"text-decoration:none\" href=\"/shop/?max_price=15\">$15</a></strong></p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\",\"verticalAlignment\":\"center\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"textColor\":\"contrast\",\"style\":{\"border\":{\"width\":\"0px\",\"style\":\"none\"},\"spacing\":{\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"is-style-outline\",\"fontSize\":\"small\"} --><div class=\"wp-block-button has-custom-font-size is-style-outline has-small-font-size\"><a class=\"wp-block-button__link has-contrast-color has-text-color wp-element-button\" href=\"/shop/?max_price=15\" style=\"border-style:none;border-width:0px;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\">\n					<strong>Summer Dinning</strong>\n				</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"25%\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"},\"blockGap\":\"10px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-column\" style=\"padding-top:0;padding-right:0;padding-bottom:0;padding-left:0;flex-basis:25%\"><!-- wp:cover {\"customOverlayColor\":\"#c1d21c\",\"isUserOverlayColor\":true,\"minHeight\":130,\"minHeightUnit\":\"px\",\"contentPosition\":\"top left\",\"style\":{\"spacing\":{\"blockGap\":\"0.8em\",\"padding\":{\"top\":\"0.8em\"}}},\"className\":\"has-background-color has-text-color\"} -->\n<div class=\"wp-block-cover has-custom-content-position is-position-top-left has-background-color has-text-color\" style=\"padding-top:0.8em;min-height:130px\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-100 has-background-dim\" style=\"background-color:#c1d21c\"></span><div class=\"wp-block-cover__inner-container\"><!-- wp:paragraph {\"align\":\"left\",\"placeholder\":\"Write title…\",\"style\":{\"typography\":{\"fontSize\":\"0.7em\",\"lineHeight\":\"1\"},\"spacing\":{\"margin\":{\"top\":\"0px\",\"bottom\":\"5px\"}},\"color\":{\"text\":\"#ffffff\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|base\"}}}}} -->\n<p class=\"has-text-align-left has-text-color has-link-color\" style=\"color:#ffffff;margin-top:0px;margin-bottom:5px;font-size:0.7em;line-height:1\"><a style=\"text-decoration:none\" href=\"/shop/?max_price=25\">Under</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"0.7em\",\"lineHeight\":\"1\"},\"spacing\":{\"margin\":{\"top\":\"0px\",\"bottom\":\"5px\"}},\"color\":{\"text\":\"#ffffff\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|base\"}}}},\"fontSize\":\"large\"} -->\n<p class=\"has-text-color has-link-color has-large-font-size\" style=\"color:#ffffff;margin-top:0px;margin-bottom:5px;font-size:0.7em;line-height:1\"><strong><a style=\"text-decoration:none\" href=\"/shop/?max_price=25\">$25</a></strong></p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\",\"verticalAlignment\":\"center\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"textColor\":\"contrast\",\"style\":{\"border\":{\"width\":\"0px\",\"style\":\"none\"},\"spacing\":{\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"is-style-outline\",\"fontSize\":\"small\"} --><div class=\"wp-block-button has-custom-font-size is-style-outline has-small-font-size\"><a class=\"wp-block-button__link has-contrast-color has-text-color wp-element-button\" href=\"/shop/?max_price=25\" style=\"border-style:none;border-width:0px;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\">\n					<strong>Women\'s Styles</strong>\n				</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"25%\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"},\"blockGap\":\"10px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-column\" style=\"padding-top:0;padding-right:0;padding-bottom:0;padding-left:0;flex-basis:25%\"><!-- wp:cover {\"customOverlayColor\":\"#10ca99\",\"isUserOverlayColor\":true,\"minHeight\":130,\"minHeightUnit\":\"px\",\"contentPosition\":\"top left\",\"style\":{\"spacing\":{\"blockGap\":\"0.8em\",\"padding\":{\"top\":\"0.8em\"}}},\"className\":\"has-background-color has-text-color\"} -->\n<div class=\"wp-block-cover has-custom-content-position is-position-top-left has-background-color has-text-color\" style=\"padding-top:0.8em;min-height:130px\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-100 has-background-dim\" style=\"background-color:#10ca99\"></span><div class=\"wp-block-cover__inner-container\"><!-- wp:paragraph {\"align\":\"left\",\"placeholder\":\"Write title…\",\"style\":{\"typography\":{\"fontSize\":\"0.7em\",\"lineHeight\":\"1\"},\"spacing\":{\"margin\":{\"top\":\"0px\",\"bottom\":\"5px\"}},\"color\":{\"text\":\"#ffffff\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|base\"}}}}} -->\n<p class=\"has-text-align-left has-text-color has-link-color\" style=\"color:#ffffff;margin-top:0px;margin-bottom:5px;font-size:0.7em;line-height:1\"><a style=\"text-decoration:none\" href=\"/shop/?max_price=20\">Under</a></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"0.7em\",\"lineHeight\":\"1\"},\"spacing\":{\"margin\":{\"top\":\"0px\",\"bottom\":\"5px\"}},\"color\":{\"text\":\"#ffffff\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|base\"}}}},\"fontSize\":\"large\"} -->\n<p class=\"has-text-color has-link-color has-large-font-size\" style=\"color:#ffffff;margin-top:0px;margin-bottom:5px;font-size:0.7em;line-height:1\"><strong><a style=\"text-decoration:none\" href=\"/shop/?max_price=20\">$20</a></strong></p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\",\"verticalAlignment\":\"center\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"textColor\":\"contrast\",\"style\":{\"border\":{\"width\":\"0px\",\"style\":\"none\"},\"spacing\":{\"padding\":{\"left\":\"0\",\"right\":\"0\",\"top\":\"0\",\"bottom\":\"0\"}}},\"className\":\"is-style-outline\",\"fontSize\":\"small\"} --><div class=\"wp-block-button has-custom-font-size is-style-outline has-small-font-size\"><a class=\"wp-block-button__link has-contrast-color has-text-color wp-element-button\" href=\"/shop/?max_price=20\" style=\"border-style:none;border-width:0px;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\">\n					<strong>Kids\' Styles</strong>\n				</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:67:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/shop-by-price/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:41:33\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:62;a:18:{s:2:\"ID\";i:204;s:7:\"site_id\";i:231214916;s:5:\"title\";s:42:\"Product List with Full Product Description\";s:4:\"name\";s:42:\"product-list-with-full-product-description\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3309:\"<!-- wp:query {\"queryId\":18,\"query\":{\"perPage\":\"5\",\"pages\":0,\"offset\":0,\"postType\":\"product\",\"order\":\"desc\",\"orderBy\":\"date\",\"author\":\"\",\"search\":\"\",\"exclude\":[],\"sticky\":\"\",\"inherit\":false,\"__woocommerceStockStatus\":[\"instock\",\"outofstock\",\"onbackorder\"]},\"namespace\":\"woocommerce/product-query\",\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/product-query-product-list-with-full-product-description\",\"name\":\"Product List with Full Product Description\"}} -->\n<div class=\"wp-block-query\"><!-- wp:post-template {\"layout\":{\"type\":\"default\",\"columnCount\":2},\"__woocommerceNamespace\":\"woocommerce/product-query/product-template\"} -->\n<!-- wp:columns {\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-columns is-not-stacked-on-mobile\"><!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:woocommerce/product-image {\"saleBadgeAlign\":\"left\",\"isDescendentOfQueryLoop\":true} /--></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"66.66%\",\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:woocommerce/product-rating {\"isDescendentOfQueryLoop\":true,\"fontSize\":\"small\",\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\"}}}} /-->\n\n<!-- wp:post-terms {\"term\":\"product_cat\",\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\",\"top\":\"0\"}}}} /-->\n\n<!-- wp:post-title {\"level\":3,\"isLink\":true,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\",\"top\":\"0\"}}},\"fontSize\":\"large\",\"__woocommerceNamespace\":\"woocommerce/product-query/product-title\"} /-->\n\n<!-- wp:post-excerpt {\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\",\"top\":\"0\"}}},\"fontSize\":\"small\",\"__woocommerceNamespace\":\"woocommerce/product-query/product-summary\"} /-->\n\n<!-- wp:woocommerce/product-sku {\"isDescendentOfQueryLoop\":true} /-->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:woocommerce/product-price {\"isDescendentOfQueryLoop\":true,\"fontSize\":\"small\",\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\"}}}} /--></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"66.66%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:woocommerce/product-button {\"isDescendentOfQueryLoop\":true,\"fontSize\":\"small\",\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\"}}}} /--></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n<!-- /wp:post-template -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"66.66%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:query-pagination {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<!-- wp:query-pagination-previous /-->\n\n<!-- wp:query-pagination-numbers /-->\n\n<!-- wp:query-pagination-next /-->\n<!-- /wp:query-pagination -->\n\n<!-- wp:query-no-results -->\n<!-- wp:paragraph {\"placeholder\":\"Add text or blocks that will display when a query returns no results.\"} -->\n<p></p>\n<!-- /wp:paragraph -->\n<!-- /wp:query-no-results --></div>\n<!-- /wp:query -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:96:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/product-list-with-full-product-description/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:35:59\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:63;a:18:{s:2:\"ID\";i:202;s:7:\"site_id\";i:231214916;s:5:\"title\";s:28:\"Product List with 1:1 Images\";s:4:\"name\";s:27:\"product-list-with-11-images\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:2434:\"<!-- wp:query {\"queryId\":16,\"query\":{\"perPage\":\"5\",\"pages\":0,\"offset\":0,\"postType\":\"product\",\"order\":\"desc\",\"orderBy\":\"date\",\"author\":\"\",\"search\":\"\",\"exclude\":[],\"sticky\":\"\",\"inherit\":false,\"__woocommerceStockStatus\":[\"instock\",\"outofstock\",\"onbackorder\"]},\"namespace\":\"woocommerce/product-query\",\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/product-query-product-list-with-1-1-images\",\"name\":\"Product List with 1:1 Images\"}} -->\n<div class=\"wp-block-query\"><!-- wp:post-template {\"layout\":{\"type\":\"default\",\"columnCount\":2},\"__woocommerceNamespace\":\"woocommerce/product-query/product-template\"} -->\n<!-- wp:columns {\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-columns is-not-stacked-on-mobile\"><!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:woocommerce/product-image {\"saleBadgeAlign\":\"left\",\"isDescendentOfQueryLoop\":true} /--></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"66.66%\",\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:woocommerce/product-rating {\"isDescendentOfQueryLoop\":true,\"fontSize\":\"small\",\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\"}}}} /-->\n\n<!-- wp:post-title {\"level\":3,\"isLink\":true,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\",\"top\":\"0\"}}},\"fontSize\":\"large\",\"__woocommerceNamespace\":\"woocommerce/product-query/product-title\"} /-->\n\n<!-- wp:post-excerpt {\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\",\"top\":\"0\"}}},\"fontSize\":\"small\",\"__woocommerceNamespace\":\"woocommerce/product-query/product-summary\"} /-->\n\n<!-- wp:woocommerce/product-price {\"isDescendentOfQueryLoop\":true,\"fontSize\":\"small\",\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\",\"top\":\"0\"}}}} /-->\n\n<!-- wp:woocommerce/product-button {\"isDescendentOfQueryLoop\":true,\"fontSize\":\"small\",\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\",\"top\":\"0\"}}}} /--></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n<!-- /wp:post-template -->\n\n<!-- wp:query-pagination {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<!-- wp:query-pagination-previous /-->\n\n<!-- wp:query-pagination-numbers /-->\n\n<!-- wp:query-pagination-next /-->\n<!-- /wp:query-pagination -->\n\n<!-- wp:query-no-results -->\n<!-- wp:paragraph {\"placeholder\":\"Add text or blocks that will display when a query returns no results.\"} -->\n<p></p>\n<!-- /wp:paragraph -->\n<!-- /wp:query-no-results --></div>\n<!-- /wp:query -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:81:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/product-list-with-11-images/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:35:29\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:64;a:18:{s:2:\"ID\";i:200;s:7:\"site_id\";i:231214916;s:5:\"title\";s:20:\"Minimal Product List\";s:4:\"name\";s:20:\"minimal-product-list\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:2060:\"<!-- wp:query {\"queryId\":14,\"query\":{\"perPage\":\"5\",\"pages\":0,\"offset\":0,\"postType\":\"product\",\"order\":\"desc\",\"orderBy\":\"date\",\"author\":\"\",\"search\":\"\",\"exclude\":[],\"sticky\":\"\",\"inherit\":false,\"__woocommerceStockStatus\":[\"instock\",\"outofstock\",\"onbackorder\"]},\"namespace\":\"woocommerce/product-query\",\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/product-query-minimal-product-list\",\"name\":\"Minimal Product List\"}} -->\n<div class=\"wp-block-query\"><!-- wp:post-template {\"layout\":{\"type\":\"default\",\"columnCount\":2},\"__woocommerceNamespace\":\"woocommerce/product-query/product-template\"} -->\n<!-- wp:columns {\"isStackedOnMobile\":false} -->\n<div class=\"wp-block-columns is-not-stacked-on-mobile\"><!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:woocommerce/product-image {\"isDescendentOfQueryLoop\":true} /--></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"66.66%\",\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:woocommerce/product-rating {\"isDescendentOfQueryLoop\":true,\"fontSize\":\"small\",\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\"}}}} /-->\n\n<!-- wp:post-title {\"level\":3,\"isLink\":true,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\",\"top\":\"0\"}}},\"fontSize\":\"large\",\"__woocommerceNamespace\":\"woocommerce/product-query/product-title\"} /-->\n\n<!-- wp:woocommerce/product-price {\"isDescendentOfQueryLoop\":true,\"fontSize\":\"small\",\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\",\"top\":\"0\"}}}} /--></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n<!-- /wp:post-template -->\n\n<!-- wp:query-pagination {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<!-- wp:query-pagination-previous /-->\n\n<!-- wp:query-pagination-numbers /-->\n\n<!-- wp:query-pagination-next /-->\n<!-- /wp:query-pagination -->\n\n<!-- wp:query-no-results -->\n<!-- wp:paragraph {\"placeholder\":\"Add text or blocks that will display when a query returns no results.\"} -->\n<p></p>\n<!-- /wp:paragraph -->\n<!-- /wp:query-no-results --></div>\n<!-- /wp:query -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:74:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/minimal-product-list/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:34:48\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:65;a:18:{s:2:\"ID\";i:198;s:7:\"site_id\";i:231214916;s:5:\"title\";s:20:\"4-Column Product Row\";s:4:\"name\";s:20:\"4-column-product-row\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:2017:\"<!-- wp:query {\"queryId\":10,\"query\":{\"perPage\":\"4\",\"pages\":0,\"offset\":0,\"postType\":\"product\",\"order\":\"desc\",\"orderBy\":\"date\",\"author\":\"\",\"search\":\"\",\"exclude\":[],\"sticky\":\"\",\"inherit\":false,\"__woocommerceStockStatus\":[\"instock\",\"outofstock\",\"onbackorder\"]},\"namespace\":\"woocommerce/product-query\",\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/product-query-4-column-product-row\",\"name\":\"4-Column Product Row\"},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-query\"><!-- wp:post-template {\"layout\":{\"type\":\"grid\",\"columnCount\":4},\"__woocommerceNamespace\":\"woocommerce/product-query/product-template\"} -->\n<!-- wp:woocommerce/product-image {\"isDescendentOfQueryLoop\":true} /-->\n\n<!-- wp:post-title {\"isLink\":true,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\",\"top\":\"0\"}}},\"fontSize\":\"medium\",\"__woocommerceNamespace\":\"woocommerce/product-query/product-title\"} /-->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"verticalAlignment\":\"top\",\"justifyContent\":\"space-between\",\"orientation\":\"horizontal\"}} -->\n<div class=\"wp-block-group\"><!-- wp:woocommerce/product-price {\"isDescendentOfQueryLoop\":true,\"fontSize\":\"small\",\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\"}}}} /-->\n\n<!-- wp:woocommerce/product-rating {\"isDescendentOfQueryLoop\":true,\"fontSize\":\"small\",\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\"}}}} /--></div>\n<!-- /wp:group -->\n\n<!-- wp:woocommerce/product-button {\"isDescendentOfQueryLoop\":true,\"fontSize\":\"small\",\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\"}}}} /-->\n<!-- /wp:post-template -->\n\n<!-- wp:query-pagination {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<!-- wp:query-pagination-previous /-->\n\n<!-- wp:query-pagination-numbers /-->\n\n<!-- wp:query-pagination-next /-->\n<!-- /wp:query-pagination -->\n\n<!-- wp:query-no-results -->\n<!-- wp:paragraph {\"placeholder\":\"Add text or blocks that will display when a query returns no results.\"} -->\n<p></p>\n<!-- /wp:paragraph -->\n<!-- /wp:query-no-results --></div>\n<!-- /wp:query -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:74:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/4-column-product-row/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:34:06\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:66;a:18:{s:2:\"ID\";i:192;s:7:\"site_id\";i:231214916;s:5:\"title\";s:44:\"Product Listing with Gallery and Description\";s:4:\"name\";s:44:\"product-listing-with-gallery-and-description\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:7230:\"<!-- wp:columns {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/product-listing-with-gallery-and-description\",\"name\":\"Product Listing with Gallery and Description\"},\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"},\"blockGap\":{\"top\":\"60px\",\"left\":\"60px\"}}}} -->\n<div class=\"wp-block-columns alignwide\" style=\"padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:columns {\"isStackedOnMobile\":false,\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"},\"blockGap\":{\"top\":\"1.5rem\",\"left\":\"1.5rem\"}}}} -->\n<div class=\"wp-block-columns is-not-stacked-on-mobile\" style=\"margin-top:0;margin-bottom:0;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><!-- wp:column {\"width\":\"15%\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"right\":\"var:preset|spacing|20\",\"bottom\":\"0\",\"left\":\"0\"},\"blockGap\":\"0\"}},\"layout\":{\"type\":\"constrained\",\"wideSize\":\"80px\"}} -->\n<div class=\"wp-block-column\" style=\"padding-top:0;padding-right:var(--wp--preset--spacing--20);padding-bottom:0;padding-left:0;flex-basis:15%\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"1rem\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"verticalAlignment\":\"center\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group\"><!-- wp:image {\"id\":193,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"color\":\"#dddddd\",\"width\":\"1px\",\"radius\":\"5px\"}},\"className\":\"is-resized\"} -->\n<figure class=\"wp-block-image size-full has-custom-border is-resized\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/06/desk-table-wood-chair-floor-home-square.png\" alt=\"\" class=\"has-border-color wp-image-193\" style=\"border-color:#dddddd;border-width:1px;border-radius:5px\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":194,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"color\":\"#dddddd\",\"width\":\"1px\",\"radius\":\"5px\"}},\"className\":\"is-resized\"} -->\n<figure class=\"wp-block-image size-full has-custom-border is-resized\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/06/table-floor-interior-atmosphere-living-room-furniture-square-1.png\" alt=\"\" class=\"has-border-color wp-image-194\" style=\"border-color:#dddddd;border-width:1px;border-radius:5px\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":195,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"style\":{\"border\":{\"color\":\"#dddddd\",\"width\":\"1px\",\"radius\":\"5px\"}},\"className\":\"is-resized\"} -->\n<figure class=\"wp-block-image size-full has-custom-border is-resized\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/06/table-floor-home-living-room-furniture-room-square.png\" alt=\"\" class=\"has-border-color wp-image-195\" style=\"border-color:#dddddd;border-width:1px;border-radius:5px\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"85%\",\"style\":{\"spacing\":{\"blockGap\":\"0\"}}} -->\n<div class=\"wp-block-column\" style=\"flex-basis:85%\"><!-- wp:image {\"id\":196,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/06/table-wood-chair-floor-living-room-furniture-vertical.png\" alt=\"\" class=\"wp-image-196\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"style\":{\"typography\":{\"fontSize\":\"48px\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"textColor\":\"foreground\"} -->\n<h2 class=\"wp-block-heading has-foreground-color has-text-color\" style=\"font-size:48px;font-style:normal;font-weight:700\">Patterned Upright, Orange and White, Wood Legs</h2>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"top\":\"0px\",\"right\":\"0px\",\"bottom\":\"0px\",\"left\":\"0px\"},\"blockGap\":\"0px\",\"margin\":{\"top\":\"10px\",\"bottom\":\"0px\"}}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"verticalAlignment\":\"center\"}} -->\n<div class=\"wp-block-group\" style=\"margin-top:10px;margin-bottom:0px;padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px\"><!-- wp:paragraph {\"textColor\":\"luminous-vivid-amber\"} -->\n<p class=\"has-luminous-vivid-amber-color has-text-color\">★★★★</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#ffe8a4\"},\"spacing\":{\"margin\":{\"right\":\"5px\"}}}} -->\n<p class=\"has-text-color\" style=\"color:#ffe8a4;margin-right:5px\">★</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"0.7em\"}},\"textColor\":\"foreground\"} -->\n<p class=\"has-foreground-color has-text-color\" style=\"font-size:0.7em\">\n				<strong>4.2</strong>(1,079 reviews)\n			</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"8px\",\"padding\":{\"top\":\"0px\",\"right\":\"0px\",\"bottom\":\"0px\",\"left\":\"0px\"},\"margin\":{\"top\":\"2px\",\"bottom\":\"0px\"}}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"verticalAlignment\":\"center\"}} -->\n<div class=\"wp-block-group\" style=\"margin-top:2px;margin-bottom:0px;padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"1.2em\"}},\"textColor\":\"foreground\"} -->\n<p class=\"has-foreground-color has-text-color\" style=\"font-size:1.2em\">\n				<strong><sup><sub>$</sub></sup>37.49</strong>\n			</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"0.7em\"},\"layout\":{\"selfStretch\":\"fit\",\"flexSize\":null},\"color\":{\"text\":\"#7c0a99\"}}} -->\n<p class=\"has-text-color\" style=\"color:#7c0a99;font-size:0.7em\">Save $10 <s>was $47.49</s></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"left\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"18px\"}},\"textColor\":\"foreground\"} -->\n<p class=\"has-foreground-color has-text-color\" style=\"font-size:18px\">Designed with your well-being in mind, this chair features a contoured backrest that provides exceptional lumbar support, helping to reduce strain on your back during long hours of sitting. The adjustable height and tilt mechanisms allow you to customize the chair to your preferred sitting position, ensuring a comfortable and productive workday. Upholstered in premium fabric and available in a variety of colors, the Harmony Ergonomic Chair adds a touch of elegance to any room.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"left\"}} -->\n<div class=\"wp-block-group\"><!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"style\":{\"spacing\":{\"padding\":{\"left\":\"80px\",\"right\":\"80px\"}},\"color\":{\"text\":\"#ffffff\",\"background\":\"#000000\"}}} --><div class=\"wp-block-button\"><a class=\"wp-block-button__link has-text-color has-background wp-element-button\" style=\"color:#ffffff;background-color:#000000;padding-right:80px;padding-left:80px\">Add to cart</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"16px\"}}} -->\n<p style=\"font-size:16px\">SKU 6355793</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:98:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/product-listing-with-gallery-and-description/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:33:29\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:67;a:18:{s:2:\"ID\";i:188;s:7:\"site_id\";i:231214916;s:5:\"title\";s:12:\"Product Hero\";s:4:\"name\";s:12:\"product-hero\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:1616:\"\n<!-- wp:woocommerce/single-product {\"isPreview\":true,\"align\":\"wide\"} -->\n<div class=\"wp-block-woocommerce-single-product alignwide\">\n	<!-- wp:columns -->\n	<div class=\"wp-block-columns\">\n		<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"40%\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n		<div class=\"wp-block-column is-vertically-aligned-center\" style=\"padding-top:0;padding-right:0;padding-bottom:0;padding-left:0;flex-basis:40%\">\n			<!-- wp:woocommerce/product-image {\"showSaleBadge\":false,\"isDescendentOfSingleProductBlock\":true,\"height\":\"300px\"} /-->\n		</div>\n		<!-- /wp:column -->\n\n		<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"60%\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"left\",\"contentSize\":\"650px\"}} -->\n		<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:60%\">\n			<!-- wp:post-title {\"textAlign\":\"\",\"isLink\":true,\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"}}},\"__woocommerceNamespace\":\"woocommerce/product-query/product-title\"} /-->\n\n			<!-- wp:woocommerce/product-price {\"isDescendentOfSingleProductBlock\":true} /-->\n\n			<!-- wp:group {\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\n			<div class=\"wp-block-group\">\n				<!-- wp:woocommerce/product-button {\"isDescendentOfSingleProductBlock\":true} /-->\n			</div>\n			<!-- /wp:group -->\n\n			<!-- wp:post-excerpt {\"__woocommerceNamespace\":\"woocommerce/product-query/product-summary\"} /-->\n		</div>\n		<!-- /wp:column -->\n	</div>\n	<!-- /wp:columns -->\n</div>\n<!-- /wp:woocommerce/single-product -->\n\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:66:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/product-hero/\";s:13:\"modified_date\";s:19:\"2025-02-14 15:20:35\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:68;a:18:{s:2:\"ID\";i:186;s:7:\"site_id\";i:231214916;s:5:\"title\";s:27:\"Featured Products 2 Columns\";s:4:\"name\";s:27:\"featured-products-2-columns\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:2625:\"<!-- wp:columns {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/featured-products-2-cols\",\"name\":\"Featured Products 2 Columns\"},\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"var:preset|spacing|40\",\"left\":\"var:preset|spacing|40\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"66.66%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:query {\"queryId\":8,\"query\":{\"perPage\":\"4\",\"pages\":0,\"offset\":0,\"postType\":\"product\",\"order\":\"asc\",\"orderBy\":\"title\",\"author\":\"\",\"search\":\"\",\"exclude\":[],\"sticky\":\"\",\"inherit\":false,\"__woocommerceAttributes\":[],\"__woocommerceStockStatus\":[\"instock\",\"onbackorder\"]},\"namespace\":\"woocommerce/product-query\"} -->\n<div class=\"wp-block-query\"><!-- wp:post-template {\"layout\":{\"type\":\"grid\",\"columnCount\":2},\"__woocommerceNamespace\":\"woocommerce/product-query/product-template\"} -->\n<!-- wp:woocommerce/product-image {\"isDescendentOfQueryLoop\":true,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"24px\",\"top\":\"0\"}}}} /-->\n\n<!-- wp:columns {\"verticalAlignment\":\"bottom\"} -->\n<div class=\"wp-block-columns are-vertically-aligned-bottom\"><!-- wp:column {\"verticalAlignment\":\"bottom\"} -->\n<div class=\"wp-block-column is-vertically-aligned-bottom\"><!-- wp:post-title {\"textAlign\":\"left\",\"level\":3,\"isLink\":true,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0rem\",\"top\":\"0\"}}},\"fontSize\":\"medium\",\"__woocommerceNamespace\":\"woocommerce/product-query/product-title\"} /--></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"bottom\"} -->\n<div class=\"wp-block-column is-vertically-aligned-bottom\"><!-- wp:woocommerce/product-price {\"isDescendentOfQueryLoop\":true,\"textAlign\":\"right\",\"fontSize\":\"small\",\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0rem\",\"top\":\"0\"}}}} /--></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n<!-- /wp:post-template --></div>\n<!-- /wp:query --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:heading {\"level\":4} -->\n<h4 class=\"wp-block-heading\"><strong>Fan favorites</strong></h4>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Get ready to start the season right. All the fan favorites in one place at the best price.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"width\":50} --><div class=\"wp-block-button has-custom-width wp-block-button__width-50\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://wooblockpatterns.wpcomstaging.com/shop/\">Shop All</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:81:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/featured-products-2-columns/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:30:24\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:69;a:18:{s:2:\"ID\";i:182;s:7:\"site_id\";i:231214916;s:5:\"title\";s:23:\"Product Details Pattern\";s:4:\"name\";s:23:\"product-details-pattern\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:8559:\"<!-- wp:columns {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/product-details-pattern\",\"name\":\"Product Details Pattern\"},\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"0\",\"left\":\"0\"}}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"right\":\"40px\",\"bottom\":\"0\",\"left\":\"0px\"},\"blockGap\":\"0px\"}}} -->\n<div class=\"wp-block-column\" style=\"padding-top:0;padding-right:40px;padding-bottom:0;padding-left:0px\"><!-- wp:image {\"id\":183,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/06/table-floor-home-living-room-furniture-room.png\" alt=\"\" class=\"wp-image-183\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:columns {\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"0\",\"left\":\"0\"},\"padding\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"},\"margin\":{\"top\":\"0.2em\",\"bottom\":\"0.2em\"}}}} -->\n<div class=\"wp-block-columns\" style=\"margin-top:0.2em;margin-bottom:0.2em;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"top\":\"0px\",\"right\":\"5px\",\"bottom\":\"0px\",\"left\":\"0px\"},\"blockGap\":\"0\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-column\" style=\"padding-top:0px;padding-right:5px;padding-bottom:0px;padding-left:0px\"><!-- wp:image {\"id\":184,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/06/table-white-chair-floor-shelf-lamp-square-lg.png\" alt=\"\" class=\"wp-image-184\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"},\"blockGap\":\"0px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-column\" style=\"padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><!-- wp:image {\"id\":117,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/06/table-floor-interior-atmosphere-living-room-furniture-square-lg.png\" alt=\"\" class=\"wp-image-117\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"style\":{\"color\":{\"text\":\"#000000\"}},\"fontSize\":\"x-large\"} -->\n<h2 class=\"wp-block-heading has-text-color has-x-large-font-size\" style=\"color:#000000\">Luxurious Charcoal Grey Upholstered Sofa</h2>\n<!-- /wp:heading -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"top\":\"0px\",\"right\":\"0px\",\"bottom\":\"0px\",\"left\":\"0px\"},\"blockGap\":\"0px\",\"margin\":{\"top\":\"10px\",\"bottom\":\"0px\"}}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\" style=\"margin-top:10px;margin-bottom:0px;padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px\"><!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#fcb900\"}}} -->\n<p class=\"has-text-color\" style=\"color:#fcb900\">★★★★</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#ffe8a4\"},\"spacing\":{\"margin\":{\"right\":\"5px\"}}}} -->\n<p class=\"has-text-color\" style=\"color:#ffe8a4;margin-right:5px\">★</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"0.7em\"},\"color\":{\"text\":\"#000000\"}}} -->\n<p class=\"has-text-color\" style=\"color:#000000;font-size:0.7em\">  <strong>4.2</strong>(1,079 reviews)</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"8px\",\"padding\":{\"top\":\"0px\",\"right\":\"0px\",\"bottom\":\"0px\",\"left\":\"0px\"},\"margin\":{\"top\":\"2px\",\"bottom\":\"0px\"}}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\" style=\"margin-top:2px;margin-bottom:0px;padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"1.2em\"},\"color\":{\"text\":\"#000000\"}}} -->\n<p class=\"has-text-color\" style=\"color:#000000;font-size:1.2em\"><strong><sup><sub>$</sub></sup>158.99</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"0.7em\"},\"layout\":{\"selfStretch\":\"fit\",\"flexSize\":null},\"color\":{\"text\":\"#000000\"}}} -->\n<p class=\"has-text-color\" style=\"color:#000000;font-size:0.7em\"><s>was $173.99</s></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"0.7em\"},\"color\":{\"text\":\"#C51313\"}}} -->\n<p class=\"has-text-color\" style=\"color:#C51313;font-size:0.7em\"><strong>9% off</strong></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0px\",\"margin\":{\"top\":\"5px\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group\" style=\"margin-top:5px\"><!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#00A510\"},\"typography\":{\"fontSize\":\"0.7em\"},\"spacing\":{\"margin\":{\"top\":\"0px\",\"right\":\"0px\",\"bottom\":\"0px\",\"left\":\"0px\"}}}} -->\n<p class=\"has-text-color\" style=\"color:#00A510;margin-top:0px;margin-right:0px;margin-bottom:0px;margin-left:0px;font-size:0.7em\"><strong>Free 2-Day Shipping</strong></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"left\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"0.8em\"},\"color\":{\"text\":\"#000000\"}}} -->\n<p class=\"has-text-color\" style=\"color:#000000;font-size:0.8em\">The \"Modern Elegance: Luxurious Charcoal Grey Upholstered Sofa\" harmonizes style and comfort to redefine your living space. This stunning piece is crafted with plush, high-density foam cushions, enveloped in a rich, charcoal grey fabric that is invitingly soft to the touch. Its clean lines and contemporary silhouette are complemented by the sturdy wooden frame, making it a durable yet stylish addition to any home decor. Whether you\'re lounging or entertaining, this sofa promises unrivaled comfort and a look that\'s seamlessly chic.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"left\"}} -->\n<div class=\"wp-block-group\"><!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"style\":{\"color\":{\"text\":\"#ffffff\",\"background\":\"#000000\"}}} --><div class=\"wp-block-button\"><a class=\"wp-block-button__link has-text-color has-background wp-element-button\" style=\"color:#ffffff;background-color:#000000\">Add to cart</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"left\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"0.8em\"},\"color\":{\"text\":\"#000000\"}}} -->\n<p class=\"has-text-color\" style=\"color:#000000;font-size:0.8em\"><strong>Features</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list {\"style\":{\"spacing\":{\"margin\":{\"top\":\"10px\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"}},\"color\":{\"text\":\"#000000\"}},\"className\":\"has-foreground-color\"} -->\n<ul style=\"color:#000000;margin-top:10px;margin-right:0;margin-bottom:0;margin-left:0\" class=\"wp-block-list has-foreground-color has-text-color\"><!-- wp:list-item {\"style\":{\"typography\":{\"fontSize\":\"0.8em\"}}} -->\n<li style=\"font-size:0.8em\">Top shelf weight capacity of 100 lbs</li>\n<!-- /wp:list-item -->\n\n<!-- wp:list-item {\"style\":{\"typography\":{\"fontSize\":\"0.8em\"}}} -->\n<li style=\"font-size:0.8em\">Drawer weight capacity of 50 lbs</li>\n<!-- /wp:list-item --></ul>\n<!-- /wp:list --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"left\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"0.8em\"},\"color\":{\"text\":\"#000000\"}}} -->\n<p class=\"has-text-color\" style=\"color:#000000;font-size:0.8em\"><strong>Weight and Dimensions</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:table {\"hasFixedLayout\":false,\"style\":{\"typography\":{\"fontSize\":\"0.7em\"},\"color\":{\"text\":\"#000000\"}},\"backgroundColor\":\"background\",\"className\":\"is-style-stripes\"} -->\n<figure class=\"wp-block-table is-style-stripes\" style=\"font-size:0.7em\"><table class=\"has-background-background-color has-text-color has-background\" style=\"color:#000000\"><tbody><tr><td>Overall</td><td>36.5\'\' H X 40\'\' W X 20\'\' D</td></tr><tr><td>Drawer Interior</td><td>2\'\' H X 29.25\'\' W X 12.5\'\' D</td></tr><tr><td>Countertop</td><td>40\'\' W X 20\'\' D</td></tr><tr><td>Countertop Thickness</td><td>0.7\'\' H</td></tr><tr><td>Overall Product Weight</td><td>39.6 lb.</td></tr></tbody></table></figure>\n<!-- /wp:table --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:77:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/product-details-pattern/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:29:31\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:70;a:18:{s:2:\"ID\";i:180;s:7:\"site_id\";i:231214916;s:5:\"title\";s:31:\"Product Details Product Listing\";s:4:\"name\";s:31:\"product-details-product-listing\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:1582:\"\n<!-- wp:woocommerce/single-product {\"isPreview\":true} -->\n<div class=\"wp-block-woocommerce-single-product\">\n	<!-- wp:columns -->\n	<div class=\"wp-block-columns\">\n		<!-- wp:column -->\n		<div class=\"wp-block-column\">\n			<!-- wp:post-featured-image {\"height\":\"490px\"} /-->\n\n			<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"8px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"center\"}} -->\n			<div class=\"wp-block-group\">\n				<!-- wp:woocommerce/product-rating-stars {\"isDescendentOfSingleProductBlock\":true,\"textColor\":\"luminous-vivid-amber\",\"style\":{\"spacing\":{\"margin\":{\"right\":\"5px\"}}}} /-->\n				<!-- wp:woocommerce/product-average-rating {\"style\":{\"typography\":{\"fontWeight\":\"600\",\"fontSize\":\"14px\"}}} /-->\n				<!-- wp:woocommerce/product-rating-counter {\"isDescendentOfSingleProductBlock\":true,\"style\":{\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|contrast\"}}},\"typography\":{\"fontSize\":\"14px\"}}} /-->\n			</div>\n			<!-- /wp:group -->\n\n			<!-- wp:post-title {\"textAlign\":\"center\",\"isLink\":true,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}},\"fontSize\":\"x-large\",\"__woocommerceNamespace\":\"woocommerce/product-query/product-title\"} /-->\n			<!-- wp:woocommerce/product-price {\"textAlign\":\"center\",\"isDescendentOfSingleProductBlock\":true,\"style\":{\"typography\":{\"fontSize\":\"28px\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}}} /-->\n			<!-- wp:woocommerce/product-button {\"textAlign\":\"center\",\"isDescendentOfSingleProductBlock\":true} /-->\n		</div>\n		<!-- /wp:column -->\n	</div>\n	<!-- /wp:columns -->\n</div>\n<!-- /wp:woocommerce/single-product -->\n\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:85:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/product-details-product-listing/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:28:16\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:71;a:18:{s:2:\"ID\";i:178;s:7:\"site_id\";i:231214916;s:5:\"title\";s:35:\"Product Collections Newest Arrivals\";s:4:\"name\";s:35:\"product-collections-newest-arrivals\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:1993:\"<!-- wp:group {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/product-collections-newest-arrivals\",\"name\":\"Product Collections Newest Arrivals\"},\"align\":\"wide\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignwide\"><!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"level\":3} -->\n<h3 class=\"wp-block-heading\">Our newest arrivals</h3>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"right\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://wooblockpatterns.wpcomstaging.com/shop/\">More new products</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:group {\"align\":\"wide\",\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group alignwide\"><!-- wp:query {\"queryId\":6,\"query\":{\"perPage\":\"4\",\"pages\":0,\"offset\":0,\"postType\":\"product\",\"order\":\"desc\",\"orderBy\":\"date\",\"author\":\"\",\"search\":\"\",\"exclude\":[],\"sticky\":\"\",\"inherit\":false,\"__woocommerceAttributes\":[],\"__woocommerceStockStatus\":[\"instock\",\"onbackorder\"]},\"namespace\":\"woocommerce/product-query\"} -->\n<div class=\"wp-block-query\"><!-- wp:post-template {\"className\":\"products-block-post-template\",\"layout\":{\"type\":\"grid\",\"columnCount\":4},\"__woocommerceNamespace\":\"woocommerce/product-query/product-template\"} -->\n<!-- wp:woocommerce/product-image {\"isDescendentOfQueryLoop\":true} /-->\n\n<!-- wp:post-title {\"textAlign\":\"center\",\"level\":3,\"isLink\":true,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\",\"top\":\"0\"}}},\"fontSize\":\"medium\",\"__woocommerceNamespace\":\"woocommerce/product-query/product-title\"} /-->\n<!-- /wp:post-template --></div>\n<!-- /wp:query --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:89:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/product-collections-newest-arrivals/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:26:37\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:72;a:18:{s:2:\"ID\";i:172;s:7:\"site_id\";i:231214916;s:5:\"title\";s:40:\"Product Collections Featured Collections\";s:4:\"name\";s:40:\"product-collections-featured-collections\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:4771:\"<!-- wp:columns {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/product-collections-featured-collections\",\"name\":\"Product Collections Featured Collections\"},\"align\":\"wide\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"},\"blockGap\":{\"top\":\"0\",\"left\":\"0\"}}}} -->\n<div class=\"wp-block-columns alignwide\" style=\"padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><!-- wp:column {\"width\":\"50%\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"30px\",\"right\":\"30px\",\"bottom\":\"30px\",\"left\":\"30px\"}},\"color\":{\"background\":\"#f3edd8\"}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-column has-background\" style=\"background-color:#f3edd8;padding-top:30px;padding-right:30px;padding-bottom:30px;padding-left:30px;flex-basis:50%\"><!-- wp:heading {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"},\"color\":{\"text\":\"#000000\"}},\"fontSize\":\"x-large\"} -->\n<h2 class=\"wp-block-heading has-text-color has-x-large-font-size\" style=\"color:#000000;font-style:normal;font-weight:700\">Tech gifts under $100</h2>\n<!-- /wp:heading -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"style\":{\"spacing\":{\"padding\":{\"left\":\"18px\",\"right\":\"18px\",\"top\":\"9px\",\"bottom\":\"9px\"}},\"typography\":{\"fontSize\":\"16px\"},\"color\":{\"background\":\"#000000\",\"text\":\"#ffffff\"}}} --><div class=\"wp-block-button has-custom-font-size\" style=\"font-size:16px\"><a class=\"wp-block-button__link has-text-color has-background wp-element-button\" href=\"https://wooblockpatterns.wpcomstaging.com/shop/\" style=\"color:#ffffff;background-color:#000000;padding-top:9px;padding-right:18px;padding-bottom:9px;padding-left:18px\">Shop tech</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"right\"}} -->\n<div class=\"wp-block-group\"><!-- wp:image {\"id\":173,\"width\":\"140px\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full is-resized\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/06/technology-white-camera-photography-vintage-photographer.png\" alt=\"\" class=\"wp-image-173\" style=\"width:140px\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":174,\"width\":\"140px\",\"height\":\"100px\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full is-resized\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/06/leather-guitar-typewriter-red-gadget-sofa.png\" alt=\"\" class=\"wp-image-174\" style=\"width:140px;height:100px\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"50%\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"30px\",\"right\":\"30px\",\"bottom\":\"30px\",\"left\":\"30px\"}},\"color\":{\"background\":\"#d8f2f3\"}}} -->\n<div class=\"wp-block-column has-background\" style=\"background-color:#d8f2f3;padding-top:30px;padding-right:30px;padding-bottom:30px;padding-left:30px;flex-basis:50%\"><!-- wp:heading {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"},\"color\":{\"text\":\"#000000\"}},\"fontSize\":\"x-large\"} -->\n<h2 class=\"wp-block-heading has-text-color has-x-large-font-size\" style=\"color:#000000;font-style:normal;font-weight:700\">For the gamers</h2>\n<!-- /wp:heading -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"style\":{\"spacing\":{\"padding\":{\"left\":\"18px\",\"right\":\"18px\",\"top\":\"9px\",\"bottom\":\"9px\"}},\"typography\":{\"fontSize\":\"16px\"},\"color\":{\"background\":\"#000000\",\"text\":\"#ffffff\"}}} --><div class=\"wp-block-button has-custom-font-size\" style=\"font-size:16px\"><a class=\"wp-block-button__link has-text-color has-background wp-element-button\" href=\"https://wooblockpatterns.wpcomstaging.com/shop/\" style=\"color:#ffffff;background-color:#000000;padding-top:9px;padding-right:18px;padding-bottom:9px;padding-left:18px\">Shop games</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"right\"}} -->\n<div class=\"wp-block-group\"><!-- wp:image {\"id\":175,\"width\":\"140px\",\"height\":\"100px\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full is-resized\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/06/music-technology-play-equipment-studio-gadget.png\" alt=\"\" class=\"wp-image-175\" style=\"width:140px;height:100px\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:image {\"id\":176,\"width\":\"140px\",\"height\":\"100px\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full is-resized\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/06/technology-joystick-gadget-console-games-playstation.png\" alt=\"\" class=\"wp-image-176\" style=\"width:140px;height:100px\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:94:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/product-collections-featured-collections/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:25:38\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:73;a:18:{s:2:\"ID\";i:169;s:7:\"site_id\";i:231214916;s:5:\"title\";s:39:\"Product Collections Featured Collection\";s:4:\"name\";s:39:\"product-collections-featured-collection\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:4254:\"<!-- wp:columns {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/product-collections-featured-collection\",\"name\":\"Product Collections Featured Collection\"},\"align\":\"wide\",\"style\":{\"color\":{\"background\":\"#333333\"},\"spacing\":{\"padding\":{\"top\":\"1.3rem\",\"right\":\"1.3rem\",\"bottom\":\"1.3rem\",\"left\":\"1.3rem\"}}},\"textColor\":\"white\"} -->\n<div class=\"wp-block-columns alignwide has-white-color has-text-color has-background\" style=\"background-color:#333333;padding-top:1.3rem;padding-right:1.3rem;padding-bottom:1.3rem;padding-left:1.3rem\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"33.33%\",\"style\":{\"spacing\":{\"padding\":{\"right\":\"var:preset|spacing|40\",\"left\":\"var:preset|spacing|40\"}}}} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"padding-right:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40);flex-basis:33.33%\"><!-- wp:heading {\"textAlign\":\"center\",\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"},\"color\":{\"text\":\"#ffffff\"}},\"fontSize\":\"x-large\"} -->\n<h2 class=\"wp-block-heading has-text-align-center has-text-color has-x-large-font-size\" style=\"color:#ffffff;font-style:normal;font-weight:700\">\n			This week\'s popular products		</h2>\n<!-- /wp:heading --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"66.66%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:66.66%\"><!-- wp:query {\"queryId\":3,\"query\":{\"perPage\":\"3\",\"pages\":0,\"offset\":0,\"postType\":\"product\",\"order\":\"desc\",\"orderBy\":\"date\",\"author\":\"\",\"search\":\"\",\"exclude\":[],\"sticky\":\"\",\"inherit\":false,\"__woocommerceAttributes\":[],\"__woocommerceStockStatus\":[\"instock\",\"onbackorder\"]},\"namespace\":\"woocommerce/product-query\"} -->\n<div class=\"wp-block-query\"><!-- wp:post-template {\"layout\":{\"type\":\"grid\",\"columnCount\":3},\"__woocommerceNamespace\":\"woocommerce/product-query/product-template\"} -->\n<!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"},\"blockGap\":\"0\"},\"color\":{\"background\":\"#484848\"},\"border\":{\"radius\":{\"topLeft\":\"0px\",\"topRight\":\"0px\",\"bottomLeft\":\"4px\",\"bottomRight\":\"4px\"}}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"justifyContent\":\"stretch\"}} -->\n<div class=\"wp-block-group has-background\" style=\"border-top-left-radius:0px;border-top-right-radius:0px;border-bottom-left-radius:4px;border-bottom-right-radius:4px;background-color:#484848;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><!-- wp:group {\"style\":{\"border\":{\"radius\":{\"topLeft\":\"4px\",\"topRight\":\"4px\"},\"color\":\"#ffffff\",\"style\":\"solid\",\"width\":\"3px\"},\"spacing\":{\"padding\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"},\"blockGap\":\"0\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\n<div class=\"wp-block-group has-border-color\" style=\"border-color:#ffffff;border-style:solid;border-width:3px;border-top-left-radius:4px;border-top-right-radius:4px;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\"><!-- wp:woocommerce/product-image {\"isDescendentOfQueryLoop\":true,\"style\":{\"spacing\":{\"margin\":{\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\"}}}} /--></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0\",\"padding\":{\"top\":\"20px\",\"right\":\"20px\",\"left\":\"20px\",\"bottom\":\"10px\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"}}}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"justifyContent\":\"left\",\"verticalAlignment\":\"center\"}} -->\n<div class=\"wp-block-group has-link-color\" style=\"padding-top:20px;padding-right:20px;padding-bottom:10px;padding-left:20px\"><!-- wp:woocommerce/product-price {\"isDescendentOfQueryLoop\":true,\"fontFamily\":\"system-font\",\"style\":{\"typography\":{\"fontSize\":\"16px\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\"},\"color\":{\"text\":\"#ffffff\"}}} /-->\n\n<!-- wp:post-title {\"level\":3,\"isLink\":true,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\",\"top\":\"0\"}},\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"300\",\"fontSize\":\"16px\",\"textDecoration\":\"none\"},\"color\":{\"text\":\"#ffffff\"}},\"__woocommerceNamespace\":\"woocommerce/product-query/product-title\"} /--></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n<!-- /wp:post-template --></div>\n<!-- /wp:query --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:93:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/product-collections-featured-collection/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:23:59\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:74;a:18:{s:2:\"ID\";i:167;s:7:\"site_id\";i:231214916;s:5:\"title\";s:30:\"Product Collection Simple Grid\";s:4:\"name\";s:30:\"product-collection-simple-grid\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:1707:\"<!-- wp:woocommerce/product-collection {\"queryId\":22,\"query\":{\"perPage\":5,\"pages\":0,\"offset\":0,\"postType\":\"product\",\"order\":\"asc\",\"orderBy\":\"title\",\"search\":\"\",\"exclude\":[],\"inherit\":false,\"taxQuery\":[],\"isProductCollectionBlock\":true,\"woocommerceOnSale\":false,\"woocommerceStockStatus\":[\"instock\",\"outofstock\",\"onbackorder\"],\"woocommerceAttributes\":[],\"woocommerceHandPickedProducts\":[]},\"tagName\":\"div\",\"displayLayout\":{\"type\":\"flex\",\"columns\":5,\"shrinkColumns\":true},\"queryContextIncludes\":[\"collection\"],\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/product-collection-simple-grid\",\"name\":\"Product Collection Simple Grid\"}} -->\n<div class=\"wp-block-woocommerce-product-collection\"><!-- wp:woocommerce/product-template -->\n<!-- wp:woocommerce/product-image {\"saleBadgeAlign\":\"left\",\"imageSizing\":\"thumbnail\",\"isDescendentOfQueryLoop\":true,\"style\":{\"typography\":{\"fontSize\":\"0.8rem\"}}} /-->\n\n<!-- wp:post-title {\"textAlign\":\"center\",\"level\":3,\"isLink\":true,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\",\"top\":\"0\"}},\"typography\":{\"fontSize\":\"1rem\"}},\"__woocommerceNamespace\":\"woocommerce/product-collection/product-title\"} /-->\n<!-- /wp:woocommerce/product-template -->\n\n<!-- wp:query-pagination {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\",\"orientation\":\"horizontal\"}} -->\n<!-- wp:query-pagination-previous /-->\n\n<!-- wp:query-pagination-numbers /-->\n\n<!-- wp:query-pagination-next /-->\n<!-- /wp:query-pagination -->\n\n<!-- wp:query-no-results -->\n<!-- wp:paragraph {\"placeholder\":\"Add text or blocks that will display when a query returns no results.\"} -->\n<p></p>\n<!-- /wp:paragraph -->\n<!-- /wp:query-no-results --></div>\n<!-- /wp:woocommerce/product-collection -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:84:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/product-collection-simple-grid/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:23:15\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:75;a:18:{s:2:\"ID\";i:165;s:7:\"site_id\";i:231214916;s:5:\"title\";s:23:\"Product Collection Rows\";s:4:\"name\";s:23:\"product-collection-rows\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:2506:\"<!-- wp:woocommerce/product-collection {\"queryId\":21,\"query\":{\"perPage\":9,\"pages\":0,\"offset\":0,\"postType\":\"product\",\"order\":\"asc\",\"orderBy\":\"title\",\"search\":\"\",\"exclude\":[],\"inherit\":false,\"taxQuery\":[],\"isProductCollectionBlock\":true,\"woocommerceOnSale\":false,\"woocommerceStockStatus\":[\"instock\",\"outofstock\",\"onbackorder\"],\"woocommerceAttributes\":[],\"woocommerceHandPickedProducts\":[]},\"tagName\":\"div\",\"displayLayout\":{\"type\":\"list\",\"columns\":3,\"shrinkColumns\":true},\"queryContextIncludes\":[\"collection\"],\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/product-collection-rows\",\"name\":\"Product Collection Rows\"}} -->\n<div class=\"wp-block-woocommerce-product-collection\"><!-- wp:woocommerce/product-template -->\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"33.33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33.33%\"><!-- wp:woocommerce/product-image {\"isDescendentOfQueryLoop\":true} /--></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"66.66%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:66.66%\"><!-- wp:post-title {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\",\"lineHeight\":\"1\"},\"spacing\":{\"margin\":{\"top\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"right\":\"0\"},\"padding\":{\"right\":\"0\",\"left\":\"0\",\"top\":\"0\",\"bottom\":\"0\"}}},\"fontSize\":\"large\",\"__woocommerceNamespace\":\"woocommerce/product-collection/product-title\"} /-->\n\n<!-- wp:woocommerce/product-price {\"isDescendentOfQueryLoop\":true,\"fontSize\":\"medium\",\"style\":{\"typography\":{\"lineHeight\":\"1\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}}} /-->\n\n<!-- wp:woocommerce/product-rating {\"isDescendentOfQueryLoop\":true,\"textColor\":\"luminous-vivid-amber\",\"fontSize\":\"medium\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0px\",\"bottom\":\"0px\"}}}} /-->\n\n<!-- wp:post-excerpt {\"showMoreOnNewLine\":false,\"excerptLength\":23,\"fontSize\":\"small\",\"__woocommerceNamespace\":\"woocommerce/product-collection/product-summary\"} /--></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n<!-- /wp:woocommerce/product-template -->\n\n<!-- wp:query-pagination {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<!-- wp:query-pagination-previous /-->\n\n<!-- wp:query-pagination-numbers /-->\n\n<!-- wp:query-pagination-next /-->\n<!-- /wp:query-pagination -->\n\n<!-- wp:query-no-results -->\n<!-- wp:paragraph {\"placeholder\":\"Add text or blocks that will display when a query returns no results.\"} -->\n<p></p>\n<!-- /wp:paragraph -->\n<!-- /wp:query-no-results --></div>\n<!-- /wp:woocommerce/product-collection -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:77:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/product-collection-rows/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:22:29\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:76;a:18:{s:2:\"ID\";i:163;s:7:\"site_id\";i:231214916;s:5:\"title\";s:23:\"Product Collection Grid\";s:4:\"name\";s:23:\"product-collection-grid\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:1807:\"<!-- wp:woocommerce/product-collection {\"queryId\":20,\"query\":{\"perPage\":4,\"pages\":0,\"offset\":0,\"postType\":\"product\",\"order\":\"asc\",\"orderBy\":\"title\",\"search\":\"\",\"exclude\":[],\"inherit\":false,\"taxQuery\":[],\"isProductCollectionBlock\":true,\"woocommerceOnSale\":false,\"woocommerceStockStatus\":[\"instock\",\"outofstock\",\"onbackorder\"],\"woocommerceAttributes\":[],\"woocommerceHandPickedProducts\":[]},\"tagName\":\"div\",\"displayLayout\":{\"type\":\"flex\",\"columns\":4,\"shrinkColumns\":true},\"queryContextIncludes\":[\"collection\"],\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/product-collection-grid\",\"name\":\"Product Collection Grid\"}} -->\n<div class=\"wp-block-woocommerce-product-collection\"><!-- wp:woocommerce/product-template -->\n<!-- wp:woocommerce/product-image {\"imageSizing\":\"thumbnail\",\"isDescendentOfQueryLoop\":true} /-->\n\n<!-- wp:post-title {\"textAlign\":\"left\",\"level\":3,\"isLink\":true,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\",\"top\":\"0\"}},\"typography\":{\"lineHeight\":\"1\"}},\"fontSize\":\"small\",\"__woocommerceNamespace\":\"woocommerce/product-collection/product-title\"} /-->\n\n<!-- wp:woocommerce/product-price {\"isDescendentOfQueryLoop\":true,\"textAlign\":\"left\",\"style\":{\"typography\":{\"fontSize\":\"0.8rem\",\"lineHeight\":\"1\",\"fontStyle\":\"normal\",\"fontWeight\":\"600\"}}} /-->\n<!-- /wp:woocommerce/product-template -->\n\n<!-- wp:query-pagination {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<!-- wp:query-pagination-previous /-->\n\n<!-- wp:query-pagination-numbers /-->\n\n<!-- wp:query-pagination-next /-->\n<!-- /wp:query-pagination -->\n\n<!-- wp:query-no-results -->\n<!-- wp:paragraph {\"placeholder\":\"Add text or blocks that will display when a query returns no results.\"} -->\n<p></p>\n<!-- /wp:paragraph -->\n<!-- /wp:query-no-results --></div>\n<!-- /wp:woocommerce/product-collection -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:77:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/product-collection-grid/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:21:55\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:77;a:18:{s:2:\"ID\";i:161;s:7:\"site_id\";i:231214916;s:5:\"title\";s:28:\"Product Collection Full Grid\";s:4:\"name\";s:28:\"product-collection-full-grid\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:1966:\"<!-- wp:woocommerce/product-collection {\"queryId\":19,\"query\":{\"perPage\":3,\"pages\":0,\"offset\":0,\"postType\":\"product\",\"order\":\"asc\",\"orderBy\":\"title\",\"search\":\"\",\"exclude\":[],\"inherit\":false,\"taxQuery\":[],\"isProductCollectionBlock\":true,\"woocommerceOnSale\":false,\"woocommerceStockStatus\":[\"instock\",\"outofstock\",\"onbackorder\"],\"woocommerceAttributes\":[],\"woocommerceHandPickedProducts\":[]},\"tagName\":\"div\",\"displayLayout\":{\"type\":\"flex\",\"columns\":3,\"shrinkColumns\":true},\"queryContextIncludes\":[\"collection\"],\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/product-collection-full-grid\",\"name\":\"Product Collection Full Grid\"}} -->\n<div class=\"wp-block-woocommerce-product-collection\"><!-- wp:woocommerce/product-template -->\n<!-- wp:woocommerce/product-image {\"imageSizing\":\"thumbnail\",\"isDescendentOfQueryLoop\":true} /-->\n\n<!-- wp:woocommerce/product-price {\"isDescendentOfQueryLoop\":true,\"textAlign\":\"left\",\"fontSize\":\"medium\",\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"600\",\"lineHeight\":\"1\"}}} /-->\n\n<!-- wp:post-title {\"textAlign\":\"left\",\"level\":3,\"isLink\":true,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\",\"top\":\"0\"}},\"typography\":{\"lineHeight\":\"1\"}},\"fontSize\":\"small\",\"__woocommerceNamespace\":\"woocommerce/product-collection/product-title\"} /-->\n\n<!-- wp:woocommerce/product-button {\"textAlign\":\"left\",\"width\":50,\"isDescendentOfQueryLoop\":true,\"style\":{\"typography\":{\"fontSize\":\"0.8rem\"}}} /-->\n<!-- /wp:woocommerce/product-template -->\n\n<!-- wp:query-pagination {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<!-- wp:query-pagination-previous /-->\n\n<!-- wp:query-pagination-numbers /-->\n\n<!-- wp:query-pagination-next /-->\n<!-- /wp:query-pagination -->\n\n<!-- wp:query-no-results -->\n<!-- wp:paragraph {\"placeholder\":\"Add text or blocks that will display when a query returns no results.\"} -->\n<p></p>\n<!-- /wp:paragraph -->\n<!-- /wp:query-no-results --></div>\n<!-- /wp:woocommerce/product-collection -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:82:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/product-collection-full-grid/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:21:05\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:78;a:18:{s:2:\"ID\";i:158;s:7:\"site_id\";i:231214916;s:5:\"title\";s:25:\"Product Collection Banner\";s:4:\"name\";s:25:\"product-collection-banner\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3025:\"<!-- wp:group {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/product-collection-banner\",\"name\":\"Product Collection Banner\"},\"align\":\"wide\",\"layout\":{\"type\":\"constrained\",\"contentSize\":\"1000px\"}} -->\n<div class=\"wp-block-group alignwide\"><!-- wp:columns {\"align\":\"wide\",\"style\":{\"color\":{\"background\":\"#ffedf5\"}}} -->\n<div class=\"wp-block-columns alignwide has-background\" style=\"background-color:#ffedf5\"><!-- wp:column {\"width\":\"58%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:58%\"><!-- wp:cover {\"url\":\"https://s0.wp.com/i/woo-block-patterns/2024/06/beach-landscape-sea-coast-nature-person.jpg\",\"id\":159,\"dimRatio\":20,\"customOverlayColor\":\"#9aacbd\",\"minHeight\":430,\"minHeightUnit\":\"px\",\"isDark\":false,\"style\":{\"spacing\":{\"padding\":{\"top\":\"80px\",\"right\":\"80px\",\"bottom\":\"80px\",\"left\":\"80px\"}}}} -->\n<div class=\"wp-block-cover is-light\" style=\"padding-top:80px;padding-right:80px;padding-bottom:80px;padding-left:80px;min-height:430px\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-20 has-background-dim\" style=\"background-color:#9aacbd\"></span><img class=\"wp-block-cover__image-background wp-image-159\" alt=\"\" src=\"https://s0.wp.com/i/woo-block-patterns/2024/06/beach-landscape-sea-coast-nature-person.jpg\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:paragraph {\"align\":\"center\",\"placeholder\":\"Write title…\",\"style\":{\"typography\":{\"fontSize\":\"40px\",\"textTransform\":\"uppercase\",\"fontStyle\":\"normal\",\"fontWeight\":\"700\",\"lineHeight\":\"1.3\"},\"color\":{\"text\":\"#ffffff\"}},\"fontFamily\":\"inter\"} -->\n<p class=\"has-text-align-center has-text-color has-inter-font-family\" style=\"color:#ffffff;font-size:40px;font-style:normal;font-weight:700;line-height:1.3;text-transform:uppercase\">Brand New for the Holidays</p>\n<!-- /wp:paragraph --></div></div>\n<!-- /wp:cover --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"22px\",\"fontStyle\":\"normal\",\"fontWeight\":\"300\",\"lineHeight\":\"1.3\"},\"color\":{\"text\":\"#000000\"}},\"fontFamily\":\"inter\"} -->\n<p class=\"has-text-color has-inter-font-family\" style=\"color:#000000;font-size:22px;font-style:normal;font-weight:300;line-height:1.3\">Check out our brand new collection of holiday products and find the right gift for anyone.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"style\":{\"color\":{\"background\":\"#ff7179\",\"text\":\"#000000\"},\"border\":{\"radius\":\"100px\",\"width\":\"0px\",\"style\":\"none\"}}} --><div class=\"wp-block-button\"><a class=\"wp-block-button__link has-text-color has-background wp-element-button\" href=\"https://wooblockpatterns.wpcomstaging.com/shop/\" style=\"border-style:none;border-width:0px;border-radius:100px;color:#000000;background-color:#ff7179\">Shop now</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:79:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/product-collection-banner/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:19:42\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:79;a:18:{s:2:\"ID\";i:153;s:7:\"site_id\";i:231214916;s:5:\"title\";s:14:\"Minimal Header\";s:4:\"name\";s:14:\"minimal-header\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:1538:\"<!-- wp:group {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/header-minimal\",\"name\":\"Minimal Header\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"right\":\"40px\",\"bottom\":\"24px\",\"left\":\"40px\",\"top\":\"24px\"},\"margin\":{\"top\":\"0px\",\"bottom\":\"0px\"}}},\"className\":\"wc-blocks-pattern-header-minimal wc-blocks-header-pattern sticky-header\",\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"space-between\"}} -->\n<div class=\"wp-block-group alignfull wc-blocks-pattern-header-minimal wc-blocks-header-pattern sticky-header\" style=\"margin-top:0px;margin-bottom:0px;padding-top:24px;padding-right:40px;padding-bottom:24px;padding-left:40px\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"20px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:site-logo {\"shouldSyncIcon\":false,\"className\":\"is-style-default\"} /-->\n\n<!-- wp:site-title {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}}} /--></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"8px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"right\"}} -->\n<div class=\"wp-block-group\"><!-- wp:woocommerce/mini-cart /-->\n\n<!-- wp:navigation {\"ref\":24,\"overlayMenu\":\"always\",\"metadata\":{\"ignoredHookedBlocks\":[\"woocommerce/customer-account\"]},\"layout\":{\"type\":\"flex\",\"justifyContent\":\"left\"}} /-->\n\n<!-- wp:woocommerce/customer-account {\"displayStyle\":\"icon_only\",\"style\":{\"spacing\":{\"margin\":{\"left\":\"0.5em\"}}}} /--></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:68:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/minimal-header/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:14:02\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:80;a:18:{s:2:\"ID\";i:151;s:7:\"site_id\";i:231214916;s:5:\"title\";s:17:\"Large Header Dark\";s:4:\"name\";s:17:\"large-header-dark\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:2045:\"<!-- wp:group {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/header-large-dark\",\"name\":\"Large Header Dark\"},\"align\":\"full\",\"style\":{\"spacing\":{\"blockGap\":\"0px\",\"padding\":{\"top\":\"1rem\",\"right\":\"1rem\",\"bottom\":\"1rem\",\"left\":\"1rem\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"}}}},\"backgroundColor\":\"black\",\"textColor\":\"white\",\"className\":\"wc-blocks-header-pattern has-background-color\",\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group alignfull wc-blocks-header-pattern has-background-color has-white-color has-black-background-color has-text-color has-background has-link-color\" style=\"padding-top:1rem;padding-right:1rem;padding-bottom:1rem;padding-left:1rem\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"1rem\"}},\"className\":\"has-small-font-size\",\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"justifyContent\":\"space-between\"}} -->\n<div class=\"wp-block-group has-small-font-size\"><!-- wp:search {\"label\":\"Search\",\"showLabel\":false,\"placeholder\":\"Search\",\"width\":100,\"widthUnit\":\"%\",\"buttonText\":\"Search\",\"buttonUseIcon\":true,\"query\":{\"post_type\":\"product\"},\"style\":{\"border\":{\"radius\":\"0px\"}}} /-->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:woocommerce/customer-account {\"displayStyle\":\"icon_only\",\"iconClass\":\"wc-block-customer-account__account-icon\",\"fontSize\":\"small\"} /-->\n\n<!-- wp:woocommerce/mini-cart {\"style\":{\"typography\":{\"fontSize\":\"14px\"}}} /--></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"16px\",\"padding\":{\"top\":\"1rem\",\"left\":\"0px\",\"bottom\":\"2rem\"}}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group\" style=\"padding-top:1rem;padding-bottom:2rem;padding-left:0px\"><!-- wp:site-logo {\"shouldSyncIcon\":false} /-->\n\n<!-- wp:site-title /--></div>\n<!-- /wp:group -->\n\n<!-- wp:navigation {\"ref\":24,\"textColor\":\"background\",\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} /--></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:71:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/large-header-dark/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:13:31\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:81;a:18:{s:2:\"ID\";i:149;s:7:\"site_id\";i:231214916;s:5:\"title\";s:12:\"Large Header\";s:4:\"name\";s:12:\"large-header\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:2444:\"<!-- wp:group {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/header-large\",\"name\":\"Large Header\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"right\":\"40px\",\"left\":\"40px\",\"top\":\"24px\",\"bottom\":\"24px\"}}},\"className\":\"wc-blocks-pattern-header-large wc-blocks-header-pattern\",\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group alignfull wc-blocks-pattern-header-large wc-blocks-header-pattern\" style=\"padding-top:24px;padding-right:40px;padding-bottom:24px;padding-left:40px\"><!-- wp:group {\"align\":\"full\",\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-group alignfull\"><!-- wp:columns {\"verticalAlignment\":\"center\",\"isStackedOnMobile\":false,\"align\":\"full\"} -->\n<div class=\"wp-block-columns alignfull are-vertically-aligned-center is-not-stacked-on-mobile\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"70%\",\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:70%\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"left\"}} -->\n<div class=\"wp-block-group\"><!-- wp:site-logo {\"shouldSyncIcon\":false} /-->\n\n<!-- wp:site-title {\"style\":{\"layout\":{\"selfStretch\":\"fixed\",\"flexSize\":\"200px\"}}} /--></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"right\"}} -->\n<div class=\"wp-block-group\"><!-- wp:woocommerce/customer-account {\"displayStyle\":\"icon_only\",\"iconClass\":\"wc-block-customer-account__account-icon\"} /-->\n\n<!-- wp:woocommerce/mini-cart /--></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"align\":\"full\",\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"space-between\"}} -->\n<div class=\"wp-block-group alignfull\"><!-- wp:navigation {\"ref\":24} /-->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"right\":\"0\",\"left\":\"0\"}}},\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group\" style=\"padding-right:0;padding-left:0\"><!-- wp:search {\"label\":\"\",\"showLabel\":false,\"placeholder\":\"Search\",\"buttonText\":\"Search\",\"buttonUseIcon\":true,\"query\":{\"post_type\":\"product\"},\"style\":{\"border\":{\"radius\":\"0px\"}}} /--></div>\n<!-- /wp:group --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:66:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/large-header/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:13:05\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:82;a:18:{s:2:\"ID\";i:147;s:7:\"site_id\";i:231214916;s:5:\"title\";s:21:\"Essential Header Dark\";s:4:\"name\";s:21:\"essential-header-dark\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:1885:\"<!-- wp:group {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/header-essential-dark\",\"name\":\"Essential Header Dark\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"right\":\"2%\",\"bottom\":\"32px\",\"left\":\"2%\",\"top\":\"32px\"},\"margin\":{\"top\":\"0px\",\"bottom\":\"0px\"}},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"}}}},\"backgroundColor\":\"black\",\"textColor\":\"white\",\"className\":\"wc-blocks-header-pattern sticky-header has-background-color\",\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"justifyContent\":\"space-between\"}} -->\n<div class=\"wp-block-group alignfull wc-blocks-header-pattern sticky-header has-background-color has-white-color has-black-background-color has-text-color has-background has-link-color\" style=\"margin-top:0px;margin-bottom:0px;padding-top:32px;padding-right:2%;padding-bottom:32px;padding-left:2%\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"40px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:site-logo {\"shouldSyncIcon\":false} /-->\n\n<!-- wp:search {\"label\":\"Search\",\"showLabel\":false,\"placeholder\":\"Search\",\"width\":100,\"widthUnit\":\"%\",\"buttonText\":\"Search\",\"buttonUseIcon\":true,\"query\":{\"post_type\":\"product\"},\"style\":{\"border\":{\"radius\":\"0px\"}},\"backgroundColor\":\"contrast-2\"} /-->\n\n<!-- wp:navigation {\"ref\":24,\"textColor\":\"background\",\"overlayTextColor\":\"contrast\",\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} /--></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"8px\"},\"layout\":{\"selfStretch\":\"fill\",\"flexSize\":null}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"right\"}} -->\n<div class=\"wp-block-group\"><!-- wp:woocommerce/customer-account {\"displayStyle\":\"icon_only\",\"iconStyle\":\"alt\",\"iconClass\":\"wc-block-customer-account__account-icon\"} /-->\n\n<!-- wp:woocommerce/mini-cart /--></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:75:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/essential-header-dark/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:12:34\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:83;a:18:{s:2:\"ID\";i:145;s:7:\"site_id\";i:231214916;s:5:\"title\";s:16:\"Essential Header\";s:4:\"name\";s:16:\"essential-header\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:1298:\"<!-- wp:group {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/header-essential\",\"name\":\"Essential Header\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"40px\",\"bottom\":\"40px\",\"left\":\"40px\",\"right\":\"40px\"}}},\"className\":\"wc-blocks-pattern-header-essential wc-blocks-header-pattern\",\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"space-between\"}} -->\n<div class=\"wp-block-group alignfull wc-blocks-pattern-header-essential wc-blocks-header-pattern\" style=\"padding-top:40px;padding-right:40px;padding-bottom:40px;padding-left:40px\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:site-logo /--></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"10px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:woocommerce/mini-cart /-->\n\n<!-- wp:woocommerce/customer-account {\"displayStyle\":\"icon_only\",\"iconClass\":\"wc-block-customer-account__account-icon\"} /--></div>\n<!-- /wp:group -->\n\n<!-- wp:navigation {\"ref\":24,\"style\":{\"spacing\":{\"blockGap\":\"24px\"}}} /--></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:70:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/essential-header/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:12:09\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:84;a:18:{s:2:\"ID\";i:143;s:7:\"site_id\";i:231214916;s:5:\"title\";s:20:\"Centered Header Menu\";s:4:\"name\";s:20:\"centered-header-menu\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:2534:\"<!-- wp:group {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/header-centered-menu\",\"name\":\"Centered Header Menu\"},\"align\":\"full\",\"className\":\"wc-blocks-pattern-header-centered-menu wc-blocks-header-pattern\",\"layout\":{\"type\":\"constrained\"}} -->\n<div class=\"wp-block-group alignfull wc-blocks-pattern-header-centered-menu wc-blocks-header-pattern\"><!-- wp:columns {\"verticalAlignment\":\"center\",\"isStackedOnMobile\":false,\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"24px\",\"bottom\":\"24px\",\"left\":\"40px\",\"right\":\"40px\"}}}} -->\n<div class=\"wp-block-columns alignfull are-vertically-aligned-center is-not-stacked-on-mobile\" style=\"padding-top:24px;padding-right:40px;padding-bottom:24px;padding-left:40px\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"70%\",\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:70%\"><!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"left\"}} -->\n<div class=\"wp-block-group\"><!-- wp:site-logo {\"shouldSyncIcon\":false} /-->\n\n<!-- wp:site-title {\"style\":{\"layout\":{\"selfStretch\":\"fixed\",\"flexSize\":\"200px\"},\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}}} /--></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"right\"}} -->\n<div class=\"wp-block-group\"><!-- wp:woocommerce/customer-account {\"displayStyle\":\"icon_only\",\"iconClass\":\"wc-block-customer-account__account-icon\"} /-->\n\n<!-- wp:woocommerce/mini-cart /--></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:separator {\"align\":\"full\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"0px\",\"bottom\":\"0px\"}}},\"className\":\"is-style-wide\"} -->\n<hr class=\"wp-block-separator alignfull has-alpha-channel-opacity is-style-wide\" style=\"margin-top:0px;margin-bottom:0px\"/>\n<!-- /wp:separator -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group\"><!-- wp:navigation {\"ref\":24,\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"400\"},\"spacing\":{\"blockGap\":\"30px\"}}} /--></div>\n<!-- /wp:group -->\n\n<!-- wp:separator {\"align\":\"full\",\"className\":\"is-style-wide\"} -->\n<hr class=\"wp-block-separator alignfull has-alpha-channel-opacity is-style-wide\"/>\n<!-- /wp:separator --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:74:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/centered-header-menu/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:11:37\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:85;a:18:{s:2:\"ID\";i:141;s:7:\"site_id\";i:231214916;s:5:\"title\";s:17:\"Footer with menus\";s:4:\"name\";s:17:\"footer-with-menus\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:2902:\"<!-- wp:group {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/footer-with-3-menus\",\"name\":\"Footer with menus\"},\"align\":\"full\",\"style\":{\"spacing\":{\"blockGap\":\"40px\",\"padding\":{\"top\":\"40px\",\"right\":\"40px\",\"bottom\":\"40px\",\"left\":\"40px\"}}},\"className\":\"wc-blocks-pattern-footer-with-3-menus wc-blocks-footer-pattern\"} -->\n<div class=\"wp-block-group alignfull wc-blocks-pattern-footer-with-3-menus wc-blocks-footer-pattern\" style=\"padding-top:40px;padding-right:40px;padding-bottom:40px;padding-left:40px\"><!-- wp:columns {\"style\":{\"spacing\":{\"padding\":{\"right\":\"0\",\"left\":\"0\"}}},\"className\":\"are-vertically-aligned-top\"} -->\n<div class=\"wp-block-columns are-vertically-aligned-top\" style=\"padding-right:0;padding-left:0\"><!-- wp:column {\"verticalAlignment\":\"top\",\"width\":\"60%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-top\" style=\"flex-basis:60%\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"32px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"verticalAlignment\":\"top\"}} -->\n<div class=\"wp-block-group\"><!-- wp:site-logo /-->\n\n<!-- wp:columns {\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"var:preset|spacing|50\"}},\"layout\":{\"selfStretch\":\"fill\",\"flexSize\":null}}} -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:navigation {\"ref\":24,\"overlayMenu\":\"never\",\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"},\"style\":{\"spacing\":{\"blockGap\":\"10px\"}}} /--></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"10%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:10%\"></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"stretch\",\"width\":\"30%\",\"style\":{\"spacing\":{\"blockGap\":\"60px\"}},\"layout\":{\"type\":\"default\"}} -->\n<div class=\"wp-block-column is-vertically-aligned-stretch\" style=\"flex-basis:30%\"><!-- wp:search {\"label\":\"Search\",\"showLabel\":false,\"placeholder\":\"Search\",\"width\":100,\"widthUnit\":\"%\",\"buttonText\":\"Search\",\"buttonUseIcon\":true,\"query\":{\"post_type\":\"product\"},\"style\":{\"border\":{\"radius\":\"0px\"}}} /-->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"0\",\"padding\":{\"right\":\"0\",\"left\":\"0\"},\"margin\":{\"top\":\"56px\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"justifyContent\":\"right\"}} -->\n<div class=\"wp-block-group\" style=\"margin-top:56px;margin-bottom:0;padding-right:0;padding-left:0\"><!-- wp:site-title {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}}} /-->\n\n<!-- wp:paragraph {\"align\":\"right\"} -->\n<p class=\"has-text-align-right\">\n					Powered by <a href=\"https://wordpress.org\" target=\"_blank\" rel=\"noreferrer nofollow noopener\">WordPress</a> with <a href=\"https://woocommerce.com\" target=\"_blank\" rel=\"noreferrer nofollow noopener\">WooCommerce</a>				</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:71:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/footer-with-menus/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:11:08\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:86;a:18:{s:2:\"ID\";i:139;s:7:\"site_id\";i:231214916;s:5:\"title\";s:24:\"Footer with 2 Menus Dark\";s:4:\"name\";s:24:\"footer-with-2-menus-dark\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3670:\"<!-- wp:group {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/footer-with-2-menus-dark\",\"name\":\"Footer with 2 Menus Dark\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"32px\",\"right\":\"4%\",\"bottom\":\"32px\",\"left\":\"4%\"},\"blockGap\":\"40px\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"}}}},\"backgroundColor\":\"black\",\"textColor\":\"white\",\"className\":\"wc-blocks-footer-pattern has-background-color\"} -->\n<div class=\"wp-block-group alignfull wc-blocks-footer-pattern has-background-color has-white-color has-black-background-color has-text-color has-background has-link-color\" style=\"padding-top:32px;padding-right:4%;padding-bottom:32px;padding-left:4%\"><!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"70%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:70%\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"32px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:site-logo {\"shouldSyncIcon\":false} /-->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"8px\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:navigation {\"ref\":24} /-->\n\n<!-- wp:navigation {\"ref\":24} /--></div>\n<!-- /wp:group --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"style\":{\"spacing\":{\"blockGap\":\"16px\"}}} -->\n<div class=\"wp-block-column\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"4px\"}},\"textColor\":\"background\",\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\n<div class=\"wp-block-group has-background-color has-text-color\"><!-- wp:paragraph {\"textColor\":\"background\",\"fontSize\":\"medium\"} -->\n<p class=\"has-background-color has-text-color has-medium-font-size\"><strong>Join our community</strong>\n				</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"14px\"}}} -->\n<p style=\"font-size:14px\">Learn about new products and discounts!</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:social-links {\"iconColor\":\"background\",\"iconColorValue\":\"#ffffff\",\"className\":\"is-style-logos-only\"} -->\n<ul class=\"wp-block-social-links has-icon-color is-style-logos-only\"><!-- wp:social-link {\"service\":\"facebook\"} /-->\n\n<!-- wp:social-link {\"service\":\"instagram\"} /-->\n\n<!-- wp:social-link {\"service\":\"twitter\"} /--></ul>\n<!-- /wp:social-links --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0px\",\"right\":\"0px\",\"bottom\":\"0px\",\"left\":\"0px\"},\"blockGap\":\"16px\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"}}}},\"textColor\":\"background\",\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull has-background-color has-text-color has-link-color\" style=\"padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"8px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"12px\"}}} -->\n<p style=\"font-size:12px\">@ 2022</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:site-title {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"400\",\"fontSize\":\"12px\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|base\"}}}}} /--></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"14px\"}}} -->\n<p style=\"font-size:14px\"><em>\n			Built with <a href=\"https://woocommerce.com/\" target=\"_blank\" rel=\"noreferrer nofollow noopener\">WooCommerce</a>		</em></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:78:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/footer-with-2-menus-dark/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:10:37\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:87;a:18:{s:2:\"ID\";i:137;s:7:\"site_id\";i:231214916;s:5:\"title\";s:19:\"Footer with 2 Menus\";s:4:\"name\";s:19:\"footer-with-2-menus\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3013:\"<!-- wp:group {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/footer-with-2-menus\",\"name\":\"Footer with 2 Menus\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"32px\",\"right\":\"4%\",\"bottom\":\"32px\",\"left\":\"4%\"},\"blockGap\":\"40px\"}},\"className\":\"wc-blocks-footer-pattern\"} -->\n<div class=\"wp-block-group alignfull wc-blocks-footer-pattern\" style=\"padding-top:32px;padding-right:4%;padding-bottom:32px;padding-left:4%\"><!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"70%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:70%\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"32px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:site-logo {\"shouldSyncIcon\":false} /-->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"8px\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:navigation {\"ref\":24} /-->\n\n<!-- wp:navigation {\"ref\":24} /--></div>\n<!-- /wp:group --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"style\":{\"spacing\":{\"blockGap\":\"16px\"}}} -->\n<div class=\"wp-block-column\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"4px\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"fontSize\":\"medium\"} -->\n<p class=\"has-medium-font-size\"><strong>Join our community</strong></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"14px\"}}} -->\n<p style=\"font-size:14px\">Learn about new products and discounts!</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group -->\n\n<!-- wp:social-links {\"className\":\"is-style-logos-only\"} -->\n<ul class=\"wp-block-social-links is-style-logos-only\"><!-- wp:social-link {\"service\":\"facebook\"} /-->\n\n<!-- wp:social-link {\"service\":\"instagram\"} /-->\n\n<!-- wp:social-link {\"service\":\"twitter\"} /--></ul>\n<!-- /wp:social-links --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0px\",\"right\":\"0px\",\"bottom\":\"0px\",\"left\":\"0px\"},\"blockGap\":\"16px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"8px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"12px\"}}} -->\n<p style=\"font-size:12px\">@ 2022</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:site-title {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"400\",\"fontSize\":\"12px\"}}} /--></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"14px\"}}} -->\n<p style=\"font-size:14px\"><em>\n			Built with <a href=\"https://woocommerce.com/\" target=\"_blank\" rel=\"noreferrer nofollow noopener\">WooCommerce</a>		</em></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:73:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/footer-with-2-menus/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:10:01\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:88;a:18:{s:2:\"ID\";i:135;s:7:\"site_id\";i:231214916;s:5:\"title\";s:23:\"Footer with Simple Menu\";s:4:\"name\";s:23:\"footer-with-simple-menu\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:2412:\"<!-- wp:group {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/footer-simple-menu\",\"name\":\"Footer with Simple Menu\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"40px\",\"bottom\":\"40px\",\"left\":\"40px\",\"right\":\"40px\"}}},\"className\":\"wc-blocks-pattern-footer-simple-menu wc-blocks-footer-pattern\"} -->\n<div class=\"wp-block-group alignfull wc-blocks-pattern-footer-simple-menu wc-blocks-footer-pattern\" style=\"padding-top:40px;padding-right:40px;padding-bottom:40px;padding-left:40px\"><!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"right\":\"0\",\"left\":\"0\"}}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"justifyContent\":\"space-between\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"padding-right:0;padding-left:0\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"24px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:search {\"label\":\"Search\",\"showLabel\":false,\"placeholder\":\"Search\",\"width\":100,\"widthUnit\":\"%\",\"buttonText\":\"Search\",\"buttonUseIcon\":true,\"query\":{\"post_type\":\"product\"},\"style\":{\"border\":{\"radius\":\"0px\"}}} /--></div>\n<!-- /wp:group -->\n\n<!-- wp:group {\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\"}} -->\n<div class=\"wp-block-group\"><!-- wp:navigation {\"ref\":24,\"overlayMenu\":\"never\",\"layout\":{\"type\":\"flex\",\"orientation\":\"horizontal\",\"justifyContent\":\"left\",\"flexWrap\":\"wrap\"},\"style\":{\"spacing\":{\"blockGap\":\"24px\"}}} /--></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\n\n<!-- wp:separator {\"align\":\"full\",\"style\":{\"spacing\":{\"margin\":{\"top\":\"var:preset|spacing|40\",\"bottom\":\"var:preset|spacing|40\"}}},\"className\":\"is-style-wide\"} -->\n<hr class=\"wp-block-separator alignfull has-alpha-channel-opacity is-style-wide\" style=\"margin-top:var(--wp--preset--spacing--40);margin-bottom:var(--wp--preset--spacing--40)\"/>\n<!-- /wp:separator -->\n\n<!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"5px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"center\",\"orientation\":\"vertical\"}} -->\n<div class=\"wp-block-group\"><!-- wp:site-title /-->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">\n			Powered by <a href=\"https://wordpress.org\" target=\"_blank\" rel=\"noreferrer nofollow noopener\">WordPress</a> with <a href=\"https://woocommerce.com\" target=\"_blank\" rel=\"noreferrer nofollow noopener\">WooCommerce</a>		</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:77:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/footer-with-simple-menu/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:09:23\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:89;a:18:{s:2:\"ID\";i:133;s:7:\"site_id\";i:231214916;s:5:\"title\";s:18:\"Simple Footer Dark\";s:4:\"name\";s:18:\"simple-footer-dark\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:2951:\"<!-- wp:group {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/footer-simple-dark\",\"name\":\"Simple Footer Dark\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"32px\",\"right\":\"48px\",\"bottom\":\"32px\",\"left\":\"48px\"},\"blockGap\":\"40px\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"}}}},\"backgroundColor\":\"black\",\"textColor\":\"white\",\"className\":\"wc-blocks-footer-pattern has-background-color\"} -->\n<div class=\"wp-block-group alignfull wc-blocks-footer-pattern has-background-color has-white-color has-black-background-color has-text-color has-background has-link-color\" style=\"padding-top:32px;padding-right:48px;padding-bottom:32px;padding-left:48px\"><!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"50%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"32px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group\"><!-- wp:site-logo /-->\n\n<!-- wp:woocommerce/customer-account {\"fontSize\":\"small\"} /-->\n\n<!-- wp:navigation {\"ref\":24} /--></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"50%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:50%\"><!-- wp:social-links {\"iconColor\":\"background\",\"iconColorValue\":\"#ffffff\",\"className\":\"is-style-logos-only\",\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<ul class=\"wp-block-social-links has-icon-color is-style-logos-only\"><!-- wp:social-link {\"service\":\"facebook\"} /-->\n\n<!-- wp:social-link {\"service\":\"instagram\"} /-->\n\n<!-- wp:social-link {\"service\":\"twitter\"} /--></ul>\n<!-- /wp:social-links --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0px\",\"right\":\"0px\",\"bottom\":\"0px\",\"left\":\"0px\"},\"blockGap\":\"12px\"}},\"textColor\":\"background\",\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull has-background-color has-text-color\" style=\"padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"8px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"12px\"}}} -->\n<p style=\"font-size:12px\">@ 2022</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:site-title {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"400\",\"fontSize\":\"12px\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"}}}}} /--></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"14px\"}}} -->\n<p style=\"font-size:14px\"><em>\n			Built with <a href=\"https://woocommerce.com/\" target=\"_blank\" rel=\"noreferrer nofollow noopener\">WooCommerce</a>		</em></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:72:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/simple-footer-dark/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:08:48\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:90;a:18:{s:2:\"ID\";i:131;s:7:\"site_id\";i:231214916;s:5:\"title\";s:13:\"Simple Footer\";s:4:\"name\";s:13:\"simple-footer\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:2499:\"<!-- wp:group {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/footer-simple\",\"name\":\"Simple Footer\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"32px\",\"right\":\"48px\",\"bottom\":\"32px\",\"left\":\"48px\"},\"blockGap\":\"40px\"}},\"className\":\"wc-blocks-footer-pattern\"} -->\n<div class=\"wp-block-group alignfull wc-blocks-footer-pattern\" style=\"padding-top:32px;padding-right:48px;padding-bottom:32px;padding-left:48px\"><!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"50%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"32px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group\"><!-- wp:site-logo /-->\n\n<!-- wp:woocommerce/customer-account {\"fontSize\":\"small\"} /-->\n\n<!-- wp:navigation {\"ref\":24} /--></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"50%\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\" style=\"flex-basis:50%\"><!-- wp:social-links {\"className\":\"is-style-logos-only\",\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<ul class=\"wp-block-social-links is-style-logos-only\"><!-- wp:social-link {\"service\":\"facebook\"} /-->\n\n<!-- wp:social-link {\"service\":\"instagram\"} /-->\n\n<!-- wp:social-link {\"service\":\"twitter\"} /--></ul>\n<!-- /wp:social-links --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0px\",\"right\":\"0px\",\"bottom\":\"0px\",\"left\":\"0px\"},\"blockGap\":\"12px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"8px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"12px\"}}} -->\n<p style=\"font-size:12px\">@ 2022</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:site-title {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"400\",\"fontSize\":\"12px\"}}} /--></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontSize\":\"14px\"}}} -->\n<p style=\"font-size:14px\"><em>\n			Built with <a href=\"https://woocommerce.com/\" target=\"_blank\" rel=\"noreferrer nofollow noopener\">WooCommerce</a>		</em></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:67:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/simple-footer/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:07:40\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:91;a:18:{s:2:\"ID\";i:129;s:7:\"site_id\";i:231214916;s:5:\"title\";s:17:\"Large Footer Dark\";s:4:\"name\";s:17:\"large-footer-dark\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:4192:\"<!-- wp:group {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/footer-large-dark\",\"name\":\"Large Footer Dark\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"32px\",\"right\":\"4%\",\"bottom\":\"32px\",\"left\":\"4%\"},\"blockGap\":\"40px\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"}}}},\"backgroundColor\":\"black\",\"textColor\":\"white\",\"className\":\"wc-blocks-footer-pattern has-background-color\"} -->\n<div class=\"wp-block-group alignfull wc-blocks-footer-pattern has-background-color has-white-color has-black-background-color has-text-color has-background has-link-color\" style=\"padding-top:32px;padding-right:4%;padding-bottom:32px;padding-left:4%\"><!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":\"16px\"}}} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column {\"width\":\"45%\",\"style\":{\"spacing\":{\"padding\":{\"right\":\"50px\"}}}} -->\n<div class=\"wp-block-column\" style=\"padding-right:50px;flex-basis:45%\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"8px\"}},\"textColor\":\"background\",\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\n<div class=\"wp-block-group has-background-color has-text-color\"><!-- wp:site-logo /-->\n\n<!-- wp:spacer {\"height\":\"0px\",\"style\":{\"layout\":{\"flexSize\":\"30px\",\"selfStretch\":\"fixed\"}}} -->\n<div style=\"height:0px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"level\":5} -->\n<h5 class=\"wp-block-heading\">Join the community</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Learn about new products and discounts!</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":\"0px\",\"style\":{\"layout\":{\"flexSize\":\"20px\",\"selfStretch\":\"fixed\"}}} -->\n<div style=\"height:0px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\n\n<!-- wp:social-links {\"iconColor\":\"background\",\"iconColorValue\":\"#ffffff\",\"size\":\"has-small-icon-size\",\"className\":\"is-style-logos-only\"} -->\n<ul class=\"wp-block-social-links has-small-icon-size has-icon-color is-style-logos-only\"><!-- wp:social-link {\"url\":\"https://www.facebook.com\",\"service\":\"facebook\"} /-->\n\n<!-- wp:social-link {\"url\":\"https://www.x.com\",\"service\":\"x\"} /-->\n\n<!-- wp:social-link {\"url\":\"https://www.instagram.com\",\"service\":\"instagram\"} /--></ul>\n<!-- /wp:social-links --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"20%\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0px\"}}}} -->\n<div class=\"wp-block-column\" style=\"padding-top:0px;flex-basis:20%\"><!-- wp:navigation {\"ref\":24,\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} /--></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"top\",\"width\":\"20%\",\"style\":{\"spacing\":{\"blockGap\":\"16px\"}}} -->\n<div class=\"wp-block-column is-vertically-aligned-top\" style=\"flex-basis:20%\"><!-- wp:navigation {\"ref\":24,\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} /--></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"top\",\"width\":\"20%\",\"style\":{\"spacing\":{\"blockGap\":\"16px\"}}} -->\n<div class=\"wp-block-column is-vertically-aligned-top\" style=\"flex-basis:20%\"><!-- wp:woocommerce/customer-account {\"displayStyle\":\"text_only\",\"fontSize\":\"small\"} /--></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0px\",\"right\":\"0px\",\"bottom\":\"0px\",\"left\":\"0px\"},\"blockGap\":\"10px\"}},\"textColor\":\"background\",\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull has-background-color has-text-color\" style=\"padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"8px\"},\"elements\":{\"link\":{\"color\":{\"text\":\"var:preset|color|background\"}}}},\"textColor\":\"background\",\"layout\":{\"type\":\"flex\",\"flexWrap\":\"nowrap\"}} -->\n<div class=\"wp-block-group has-background-color has-text-color has-link-color\"><!-- wp:paragraph -->\n<p>@ 2024</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:site-title /--></div>\n<!-- /wp:group -->\n\n<!-- wp:paragraph -->\n<p><em>\n			Built with <a href=\"https://woocommerce.com/\" target=\"_blank\" rel=\"noreferrer nofollow noopener\">WooCommerce</a>		</em></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:71:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/large-footer-dark/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:06:19\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:92;a:18:{s:2:\"ID\";i:125;s:7:\"site_id\";i:231214916;s:5:\"title\";s:12:\"Large Footer\";s:4:\"name\";s:12:\"large-footer\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3605:\"<!-- wp:group {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/footer-large\",\"name\":\"Large Footer\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"40px\",\"right\":\"40px\",\"bottom\":\"40px\",\"left\":\"40px\"},\"blockGap\":\"40px\"}},\"className\":\"wc-blocks-pattern-footer-large wc-blocks-footer-pattern\"} -->\n<div class=\"wp-block-group alignfull wc-blocks-pattern-footer-large wc-blocks-footer-pattern\" style=\"padding-top:40px;padding-right:40px;padding-bottom:40px;padding-left:40px\"><!-- wp:columns {\"align\":\"wide\",\"style\":{\"spacing\":{\"blockGap\":\"32px\",\"padding\":{\"right\":\"0px\",\"left\":\"0px\"}}}} -->\n<div class=\"wp-block-columns alignwide\" style=\"padding-right:0px;padding-left:0px\"><!-- wp:column {\"width\":\"60%\",\"style\":{\"spacing\":{\"padding\":{\"right\":\"50px\"}}}} -->\n<div class=\"wp-block-column\" style=\"padding-right:50px;flex-basis:60%\"><!-- wp:group {\"style\":{\"spacing\":{\"blockGap\":\"8px\"}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\"}} -->\n<div class=\"wp-block-group\"><!-- wp:site-logo /-->\n\n<!-- wp:heading {\"level\":5,\"style\":{\"typography\":{\"textTransform\":\"none\"},\"spacing\":{\"margin\":{\"top\":\"40px\"}}}} -->\n<h5 class=\"wp-block-heading\" style=\"margin-top:40px;text-transform:none\">Join the community</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"40px\"}}}} -->\n<p style=\"margin-bottom:40px\">Learn about new products and discounts</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:social-links {\"size\":\"has-small-icon-size\",\"style\":{\"spacing\":{\"blockGap\":{\"left\":\"16px\"}}},\"className\":\"is-style-logos-only\"} -->\n<ul class=\"wp-block-social-links has-small-icon-size is-style-logos-only\"><!-- wp:social-link {\"url\":\"https://www.facebook.com\",\"service\":\"facebook\"} /-->\n\n<!-- wp:social-link {\"url\":\"https://www.x.com\",\"service\":\"x\"} /-->\n\n<!-- wp:social-link {\"url\":\"https://www.instagram.com\",\"service\":\"instagram\"} /-->\n\n<!-- wp:social-link {\"url\":\"https://www.twitch.com\",\"service\":\"twitch\"} /--></ul>\n<!-- /wp:social-links --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"20%\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0px\"}}}} -->\n<div class=\"wp-block-column\" style=\"padding-top:0px;flex-basis:20%\"></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"top\",\"width\":\"20%\",\"style\":{\"spacing\":{\"blockGap\":\"16px\"}}} -->\n<div class=\"wp-block-column is-vertically-aligned-top\" style=\"flex-basis:20%\"></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"top\",\"width\":\"20%\",\"style\":{\"spacing\":{\"blockGap\":\"16px\"}}} -->\n<div class=\"wp-block-column is-vertically-aligned-top\" style=\"flex-basis:20%\"><!-- wp:navigation {\"ref\":24,\"overlayMenu\":\"never\",\"layout\":{\"overlayMenu\":\"never\",\"type\":\"flex\",\"orientation\":\"vertical\"},\"style\":{\"spacing\":{\"blockGap\":\"10px\"}}} /--></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"0px\",\"right\":\"0px\",\"bottom\":\"0px\",\"left\":\"0px\"},\"blockGap\":\"10px\"}},\"layout\":{\"type\":\"flex\",\"flexWrap\":\"wrap\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px\"><!-- wp:site-title {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"700\"}}} /-->\n\n<!-- wp:paragraph {\"align\":\"center\"} -->\n<p class=\"has-text-align-center\">\n			Powered by <a href=\"https://wordpress.org\" target=\"_blank\" rel=\"noreferrer nofollow noopener\">WordPress</a> with <a href=\"https://woocommerce.com\" target=\"_blank\" rel=\"noreferrer nofollow noopener\">WooCommerce</a>		</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:66:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/large-footer/\";s:13:\"modified_date\";s:19:\"2024-06-17 14:05:20\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:93;a:18:{s:2:\"ID\";i:119;s:7:\"site_id\";i:231214916;s:5:\"title\";s:36:\"Featured Products: Fresh &amp; Tasty\";s:4:\"name\";s:29:\"featured-products-fresh-tasty\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:5006:\"<!-- wp:columns {\"align\":\"wide\"} -->\n<div class=\"wp-block-columns alignwide\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":120,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"align\":\"full\"} -->\n<figure class=\"wp-block-image alignfull size-full\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/06/sweet-organic-lemons.png\" alt=\"\" class=\"wp-image-120\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:columns {\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"0\"},\"margin\":{\"top\":\"5px\",\"bottom\":\"0\"}}}} -->\n<div class=\"wp-block-columns\" style=\"margin-top:5px;margin-bottom:0\"><!-- wp:column {\"width\":\"67%\",\"style\":{\"typography\":{\"fontWeight\":\"600\"}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"left\"}} -->\n<div class=\"wp-block-column\" style=\"font-weight:600;flex-basis:67%\"><!-- wp:paragraph {\"fontSize\":\"small\"} -->\n<p class=\"has-small-font-size\">Sweet Organic Lemons</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"33%\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"right\"}} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33%\"><!-- wp:paragraph {\"align\":\"left\",\"fontSize\":\"small\"} -->\n<p class=\"has-text-align-left has-small-font-size\">from $1.99</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":121,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"align\":\"full\"} -->\n<figure class=\"wp-block-image alignfull size-full\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/06/fresh-organic-tomatoes.png\" alt=\"\" class=\"wp-image-121\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:columns {\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"0\"},\"margin\":{\"top\":\"5px\",\"bottom\":\"0\"}}}} -->\n<div class=\"wp-block-columns\" style=\"margin-top:5px;margin-bottom:0\"><!-- wp:column {\"width\":\"67%\",\"style\":{\"typography\":{\"fontWeight\":\"600\"}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"left\"}} -->\n<div class=\"wp-block-column\" style=\"font-weight:600;flex-basis:67%\"><!-- wp:paragraph {\"fontSize\":\"small\"} -->\n<p class=\"has-small-font-size\">Fresh Organic Tomatoes</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"33%\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"right\"}} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33%\"><!-- wp:paragraph {\"align\":\"left\",\"fontSize\":\"small\"} -->\n<p class=\"has-text-align-left has-small-font-size\">from $2.99</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":122,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"align\":\"full\"} -->\n<figure class=\"wp-block-image alignfull size-full\"><img src=\"https://s2.wp.com/i/woo-block-patterns/2024/06/fresh-lettuce-washed.png\" alt=\"\" class=\"wp-image-122\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:columns {\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"0\"},\"margin\":{\"top\":\"5px\",\"bottom\":\"0\"}}}} -->\n<div class=\"wp-block-columns\" style=\"margin-top:5px;margin-bottom:0\"><!-- wp:column {\"width\":\"67%\",\"style\":{\"typography\":{\"fontWeight\":\"600\"}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"left\"}} -->\n<div class=\"wp-block-column\" style=\"font-weight:600;flex-basis:67%\"><!-- wp:paragraph {\"fontSize\":\"small\"} -->\n<p class=\"has-small-font-size\">Fresh Lettuce (Washed)</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"33%\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"right\"}} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33%\"><!-- wp:paragraph {\"align\":\"left\",\"fontSize\":\"small\"} -->\n<p class=\"has-text-align-left has-small-font-size\">from $0.99</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":123,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"align\":\"full\"} -->\n<figure class=\"wp-block-image alignfull size-full\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/06/russet-organic-potatoes.png\" alt=\"\" class=\"wp-image-123\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:columns {\"style\":{\"spacing\":{\"blockGap\":{\"top\":\"0\"},\"margin\":{\"top\":\"5px\",\"bottom\":\"0\"}}}} -->\n<div class=\"wp-block-columns\" style=\"margin-top:5px;margin-bottom:0\"><!-- wp:column {\"width\":\"67%\",\"style\":{\"typography\":{\"fontWeight\":\"600\"}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"left\"}} -->\n<div class=\"wp-block-column\" style=\"font-weight:600;flex-basis:67%\"><!-- wp:paragraph {\"fontSize\":\"small\"} -->\n<p class=\"has-small-font-size\">Russet Organic Potatoes</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"33%\",\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"right\"}} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33%\"><!-- wp:paragraph {\"align\":\"left\",\"fontSize\":\"small\"} -->\n<p class=\"has-text-align-left has-small-font-size\">from $1.49</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:83:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/featured-products-fresh-tasty/\";s:13:\"modified_date\";s:19:\"2024-06-17 13:47:45\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:94;a:18:{s:2:\"ID\";i:115;s:7:\"site_id\";i:231214916;s:5:\"title\";s:26:\"Discount Banner with Image\";s:4:\"name\";s:26:\"discount-banner-with-image\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3248:\"<!-- wp:columns {\"verticalAlignment\":\"center\",\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/discount-banner-with-image\",\"name\":\"Discount Banner with Image\"},\"align\":\"wide\",\"style\":{\"color\":{\"background\":\"#254094\"},\"spacing\":{\"padding\":{\"top\":\"30px\",\"right\":\"30px\",\"bottom\":\"30px\",\"left\":\"30px\"}}}} -->\n<div class=\"wp-block-columns alignwide are-vertically-aligned-center has-background\" style=\"background-color:#254094;padding-top:30px;padding-right:30px;padding-bottom:30px;padding-left:30px\"><!-- wp:column {\"verticalAlignment\":\"center\",\"width\":\"\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"top\":\"15px\"}}},\"layout\":{\"type\":\"constrained\",\"contentSize\":\"350px\"}} -->\n<div class=\"wp-block-group\" style=\"padding-top:15px\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"500\",\"fontSize\":\"45px\",\"lineHeight\":\"0\"},\"color\":{\"text\":\"#ffffff\"}}} -->\n<p class=\"has-text-color\" style=\"color:#ffffff;font-size:45px;font-style:normal;font-weight:500;line-height:0\">UP TO</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#fdf251\"},\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"800\",\"fontSize\":\"90px\",\"lineHeight\":\"0.8\"}}} -->\n<p class=\"has-text-color\" style=\"color:#fdf251;font-size:90px;font-style:normal;font-weight:800;line-height:0.8\">40% off</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"300\",\"fontSize\":\"35px\",\"lineHeight\":\"0\"},\"color\":{\"text\":\"#ffffff\"},\"spacing\":{\"margin\":{\"bottom\":\"40px\"}}}} -->\n<p class=\"has-text-color\" style=\"color:#ffffff;margin-bottom:40px;font-size:35px;font-style:normal;font-weight:300;line-height:0\">Select products</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"style\":{\"color\":{\"background\":\"#ff7179\",\"text\":\"#ffffff\"},\"border\":{\"radius\":\"40px\",\"width\":\"0px\",\"style\":\"none\"},\"spacing\":{\"padding\":{\"top\":\"10px\",\"bottom\":\"10px\",\"left\":\"30px\",\"right\":\"30px\"}}}} --><div class=\"wp-block-button\"><a class=\"wp-block-button__link has-text-color has-background wp-element-button\" href=\"https://wooblockpatterns.wpcomstaging.com/shop/\" style=\"border-style:none;border-width:0px;border-radius:40px;color:#ffffff;background-color:#ff7179;padding-top:10px;padding-right:30px;padding-bottom:10px;padding-left:30px\">Shop now</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:group --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"verticalAlignment\":\"center\"} -->\n<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:image {\"id\":117,\"sizeSlug\":\"full\",\"linkDestination\":\"none\",\"align\":\"center\",\"style\":{\"border\":{\"radius\":{\"topLeft\":\"100px\",\"topRight\":\"10px\",\"bottomLeft\":\"10px\",\"bottomRight\":\"100px\"}}}} -->\n<figure class=\"wp-block-image aligncenter size-full has-custom-border\"><img src=\"https://s0.wp.com/i/woo-block-patterns/2024/06/table-floor-interior-atmosphere-living-room-furniture-square-lg.png\" alt=\"\" class=\"wp-image-117\" style=\"border-top-left-radius:100px;border-top-right-radius:10px;border-bottom-left-radius:10px;border-bottom-right-radius:100px\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:80:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/discount-banner-with-image/\";s:13:\"modified_date\";s:19:\"2024-06-17 13:45:36\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:95;a:18:{s:2:\"ID\";i:113;s:7:\"site_id\";i:231214916;s:5:\"title\";s:15:\"Discount banner\";s:4:\"name\";s:15:\"discount-banner\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:2312:\"<!-- wp:group {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/discount-banner\",\"name\":\"Discount Banner\"},\"layout\":{\"type\":\"constrained\",\"contentSize\":\"470px\"}} -->\n<div class=\"wp-block-group\"><!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|30\",\"bottom\":\"var:preset|spacing|30\",\"left\":\"var:preset|spacing|30\",\"right\":\"var:preset|spacing|30\"}},\"color\":{\"background\":\"#254094\"}},\"layout\":{\"type\":\"constrained\",\"contentSize\":\"\"}} -->\n<div class=\"wp-block-group has-background\" style=\"background-color:#254094;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)\"><!-- wp:paragraph {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"500\",\"fontSize\":\"45px\"},\"color\":{\"text\":\"#ffffff\"}}} -->\n<p class=\"has-text-color\" style=\"color:#ffffff;font-size:45px;font-style:normal;font-weight:500\">UP TO</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#fdf251\"},\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"800\",\"fontSize\":\"90px\",\"lineHeight\":\"0.1\"}}} -->\n<p class=\"has-text-color\" style=\"color:#fdf251;font-size:90px;font-style:normal;font-weight:800;line-height:0.1\">40% off</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"300\",\"fontSize\":\"35px\"},\"color\":{\"text\":\"#ffffff\"}}} -->\n<p class=\"has-text-color\" style=\"color:#ffffff;font-size:35px;font-style:normal;font-weight:300\">Select products</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"style\":{\"color\":{\"background\":\"#ff7179\",\"text\":\"#ffffff\"},\"border\":{\"radius\":\"40px\",\"width\":\"0px\",\"style\":\"none\"},\"spacing\":{\"padding\":{\"top\":\"10px\",\"bottom\":\"10px\",\"left\":\"30px\",\"right\":\"30px\"}}}} --><div class=\"wp-block-button\"><a class=\"wp-block-button__link has-text-color has-background wp-element-button\" href=\"https://wooblockpatterns.wpcomstaging.com/shop/\" style=\"border-style:none;border-width:0px;border-radius:40px;color:#ffffff;background-color:#ff7179;padding-top:10px;padding-right:30px;padding-bottom:10px;padding-left:30px\">\n					Shop now\n				</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:16:\"_woo_woocommerce\";a:3:{s:4:\"slug\";s:16:\"_woo_woocommerce\";s:5:\"title\";s:16:\"_woo_WooCommerce\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:69:\"https://wooblockpatterns.wpcomstaging.com/2024/06/17/discount-banner/\";s:13:\"modified_date\";s:19:\"2024-06-17 13:39:37\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:96;a:18:{s:2:\"ID\";i:99;s:7:\"site_id\";i:231214916;s:5:\"title\";s:23:\"Featured Category Focus\";s:4:\"name\";s:22:\"feature-category-focus\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:1621:\"<!-- wp:group {\"metadata\":{\"categories\":[\"woo-commerce\"],\"patternName\":\"woocommerce-blocks/featured-category-focus\",\"name\":\"Featured Category Focus\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"var:preset|spacing|70\",\"right\":\"var:preset|spacing|70\",\"bottom\":\"var:preset|spacing|70\",\"left\":\"var:preset|spacing|70\"}}},\"layout\":{\"type\":\"flex\",\"orientation\":\"vertical\",\"justifyContent\":\"center\",\"flexWrap\":\"wrap\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"padding-top:var(--wp--preset--spacing--70);padding-right:var(--wp--preset--spacing--70);padding-bottom:var(--wp--preset--spacing--70);padding-left:var(--wp--preset--spacing--70)\"><!-- wp:image {\"id\":100,\"width\":\"469px\",\"height\":\"348px\",\"scale\":\"cover\",\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full is-resized\"><img src=\"https://s1.wp.com/i/woo-block-patterns/2024/06/white-black-black-and-white-photograph-monochrome-photography.jpg\" alt=\"\" class=\"wp-image-100\" style=\"object-fit:cover;width:469px;height:348px\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"fontSize\":\"large\"} -->\n<p class=\"has-text-align-center has-large-font-size\">Black and white high-quality prints</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"style\":{\"border\":{\"width\":\"0px\",\"style\":\"none\"}}} --><div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://wooblockpatterns.wpcomstaging.com/shop/\" style=\"border-style:none;border-width:0px\">Shop prints</a></div><!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:0:{}s:10:\"categories\";a:1:{s:21:\"_woo_featured_selling\";a:3:{s:4:\"slug\";s:21:\"_woo_featured_selling\";s:5:\"title\";s:21:\"_woo_featured_selling\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:76:\"https://wooblockpatterns.wpcomstaging.com/2024/06/14/feature-category-focus/\";s:13:\"modified_date\";s:19:\"2024-07-18 16:17:19\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:97;a:18:{s:2:\"ID\";i:90;s:7:\"site_id\";i:231214916;s:5:\"title\";s:27:\"Large Image Product Gallery\";s:4:\"name\";s:27:\"large-image-product-gallery\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3144:\"<!-- wp:group {\"metadata\":{\"name\":\"Large Image Product Gallery\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:query {\"queryId\":3,\"query\":{\"perPage\":\"4\",\"pages\":0,\"offset\":0,\"postType\":\"product\",\"order\":\"desc\",\"orderBy\":\"date\",\"author\":\"\",\"search\":\"\",\"exclude\":[],\"sticky\":\"\",\"inherit\":false,\"__woocommerceStockStatus\":[\"instock\",\"outofstock\",\"onbackorder\"]},\"namespace\":\"woocommerce/product-query\"} -->\n<div class=\"wp-block-query\"><!-- wp:post-template {\"layout\":{\"type\":\"grid\",\"columnCount\":2},\"__woocommerceNamespace\":\"woocommerce/product-query/product-template\"} -->\n<!-- wp:woocommerce/product-image {\"saleBadgeAlign\":\"left\",\"isDescendentOfQueryLoop\":true,\"aspectRatio\":\"2/3\"} /-->\n\n<!-- wp:post-title {\"textAlign\":\"center\",\"level\":3,\"isLink\":true,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\",\"top\":\"0\"}}},\"fontSize\":\"medium\",\"__woocommerceNamespace\":\"woocommerce/product-query/product-title\"} /-->\n\n<!-- wp:woocommerce/product-price {\"isDescendentOfQueryLoop\":true,\"textAlign\":\"center\",\"fontSize\":\"small\",\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\"}}}} /-->\n<!-- /wp:post-template --></div>\n<!-- /wp:query -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:21:\"_woo_featured_selling\";a:3:{s:4:\"slug\";s:21:\"_woo_featured_selling\";s:5:\"title\";s:21:\"_woo_featured_selling\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:81:\"https://wooblockpatterns.wpcomstaging.com/2024/06/14/large-image-product-gallery/\";s:13:\"modified_date\";s:19:\"2024-07-02 10:55:34\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}i:98;a:18:{s:2:\"ID\";i:83;s:7:\"site_id\";i:231214916;s:5:\"title\";s:28:\"Product Collection 3 Columns\";s:4:\"name\";s:28:\"product-collection-3-columns\";s:11:\"description\";s:0:\"\";s:14:\"ai_description\";s:0:\"\";s:4:\"html\";s:3351:\"<!-- wp:group {\"metadata\":{\"name\":\"Product Collection 3 Columns\"},\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"bottom\":\"calc( 0.5 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\",\"left\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-left, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\",\"right\":\"var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal))\"},\"margin\":{\"top\":\"0\",\"bottom\":\"0\"}}},\"layout\":{\"type\":\"constrained\",\"justifyContent\":\"center\"}} -->\n<div class=\"wp-block-group alignfull\" style=\"margin-top:0;margin-bottom:0;padding-top:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-right:var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal));padding-bottom:calc( 0.5 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)));padding-left:var(--wp--style--root--padding-left, var(--wp--custom--gap--horizontal))\"><!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:woocommerce/product-collection {\"queryId\":26,\"query\":{\"perPage\":3,\"pages\":0,\"offset\":0,\"postType\":\"product\",\"order\":\"asc\",\"orderBy\":\"title\",\"search\":\"\",\"exclude\":[],\"inherit\":false,\"taxQuery\":[],\"isProductCollectionBlock\":true,\"woocommerceOnSale\":false,\"woocommerceStockStatus\":[\"instock\",\"outofstock\",\"onbackorder\"],\"woocommerceAttributes\":[],\"woocommerceHandPickedProducts\":[]},\"tagName\":\"div\",\"displayLayout\":{\"type\":\"flex\",\"columns\":3},\"queryContextIncludes\":[\"collection\"],\"align\":\"wide\"} -->\n<div class=\"wp-block-woocommerce-product-collection alignwide\"><!-- wp:woocommerce/product-template -->\n<!-- wp:woocommerce/product-image {\"isDescendentOfQueryLoop\":true,\"aspectRatio\":\"3/5\"} /-->\n\n<!-- wp:woocommerce/product-rating {\"isDescendentOfQueryLoop\":true,\"textAlign\":\"center\"} /-->\n\n<!-- wp:post-title {\"textAlign\":\"center\",\"level\":3,\"isLink\":true,\"style\":{\"spacing\":{\"margin\":{\"bottom\":\"0.75rem\",\"top\":\"0\"}}},\"fontSize\":\"medium\",\"__woocommerceNamespace\":\"woocommerce/product-collection/product-title\"} /-->\n\n<!-- wp:woocommerce/product-price {\"isDescendentOfQueryLoop\":true,\"textAlign\":\"center\",\"fontSize\":\"small\"} /-->\n<!-- /wp:woocommerce/product-template --></div>\n<!-- /wp:woocommerce/product-collection -->\n\n<!-- wp:spacer {\"height\":\"calc( 0.25 * var(\\u002d\\u002dwp\\u002d\\u002dstyle\\u002d\\u002droot\\u002d\\u002dpadding-right, var(\\u002d\\u002dwp\\u002d\\u002dcustom\\u002d\\u002dgap\\u002d\\u002dhorizontal)))\"} -->\n<div style=\"height:calc( 0.25 * var(--wp--style--root--padding-right, var(--wp--custom--gap--horizontal)))\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->\";s:14:\"disallow_after\";a:0:{}s:12:\"dependencies\";a:1:{i:0;s:11:\"woocommerce\";}s:10:\"categories\";a:1:{s:21:\"_woo_featured_selling\";a:3:{s:4:\"slug\";s:21:\"_woo_featured_selling\";s:5:\"title\";s:21:\"_woo_featured_selling\";s:11:\"description\";s:0:\"\";}}s:24:\"virtual_theme_categories\";a:0:{}s:4:\"tags\";a:0:{}s:12:\"pattern_meta\";a:0:{}s:10:\"source_url\";s:82:\"https://wooblockpatterns.wpcomstaging.com/2024/06/14/product-collection-3-columns/\";s:13:\"modified_date\";s:19:\"2024-07-02 10:35:33\";s:12:\"preview_data\";a:0:{}s:9:\"post_type\";s:8:\"wp_block\";s:22:\"is_included_in_big_sky\";i:0;}}", "on");
INSERT INTO `wp_options` VALUES("648", "action_scheduler_migration_status", "complete", "auto");
INSERT INTO `wp_options` VALUES("649", "as_has_wp_comment_logs", "no", "on");
INSERT INTO `wp_options` VALUES("650", "swa_ie_term_imported", "imported", "auto");
INSERT INTO `wp_options` VALUES("663", "_transient_product_query-transient-version", "1764313301", "on");
INSERT INTO `wp_options` VALUES("664", "wp_calendar_block_has_published_posts", "1", "auto");
INSERT INTO `wp_options` VALUES("665", "category_children", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("666", "service-category_children", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("667", "service-tag_children", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("668", "industry-category_children", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("669", "industry-tag_children", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("670", "case-category_children", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("671", "case-tag_children", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("672", "career-category_children", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("673", "career-tag_children", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("674", "elementor_library_category_children", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("675", "product_brand_children", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("676", "product_cat_children", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("677", "_transient_product-transient-version", "1749183448", "on");
INSERT INTO `wp_options` VALUES("678", "cms_theme_options", "a:93:{s:12:\"accent_color\";a:2:{s:7:\"regular\";s:0:\"\";s:6:\"darken\";s:0:\"\";}s:13:\"primary_color\";a:2:{s:7:\"regular\";s:0:\"\";s:7:\"lighten\";s:0:\"\";}s:13:\"heading_color\";a:1:{s:7:\"regular\";s:0:\"\";}s:10:\"body_color\";a:1:{s:7:\"regular\";s:0:\"\";}s:10:\"link_color\";a:3:{s:7:\"regular\";s:0:\"\";s:5:\"hover\";s:0:\"\";s:6:\"active\";s:0:\"\";}s:12:\"custom_color\";a:9:{s:5:\"green\";s:0:\"\";s:11:\"light-green\";s:0:\"\";s:6:\"purple\";s:0:\"\";s:11:\"light-purle\";s:0:\"\";s:4:\"grey\";s:0:\"\";s:7:\"stroke1\";s:0:\"\";s:7:\"divider\";s:0:\"\";s:12:\"divider-dark\";s:0:\"\";s:11:\"stroke-dark\";s:0:\"\";}s:9:\"body_font\";s:7:\"default\";s:14:\"body_font_typo\";a:2:{s:11:\"font_family\";s:0:\"\";s:10:\"font_style\";s:0:\"\";}s:12:\"heading_font\";s:7:\"default\";s:17:\"heading_font_typo\";a:2:{s:11:\"font_family\";s:0:\"\";s:10:\"font_style\";s:0:\"\";}s:17:\"show_page_loading\";s:1:\"0\";s:13:\"back_totop_on\";s:1:\"1\";s:8:\"dev_mode\";s:1:\"0\";s:17:\"header_top_layout\";s:4:\"none\";s:13:\"header_layout\";s:1:\"1\";s:11:\"header_menu\";s:2:\"65\";s:15:\"main_menu_color\";a:3:{s:7:\"regular\";s:0:\"\";s:5:\"hover\";s:0:\"\";s:6:\"active\";s:0:\"\";}s:13:\"header_height\";a:2:{s:6:\"height\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:12:\"header_width\";s:15:\"container-fluid\";s:13:\"header_sticky\";s:2:\"on\";s:18:\"header_sticky_mode\";s:7:\"srollup\";s:12:\"header_boxed\";s:3:\"off\";s:13:\"header_shadow\";s:3:\"off\";s:14:\"header_divider\";s:3:\"off\";s:4:\"logo\";a:2:{s:3:\"url\";s:69:\"https://atlascapt.warelytest.com/wp-content/uploads/2025/08/1logo.png\";s:2:\"id\";s:3:\"808\";}s:9:\"logo_maxh\";a:3:{s:5:\"width\";s:3:\"230\";s:6:\"height\";s:3:\"190\";s:4:\"unit\";s:2:\"px\";}s:11:\"logo_mobile\";a:2:{s:3:\"url\";s:69:\"https://atlascapt.warelytest.com/wp-content/uploads/2025/08/1logo.png\";s:2:\"id\";s:3:\"808\";}s:12:\"logo_maxh_sm\";a:3:{s:5:\"width\";s:3:\"230\";s:6:\"height\";s:3:\"190\";s:4:\"unit\";s:2:\"px\";}s:18:\"header_transparent\";s:3:\"off\";s:10:\"logo_light\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:17:\"logo_light_mobile\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:22:\"transparent_menu_color\";a:3:{s:7:\"regular\";s:0:\"\";s:5:\"hover\";s:0:\"\";s:6:\"active\";s:0:\"\";}s:11:\"search_icon\";s:3:\"off\";s:17:\"search_on_content\";s:2:\"_1\";s:25:\"search_on_content_content\";s:2:\"_1\";s:9:\"cart_icon\";s:3:\"off\";s:10:\"h_phone_on\";s:3:\"off\";s:12:\"h_phone_text\";s:0:\"\";s:14:\"h_phone_number\";s:13:\"+65 8931 8808\";s:9:\"h_mail_on\";s:3:\"off\";s:11:\"h_mail_text\";s:34:\"enquiries@atlascapitalsolutions.sg\";s:8:\"h_btn_on\";s:3:\"off\";s:10:\"h_btn_text\";s:12:\"Get in Touch\";s:15:\"h_btn_link_type\";s:4:\"page\";s:10:\"h_btn_link\";s:2:\"94\";s:17:\"h_btn_link_custom\";s:0:\"\";s:12:\"h_btn_target\";s:5:\"_self\";s:9:\"h_btn2_on\";s:3:\"off\";s:11:\"h_btn2_text\";s:0:\"\";s:16:\"h_btn2_link_type\";s:4:\"page\";s:11:\"h_btn2_link\";s:0:\"\";s:18:\"h_btn2_link_custom\";s:0:\"\";s:13:\"h_btn2_target\";s:5:\"_self\";s:17:\"hide_sidebar_icon\";s:3:\"off\";s:21:\"header_sidenav_layout\";s:3:\"332\";s:18:\"show_header_social\";s:3:\"off\";s:9:\"pagetitle\";s:2:\"on\";s:10:\"show_title\";s:2:\"on\";s:15:\"show_breadcrumb\";s:2:\"on\";s:13:\"page_title_bg\";a:2:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:86:\"https://demo.cmssuperheroes.com/themeforest/finanzia/wp-content/uploads/slider-10.webp\";}s:18:\"page_title_overlay\";s:0:\"\";s:13:\"content_width\";s:9:\"container\";s:24:\"search_field_placeholder\";s:0:\"\";s:17:\"archive_author_on\";s:1:\"1\";s:15:\"archive_date_on\";s:1:\"1\";s:21:\"archive_categories_on\";s:1:\"0\";s:19:\"archive_comments_on\";s:1:\"0\";s:14:\"post_author_on\";s:1:\"1\";s:19:\"post_author_info_on\";s:1:\"1\";s:12:\"post_date_on\";s:1:\"1\";s:18:\"post_categories_on\";s:1:\"1\";s:12:\"post_tags_on\";s:1:\"1\";s:16:\"post_comments_on\";s:1:\"1\";s:20:\"post_social_share_on\";s:1:\"1\";s:18:\"post_navigation_on\";s:1:\"1\";s:21:\"post_comments_form_on\";s:1:\"1\";s:10:\"sidebar_on\";s:2:\"on\";s:11:\"sidebar_pos\";s:10:\"order-last\";s:16:\"footer_copyright\";s:0:\"\";s:13:\"footer_layout\";s:3:\"169\";s:12:\"footer_fixed\";s:3:\"off\";s:14:\"title_404_page\";s:0:\"\";s:16:\"content_404_page\";s:0:\"\";s:17:\"btn_text_404_page\";s:0:\"\";s:21:\"product_single_layout\";s:14:\"single-product\";s:15:\"product_gallery\";s:6:\"slider\";s:19:\"product_gallery_nav\";s:2:\"on\";s:13:\"product_share\";s:2:\"on\";s:10:\"hide_popup\";s:3:\"off\";s:13:\"popup_animate\";s:12:\"cms-fadeInUp\";s:14:\"popup_position\";s:15:\"align-items-end\";s:11:\"popup_max_w\";a:2:{s:5:\"width\";s:0:\"\";s:4:\"unit\";s:2:\"px\";}s:10:\"gm_api_key\";s:0:\"\";}", "auto");
INSERT INTO `wp_options` VALUES("679", "newsletter_htmlforms", "a:2:{i:0;b:0;s:6:\"form_1\";s:1536:\"<form method=\"post\" action=\"http://localhost:8888/2024/finanzia/wp-admin/admin-ajax.php?action=tnp&na=s\" class=\"cms-newsletter-sc-2 relative\"><input type=\"hidden\" name=\"nlang\" value=\"\"><div class=\"tnp-field tnp-field-email\"><input class=\"tnp-email\" type=\"email\" name=\"ne\" id=\"tnp-1\" value=\"\" placeholder=\"Your Email Address\" required></div><div class=\"tnp-field tnp-field-button\"><span class=\"absolute top-right mt-10 text-17 box-37 circle bg-accent text-white\" type=\"submit\"><svg viewBox=\"0 0 17 11\" xmlns=\"http://www.w3.org/2000/svg\"> <path d=\"M11.5248 10.309C11.2695 10.0543 11.2695 9.64136 11.5248 9.38667L14.7676 6.15217H0.653846C0.292737 6.15217 -3.15692e-08 5.86019 0 5.5C3.15692e-08 5.13981 0.292737 4.84783 0.653846 4.84783H14.7676L11.5248 1.61333C11.2695 1.35864 11.2695 0.945707 11.5248 0.691017C11.7802 0.436327 12.1942 0.436328 12.4495 0.691018L16.8085 5.03884C17.0638 5.29353 17.0638 5.70647 16.8085 5.96116L12.4495 10.309C12.1942 10.5637 11.7802 10.5637 11.5248 10.309Z\"/> <path d=\"M11.5248 10.309C11.2695 10.0543 11.2695 9.64136 11.5248 9.38667L14.7676 6.15217H0.653846C0.292737 6.15217 -3.15692e-08 5.86019 0 5.5C3.15692e-08 5.13981 0.292737 4.84783 0.653846 4.84783H14.7676L11.5248 1.61333C11.2695 1.35864 11.2695 0.945707 11.5248 0.691017C11.7802 0.436327 12.1942 0.436328 12.4495 0.691018L16.8085 5.03884C17.0638 5.29353 17.0638 5.70647 16.8085 5.96116L12.4495 10.309C12.1942 10.5637 11.7802 10.5637 11.5248 10.309Z\"/></svg></span><input class=\"tnp-submit cms-opacity-0\" type=\"submit\" value=\"Subscribe\"></div></form>\";}", "auto");
INSERT INTO `wp_options` VALUES("680", "woosw_page_id", "615", "auto");
INSERT INTO `wp_options` VALUES("685", "swa_ie_demo_installed", "finanzia", "auto");
INSERT INTO `wp_options` VALUES("686", "_transient_wc_count_comments", "O:8:\"stdClass\":7:{s:14:\"total_comments\";i:3;s:3:\"all\";i:3;s:8:\"approved\";s:1:\"3\";s:9:\"moderated\";i:0;s:4:\"spam\";i:0;s:5:\"trash\";i:0;s:12:\"post-trashed\";i:0;}", "on");
INSERT INTO `wp_options` VALUES("726", "_elementor_local_google_fonts", "a:2:{s:6:\"roboto\";a:2:{s:3:\"url\";s:89:\"https://atlascapt.warelytest.com/wp-content/uploads/elementor/google-fonts/css/roboto.css\";s:7:\"version\";i:1749183458;}s:10:\"robotoslab\";a:2:{s:3:\"url\";s:93:\"https://atlascapt.warelytest.com/wp-content/uploads/elementor/google-fonts/css/robotoslab.css\";s:7:\"version\";i:1749183459;}}", "auto");
INSERT INTO `wp_options` VALUES("727", "_elementor_element_cache_unique_id", "cbb87d86f02cdf537be99c206634b507", "auto");
INSERT INTO `wp_options` VALUES("753", "woocommerce_task_list_tracked_completed_tasks", "a:3:{i:0;s:8:\"products\";i:1;s:17:\"launch-your-store\";i:2;s:15:\"customize-store\";}", "auto");
INSERT INTO `wp_options` VALUES("754", "woocommerce_ces_tracks_queue", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("755", "woocommerce_clear_ces_tracks_queue_for_page", "", "auto");
INSERT INTO `wp_options` VALUES("756", "woocommerce_ces_shown_for_actions", "a:1:{i:0;s:15:\"settings_change\";}", "auto");
INSERT INTO `wp_options` VALUES("826", "rsssl_vulnerability_mail_sent_for", "a:2:{i:0;s:36:\"552cd3e5-96ca-4a76-b22e-7eb65c0d783d\";i:1;s:36:\"d3411927-e153-48b1-a5ca-549c26d1db82\";}", "off");
INSERT INTO `wp_options` VALUES("912", "_transient_health-check-site-status-result", "{\"good\":15,\"recommended\":10,\"critical\":2}", "on");
INSERT INTO `wp_options` VALUES("922", "woocommerce_tracker_last_send", "1763962332", "auto");
INSERT INTO `wp_options` VALUES("1246", "woocommerce_tracker_ua", "a:4:{i:0;s:101:\"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/134.0.0.0 Safari/537.36\";i:1;s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36\";i:2;s:101:\"Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36\";i:3;s:125:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36 Edg/142.0.0.0\";}", "off");
INSERT INTO `wp_options` VALUES("1333", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("1347", "_transient_shipping-transient-version", "1750312272", "on");
INSERT INTO `wp_options` VALUES("1350", "site_logo", "691", "auto");
INSERT INTO `wp_options` VALUES("1351", "woocommerce_admin_customize_store_completed", "yes", "auto");
INSERT INTO `wp_options` VALUES("1352", "woocommerce_maybe_regenerate_images_hash", "e00a7e0a45bad5785e83fef2ae5eeb55", "auto");
INSERT INTO `wp_options` VALUES("1620", "e_editor_counter", "67", "auto");
INSERT INTO `wp_options` VALUES("1621", "_elementor_free_to_pro_upsell", "a:2:{s:7:\"timeout\";i:1762235597;s:5:\"value\";s:723:\"[{\"id\":\"animated_headline\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/animated_headline.jpg\"},{\"id\":\"video_playlist\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/video_playlist.jpg\"},{\"id\":\"cta\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/cta.jpg\"},{\"id\":\"testimonial_widget\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/testimonial_widget.jpg\"},{\"id\":\"image_carousel\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/image_carousel.jpg\"},{\"id\":\"connect-pro-upgrade\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/free-to-pro-upsell\\/v1\\/images\\/connect-pro-upgrade.jpg\"}]\";}", "off");
INSERT INTO `wp_options` VALUES("1622", "_elementor_notifications_data", "a:2:{s:7:\"timeout\";i:1762235598;s:5:\"value\";s:15038:\"[{\"id\":\"transform-3.32\",\"title\":\"Design with depth using Transform\",\"description\":\"Move, scale, rotate, and skew any element with ease. Transform controls add depth, stacked effects, and seamless States for hover, focus, and active micro-interactions.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-transform.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"size-variable-3.32\",\"title\":\"Consistency with Size Variables\",\"description\":\"Define reusable values for properties like spacing or typography, then update them once to scale changes instantly across your site.\",\"topic\":\"Elementor Pro 3.32\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-size-variables.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"size-variable-3.32\",\"title\":\"Consistency with Size Variables\",\"description\":\"Define reusable values for properties like spacing or typography, then update them once to scale changes instantly across your site.\",\"topic\":\"Elementor Pro 3.32\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-size-variables.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-size-variable\\/\"},{\"id\":\"transitions-3.32\",\"title\":\"Smooth interactions with Transitions\",\"description\":\"Bring polish to every interaction. Transitions let you animate style changes smoothly between states. In Pro, layer multiple transitions by property for refined, modern micro-animations.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-transition.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"variables-3.31\",\"title\":\"Scalable design with Variables\",\"description\":\"Define once, reuse everywhere. Color & Font Variables help you build consistent, scalable design systems that update globally and are perfect for large sites or teams.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-variables.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"filters-3.31\",\"title\":\"Visual effects with Filters and Backdrop Filters\",\"description\":\"Apply multiple Filters like blur, brightness, and contrast. Stack, reorder, and preview in real time without writing a line of code.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-filters.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"ally-assistant\",\"title\":\"New! Fix accessibility issues with Ally Assistant\",\"description\":\"Scan any page for accessibility issues and fix them in one click. From color contrast to missing alt text, Ally Assistant provides guided steps or AI-powered fixes to make your site more inclusive.\",\"topic\":\"Ally by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/ally-assistant.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Scan for free\",\"ctaLink\":\"http:\\/\\/go.elementor.com\\/acc-assistant-launch-whats-new\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"pojo-accessibility\\/pojo-accessibility.php\"}]]},{\"id\":\"classes-3.31\",\"title\":\"Smarter Class Manager tools\",\"description\":\"Quickly locate and manage Global Classes with usage counts, a new locator panel, and full class search. Perfect for scaling and refactoring complex design systems.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-classes.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"send-notification-august\",\"title\":\"All Your Assets, One Library\",\"description\":\"Save time and skip the re-uploads - now you can pull images straight from your WordPress Media Library into Send. Faster, simpler, and built for WordPress.\",\"topic\":\"Send: Email & SMS built for WooCommerce\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/aug_send.png\",\"chipTags\":[\"Cart abandonment\"],\"cta\":\"Upload Your Assets\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/ML_WN\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"send-app\\/send-app.php\"}]]},{\"id\":\"attributes-3.31\",\"title\":\"Add semantic HTML with Attributes\",\"description\":\"Add custom HTML attributes like aria-*, data-*, and role to any element. Structure your markup for better accessibility, performance, and compliance.\",\"topic\":\"Elementor Pro 3.31\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-attributes.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"attributes-3.31\",\"title\":\"Add semantic HTML with Attributes\",\"description\":\"Add custom HTML attributes like aria-*, data-*, and role to any element. Structure your markup for better accessibility, performance, and compliance.\",\"topic\":\"Elementor Pro 3.31\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-attributes.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-attributes\\/\"},{\"id\":\"classes-3.30\",\"title\":\"Better class control\",\"description\":\"Get popovers with your class name, breakpoint, state and possible conflicts. Plus, the exact class names you define are now reflected in the code, making debugging and working with external tools easier!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/classes-3.30.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"cloud-websites-3.30\",\"title\":\"Full Website Templates in the cloud\",\"description\":\"Save and apply entire websites, including multiple pages, styles, site settings, media, and layout configurations - directly from the cloud.\",\"topic\":\"Elementor Pro 3.30\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-3.30.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"cloud-websites-3.30\",\"title\":\"Full Website Templates in the cloud\",\"description\":\"Save and apply entire websites, including multiple pages, styles, site settings, media, and layout configurations - directly from the cloud.\",\"topic\":\"Elementor Pro 3.30\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-3.30.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.30-cloud-websites\\/\"},{\"id\":\"youtube-3.30\",\"title\":\"YouTube Element\",\"description\":\"The new YouTube Element is purpose-built to support V4 capabilities with faster rendering, better performance, and familiar controls like autoplay, loop, mute, and aspect ratio.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/youtube-3.30.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"host-google-cloud\",\"title\":\"Deliver fast, secure websites at scale - free migration included!\",\"description\":\"Host your site on Elementor\\u2019s infrastructure - built for speed, security, and scale. Powered by Google Cloud, with free migration and 24\\/7 expert support.\",\"topic\":\"Host\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/host-google-cloud.png\",\"chipTags\":[\"Cloud Hosting\"],\"link\":\"https:\\/\\/go.elementor.com\\/elementor-host-google-cloud\",\"readMoreText\":\"Read More\"},{\"id\":\"cloud-templates-3.29\",\"title\":\"Your Templates, available everywhere\",\"description\":\"Store sections, containers, and full pages in the cloud\\u2014making them accessible across all your Pro-connected sites. Style once, reuse anywhere!\",\"topic\":\"Elementor Pro 3.29\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-templates.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-cloud-templates-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"cloud-templates-3.29\",\"title\":\"Your Templates, available everywhere\",\"description\":\"Store sections, containers, and full pages in the cloud\\u2014making them accessible across all your Pro-connected sites. Style once, reuse anywhere!\",\"topic\":\"Elementor Pro 3.29\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-templates.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-cloud-templates\\/\"},{\"id\":\"migration-host\",\"title\":\"Move to Better Cloud Hosting, Painlessly\",\"description\":\"Migrate your Elementor website for free to a home that\\u2019s perfect for it, in minutes, with a combination of\\u2028advanced automation and free expert support\",\"topic\":\"Host\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/migration-host.png\",\"chipTags\":[\"Cloud Hosting\"],\"link\":\"https:\\/\\/go.elementor.com\\/hosting-free-migration\",\"readMoreText\":\"Learn More\",\"cta\":\"Migrate for free\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/hosting-free-migration\"},{\"id\":\"ai-isolate-object\",\"title\":\"Sharper product images, instantly\",\"description\":\"Remove distractions and reframe your shots with the new Isolate Object tool powered by Elementor AI \\u2014 perfect for a polished, uniform Woo storefront.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/isolate-object-ai.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"introduction_meta\",\"meta\":\"ai_get_started\"}]],\"cta\":\"Start Free Trial\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\"},{\"id\":\"ai-isolate-object\",\"title\":\"Sharper product images, instantly\",\"description\":\"Remove distractions and reframe your shots with the new Isolate Object tool powered by Elementor AI \\u2014 perfect for a polished, uniform Woo storefront.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/isolate-object-ai.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Start Free Trial\",\"link\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\",\"readMoreText\":\"Learn More\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\"},{\"id\":\"hello-biz-contact\",\"title\":\"New Contact Widget, Visual Layout Presets & more\",\"description\":\"Hello Biz just got an update! Explore the new Contact Widget, Visual Layout Presets, Form Submissions integration, and fresh new kits.\",\"topic\":\"Hello Biz\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/hello-biz-contact.png\",\"chipTags\":[\"New Features\"],\"link\":\"https:\\/\\/go.elementor.com\\/hello-biz-updates\",\"readMoreText\":\"Learn More\"},{\"id\":\"ai-site-planner-colors\",\"title\":\"Style Your Wireframe, Speed Up Your Store Build\",\"description\":\"Site Planner now lets you style your wireframe with fonts and colors - instantly visualizing your site\\u2019s look and feel. Plus, it predesigns pages for WooCommerce like Cart and Checkout, so you can dive straight into customizations\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/site-planner-colors.png\",\"chipTags\":[\"New Feature\"],\"link\":\"http:\\/\\/www.elementor.com\\/ai-site-planner\",\"readMoreText\":\"Learn More\"},{\"id\":\"ally-notification\",\"title\":\"Just released! Ally - a new plugin for web accessibility & usability\",\"description\":\"Ally simplifies the complexities of making your website more accessible. With new regulations here and coming, making your website more usable and inclusive is no longer just an option, but a must.\",\"topic\":\"Ally by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/ally-notification.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Get it free\",\"ctaLink\":\"https:\\/\\/wordpress.org\\/plugins\\/pojo-accessibility\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"pojo-accessibility\\/pojo-accessibility.php\"}]]},{\"id\":\"ai-site-planner\",\"title\":\"Instant Sitemaps & Wireframes\",\"description\":\"Get your website plan in minutes with AI Site Planner. Describe your desired site and AI will generate a sitemap, brief and wireframe populated with initial content, ready for you to customize.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/aI-site-planner.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/ai-notification-site-planner\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"image-optimizer-3.19\",\"title\":\"Effortlessly optimize images for a stunning, high-speed website with the Image Optimizer plugin.\",\"description\":\"Image Optimizer perfectly balances between image quality and performance to boost your website.  Resize, compress, and convert images to WebP, for faster loading times and and better user experience.\",\"topic\":\"Image Optimizer Plugin by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/image-optimizer-3.19.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Get the Image Optimizer\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/io-notification-wp-dash-learn-more\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"image-optimization\\/image-optimization.php\"}]]},{\"id\":\"5-star-rating-prompt\",\"title\":\"Love the New Features? Let Us Know with 5 Stars!\",\"description\":\"Help spread the word by telling the world what you love about Elementor.\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/5-star-rating-prompt.png\",\"cta\":\"Leave a Review\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/wp-dash-notification-five-stars\\/\"},{\"id\":\"site-mailer-introducing\",\"title\":\"Introducing Site Mailer\",\"description\":\"Keep your WordPress emails out of the spam folder with improved deliverability and an easy setup\\u2014no need for an SMTP plugin or complicated configurations.\",\"topic\":\"Site Mailer Plugin by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/Site-mailer.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Start Free Trial\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/sm-wp-dash-whatsnew\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"site-mailer\\/site-mailer.php\"}]]}]\";}", "off");
INSERT INTO `wp_options` VALUES("1926", "woocommerce_task_list_reminder_bar_hidden", "yes", "auto");
INSERT INTO `wp_options` VALUES("2126", "_transient_timeout_woocommerce_marketplace_promotions_v2", "1764394041", "off");
INSERT INTO `wp_options` VALUES("2127", "_transient_woocommerce_marketplace_promotions_v2", "a:2:{s:6:\"notice\";a:8:{s:13:\"date_from_gmt\";s:16:\"2024-11-17 00:00\";s:11:\"date_to_gmt\";s:16:\"2024-11-20 23:59\";s:6:\"format\";s:6:\"notice\";s:5:\"style\";s:4:\"info\";s:5:\"pages\";a:5:{i:0;a:4:{s:4:\"page\";s:8:\"wc-admin\";s:4:\"path\";s:11:\"/extensions\";s:3:\"tab\";s:0:\"\";s:4:\"name\";s:8:\"Discover\";}i:1;a:4:{s:4:\"page\";s:8:\"wc-admin\";s:4:\"path\";s:11:\"/extensions\";s:3:\"tab\";s:10:\"extensions\";s:4:\"name\";s:6:\"Browse\";}i:2;a:4:{s:4:\"page\";s:8:\"wc-admin\";s:4:\"path\";s:11:\"/extensions\";s:3:\"tab\";s:6:\"themes\";s:4:\"name\";s:6:\"Themes\";}i:3;a:4:{s:4:\"page\";s:8:\"wc-admin\";s:4:\"path\";s:11:\"/extensions\";s:3:\"tab\";s:17:\"business-services\";s:4:\"name\";s:17:\"Business Services\";}i:4;a:4:{s:4:\"page\";s:8:\"wc-admin\";s:4:\"path\";s:11:\"/extensions\";s:3:\"tab\";s:16:\"my-subscriptions\";s:4:\"name\";s:16:\"My Subscriptions\";}}s:7:\"content\";a:1:{s:5:\"en_US\";s:192:\"<strong>Save 40%</strong> in the WooCommerce Marketplace sale. Offer ends December 3 at 3 pm UTC. <a href=\"https://woocommerce.com/products/#sale-ts-and-cs\" target=\"_blank\">T&amp;Cs</a> apply.\";}s:4:\"icon\";s:7:\"percent\";s:14:\"is_dismissible\";b:1;}s:6:\"promos\";a:8:{i:0;a:9:{s:13:\"date_from_gmt\";s:16:\"2025-11-19 14:15\";s:11:\"date_to_gmt\";s:16:\"2025-11-26 13:30\";s:6:\"format\";s:10:\"promo-card\";s:5:\"pages\";a:1:{i:0;a:2:{s:4:\"path\";s:0:\"\";s:8:\"pathname\";s:33:\"/wp-admin/admin.php?page=wc-admin\";}}s:9:\"cta_label\";a:1:{s:5:\"en_US\";s:13:\"Shop the sale\";}s:8:\"cta_link\";s:67:\"/wp-admin/admin.php?page=wc-admin&tab=extensions&path=%2Fextensions\";s:7:\"content\";a:1:{s:5:\"en_US\";s:175:\"Save up to 40% in the WooCommerce Marketplace sale. Ends December 2 at 14:00 UTC. <a href=\"https://woocommerce.com/products/#sale-ts-and-cs\" target=\"_blank\">T&C</a>’s apply.\";}s:5:\"title\";a:1:{s:5:\"en_US\";s:37:\"Upgrade your store with up to 40% off\";}s:4:\"icon\";s:7:\"percent\";}i:1;a:9:{s:13:\"date_from_gmt\";s:16:\"2025-11-19 14:15\";s:11:\"date_to_gmt\";s:16:\"2025-11-26 13:30\";s:6:\"format\";s:10:\"promo-card\";s:5:\"pages\";a:1:{i:0;a:2:{s:4:\"page\";s:8:\"wc-admin\";s:4:\"path\";s:10:\"/marketing\";}}s:9:\"cta_label\";a:1:{s:5:\"en_US\";s:23:\"Level up your marketing\";}s:8:\"cta_link\";s:97:\"/wp-admin/admin.php?page=wc-admin&tab=extensions&path=%2Fextensions&category=marketing-extensions\";s:7:\"content\";a:1:{s:5:\"en_US\";s:196:\"Take up to 40% off WooCommerce Marketplace products — now until December 2 at 14:00 UTC. T&Cs apply. <a href=\"https://woocommerce.com/products/#sale-ts-and-cs\" target=\"_blank\">T&C</a>’s apply.\";}s:5:\"title\";a:1:{s:5:\"en_US\";s:33:\"Save up to 40% on marketing tools\";}s:4:\"icon\";s:7:\"percent\";}i:2;a:10:{s:13:\"date_from_gmt\";s:16:\"2025-11-19 14:15\";s:11:\"date_to_gmt\";s:16:\"2025-11-26 13:30\";s:6:\"format\";s:10:\"promo-card\";s:5:\"pages\";a:1:{i:0;a:2:{s:4:\"path\";s:0:\"\";s:8:\"pathname\";s:40:\"/wp-admin/edit.php?post_type=shop_coupon\";}}s:9:\"cta_label\";a:1:{s:5:\"en_US\";s:19:\"Upgrade your promos\";}s:8:\"cta_link\";s:80:\"/wp-admin/admin.php?page=wc-admin&path=%2Fextensions&tab=extensions&term=Coupons\";s:7:\"content\";a:1:{s:5:\"en_US\";s:181:\"Save up to 40% in the WooCommerce Marketplace sale. Offer ends December 2 at 14:00 UTC. <a href=\"https://woocommerce.com/products/#sale-ts-and-cs\" target=\"_blank\">T&C</a>’s apply.\";}s:5:\"title\";a:1:{s:5:\"en_US\";s:46:\"Take up to 40% off coupon and promo extensions\";}s:5:\"style\";s:4:\"wide\";s:4:\"icon\";s:7:\"percent\";}i:3;a:10:{s:13:\"date_from_gmt\";s:16:\"2025-11-19 14:15\";s:11:\"date_to_gmt\";s:16:\"2025-11-26 13:30\";s:6:\"format\";s:10:\"promo-card\";s:5:\"pages\";a:1:{i:0;a:2:{s:4:\"page\";s:8:\"wc-admin\";s:4:\"path\";s:11:\"/extensions\";}}s:9:\"cta_label\";a:1:{s:5:\"en_US\";s:13:\"Shop the sale\";}s:8:\"cta_link\";s:67:\"/wp-admin/admin.php?page=wc-admin&tab=extensions&path=%2Fextensions\";s:7:\"content\";a:1:{s:5:\"en_US\";s:198:\"For a limited time, save up to 40% in the WooCommerce Marketplace sale. Offer ends December 2 at 14:00 UTC. <a href=\"https://woocommerce.com/products/#sale-ts-and-cs\" target=\"_blank\">T&Cs</a> apply.\";}s:5:\"title\";a:1:{s:5:\"en_US\";s:37:\"Upgrade your store with up to 40% off\";}s:5:\"style\";s:14:\"has-background\";s:4:\"icon\";s:7:\"percent\";}i:4;a:9:{s:13:\"date_from_gmt\";s:16:\"2025-11-26 14:15\";s:11:\"date_to_gmt\";s:16:\"2025-12-02 13:59\";s:6:\"format\";s:10:\"promo-card\";s:5:\"pages\";a:1:{i:0;a:2:{s:4:\"path\";s:0:\"\";s:8:\"pathname\";s:33:\"/wp-admin/admin.php?page=wc-admin\";}}s:9:\"cta_label\";a:1:{s:5:\"en_US\";s:13:\"Shop the sale\";}s:8:\"cta_link\";s:67:\"/wp-admin/admin.php?page=wc-admin&tab=extensions&path=%2Fextensions\";s:7:\"content\";a:1:{s:5:\"en_US\";s:195:\"Save up to 40% on themes and extensions in the WooCommerce Marketplace until December 2 at 14:00 UTC. <a href=\"https://woocommerce.com/products/#sale-ts-and-cs\" target=\"_blank\">T&C</a>’s apply.\";}s:5:\"title\";a:1:{s:5:\"en_US\";s:29:\"Black Friday savings are live\";}s:4:\"icon\";s:7:\"percent\";}i:5;a:9:{s:13:\"date_from_gmt\";s:16:\"2025-11-26 14:15\";s:11:\"date_to_gmt\";s:16:\"2025-12-02 13:59\";s:6:\"format\";s:10:\"promo-card\";s:5:\"pages\";a:1:{i:0;a:2:{s:4:\"page\";s:8:\"wc-admin\";s:4:\"path\";s:10:\"/marketing\";}}s:9:\"cta_label\";a:1:{s:5:\"en_US\";s:23:\"Level up your marketing\";}s:8:\"cta_link\";s:97:\"/wp-admin/admin.php?page=wc-admin&tab=extensions&path=%2Fextensions&category=marketing-extensions\";s:7:\"content\";a:1:{s:5:\"en_US\";s:178:\"Save up to 40% in the Woo BFCM sale. Offer ends December 2 at 14:00 UTC. T&Cs apply. <a href=\"https://woocommerce.com/products/#sale-ts-and-cs\" target=\"_blank\">T&C</a>’s apply.\";}s:5:\"title\";a:1:{s:5:\"en_US\";s:43:\"Take up to 40% off marketing tools and more\";}s:4:\"icon\";s:7:\"percent\";}i:6;a:10:{s:13:\"date_from_gmt\";s:16:\"2025-11-26 14:15\";s:11:\"date_to_gmt\";s:16:\"2025-12-02 13:59\";s:6:\"format\";s:10:\"promo-card\";s:5:\"pages\";a:1:{i:0;a:2:{s:4:\"path\";s:0:\"\";s:8:\"pathname\";s:40:\"/wp-admin/edit.php?post_type=shop_coupon\";}}s:9:\"cta_label\";a:1:{s:5:\"en_US\";s:19:\"Upgrade your promos\";}s:8:\"cta_link\";s:80:\"/wp-admin/admin.php?page=wc-admin&path=%2Fextensions&tab=extensions&term=Coupons\";s:7:\"content\";a:1:{s:5:\"en_US\";s:166:\"Save up to 40% in the Woo BFCM sale. Offer ends December 2 at 14:00 UTC. <a href=\"https://woocommerce.com/products/#sale-ts-and-cs\" target=\"_blank\">T&C</a>’s apply.\";}s:5:\"title\";a:1:{s:5:\"en_US\";s:46:\"Take up to 40% off coupon and promo extensions\";}s:5:\"style\";s:4:\"wide\";s:4:\"icon\";s:7:\"percent\";}i:7;a:10:{s:13:\"date_from_gmt\";s:16:\"2025-11-26 14:15\";s:11:\"date_to_gmt\";s:16:\"2025-12-02 13:59\";s:6:\"format\";s:10:\"promo-card\";s:5:\"pages\";a:1:{i:0;a:2:{s:4:\"page\";s:8:\"wc-admin\";s:4:\"path\";s:11:\"/extensions\";}}s:9:\"cta_label\";a:1:{s:5:\"en_US\";s:13:\"Shop the sale\";}s:8:\"cta_link\";s:67:\"/wp-admin/admin.php?page=wc-admin&tab=extensions&path=%2Fextensions\";s:7:\"content\";a:1:{s:5:\"en_US\";s:188:\"Take up to 40% off WooCommerce Marketplace products this BFCM. Sale ends December 2 at 14:00 UTC. <a href=\"https://woocommerce.com/products/#sale-ts-and-cs\" target=\"_blank\">T&Cs</a> apply.\";}s:5:\"title\";a:1:{s:5:\"en_US\";s:39:\"Save up to 40% on your next big upgrade\";}s:5:\"style\";s:14:\"has-background\";s:4:\"icon\";s:7:\"percent\";}}}", "off");
INSERT INTO `wp_options` VALUES("2137", "db_upgraded", "", "on");
INSERT INTO `wp_options` VALUES("2141", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:21:\"selvam@warelycorp.com\";s:7:\"version\";s:5:\"6.8.2\";s:9:\"timestamp\";i:1752600482;}", "off");
INSERT INTO `wp_options` VALUES("2212", "_transient_timeout_woocommerce_admin_payment_gateway_suggestions_specs", "1764912443", "off");
INSERT INTO `wp_options` VALUES("2213", "_transient_woocommerce_admin_payment_gateway_suggestions_specs", "a:1:{s:5:\"en_US\";a:24:{s:6:\"affirm\";O:8:\"stdClass\":11:{s:2:\"id\";s:6:\"affirm\";s:5:\"title\";s:6:\"Affirm\";s:7:\"content\";s:169:\"Affirm’s tailored Buy Now Pay Later programs remove price as a barrier, turning browsers into buyers, increasing average order value, and expanding your customer base.\";s:5:\"image\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/affirm.png\";s:11:\"image_72x72\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/affirm.png\";s:7:\"plugins\";a:0:{}s:13:\"external_link\";s:59:\"https://woocommerce.com/products/woocommerce-gateway-affirm\";s:10:\"is_visible\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:9:\"6.5.0-dev\";s:8:\"operator\";s:2:\">=\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:9:\"9.2.0-dev\";s:8:\"operator\";s:1:\"<\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}}i:2;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:4:\"data\";}}i:1;O:8:\"stdClass\":1:{s:3:\"use\";s:10:\"array_keys\";}}s:11:\"option_name\";s:18:\"wcpay_account_data\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:10:\"account_id\";s:7:\"default\";a:0:{}}}}}s:14:\"category_other\";a:0:{}s:19:\"category_additional\";a:2:{i:0;s:2:\"US\";i:1;s:2:\"CA\";}s:23:\"recommendation_priority\";i:6;}s:8:\"afterpay\";O:8:\"stdClass\":10:{s:2:\"id\";s:8:\"afterpay\";s:5:\"title\";s:8:\"Afterpay\";s:7:\"content\";s:125:\"Afterpay allows customers to receive products immediately and pay for purchases over four installments, always interest-free.\";s:5:\"image\";s:110:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/afterpay.png\";s:11:\"image_72x72\";s:110:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/afterpay.png\";s:7:\"plugins\";a:1:{i:0;s:32:\"afterpay-gateway-for-woocommerce\";}s:10:\"is_visible\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:9:\"6.5.0-dev\";s:8:\"operator\";s:2:\">=\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:9:\"9.2.0-dev\";s:8:\"operator\";s:1:\"<\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}}i:2;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:4:\"data\";}}i:1;O:8:\"stdClass\":1:{s:3:\"use\";s:10:\"array_keys\";}}s:11:\"option_name\";s:18:\"wcpay_account_data\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:10:\"account_id\";s:7:\"default\";a:0:{}}}}}s:14:\"category_other\";a:0:{}s:19:\"category_additional\";a:3:{i:0;s:2:\"US\";i:1;s:2:\"CA\";i:2;s:2:\"AU\";}s:23:\"recommendation_priority\";i:6;}s:14:\"airwallex_main\";O:8:\"stdClass\":11:{s:2:\"id\";s:14:\"airwallex_main\";s:5:\"title\";s:18:\"Airwallex Payments\";s:7:\"content\";s:115:\"Boost international sales and save on FX fees. Accept 60+ local payment methods including Apple Pay and Google Pay.\";s:5:\"image\";s:105:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/airwallex.png\";s:11:\"image_72x72\";s:111:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/airwallex.png\";s:12:\"square_image\";s:112:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/airwallex-square.png\";s:7:\"plugins\";a:1:{i:0;s:33:\"airwallex-online-payments-gateway\";}s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:17:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EE\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CN\";s:9:\"operation\";s:1:\"=\";}}}}s:14:\"category_other\";a:17:{i:0;s:2:\"GB\";i:1;s:2:\"AT\";i:2;s:2:\"BE\";i:3;s:2:\"EE\";i:4;s:2:\"FR\";i:5;s:2:\"DE\";i:6;s:2:\"GR\";i:7;s:2:\"IE\";i:8;s:2:\"IT\";i:9;s:2:\"NL\";i:10;s:2:\"PL\";i:11;s:2:\"PT\";i:12;s:2:\"AU\";i:13;s:2:\"NZ\";i:14;s:2:\"HK\";i:15;s:2:\"SG\";i:16;s:2:\"CN\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:4;}s:24:\"amazon_payments_advanced\";O:8:\"stdClass\":10:{s:2:\"id\";s:24:\"amazon_payments_advanced\";s:5:\"title\";s:10:\"Amazon Pay\";s:7:\"content\";s:94:\"Enable a familiar, fast checkout for hundreds of millions of active Amazon customers globally.\";s:5:\"image\";s:111:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/amazonpay.png\";s:11:\"image_72x72\";s:111:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/amazonpay.png\";s:7:\"plugins\";a:1:{i:0;s:44:\"woocommerce-gateway-amazon-payments-advanced\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:18:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CY\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LU\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SL\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:9:\"6.5.0-dev\";s:8:\"operator\";s:2:\">=\";}}s:14:\"category_other\";a:0:{}s:19:\"category_additional\";a:18:{i:0;s:2:\"US\";i:1;s:2:\"AT\";i:2;s:2:\"BE\";i:3;s:2:\"CY\";i:4;s:2:\"DK\";i:5;s:2:\"ES\";i:6;s:2:\"FR\";i:7;s:2:\"DE\";i:8;s:2:\"GB\";i:9;s:2:\"HU\";i:10;s:2:\"IE\";i:11;s:2:\"IT\";i:12;s:2:\"LU\";i:13;s:2:\"NL\";i:14;s:2:\"PT\";i:15;s:2:\"SL\";i:16;s:2:\"SE\";i:17;s:2:\"JP\";}s:23:\"recommendation_priority\";i:6;}s:4:\"bacs\";O:8:\"stdClass\":8:{s:2:\"id\";s:4:\"bacs\";s:5:\"title\";s:20:\"Direct bank transfer\";s:7:\"content\";s:32:\"Take payments via bank transfer.\";s:5:\"image\";s:100:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/bacs.svg\";s:11:\"image_72x72\";s:106:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/bacs.png\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":1:{s:4:\"type\";s:4:\"pass\";}}s:10:\"is_offline\";b:1;s:23:\"recommendation_priority\";i:6;}s:3:\"cod\";O:8:\"stdClass\":8:{s:2:\"id\";s:3:\"cod\";s:5:\"title\";s:16:\"Cash on delivery\";s:7:\"content\";s:36:\"Take payments in cash upon delivery.\";s:5:\"image\";s:99:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/cod.svg\";s:11:\"image_72x72\";s:105:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/cod.png\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":1:{s:4:\"type\";s:4:\"pass\";}}s:10:\"is_offline\";b:1;s:23:\"recommendation_priority\";i:6;}s:4:\"eway\";O:8:\"stdClass\":11:{s:2:\"id\";s:4:\"eway\";s:5:\"title\";s:4:\"Eway\";s:7:\"content\";s:171:\"The Eway extension for WooCommerce allows you to take credit card payments directly on your store without redirecting your customers to a third party site to make payment.\";s:5:\"image\";s:100:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/eway.png\";s:11:\"image_72x72\";s:106:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/eway.png\";s:12:\"square_image\";s:107:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/eway-square.png\";s:7:\"plugins\";a:1:{i:0;s:24:\"woocommerce-gateway-eway\";}s:10:\"is_visible\";b:0;s:14:\"category_other\";a:0:{}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:6;}s:3:\"kco\";O:8:\"stdClass\":10:{s:2:\"id\";s:3:\"kco\";s:5:\"title\";s:15:\"Klarna Checkout\";s:7:\"content\";s:115:\"Choose the payment that you want, pay now, pay later or slice it. No credit card numbers, no passwords, no worries.\";s:5:\"image\";s:85:\"https://woocommerce.com/wp-content/plugins/woocommerce/assets/images/klarna-black.png\";s:11:\"image_72x72\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/klarna.png\";s:7:\"plugins\";a:1:{i:0;s:31:\"klarna-checkout-for-woocommerce\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"category_other\";a:3:{i:0;s:2:\"NO\";i:1;s:2:\"SE\";i:2;s:2:\"FI\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:6;}s:15:\"klarna_payments\";O:8:\"stdClass\":10:{s:2:\"id\";s:15:\"klarna_payments\";s:5:\"title\";s:15:\"Klarna Payments\";s:7:\"content\";s:115:\"Choose the payment that you want, pay now, pay later or slice it. No credit card numbers, no passwords, no worries.\";s:5:\"image\";s:85:\"https://woocommerce.com/wp-content/plugins/woocommerce/assets/images/klarna-black.png\";s:11:\"image_72x72\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/klarna.png\";s:7:\"plugins\";a:1:{i:0;s:31:\"klarna-payments-for-woocommerce\";}s:10:\"is_visible\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:19:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MX\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:4:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:9:\"9.2.0-dev\";s:8:\"operator\";s:1:\"<\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:39:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PR\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CY\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EE\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LU\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LT\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LV\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MT\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SI\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SK\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BG\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CZ\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HR\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RO\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AE\";s:9:\"operation\";s:1:\"=\";}}}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}}i:3;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:4:\"data\";}}i:1;O:8:\"stdClass\":1:{s:3:\"use\";s:10:\"array_keys\";}}s:11:\"option_name\";s:18:\"wcpay_account_data\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:10:\"account_id\";s:7:\"default\";a:0:{}}}}}s:14:\"category_other\";a:0:{}s:19:\"category_additional\";a:19:{i:0;s:2:\"MX\";i:1;s:2:\"US\";i:2;s:2:\"CA\";i:3;s:2:\"AT\";i:4;s:2:\"BE\";i:5;s:2:\"CH\";i:6;s:2:\"DK\";i:7;s:2:\"ES\";i:8;s:2:\"FI\";i:9;s:2:\"FR\";i:10;s:2:\"DE\";i:11;s:2:\"GB\";i:12;s:2:\"IT\";i:13;s:2:\"NL\";i:14;s:2:\"NO\";i:15;s:2:\"PL\";i:16;s:2:\"SE\";i:17;s:2:\"NZ\";i:18;s:2:\"AU\";}s:23:\"recommendation_priority\";i:6;}s:30:\"mollie_wc_gateway_banktransfer\";O:8:\"stdClass\":11:{s:2:\"id\";s:30:\"mollie_wc_gateway_banktransfer\";s:5:\"title\";s:6:\"Mollie\";s:7:\"content\";s:128:\"Effortless payments by Mollie: Offer global and local payment methods, get onboarded in minutes, and supported in your language.\";s:5:\"image\";s:102:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/mollie.svg\";s:11:\"image_72x72\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/mollie.png\";s:12:\"square_image\";s:109:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/mollie-square.png\";s:7:\"plugins\";a:1:{i:0;s:31:\"mollie-payments-for-woocommerce\";}s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:11:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}}}}s:14:\"category_other\";a:11:{i:0;s:2:\"AT\";i:1;s:2:\"BE\";i:2;s:2:\"CH\";i:3;s:2:\"ES\";i:4;s:2:\"FI\";i:5;s:2:\"FR\";i:6;s:2:\"DE\";i:7;s:2:\"GB\";i:8;s:2:\"IT\";i:9;s:2:\"NL\";i:10;s:2:\"PL\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:6;}s:7:\"payfast\";O:8:\"stdClass\":10:{s:2:\"id\";s:7:\"payfast\";s:5:\"title\";s:7:\"Payfast\";s:7:\"content\";s:299:\"The Payfast extension for WooCommerce enables you to accept payments by Credit Card and EFT via one of South Africa’s most popular payment gateways. No setup fees or monthly subscription costs. Selecting this extension will configure your store to use South African rands as the selected currency.\";s:5:\"image\";s:80:\"https://woocommerce.com/wp-content/plugins/woocommerce/assets/images/payfast.png\";s:11:\"image_72x72\";s:109:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/payfast.png\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-payfast-gateway\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ZA\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"category_other\";a:1:{i:0;s:2:\"ZA\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:6;}s:17:\"payoneer-checkout\";O:8:\"stdClass\":10:{s:2:\"id\";s:17:\"payoneer-checkout\";s:5:\"title\";s:17:\"Payoneer Checkout\";s:7:\"content\";s:202:\"Payoneer Checkout is the next generation of payment processing platforms, giving merchants around the world the solutions and direction they need to succeed in today’s hyper-competitive global market.\";s:5:\"image\";s:104:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/payoneer.png\";s:11:\"image_72x72\";s:110:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/payoneer.png\";s:7:\"plugins\";a:1:{i:0;s:17:\"payoneer-checkout\";}s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CN\";s:9:\"operation\";s:1:\"=\";}}}}s:14:\"category_other\";a:0:{}s:19:\"category_additional\";a:2:{i:0;s:2:\"HK\";i:1;s:2:\"CN\";}s:23:\"recommendation_priority\";i:6;}s:8:\"paystack\";O:8:\"stdClass\":11:{s:2:\"id\";s:8:\"paystack\";s:5:\"title\";s:8:\"Paystack\";s:7:\"content\";s:127:\"Paystack helps African merchants accept one-time and recurring payments online with a modern, safe, and secure payment gateway.\";s:5:\"image\";s:104:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/paystack.png\";s:12:\"square_image\";s:111:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/paystack-square.png\";s:11:\"image_72x72\";s:110:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/paystack.png\";s:7:\"plugins\";a:1:{i:0;s:12:\"woo-paystack\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ZA\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GH\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NG\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"category_other\";a:3:{i:0;s:2:\"ZA\";i:1;s:2:\"GH\";i:2;s:2:\"NG\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:6;}s:7:\"payubiz\";O:8:\"stdClass\":10:{s:2:\"id\";s:7:\"payubiz\";s:5:\"title\";s:20:\"PayU for WooCommerce\";s:7:\"content\";s:169:\"Enable PayU’s exclusive plugin for WooCommerce to start accepting payments in 100+ payment methods available in India including credit cards, debit cards, UPI, & more!\";s:5:\"image\";s:100:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/payu.svg\";s:11:\"image_72x72\";s:106:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/payu.png\";s:7:\"plugins\";a:1:{i:0;s:10:\"payu-india\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IN\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"category_other\";a:1:{i:0;s:2:\"IN\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:6;}s:12:\"ppcp-gateway\";O:8:\"stdClass\":11:{s:2:\"id\";s:12:\"ppcp-gateway\";s:5:\"title\";s:15:\"PayPal Payments\";s:7:\"content\";s:78:\"Safe and secure payments using credit cards or your customer\'s PayPal account.\";s:5:\"image\";s:79:\"https://woocommerce.com/wp-content/plugins/woocommerce/assets/images/paypal.png\";s:11:\"image_72x72\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/paypal.png\";s:12:\"square_image\";s:102:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/paypal.svg\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-paypal-payments\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:49:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MX\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BR\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AR\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CL\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CO\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EC\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PE\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"UY\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"VE\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BG\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HR\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CY\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CZ\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EE\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LV\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LT\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LU\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MT\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RO\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SK\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SL\";s:9:\"operation\";s:1:\"=\";}i:40;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:41;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:42;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:43;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:44;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}i:45;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:46;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CN\";s:9:\"operation\";s:1:\"=\";}i:47;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ID\";s:9:\"operation\";s:1:\"=\";}i:48;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IN\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"category_other\";a:48:{i:0;s:2:\"US\";i:1;s:2:\"CA\";i:2;s:2:\"MX\";i:3;s:2:\"BR\";i:4;s:2:\"AR\";i:5;s:2:\"CL\";i:6;s:2:\"CO\";i:7;s:2:\"EC\";i:8;s:2:\"PE\";i:9;s:2:\"UY\";i:10;s:2:\"VE\";i:11;s:2:\"AT\";i:12;s:2:\"BE\";i:13;s:2:\"BG\";i:14;s:2:\"HR\";i:15;s:2:\"CH\";i:16;s:2:\"CY\";i:17;s:2:\"CZ\";i:18;s:2:\"DK\";i:19;s:2:\"EE\";i:20;s:2:\"ES\";i:21;s:2:\"FI\";i:22;s:2:\"FR\";i:23;s:2:\"DE\";i:24;s:2:\"GB\";i:25;s:2:\"GR\";i:26;s:2:\"HU\";i:27;s:2:\"IE\";i:28;s:2:\"IT\";i:29;s:2:\"LV\";i:30;s:2:\"LT\";i:31;s:2:\"LU\";i:32;s:2:\"MT\";i:33;s:2:\"NL\";i:34;s:2:\"NO\";i:35;s:2:\"PL\";i:36;s:2:\"PT\";i:37;s:2:\"RO\";i:38;s:2:\"SK\";i:39;s:2:\"SL\";i:40;s:2:\"SE\";i:41;s:2:\"AU\";i:42;s:2:\"NZ\";i:43;s:2:\"HK\";i:44;s:2:\"JP\";i:45;s:2:\"SG\";i:46;s:2:\"CN\";i:47;s:2:\"ID\";}s:19:\"category_additional\";a:49:{i:0;s:2:\"US\";i:1;s:2:\"CA\";i:2;s:2:\"MX\";i:3;s:2:\"BR\";i:4;s:2:\"AR\";i:5;s:2:\"CL\";i:6;s:2:\"CO\";i:7;s:2:\"EC\";i:8;s:2:\"PE\";i:9;s:2:\"UY\";i:10;s:2:\"VE\";i:11;s:2:\"AT\";i:12;s:2:\"BE\";i:13;s:2:\"BG\";i:14;s:2:\"HR\";i:15;s:2:\"CH\";i:16;s:2:\"CY\";i:17;s:2:\"CZ\";i:18;s:2:\"DK\";i:19;s:2:\"EE\";i:20;s:2:\"ES\";i:21;s:2:\"FI\";i:22;s:2:\"FR\";i:23;s:2:\"DE\";i:24;s:2:\"GB\";i:25;s:2:\"GR\";i:26;s:2:\"HU\";i:27;s:2:\"IE\";i:28;s:2:\"IT\";i:29;s:2:\"LV\";i:30;s:2:\"LT\";i:31;s:2:\"LU\";i:32;s:2:\"MT\";i:33;s:2:\"NL\";i:34;s:2:\"NO\";i:35;s:2:\"PL\";i:36;s:2:\"PT\";i:37;s:2:\"RO\";i:38;s:2:\"SK\";i:39;s:2:\"SL\";i:40;s:2:\"SE\";i:41;s:2:\"AU\";i:42;s:2:\"NZ\";i:43;s:2:\"HK\";i:44;s:2:\"JP\";i:45;s:2:\"SG\";i:46;s:2:\"CN\";i:47;s:2:\"ID\";i:48;s:2:\"IN\";}s:23:\"recommendation_priority\";i:5;}s:8:\"razorpay\";O:8:\"stdClass\":10:{s:2:\"id\";s:8:\"razorpay\";s:5:\"title\";s:8:\"Razorpay\";s:7:\"content\";s:133:\"The official Razorpay extension for WooCommerce allows you to accept credit cards, debit cards, netbanking, wallet, and UPI payments.\";s:5:\"image\";s:104:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/razorpay.svg\";s:11:\"image_72x72\";s:110:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/razorpay.png\";s:7:\"plugins\";a:1:{i:0;s:12:\"woo-razorpay\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IN\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"category_other\";a:1:{i:0;s:2:\"IN\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:6;}s:18:\"square_credit_card\";O:8:\"stdClass\":10:{s:2:\"id\";s:18:\"square_credit_card\";s:5:\"title\";s:6:\"Square\";s:7:\"content\";s:169:\"Securely accept credit and debit cards with one low rate, no surprise fees (custom rates available). Sell online and in store and track sales and inventory in one place.\";s:5:\"image\";s:85:\"https://woocommerce.com/wp-content/plugins/woocommerce/assets/images/square-black.png\";s:11:\"image_72x72\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/square.png\";s:7:\"plugins\";a:1:{i:0;s:18:\"woocommerce-square\";}s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}i:1;a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:8:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:14:\"selling_venues\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:12:\"brick-mortar\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:14:\"selling_venues\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:18:\"brick-mortar-other\";}}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:21:\"selling_online_answer\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:21:\"no_im_selling_offline\";s:7:\"default\";s:0:\"\";}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:21:\"selling_online_answer\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:34:\"im_selling_both_online_and_offline\";s:7:\"default\";s:0:\"\";}}}}}}}}}s:14:\"category_other\";a:8:{i:0;s:2:\"US\";i:1;s:2:\"CA\";i:2;s:2:\"IE\";i:3;s:2:\"ES\";i:4;s:2:\"FR\";i:5;s:2:\"GB\";i:6;s:2:\"AU\";i:7;s:2:\"JP\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:6;}s:6:\"stripe\";O:8:\"stdClass\":11:{s:2:\"id\";s:6:\"stripe\";s:5:\"title\";s:6:\"Stripe\";s:7:\"content\";s:112:\"Accept debit and credit cards in 135+ currencies, methods such as Alipay, and one-touch checkout with Apple Pay.\";s:5:\"image\";s:79:\"https://woocommerce.com/wp-content/plugins/woocommerce/assets/images/stripe.png\";s:11:\"image_72x72\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/stripe.png\";s:12:\"square_image\";s:102:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/stripe.svg\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-stripe\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:40:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MX\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BR\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BG\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CY\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CZ\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EE\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LV\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LT\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LU\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MT\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RO\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SK\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SL\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ID\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IN\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"category_other\";a:40:{i:0;s:2:\"US\";i:1;s:2:\"CA\";i:2;s:2:\"MX\";i:3;s:2:\"BR\";i:4;s:2:\"AT\";i:5;s:2:\"BE\";i:6;s:2:\"BG\";i:7;s:2:\"CH\";i:8;s:2:\"CY\";i:9;s:2:\"CZ\";i:10;s:2:\"DK\";i:11;s:2:\"EE\";i:12;s:2:\"ES\";i:13;s:2:\"FI\";i:14;s:2:\"FR\";i:15;s:2:\"DE\";i:16;s:2:\"GB\";i:17;s:2:\"GR\";i:18;s:2:\"HU\";i:19;s:2:\"IE\";i:20;s:2:\"IT\";i:21;s:2:\"LV\";i:22;s:2:\"LT\";i:23;s:2:\"LU\";i:24;s:2:\"MT\";i:25;s:2:\"NL\";i:26;s:2:\"NO\";i:27;s:2:\"PL\";i:28;s:2:\"PT\";i:29;s:2:\"RO\";i:30;s:2:\"SK\";i:31;s:2:\"SL\";i:32;s:2:\"SE\";i:33;s:2:\"AU\";i:34;s:2:\"NZ\";i:35;s:2:\"HK\";i:36;s:2:\"JP\";i:37;s:2:\"SG\";i:38;s:2:\"ID\";i:39;s:2:\"IN\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:3;}s:23:\"woo-mercado-pago-custom\";O:8:\"stdClass\":11:{s:2:\"id\";s:23:\"woo-mercado-pago-custom\";s:5:\"title\";s:12:\"Mercado Pago\";s:7:\"content\";s:198:\"Set up your payment methods and accept credit and debit cards, cash, bank transfers and money from your Mercado Pago account. Offer safe and secure payments with Latin America’s leading processor.\";s:5:\"image\";s:107:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/mercadopago.png\";s:11:\"image_72x72\";s:113:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/mercadopago.png\";s:7:\"plugins\";a:1:{i:0;s:23:\"woocommerce-mercadopago\";}s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:8:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AR\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CL\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CO\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EC\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PE\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"UY\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MX\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BR\";s:9:\"operation\";s:1:\"=\";}}}}s:16:\"is_local_partner\";b:1;s:14:\"category_other\";a:8:{i:0;s:2:\"AR\";i:1;s:2:\"CL\";i:2;s:2:\"CO\";i:3;s:2:\"EC\";i:4;s:2:\"PE\";i:5;s:2:\"UY\";i:6;s:2:\"MX\";i:7;s:2:\"BR\";}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:6;}s:20:\"woocommerce_payments\";O:8:\"stdClass\":10:{s:2:\"id\";s:20:\"woocommerce_payments\";s:5:\"title\";s:11:\"WooPayments\";s:7:\"content\";s:84:\"Manage transactions without leaving your WordPress Dashboard. Only with WooPayments.\";s:5:\"image\";s:101:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/wcpay.svg\";s:12:\"square_image\";s:107:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/woocommerce.svg\";s:11:\"image_72x72\";s:101:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/wcpay.svg\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}s:11:\"description\";s:225:\"With WooPayments, you can securely accept major cards, Apple Pay, and payments in over 100 currencies. Track cash flow and manage recurring revenue directly from your store’s dashboard - with no setup costs or monthly fees.\";s:10:\"is_visible\";a:4:{i:0;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:39:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PR\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CY\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EE\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LU\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LT\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LV\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MT\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SI\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SK\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BG\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CZ\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HR\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RO\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AE\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:10:\"5.10.0-dev\";s:8:\"operator\";s:1:\"<\";}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:17:\"woocommerce-admin\";}}}}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:17:\"woocommerce-admin\";s:7:\"version\";s:9:\"2.9.0-dev\";s:8:\"operator\";s:1:\"<\";}}}}s:23:\"recommendation_priority\";i:2;}s:47:\"woocommerce_payments:without-in-person-payments\";O:8:\"stdClass\":10:{s:2:\"id\";s:47:\"woocommerce_payments:without-in-person-payments\";s:5:\"title\";s:11:\"WooPayments\";s:7:\"content\";s:84:\"Manage transactions without leaving your WordPress Dashboard. Only with WooPayments.\";s:5:\"image\";s:101:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/wcpay.svg\";s:11:\"image_72x72\";s:101:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/wcpay.svg\";s:12:\"square_image\";s:107:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/woocommerce.svg\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}s:11:\"description\";s:225:\"With WooPayments, you can securely accept major cards, Apple Pay, and payments in over 100 currencies. Track cash flow and manage recurring revenue directly from your store’s dashboard - with no setup costs or monthly fees.\";s:10:\"is_visible\";a:3:{i:0;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:37:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PR\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CY\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EE\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LU\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LT\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LV\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MT\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SI\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SK\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BG\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CZ\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HR\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RO\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AE\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:17:\"woocommerce-admin\";s:7:\"version\";s:9:\"2.9.0-dev\";s:8:\"operator\";s:2:\">=\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:10:\"5.10.0-dev\";s:8:\"operator\";s:2:\">=\";}}}}s:23:\"recommendation_priority\";i:1;}s:44:\"woocommerce_payments:with-in-person-payments\";O:8:\"stdClass\":10:{s:2:\"id\";s:44:\"woocommerce_payments:with-in-person-payments\";s:5:\"title\";s:11:\"WooPayments\";s:7:\"content\";s:84:\"Manage transactions without leaving your WordPress Dashboard. Only with WooPayments.\";s:5:\"image\";s:101:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/wcpay.svg\";s:11:\"image_72x72\";s:101:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/wcpay.svg\";s:12:\"square_image\";s:107:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/woocommerce.svg\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}s:11:\"description\";s:212:\"With WooPayments, you can securely accept major cards, Apple Pay, and payments in over 100 currencies – with no setup costs or monthly fees – and you can now accept in-person payments with the Woo mobile app.\";s:10:\"is_visible\";a:3:{i:0;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:17:\"woocommerce-admin\";s:7:\"version\";s:9:\"2.9.0-dev\";s:8:\"operator\";s:2:\">=\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:10:\"5.10.0-dev\";s:8:\"operator\";s:2:\">=\";}}}}s:23:\"recommendation_priority\";i:0;}s:25:\"woocommerce_payments:bnpl\";O:8:\"stdClass\":9:{s:2:\"id\";s:25:\"woocommerce_payments:bnpl\";s:5:\"title\";s:38:\"Activate BNPL instantly on WooPayments\";s:7:\"content\";s:185:\"The world’s favorite buy now, pay later options and many more are right at your fingertips with WooPayments — all from one dashboard, without needing multiple extensions and logins.\";s:5:\"image\";s:106:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/wcpay-bnpl.svg\";s:11:\"image_72x72\";s:106:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/wcpay-bnpl.svg\";s:12:\"square_image\";s:107:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/woocommerce.svg\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}s:10:\"is_visible\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:18:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:7:\"version\";s:9:\"9.2.0-dev\";s:8:\"operator\";s:2:\">=\";}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}i:4;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:4:\"data\";}}i:1;O:8:\"stdClass\":1:{s:3:\"use\";s:10:\"array_keys\";}}s:11:\"option_name\";s:18:\"wcpay_account_data\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:10:\"account_id\";s:7:\"default\";a:0:{}}}s:23:\"recommendation_priority\";i:6;}s:8:\"zipmoney\";O:8:\"stdClass\":10:{s:2:\"id\";s:8:\"zipmoney\";s:5:\"title\";s:27:\"Zip Co - Buy Now, Pay Later\";s:7:\"content\";s:84:\"Give your customers the power to pay later, interest free and watch your sales grow.\";s:5:\"image\";s:104:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/zipmoney.png\";s:11:\"image_72x72\";s:110:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/payment-gateway-suggestions/images/72x72/zipmoney.png\";s:7:\"plugins\";a:1:{i:0;s:29:\"zipmoney-payments-woocommerce\";}s:10:\"is_visible\";b:0;s:14:\"category_other\";a:0:{}s:19:\"category_additional\";a:0:{}s:23:\"recommendation_priority\";i:6;}}}", "off");
INSERT INTO `wp_options` VALUES("2214", "_transient_timeout_woocommerce_admin_remote_free_extensions_specs", "1764912443", "off");
INSERT INTO `wp_options` VALUES("2215", "_transient_woocommerce_admin_remote_free_extensions_specs", "a:1:{s:5:\"en_US\";a:5:{s:10:\"obw/basics\";O:8:\"stdClass\":3:{s:3:\"key\";s:10:\"obw/basics\";s:5:\"title\";s:14:\"Get the basics\";s:7:\"plugins\";a:4:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:11:\"WooPayments\";s:11:\"description\";s:154:\"Accept credit cards and other popular payment methods with <a href=\"https://woocommerce.com/products/woocommerce-payments\" target=\"_blank\">WooPayments</a>\";s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";a:39:{i:0;s:2:\"US\";i:1;s:2:\"PR\";i:2;s:2:\"AU\";i:3;s:2:\"CA\";i:4;s:2:\"DE\";i:5;s:2:\"ES\";i:6;s:2:\"FR\";i:7;s:2:\"GB\";i:8;s:2:\"IE\";i:9;s:2:\"IT\";i:10;s:2:\"NZ\";i:11;s:2:\"AT\";i:12;s:2:\"BE\";i:13;s:2:\"NL\";i:14;s:2:\"PL\";i:15;s:2:\"PT\";i:16;s:2:\"CH\";i:17;s:2:\"HK\";i:18;s:2:\"SG\";i:19;s:2:\"CY\";i:20;s:2:\"DK\";i:21;s:2:\"EE\";i:22;s:2:\"FI\";i:23;s:2:\"GR\";i:24;s:2:\"LU\";i:25;s:2:\"LT\";i:26;s:2:\"LV\";i:27;s:2:\"NO\";i:28;s:2:\"MT\";i:29;s:2:\"SI\";i:30;s:2:\"SK\";i:31;s:2:\"BG\";i:32;s:2:\"CZ\";i:33;s:2:\"HR\";i:34;s:2:\"HU\";i:35;s:2:\"RO\";i:36;s:2:\"SE\";i:37;s:2:\"JP\";i:38;s:2:\"AE\";}s:9:\"operation\";s:2:\"in\";}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}}s:14:\"is_built_by_wc\";b:1;s:14:\"min_wp_version\";s:3:\"5.9\";s:3:\"key\";s:20:\"woocommerce-payments\";}i:1;O:8:\"stdClass\":5:{s:4:\"name\";s:20:\"WooCommerce Shipping\";s:11:\"description\";s:119:\"Print shipping labels with <a href=\"https://woocommerce.com/products/shipping\" target=\"_blank\">WooCommerce Shipping</a>\";s:10:\"is_visible\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";a:1:{i:0;s:2:\"US\";}s:9:\"operation\";s:2:\"in\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-shipping\";}}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:13:\"product_types\";}}i:1;O:8:\"stdClass\":1:{s:3:\"use\";s:5:\"count\";}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:5:\"value\";i:1;s:7:\"default\";a:0:{}s:9:\"operation\";s:2:\"!=\";}}i:1;a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:15:\"product_types.0\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:5:\"value\";s:9:\"downloads\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:2:\"!=\";}}}}}s:14:\"is_built_by_wc\";b:1;s:3:\"key\";s:20:\"woocommerce-shipping\";}i:2;O:8:\"stdClass\":5:{s:4:\"name\";s:15:\"WooCommerce Tax\";s:11:\"description\";s:111:\"Get automated sales tax with <a href=\"https://woocommerce.com/products/tax\" target=\"_blank\">WooCommerce Tax</a>\";s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";a:11:{i:0;s:2:\"US\";i:1;s:2:\"FR\";i:2;s:2:\"GB\";i:3;s:2:\"DE\";i:4;s:2:\"CA\";i:5;s:2:\"AU\";i:6;s:2:\"GR\";i:7;s:2:\"BE\";i:8;s:2:\"PT\";i:9;s:2:\"DK\";i:10;s:2:\"SE\";}s:9:\"operation\";s:2:\"in\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-services\";}}}}}s:14:\"is_built_by_wc\";b:1;s:3:\"key\";s:24:\"woocommerce-services:tax\";}i:3;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"Jetpack\";s:11:\"description\";s:110:\"Enhance speed and security with <a href=\"https://woocommerce.com/products/jetpack\" target=\"_blank\">Jetpack</a>\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:7:\"jetpack\";}}}}}s:14:\"is_built_by_wc\";b:0;s:14:\"min_wp_version\";s:3:\"6.0\";s:3:\"key\";s:7:\"jetpack\";}}}s:8:\"obw/grow\";O:8:\"stdClass\":3:{s:3:\"key\";s:8:\"obw/grow\";s:5:\"title\";s:15:\"Grow your store\";s:7:\"plugins\";a:4:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:8:\"MailPoet\";s:11:\"description\";s:115:\"Level up your email marketing with <a href=\"https://woocommerce.com/products/mailpoet\" target=\"_blank\">MailPoet</a>\";s:10:\"manage_url\";s:35:\"admin.php?page=mailpoet-newsletters\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:37:\"woocommerce_remote_variant_assignment\";s:5:\"value\";a:2:{i:0;i:1;i:1;i:84;}s:7:\"default\";b:0;s:9:\"operation\";s:5:\"range\";}}s:14:\"is_built_by_wc\";b:1;s:3:\"key\";s:8:\"mailpoet\";}i:1;O:8:\"stdClass\":8:{s:4:\"name\";s:22:\"Google for WooCommerce\";s:11:\"description\";s:126:\"Drive sales with <a href=\"https://woocommerce.com/products/google-listings-and-ads\" target=\"_blank\">Google for WooCommerce</a>\";s:9:\"image_url\";s:94:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/google.svg\";s:10:\"manage_url\";s:46:\"admin.php?page=wc-admin&path=%2Fgoogle%2Fstart\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:23:\"google-listings-and-ads\";}}}}}s:14:\"is_built_by_wc\";b:1;s:15:\"min_php_version\";s:3:\"7.4\";s:3:\"key\";s:23:\"google-listings-and-ads\";}i:2;O:8:\"stdClass\":8:{s:4:\"name\";s:25:\"Pinterest for WooCommerce\";s:11:\"description\";s:76:\"Get your products in front of Pinners searching for ideas and things to buy.\";s:9:\"image_url\";s:97:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/pinterest.png\";s:10:\"manage_url\";s:51:\"admin.php?page=wc-admin&path=%2Fpinterest%2Flanding\";s:10:\"is_visible\";b:1;s:14:\"is_built_by_wc\";b:1;s:15:\"min_php_version\";s:3:\"7.3\";s:3:\"key\";s:25:\"pinterest-for-woocommerce\";}i:3;O:8:\"stdClass\":7:{s:4:\"name\";s:24:\"Facebook for WooCommerce\";s:11:\"description\";s:141:\"List products and create ads on Facebook and Instagram with <a href=\"https://woocommerce.com/products/facebook/\">Facebook for WooCommerce</a>\";s:9:\"image_url\";s:96:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/facebook.png\";s:10:\"manage_url\";s:26:\"admin.php?page=wc-facebook\";s:10:\"is_visible\";b:0;s:14:\"is_built_by_wc\";b:0;s:3:\"key\";s:24:\"facebook-for-woocommerce\";}}}s:15:\"task-list/reach\";O:8:\"stdClass\":3:{s:3:\"key\";s:15:\"task-list/reach\";s:5:\"title\";s:22:\"Reach out to customers\";s:7:\"plugins\";a:3:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:8:\"MailPoet\";s:11:\"description\";s:111:\"Create and send purchase follow-up emails, newsletters, and promotional campaigns straight from your dashboard.\";s:9:\"image_url\";s:96:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/mailpoet.svg\";s:10:\"manage_url\";s:35:\"admin.php?page=mailpoet-newsletters\";s:14:\"is_built_by_wc\";b:1;s:3:\"key\";s:12:\"mailpoet:alt\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"Klaviyo\";s:11:\"description\";s:138:\"Grow and retain customers with intelligent, impactful email and SMS marketing automation and a consolidated view of customer interactions.\";s:9:\"image_url\";s:95:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/klaviyo.png\";s:10:\"manage_url\";s:31:\"admin.php?page=klaviyo_settings\";s:14:\"is_built_by_wc\";b:0;s:3:\"key\";s:11:\"klaviyo:alt\";}i:2;O:8:\"stdClass\":6:{s:4:\"name\";s:9:\"Mailchimp\";s:11:\"description\";s:78:\"Send targeted campaigns, recover abandoned carts and much more with Mailchimp.\";s:9:\"image_url\";s:97:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/mailchimp.svg\";s:10:\"manage_url\";s:36:\"admin.php?page=mailchimp-woocommerce\";s:14:\"is_built_by_wc\";b:0;s:3:\"key\";s:29:\"mailchimp-for-woocommerce:alt\";}}}s:14:\"task-list/grow\";O:8:\"stdClass\":3:{s:3:\"key\";s:14:\"task-list/grow\";s:5:\"title\";s:15:\"Grow your store\";s:7:\"plugins\";a:5:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:22:\"Google for WooCommerce\";s:11:\"description\";s:134:\"Reach more shoppers and drive sales for your store. Integrate with Google to list your products for free and launch paid ad campaigns.\";s:9:\"image_url\";s:94:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/google.svg\";s:10:\"manage_url\";s:46:\"admin.php?page=wc-admin&path=%2Fgoogle%2Fstart\";s:14:\"is_built_by_wc\";b:1;s:3:\"key\";s:27:\"google-listings-and-ads:alt\";}i:1;O:8:\"stdClass\":7:{s:4:\"name\";s:22:\"TikTok for WooCommerce\";s:9:\"image_url\";s:94:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/tiktok.svg\";s:11:\"description\";s:118:\"Grow your online sales by promoting your products on TikTok to over one billion monthly active users around the world.\";s:10:\"manage_url\";s:21:\"admin.php?page=tiktok\";s:10:\"is_visible\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";a:40:{i:0;s:2:\"US\";i:1;s:2:\"CA\";i:2;s:2:\"MX\";i:3;s:2:\"AT\";i:4;s:2:\"BE\";i:5;s:2:\"CZ\";i:6;s:2:\"DK\";i:7;s:2:\"FI\";i:8;s:2:\"FR\";i:9;s:2:\"DE\";i:10;s:2:\"GR\";i:11;s:2:\"HU\";i:12;s:2:\"IE\";i:13;s:2:\"IT\";i:14;s:2:\"NL\";i:15;s:2:\"PL\";i:16;s:2:\"PT\";i:17;s:2:\"RO\";i:18;s:2:\"ES\";i:19;s:2:\"SE\";i:20;s:2:\"GB\";i:21;s:2:\"CH\";i:22;s:2:\"NO\";i:23;s:2:\"AU\";i:24;s:2:\"NZ\";i:25;s:2:\"SG\";i:26;s:2:\"MY\";i:27;s:2:\"PH\";i:28;s:2:\"ID\";i:29;s:2:\"VN\";i:30;s:2:\"TH\";i:31;s:2:\"KR\";i:32;s:2:\"IL\";i:33;s:2:\"AE\";i:34;s:2:\"RU\";i:35;s:2:\"UA\";i:36;s:2:\"TR\";i:37;s:2:\"SA\";i:38;s:2:\"BR\";i:39;s:2:\"JP\";}s:9:\"operation\";s:2:\"in\";}}s:14:\"is_built_by_wc\";b:0;s:3:\"key\";s:19:\"tiktok-for-business\";}i:2;O:8:\"stdClass\":6:{s:4:\"name\";s:25:\"Pinterest for WooCommerce\";s:11:\"description\";s:159:\"Get your products in front of Pinterest users searching for ideas and things to buy. Get started with Pinterest and make your entire product catalog browsable.\";s:9:\"image_url\";s:97:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/pinterest.png\";s:10:\"manage_url\";s:51:\"admin.php?page=wc-admin&path=%2Fpinterest%2Flanding\";s:14:\"is_built_by_wc\";b:1;s:3:\"key\";s:29:\"pinterest-for-woocommerce:alt\";}i:3;O:8:\"stdClass\":8:{s:4:\"name\";s:26:\"Meta Ads & Pixel by Kliken\";s:11:\"description\";s:150:\"Automate Facebook & Instagram marketing with Kliken. Launch ads and schedule a month of posts in 5 minutes—first 5 free! Plans start at just $20/mo.\";s:9:\"image_url\";s:94:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/obw-free-extensions/images/kliken.s